	AREA wram_code0, CODE, READWRITE

	INCLUDE equates.h
	INCLUDE z80mac.h
	INCLUDE io.h
	INCLUDE gfx.h

	IMPORT |wram_globals0$$Base|
	IMPORT ui	;ui.c
	IMPORT quickload	;sram.c
	IMPORT quicksave	;sram.c

	EXPORT CPU_reset
	EXPORT run
	EXPORT op_table
	EXPORT default_scanlinehook
	EXPORT cpustate
	EXPORT rommap
	EXPORT frametotal
	EXPORT sleeptime
	EXPORT dontstop
	EXPORT novblankwait
	EXPORT gbadetect
	EXPORT sprcollision
	EXPORT ntsc_pal_reset

CYCLE_PSL EQU 228*CYCLE
;----------------------------------------------------------------------------
_GO;	Continue running
;----------------------------------------------------------------------------
	fetch 0
;----------------------------------------------------------------------------
_40;	LD B,B
_49;	LD C,C
_52;	LD D,D
_5B;	LD E,E
_64;	LD H,H
_6D;	LD L,L
_7F;	LD A,A
;----------------------------------------------------------------------------
_00;	NOP
;----------------------------------------------------------------------------
	fetch 4
;----------------------------------------------------------------------------
_01;	LD BC,#nnnn
;----------------------------------------------------------------------------
	opLDIM16
	mov z80bc,r0,lsl#16
	fetch 10
;----------------------------------------------------------------------------
_02;	LD (BC),A		write A to (BC)
;----------------------------------------------------------------------------
	mov r0,z80a,lsr#24
	writemem8BC
	fetch 7
;----------------------------------------------------------------------------
_03;	INC BC
;----------------------------------------------------------------------------
	opINC16 z80bc
	fetch 6
;----------------------------------------------------------------------------
_04;	INC B
;----------------------------------------------------------------------------
	opINC8H z80bc
	fetch 4
;----------------------------------------------------------------------------
_05;	DEC B
;----------------------------------------------------------------------------
	opDEC8H z80bc
	fetch 4
;----------------------------------------------------------------------------
_06;	LD B,#nn
;----------------------------------------------------------------------------
	opLDIM8H z80bc
	fetch 7
;----------------------------------------------------------------------------
_07;	RLCA			rotate accu left
;----------------------------------------------------------------------------
	bic z80f,z80f,#PSR_n+PSR_H+PSR_C
	movs z80a,z80a,lsl#1
	orrcs z80a,z80a,#0x01000000
	orrcs z80f,z80f,#PSR_C
	fetch 4
;----------------------------------------------------------------------------
_08;	EX AF,AF'		Exchange AF & AF'
;----------------------------------------------------------------------------
	adr r0,cpuregs2
	swp z80f,z80f,[r0]
	add r0,r0,#4
	swp z80a,z80a,[r0]
	fetch 4
;----------------------------------------------------------------------------
_09;	ADD HL,BC
;----------------------------------------------------------------------------
	opADD16 z80hl,z80bc
	fetch 11
;----------------------------------------------------------------------------
_0A;	LD A,(BC)
;----------------------------------------------------------------------------
	readmem8BC
	mov z80a,r0,lsl#24
	fetch 7
;----------------------------------------------------------------------------
_0B;	DEC BC
;----------------------------------------------------------------------------
	opDEC16 z80bc
	fetch 6
;----------------------------------------------------------------------------
_0C;	INC C
;----------------------------------------------------------------------------
	opINC8L z80bc
	fetch 4
;----------------------------------------------------------------------------
_0D;	DEC C
;----------------------------------------------------------------------------
	opDEC8L z80bc
	fetch 4
;----------------------------------------------------------------------------
_0E;	LD C,#nn
;----------------------------------------------------------------------------
	opLDIM8L z80bc
	fetch 7
;----------------------------------------------------------------------------
_0F;	RRCA			rotate accu right
;----------------------------------------------------------------------------
	bic z80f,z80f,#PSR_n+PSR_H+PSR_C
	movs z80a,z80a,lsr#25
	orrcs z80f,z80f,#PSR_C
	orrcs z80a,z80a,#0x00000080
	mov z80a,z80a,lsl#24
	fetch 4
;----------------------------------------------------------------------------
_10;	DJNZ,*			decrease B jump if not zero
;----------------------------------------------------------------------------
	sub z80bc,z80bc,#0x01000000
	tst z80bc,#0xff000000
	ldrsb r0,[z80pc],#1
	addne z80pc,z80pc,r0
	subne cycles,cycles,#5*CYCLE
	fetch 8
;----------------------------------------------------------------------------
_11;	LD DE,#nnnn
;----------------------------------------------------------------------------
	opLDIM16
	mov z80de,r0,lsl#16
	fetch 10
;----------------------------------------------------------------------------
_12;	LD (DE),A		write A to (DE)
;----------------------------------------------------------------------------
	mov r0,z80a,lsr#24
	writemem8DE
	fetch 7
;----------------------------------------------------------------------------
_13;	INC DE
;----------------------------------------------------------------------------
	opINC16 z80de
	fetch 6
;----------------------------------------------------------------------------
_14;	INC D
;----------------------------------------------------------------------------
	opINC8H z80de
	fetch 4
;----------------------------------------------------------------------------
_15;	DEC D
;----------------------------------------------------------------------------
	opDEC8H z80de
	fetch 4
;----------------------------------------------------------------------------
_16;	LD D,#nn
;----------------------------------------------------------------------------
	opLDIM8H z80de
	fetch 7
;----------------------------------------------------------------------------
_17;	RLA				rotate accu left through C
;----------------------------------------------------------------------------
	tst z80f,#PSR_C
	bic z80f,z80f,#PSR_n+PSR_H+PSR_C
	orrne z80a,z80a,#0x00800000
	movs z80a,z80a,lsl#1
	orrcs z80f,z80f,#PSR_C
	fetch 4
;----------------------------------------------------------------------------
_18;	JR *			relative jump
;----------------------------------------------------------------------------
	ldrsb r0,[z80pc],#1
	add z80pc,z80pc,r0
	fetch 12
;----------------------------------------------------------------------------
_19;	ADD HL,DE
;----------------------------------------------------------------------------
	opADD16 z80hl,z80de
	fetch 11
;----------------------------------------------------------------------------
_1A;	LD A,(DE)
;----------------------------------------------------------------------------
	readmem8DE
	mov z80a,r0,lsl#24
	fetch 7
;----------------------------------------------------------------------------
_1B;	DEC DE
;----------------------------------------------------------------------------
	opDEC16 z80de
	fetch 6
;----------------------------------------------------------------------------
_1C;	INC E
;----------------------------------------------------------------------------
	opINC8L z80de
	fetch 4
;----------------------------------------------------------------------------
_1D;	DEC E
;----------------------------------------------------------------------------
	opDEC8L z80de
	fetch 4
;----------------------------------------------------------------------------
_1E;	LD E,#nn
;----------------------------------------------------------------------------
	opLDIM8L z80de
	fetch 7
;----------------------------------------------------------------------------
_1F;	RRA				rotate accu right through C
;----------------------------------------------------------------------------
	orr z80a,z80a,z80f,lsr#1		;get C
	bic z80f,z80f,#PSR_n+PSR_H+PSR_C
	movs z80a,z80a,ror#25
	orrcs z80f,z80f,#PSR_C
	mov z80a,z80a,lsl#24
	fetch 4
;----------------------------------------------------------------------------
_20;	JR NZ,*			jump if not zero
;----------------------------------------------------------------------------
	tst z80f,#PSR_Z
	ldrsb r0,[z80pc],#1
	addeq z80pc,z80pc,r0
	subeq cycles,cycles,#5*CYCLE
	fetch 7
;----------------------------------------------------------------------------
;_20;	JR NZ,*			jump if not zero
;----------------------------------------------------------------------------
;	tst z80f,#PSR_Z
;	ldrsb r0,[z80pc],#1
;	bne _dum20
;	add z80pc,z80pc,r0
;	sub cycles,cycles,#5*CYCLE
;	cmp r0,#-6							;AfterBurner, Out Run & PS.
;	andeq cycles,cycles,#CYC_MASK
;_dum20
;	fetch 7
;----------------------------------------------------------------------------
_21;	LD HL,#nnnn
;----------------------------------------------------------------------------
	opLDIM16
	mov z80hl,r0,lsl#16
	fetch 10
;----------------------------------------------------------------------------
_ED63;	LD (NN),HL		write HL to (NN)
;----------------------------------------------------------------------------
	eatcycles 4
;----------------------------------------------------------------------------
_22;	LD (NN),HL		write HL to (NN)
;----------------------------------------------------------------------------
	ldrb r0,[z80pc],#1
	ldrb r1,[z80pc],#1
	orr addy,r0,r1,lsl#8
	writemem16 z80hl
	fetch 16
;----------------------------------------------------------------------------
_23;	INC HL
;----------------------------------------------------------------------------
	opINC16 z80hl
	fetch 6
;----------------------------------------------------------------------------
_24;	INC H
;----------------------------------------------------------------------------
	opINC8H z80hl
	fetch 4
;----------------------------------------------------------------------------
_25;	DEC H
;----------------------------------------------------------------------------
	opDEC8H z80hl
	fetch 4
;----------------------------------------------------------------------------
_26;	LD H,#nn
;----------------------------------------------------------------------------
	opLDIM8H z80hl
	fetch 7
;----------------------------------------------------------------------------
_27;	DAA				decimal adjust accumulator
;----------------------------------------------------------------------------
	mov r0,#0

	and r1,z80a,#0x0F000000
	cmp r1,#0x0A000000
	orrpl r0,r0,#0x06000000
	cmppl z80a,#0x90000000
	cmpmi z80a,#0xA0000000
	orrhs z80f,z80f,#PSR_C			;C

	tst z80f,#PSR_H					;half carry.
	orrne r0,r0,#0x06000000

	tst z80f,#PSR_C					;carry.
	orrne r0,r0,#0x60000000

	adr r2,pzst
	tst z80f,#PSR_n					;check if last instruction was add or sub.
	bne doSUBconv

doADDconv
	and z80f,z80f,#PSR_C+PSR_n		;keep C & n
	add z80a,z80a,r0
	ldrb r0,[r2,z80a,lsr#24]			;get PZS
	orr z80f,z80f,r0
	cmp r1,#0x0A000000
	orrpl z80f,z80f,#PSR_H
	fetch 4

doSUBconv
	and z80f,z80f,#PSR_C+PSR_n+PSR_H	;keep C & n & H
	sub z80a,z80a,r0
	ldrb r0,[r2,z80a,lsr#24]			;get PZS
	orr z80f,z80f,r0
	cmp r1,#0x06000000
	bicpl z80f,z80f,#PSR_H
	fetch 4
;----------------------------------------------------------------------------
_28;	JR Z,*			jump if zero
;----------------------------------------------------------------------------
	tst z80f,#PSR_Z
	ldrsb r0,[z80pc],#1
	addne z80pc,z80pc,r0
	subne cycles,cycles,#5*CYCLE
	fetch 7
;----------------------------------------------------------------------------
;_28;	JR Z,*			jump if zero
;----------------------------------------------------------------------------
;	tst z80f,#PSR_Z
;	ldrsb r0,[z80pc],#1
;	beq _dum
;	add z80pc,z80pc,r0
;	sub cycles,cycles,#5*CYCLE
;	cmp r0,#-6							;Sonic 1
;	andeq cycles,cycles,#CYC_MASK
;_dum
;	fetch 7
;----------------------------------------------------------------------------
_29;	ADD HL,HL
;----------------------------------------------------------------------------
	opADD16_2 z80hl
	fetch 11
;----------------------------------------------------------------------------
_ED6B;	LD HL,(NN)		load HL from (NN)
;----------------------------------------------------------------------------
	eatcycles 4
;----------------------------------------------------------------------------
_2A;	LD HL,(NN)		load HL from (NN)
;----------------------------------------------------------------------------
	ldrb r0,[z80pc],#1
	ldrb r1,[z80pc],#1
	orr addy,r0,r1,lsl#8
	readmem16 z80hl
	fetch 16
;----------------------------------------------------------------------------
_2B;	DEC HL
;----------------------------------------------------------------------------
	opDEC16 z80hl
	fetch 6
;----------------------------------------------------------------------------
_2C;	INC L
;----------------------------------------------------------------------------
	opINC8L z80hl
	fetch 4
;----------------------------------------------------------------------------
_2D;	DEC L
;----------------------------------------------------------------------------
	opDEC8L z80hl
	fetch 4
;----------------------------------------------------------------------------
_2E;	LD L,#nn
;----------------------------------------------------------------------------
	opLDIM8L z80hl
	fetch 7
;----------------------------------------------------------------------------
_2F;	CPL				complement A
;----------------------------------------------------------------------------
	eor z80a,z80a,#0xFF000000
	orr z80f,z80f,#PSR_n|PSR_H		;set n & h
	fetch 4
;----------------------------------------------------------------------------
_30;	JR NC,*			jump if no carry
;----------------------------------------------------------------------------
	tst z80f,#PSR_C
	ldrsb r0,[z80pc],#1
	addeq z80pc,z80pc,r0
	subeq cycles,cycles,#5*CYCLE
	fetch 7
;----------------------------------------------------------------------------
;_30;	JR NC,*			jump if no carry
;----------------------------------------------------------------------------
;	tst z80f,#PSR_C
;	ldrsb r0,[z80pc],#1
;	bne _dum
;	add z80pc,z80pc,r0
;	sub cycles,cycles,#5*CYCLE
;	cmp r0,#-7
;	andeq cycles,cycles,#CYC_MASK
;_dum
;	fetch 7
;----------------------------------------------------------------------------
_31;	LD SP,#nnnn
;----------------------------------------------------------------------------
	opLDIM16
	mov z80sp,r0,lsl#16
	fetch 10
;----------------------------------------------------------------------------
_32;	LD (NN),A		write A to (NN)
;----------------------------------------------------------------------------
	ldrb addy,[z80pc],#1
	ldrb r0,[z80pc],#1
	orr addy,addy,r0,lsl#8
	mov r0,z80a,lsr#24
	writemem8
	fetch 13
;----------------------------------------------------------------------------
_33;	INC SP
;----------------------------------------------------------------------------
	opINC16 z80sp
	fetch 6
;----------------------------------------------------------------------------
_34;	INC (HL)
;----------------------------------------------------------------------------
	mov addy,z80hl,lsr#16
;----------------------------------------------------------------------------
_DD34_;	INC (IX+d)
;----------------------------------------------------------------------------
	readmem8
	opINC8b
	writemem8
	fetch 11
;----------------------------------------------------------------------------
_35;	DEC (HL)
;----------------------------------------------------------------------------
	mov addy,z80hl,lsr#16
;----------------------------------------------------------------------------
_DD35_;	DEC (IX+d)
;----------------------------------------------------------------------------
	readmem8
	opDEC8b
	writemem8
	fetch 11
;----------------------------------------------------------------------------
_36;	LD (HL),#nn
;----------------------------------------------------------------------------
	mov addy,z80hl,lsr#16
;----------------------------------------------------------------------------
_DD36_;	LD (IX+d),#nn
;----------------------------------------------------------------------------
	ldrb r0,[z80pc],#1
	writemem8
	fetch 10
;----------------------------------------------------------------------------
_37;	SCF				set carry flag
;----------------------------------------------------------------------------
	bic z80f,z80f,#PSR_H|PSR_n		;clear H & n
	orr z80f,z80f,#PSR_C			;set carry.
	fetch 4
;----------------------------------------------------------------------------
_38;	JR C,*			jump if carry
;----------------------------------------------------------------------------
	tst z80f,#PSR_C
	ldrsb r0,[z80pc],#1
	addne z80pc,z80pc,r0
	subne cycles,cycles,#5*CYCLE
	fetch 7
;----------------------------------------------------------------------------
_39;	ADD HL,SP
;----------------------------------------------------------------------------
	opADD16 z80hl,z80sp
	fetch 11
;----------------------------------------------------------------------------
_3A;	LD A,(NN)		load A from (NN)
;----------------------------------------------------------------------------
	ldrb addy,[z80pc],#1
	ldrb r0,[z80pc],#1
	orr addy,addy,r0,lsl#8
	readmem8
	mov z80a,r0,lsl#24
	fetch 13
;----------------------------------------------------------------------------
_3B;	DEC SP
;----------------------------------------------------------------------------
	opDEC16 z80sp
	fetch 6
;----------------------------------------------------------------------------
_3C;	INC A
;----------------------------------------------------------------------------
	opINC8 z80a
	fetch 4
;----------------------------------------------------------------------------
_3D;	DEC A
;----------------------------------------------------------------------------
	opDEC8 z80a
	fetch 4
;----------------------------------------------------------------------------
_3E;	LD A,#nn
;----------------------------------------------------------------------------
	ldrb r0,[z80pc],#1
	mov z80a,r0,lsl#24
	fetch 7
;----------------------------------------------------------------------------
_3F;	CCF				complement carry flag
;----------------------------------------------------------------------------
	bic z80f,z80f,#PSR_n|PSR_H	;clear n & H
	tst z80f,#PSR_C
	orrne z80f,z80f,#PSR_H		;old carry in H
	eor z80f,z80f,#PSR_C			;complement carry.
	fetch 4
;----------------------------------------------------------------------------
;_40;	LD B,B
;----------------------------------------------------------------------------
;	fetch 4
;----------------------------------------------------------------------------
_41;	LD B,C
;----------------------------------------------------------------------------
	and z80bc,z80bc,#0x00FF0000
	orr z80bc,z80bc,z80bc,lsl#8
	fetch 4
;----------------------------------------------------------------------------
_42;	LD B,D
;----------------------------------------------------------------------------
	and z80bc,z80bc,#0x00FF0000
	and r0,z80de,#0xFF000000
	orr z80bc,z80bc,r0
	fetch 4
;----------------------------------------------------------------------------
_43;	LD B,E
;----------------------------------------------------------------------------
	and z80bc,z80bc,#0x00FF0000
	orr z80bc,z80bc,z80de,lsl#8
	fetch 4
;----------------------------------------------------------------------------
_44;	LD B,H
;----------------------------------------------------------------------------
	and z80bc,z80bc,#0x00FF0000
	and r0,z80hl,#0xFF000000
	orr z80bc,z80bc,r0
	fetch 4
;----------------------------------------------------------------------------
_45;	LD B,L
;----------------------------------------------------------------------------
	and z80bc,z80bc,#0x00FF0000
	orr z80bc,z80bc,z80hl,lsl#8
	fetch 4
;----------------------------------------------------------------------------
_46;	LD B,(HL)
;----------------------------------------------------------------------------
	mov addy,z80hl,lsr#16
;----------------------------------------------------------------------------
_DD46_;	LD B,(IX+d)
;----------------------------------------------------------------------------
	readmem8
	and z80bc,z80bc,#0x00FF0000
	orr z80bc,z80bc,r0,lsl#24
	fetch 7
;----------------------------------------------------------------------------
_47;	LD B,A
;----------------------------------------------------------------------------
	and z80bc,z80bc,#0x00FF0000
	orr z80bc,z80bc,z80a
	fetch 4
;----------------------------------------------------------------------------
_48;	LD C,B
;----------------------------------------------------------------------------
	and z80bc,z80bc,#0xFF000000
	orr z80bc,z80bc,z80bc,lsr#8
	fetch 4
;----------------------------------------------------------------------------
;_49;	LD C,C
;----------------------------------------------------------------------------
;	fetch 4
;----------------------------------------------------------------------------
_4A;	LD C,D
;----------------------------------------------------------------------------
	and z80bc,z80bc,#0xFF000000
	and r0,z80de,#0xFF000000
	orr z80bc,z80bc,r0,lsr#8
	fetch 4
;----------------------------------------------------------------------------
_4B;	LD C,E
;----------------------------------------------------------------------------
	and z80bc,z80bc,#0xFF000000
	and r0,z80de,#0x00FF0000
	orr z80bc,z80bc,r0
	fetch 4
;----------------------------------------------------------------------------
_4C;	LD C,H
;----------------------------------------------------------------------------
	and z80bc,z80bc,#0xFF000000
	and r0,z80hl,#0xFF000000
	orr z80bc,z80bc,r0,lsr#8
	fetch 4
;----------------------------------------------------------------------------
_4D;	LD C,L
;----------------------------------------------------------------------------
	and z80bc,z80bc,#0xFF000000
	and r0,z80hl,#0x00FF0000
	orr z80bc,z80bc,r0
	fetch 4
;----------------------------------------------------------------------------
_4E;	LD C,(HL)
;----------------------------------------------------------------------------
	mov addy,z80hl,lsr#16
;----------------------------------------------------------------------------
_DD4E_;	LD C,(IX+d)
;----------------------------------------------------------------------------
	readmem8
	and z80bc,z80bc,#0xFF000000
	orr z80bc,z80bc,r0,lsl#16
	fetch 7
;----------------------------------------------------------------------------
_4F;	LD C,A
;----------------------------------------------------------------------------
	and z80bc,z80bc,#0xFF000000
	orr z80bc,z80bc,z80a,lsr#8
	fetch 4
;----------------------------------------------------------------------------
_50;	LD D,B
;----------------------------------------------------------------------------
	and z80de,z80de,#0x00FF0000
	and r0,z80bc,#0xFF000000
	orr z80de,z80de,r0
	fetch 4
;----------------------------------------------------------------------------
_51;	LD D,C
;----------------------------------------------------------------------------
	and z80de,z80de,#0x00FF0000
	orr z80de,z80de,z80bc,lsl#8
	fetch 4
;----------------------------------------------------------------------------
;_52;	LD D,D
;----------------------------------------------------------------------------
;	fetch 4
;----------------------------------------------------------------------------
_53;	LD D,E
;----------------------------------------------------------------------------
	and z80de,z80de,#0x00FF0000
	orr z80de,z80de,z80de,lsl#8
	fetch 4
;----------------------------------------------------------------------------
_54;	LD D,H
;----------------------------------------------------------------------------
	and z80de,z80de,#0x00FF0000
	and r0,z80hl,#0xFF000000
	orr z80de,z80de,r0
	fetch 4
;----------------------------------------------------------------------------
_55;	LD D,L
;----------------------------------------------------------------------------
	and z80de,z80de,#0x00FF0000
	orr z80de,z80de,z80hl,lsl#8
	fetch 4
;----------------------------------------------------------------------------
_56;	LD D,(HL)
;----------------------------------------------------------------------------
	mov addy,z80hl,lsr#16
;----------------------------------------------------------------------------
_DD56_;	LD D,(IX+d)
;----------------------------------------------------------------------------
	readmem8
	and z80de,z80de,#0x00FF0000
	orr z80de,z80de,r0,lsl#24
	fetch 7
;----------------------------------------------------------------------------
_57;	LD D,A
;----------------------------------------------------------------------------
	and z80de,z80de,#0x00FF0000
	orr z80de,z80de,z80a
	fetch 4
;----------------------------------------------------------------------------
_58;	LD E,B
;----------------------------------------------------------------------------
	and z80de,z80de,#0xFF000000
	and r0,z80bc,#0xFF000000
	orr z80de,z80de,r0,lsr#8
	fetch 4
;----------------------------------------------------------------------------
_59;	LD E,C
;----------------------------------------------------------------------------
	and z80de,z80de,#0xFF000000
	and r0,z80bc,#0x00FF0000
	orr z80de,z80de,r0
	fetch 4
;----------------------------------------------------------------------------
_5A;	LD E,D
;----------------------------------------------------------------------------
	and z80de,z80de,#0xFF000000
	orr z80de,z80de,z80de,lsr#8
	fetch 4
;----------------------------------------------------------------------------
;_5B;	LD E,E
;----------------------------------------------------------------------------
;	fetch 4
;----------------------------------------------------------------------------
_5C;	LD E,H
;----------------------------------------------------------------------------
	and z80de,z80de,#0xFF000000
	and r0,z80hl,#0xFF000000
	orr z80de,z80de,r0,lsr#8
	fetch 4
;----------------------------------------------------------------------------
_5D;	LD E,L
;----------------------------------------------------------------------------
	and z80de,z80de,#0xFF000000
	and r0,z80hl,#0x00FF0000
	orr z80de,z80de,r0
	fetch 4
;----------------------------------------------------------------------------
_5E;	LD E,(HL)
;----------------------------------------------------------------------------
	mov addy,z80hl,lsr#16
;----------------------------------------------------------------------------
_DD5E_;	LD E,(IX+d)
;----------------------------------------------------------------------------
	readmem8
	and z80de,z80de,#0xFF000000
	orr z80de,z80de,r0,lsl#16
	fetch 7
;----------------------------------------------------------------------------
_5F;	LD E,A
;----------------------------------------------------------------------------
	and z80de,z80de,#0xFF000000
	orr z80de,z80de,z80a,lsr#8
	fetch 4
;----------------------------------------------------------------------------
_60;	LD H,B
;----------------------------------------------------------------------------
	and z80hl,z80hl,#0x00FF0000
	and r0,z80bc,#0xFF000000
	orr z80hl,z80hl,r0
	fetch 4
;----------------------------------------------------------------------------
_61;	LD H,C
;----------------------------------------------------------------------------
	and z80hl,z80hl,#0x00FF0000
	orr z80hl,z80hl,z80bc,lsl#8
	fetch 4
;----------------------------------------------------------------------------
_62;	LD H,D
;----------------------------------------------------------------------------
	and z80hl,z80hl,#0x00FF0000
	and r0,z80de,#0xFF000000
	orr z80hl,z80hl,r0
	fetch 4
;----------------------------------------------------------------------------
_63;	LD H,E
;----------------------------------------------------------------------------
	and z80hl,z80hl,#0x00FF0000
	orr z80hl,z80hl,z80de,lsl#8
	fetch 4
;----------------------------------------------------------------------------
;_64;	LD H,H
;----------------------------------------------------------------------------
;	fetch 4
;----------------------------------------------------------------------------
_65;	LD H,L
;----------------------------------------------------------------------------
	and z80hl,z80hl,#0x00FF0000
	orr z80hl,z80hl,z80hl,lsl#8
	fetch 4
;----------------------------------------------------------------------------
_66;	LD H,(HL)
;----------------------------------------------------------------------------
	mov addy,z80hl,lsr#16
;----------------------------------------------------------------------------
_DD66_;	LD H,(IX+d)
;----------------------------------------------------------------------------
	readmem8
	and z80hl,z80hl,#0x00FF0000
	orr z80hl,z80hl,r0,lsl#24
	fetch 7
;----------------------------------------------------------------------------
_67;	LD H,A
;----------------------------------------------------------------------------
	and z80hl,z80hl,#0x00FF0000
	orr z80hl,z80hl,z80a
	fetch 4
;----------------------------------------------------------------------------
_68;	LD L,B
;----------------------------------------------------------------------------
	and z80hl,z80hl,#0xFF000000
	and r0,z80bc,#0xFF000000
	orr z80hl,z80hl,r0,lsr#8
	fetch 4
;----------------------------------------------------------------------------
_69;	LD L,C
;----------------------------------------------------------------------------
	and z80hl,z80hl,#0xFF000000
	and r0,z80bc,#0x00FF0000
	orr z80hl,z80hl,r0
	fetch 4
;----------------------------------------------------------------------------
_6A;	LD L,D
;----------------------------------------------------------------------------
	and z80hl,z80hl,#0xFF000000
	and r0,z80de,#0xFF000000
	orr z80hl,z80hl,r0,lsr#8
	fetch 4
;----------------------------------------------------------------------------
_6B;	LD L,E
;----------------------------------------------------------------------------
	and z80hl,z80hl,#0xFF000000
	and r0,z80de,#0x00FF0000
	orr z80hl,z80hl,r0
	fetch 4
;----------------------------------------------------------------------------
_6C;	LD L,H
;----------------------------------------------------------------------------
	and z80hl,z80hl,#0xFF000000
	orr z80hl,z80hl,z80hl,lsr#8
	fetch 4
;----------------------------------------------------------------------------
;_6D;	LD L,L
;----------------------------------------------------------------------------
;	fetch 4
;----------------------------------------------------------------------------
_6E;	LD L,(HL)
;----------------------------------------------------------------------------
	mov addy,z80hl,lsr#16
;----------------------------------------------------------------------------
_DD6E_;	LD L,(IX+d)
;----------------------------------------------------------------------------
	readmem8
	and z80hl,z80hl,#0xFF000000
	orr z80hl,z80hl,r0,lsl#16
	fetch 7
;----------------------------------------------------------------------------
_6F;	LD L,A
;----------------------------------------------------------------------------
	and z80hl,z80hl,#0xFF000000
	orr z80hl,z80hl,z80a,lsr#8
	fetch 4
;----------------------------------------------------------------------------
_70;	LD (HL),B
;----------------------------------------------------------------------------
	mov addy,z80hl,lsr#16
;----------------------------------------------------------------------------
_DD70_;	LD (IX+d),B
;----------------------------------------------------------------------------
	mov r0,z80bc,lsr#24
	writemem8
	fetch 7
;----------------------------------------------------------------------------
_71;	LD (HL),C
;----------------------------------------------------------------------------
	mov addy,z80hl,lsr#16
;----------------------------------------------------------------------------
_DD71_;	LD (IX+d),C
;----------------------------------------------------------------------------
	mov r0,z80bc,lsr#16
	writemem8
	fetch 7
;----------------------------------------------------------------------------
_72;	LD (HL),D
;----------------------------------------------------------------------------
	mov addy,z80hl,lsr#16
;----------------------------------------------------------------------------
_DD72_;	LD (IX+d),D
;----------------------------------------------------------------------------
	mov r0,z80de,lsr#24
	writemem8
	fetch 7
;----------------------------------------------------------------------------
_73;	LD (HL),E
;----------------------------------------------------------------------------
	mov addy,z80hl,lsr#16
;----------------------------------------------------------------------------
_DD73_;	LD (IX+d),E
;----------------------------------------------------------------------------
	mov r0,z80de,lsr#16
	writemem8
	fetch 7
;----------------------------------------------------------------------------
_74;	LD (HL),H
;----------------------------------------------------------------------------
	mov addy,z80hl,lsr#16
;----------------------------------------------------------------------------
_DD74_;	LD (IX+d),H
;----------------------------------------------------------------------------
	mov r0,z80hl,lsr#24
	writemem8
	fetch 7
;----------------------------------------------------------------------------
_75;	LD (HL),L
;----------------------------------------------------------------------------
	mov addy,z80hl,lsr#16
;----------------------------------------------------------------------------
_DD75_;	LD (IX+d),L
;----------------------------------------------------------------------------
	mov r0,z80hl,lsr#16
	writemem8
	fetch 7
;----------------------------------------------------------------------------
_76;	HALT, wait for interrupt.
;----------------------------------------------------------------------------
	sub z80pc,z80pc,#1
	and cycles,cycles,#CYC_MASK				;speedhack!
	eatcycles 4
	ldr pc,nexttimeout
;----------------------------------------------------------------------------
_77;	LD (HL),A
;----------------------------------------------------------------------------
	mov addy,z80hl,lsr#16
;----------------------------------------------------------------------------
_DD77_;	LD (IX+d),A
;----------------------------------------------------------------------------
	mov r0,z80a,lsr#24
	writemem8
	fetch 7
;----------------------------------------------------------------------------
_78;	LD A,B
;----------------------------------------------------------------------------
	and z80a,z80bc,#0xFF000000
	fetch 4
;----------------------------------------------------------------------------
_79;	LD A,C
;----------------------------------------------------------------------------
	mov z80a,z80bc,lsl#8
	fetch 4
;----------------------------------------------------------------------------
_7A;	LD A,D
;----------------------------------------------------------------------------
	and z80a,z80de,#0xFF000000
	fetch 4
;----------------------------------------------------------------------------
_7B;	LD A,E
;----------------------------------------------------------------------------
	mov z80a,z80de,lsl#8
	fetch 4
;----------------------------------------------------------------------------
_7C;	LD A,H
;----------------------------------------------------------------------------
	and z80a,z80hl,#0xFF000000
	fetch 4
;----------------------------------------------------------------------------
_7D;	LD A,L
;----------------------------------------------------------------------------
	mov z80a,z80hl,lsl#8
	fetch 4
;----------------------------------------------------------------------------
_7E;	LD A,(HL)
;----------------------------------------------------------------------------
	mov addy,z80hl,lsr#16
;----------------------------------------------------------------------------
_DD7E_;	LD A,(IX+d)
;----------------------------------------------------------------------------
	readmem8
	mov z80a,r0,lsl#24
	fetch 7
;----------------------------------------------------------------------------
;_7F;	LD A,A
;----------------------------------------------------------------------------
;	fetch 4

;----------------------------------------------------------------------------
_80;	ADD B
;----------------------------------------------------------------------------
	opADDH z80bc
;----------------------------------------------------------------------------
_81;	ADD C
;----------------------------------------------------------------------------
	opADDL z80bc
;----------------------------------------------------------------------------
_82;	ADD D
;----------------------------------------------------------------------------
	opADDH z80de
;----------------------------------------------------------------------------
_83;	ADD E
;----------------------------------------------------------------------------
	opADDL z80de
;----------------------------------------------------------------------------
_84;	ADD H
;----------------------------------------------------------------------------
	opADDH z80hl
;----------------------------------------------------------------------------
_85;	ADD L
;----------------------------------------------------------------------------
	opADDL z80hl
;----------------------------------------------------------------------------
_86;	ADD (HL)
;----------------------------------------------------------------------------
	mov addy,z80hl,lsr#16
;----------------------------------------------------------------------------
_DD86_;	ADD (IX+d)
;----------------------------------------------------------------------------
	readmem8
	opADDb
	fetch 7
;----------------------------------------------------------------------------
_87;	ADD A
;----------------------------------------------------------------------------
	opADDA

;----------------------------------------------------------------------------
_88;	ADC B
;----------------------------------------------------------------------------
	opADCH z80bc
;----------------------------------------------------------------------------
_89;	ADC C
;----------------------------------------------------------------------------
	opADCL z80bc
;----------------------------------------------------------------------------
_8A;	ADC D
;----------------------------------------------------------------------------
	opADCH z80de
;----------------------------------------------------------------------------
_8B;	ADC E
;----------------------------------------------------------------------------
	opADCL z80de
;----------------------------------------------------------------------------
_8C;	ADC H
;----------------------------------------------------------------------------
	opADCH z80hl
;----------------------------------------------------------------------------
_8D;	ADC L
;----------------------------------------------------------------------------
	opADCL z80hl
;----------------------------------------------------------------------------
_8E;	ADC (HL)
;----------------------------------------------------------------------------
	mov addy,z80hl,lsr#16
;----------------------------------------------------------------------------
_DD8E_;	ADC (IX+d)
;----------------------------------------------------------------------------
	readmem8
	opADCb
	fetch 7
;----------------------------------------------------------------------------
_8F;	ADC A
;----------------------------------------------------------------------------
	opADCA

;----------------------------------------------------------------------------
_90;	SUB B
;----------------------------------------------------------------------------
	opSUBH z80bc
;----------------------------------------------------------------------------
_91;	SUB C
;----------------------------------------------------------------------------
	opSUBL z80bc
;----------------------------------------------------------------------------
_92;	SUB D
;----------------------------------------------------------------------------
	opSUBH z80de
;----------------------------------------------------------------------------
_93;	SUB E
;----------------------------------------------------------------------------
	opSUBL z80de
;----------------------------------------------------------------------------
_94;	SUB H
;----------------------------------------------------------------------------
	opSUBH z80hl
;----------------------------------------------------------------------------
_95;	SUB L
;----------------------------------------------------------------------------
	opSUBL z80hl
;----------------------------------------------------------------------------
_96;	SUB (HL)
;----------------------------------------------------------------------------
	mov addy,z80hl,lsr#16
;----------------------------------------------------------------------------
_DD96_;	SUB (IX+d)
;----------------------------------------------------------------------------
	readmem8
	opSUBb
	fetch 7
;----------------------------------------------------------------------------
_97;	SUB A
;----------------------------------------------------------------------------
	opSUBA

;----------------------------------------------------------------------------
_98;	SBC B
;----------------------------------------------------------------------------
	opSBCH z80bc
;----------------------------------------------------------------------------
_99;	SBC C
;----------------------------------------------------------------------------
	opSBCL z80bc
;----------------------------------------------------------------------------
_9A;	SBC D
;----------------------------------------------------------------------------
	opSBCH z80de
;----------------------------------------------------------------------------
_9B;	SBC E
;----------------------------------------------------------------------------
	opSBCL z80de
;----------------------------------------------------------------------------
_9C;	SBC H
;----------------------------------------------------------------------------
	opSBCH z80hl
;----------------------------------------------------------------------------
_9D;	SBC L
;----------------------------------------------------------------------------
	opSBCL z80hl
;----------------------------------------------------------------------------
_9E;	SBC (HL)
;----------------------------------------------------------------------------
	mov addy,z80hl,lsr#16
;----------------------------------------------------------------------------
_DD9E_;	SBC (IX+d)
;----------------------------------------------------------------------------
	readmem8
	opSBCb
	fetch 7
;----------------------------------------------------------------------------
_9F;	SBC A
;----------------------------------------------------------------------------
	opSBCA

;----------------------------------------------------------------------------
_A0;	AND B
;----------------------------------------------------------------------------
	opANDH z80bc
;----------------------------------------------------------------------------
_A1;	AND C
;----------------------------------------------------------------------------
	opANDL z80bc
;----------------------------------------------------------------------------
_A2;	AND D
;----------------------------------------------------------------------------
	opANDH z80de
;----------------------------------------------------------------------------
_A3;	AND E
;----------------------------------------------------------------------------
	opANDL z80de
;----------------------------------------------------------------------------
_A4;	AND H
;----------------------------------------------------------------------------
	opANDH z80hl
;----------------------------------------------------------------------------
_A5;	AND L
;----------------------------------------------------------------------------
	opANDL z80hl
;----------------------------------------------------------------------------
_A6;	AND (HL)
;----------------------------------------------------------------------------
	mov addy,z80hl,lsr#16
;----------------------------------------------------------------------------
_DDA6_;	AND (IX+d)
;----------------------------------------------------------------------------
	readmem8
	opANDb
	fetch 7
;----------------------------------------------------------------------------
_A7;	AND A
;----------------------------------------------------------------------------
	opANDA

;----------------------------------------------------------------------------
_A8;	XOR B
;----------------------------------------------------------------------------
	opXORH z80bc
;----------------------------------------------------------------------------
_A9;	XOR C
;----------------------------------------------------------------------------
	opXORL z80bc
;----------------------------------------------------------------------------
_AA;	XOR D
;----------------------------------------------------------------------------
	opXORH z80de
;----------------------------------------------------------------------------
_AB;	XOR E
;----------------------------------------------------------------------------
	opXORL z80de
;----------------------------------------------------------------------------
_AC;	XOR H
;----------------------------------------------------------------------------
	opXORH z80hl
;----------------------------------------------------------------------------
_AD;	XOR L
;----------------------------------------------------------------------------
	opXORL z80hl
;----------------------------------------------------------------------------
_AE;	XOR (HL)
;----------------------------------------------------------------------------
	mov addy,z80hl,lsr#16
;----------------------------------------------------------------------------
_DDAE_;	XOR (IX+d)
;----------------------------------------------------------------------------
	readmem8
	opXORb
	fetch 7
;----------------------------------------------------------------------------
_AF;	XOR A
;----------------------------------------------------------------------------
	opXORA

;----------------------------------------------------------------------------
_B0;	OR B
;----------------------------------------------------------------------------
	opORH z80bc
;----------------------------------------------------------------------------
_B1;	OR C
;----------------------------------------------------------------------------
	opORL z80bc
;----------------------------------------------------------------------------
_B2;	OR D
;----------------------------------------------------------------------------
	opORH z80de
;----------------------------------------------------------------------------
_B3;	OR E
;----------------------------------------------------------------------------
	opORL z80de
;----------------------------------------------------------------------------
_B4;	OR H
;----------------------------------------------------------------------------
	opORH z80hl
;----------------------------------------------------------------------------
_B5;	OR L
;----------------------------------------------------------------------------
	opORL z80hl
;----------------------------------------------------------------------------
_B6;	OR (HL)
;----------------------------------------------------------------------------
	mov addy,z80hl,lsr#16
;----------------------------------------------------------------------------
_DDB6_;	OR (IX+d)
;----------------------------------------------------------------------------
	readmem8
	opORb
	fetch 7
;----------------------------------------------------------------------------
_B7;	OR A
;----------------------------------------------------------------------------
	opORA

;----------------------------------------------------------------------------
_B8;	CP B
;----------------------------------------------------------------------------
	opCPH z80bc
;----------------------------------------------------------------------------
_B9;	CP C
;----------------------------------------------------------------------------
	opCPL z80bc
;----------------------------------------------------------------------------
_BA;	CP D
;----------------------------------------------------------------------------
	opCPH z80de
;----------------------------------------------------------------------------
_BB;	CP E
;----------------------------------------------------------------------------
	opCPL z80de
;----------------------------------------------------------------------------
_BC;	CP H
;----------------------------------------------------------------------------
	opCPH z80hl
;----------------------------------------------------------------------------
_BD;	CP L
;----------------------------------------------------------------------------
	opCPL z80hl
;----------------------------------------------------------------------------
_BE;	CP (HL)
;----------------------------------------------------------------------------
	mov addy,z80hl,lsr#16
;----------------------------------------------------------------------------
_DDBE_;	CP (IX+d)
;----------------------------------------------------------------------------
	readmem8
	opCPb
	fetch 7
;----------------------------------------------------------------------------
_BF;	CP A
;----------------------------------------------------------------------------
	opCPA

;----------------------------------------------------------------------------
_C0;	RET NZ
;----------------------------------------------------------------------------
	tst z80f,#PSR_Z
	beq _C9_
	fetch 5
;----------------------------------------------------------------------------
_C1;	POP BC
;----------------------------------------------------------------------------
	pop16 z80bc
	mov z80bc,z80bc,lsl#16
	fetch 10
;----------------------------------------------------------------------------
_C2;	JP NZ,$nnnn
;----------------------------------------------------------------------------
	tst z80f,#PSR_Z
	beq _C3
	add z80pc,z80pc,#2
	fetch 10
;----------------------------------------------------------------------------
_C3;	JP $nnnn
;----------------------------------------------------------------------------
;	ldr r1,lastbank
;	sub r1,z80pc,r1
	ldrb r0,[z80pc],#1
	ldrb z80pc,[z80pc]
	orr z80pc,r0,z80pc,lsl#8
;	sub r1,z80pc,r1
;	cmp r1,#-3
;	andpl cycles,cycles,#CYC_MASK
	encodePC
	fetch 10
;----------------------------------------------------------------------------
_C4;	CALL NZ,$nnnn
;----------------------------------------------------------------------------
	tst z80f,#PSR_Z
	beq _CD
	add z80pc,z80pc,#2
	fetch 10
;----------------------------------------------------------------------------
_C5;	PUSH BC
;----------------------------------------------------------------------------
	mov r0,z80bc,lsr#16
	push16
	fetch 11
;----------------------------------------------------------------------------
_C6;	ADD #nn
;----------------------------------------------------------------------------
	ldrb r0,[z80pc],#1
	opADDb
	fetch 7
;----------------------------------------------------------------------------
_C7;	RST 0x00
_CF;	RST 0x08
_D7;	RST 0x10
_DF;	RST 0x18
_E7;	RST 0x20
_EF;	RST 0x28
_F7;	RST 0x30
_FF;	RST 0x38
;----------------------------------------------------------------------------
	and addy,r0,#0x38
	b rst_entry
;----------------------------------------------------------------------------
_C8;	RET Z
;----------------------------------------------------------------------------
	tst z80f,#PSR_Z
	bne _C9_
	fetch 5
;----------------------------------------------------------------------------
_C9_;
	eatcycles 1
;----------------------------------------------------------------------------
_C9;	RET
;----------------------------------------------------------------------------
	pop16 z80pc
	encodePC
	fetch 10
;----------------------------------------------------------------------------
_CA;	JP Z,$nnnn
;----------------------------------------------------------------------------
	tst z80f,#PSR_Z
	bne _C3
	add z80pc,z80pc,#2
	fetch 10
;----------------------------------------------------------------------------
_CC;	CALL Z,$nnnn
;----------------------------------------------------------------------------
	tst z80f,#PSR_Z
	bne _CD
	add z80pc,z80pc,#2
	fetch 10
;----------------------------------------------------------------------------
_CD;	CALL $nnnn
;----------------------------------------------------------------------------
	ldrb r1,[z80pc],#1
	ldrb r2,[z80pc],#1
	ldr r0,lastbank
	sub r0,z80pc,r0
	orr z80pc,r1,r2,lsl#8
	push16
	encodePC
	fetch 17
;----------------------------------------------------------------------------
_CE;	ADC #nn
;----------------------------------------------------------------------------
	ldrb r0,[z80pc],#1
	opADCb
	fetch 7
;----------------------------------------------------------------------------
;_CF;	RST 0x08		moved to C7
;----------------------------------------------------------------------------
_D0;	RET NC
;----------------------------------------------------------------------------
	tst z80f,#PSR_C
	beq _C9_
	fetch 5
;----------------------------------------------------------------------------
_D1;	POP DE
;----------------------------------------------------------------------------
	pop16 z80de
	mov z80de,z80de,lsl#16
	fetch 10
;----------------------------------------------------------------------------
_D2;	JP NC,$nnnn
;----------------------------------------------------------------------------
	tst z80f,#PSR_C
	beq _C3
	add z80pc,z80pc,#2
	fetch 10

;----------------------------------------------------------------------------
_D3;	OUT (N),A
;----------------------------------------------------------------------------
	ldrb addy,[z80pc],#1
	mov r0,z80a,lsr#24
	bl Z80_OUT
	fetch 11
;----------------------------------------------------------------------------
_D4;	CALL NC,$nnnn
;----------------------------------------------------------------------------
	tst z80f,#PSR_C
	beq _CD
	add z80pc,z80pc,#2
	fetch 10
;----------------------------------------------------------------------------
_D5;	PUSH DE
;----------------------------------------------------------------------------
	mov r0,z80de,lsr#16
	push16
	fetch 11
;----------------------------------------------------------------------------
_D6;	SUB #nn
;----------------------------------------------------------------------------
	ldrb r0,[z80pc],#1
	opSUBb
	fetch 7
;----------------------------------------------------------------------------
;_D7;	RST 0x10		moved to C7
;----------------------------------------------------------------------------
_D8;	RET C
;----------------------------------------------------------------------------
	tst z80f,#PSR_C
	bne _C9_
	fetch 5
;----------------------------------------------------------------------------
_D9;	EXX		exchange BC, DE & HL
;----------------------------------------------------------------------------
	adrl r0,cpuregs2+8
	swp z80bc,z80bc,[r0]
	add r0,r0,#4
	swp z80de,z80de,[r0]
	add r0,r0,#4
	swp z80hl,z80hl,[r0]
	fetch 4
;----------------------------------------------------------------------------
_DA;	JP C,$nnnn
;----------------------------------------------------------------------------
	tst z80f,#PSR_C
	bne _C3
	add z80pc,z80pc,#2
	fetch 10
;----------------------------------------------------------------------------
_DB;	IN A,(N)
;----------------------------------------------------------------------------
	ldrb addy,[z80pc],#1
	bl Z80_IN
	mov z80a,r0,lsl#24
	fetch 11
;----------------------------------------------------------------------------
_DC;	CALL C,$nnnn
;----------------------------------------------------------------------------
	tst z80f,#PSR_C
	bne _CD
	add z80pc,z80pc,#2
	fetch 10
;----------------------------------------------------------------------------
;_DD;	prefix. change HL to IX
;----------------------------------------------------------------------------

;----------------------------------------------------------------------------
_DE;	SBC #nn
;----------------------------------------------------------------------------
	ldrb r0,[z80pc],#1
	opSBCb
	fetch 7
;----------------------------------------------------------------------------
;_DF;	RST 0x18		moved to C7
;----------------------------------------------------------------------------
_E0;	RET PO
;----------------------------------------------------------------------------
	tst z80f,#PSR_P
	beq _C9_
	fetch 5
;----------------------------------------------------------------------------
_E1;	POP HL
;----------------------------------------------------------------------------
	pop16 z80hl
	mov z80hl,z80hl,lsl#16
	fetch 10
;----------------------------------------------------------------------------
_E2;	JP PO
;----------------------------------------------------------------------------
	tst z80f,#PSR_P
	beq _C3
	add z80pc,z80pc,#2
	fetch 10
;----------------------------------------------------------------------------
_E3;	EX (SP),HL
;----------------------------------------------------------------------------
	and r1,z80sp,#0xFC000000
	adr r2,memmap_tbl
	ldr r1,[r2,r1,lsr#24]

	mov r2,z80hl,lsr#16
	ldrb z80hl,[r1,z80sp,lsr#16]
	strb r2,[r1,z80sp,lsr#16]
	add addy,z80sp,#0x00010000
	mov r2,r2,lsr#8
	ldrb r0,[r1,addy,lsr#16]
	strb r2,[r1,addy,lsr#16]
	orr z80hl,z80hl,r0,lsl#8
	mov z80hl,z80hl,lsl#16
	fetch 19
;----------------------------------------------------------------------------
_E4;	CALL PO,$nnnn
;----------------------------------------------------------------------------
	tst z80f,#PSR_P
	beq _CD
	add z80pc,z80pc,#2
	fetch 10
;----------------------------------------------------------------------------
_E5;	PUSH HL
;----------------------------------------------------------------------------
	mov r0,z80hl,lsr#16
	push16
	fetch 11
;----------------------------------------------------------------------------
_E6;	AND #nn
;----------------------------------------------------------------------------
	ldrb r0,[z80pc],#1
	opANDb
	fetch 7
;----------------------------------------------------------------------------
;_E7;	RST 0x20		moved to C7
;----------------------------------------------------------------------------
_E8;	RET PE
;----------------------------------------------------------------------------
	tst z80f,#PSR_P
	bne _C9_
	fetch 5
;----------------------------------------------------------------------------
_E9;	JP HL
;----------------------------------------------------------------------------
	encodePC_HL
	fetch 4
;----------------------------------------------------------------------------
_EA;	JP PE
;----------------------------------------------------------------------------
	tst z80f,#PSR_P
	bne _C3
	add z80pc,z80pc,#2
	fetch 10
;----------------------------------------------------------------------------
_EB;	EX DE,HL
;----------------------------------------------------------------------------
	eor z80de,z80de,z80hl
	eor z80hl,z80hl,z80de
	eor z80de,z80de,z80hl
	fetch 4
;----------------------------------------------------------------------------
_EC;	CALL PE,$nnnn
;----------------------------------------------------------------------------
	tst z80f,#PSR_P
	bne _CD
	add z80pc,z80pc,#2
	fetch 10
;----------------------------------------------------------------------------
;_ED;	prefix. 
;----------------------------------------------------------------------------

;----------------------------------------------------------------------------
_EE;	XOR #nn
;----------------------------------------------------------------------------
	ldrb r0,[z80pc],#1
	opXORb
	fetch 7
;----------------------------------------------------------------------------
;_EF;	RST 0x28		moved to C7
;----------------------------------------------------------------------------
_F0;	RET P
;----------------------------------------------------------------------------
	tst z80f,#PSR_S
	beq _C9_
	fetch 5
;----------------------------------------------------------------------------
_F1;	POP AF
;----------------------------------------------------------------------------
	popAF
	decodeFLG
	fetch 10
;----------------------------------------------------------------------------
_F2;	JP P
;----------------------------------------------------------------------------
	tst z80f,#PSR_S
	beq _C3
	add z80pc,z80pc,#2
	fetch 10
;----------------------------------------------------------------------------
_F3;	DI, disable interrupt
;----------------------------------------------------------------------------
	strb z80a,z80_iff1
	strb z80a,z80_iff2
	fetch 4
;----------------------------------------------------------------------------
_F4;	CALL P,$nnnn
;----------------------------------------------------------------------------
	tst z80f,#PSR_S
	beq _CD
	add z80pc,z80pc,#2
	fetch 10
;----------------------------------------------------------------------------
_F5;	PUSH AF
;----------------------------------------------------------------------------
	encodeFLG
	orr r0,r0,z80a,lsr#16
	push16
	fetch 11
;----------------------------------------------------------------------------
_F6;	OR #nn
;----------------------------------------------------------------------------
	ldrb r0,[z80pc],#1
	opORb
	fetch 7
;----------------------------------------------------------------------------
;_F7;	RST 0x30		moved to C7
;----------------------------------------------------------------------------
_F8;	RET M
;----------------------------------------------------------------------------
	tst z80f,#PSR_S
	bne _C9_
	fetch 5
;----------------------------------------------------------------------------
_F9;	LD SP,HL
;----------------------------------------------------------------------------
	mov z80sp,z80hl
	fetch 6
;----------------------------------------------------------------------------
_FA;	JP M
;----------------------------------------------------------------------------
	tst z80f,#PSR_S
	bne _C3
	add z80pc,z80pc,#2
	fetch 10
;----------------------------------------------------------------------------
_FB;	EI, enable interrupt
;----------------------------------------------------------------------------
	eatcycles 4
	mov r0,#1
	strb r0,z80_iff2
	ldrb r1,z80_iff1
	strb r0,z80_iff1
	cmp r0,r1
;RETN_fix
	ldrne r0,EiFixAdr
	strne r0,nexttimeout
	strne cycles,oldcycles
	andne cycles,cycles,#CYC_MASK
	fetch_force
EiFixAdr
 DCD EI_fix
;----------------------------------------------------------------------------
_FC;	CALL M,$nnnn
;----------------------------------------------------------------------------
	tst z80f,#PSR_S
	bne _CD
	add z80pc,z80pc,#2
	fetch 10
;----------------------------------------------------------------------------
;_FD;	prefix. change HL to IY
;----------------------------------------------------------------------------

;----------------------------------------------------------------------------
_FE;	CP #nn
;----------------------------------------------------------------------------
	ldrb r0,[z80pc],#1
	opCPb
	fetch 7
;----------------------------------------------------------------------------
;_FF;	RST 0x38		moved to C7
;----------------------------------------------------------------------------




;----------------------------------------------------------------------------
_CB;	Extensions
;----------------------------------------------------------------------------
;	mov r11,r11			;No$GBA breakpoint
	ldrb r0,[z80pc],#1
	ldr pc,[pc,r0,lsl#2]
	DCD 0
;----------------------------------------------------------------------------
cb_table
	DCD _CB00,_CB01,_CB02,_CB03,_CB04,_CB05,_CB06,_CB07,_CB08,_CB09,_CB0A,_CB0B,_CB0C,_CB0D,_CB0E,_CB0F
	DCD _CB10,_CB11,_CB12,_CB13,_CB14,_CB15,_CB16,_CB17,_CB18,_CB19,_CB1A,_CB1B,_CB1C,_CB1D,_CB1E,_CB1F
	DCD _CB20,_CB21,_CB22,_CB23,_CB24,_CB25,_CB26,_CB27,_CB28,_CB29,_CB2A,_CB2B,_CB2C,_CB2D,_CB2E,_CB2F
	DCD _CB30,_CB31,_CB32,_CB33,_CB34,_CB35,_CB36,_CB37,_CB38,_CB39,_CB3A,_CB3B,_CB3C,_CB3D,_CB3E,_CB3F
	DCD _CB40,_CB41,_CB42,_CB43,_CB44,_CB45,_CB46,_CB47,_CB40,_CB41,_CB42,_CB43,_CB44,_CB45,_CB4E,_CB47
	DCD _CB40,_CB41,_CB42,_CB43,_CB44,_CB45,_CB56,_CB47,_CB40,_CB41,_CB42,_CB43,_CB44,_CB45,_CB5E,_CB47
	DCD _CB40,_CB41,_CB42,_CB43,_CB44,_CB45,_CB66,_CB47,_CB40,_CB41,_CB42,_CB43,_CB44,_CB45,_CB6E,_CB47
	DCD _CB40,_CB41,_CB42,_CB43,_CB44,_CB45,_CB76,_CB47,_CB78,_CB79,_CB7A,_CB7B,_CB7C,_CB7D,_CB7E,_CB7F
	DCD _CB80,_CB81,_CB82,_CB83,_CB84,_CB85,_CB86,_CB87,_CB80,_CB81,_CB82,_CB83,_CB84,_CB85,_CB8E,_CB87
	DCD _CB80,_CB81,_CB82,_CB83,_CB84,_CB85,_CB96,_CB87,_CB80,_CB81,_CB82,_CB83,_CB84,_CB85,_CB9E,_CB87
	DCD _CB80,_CB81,_CB82,_CB83,_CB84,_CB85,_CBA6,_CB87,_CB80,_CB81,_CB82,_CB83,_CB84,_CB85,_CBAE,_CB87
	DCD _CB80,_CB81,_CB82,_CB83,_CB84,_CB85,_CBB6,_CB87,_CB80,_CB81,_CB82,_CB83,_CB84,_CB85,_CBBE,_CB87
	DCD _CBC0,_CBC1,_CBC2,_CBC3,_CBC4,_CBC5,_CBC6,_CBC7,_CBC0,_CBC1,_CBC2,_CBC3,_CBC4,_CBC5,_CBCE,_CBC7
	DCD _CBC0,_CBC1,_CBC2,_CBC3,_CBC4,_CBC5,_CBD6,_CBC7,_CBC0,_CBC1,_CBC2,_CBC3,_CBC4,_CBC5,_CBDE,_CBC7
	DCD _CBC0,_CBC1,_CBC2,_CBC3,_CBC4,_CBC5,_CBE6,_CBC7,_CBC0,_CBC1,_CBC2,_CBC3,_CBC4,_CBC5,_CBEE,_CBC7
	DCD _CBC0,_CBC1,_CBC2,_CBC3,_CBC4,_CBC5,_CBF6,_CBC7,_CBC0,_CBC1,_CBC2,_CBC3,_CBC4,_CBC5,_CBFE,_CBC7
;----------------------------------------------------------------------------
_CB00;		RLC B
;----------------------------------------------------------------------------
	opRLCH z80bc
;----------------------------------------------------------------------------
_CB01;		RLC C
;----------------------------------------------------------------------------
	opRLCL z80bc
;----------------------------------------------------------------------------
_CB02;		RLC D
;----------------------------------------------------------------------------
	opRLCH z80de
;----------------------------------------------------------------------------
_CB03;		RLC E
;----------------------------------------------------------------------------
	opRLCL z80de
;----------------------------------------------------------------------------
_CB04;		RLC H
;----------------------------------------------------------------------------
	opRLCH z80hl
;----------------------------------------------------------------------------
_CB05;		RLC L
;----------------------------------------------------------------------------
	opRLCL z80hl
;----------------------------------------------------------------------------
_CB06;		RLC (HL)
;----------------------------------------------------------------------------
	mov addy,z80hl,lsr#16
;----------------------------------------------------------------------------
_DDCB06;	RLC (IX+d)
;----------------------------------------------------------------------------
	readmem8
	opRLCb
	writemem8
	fetch 15
;----------------------------------------------------------------------------
_CB07;		RLC A
;----------------------------------------------------------------------------
	opRLCA
;----------------------------------------------------------------------------


;----------------------------------------------------------------------------
_CB08;		RRC B
;----------------------------------------------------------------------------
	opRRCH z80bc
;----------------------------------------------------------------------------
_CB09;		RRC C
;----------------------------------------------------------------------------
	opRRCL z80bc
;----------------------------------------------------------------------------
_CB0A;		RRC D
;----------------------------------------------------------------------------
	opRRCH z80de
;----------------------------------------------------------------------------
_CB0B;		RRC E
;----------------------------------------------------------------------------
	opRRCL z80de
;----------------------------------------------------------------------------
_CB0C;		RRC H
;----------------------------------------------------------------------------
	opRRCH z80hl
;----------------------------------------------------------------------------
_CB0D;		RRC L
;----------------------------------------------------------------------------
	opRRCL z80hl
;----------------------------------------------------------------------------
_CB0E;		RRC (HL)
;----------------------------------------------------------------------------
	mov addy,z80hl,lsr#16
;----------------------------------------------------------------------------
_DDCB0E;	RRC (IX+d)
;----------------------------------------------------------------------------
	readmem8
	opRRCb
	writemem8
	fetch 15
;----------------------------------------------------------------------------
_CB0F;		RRC A
;----------------------------------------------------------------------------
	opRRCA
;----------------------------------------------------------------------------


;----------------------------------------------------------------------------
_CB10;		RL B
;----------------------------------------------------------------------------
	opRLH z80bc
;----------------------------------------------------------------------------
_CB11;		RL C
;----------------------------------------------------------------------------
	opRLL z80bc
;----------------------------------------------------------------------------
_CB12;		RL D
;----------------------------------------------------------------------------
	opRLH z80de
;----------------------------------------------------------------------------
_CB13;		RL E
;----------------------------------------------------------------------------
	opRLL z80de
;----------------------------------------------------------------------------
_CB14;		RL H
;----------------------------------------------------------------------------
	opRLH z80hl
;----------------------------------------------------------------------------
_CB15;		RL L
;----------------------------------------------------------------------------
	opRLL z80hl
;----------------------------------------------------------------------------
_CB16;		RL (HL)
;----------------------------------------------------------------------------
	mov addy,z80hl,lsr#16
;----------------------------------------------------------------------------
_DDCB16;	RL (IX+d)
;----------------------------------------------------------------------------
	readmem8
	opRLb
	writemem8
	fetch 15
;----------------------------------------------------------------------------
_CB17;		RL A
;----------------------------------------------------------------------------
	opRLA
;----------------------------------------------------------------------------


;----------------------------------------------------------------------------
_CB18;		RR B
;----------------------------------------------------------------------------
	opRRH z80bc
;----------------------------------------------------------------------------
_CB19;		RR C
;----------------------------------------------------------------------------
	opRRL z80bc
;----------------------------------------------------------------------------
_CB1A;		RR D
;----------------------------------------------------------------------------
	opRRH z80de
;----------------------------------------------------------------------------
_CB1B;		RR E
;----------------------------------------------------------------------------
	opRRL z80de
;----------------------------------------------------------------------------
_CB1C;		RR H
;----------------------------------------------------------------------------
	opRRH z80hl
;----------------------------------------------------------------------------
_CB1D;		RR L
;----------------------------------------------------------------------------
	opRRL z80hl
;----------------------------------------------------------------------------
_CB1E;		RR (HL)
;----------------------------------------------------------------------------
	mov addy,z80hl,lsr#16
;----------------------------------------------------------------------------
_DDCB1E;	RR (IX+d)
;----------------------------------------------------------------------------
	readmem8
	opRRb
	writemem8
	fetch 15
;----------------------------------------------------------------------------
_CB1F;		RR A
;----------------------------------------------------------------------------
	opRRA
;----------------------------------------------------------------------------


;----------------------------------------------------------------------------
_CB20;		SLA B
;----------------------------------------------------------------------------
	opSLAH z80bc
;----------------------------------------------------------------------------
_CB21;		SLA C
;----------------------------------------------------------------------------
	opSLAL z80bc
;----------------------------------------------------------------------------
_CB22;		SLA D
;----------------------------------------------------------------------------
	opSLAH z80de
;----------------------------------------------------------------------------
_CB23;		SLA E
;----------------------------------------------------------------------------
	opSLAL z80de
;----------------------------------------------------------------------------
_CB24;		SLA H
;----------------------------------------------------------------------------
	opSLAH z80hl
;----------------------------------------------------------------------------
_CB25;		SLA L
;----------------------------------------------------------------------------
	opSLAL z80hl
;----------------------------------------------------------------------------
_CB26;		SLA (HL)
;----------------------------------------------------------------------------
	mov addy,z80hl,lsr#16
;----------------------------------------------------------------------------
_DDCB26;	SLA (IX+d)
;----------------------------------------------------------------------------
	readmem8
	opSLAb
	writemem8
	fetch 15
;----------------------------------------------------------------------------
_CB27;		SLA A
;----------------------------------------------------------------------------
	opSLAA
;----------------------------------------------------------------------------


;----------------------------------------------------------------------------
_CB28;		SRA B
;----------------------------------------------------------------------------
	opSRAH z80bc
;----------------------------------------------------------------------------
_CB29;		SRA C
;----------------------------------------------------------------------------
	opSRAL z80bc
;----------------------------------------------------------------------------
_CB2A;		SRA D
;----------------------------------------------------------------------------
	opSRAH z80de
;----------------------------------------------------------------------------
_CB2B;		SRA E
;----------------------------------------------------------------------------
	opSRAL z80de
;----------------------------------------------------------------------------
_CB2C;		SRA H
;----------------------------------------------------------------------------
	opSRAH z80hl
;----------------------------------------------------------------------------
_CB2D;		SRA L
;----------------------------------------------------------------------------
	opSRAL z80hl
;----------------------------------------------------------------------------
_CB2E;		SRA (HL)
;----------------------------------------------------------------------------
	mov addy,z80hl,lsr#16
;----------------------------------------------------------------------------
_DDCB2E;	SRA (IX+d)
;----------------------------------------------------------------------------
	readmem8
	opSRAb
	writemem8
	fetch 15
;----------------------------------------------------------------------------
_CB2F;		SRA A
;----------------------------------------------------------------------------
	opSRAA
;----------------------------------------------------------------------------


;----------------------------------------------------------------------------
_CB30;		SLL B
;----------------------------------------------------------------------------
	opSLLH z80bc
;----------------------------------------------------------------------------
_CB31;		SLL C
;----------------------------------------------------------------------------
	opSLLL z80bc
;----------------------------------------------------------------------------
_CB32;		SLL D
;----------------------------------------------------------------------------
	opSLLH z80de
;----------------------------------------------------------------------------
_CB33;		SLL E
;----------------------------------------------------------------------------
	opSLLL z80de
;----------------------------------------------------------------------------
_CB34;		SLL H
;----------------------------------------------------------------------------
	opSLLH z80hl
;----------------------------------------------------------------------------
_CB35;		SLL L
;----------------------------------------------------------------------------
	opSLLL z80hl
;----------------------------------------------------------------------------
_CB36;		SLL (HL)
;----------------------------------------------------------------------------
	mov addy,z80hl,lsr#16
;----------------------------------------------------------------------------
_DDCB36;	SLL (IX+d)
;----------------------------------------------------------------------------
	readmem8
	opSLLb
	writemem8
	fetch 15
;----------------------------------------------------------------------------
_CB37;		SLL A
;----------------------------------------------------------------------------
	opSLLA
;----------------------------------------------------------------------------


;----------------------------------------------------------------------------
_CB38;		SRL B
;----------------------------------------------------------------------------
	opSRLH z80bc
;----------------------------------------------------------------------------
_CB39;		SRL C
;----------------------------------------------------------------------------
	opSRLL z80bc
;----------------------------------------------------------------------------
_CB3A;		SRL D
;----------------------------------------------------------------------------
	opSRLH z80de
;----------------------------------------------------------------------------
_CB3B;		SRL E
;----------------------------------------------------------------------------
	opSRLL z80de
;----------------------------------------------------------------------------
_CB3C;		SRL H
;----------------------------------------------------------------------------
	opSRLH z80hl
;----------------------------------------------------------------------------
_CB3D;		SRL L
;----------------------------------------------------------------------------
	opSRLL z80hl
;----------------------------------------------------------------------------
_CB3E;		SRL (HL)
;----------------------------------------------------------------------------
	mov addy,z80hl,lsr#16
;----------------------------------------------------------------------------
_DDCB3E;	SRL (IX+d)
;----------------------------------------------------------------------------
	readmem8
	opSRLb
	writemem8
	fetch 15
;----------------------------------------------------------------------------
_CB3F;		SRL A
;----------------------------------------------------------------------------
	opSRLA
;----------------------------------------------------------------------------


;----------------------------------------------------------------------------
_CB40;		BIT x,B		, actually CB-40,48,50,58,60,68 & 70
;----------------------------------------------------------------------------
	opBITH z80bc
;----------------------------------------------------------------------------
_CB41;		BIT x,C		, actually CB-41,49,51,59,61,69 & 71
;----------------------------------------------------------------------------
	opBITL z80bc
;----------------------------------------------------------------------------
_CB42;		BIT x,D		, actually CB-42,4A,52,5A,62,6A & 72
;----------------------------------------------------------------------------
	opBITH z80de
;----------------------------------------------------------------------------
_CB43;		BIT x,E		, actually CB-43,4B,53,5B,63,6B & 73
;----------------------------------------------------------------------------
	opBITL z80de
;----------------------------------------------------------------------------
_CB44;		BIT x,H		, actually CB-44,4C,54,5C,64,6C & 74
;----------------------------------------------------------------------------
	opBITH z80hl
;----------------------------------------------------------------------------
_CB45;		BIT x,L		, actually CB-45,4D,55,5D,65,6D & 75
;----------------------------------------------------------------------------
	opBITL z80hl
;----------------------------------------------------------------------------
_CB47;		BIT x,A		, actually CB-47,4F,57,5F,67,6F & 77
;----------------------------------------------------------------------------
	opBITH z80a
;----------------------------------------------------------------------------
_CB46;		BIT 0,(HL)
;----------------------------------------------------------------------------
	mov addy,z80hl,lsr#16
;----------------------------------------------------------------------------
_DDCB46;	BIT 0,(IX+d)
;----------------------------------------------------------------------------
	opBITmem 0
;----------------------------------------------------------------------------
_CB4E;		BIT 1,(HL)
;----------------------------------------------------------------------------
	mov addy,z80hl,lsr#16
;----------------------------------------------------------------------------
_DDCB4E;	BIT 1,(IX+d)
;----------------------------------------------------------------------------
	opBITmem 1
;----------------------------------------------------------------------------
_CB56;		BIT 2,(HL)
;----------------------------------------------------------------------------
	mov addy,z80hl,lsr#16
;----------------------------------------------------------------------------
_DDCB56;	BIT 2,(IX+d)
;----------------------------------------------------------------------------
	opBITmem 2
;----------------------------------------------------------------------------
_CB5E;		BIT 3,(HL)
;----------------------------------------------------------------------------
	mov addy,z80hl,lsr#16
;----------------------------------------------------------------------------
_DDCB5E;	BIT 3,(IX+d)
;----------------------------------------------------------------------------
	opBITmem 3
;----------------------------------------------------------------------------
_CB66;		BIT 4,(HL)
;----------------------------------------------------------------------------
	mov addy,z80hl,lsr#16
;----------------------------------------------------------------------------
_DDCB66;	BIT 4,(IX+d)
;----------------------------------------------------------------------------
	opBITmem 4
;----------------------------------------------------------------------------
_CB6E;		BIT 5,(HL)
;----------------------------------------------------------------------------
	mov addy,z80hl,lsr#16
;----------------------------------------------------------------------------
_DDCB6E;	BIT 5,(IX+d)
;----------------------------------------------------------------------------
	opBITmem 5
;----------------------------------------------------------------------------
_CB76;		BIT 6,(HL)
;----------------------------------------------------------------------------
	mov addy,z80hl,lsr#16
;----------------------------------------------------------------------------
_DDCB76;	BIT 6,(IX+d)
;----------------------------------------------------------------------------
	opBITmem 6
;----------------------------------------------------------------------------
_CB7E;		BIT 7,(HL)
;----------------------------------------------------------------------------
	mov addy,z80hl,lsr#16
;----------------------------------------------------------------------------
_DDCB7E;	BIT 7,(IX+d)
;----------------------------------------------------------------------------
	opBIT7mem
;----------------------------------------------------------------------------
_CB78;		BIT 7,B
;----------------------------------------------------------------------------
	opBIT7H z80bc
;----------------------------------------------------------------------------
_CB79;		BIT 7,C
;----------------------------------------------------------------------------
	opBIT7L z80bc
;----------------------------------------------------------------------------
_CB7A;		BIT 7,D
;----------------------------------------------------------------------------
	opBIT7H z80de
;----------------------------------------------------------------------------
_CB7B;		BIT 7,E
;----------------------------------------------------------------------------
	opBIT7L z80de
;----------------------------------------------------------------------------
_CB7C;		BIT 7,H
;----------------------------------------------------------------------------
	opBIT7H z80hl
;----------------------------------------------------------------------------
_CB7D;		BIT 7,L
;----------------------------------------------------------------------------
	opBIT7L z80hl
;----------------------------------------------------------------------------
_CB7F;		BIT 7,A
;----------------------------------------------------------------------------
	opBIT7H z80a
;----------------------------------------------------------------------------


;----------------------------------------------------------------------------
_CB80;		RES x,B		, actually CB-80,88,90,98,A0,A8,B0 & B8
;----------------------------------------------------------------------------
	opRESH z80bc
;----------------------------------------------------------------------------
_CB81;		RES x,C		, actually CB-81,89,81,89,A1,A9,B1 & B9
;----------------------------------------------------------------------------
	opRESL z80bc
;----------------------------------------------------------------------------
_CB82;		RES x,D		, actually CB-82,8A,92,9A,A2,AA,B2 & BA
;----------------------------------------------------------------------------
	opRESH z80de
;----------------------------------------------------------------------------
_CB83;		RES x,E		, actually CB-83,8B,93,9B,A3,AB,B3 & BB
;----------------------------------------------------------------------------
	opRESL z80de
;----------------------------------------------------------------------------
_CB84;		RES x,H		, actually CB-84,8C,94,9C,A4,AC,B4 & BC
;----------------------------------------------------------------------------
	opRESH z80hl
;----------------------------------------------------------------------------
_CB85;		RES x,L		, actually CB-85,8D,95,9D,A5,AD,B5 & BD
;----------------------------------------------------------------------------
	opRESL z80hl
;----------------------------------------------------------------------------
_CB86;		RES 0,(HL)
;----------------------------------------------------------------------------
	mov addy,z80hl,lsr#16
;----------------------------------------------------------------------------
_DDCB86;	RES 0,(IX+d)
;----------------------------------------------------------------------------
	opRESmem 0
;----------------------------------------------------------------------------
_CB8E;		RES 1,(HL)
;----------------------------------------------------------------------------
	mov addy,z80hl,lsr#16
;----------------------------------------------------------------------------
_DDCB8E;	RES 1,(IX+d)
;----------------------------------------------------------------------------
	opRESmem 1
;----------------------------------------------------------------------------
_CB96;		RES 2,(HL)
;----------------------------------------------------------------------------
	mov addy,z80hl,lsr#16
;----------------------------------------------------------------------------
_DDCB96;	RES 2,(IX+d)
;----------------------------------------------------------------------------
	opRESmem 2
;----------------------------------------------------------------------------
_CB9E;		RES 3,(HL)
;----------------------------------------------------------------------------
	mov addy,z80hl,lsr#16
;----------------------------------------------------------------------------
_DDCB9E;	RES 3,(IX+d)
;----------------------------------------------------------------------------
	opRESmem 3
;----------------------------------------------------------------------------
_CBA6;		RES 4,(HL)
;----------------------------------------------------------------------------
	mov addy,z80hl,lsr#16
;----------------------------------------------------------------------------
_DDCBA6;	RES 4,(IX+d)
;----------------------------------------------------------------------------
	opRESmem 4
;----------------------------------------------------------------------------
_CBAE;		RES 5,(HL)
;----------------------------------------------------------------------------
	mov addy,z80hl,lsr#16
;----------------------------------------------------------------------------
_DDCBAE;	RES 5,(IX+d)
;----------------------------------------------------------------------------
	opRESmem 5
;----------------------------------------------------------------------------
_CBB6;		RES 6,(HL)
;----------------------------------------------------------------------------
	mov addy,z80hl,lsr#16
;----------------------------------------------------------------------------
_DDCBB6;	RES 6,(IX+d)
;----------------------------------------------------------------------------
	opRESmem 6
;----------------------------------------------------------------------------
_CBBE;		RES 7,(HL)
;----------------------------------------------------------------------------
	mov addy,z80hl,lsr#16
;----------------------------------------------------------------------------
_DDCBBE;	RES 7,(IX+d)
;----------------------------------------------------------------------------
	opRESmem 7
;----------------------------------------------------------------------------
_CB87;		RES x,A		, actually CB-87,8F,97,9F,A7,AF,B7 & BF
;----------------------------------------------------------------------------
	opRESH z80a
;----------------------------------------------------------------------------


;----------------------------------------------------------------------------
_CBC0;		SET x,B		, actually CB-C0,C8,D0,D8,E0,E8,F0 & F8
;----------------------------------------------------------------------------
	opSETH z80bc
;----------------------------------------------------------------------------
_CBC1;		SET x,C		, actually CB-C1,C9,D1,D9,E1,E9,F1 & F9
;----------------------------------------------------------------------------
	opSETL z80bc
;----------------------------------------------------------------------------
_CBC2;		SET x,D		, actually CB-C2,CA,D2,DA,E2,EA,F2 & FA
;----------------------------------------------------------------------------
	opSETH z80de
;----------------------------------------------------------------------------
_CBC3;		SET x,E		, actually CB-C3,CB,D3,DB,E3,EB,F3 & FB
;----------------------------------------------------------------------------
	opSETL z80de
;----------------------------------------------------------------------------
_CBC4;		SET x,H		, actually CB-C4,CC,D4,DC,E4,EC,F4 & FC
;----------------------------------------------------------------------------
	opSETH z80hl
;----------------------------------------------------------------------------
_CBC5;		SET x,L		, actually CB-C5,CD,D5,DD,E5,ED,F5 & FD
;----------------------------------------------------------------------------
	opSETL z80hl
;----------------------------------------------------------------------------
_CBC6;		SET 0,(HL)
;----------------------------------------------------------------------------
	mov addy,z80hl,lsr#16
;----------------------------------------------------------------------------
_DDCBC6;	SET 0,(IX+d)
;----------------------------------------------------------------------------
	opSETmem 0
;----------------------------------------------------------------------------
_CBCE;		SET 1,(HL)
;----------------------------------------------------------------------------
	mov addy,z80hl,lsr#16
;----------------------------------------------------------------------------
_DDCBCE;	SET 1,(IX+d)
;----------------------------------------------------------------------------
	opSETmem 1
;----------------------------------------------------------------------------
_CBD6;		SET 2,(HL)
;----------------------------------------------------------------------------
	mov addy,z80hl,lsr#16
;----------------------------------------------------------------------------
_DDCBD6;	SET 2,(IX+d)
;----------------------------------------------------------------------------
	opSETmem 2
;----------------------------------------------------------------------------
_CBDE;		SET 3,(HL)
;----------------------------------------------------------------------------
	mov addy,z80hl,lsr#16
;----------------------------------------------------------------------------
_DDCBDE;	SET 3,(IX+d)
;----------------------------------------------------------------------------
	opSETmem 3
;----------------------------------------------------------------------------
_CBE6;		SET 4,(HL)
;----------------------------------------------------------------------------
	mov addy,z80hl,lsr#16
;----------------------------------------------------------------------------
_DDCBE6;	SET 4,(IX+d)
;----------------------------------------------------------------------------
	opSETmem 4
;----------------------------------------------------------------------------
_CBEE;		SET 5,(HL)
;----------------------------------------------------------------------------
	mov addy,z80hl,lsr#16
;----------------------------------------------------------------------------
_DDCBEE;	SET 5,(IX+d)
;----------------------------------------------------------------------------
	opSETmem 5
;----------------------------------------------------------------------------
_CBF6;		SET 6,(HL)
;----------------------------------------------------------------------------
	mov addy,z80hl,lsr#16
;----------------------------------------------------------------------------
_DDCBF6;	SET 6,(IX+d)
;----------------------------------------------------------------------------
	opSETmem 6
;----------------------------------------------------------------------------
_CBFE;		SET 7,(HL)
;----------------------------------------------------------------------------
	mov addy,z80hl,lsr#16
;----------------------------------------------------------------------------
_DDCBFE;	SET 7,(IX+d)
;----------------------------------------------------------------------------
	opSETmem 7
;----------------------------------------------------------------------------
_CBC7;		SET x,A		, actually CB-C7,CF,D7,DF,E7,EF,F7 & FF
;----------------------------------------------------------------------------
	opSETH z80a
;----------------------------------------------------------------------------


;----------------------------------------------------------------------------
_DDDD
;----------------------------------------------------------------------------
	eatcycles 4
;----------------------------------------------------------------------------
_DD;	Extensions
;----------------------------------------------------------------------------
	adr z80xy,z80_ix
	adr r1,ddfd_table
	ldrb r0,[z80pc],#1
	ldr pc,[r1,r0,lsl#2]

;----------------------------------------------------------------------------
_DDFD
;----------------------------------------------------------------------------
	eatcycles 4
;----------------------------------------------------------------------------
_FD;	Extensions
;----------------------------------------------------------------------------
	adrl z80xy,z80_iy
_DDFD_ext;
	ldrb r0,[z80pc],#1
	ldr pc,[pc,r0,lsl#2]
	DCD 0
;----------------------------------------------------------------------------
ddfd_table
	DCD _DDNF,_DDNF,_DDNF,_DDNF,_DDNF,_DDNF,_DDNF,_DDNF,_DDNF,_DD09,_DDNF,_DDNF,_DDNF,_DDNF,_DDNF,_DDNF
	DCD _DDNF,_DDNF,_DDNF,_DDNF,_DDNF,_DDNF,_DDNF,_DDNF,_DDNF,_DD19,_DDNF,_DDNF,_DDNF,_DDNF,_DDNF,_DDNF
	DCD _DDNF,_DD21,_DD22,_DD23,_DD24,_DD25,_DD26,_DDNF,_DDNF,_DD29,_DD2A,_DD2B,_DD2C,_DD2D,_DD2E,_DDNF
	DCD _DDNF,_DDNF,_DDNF,_DDNF,_DD34,_DD35,_DD36,_DDNF,_DDNF,_DD39,_DDNF,_DDNF,_DDNF,_DDNF,_DDNF,_DDNF
	DCD _DDNF,_DDNF,_DDNF,_DDNF,_DD44,_DD45,_DD46,_DDNF,_DDNF,_DDNF,_DDNF,_DDNF,_DD4C,_DD4D,_DD4E,_DDNF
	DCD _DDNF,_DDNF,_DDNF,_DDNF,_DD54,_DD55,_DD56,_DDNF,_DDNF,_DDNF,_DDNF,_DDNF,_DD5C,_DD5D,_DD5E,_DDNF
	DCD _DD60,_DD61,_DD62,_DD63,_DDNF,_DD65,_DD66,_DD67,_DD68,_DD69,_DD6A,_DD6B,_DD6C,_DDNF,_DD6E,_DD6F
	DCD _DD70,_DD71,_DD72,_DD73,_DD74,_DD75,_DDNF,_DD77,_DDNF,_DDNF,_DDNF,_DDNF,_DD7C,_DD7D,_DD7E,_DDNF
	DCD _DDNF,_DDNF,_DDNF,_DDNF,_DD84,_DD85,_DD86,_DDNF,_DDNF,_DDNF,_DDNF,_DDNF,_DD8C,_DD8D,_DD8E,_DDNF
	DCD _DDNF,_DDNF,_DDNF,_DDNF,_DD94,_DD95,_DD96,_DDNF,_DDNF,_DDNF,_DDNF,_DDNF,_DD9C,_DD9D,_DD9E,_DDNF
	DCD _DDNF,_DDNF,_DDNF,_DDNF,_DDA4,_DDA5,_DDA6,_DDNF,_DDNF,_DDNF,_DDNF,_DDNF,_DDAC,_DDAD,_DDAE,_DDNF
	DCD _DDNF,_DDNF,_DDNF,_DDNF,_DDB4,_DDB5,_DDB6,_DDNF,_DDNF,_DDNF,_DDNF,_DDNF,_DDBC,_DDBD,_DDBE,_DDNF
	DCD _DDNF,_DDNF,_DDNF,_DDNF,_DDNF,_DDNF,_DDNF,_DDNF,_DDNF,_DDNF,_DDNF,_DDCB,_DDNF,_DDNF,_DDNF,_DDNF
	DCD _DDNF,_DDNF,_DDNF,_DDNF,_DDNF,_DDNF,_DDNF,_DDNF,_DDNF,_DDNF,_DDNF,_DDNF,_DDNF,_DDDD,_DDNF,_DDNF
	DCD _DDNF,_DDE1,_DDNF,_DDE3,_DDNF,_DDE5,_DDNF,_DDNF,_DDNF,_DDE9,_DDNF,_DDNF,_DDNF,_DDNF,_DDNF,_DDNF
	DCD _DDNF,_DDNF,_DDNF,_DDNF,_DDNF,_DDNF,_DDNF,_DDNF,_DDNF,_DDF9,_DDNF,_DDNF,_DDNF,_DDFD,_DDNF,_DDNF

;----------------------------------------------------------------------------
_DDNF;
;----------------------------------------------------------------------------
;	mov r11,r11				;No$GBA breakpoint
;	orr r1,r0,r1,lsl#8
	eatcycles 4
	ldr pc,[z80optbl,r0,lsl#2]
;----------------------------------------------------------------------------
_DD09;	ADD IX,BC
;----------------------------------------------------------------------------
	ldr r0,[z80xy]
	opADD16 r0,z80bc
	str r0,[z80xy]
	fetch 15
;----------------------------------------------------------------------------
_DD19;	ADD IX,DE
;----------------------------------------------------------------------------
	ldr r0,[z80xy]
	opADD16 r0,z80de
	str r0,[z80xy]
	fetch 15
;----------------------------------------------------------------------------
_DD21;	LD IX,#nnnn
;----------------------------------------------------------------------------
	opLDIM16
	strh r0,[z80xy,#2]
	fetch 14
;----------------------------------------------------------------------------
_DD22;	LD (NN),IX		write IX to (NN)
;----------------------------------------------------------------------------
	ldrb r0,[z80pc],#1
	ldrb r1,[z80pc],#1
	orr addy,r0,r1,lsl#8
	ldrb r0,[z80xy,#2]
	stmfd sp!,{lr}
	writemem8
	ldmfd sp!,{lr}
	add addy,addy,#1
	ldrb r0,[z80xy,#3]
	writemem8
	fetch 20
;----------------------------------------------------------------------------
_DD23;	INC IX
;----------------------------------------------------------------------------
	ldr r0,[z80xy]
	opINC16 r0
	str r0,[z80xy]
	fetch 10
;----------------------------------------------------------------------------
_DD24;	INC IXh
;----------------------------------------------------------------------------
	ldr r0,[z80xy]
	opINC8H r0
	str r0,[z80xy]
	fetch 8				;9 cycles?
;----------------------------------------------------------------------------
_DD25;	DEC IXh
;----------------------------------------------------------------------------
	ldr r0,[z80xy]
	opDEC8H r0
	str r0,[z80xy]
	fetch 8				;9 cycles?
;----------------------------------------------------------------------------
_DD26;	LD IXh,#nn
;----------------------------------------------------------------------------
	ldrb r0,[z80pc],#1
	strb r0,[z80xy,#3]
	fetch 11			;all 8bit acces to IX/IY is 9 cycles?
;----------------------------------------------------------------------------
_DD29;	ADD IX,IX
;----------------------------------------------------------------------------
	ldr r0,[z80xy]
	opADD16_2 r0
	str r0,[z80xy]
	fetch 15
;----------------------------------------------------------------------------
_DD2A;	LD IX,(NN)		load IX from (NN)
;----------------------------------------------------------------------------
	ldrb r0,[z80pc],#1
	ldrb r1,[z80pc],#1
	orr addy,r0,r1,lsl#8
	readmem8
	add addy,addy,#1
	and r1,addy,#0xFC00
	ldr r1,[r2,r1,lsr#8]
	ldrb r1,[r1,addy]
	orr r0,r0,r1,lsl#8
	strh r0,[z80xy,#2]
	fetch 20
;----------------------------------------------------------------------------
_DD2B;	DEC IX
;----------------------------------------------------------------------------
	ldr r0,[z80xy]
	opDEC16 r0
	str r0,[z80xy]
	fetch 10
;----------------------------------------------------------------------------
_DD2C;	INC IXl
;----------------------------------------------------------------------------
	ldrb r0,[z80xy,#2]
	opINC8b
	strb r0,[z80xy,#2]
	fetch 8
;----------------------------------------------------------------------------
_DD2D;	DEC IXl
;----------------------------------------------------------------------------
	ldrb r0,[z80xy,#2]
	opDEC8b
	strb r0,[z80xy,#2]
	fetch 8
;----------------------------------------------------------------------------
_DD2E;	LD IXl,#nn
;----------------------------------------------------------------------------
	ldrb r0,[z80pc],#1
	strb r0,[z80xy,#2]
	fetch 11
;----------------------------------------------------------------------------
_DD34;	INC (IX+d)
;----------------------------------------------------------------------------
	CalcIXd
	eatcycles 12
	b _DD34_
;----------------------------------------------------------------------------
_DD35;	DEC (IX+d)
;----------------------------------------------------------------------------
	CalcIXd
	eatcycles 12
	b _DD35_
;----------------------------------------------------------------------------
_DD36;	LD (IX+d),#n
;----------------------------------------------------------------------------
	CalcIXd
	eatcycles 9
	b _DD36_
;----------------------------------------------------------------------------
_DD39;	ADD IX,SP
;----------------------------------------------------------------------------
	ldr r0,[z80xy]
	opADD16 r0,z80sp
	str r0,[z80xy]
	fetch 15
;----------------------------------------------------------------------------
_DD44;	LD B,IXh
;----------------------------------------------------------------------------
	add z80xy,z80xy,#1
;----------------------------------------------------------------------------
_DD45;	LD B,IXl
;----------------------------------------------------------------------------
	ldrb r0,[z80xy,#2]
	and z80bc,z80bc,#0x00FF0000
	orr z80bc,z80bc,r0,lsl#24
	fetch 8
;----------------------------------------------------------------------------
_DD46;	LD B,(IX+d)
;----------------------------------------------------------------------------
	CalcIXd
	eatcycles 12
	b _DD46_
;----------------------------------------------------------------------------
_DD4C;	LD C,IXh
;----------------------------------------------------------------------------
	add z80xy,z80xy,#1
;----------------------------------------------------------------------------
_DD4D;	LD C,IXl
;----------------------------------------------------------------------------
	ldrb r0,[z80xy,#2]
	and z80bc,z80bc,#0xFF000000
	orr z80bc,z80bc,r0,lsl#16
	fetch 8
;----------------------------------------------------------------------------
_DD4E;	LD C,(IX+d)
;----------------------------------------------------------------------------
	CalcIXd
	eatcycles 12
	b _DD4E_
;----------------------------------------------------------------------------
_DD54;	LD D,IXh
;----------------------------------------------------------------------------
	add z80xy,z80xy,#1
;----------------------------------------------------------------------------
_DD55;	LD D,IXl
;----------------------------------------------------------------------------
	ldrb r0,[z80xy,#2]
	and z80de,z80de,#0x00FF0000
	orr z80de,z80de,r0,lsl#24
	fetch 8
;----------------------------------------------------------------------------
_DD56;	LD D,(IX+d)
;----------------------------------------------------------------------------
	CalcIXd
	eatcycles 12
	b _DD56_
;----------------------------------------------------------------------------
_DD5C;	LD E,IXh
;----------------------------------------------------------------------------
	add z80xy,z80xy,#1
;----------------------------------------------------------------------------
_DD5D;	LD E,IXl
;----------------------------------------------------------------------------
	ldrb r0,[z80xy,#2]
	and z80de,z80de,#0xFF000000
	orr z80de,z80de,r0,lsl#16
	fetch 8
;----------------------------------------------------------------------------
_DD5E;	LD E,(IX+d)
;----------------------------------------------------------------------------
	CalcIXd
	eatcycles 12
	b _DD5E_
;----------------------------------------------------------------------------
_DD60;	LD IXh,B
;----------------------------------------------------------------------------
	mov r0,z80bc,lsr#24
	strb r0,[z80xy,#3]
	fetch 8
;----------------------------------------------------------------------------
_DD61;	LD IXh,C
;----------------------------------------------------------------------------
	mov r0,z80bc,lsr#16
	strb r0,[z80xy,#3]
	fetch 8
;----------------------------------------------------------------------------
_DD62;	LD IXh,D
;----------------------------------------------------------------------------
	mov r0,z80de,lsr#24
	strb r0,[z80xy,#3]
	fetch 8
;----------------------------------------------------------------------------
_DD63;	LD IXh,E
;----------------------------------------------------------------------------
	mov r0,z80de,lsr#16
	strb r0,[z80xy,#3]
	fetch 8
;----------------------------------------------------------------------------
_DD65;	LD IXh,IXl
;----------------------------------------------------------------------------
	ldrb r0,[z80xy,#2]
	strb r0,[z80xy,#3]
	fetch 8
;----------------------------------------------------------------------------
_DD66;	LD H,(IX+d)
;----------------------------------------------------------------------------
	CalcIXd
	eatcycles 12
	b _DD66_
;----------------------------------------------------------------------------
_DD67;	LD IXh,A
;----------------------------------------------------------------------------
	mov r0,z80a,lsr#24
	strb r0,[z80xy,#3]
	fetch 8
;----------------------------------------------------------------------------
_DD68;	LD IXl,B
;----------------------------------------------------------------------------
	mov r0,z80bc,lsr#24
	strb r0,[z80xy,#2]
	fetch 8
;----------------------------------------------------------------------------
_DD69;	LD IXl,C
;----------------------------------------------------------------------------
	mov r0,z80bc,lsr#16
	strb r0,[z80xy,#2]
	fetch 8
;----------------------------------------------------------------------------
_DD6A;	LD IXl,D
;----------------------------------------------------------------------------
	mov r0,z80de,lsr#24
	strb r0,[z80xy,#2]
	fetch 8
;----------------------------------------------------------------------------
_DD6B;	LD IXl,E
;----------------------------------------------------------------------------
	mov r0,z80de,lsr#16
	strb r0,[z80xy,#2]
	fetch 8
;----------------------------------------------------------------------------
_DD6C;	LD IXl,IXh
;----------------------------------------------------------------------------
	ldrb r0,[z80xy,#3]
	strb r0,[z80xy,#2]
	fetch 8
;----------------------------------------------------------------------------
_DD6E;	LD L,(IX+d)
;----------------------------------------------------------------------------
	CalcIXd
	eatcycles 12
	b _DD6E_
;----------------------------------------------------------------------------
_DD6F;	LD IXl,A
;----------------------------------------------------------------------------
	mov r0,z80a,lsr#24
	strb r0,[z80xy,#2]
	fetch 8
;----------------------------------------------------------------------------
_DD70;	LD (IX+d),B
;----------------------------------------------------------------------------
	CalcIXd
	eatcycles 12
	b _DD70_
;----------------------------------------------------------------------------
_DD71;	LD (IX+d),C
;----------------------------------------------------------------------------
	CalcIXd
	eatcycles 12
	b _DD71_
;----------------------------------------------------------------------------
_DD72;	LD (IX+d),D
;----------------------------------------------------------------------------
	CalcIXd
	eatcycles 12
	b _DD72_
;----------------------------------------------------------------------------
_DD73;	LD (IX+d),E
;----------------------------------------------------------------------------
	CalcIXd
	eatcycles 12
	b _DD73_
;----------------------------------------------------------------------------
_DD74;	LD (IX+d),H
;----------------------------------------------------------------------------
	CalcIXd
	eatcycles 12
	b _DD74_
;----------------------------------------------------------------------------
_DD75;	LD (IX+d),L
;----------------------------------------------------------------------------
	CalcIXd
	eatcycles 12
	b _DD75_
;----------------------------------------------------------------------------
_DD77;	LD (IX+d),A
;----------------------------------------------------------------------------
	CalcIXd
	eatcycles 12
	b _DD77_
;----------------------------------------------------------------------------
_DD7C;	LD A,IXh
;----------------------------------------------------------------------------
	add z80xy,z80xy,#1
;----------------------------------------------------------------------------
_DD7D;	LD A,IXl
;----------------------------------------------------------------------------
	ldrb r0,[z80xy,#2]
	mov z80a,r0,lsl#24
	fetch 8
;----------------------------------------------------------------------------
_DD7E;	LD A,(IX+d)
;----------------------------------------------------------------------------
	CalcIXd
	eatcycles 12
	b _DD7E_
;----------------------------------------------------------------------------
_DD84;	ADD IXh
;----------------------------------------------------------------------------
	add z80xy,z80xy,#1
;----------------------------------------------------------------------------
_DD85;	ADD IXl
;----------------------------------------------------------------------------
	ldrb r0,[z80xy,#2]
	opADDb
	fetch 8
;----------------------------------------------------------------------------
_DD86;	ADD (IX+d)
;----------------------------------------------------------------------------
	CalcIXd
	eatcycles 12
	b _DD86_
;----------------------------------------------------------------------------
_DD8C;	ADC IXh
;----------------------------------------------------------------------------
	add z80xy,z80xy,#1
;----------------------------------------------------------------------------
_DD8D;	ADC IXl
;----------------------------------------------------------------------------
	ldrb r0,[z80xy,#2]
	opADCb
	fetch 8
;----------------------------------------------------------------------------
_DD8E;	ADC (IX+d)
;----------------------------------------------------------------------------
	CalcIXd
	eatcycles 12
	b _DD8E_
;----------------------------------------------------------------------------
_DD94;	SUB IXh
;----------------------------------------------------------------------------
	add z80xy,z80xy,#1
;----------------------------------------------------------------------------
_DD95;	SUB IXl
;----------------------------------------------------------------------------
	ldrb r0,[z80xy,#2]
	opSUBb
	fetch 8
;----------------------------------------------------------------------------
_DD96;	SUB (IX+d)
;----------------------------------------------------------------------------
	CalcIXd
	eatcycles 12
	b _DD96_
;----------------------------------------------------------------------------
_DD9C;	SBC IXh
;----------------------------------------------------------------------------
	add z80xy,z80xy,#1
;----------------------------------------------------------------------------
_DD9D;	SBC IXl
;----------------------------------------------------------------------------
	ldrb r0,[z80xy,#2]
	opSBCb
	fetch 8
;----------------------------------------------------------------------------
_DD9E;	SBC (IX+d)
;----------------------------------------------------------------------------
	CalcIXd
	eatcycles 12
	b _DD9E_
;----------------------------------------------------------------------------
_DDA4;	AND IXh
;----------------------------------------------------------------------------
	add z80xy,z80xy,#1
;----------------------------------------------------------------------------
_DDA5;	AND IXl
;----------------------------------------------------------------------------
	ldrb r0,[z80xy,#2]
	opANDb
	fetch 8
;----------------------------------------------------------------------------
_DDA6;	AND (IX+d)
;----------------------------------------------------------------------------
	CalcIXd
	eatcycles 12
	b _DDA6_
;----------------------------------------------------------------------------
_DDAC;	XOR IXh
;----------------------------------------------------------------------------
	add z80xy,z80xy,#1
;----------------------------------------------------------------------------
_DDAD;	XOR IXl
;----------------------------------------------------------------------------
	ldrb r0,[z80xy,#2]
	opXORb
	fetch 8
;----------------------------------------------------------------------------
_DDAE;	XOR (IX+d)
;----------------------------------------------------------------------------
	CalcIXd
	eatcycles 12
	b _DDAE_
;----------------------------------------------------------------------------
_DDB4;	OR IXh
;----------------------------------------------------------------------------
	add z80xy,z80xy,#1
;----------------------------------------------------------------------------
_DDB5;	OR IXl
;----------------------------------------------------------------------------
	ldrb r0,[z80xy,#2]
	opORb
	fetch 8
;----------------------------------------------------------------------------
_DDB6;	OR (IX+d)
;----------------------------------------------------------------------------
	CalcIXd
	eatcycles 12
	b _DDB6_
;----------------------------------------------------------------------------
_DDBC;	CP IXh
;----------------------------------------------------------------------------
	add z80xy,z80xy,#1
;----------------------------------------------------------------------------
_DDBD;	CP IXl
;----------------------------------------------------------------------------
	ldrb r0,[z80xy,#2]
	opCPb
	fetch 8
;----------------------------------------------------------------------------
_DDBE;	CP (IX+d)
;----------------------------------------------------------------------------
	CalcIXd
	eatcycles 12
	b _DDBE_
;----------------------------------------------------------------------------
_DDE1;	POP IX
;----------------------------------------------------------------------------
	pop16 r0
	strh r0,[z80xy,#2]
	fetch 14
;----------------------------------------------------------------------------
_DDE3;	EX (SP),IX
;----------------------------------------------------------------------------
	and r1,z80sp,#0xFC000000
	adr r2,memmap_tbl
	ldr r1,[r2,r1,lsr#24]

	ldrb r2,[r1,z80sp,lsr#16]
	ldrh r0,[z80xy,#2]
	strb r0,[r1,z80sp,lsr#16]
	add addy,z80sp,#0x00010000
	mov r0,r0,lsr#8
	ldrb addy,[r1,addy,lsr#16]!
	strb r0,[r1]
	orr r2,r2,addy,lsl#8
	strh r2,[z80xy,#2]
	fetch 23
;----------------------------------------------------------------------------
_DDE5;	PUSH IX
;----------------------------------------------------------------------------
	ldrh r0,[z80xy,#2]
	push16
	fetch 15
;----------------------------------------------------------------------------
_DDE9;	JP IX
;----------------------------------------------------------------------------
	ldrh z80pc,[z80xy,#2]
	encodePC
	fetch 8
;----------------------------------------------------------------------------
_DDF9;	LD SP,IX
;----------------------------------------------------------------------------
	ldr z80sp,[z80xy]
	fetch 10

;----------------------------------------------------------------------------
_DDCB;	Extensions
;----------------------------------------------------------------------------
	eatcycles 8
	CalcIXd
	ldrb r0,[z80pc],#1
	ldr pc,[pc,r0,lsl#2]
	DCD 0
;----------------------------------------------------------------------------
ddcb_table
	DCD _DDCBNF,_DDCBNF,_DDCBNF,_DDCBNF,_DDCBNF,_DDCBNF,_DDCB06,_DDCBNF,_DDCBNF,_DDCBNF,_DDCBNF,_DDCBNF,_DDCBNF,_DDCBNF,_DDCB0E,_DDCBNF
	DCD _DDCBNF,_DDCBNF,_DDCBNF,_DDCBNF,_DDCBNF,_DDCBNF,_DDCB16,_DDCBNF,_DDCBNF,_DDCBNF,_DDCBNF,_DDCBNF,_DDCBNF,_DDCBNF,_DDCB1E,_DDCBNF
	DCD _DDCBNF,_DDCBNF,_DDCBNF,_DDCBNF,_DDCBNF,_DDCBNF,_DDCB26,_DDCBNF,_DDCBNF,_DDCBNF,_DDCBNF,_DDCBNF,_DDCBNF,_DDCBNF,_DDCB2E,_DDCBNF
	DCD _DDCBNF,_DDCBNF,_DDCBNF,_DDCBNF,_DDCBNF,_DDCBNF,_DDCB36,_DDCBNF,_DDCBNF,_DDCBNF,_DDCBNF,_DDCBNF,_DDCBNF,_DDCBNF,_DDCB3E,_DDCBNF
	DCD _DDCBNF,_DDCBNF,_DDCBNF,_DDCBNF,_DDCBNF,_DDCBNF,_DDCB46,_DDCBNF,_DDCBNF,_DDCBNF,_DDCBNF,_DDCBNF,_DDCBNF,_DDCBNF,_DDCB4E,_DDCBNF
	DCD _DDCBNF,_DDCBNF,_DDCBNF,_DDCBNF,_DDCBNF,_DDCBNF,_DDCB56,_DDCBNF,_DDCBNF,_DDCBNF,_DDCBNF,_DDCBNF,_DDCBNF,_DDCBNF,_DDCB5E,_DDCBNF
	DCD _DDCBNF,_DDCBNF,_DDCBNF,_DDCBNF,_DDCBNF,_DDCBNF,_DDCB66,_DDCBNF,_DDCBNF,_DDCBNF,_DDCBNF,_DDCBNF,_DDCBNF,_DDCBNF,_DDCB6E,_DDCBNF
	DCD _DDCBNF,_DDCBNF,_DDCBNF,_DDCBNF,_DDCBNF,_DDCBNF,_DDCB76,_DDCBNF,_DDCBNF,_DDCBNF,_DDCBNF,_DDCBNF,_DDCBNF,_DDCBNF,_DDCB7E,_DDCBNF
	DCD _DDCBNF,_DDCBNF,_DDCBNF,_DDCBNF,_DDCBNF,_DDCBNF,_DDCB86,_DDCBNF,_DDCBNF,_DDCBNF,_DDCBNF,_DDCBNF,_DDCBNF,_DDCBNF,_DDCB8E,_DDCBNF
	DCD _DDCBNF,_DDCBNF,_DDCBNF,_DDCBNF,_DDCBNF,_DDCBNF,_DDCB96,_DDCBNF,_DDCBNF,_DDCBNF,_DDCBNF,_DDCBNF,_DDCBNF,_DDCBNF,_DDCB9E,_DDCBNF
	DCD _DDCBNF,_DDCBNF,_DDCBNF,_DDCBNF,_DDCBNF,_DDCBNF,_DDCBA6,_DDCBNF,_DDCBNF,_DDCBNF,_DDCBNF,_DDCBNF,_DDCBNF,_DDCBNF,_DDCBAE,_DDCBNF
	DCD _DDCBNF,_DDCBNF,_DDCBNF,_DDCBNF,_DDCBNF,_DDCBNF,_DDCBB6,_DDCBNF,_DDCBNF,_DDCBNF,_DDCBNF,_DDCBNF,_DDCBNF,_DDCBNF,_DDCBBE,_DDCBNF
	DCD _DDCBNF,_DDCBNF,_DDCBNF,_DDCBNF,_DDCBNF,_DDCBNF,_DDCBC6,_DDCBNF,_DDCBNF,_DDCBNF,_DDCBNF,_DDCBNF,_DDCBNF,_DDCBNF,_DDCBCE,_DDCBNF
	DCD _DDCBNF,_DDCBNF,_DDCBNF,_DDCBNF,_DDCBNF,_DDCBNF,_DDCBD6,_DDCBNF,_DDCBNF,_DDCBNF,_DDCBNF,_DDCBNF,_DDCBNF,_DDCBNF,_DDCBDE,_DDCBNF
	DCD _DDCBNF,_DDCBNF,_DDCBNF,_DDCBNF,_DDCBNF,_DDCBNF,_DDCBE6,_DDCBNF,_DDCBNF,_DDCBNF,_DDCBNF,_DDCBNF,_DDCBNF,_DDCBNF,_DDCBEE,_DDCBNF
	DCD _DDCBNF,_DDCBNF,_DDCBNF,_DDCBNF,_DDCBNF,_DDCBNF,_DDCBF6,_DDCBNF,_DDCBNF,_DDCBNF,_DDCBNF,_DDCBNF,_DDCBNF,_DDCBNF,_DDCBFE,_DDCBNF


;----------------------------------------------------------------------------
_ED;	Extensions
;----------------------------------------------------------------------------
	ldrb r0,[z80pc],#1
	ldr pc,[pc,r0,lsl#2]
	DCD 0
;----------------------------------------------------------------------------
ed_table
	DCD _EDNP,_EDNP,_EDNP,_EDNP,_EDNP,_EDNP,_EDNP,_EDNP,_EDNP,_EDNP,_EDNP,_EDNP,_EDNP,_EDNP,_EDNP,_EDNP
	DCD _EDNP,_EDNP,_EDNP,_EDNP,_EDNP,_EDNP,_EDNP,_EDNP,_EDNP,_EDNP,_EDNP,_EDNP,_EDNP,_EDNP,_EDNP,_EDNP
	DCD _EDNP,_EDNP,_EDNP,_EDNP,_EDNP,_EDNP,_EDNP,_EDNP,_EDNP,_EDNP,_EDNP,_EDNP,_EDNP,_EDNP,_EDNP,_EDNP
	DCD _EDNP,_EDNP,_EDNP,_EDNP,_EDNP,_EDNP,_EDNP,_EDNP,_EDNP,_EDNP,_EDNP,_EDNP,_EDNP,_EDNP,_EDNP,_EDNP
	DCD _ED40,_ED41,_ED42,_ED43,_ED44,_ED45,_ED46,_ED47,_ED48,_ED49,_ED4A,_ED4B,_ED44,_ED4D,_ED46,_ED4F
	DCD _ED50,_ED51,_ED52,_ED53,_ED44,_ED45,_ED56,_ED57,_ED58,_ED59,_ED5A,_ED5B,_ED44,_ED45,_ED5E,_ED5F
	DCD _ED60,_ED61,_ED62,_ED63,_ED44,_ED45,_ED46,_ED67,_ED68,_ED69,_ED6A,_ED6B,_ED44,_ED45,_ED46,_ED6F
	DCD _ED70,_ED71,_ED72,_ED73,_ED44,_ED45,_ED56,_EDNP,_ED78,_ED79,_ED7A,_ED7B,_ED44,_ED45,_ED5E,_EDNP
	DCD _EDNP,_EDNP,_EDNP,_EDNP,_EDNP,_EDNP,_EDNP,_EDNP,_EDNP,_EDNP,_EDNP,_EDNP,_EDNP,_EDNP,_EDNP,_EDNP
	DCD _EDNP,_EDNP,_EDNP,_EDNP,_EDNP,_EDNP,_EDNP,_EDNP,_EDNP,_EDNP,_EDNP,_EDNP,_EDNP,_EDNP,_EDNP,_EDNP
	DCD _EDA0,_EDA1,_EDA2,_EDA3,_EDNP,_EDNP,_EDNP,_EDNP,_EDA8,_EDA9,_EDAA,_EDAB,_EDNP,_EDNP,_EDNP,_EDNP
	DCD _EDB0,_EDB1,_EDB2,_EDB3,_EDNP,_EDNP,_EDNP,_EDNP,_EDB8,_EDB9,_EDBA,_EDBB,_EDNP,_EDNP,_EDNP,_EDNP
	DCD _EDNP,_EDNP,_EDNP,_EDNP,_EDNP,_EDNP,_EDNP,_EDNP,_EDNP,_EDNP,_EDNP,_EDNP,_EDNP,_EDNP,_EDNP,_EDNP
	DCD _EDNP,_EDNP,_EDNP,_EDNP,_EDNP,_EDNP,_EDNP,_EDNP,_EDNP,_EDNP,_EDNP,_EDNP,_EDNP,_EDNP,_EDNP,_EDNP
	DCD _EDNP,_EDNP,_EDNP,_EDNP,_EDNP,_EDNP,_EDNP,_EDNP,_EDNP,_EDNP,_EDNP,_EDNP,_EDNP,_EDNP,_EDNP,_EDNP
	DCD _EDNP,_EDNP,_EDNP,_EDNP,_EDNP,_EDNP,_EDNP,_EDNP,_EDNP,_EDNP,_EDNP,_EDNP,_EDNP,_EDNP,_EDNP,_EDNP

;----------------------------------------------------------------------------
_ED40;		IN B,(C)
;----------------------------------------------------------------------------
	opINrC
	and z80bc,z80bc,#0x00FF0000
	orr z80bc,z80bc,r0,lsl#24
	fetch 12
;----------------------------------------------------------------------------
_ED41;		OUT (C),B
;----------------------------------------------------------------------------
	opOUTCrH z80bc
;----------------------------------------------------------------------------
_ED42;		SBC HL,BC
;----------------------------------------------------------------------------
	opSBC16 z80bc
;----------------------------------------------------------------------------
_ED43;		LD (NN),BC
;----------------------------------------------------------------------------
	ldrb r0,[z80pc],#1
	ldrb r1,[z80pc],#1
	orr addy,r0,r1,lsl#8
	writemem16 z80bc
	fetch 20
;----------------------------------------------------------------------------
_ED44;		NEG A
;----------------------------------------------------------------------------
	rsbs z80a,z80a,#0
	mrs z80f,cpsr
	mov z80f,z80f,lsr#28					;@S,Z,V&C
	eor z80f,z80f,#PSR_C|PSR_n				;@invert C and set n.
	tst z80a,#0x0F000000					;@H, correct
	orrne z80f,z80f,#PSR_H
	fetch 8
;----------------------------------------------------------------------------
;_ED45;		RETN			Return from NMI, moved to ED4D
;----------------------------------------------------------------------------
;----------------------------------------------------------------------------
_ED46;		IM 0
;----------------------------------------------------------------------------
	strb z80a,z80_im						;@zero IM
	fetch 8
;----------------------------------------------------------------------------
_ED47;		LD I,A
;----------------------------------------------------------------------------
	mov r0,z80a,lsr#24
	strb r0,z80_i
	fetch 9
;----------------------------------------------------------------------------
_ED48;		IN C,(C)
;----------------------------------------------------------------------------
	opINrC
	and z80bc,z80bc,#0xFF000000
	orr z80bc,z80bc,r0,lsl#16
	fetch 12
;----------------------------------------------------------------------------
_ED49;		OUT (C),C
;----------------------------------------------------------------------------
	opOUTCrL z80bc
;----------------------------------------------------------------------------
_ED4A;		ADC HL,BC
;----------------------------------------------------------------------------
	opADC16 z80bc
;----------------------------------------------------------------------------
_ED4B;		LD BC,(NN)
;----------------------------------------------------------------------------
	ldrb r0,[z80pc],#1
	ldrb r1,[z80pc],#1
	orr addy,r0,r1,lsl#8
	readmem16 z80bc
	fetch 20
;----------------------------------------------------------------------------
;_ED4C;		NEG A
;----------------------------------------------------------------------------
;----------------------------------------------------------------------------
_ED45;		RETN			Return from NMI
;----------------------------------------------------------------------------
;----------------------------------------------------------------------------
_ED4D;		RETI			Return from IRQ
;----------------------------------------------------------------------------
	ldrb r0,z80_iff2
	strb r0,z80_iff1
	eatcycles 4

;	tst r0,#0xFF
;	ldrne r0,EiFixAdr
;	strne r0,nexttimeout
;	strne cycles,oldcycles
;	andne cycles,cycles,#CYC_MASK
	b _C9
;----------------------------------------------------------------------------
;_ED4E;		IM 0
;----------------------------------------------------------------------------
;----------------------------------------------------------------------------
_ED4F;		LD R,A
;----------------------------------------------------------------------------
	mov r0,z80a,lsr#24
	strb r0,z80_r
	fetch 9
;----------------------------------------------------------------------------
_ED50;		IN D,(C)
;----------------------------------------------------------------------------
	opINrC
	and z80de,z80de,#0x00FF0000
	orr z80de,z80de,r0,lsl#24
	fetch 12
;----------------------------------------------------------------------------
_ED51;		OUT (C),D
;----------------------------------------------------------------------------
	opOUTCrH z80de
;----------------------------------------------------------------------------
_ED52;		SBC HL,DE
;----------------------------------------------------------------------------
	opSBC16 z80de
;----------------------------------------------------------------------------
_ED53;		LD (NN),DE
;----------------------------------------------------------------------------
	ldrb r0,[z80pc],#1
	ldrb r1,[z80pc],#1
	orr addy,r0,r1,lsl#8
	writemem16 z80de
	fetch 20
;----------------------------------------------------------------------------
;_ED54;		NEG A
;----------------------------------------------------------------------------
;----------------------------------------------------------------------------
;_ED55;		RETN
;----------------------------------------------------------------------------
;----------------------------------------------------------------------------
_ED56;		IM 1
;----------------------------------------------------------------------------
	mov r0,#1
	strb r0,z80_im
	fetch 8
;----------------------------------------------------------------------------
_ED57;		LD A,I
;----------------------------------------------------------------------------
	ldrb r0,z80_i
	movs z80a,r0,lsl#24
	and z80f,z80f,#PSR_C
	orrmi z80f,z80f,#PSR_S
	orreq z80f,z80f,#PSR_Z
	ldrb r0,z80_iff2
	cmp r0,#0
	orrne z80f,z80f,#PSR_V
	fetch 9
;----------------------------------------------------------------------------
_ED58;		IN E,(C)
;----------------------------------------------------------------------------
	opINrC
	and z80de,z80de,#0xFF000000
	orr z80de,z80de,r0,lsl#16
	fetch 12
;----------------------------------------------------------------------------
_ED59;		OUT (C),E
;----------------------------------------------------------------------------
	opOUTCrL z80de
;----------------------------------------------------------------------------
_ED5A;		ADC HL,DE
;----------------------------------------------------------------------------
	opADC16 z80de
;----------------------------------------------------------------------------
_ED5B;		LD DE,(NN)
;----------------------------------------------------------------------------
	ldrb r0,[z80pc],#1
	ldrb r1,[z80pc],#1
	orr addy,r0,r1,lsl#8
	readmem16 z80de
	fetch 20
;----------------------------------------------------------------------------
;_ED5C;		NEG A
;----------------------------------------------------------------------------
;----------------------------------------------------------------------------
;_ED5D;		RETN
;----------------------------------------------------------------------------
;----------------------------------------------------------------------------
_ED5E;		IM 2
;----------------------------------------------------------------------------
	mov r0,#2
	strb r0,z80_im
	fetch 8
;----------------------------------------------------------------------------
_ED5F;		LD A,R
;----------------------------------------------------------------------------
	ldrb r0,z80_r
	and r0,r0,#0x80					;
	rsb r1,cycles,#0				;
	and r1,r1,#0x7F<<CYC_SHIFT		;Fix for Shanghai 2 GG.
	orr r0,r0,r1,lsr#CYC_SHIFT		;

;	mov r0,r0,ror#7
;	add r0,r0,#0x16000000			;Pseudo R counter, needed in Bank Panic.
;	mov r0,r0,ror#25
;	strb r0,z80_r
	movs z80a,r0,lsl#24
	and z80f,z80f,#PSR_C
	orrmi z80f,z80f,#PSR_S
	orreq z80f,z80f,#PSR_Z
	ldrb r0,z80_iff2
	cmp r0,#0
	orrne z80f,z80f,#PSR_P
	fetch 9
;----------------------------------------------------------------------------
_ED60;		IN H,(C)
;----------------------------------------------------------------------------
	opINrC
	and z80hl,z80hl,#0x00FF0000
	orr z80hl,z80hl,r0,lsl#24
	fetch 12
;----------------------------------------------------------------------------
_ED61;		OUT (C),H
;----------------------------------------------------------------------------
	opOUTCrH z80hl
;----------------------------------------------------------------------------
_ED62;		SBC HL,HL
;----------------------------------------------------------------------------
	opSBC16HL
;----------------------------------------------------------------------------
;_ED63;		LD (NN),HL			;same as _22
;----------------------------------------------------------------------------
;----------------------------------------------------------------------------
;_ED64;		NEG A
;----------------------------------------------------------------------------
;----------------------------------------------------------------------------
;_ED65;		RETN
;----------------------------------------------------------------------------
;----------------------------------------------------------------------------
;_ED66;		IM 0
;----------------------------------------------------------------------------
;----------------------------------------------------------------------------
_ED67;		RRD
;----------------------------------------------------------------------------
	readmem8HL
	mov r1,r0,ror#4
	orr r0,r1,z80a,lsr#20
	bic z80a,z80a,#0x0F000000
	orr z80a,z80a,r1,lsr#4
	writemem8HL
	adr r1,pzst
	ldrb r0,[r1,z80a,lsr#24]		;get PZS
	and z80f,z80f,#PSR_C			;keep C
	orr z80f,z80f,r0
	fetch 18
;----------------------------------------------------------------------------
_ED68;		IN L,(C)
;----------------------------------------------------------------------------
	opINrC
	and z80hl,z80hl,#0xFF000000
	orr z80hl,z80hl,r0,lsl#16
	fetch 12
;----------------------------------------------------------------------------
_ED69;		OUT (C),L
;----------------------------------------------------------------------------
	opOUTCrL z80hl
;----------------------------------------------------------------------------
_ED6A;		ADC HL,HL
;----------------------------------------------------------------------------
	opADC16HL
;----------------------------------------------------------------------------
;_ED6B;		LD HL,(NN)			;same as _2A
;----------------------------------------------------------------------------
;----------------------------------------------------------------------------
;_ED6C;		NEG A
;----------------------------------------------------------------------------
;----------------------------------------------------------------------------
;_ED6D;		RETN
;----------------------------------------------------------------------------
;----------------------------------------------------------------------------
;_ED6E;		IM 0
;----------------------------------------------------------------------------
;----------------------------------------------------------------------------
_ED6F;		RLD
;----------------------------------------------------------------------------
	readmem8HL
	orr r0,r0,z80a,lsl#4
	mov r0,r0,ror#28
	bic z80a,z80a,#0x0F000000
	orr z80a,z80a,r0,lsl#16
	and z80a,z80a,#0xFF000000
	writemem8HL
	adr r1,pzst
	ldrb r1,[r1,z80a,lsr#24]		;get PZS
	and z80f,z80f,#PSR_C			;keep C
	orr z80f,z80f,r1
	fetch 18
;----------------------------------------------------------------------------
_ED70;		IN F,(C)			;only set flags
;----------------------------------------------------------------------------
	opINrC
	fetch 12
;----------------------------------------------------------------------------
_ED71;		OUT (C),0
;----------------------------------------------------------------------------
	mov r0,#0
	opOUTCr
;----------------------------------------------------------------------------
_ED72;		SBC HL,SP
;----------------------------------------------------------------------------
	opSBC16 z80sp
;----------------------------------------------------------------------------
_ED73;		LD (NN),SP
;----------------------------------------------------------------------------
	ldrb r0,[z80pc],#1
	ldrb r1,[z80pc],#1
	orr addy,r0,r1,lsl#8
	writemem16 z80sp
	fetch 20
;----------------------------------------------------------------------------
;_ED74;		NEG A
;----------------------------------------------------------------------------
;----------------------------------------------------------------------------
;_ED75;		RETN
;----------------------------------------------------------------------------
;----------------------------------------------------------------------------
;_ED76;		IM 1
;----------------------------------------------------------------------------
;----------------------------------------------------------------------------
;_ED77;		NOP
;----------------------------------------------------------------------------
;----------------------------------------------------------------------------
_ED78;		IN A,(C)
;----------------------------------------------------------------------------
	opINrC
	mov z80a,r0,lsl#24
	fetch 12
;----------------------------------------------------------------------------
_ED79;		OUT (C),A
;----------------------------------------------------------------------------
	opOUTCrH z80a
;----------------------------------------------------------------------------
_ED7A;		ADC HL,SP
;----------------------------------------------------------------------------
	opADC16 z80sp
;----------------------------------------------------------------------------
_ED7B;		LD SP,(NN)
;----------------------------------------------------------------------------
	ldrb r0,[z80pc],#1
	ldrb r1,[z80pc],#1
	orr addy,r0,r1,lsl#8
	readmem16 z80sp
	fetch 20
;----------------------------------------------------------------------------
;_ED7C;		NEG A
;----------------------------------------------------------------------------
;----------------------------------------------------------------------------
;_ED7D;		RETN
;----------------------------------------------------------------------------
;----------------------------------------------------------------------------
;_ED7E;		IM 2
;----------------------------------------------------------------------------
;----------------------------------------------------------------------------
;_ED7F;		NOP
;----------------------------------------------------------------------------

;----------------------------------------------------------------------------
_EDA0;		LDI
;----------------------------------------------------------------------------
	copymem8HL_DE
	add z80hl,z80hl,#0x00010000
	add z80de,z80de,#0x00010000
	subs z80bc,z80bc,#0x00010000
	bic z80f,z80f,#PSR_H+PSR_P+PSR_n
	orrne z80f,z80f,#PSR_P
	fetch 16
;----------------------------------------------------------------------------
_EDA1;		CPI
;----------------------------------------------------------------------------
	readmem8HL
	add z80hl,z80hl,#0x00010000
	mov r1,z80a,lsl#4
	cmp z80a,r0,lsl#24
	and z80f,z80f,#PSR_C
	orr z80f,z80f,#PSR_n
	orrmi z80f,z80f,#PSR_S
	orreq z80f,z80f,#PSR_Z
	cmp r1,r0,lsl#28
	orrcc z80f,z80f,#PSR_H
	subs z80bc,z80bc,#0x00010000
	orrne z80f,z80f,#PSR_P
	fetch 16
;----------------------------------------------------------------------------
_EDA2;		INI			Port(C) -> (HL), HL++
;----------------------------------------------------------------------------
	bl Z80_IN_C
	and z80f,r0,#PSR_n				;minus sets n
	writemem8HL
	add z80hl,z80hl,#0x00010000
	sub z80bc,z80bc,#0x01000000
	tst z80bc,#0xFF000000
	orrmi z80f,z80f,#PSR_S
	orreq z80f,z80f,#PSR_Z
	fetch 16
;----------------------------------------------------------------------------
_EDA3;		OUTI		(HL) -> Port(C), HL++
;----------------------------------------------------------------------------
	readmem8HL
	add z80hl,z80hl,#0x00010000
	and z80f,r0,#PSR_n				;minus sets n
	mov r1,z80hl,lsl#8
	adds r1,r1,r0,lsl#24
	orrcs z80f,z80f,#PSR_C+PSR_H
	sub z80bc,z80bc,#0x01000000
	tst z80bc,#0xFF000000
	orrmi z80f,z80f,#PSR_S
	orreq z80f,z80f,#PSR_Z
	bl Z80_OUT_C
	fetch 16
;----------------------------------------------------------------------------
_EDA8;		LDD
;----------------------------------------------------------------------------
	copymem8HL_DE
	sub z80hl,z80hl,#0x00010000
	sub z80de,z80de,#0x00010000
	subs z80bc,z80bc,#0x00010000
	bic z80f,z80f,#PSR_H+PSR_P+PSR_n
	orrne z80f,z80f,#PSR_P
	fetch 16
;----------------------------------------------------------------------------
_EDA9;		CPD
;----------------------------------------------------------------------------
	readmem8HL
	sub z80hl,z80hl,#0x00010000
	mov r1,z80a,lsl#4
	cmp z80a,r0,lsl#24
	and z80f,z80f,#PSR_C
	orr z80f,z80f,#PSR_n
	orrmi z80f,z80f,#PSR_S
	orreq z80f,z80f,#PSR_Z
	cmp r1,r0,lsl#28
	orrcc z80f,z80f,#PSR_H
	subs z80bc,z80bc,#0x00010000
	orrne z80f,z80f,#PSR_P
	fetch 16
;----------------------------------------------------------------------------
_EDAA;		IND			Port(C) -> (HL), HL--
;----------------------------------------------------------------------------
	bl Z80_IN_C
	and z80f,r0,#PSR_n				;minus sets n
	sub z80bc,z80bc,#0x01000000
	tst z80bc,#0xFF000000
	orrmi z80f,z80f,#PSR_S
	orreq z80f,z80f,#PSR_Z
	writemem8HL
	sub z80hl,z80hl,#0x00010000
	fetch 16
;----------------------------------------------------------------------------
_EDAB;		OUTD		(HL) -> Port(C), HL--
;----------------------------------------------------------------------------
	readmem8HL
	sub z80hl,z80hl,#0x00010000
	and z80f,r0,#PSR_n				;minus sets n
	sub z80bc,z80bc,#0x01000000
	tst z80bc,#0xFF000000
	orrmi z80f,z80f,#PSR_S
	orreq z80f,z80f,#PSR_Z
	bl Z80_OUT_C
	fetch 16

;----------------------------------------------------------------------------
LDIR_loop
	orr z80f,z80f,#PSR_P
	subs cycles,cycles,#21*CYCLE
	submi z80pc,z80pc,#2
	ldrmi pc,nexttimeout
;----------------------------------------------------------------------------
_EDB0;		LDIR
;----------------------------------------------------------------------------
	copymem8HL_DE
	add z80hl,z80hl,#0x00010000
	add z80de,z80de,#0x00010000
	subs z80bc,z80bc,#0x00010000
	bic z80f,z80f,#PSR_H+PSR_P+PSR_n
	bne LDIR_loop
	fetch 16

;----------------------------------------------------------------------------
_EDB1;		CPIR
;----------------------------------------------------------------------------
	readmem8HL
	add z80hl,z80hl,#0x00010000
	mov r1,z80a,lsl#4
	cmp z80a,r0,lsl#24
	and z80f,z80f,#PSR_C
	orr z80f,z80f,#PSR_n
	orrmi z80f,z80f,#PSR_S
	orreq z80f,z80f,#PSR_Z
	cmp r1,r0,lsl#28
	orrcc z80f,z80f,#PSR_H
	subs z80bc,z80bc,#0x00010000
	orrne z80f,z80f,#PSR_P
	eor r0,z80f,#PSR_Z
	tstne r0,#PSR_Z
	subne z80pc,z80pc,#2
	subne cycles,cycles,#5*CYCLE
	fetch 16
;----------------------------------------------------------------------------
_EDB2;		INIR		Port(C) -> (HL), HL++
;----------------------------------------------------------------------------
	bl Z80_IN_C
	and z80f,r0,#PSR_n				;minus sets n
	writemem8HL
	add z80hl,z80hl,#0x00010000
	sub z80bc,z80bc,#0x01000000
	tst z80bc,#0xFF000000
	orrmi z80f,z80f,#PSR_S
	orreq z80f,z80f,#PSR_Z
	subne z80pc,z80pc,#2
	subne cycles,cycles,#5*CYCLE
	fetch 16

;----------------------------------------------------------------------------
OTIR_loop
	subs cycles,cycles,#21*CYCLE
	submi z80pc,z80pc,#2
	ldrmi pc,nexttimeout
;----------------------------------------------------------------------------
_EDB3;		OTIR		(HL) -> Port(C), HL++
;----------------------------------------------------------------------------
	readmem8HL
	add z80hl,z80hl,#0x00010000
	and z80f,r0,#PSR_n				;minus sets n
	mov r1,z80hl,lsl#8
	adds r1,r1,r0,lsl#24
	orrcs z80f,z80f,#PSR_C+PSR_H
	sub z80bc,z80bc,#0x01000000
	bl Z80_OUT_C
	tst z80bc,#0xFF000000
	orrmi z80f,z80f,#PSR_S
	bne OTIR_loop
	orr z80f,z80f,#PSR_Z
	fetch 16
;----------------------------------------------------------------------------
_EDB8;		LDDR
;----------------------------------------------------------------------------
	copymem8HL_DE
	sub z80hl,z80hl,#0x00010000
	sub z80de,z80de,#0x00010000
	subs z80bc,z80bc,#0x00010000
	bic z80f,z80f,#PSR_H+PSR_P+PSR_n
	orrne z80f,z80f,#PSR_P
	subne z80pc,z80pc,#2
	subne cycles,cycles,#5*CYCLE
	fetch 16
;----------------------------------------------------------------------------
_EDB9;		CPDR
;----------------------------------------------------------------------------
	readmem8HL
	sub z80hl,z80hl,#0x00010000
	mov r1,z80a,lsl#4
	cmp z80a,r0,lsl#24
	and z80f,z80f,#PSR_C
	orr z80f,z80f,#PSR_n
	orrmi z80f,z80f,#PSR_S
	orreq z80f,z80f,#PSR_Z
	cmp r1,r0,lsl#28
	orrcc z80f,z80f,#PSR_H
	subs z80bc,z80bc,#0x00010000
	orrne z80f,z80f,#PSR_P
	eor r0,z80f,#PSR_Z
	tstne r0,#PSR_Z
	subne z80pc,z80pc,#2
	subne cycles,cycles,#5*CYCLE
	fetch 16
;----------------------------------------------------------------------------
_EDBA;		INDR			Port(C) -> (HL), HL--
;----------------------------------------------------------------------------
	bl Z80_IN_C
	and z80f,r0,#PSR_n				;minus sets n
	writemem8HL
	sub z80hl,z80hl,#0x00010000
	sub z80bc,z80bc,#0x01000000
	tst z80bc,#0xFF000000
	orrmi z80f,z80f,#PSR_S
	orreq z80f,z80f,#PSR_Z
	subne z80pc,z80pc,#2
	subne cycles,cycles,#5*CYCLE
	fetch 16
;----------------------------------------------------------------------------
_EDBB;		OTDR		(HL) -> Port(C), HL--
;----------------------------------------------------------------------------
	readmem8HL
	sub z80hl,z80hl,#0x00010000
	and z80f,r0,#PSR_n				;minus sets n
	sub z80bc,z80bc,#0x01000000
	tst z80bc,#0xFF000000
	orrmi z80f,z80f,#PSR_S
	orreq z80f,z80f,#PSR_Z
	subne z80pc,z80pc,#2
	subne cycles,cycles,#5*CYCLE
	bl Z80_OUT_C
	fetch 16
;----------------------------------------------------------------------------








;----------------------------------------------------------------------------
run	;r0=0 to return after frame
;----------------------------------------------------------------------------
;	mov r11,r11			;No$GBA breakpoint
	mov r1,#0
	strb r1,novblankwait

	strb r0,dontstop
	tst r0,#1
	stmeqfd sp!,{r3-r11,lr}

	ldr globalptr,=|wram_globals0$$Base|
	b line0x
;----------------------------------------------------------------------------
;cycles ran out
;----------------------------------------------------------------------------
line0
	adr r2,cpuregs
	stmia r2,{z80f-z80pc,z80sp}	;save Z80 state
waitformulti
	ldr r1,=REG_P1		;refresh input every frame
	ldrh r0,[r1]
		eor r0,r0,#0xff
		eor r0,r0,#0x300	;r0=button state (raw)
	ldr r1,AGBjoypad
	eor r1,r1,r0
	and r1,r1,r0		;r1=button state (0->1)
	str r0,AGBjoypad

	ldrb r2,emuflags+1
	cmp r2,#SCALED
	bhs %F0			;if unscaled
	ldr r2,windowtop
	tst r0,#0x100			;R=scroll down
	addne r2,r2,#2
	tst r0,#0x200			;L=scroll up
	subne r2,r2,#2
	ldrb r3,maxpan
	cmp r2,r3
	movgt r2,r3
	ldrb r3,minpan
	cmp r2,r3
	movmi r2,r3
	str r2,windowtop
0

	ldrb r2,dontstop
	tst r2,#1
	ldmeqfd sp!,{r3-r11,lr}	;exit here if doing single frame:
	bxeq lr							;return to rommenu()

	;----anything from here til line0x won't get executed while rom menu is active---

	mov r2,#REG_BASE
	mov r3,#0x0110				;was 0x0310
	strh r3,[r2,#REG_BLDCNT]	;stop darkened screen,OBJ blend to BG0/1
	mov r3,#0x1000				;BG0/1=16, OBJ=0
	strh r3,[r2,#REG_BLDALPHA]	;Alpha values

	adr lr,line0x			;return here after doing L/R + SEL/START

	tst r1,#0x300			;if L or R was pressed
	tstne r0,#0x100
	tstne r0,#0x200			;and both L+R are held..
	ldrne r1,=ui
	bxne r1					;do menu


	ands r3,r0,#0x300		;if either L or R is pressed (not both)
	eornes r3,r3,#0x300
	bicne r0,r0,#0x0c		;	hide sel,start from EMU
	str r0,EMUjoypad
	beq line0x				;skip ahead if neither or both are pressed

	tst r0,#0x200
	tstne r1,#4				;L+SEL for BG adjust
	ldrne r2,adjustblend
	addne r2,r2,#1
	strne r2,adjustblend

	tst r0,#0x200			;L?
	tstne r1,#8				;START?
	ldrb r2,novblankwait	;0=Normal, 1=Force, 2=No wait, 3=Slomo
	addne r2,r2,#1
	and r2,r2,#3
	strb r2,novblankwait

	tst r0,#0x100			;R?
	tstne r1,#8				;START:
	ldrne r1,=quickload
	bxne r1

	tst r0,#0x100			;R?
	tstne r1,#4				;SELECT:
	ldrne r1,=quicksave
	bxne r1
line0x
	bl refreshEMUjoypads	;Z=1 if communication ok
	bne waitformulti		;waiting on other GBA..

	ldr r0,=joy0state
	ldrh r0,[r0]
	orr r0,r0,r0,lsr#8
	ldrb r1,nmi_trigg
	eor r1,r1,r0
	and r1,r1,r0
	strb r0,nmi_trigg
	ldrb r3,machine
	cmp r3,#VDP_GG
	tstne r1,#0x80			;SMS PAUSE?
	movne r3,#1
	strneb r3,z80_if_

	ldr r0,AGBjoypad
	ldr r2,fiveminutes		;sleep after 5/10/30 minutes of inactivity
	cmp r0,#0				;(left out of the loop so waiting on multi-link
	ldrne r2,sleeptime		;doesn't accelerate time)
	subs r2,r2,#1
	str r2,fiveminutes
	bleq suspend

	bl newframe				;display update

	adr r0,cpuregs
	ldmia r0,{z80f-z80pc,z80sp}	;restore Z80 state

	adr r0,line0_to_96
	str r0,nexttimeout
	str r0,nexttimeout_
	adr r0,default_scanlinehook
	str r0,scanlinehook
;	mov r1,#0				;Scanline

line0_to_96 ;------------------------
;	ldr r0,cyclesperscanline
	add cycles,cycles,#CYCLE_PSL

	ldr r1,scanline
	add r1,r1,#1
	str r1,scanline

	ldrb r0,scrstartline
	cmp r1,r0
	bleq midframe				;display update

	cmp r1,#30
	ldreqb r0,vdpstat
	ldreqb r2,sprcollision
	orreq r0,r0,r2
	streqb r0,vdpstat


	cmp r1,#96
	ldrmi pc,scanlinehook
;--------------------------------------------- on line 96
	ldrb r0,vdpmode2
	strb r0,vdpmode2_bak1		;screen on/off


	adr addy,line96_to_VBL
	str addy,nexttimeout
	str addy,nexttimeout_
	ldr pc,scanlinehook
line96_to_VBL ;------------------------
;	ldr r0,cyclesperscanline
	add cycles,cycles,#CYCLE_PSL

	ldr r1,scanline
	add r1,r1,#1
	str r1,scanline

	ldr r0,endframeline
	cmp r1,r0
	bleq endframe					;display update, r1 is saved.

	ldr r0,vblline
	cmp r1,r0
	ldrmi pc,scanlinehook

	adr addy,lineVBL
	str addy,nexttimeout
	str addy,nexttimeout_
	ldr pc,scanlinehook
lineVBL ;------------------------

	ldr r0,fpsvalue
	add r0,r0,#1
	str r0,fpsvalue
;----------------------------------------

	ldrb r0,vdpstat
	orr r0,r0,#0x80		;VBlank bit
	strb r0,vdpstat

	ldr r1,scanline
	add r1,r1,#1
	str r1,scanline

	adr addy,VBL_Hook
	str addy,nexttimeout
	str addy,nexttimeout_
	fetch_force
VBL_Hook
;	ldr r0,cyclesperscanline
	add cycles,cycles,#CYCLE_PSL

	adr addy,lineVBL_to_end
	str addy,nexttimeout
	str addy,nexttimeout_
	adr r0,reloadScanlineIRQ
	ldr r1,scanlinehook
	str r0,scanlinehook
	mov pc,r1

lineVBL_to_end ;------------------------
;	ldr r0,cyclesperscanline
	add cycles,cycles,#CYCLE_PSL

	ldr r1,scanline
	add r1,r1,#1
	str r1,scanline

	ldr r2,lastscanline
	cmp r1,r2
	ldrmi pc,scanlinehook

	adr addy,line0
	str addy,nexttimeout
	str addy,nexttimeout_
	ldr r0,frame
	add r0,r0,#1
	str r0,frame

	ldrb r0,z80_if_
	cmp r0,#0
	bne nmiZ80

	ldr pc,scanlinehook

;----------------------------------------------------------
default_scanlinehook
checkScanlineIRQ
;	ldr r0,vblline
;	cmp r1,r0				;r1 is allready scanline.
;	bhi reloadScanlineIRQ
	ldr r0,lineirq
	subs r0,r0,#1
	bpl noScanlineIRQ
	mov r1,#0x40			;scanline bit
	strb r1,vdppending
reloadScanlineIRQ
	ldrb r0,vdpcounter
noScanlineIRQ
	str r0,lineirq

;----------------------------------------------------------
checkMasterIRQ
;----------------------------------------------------------
	ldrb r0,z80_iff1
	cmp r0,#0
	beq _GO
;----------------------------------------------------------
checkIRQ
;----------------------------------------------------------
	ldrb r1,vdpmode2
	ldrb r0,vdpstat
	and r0,r0,#0x80
	ands r0,r0,r1,lsl#2

	ldreqb r1,vdpmode1
	ldreqb r0,vdppending
	andeqs r0,r0,r1,lsl#2
	beq _GO
;----------------------------------------------------------
irqZ80
;----------------------------------------------------------
;	ldrb r1,z80_im			;which IRQ mode?
;	cmp r1,#1
;	movmi addy,#0			;get IRQ vector, 13 cycles
;	moveq addy,#0x38		;get IRQ vector, 13 cycles
;	movhi addy,#0x18		;get IRQ vector, 19 cycles
	mov addy,#0x38			;get IRQ vector
	eatcycles 2

	strb z80a,z80_iff2		;disable IRQs
nmi_entry
	strb z80a,z80_iff1
	ldrb r1,[z80pc]
	cmp r1,#0x76			;Check if we're doing Halt.
	addeq z80pc,z80pc,#1	;get out of HALT
rst_entry
	ldr r0,lastbank
	sub r0,z80pc,r0
	push16					;save PC
	encodePC_IRQ
	fetch 11				;13 for IRQ
;----------------------------------------------------------
nmiZ80
;----------------------------------------------------------
	mov addy,#0x66			;get NMI vector
	strb z80a,z80_if_		;disable NMI
	b nmi_entry
;----------------------------------------------------------------------------
EI_fix;	ei should be delayed by 1 instruction.
;----------------------------------------------------------------------------
	ldr r0,oldcycles
	bic r0,r0,#CYC_MASK			; don't add any cpu bits.
	add cycles,cycles,r0
	ldr r0,nexttimeout_
	str r0,nexttimeout
	b checkIRQ
;	b checkMasterIRQ
;----------------------------------------------------------------------------
fiveminutes		DCD 5*60*60
sleeptime		DCD 5*60*60
dontstop		DCB 0
novblankwait	DCB 0
gbadetect		DCB 0
sprcollision	DCB 0
nmi_trigg		DCB 0
				DCB 0,0,0
;----------------------------------------------------------------------------
	AREA rom_code, CODE, READONLY
;----------------------------------------------------------------------------
_DDCBNF;
;----------------------------------------------------------------------------
	mov r11,r11				;No$GBA breakpoint
	orr r1,r0,r1,lsl#8
tag01
;	b tag01
	fetch 4
;----------------------------------------------------------------------------
_EDNP;						;ED nop instructions, takes 8 cycles.
;----------------------------------------------------------------------------
	mov r11,r11				;No$GBA breakpoint
	orr r0,r0,#0xED00
tag02
;	b tag02
	fetch 8
;----------------------------------------------------------------------------
_xx;	???					;invalid opcode
;----------------------------------------------------------------------------
	mov r11,r11				;No$GBA breakpoint
	[ DEBUG
		adr r0,_xx
		mov r1,#0
		bl debug_
	]
	fetch 4


;----------------------------------------------------------------------------
ntsc_pal_reset
;--- PAL Speed - 3546893Hz / 50Hz / 313 = 226.638
;---NTSC Speed - 3579545Hz / 60Hz / 262 = 227.706
	ldr r0,emuflags
	tst r0,#PALTIMING
;	moveq r1,#228*CYCLE		;NTSC 228
;	movne r1,#228*CYCLE		;PAL 228
;	str r1,cyclesperscanline
	ldreq r1,=261			;NTSC
	ldrne r1,=312			;PAL
	str r1,lastscanline
	bx lr

;----------------------------------------------------------------------------
CPU_reset	;called by loadcart (r0-r9 are free to use)
;----------------------------------------------------------------------------
	str lr,[sp,#-4]!
	bl ntsc_pal_reset
;---cpu reset
	ldr r0,emuflags
	tst r0,#NOCPUHACK		;load opcode set
	adr r1,normalops
;	adreq r1,jmpops
;	adr r3,opindex
;	mov r4,#8
;nr0	ldr r5,[r1,r4,lsl#2]
;	ldr r6,[r3,r4,lsl#2]
;	str r5,[r6]
;	subs r4,r4,#1
;	bpl nr0

	mov z80a,#0xFF000000
	mov z80bc,#0x00000000
	mov z80de,#0x00000000
	mov z80hl,#0x00000000
	mov z80f,#PSR_S+PSR_Z+PSR_V+PSR_C+PSR_H+PSR_n
	strb z80a,z80_iff1		;disable all IRQs
	strb z80a,z80_iff2
	strb z80a,z80_if_
	strb z80a,z80_r
	ldr z80sp,=0xffff0000	;SP=FFFF
	str z80sp,z80_ix
	str z80sp,z80_iy
	mov cycles,#0

	str cycles,frame			;frame count reset

	;(clear irq/nmi/res source)...

	mov z80pc,#0
	encodePC			;get RESET vector

	adr r0,cpuregs
	stmia r0,{z80f-z80pc,z80sp}
	ldr lr,[sp],#4
	bx lr
normalops
	DCD _00,_00,_00,_00,_00,_00,_00,_00,_00
jmpops
	DCD _00,_00,_00,_00,_00,_00,_00,_00,_00
opindex
	DCD op_table+0x10*4,op_table+0x30*4,op_table+0x50*4,op_table+0x70*4,op_table+0x90*4
	DCD op_table+0xB0*4,op_table+0xD0*4,op_table+0xF0*4,op_table+0x4C*4
;----------------------------------------------------------------------------
	AREA wram_globals0, CODE, READWRITE
;----------------------------------------------------------------------------
op_table
	DCD _00,_01,_02,_03,_04,_05,_06,_07,_08,_09,_0A,_0B,_0C,_0D,_0E,_0F
	DCD _10,_11,_12,_13,_14,_15,_16,_17,_18,_19,_1A,_1B,_1C,_1D,_1E,_1F
	DCD _20,_21,_22,_23,_24,_25,_26,_27,_28,_29,_2A,_2B,_2C,_2D,_2E,_2F
	DCD _30,_31,_32,_33,_34,_35,_36,_37,_38,_39,_3A,_3B,_3C,_3D,_3E,_3F
	DCD _40,_41,_42,_43,_44,_45,_46,_47,_48,_49,_4A,_4B,_4C,_4D,_4E,_4F
	DCD _50,_51,_52,_53,_54,_55,_56,_57,_58,_59,_5A,_5B,_5C,_5D,_5E,_5F
	DCD _60,_61,_62,_63,_64,_65,_66,_67,_68,_69,_6A,_6B,_6C,_6D,_6E,_6F
	DCD _70,_71,_72,_73,_74,_75,_76,_77,_78,_79,_7A,_7B,_7C,_7D,_7E,_7F
	DCD _80,_81,_82,_83,_84,_85,_86,_87,_88,_89,_8A,_8B,_8C,_8D,_8E,_8F
	DCD _90,_91,_92,_93,_94,_95,_96,_97,_98,_99,_9A,_9B,_9C,_9D,_9E,_9F
	DCD _A0,_A1,_A2,_A3,_A4,_A5,_A6,_A7,_A8,_A9,_AA,_AB,_AC,_AD,_AE,_AF
	DCD _B0,_B1,_B2,_B3,_B4,_B5,_B6,_B7,_B8,_B9,_BA,_BB,_BC,_BD,_BE,_BF
	DCD _C0,_C1,_C2,_C3,_C4,_C5,_C6,_C7,_C8,_C9,_CA,_CB,_CC,_CD,_CE,_CF
	DCD _D0,_D1,_D2,_D3,_D4,_D5,_D6,_D7,_D8,_D9,_DA,_DB,_DC,_DD,_DE,_DF
	DCD _E0,_E1,_E2,_E3,_E4,_E5,_E6,_E7,_E8,_E9,_EA,_EB,_EC,_ED,_EE,_EF
	DCD _F0,_F1,_F2,_F3,_F4,_F5,_F6,_F7,_F8,_F9,_FA,_FB,_FC,_FD,_FE,_FF

PZSTable
	DCB PSR_Z|PSR_P,0 ,0 ,PSR_P,0 ,PSR_P,PSR_P,0 ,0 ,PSR_P,PSR_P,0 ,PSR_P,0 ,0 ,PSR_P
	DCB 0    ,PSR_P,PSR_P,0 ,PSR_P,0 ,0 ,PSR_P,PSR_P,0 ,0 ,PSR_P,0 ,PSR_P,PSR_P,0
	DCB 0    ,PSR_P,PSR_P,0 ,PSR_P,0 ,0 ,PSR_P,PSR_P,0 ,0 ,PSR_P,0 ,PSR_P,PSR_P,0
	DCB PSR_P   ,0 ,0 ,PSR_P,0 ,PSR_P,PSR_P,0 ,0 ,PSR_P,PSR_P,0 ,PSR_P,0 ,0 ,PSR_P
	DCB 0    ,PSR_P,PSR_P,0 ,PSR_P,0 ,0 ,PSR_P,PSR_P,0 ,0 ,PSR_P,0 ,PSR_P,PSR_P,0
	DCB PSR_P   ,0 ,0 ,PSR_P,0 ,PSR_P,PSR_P,0 ,0 ,PSR_P,PSR_P,0 ,PSR_P,0 ,0 ,PSR_P
	DCB PSR_P   ,0 ,0 ,PSR_P,0 ,PSR_P,PSR_P,0 ,0 ,PSR_P,PSR_P,0 ,PSR_P,0 ,0 ,PSR_P
	DCB 0    ,PSR_P,PSR_P,0 ,PSR_P,0 ,0 ,PSR_P,PSR_P,0 ,0 ,PSR_P,0 ,PSR_P,PSR_P,0
	DCB PSR_S   ,PSR_P+PSR_S,PSR_P+PSR_S,PSR_S,PSR_P+PSR_S,PSR_S,PSR_S,PSR_P+PSR_S,PSR_P+PSR_S,PSR_S,PSR_S,PSR_P+PSR_S,PSR_S,PSR_P+PSR_S,PSR_P+PSR_S,PSR_S
	DCB PSR_P+PSR_S,PSR_S,PSR_S,PSR_P+PSR_S,PSR_S,PSR_P+PSR_S,PSR_P+PSR_S,PSR_S,PSR_S,PSR_P+PSR_S,PSR_P+PSR_S,PSR_S,PSR_P+PSR_S,PSR_S,PSR_S,PSR_P+PSR_S
	DCB PSR_P+PSR_S,PSR_S,PSR_S,PSR_P+PSR_S,PSR_S,PSR_P+PSR_S,PSR_P+PSR_S,PSR_S,PSR_S,PSR_P+PSR_S,PSR_P+PSR_S,PSR_S,PSR_P+PSR_S,PSR_S,PSR_S,PSR_P+PSR_S
	DCB PSR_S   ,PSR_P+PSR_S,PSR_P+PSR_S,PSR_S,PSR_P+PSR_S,PSR_S,PSR_S,PSR_P+PSR_S,PSR_P+PSR_S,PSR_S,PSR_S,PSR_P+PSR_S,PSR_S,PSR_P+PSR_S,PSR_P+PSR_S,PSR_S
	DCB PSR_P+PSR_S,PSR_S,PSR_S,PSR_P+PSR_S,PSR_S,PSR_P+PSR_S,PSR_P+PSR_S,PSR_S,PSR_S,PSR_P+PSR_S,PSR_P+PSR_S,PSR_S,PSR_P+PSR_S,PSR_S,PSR_S,PSR_P+PSR_S
	DCB PSR_S   ,PSR_P+PSR_S,PSR_P+PSR_S,PSR_S,PSR_P+PSR_S,PSR_S,PSR_S,PSR_P+PSR_S,PSR_P+PSR_S,PSR_S,PSR_S,PSR_P+PSR_S,PSR_S,PSR_P+PSR_S,PSR_P+PSR_S,PSR_S
	DCB PSR_S   ,PSR_P+PSR_S,PSR_P+PSR_S,PSR_S,PSR_P+PSR_S,PSR_S,PSR_S,PSR_P+PSR_S,PSR_P+PSR_S,PSR_S,PSR_S,PSR_P+PSR_S,PSR_S,PSR_P+PSR_S,PSR_P+PSR_S,PSR_S
	DCB PSR_P+PSR_S,PSR_S,PSR_S,PSR_P+PSR_S,PSR_S,PSR_P+PSR_S,PSR_P+PSR_S,PSR_S,PSR_S,PSR_P+PSR_S,PSR_P+PSR_S,PSR_S,PSR_P+PSR_S,PSR_S,PSR_S,PSR_P+PSR_S

	;writemem_tbl
	% 8*4		;$0000-FFFF
	;memmap_tbl
rommap
	% 64*4		;$0000-FFFF

cpustate
	;group these together for save/loadstate
	% 8*4 ;cpuregs  (flg,a,bc,de,hl,cycles,pc,sp)
	% 8*4 ;cpuregs2 (flg',a',bc',de',hl',0,0,0)
	DCD 0 ;z80_ix:
	DCD 0 ;z80_iy:
	DCD 0 ;lastbank:	last memmap added to PC (used to calculate current PC)
	DCB 0 ;z80_iff1:	(interrupt flag 1)
	DCB 0 ;z80_iff2:	(interrupt flag 2)
	DCB 0 ;z80_im:		(interrupt mode)
	DCB 0 ;z80_if:		(NMI)

	DCB 0 ;z80_i:		(Interrupt vector)
	DCB 0 ;z80_r:		(Refresh reg)
	DCB 0 ;z80_temp1
	DCB 0 ;z80_temp2
	DCD 0 ;nexttimeout:  jump here when cycles runs out
	DCD 0 ;nexttimeout_:  backup of nexttimeout
	DCD 0 ;oldcycles:  backup of cycles
	DCD 0 ;scanlinehook
	DCD 0 ;scanline
frametotal		;let ui.c see frame count for savestates
	DCD 0 ;frame
	DCD 0 ;cyclesperscanline
	DCD 0 ;lastscanline (261/312)
;----------------------------------------------------------------------------
	END

