	INCLUDE equates.h
	INCLUDE memory.h
	INCLUDE z80.h

	EXPORT SN76496_init
	EXPORT SN76496_reset
	EXPORT frequency_reset
;	EXPORT updatesound
	EXPORT soundmode
	EXPORT SN76496_W_OFF
	EXPORT SN76496_W
	EXPORT Vbl_SN76496_1
	EXPORT Vbl_SN76496_2
	EXPORT GG_Stereo_W
	EXPORT SoundVariables

NSEED	 	EQU 0x8000			;Noise Seed
								;These values are for the SMS/GG/MD VDP sound.
WFEED	 	EQU 0x9000			;White Noise Feedback
PFEED	 	EQU 0x8000			;Periodic Noise Feedback

								;These values are for the SN76496 sound chip.
;WFEED	 	EQU 0x6000			;White Noise Feedback
;PFEED	 	EQU 0x4000			;Periodic Noise Feedback
 AREA wram_code4, CODE, READWRITE
;----------------------------------------------------------------------------
; r0 = mixer reg L.
; r1 = mixer reg R.
; r2 -> r5 = pos+freq.
; r6 = noise generator.
; r7 = mixerbuffer L.
; r8 = noise feedback.
; r9 = mixerbuffer R.
; r10 = mix length.
; r11 = ch volumes L.
; r12 = ch volumes R.
; lr = return address.
;----------------------------------------------------------------------------
mixer
;----------------------------------------------------------------------------
mixloop

	adds r5,r5,r5,lsl#16
	movcss r6,r6,lsr#1
	eorcs r6,r6,r8
volF
	mov r0,#0x82
	mov r1,#0x82
	adds r2,r2,r2,lsl#16
	addpl r0,r0,r11
	addpl r1,r1,r12

	adds r3,r3,r3,lsl#16
	addpl r0,r0,r11,lsr#8
	addpl r1,r1,r12,lsr#8

	adds r4,r4,r4,lsl#16
	addpl r0,r0,r11,lsr#16
	addpl r1,r1,r12,lsr#16

	tst r6,#1
	addne r0,r0,r11,lsr#24
	addne r1,r1,r12,lsr#24

	strb r0,[r7],#1
	strb r1,[r9],#1

	subs r10,r10,#1
	bhi mixloop

	bx lr
;----------------------------------------------------------------------------

 AREA rom_code, CODE, READONLY ;-- - - - - - - - - - - - - - - - - - - - - -

;----------------------------------------------------------------------------
SN76496_init
;----------------------------------------------------------------------------
	stmfd sp!,{r3-r7,lr}
	mov r1,#REG_BASE

;	ldrh r0,[r1,#REG_SGBIAS]
;	bic r0,r0,#0xc000				;just change bits we know about.
;	orr r0,r0,#0x8000				;PWM 7-bit 131.072kHz
;	strh r0,[r1,#REG_SGBIAS]

	ldr r2,soundmode				;if r2=0, no sound.
	cmp r2,#1
;	ldr r3,=psg_write_ptr
;	adrmi r0,SN76496_W_OFF
;	adreq r0,SN76496_W
;	str r0,[r3],#4
;	str r0,[r3]

	movmi r0,#0
	ldreq r0,=0x9a0c0000			;stop all channels.  use directsound A&B, timer 0
	str r0,[r1,#REG_SGCNT_L]

	moveq r0,#0x80
	strh r0,[r1,#REG_SGCNT_X]		;sound master enable

;	mov r0,#0x08
;	strh r0,[r1,#REG_SG1CNT_L]		;square1 sweep off

									;square1 & 2 reset
;	strh r1,[r1,#REG_SG1CNT_H]		;set volume
;	strh r1,[r1,#REG_SG2CNT_L]		;set volume

									;triangle reset
	mov r0,#0
	str r0,[r1,#REG_SG3CNT_L]		;sound3 disable, mute, write bank 0

									;Mixer channels
	strh r1,[r1,#REG_DM1CNT_H]		;DMA1 stop, Left channel
	strh r1,[r1,#REG_DM2CNT_H]		;DMA2 stop, Right channel
	add r0,r1,#REG_FIFO_A_L			;DMA1 destination..
	str r0,[r1,#REG_DM1DAD]
	add r0,r1,#REG_FIFO_B_L			;DMA2 destination..
	str r0,[r1,#REG_DM2DAD]
	ldr r0,pcmptr0
	str r0,[r1,#REG_DM1SAD]			;DMA1 src=..
	add r0,r0,#PCMWAVSIZE*2
	str r0,[r1,#REG_DM2SAD]			;DMA2 src=..
;	ldr r0,=0xB640					;noIRQ fifo 32bit repeat incsrc fixeddst
;	strh r0,[r1,#REG_DM1CNT_H]		;DMA1 start
;	strh r0,[r1,#REG_DM2CNT_H]		;DMA2 start


	add r1,r1,#REG_TM0CNT_L			;timer 0 controls sample rate:
	mov r0,#0
	str r0,[r1]						;stop timer 0
	ldr r3,mixrate					; 924=Low, 532=High.
	mov r2,#0x10000					;frequency = 0
	subeq r0,r2,r3					;frequency = 0x1000000/r3 Hz
	orreq r0,r0,#0x800000			;timer 0 on
	str r0,[r1],#4
	mov r0,#0

	bl frequency_reset
	ldmfd sp!,{r3-r7,lr}
;----------------------------------------------------------------------------
SN76496_reset
;----------------------------------------------------------------------------
	stmfd sp!,{lr}

	adrl r0,SoundVariables
	mov r1,#0
	mov r2,#11						;44/4=11
	bl memset_						;clear variables
	str r1,ch0volume				;silence
	mov r0,#0xFF
	bl GG_Stereo_W

	ldmfd sp!,{lr}
	bx lr

;----------------------------------------------------------------------------
frequency_reset
;----------------------------------------------------------------------------
	stmfd sp!,{r4-r6,r10,lr}
	ldr globalptr,=|wram_globals0$$Base|	;need ptr regs init'd

	ldr r0,emuflags
	tst r0,#PALTIMING
	ldreq r6,freqconvNTSC			;(3579545/mixrate)*4096
	ldrne r6,freqconvPAL			;(3546893/mixrate)*4096
	str r6,freqconv					;(sn76496/gba)*4096
	ldr r5,=FREQTBL					;Destination
	mov r4,#2048
frqloop2
	mov r0,r6
	mov r1,r4
;	subs r1,r4,#2
;	moveq r1,r6
	swi 0x060000					;BIOS Div, r0/r1.
	cmp r4,#7*2
	movmi r0,#0						;to remove real high tones.
	subs r4,r4,#2
	strh r0,[r5,r4]
	bhi frqloop2

	ldmfd sp!,{r4-r6,r10,lr}
	bx lr

;----------------------------------------------------------------------------
Vbl_SN76496_1
;----------------------------------------------------------------------------
;	ldr r0,soundmode				;if soundmode=0, no sound.
;	cmp r0,#0
;	bxeq lr

	mov r1,#REG_BASE
	strh r1,[r1,#REG_DM1CNT_H]		;DMA1 stop
	strh r1,[r1,#REG_DM2CNT_H]		;DMA2 stop
	ldr r2,pcmptr0
	str r2,[r1,#REG_DM1SAD]			;DMA1 src=..
	add r0,r2,#PCMWAVSIZE*2
	str r0,[r1,#REG_DM2SAD]			;DMA2 src=..
	ldr r0,=0xB640					;noIRQ fifo 32bit repeat incsrc fixeddst
	strh r0,[r1,#REG_DM1CNT_H]		;DMA1 go
	strh r0,[r1,#REG_DM2CNT_H]		;DMA2 go

	ldr r1,pcmptr1
	str r1,pcmptr0
	str r1,pcmptr
	str r2,pcmptr1

	bx lr
;----------------------------------------------------------------------------
Vbl_SN76496_2
;----------------------------------------------------------------------------
	;update DMA buffer for PCM
;	ldr r0,soundmode				;if soundmode=0, no sound.
;	cmp r0,#0
;	bxeq lr

	stmfd sp!,{r3-r12,lr}
PSGMixer
	adrl r11,GG_Volume_L
	ldmia r11,{r0-r10}		;load freq,addr,rng,pcmptr,noisefb,vol & len
;--------------------------
	and r11,r9,r1			;right volume
	and r12,r9,r0			;left volume
	add r9,r7,#PCMWAVSIZE*2

	bl mixer

	adrl r0,ch0freq
	stmia r0,{r2-r6}		;writeback freq,addr,rng

	ldmfd sp!,{r3-r12,pc}
;----------------------------------------------------------------------------
SN76496_W_OFF
	bx lr
;----------------------------------------------------------------------------
SN76496_W
	tst r0,#0x80
	andne r1,r0,#0x70
	strneb r1,lastreg
	ldreqb r1,lastreg
	movs r1,r1,lsr#5
	bcc SetFreq
DoVolume
	and r0,r0,#0x0F
	adr r2,Attenuation
	ldrb r0,[r2,r0]
	adr r2,ch0volume
	strb r0,[r2,r1]
	bx lr

SetFreq
	cmp r1,#3				;noise channel
	beq SetNoiseF
	tst r0,#0x80
	adr r2,ch0reg
	add r2,r2,r1,lsl#2
	andeq r0,r0,#0x3F
	movne r0,r0,lsl#4
	streqb r0,[r2,#1]
	strneb r0,[r2]
	ldr r0,[r2]
	mov r0,r0,lsr#3

	ldr r2,=FREQTBL
	ldrh r0,[r2,r0]
	adr r2,ch0freq
	add r2,r2,r1,lsl#2
	strh r0,[r2]
	cmp r1,#2				;ch2
	ldreq r2,ch3reg
	andeq r2,r2,#0x3
	cmpeq r2,#0x3
	streqh r0,ch3freq
	bx lr

SetNoiseF
	str r0,ch3reg
	tst r0,#0x4
	movne r2,#WFEED			;White noise
	moveq r2,#PFEED			;Periodic noise
	str r2,noisefb
	mov r2,#NSEED			;Preset seed
	str r2,rng
	ldr r2,freqconv
	ands r0,r0,#0x3
	moveq r1,r2,lsr#5		;These values sound ok
	movne r1,r2,lsr#6
	cmp r0,#0x2
	moveq r1,r2,lsr#7
	ldrhih r1,ch2freq
	strh r1,ch3freq
	bx lr

Attenuation
	DCB 0x3F,0x32,0x28,0x20,0x19,0x14,0x10,0x0D,0x0A,0x08,0x06,0x05,0x04,0x03,0x02,0x00
;----------------------------------------------------------------------------
GG_Stereo_W
;----------------------------------------------------------------------------
	adr r2,GG_Table
	and r1,r0,#0xF0
	ldr r1,[r2,r1,lsr#2]
	str r1,GG_Volume_L
	and r1,r0,#0x0F
	ldr r1,[r2,r1,lsl#2]
	str r1,GG_Volume_R
	bx lr
GG_Table
	DCD 0x00000000,0x0000003F,0x00003F00,0x00003F3F,0x003F0000,0x003F003F,0x003F3F00,0x003F3F3F
	DCD 0x3F000000,0x3F00003F,0x3F003F00,0x3F003F3F,0x3F3F0000,0x3F3F003F,0x3F3F3F00,0x3F3F3F3F
;----------------------------------------------------------------------------
SoundVariables
lastreg		DCB 0
			% 3

ch0reg		DCD 0
ch1reg		DCD 0
ch2reg		DCD 0
ch3reg		DCD 0

;----------------------------------------------------------------------------
GG_Volume_L	DCD 0x3F3F3F3F
GG_Volume_R	DCD 0x3F3F3F3F

ch0freq		DCW 0		;freq,addr, rng/noisefb & volume need to be like this for the mixer start.
ch0addr		DCW 0
ch1freq 	DCW 0
ch1addr		DCW 0
ch2freq 	DCW 0
ch2addr		DCW 0
ch3freq 	DCW 0
ch3addr		DCW 0

rng			DCD NSEED	;noise generator
pcmptr		DCD PCMWAV
noisefb		DCD WFEED	;noise feedback

ch0volume	DCB 0
ch1volume	DCB 0
ch2volume	DCB 0
ch3volume	DCB 0

mixlength	DCD 528		;mixlength (528=high, 304=low)
pcmptr0		DCD PCMWAV
pcmptr1		DCD PCMWAV+PCMWAVSIZE
;----------------------------------------------------------------------------

mixrate			DCD 532		;mixrate (532=high, 924=low), (mixrate=0x1000000/mixer_frequency)
freqconvPAL		DCD 0x70788	;Frequency conversion (0x70788=high, 0xC3581=low) (3546893/mixer_frequency)*4096
freqconvNTSC	DCD 0x71819	;Frequency conversion (0x71819=high, 0xC5247=low) (3579545/mixer_frequency)*4096
freqconv		DCD 0
soundmode		DCD 1		;soundmode (OFF/ON)

;----------------------------------------------------------------------------
	END

