	INCLUDE equates.h

	EXPORT empty_IO_R
	EXPORT empty_R
	EXPORT empty_W
	EXPORT ram0_W
	EXPORT ram1_W
	EXPORT ram1S_W
	EXPORT sram0_W
	EXPORT sram1_W
	EXPORT Korean_W
	EXPORT Codemaster_W
	EXPORT rom_W
	EXPORT bytecopy_
	EXPORT memset_
	EXPORT memorr_

	IMPORT BankSwitch0_W
	IMPORT BankSwitch1_W
	IMPORT BankSwitch2_W
	IMPORT BankSwitchR_W
	IMPORT BankSwitch0C_W
	IMPORT BankSwitch1C_W
	IMPORT BankSwitch2C_W
;----------------------------------------------------------------------------
 AREA rom_code, CODE, READONLY
;----------------------------------------------------------------------------
;----------------------------------------------------------------------------
bytecopy_		;void bytecopy(u8 *dst,u8 *src,int count)
;----------------------------------------------------------------------------
bytecopy_l
	subs r2,r2,#1
	ldrplb r3,[r1,r2]
	strplb r3,[r0,r2]
	bhi bytecopy_l
	bx lr

;----------------------------------------------------------------------------
empty_IO_R		;read bad IO address (error)
;----------------------------------------------------------------------------
	mov r11,r11				;No$GBA breakpoint
	mov r0,#0xFF			;SMS2
;	ldrb r0,[z80_pc,#-1]	;SMS
	mov pc,lr
;----------------------------------------------------------------------------
empty_R			;read bad address (error)
;----------------------------------------------------------------------------
	mov r11,r11				;No$GBA breakpoint
	mov r0,#0
	mov pc,lr
;----------------------------------------------------------------------------
empty_W			;write bad address (error)
;----------------------------------------------------------------------------
	mov r11,r11				;No$GBA breakpoint
	mov r0,#0xBA
	mov pc,lr
;----------------------------------------------------------------------------
Korean_W		;write ROM address (bankswitch)
;----------------------------------------------------------------------------
	cmp addy,#0xA000
	beq BankSwitch2_W
	mov r11,r11				;No$GBA breakpoint
	mov pc,lr
;----------------------------------------------------------------------------
Codemaster_W	;write ROM address (bankswitch)
;----------------------------------------------------------------------------
	cmp addy,#0x8000
	beq BankSwitch2C_W
	cmp addy,#0x4000
	beq BankSwitch1C_W
	cmp addy,#0x0000
	beq BankSwitch0C_W
;----------------------------------------------------------------------------
rom_W			;write ROM address (error)
;----------------------------------------------------------------------------
	mov r11,r11				;No$GBA breakpoint
	mov r0,#0xB0
	mov pc,lr
;----------------------------------------------------------------------------
	AREA wram_code3, CODE, READWRITE
;----------------------------------------------------------------------------
ram0_W			;write ram ($C000-$DFFF)
;----------------------------------------------------------------------------
	ldr r1,=EMU_RAM-0xC000
	strb r0,[r1,addy]
	mov pc,lr
;----------------------------------------------------------------------------
ram1_W			;write ram ($E000-$FFFF), mirror.
;----------------------------------------------------------------------------
	ldrb r1,BankMap4
	tst r1,#0x08				;BIOS?
	ldrne r1,=EMU_RAM-0xE000	;Skip forward to write with BankSwitch.
	strneb r0,[r1,addy]
	movne pc,lr
;----------------------------------------------------------------------------
ram1S_W			;write ram ($E000-$FFFF), mirror. Bankswitch
;----------------------------------------------------------------------------
	ldr r1,=EMU_RAM-0xE000
	strb r0,[r1,addy]
	mov r1,#0x00040000
	adds r1,r1,addy,lsl#16
	movmi pc,lr

	beq BankSwitchR_W		;$FFFC
	cmp r1,#0x20000
	bhi BankSwitch2_W		;$FFFF
	beq BankSwitch1_W		;$FFFE
	bmi BankSwitch0_W		;$FFFD
;	mov r11,r11
;	mov pc,lr
;----------------------------------------------------------------------------
sram0_W			;write sram bank0 ($8000-$9FFF),($A000-$BFFF)
;----------------------------------------------------------------------------
	ldr r1,=EMU_SRAM-0x8000
	strb r0,[r1,addy]
	mov pc,lr
;----------------------------------------------------------------------------
sram1_W			;write sram bank1 ($8000-$9FFF),($A000-$BFFF)
;----------------------------------------------------------------------------
	ldr r1,=EMU_SRAM-0x4000
	strb r0,[r1,addy]
	mov pc,lr
;----------------------------------------------------------------------------
;rom_R7			;read rom
;----------------------------------------------------------------------------
;	ldr r1,memmap_tbl+28
;	ldrb r0,[r1,addy]
;	mov pc,lr
;----------------------------------------------------------------------------
;rom_R			;read rom
;----------------------------------------------------------------------------
;	adr r0,memmap_tbl
;	ldr r1,[r0,r1,lsr#11]	;r1=addy & 0xe000
;	ldrb r0,[r1,addy]
;	mov pc,lr
;----------------------------------------------------------------------------
memset_ ;r0=dest r1=data r2=word count
;	exit with r0 & r1 unchanged, r2=0
;----------------------------------------------------------------------------
	subs r2,r2,#1
	strpl r1,[r0,r2,lsl#2]
	bhi memset_
	bx lr
;----------------------------------------------------------------------------
memorr_ ;r0=dest r1=data r2=word count
;	exit with r0 & r1 unchanged, r2=0, r3 trashed
;----------------------------------------------------------------------------
	subs r2,r2,#1
	ldrpl r3,[r0,r2,lsl#2]
	orrpl r3,r3,r1
	strpl r3,[r0,r2,lsl#2]
	bhi memorr_
	bx lr
;----------------------------------------------------------------------------
	END
