	INCLUDE equates.h
	INCLUDE memory.h
	INCLUDE gfx.h
	INCLUDE cart.h
	INCLUDE z80mac.h
	INCLUDE z80.h
	INCLUDE sn76496.h

	EXPORT IO_init
	EXPORT IO_reset
	EXPORT Z80_IN
	EXPORT Z80_OUT
	EXPORT Z80_IN_C
	EXPORT Z80_OUT_C
	EXPORT joycfg
	EXPORT spriteinit
	EXPORT suspend
	EXPORT refreshEMUjoypads
	EXPORT serialinterrupt
	EXPORT resetSIO
	EXPORT joy0state
	EXPORT joy1state
	EXPORT thumbcall_r1
	EXPORT gettime
	EXPORT vbaprint
	EXPORT waitframe
	EXPORT UnCompVram
	EXPORT LZ77UnCompVram
	EXPORT HuffUnComp
	EXPORT RLEUnCompVram
	EXPORT CheckGBAVersion
	EXPORT BankSwitchR_W
	EXPORT BankSwitch0_W
	EXPORT BankSwitch1_W
	EXPORT BankSwitch2_W
	EXPORT BankSwitch0C_W
	EXPORT BankSwitch1C_W
	EXPORT BankSwitch2C_W
	EXPORT reBankSwitchB_W
	EXPORT reBankSwitchR_W
	EXPORT reBankSwitch0_W
	EXPORT reBankSwitch1_W
	EXPORT reBankSwitch2_W
	EXPORT reBankSwitch0C_W
	EXPORT VDPdata_W_ptr


;----------------------------------------------------------------------------
 AREA rom_code, CODE, READONLY ;-- - - - - - - - - - - - - - - - - - - - - -
;----------------------------------------------------------------------------

UnCompVram
	ldrb r2,[r0]
	mov r2,r2,lsr#4
	cmp r2,#1
	beq LZ77UnCompVram
	cmp r2,#2
	beq HuffUnComp
	cmp r2,#3
	beq RLEUnCompVram
	bx lr

LZ77UnCompVram
	swi 0x120000
	bx lr

HuffUnComp
	swi 0x130000
	bx lr

RLEUnCompVram
	swi 0x150000
	bx lr


vbaprint
	swi 0xFF0000		;!!!!!!! Doesn't work on hardware !!!!!!!
	bx lr
waitframe
VblWait
	mov r0,#0				;don't wait if not necessary
	mov r1,#1				;VBL wait
	swi 0x040000			; Turn of CPU until VBLIRQ if not too late allready.
	bx lr
CheckGBAVersion
	ldr r0,=0x5AB07A6E		;Fool proofing
	mov r12,#0
	swi 0x0D0000			;GetBIOSChecksum
	ldr r1,=0xABBE687E		;Proto GBA
	cmp r0,r1
	moveq r12,#1
	ldr r1,=0xBAAE187F		;Normal GBA
	cmp r0,r1
	moveq r12,#2
	ldr r1,=0xBAAE1880		;Nintendo DS
	cmp r0,r1
	moveq r12,#4
	mov r0,r12
	bx lr

;----------------------------------------------------------------------------
IO_init
;----------------------------------------------------------------------------
	mov r1,#REG_BASE
	mov r0,#0x0008
	strh r0,[r1,#REG_DISPSTAT]	;vblank en

	add r2,r1,#REG_IE
	mov r0,#-1
	strh r0,[r2,#2]			;stop pending interrupts
	ldr r0,=irqhandler
	str r0,[r1,#-4]			;=AGB_IRQVECT
	ldr r0,=0x10A1			;key,serial,timer2,vblank. (serial interrupt=0x80)
	strh r0,[r2]
	mov r0,#1
	strh r0,[r2,#8]			;master irq enable

	ldr r0,=0x00C1EB84		;5244, pre *64. for 50Hz timing
	str r0,[r1,#REG_TM2CNT_L]

	bx lr
;----------------------------------------------------------------------------

scaleparms;
	DCD 0x0000,0x0100,0x0120,0x0080,0x0099,OAM_BUFFER1+6
;----------------------------------------------------------------------------
IO_reset
;----------------------------------------------------------------------------
	adr r5,scaleparms		;set sprite scaling params
	ldmia r5,{r0-r5}

	mov r6,#2
scaleloop
	strh r1,[r5],#8				;buffer1, buffer2. scaled normal sprites
	strh r0,[r5],#8
	strh r0,[r5],#8
	strh r2,[r5],#8
		strh r3,[r5],#8			;unscaled double sprites
		strh r0,[r5],#8
		strh r0,[r5],#8
		strh r3,[r5],#40
			strh r3,[r5],#8		;scaled double sprites
			strh r0,[r5],#8
			strh r0,[r5],#8
			strh r4,[r5],#136
		add r5,r5,#0x300
	subs r6,r6,#1
	bne scaleloop


	ldrb r0,machine
	cmp r0,#VDP_GG
	ldreq r1,=IOCtrl_GG_W
	ldrne r1,=IOCtrl_SMS_W
	ldr r2,=OUT_Table
	str r1,[r2,#4]

	ldr r0,=IN_Table
	ldreq r1,=Low0_IO_R
	ldrne r1,=empty_IO_R
	str r1,[r0],#4
	ldreq r1,=Low1_IO_R
	str r1,[r0]

	ldrne r0,biosbase_gg
	ldrne r1,biosbase
	cmpne r1,r0
	ldreq r1,=MemCtrl_GG_W
	ldrne r1,=MemCtrl_SMS_W
	str r1,[r2]

	ldr r2,=GGIO_Default
	ldmia r2!,{r0-r1}
	stmia r2,{r0-r1}
	
	ldrb r0,emuflags+1
	;..to spriteinit
;----------------------------------------------------------------------------
spriteinit	;build yscale_lookup tbl (called by ui.c) r0=scaletype
;called by ui.c:  void spriteinit(char scaletype) (pass scaletype in r0 because globals ptr isn't set up to read it)
;----------------------------------------------------------------------------
	ldr r3,=YSCALE_LOOKUP-16
	cmp r0,#SCALED
	bpl si1

;------------------ unscaled
si5
	sub r2,r3,#192-160
	mov r0,#164
si2	strb r0,[r2],#1
	cmp r2,r3
	bne si2

	add r2,r3,#256+16
	mov r0,#-31
si3	strb r0,[r3],#1
	add r0,r0,#1
	cmp r0,#164
	movpl r0,#164
	cmp r2,r3
	bne si3
	bx lr

;------------------ scaled
si1
	ldr r0,=0x00D55555		;5/6
	ldr r1,=0xe6000000		;-(16+16)*0.75
si4	mov r2,r1,lsr#24
	strb r2,[r3],#1
	add r1,r1,r0
	cmp r2,#0xe0
	bne si4
	bx lr
;----------------------------------------------------------------------------
suspend	;called from ui.c and z80.s
;----------------------------------------------------------------------------
	mov r3,#REG_BASE

	ldr r1,=REG_P1CNT
	ldr r0,=0xc00c			;interrupt on start+sel
	strh r0,[r3,r1]

	ldrh r1,[r3,#REG_SGCNT_L]
	strh r3,[r3,#REG_SGCNT_L]	;sound off

	ldrh r0,[r3,#REG_DISPCNT]
	orr r0,r0,#0x80
	strh r0,[r3,#REG_DISPCNT]	;LCD off

	swi 0x030000

	ldrh r0,[r3,#REG_DISPCNT]
	bic r0,r0,#0x80
	strh r0,[r3,#REG_DISPCNT]	;LCD on

	strh r1,[r3,#REG_SGCNT_L]	;sound on

	ldr r1,=REG_P1
susloop
	ldrh r0,[r1]
	and r0,r0,#0xc
	eors r0,r0,#0xc
	bne susloop

	bx lr
;----------------------------------------------------------------------------
gettime	;called from ui.c
;----------------------------------------------------------------------------
	ldr r3,=0x080000c4		;base address for RTC
	mov r1,#1
	strh r1,[r3,#4]			;enable RTC
	mov r1,#7
	strh r1,[r3,#2]			;enable write

	mov r1,#1
	strh r1,[r3]
	mov r1,#5
	strh r1,[r3]			;State=Command

	mov r2,#0x65			;r2=Command, YY:MM:DD 00 hh:mm:ss
	mov addy,#8
RTCLoop1
	mov r1,#2
	and r1,r1,r2,lsr#6
	orr r1,r1,#4
	strh r1,[r3]
	mov r1,r2,lsr#6
	orr r1,r1,#5
	strh r1,[r3]
	mov r2,r2,lsl#1
	subs addy,addy,#1
	bne RTCLoop1

	mov r1,#5
	strh r1,[r3,#2]			;enable read
	mov r2,#0
	mov addy,#32
RTCLoop2
	mov r1,#4
	strh r1,[r3]
	mov r1,#5
	strh r1,[r3]
	ldrh r1,[r3]
	and r1,r1,#2
	mov r2,r2,lsr#1
	orr r2,r2,r1,lsl#30
	subs addy,addy,#1
	bne RTCLoop2

	mov r0,#0
	mov addy,#24
RTCLoop3
	mov r1,#4
	strh r1,[r3]
	mov r1,#5
	strh r1,[r3]
	ldrh r1,[r3]
	and r1,r1,#2
	mov r0,r0,lsr#1
	orr r0,r0,r1,lsl#22
	subs addy,addy,#1
	bne RTCLoop3

	bx lr
;----------------------------------------------------------------------------
resetSIO	;r0=joycfg
;----------------------------------------------------------------------------
	bic r0,r0,#0x0f000000
	str r0,joycfg

	mov r2,#REG_BASE
	add r2,r2,#0x100

	mov r1,#0
	strh r1,[r2,#REG_RCNT]

	tst r0,#0x80000000
	moveq r1,#0x2000
	movne r1,   #0x6000
	addne r1,r1,#0x0002			;16bit multiplayer, 57600bps
	strh r1,[r2,#REG_SIOCNT]

	bx lr
;----------------------------------------------------------------------------
serialinterrupt
;----------------------------------------------------------------------------
	mov r3,#REG_BASE
	add r3,r3,#0x100

	mov r0,#0x1
serWait	subs r0,r0,#1
	bne serWait
	mov r0,#0x100				;time to wait.
	ldrh r1,[r3,#REG_SIOCNT]
	tst r1,#0x80				;Still transfering?
	bne serWait

	tst r1,#0x40				;communication error? resend?
	bne sio_err

	ldr r0,[r3,#REG_SIOMULTI0]	;Both SIOMULTI0&1

	and r2,r0,#0xff00			;From Master
	cmp r2,#0xaa00
	beq resetrequest			;$AAxx means Master GBA wants to restart

	ldr r2,sending
	tst r2,#0x10000
	beq sio_err
	strne r0,received0			;store only if we were expecting something
sio_err
	strb r3,sending+2			;send completed, r3b=0
	bx lr

resetrequest
	ldr r2,joycfg
	strh r0,received0
	orr r2,r2,#0x01000000
	bic r2,r2,#0x08000000
	str r2,joycfg
	bx lr

sending DCD 0
lastsent DCD 0
received0 DCD 0
;---------------------------------------------
xmit	;send byte in r0
;returns REG_SIOCNT in r1, received byte in r2, lastsent in r3, Z set if successful, r4-r5 destroyed
;---------------------------------------------
	ldr r3,sending
	tst r3,#0x10000				;last send completed?
	movne pc,lr

	mov r5,#REG_BASE
	add r5,r5,#0x100
	ldrh r1,[r5,#REG_SIOCNT]
	tst r1,#0x80				;clear to send?
	movne pc,lr

	ldrb r4,frame
	eor r4,r4,#0x55
	bic r4,r4,#0x80
	orr r0,r0,r4,lsl#8			;r0=new data to send

	ldr r2,received0
	cmp r2,#-1					;Check for uninitialized
	eoreq r2,r2,#0xf00

	eor r4,r2,r2,lsr#16			;P1 & P2
	tst r4,#0xff00				;in sync yet?
	beq checkold
	ldr r1,lastsent
	eor r4,r1,r2,lsr#16			;Has P2 missed an interrupt?
	tst r4,#0xff00
	streq r1,sending			;Send the value before this.
	b iofail
checkold
	ldr r4,sending
	ldr r1,lastsent
	eor r4,r4,r1				;Did we send an old value last time?
	tst r4,#0xff00
	bne iogood		;bne
	ldr r1,sending
	str r0,sending
	str r1,lastsent
iofail
	orrs r4,r4,#1				;Z=0 fail
	b notyet
iogood
	ands r4,r4,#0				;Z=1 ok
notyet
	ldr r1,sending
	streq r1,lastsent
	movne r0,r1					;resend last.

	orr r0,r0,#0x10000
	str r0,sending
	strh r0,[r5,#REG_SIOMLT_SEND]	;put data in buffer
	ldrh r1,[r5,#REG_SIOCNT]
	tst r1,#0x4					;Check if we're Master.
	bne endSIO

multip
	ldrh r1,[r5,#REG_SIOCNT]
	tst r1,#0x8					;Check if all machines are in multi mode.
	beq multip

	orr r1,r1,#0x80				;Set send bit
	strh r1,[r5,#REG_SIOCNT]	;start send

endSIO
	teq r4,#0
	mov pc,lr
;----------------------------------------------------------------------------
refreshEMUjoypads	;call every frame
;exits with Z flag clear if update incomplete (waiting for other player)
;is my multiplayer code butt-ugly?  yes, I thought so.
;i'm not trying to win any contests here.
;----------------------------------------------------------------------------
	mov r6,lr					;return with this..

		ldr r4,frame
		movs r0,r4,lsr#2		;C=frame&2 (autofire alternates every other frame)
	ldr r1,EMUjoypad
	mov r4,r1
	and r0,r1,#0xf0
		ldr r2,joycfg
		andcs r1,r1,r2
		movcss addy,r1,lsr#9	;R?
		andcs r1,r1,r2,lsr#16
	adr addy,dulr2lrud
	ldrb r0,[addy,r0,lsr#4]		;downupleftright



	;paddle stuff
	;--------------------------------
;	ldrb r3,paddle0x
;	tst r0,#0x8
;	addne r3,r3,#2
;	tst r0,#0x4
;	subnes r3,r3,#2
;	movmi r3,#0
;	cmp r3,#0xFF
;	movpl r3,#0xFF
;	strb r3,paddle0x
	;--------------------------------



	ands r3,r1,#3
	cmpne r3,#3
	eorne r3,r3,#3

	tst r2,#0x400				;Swap A/B?
	andne r3,r1,#3
	orr r0,r0,r3,lsl#4

	ldrb r3,config
	tst r3,#0x40
	tstne r4,#0x100				;R as Start?
	orrne r1,r1,#0x08
	and r1,r1,#0x08				;Start
;	mov r1,r1,lsl#4				;GameGear Start
;	strb r1,joy2state
	tst r3,#0x20
	tstne r4,#0x04				;Select as Reset?
	orrne r1,r1,#0x04
	orr r0,r0,r1,lsl#4

;	ldrb r1,joyExtra
;	and r1,r1,#0xC0
;	tst r3,#0x20
;	tstne r4,#0x04				;Select as Reset?
;	orrne r1,r1,#0x10
;	strb r1,joyExtra

	tst r2,#0x80000000
	bne multi

	tst r2,#0x40000000			;Player2?
	streqb r0,joy0state
	strneb r0,joy1state
fin	ands r0,r0,#0				;Z=1
	mov pc,r6
multi							;r2=joycfg
	tst r2,#0x08000000			;link active?
	beq link_sync

	bl xmit						;send joypad data for NEXT frame
	movne pc,r6					;send was incomplete!

	strb r2,joy0state			;master is player 1
	mov r2,r2,lsr#16
	strb r2,joy1state			;slave1 is player 2
	b fin

link_sync
	mov r1,#0x8000
	str r1,lastsent
	tst r2,#0x03000000
	beq stage0
	tst r2,#0x02000000
	beq stage1
stage2
	mov r0,#0x2200
	bl xmit						;wait til other side is ready to go

	moveq r1,#0x8000
	streq r1,lastsent
	ldr r2,joycfg
	biceq r2,r2,#0x03000000
	orreq r2,r2,#0x08000000
	str r2,joycfg

	b badmonkey
stage1							;other GBA wants to reset
	bl sendreset				;one last time..
	bne badmonkey

	orr r2,r2,#0x02000000		;on to stage 2..
	str r2,joycfg

	ldr r0,romnumber
	tst r4,#0x4					;who are we?
	beq sg1
	ldrb r3,received0			;slaves uses master's timing flags
	bic r1,r1,#COUNTRY+PALTIMING
	orr r1,r1,r3
sg1	bl loadcart					;game reset

	mov r1,#0
	str r1,sending				;reset sequence numbers
	str r1,received0
badmonkey
	orrs r0,r0,#1				;Z=0 (incomplete xfer)
	mov pc,r6
stage0	;self-initiated link reset
	bl sendreset				;keep sending til we get a reply
	b badmonkey
sendreset       ;exits with r1=emuflags, r4=REG_SIOCNT, Z=1 if send was OK
	mov r5,#REG_BASE
	add r5,r5,#0x100

	ldr r1,emuflags
	and r0,r1,#COUNTRY+PALTIMING
	orr r0,r0,#0xaa00			;$AAxx, xx=timing flags

	ldrh r4,[r5,#REG_SIOCNT]
	tst r4,#0x80				;ok to send?
	movne pc,lr

	strh r0,[r5,#REG_SIOMLT_SEND]
	orr r4,r4,#0x80
	strh r4,[r5,#REG_SIOCNT]	;send!
	mov pc,lr

joycfg DCD 0x00ff01ff ;byte0=auto mask, byte1=(saves R), byte2=R auto mask
;bit 31=single/multi, 30=1P/2P, 27=(multi) link active, 24=reset signal received
joy0state	DCB 0
joy1state	DCB 0
joy2state	DCB 0
joyExtra	DCB 0
paddle0x	DCB 0x80
			DCB 0,0,0
dulr2lrud	DCB 0x00,0x08,0x04,0x0C, 0x01,0x09,0x05,0x0D, 0x02,0x0A,0x06,0x0E, 0x03,0x0B,0x07,0x0F

;----------------------------------------------------------------------------
IOPortA_R		;Player1...
;----------------------------------------------------------------------------
;	mov r11,r11					;No$GBA breakpoint
	ldrb r0,joy0state
	and r0,r0,#0x3F
	ldrb r1,joy1state
	and r1,r1,#0x03
	orr r0,r0,r1,lsl#6
	eor r0,r0,#0xFF
	mov pc,lr
;----------------------------------------------------------------------------
IOPortB_R		;Player2...
;----------------------------------------------------------------------------
;	mov r11,r11					;No$GBA breakpoint
	ldrb r0,joy0state
	and r0,r0,#0x40
	ldrb r1,joy1state
	and r1,r1,#0x7C
	orr r0,r0,r1
	ldrb r1,joyExtra
	orr r0,r1,r0,lsr#2
	eor r0,r0,#0xFF
	mov pc,lr

;----------------------------------------------------------------------------
Low0_IO_R		;GG start button & country
;----------------------------------------------------------------------------
	ands addy,addy,#0xFF
	bne Low1_IO_R

	ldrb r1,emuflags
	and r1,r1,#3				;Jap / PAL bits
	ldrb r0,joy0state			;Port 0x00
	and r0,r0,#0x80
	orr r0,r0,r1,lsl#5
;	orr r0,r0,#0x40				;JAP/EXPORT
;	orr r0,r0,#0x20				;NTSC/PAL
	eor r0,r0,#0xC0
	mov pc,lr
;----------------------------------------------------------------------------
Low1_IO_R		;GG com port stuff
;----------------------------------------------------------------------------
	and addy,addy,#0xFF
	cmp addy,#6
	bhi empty_IO_R
	adr r1,GGIO
	ldrb r0,[r1,addy]
	mov pc,lr

;------------------------------------------------------------------------------
IOCtrl_GG_W
;------------------------------------------------------------------------------
	and addy,addy,#0xFF
	cmp addy,#6
	bhi IOCtrl_SMS_W
	adr r1,GGIO
	strb r0,[r1,addy]
	mov pc,lr
GGIO_Default
	DCB 0xC0,0x7F,0xFF,0x00,0xFF,0x00,0xFF,0
GGIO
	DCB 0xC0,0x7F,0xFF,0x00,0xFF,0x00,0xFF,0
;------------------------------------------------------------------------------
IOCtrl_SMS_W
;------------------------------------------------------------------------------
	ldrb r1,emuflags
	tst r1,#2					;Jap bit
	eoreq r0,r0,#0xF0
	bic r0,r0,r0,lsl#4
	and r0,r0,#0xA0				;only care about TH A/B right now.
	orr r0,r0,r0,lsl#1
	and r0,r0,#0xC0
	strb r0,joyExtra

	;paddle stuff
	;--------------------------------
;	ands r0,r0,#0x40
;	ldrb r0,joy0state
;	and r0,r0,#0xD0
;	orrne r0,r0,#0x20
;	ldrb r1,paddle0x
;	andne r1,r1,#0x0f
;	moveq r1,r1,lsr#4
;	eor r1,r1,#0x0F
;	orr r0,r0,r1
;	strb r0,joy0state
	;--------------------------------
	
	mov pc,lr

;------------------------------------------------------------------------------
MemCtrl_GG_W
;------------------------------------------------------------------------------
	and addy,addy,#0xFF
	cmp addy,#6
	bhi BankSwitchB_GG_W
	adr r1,GGIO
	strb r0,[r1,addy]
	beq GG_Stereo_W
	mov pc,lr

;------------------------------------------------------------------------------
reBankSwitchB_W					;bankswitch BIOS
;------------------------------------------------------------------------------
	ldrb r0,BankMap4
;------------------------------------------------------------------------------
BankSwitchB_W					;switch to BIOS
;------------------------------------------------------------------------------
	ldr r2,biosbase
	ldr r1,biosbase_gg
	cmp r2,r1
	beq BankSwitchB_GG_W

;------------------------------------------------------------------------------
MemCtrl_SMS_W
;------------------------------------------------------------------------------
;------------------------------------------------------------------------------
BankSwitchB_SMS_W					;switch to BIOS (SMS)
;------------------------------------------------------------------------------
;	mov r11,r11
	strb r0,BankMap4

	ldr r1,biosbase
	tst r0,#0x40				;CART ROM?
	ldreq r1,cartbase
	tst r0,#0x08				;BIOS?
	ldrne r1,cartbase

	ldr r0,rombase
	cmp r1,r0
	moveq pc,lr


	ldr r0,biosbase
	cmp r0,r1
	ldr r0,BankMap0
	streq r0,BankMap_Cart
	strne r0,BankMap_Bios
	ldreq r0,BankMap_Bios
	ldrne r0,BankMap_Cart
	str r0,BankMap0
	
	str r1,rombase
	sub r1,r1,#0x4000
	str r1,rombase4k
	sub r1,r1,#0x4000
	str r1,rombase8k

	ldrne r0,rommask_backup
	moveq r0,#0x7F
	str r0,rommask

	stmfd sp!,{lr}
	bl reBankSwitch0_W
	bl reBankSwitch1_W
	ldmfd sp!,{lr}
	b reBankSwitch2_W

;------------------------------------------------------------------------------
BankSwitchB_GG_W				;switch to BIOS for 0x0000-0x03FF
;------------------------------------------------------------------------------
	strb r0,BankMap4

	tst r0,#0x08				;BIOS?
	ldreq r0,biosbase
	ldrne r0,rombase
	str r0,memmap_tbl			;memmap_tbl
	b flush




;------------------------------------------------------------------------------
;						Codemasters mapper stuff
;------------------------------------------------------------------------------
;------------------------------------------------------------------------------
reBankSwitch0C_W				;0x0000-0x3FFF, Codemasters mapper
;------------------------------------------------------------------------------
	ldrb r0,BankMap1
;------------------------------------------------------------------------------
BankSwitch0C_W					;0x0000-0x3FFF
;------------------------------------------------------------------------------
	strb r0,BankMap1
	ldr r1,rommask
	and r0,r0,r1
	ldr r1,rombase
	add r0,r1,r0,lsl#14
	adr r2,memmap_tbl
	b Map16k
;------------------------------------------------------------------------------
reBankSwitch1C_W				;0x4000-0x7FFF, Codemasters mapper
;------------------------------------------------------------------------------
	ldrb r0,BankMap2
;------------------------------------------------------------------------------
BankSwitch1C_W					;0x4000-0x7FFF
;------------------------------------------------------------------------------
	strb r0,BankMap2
	ldr r1,rommask
	and r0,r0,r1
	ldr r1,rombase4k
	add r0,r1,r0,lsl#14
	adr r2,memmap_tbl+16*4

	stmfd sp!,{lr}
	bl Map16k
	ldmfd sp!,{lr}
;------------------------------------------------------------------------------
reBankSwitch2C_W				;0x8000-0xBFFF
;------------------------------------------------------------------------------
	ldrb r0,BankMap3
;------------------------------------------------------------------------------
BankSwitch2C_W					;0x8000-0xBFFF
;------------------------------------------------------------------------------
	strb r0,BankMap3
	ldrb r1,BankMap2
	tst r1,#0x80
	beq BankSwitch2_W			;Normal Mapping.

	ldr r1,rommask
	and r0,r0,r1
	ldr r1,rombase8k
	add r0,r1,r0,lsl#14
	adr r2,memmap_tbl+32*4
	stmfd sp!,{lr}
	mov r1,r0
	bl Map8k						;Only map Rom to 0x8000-0x9FFF
	ldmfd sp!,{lr}


	ldr r2,=MEMMAPTBL_
	ldr r0,[r2,#20]!
	ldr r1,[r2,#-8*4]			;WRMEMTBL_
	adr r2,writemem_tbl+16
	str r1,[r2,#4]				;writemem_tbl
	adr r2,memmap_tbl+40*4
	mov r1,r0
	b Map8k						;Only map RAM to 0xA000-0xBFFF
;----------------------------------------------------------------------------




;----------------------------------------------------------------------------
empty_IO_W
;----------------------------------------------------------------------------
	and addy,addy,#0xFF
	cmp addy,#0xFD				;SDC debugg
	bne empty_W
;------------------------------------------------------------------------------
OutputChar
;------------------------------------------------------------------------------
	adr r1,dummys
	strb r0,[r1]
	mov r0,r1
	b vbaprint
dummys
	DCB 0,0,0,0
;----------------------------------------------------------------------------
	INCLUDE visoly.s
 AREA wram_code1, CODE, READWRITE
;-- - - - - - - - - - - - - - - - - - - - - -

thumbcall_r1 bx r1


;----------------------------------------------------------------------------
Z80_IN_C
;----------------------------------------------------------------------------
	mov addy,z80bc,lsr#16
	and addy,addy,#0xFF
;----------------------------------------------------------------------------
Z80_IN
;----------------------------------------------------------------------------
	mov r1,addy,lsl#31
	orr r1,r1,addy,lsr#6
	ldr pc,[pc,r1,ror#29]
	DCD 0
IN_Table
	DCD Low0_IO_R
	DCD Low1_IO_R
	DCD VCounter_R
	DCD HCounter_R
	DCD VDPdata_R
	DCD VDPstat_R
	DCD IOPortA_R
	DCD IOPortB_R
;----------------------------------------------------------------------------
Z80_OUT_C
;----------------------------------------------------------------------------
	mov addy,z80bc,lsr#16
	and addy,addy,#0xFF
;----------------------------------------------------------------------------
Z80_OUT
;----------------------------------------------------------------------------
	mov r1,addy,lsl#31
	orr r1,r1,addy,lsr#6
	ldr pc,[pc,r1,ror#29]
	DCD 0
OUT_Table
	DCD MemCtrl_SMS_W
	DCD IOCtrl_SMS_W
	DCD SN76496_W
	DCD SN76496_W
VDPdata_W_ptr
	DCD VDPdata_W
	DCD VDPctrl_W
	DCD empty_IO_W
	DCD empty_IO_W

;------------------------------------------------------------------------------
reBankSwitch0_W					;0x0000-0x3FFF
;------------------------------------------------------------------------------
	ldrb r0,BankMap1
;------------------------------------------------------------------------------
BankSwitch0_W					;0x0000-0x3FFF
;------------------------------------------------------------------------------
	strb r0,BankMap1
	ldrb r1,BankMap4
	tst r1,#0x08
	ldr r1,rommask
	and r0,r0,r1
	adr r2,memmap_tbl
	ldreq r1,biosbase
	ldrne r1,rombase
	str r1,[r2],#4				;memmap_tbl
	ldr r1,rombase
	add r0,r1,r0,lsl#14
	b Map15k

;------------------------------------------------------------------------------
reBankSwitch1_W					;0x4000-0x7FFF
;------------------------------------------------------------------------------
	ldrb r0,BankMap2
;------------------------------------------------------------------------------
BankSwitch1_W					;0x4000-0x7FFF
;------------------------------------------------------------------------------
	strb r0,BankMap2
	ldr r1,rommask
	and r0,r0,r1
	ldr r1,rombase4k
	add r0,r1,r0,lsl#14
	adr r2,memmap_tbl+16*4
	b Map16k

;------------------------------------------------------------------------------
reBankSwitchR_W					;0x8000-0xBFFF
;------------------------------------------------------------------------------
	ldrb r0,BankMap0
;------------------------------------------------------------------------------
BankSwitchR_W					;switch between ROM & RAM for 0x8000
;------------------------------------------------------------------------------
	strb r0,BankMap0
	tst r0,#8					;RAM or ROM?
	beq reBankSwitch2_W

	and r0,r0,#4				;Bank 0/1?
	add r0,r0,#20

	ldr r2,=MEMMAPTBL_
	ldr r0,[r2,r0]!
	ldr r1,[r2,#-8*4]			;WRMEMTBL_
	b doBank2
;------------------------------------------------------------------------------
reBankSwitch2_W					;0x8000-0xBFFF
;------------------------------------------------------------------------------
	ldrb r0,BankMap3
;------------------------------------------------------------------------------
BankSwitch2_W					;0x8000-0xBFFF
;------------------------------------------------------------------------------
	strb r0,BankMap3
	ldrb r1,BankMap0
	tst r1,#8					;RAM or ROM?
	bne reBankSwitchR_W

	ldr r1,rommask
	and r0,r0,r1
	ldr r1,rombase8k
	add r0,r1,r0,lsl#14
	ldr r1,=WRMEMTBL_
	ldr r1,[r1]
doBank2
	adr r2,writemem_tbl+16
	str r1,[r2],#4				;writemem_tbl
	str r1,[r2],#(32+3)*4		;writemem_tbl
Map16k
	str r0,[r2],#4				;memmap_tbl
Map15k
	str r0,[r2],#4				;memmap_tbl
	mov r1,r0
	stmia r2!,{r0-r1}			;memmap_tbl
	stmia r2!,{r0-r1}			;memmap_tbl
	stmia r2!,{r0-r1}			;memmap_tbl
Map8k
	stmia r2!,{r0-r1}			;memmap_tbl
	stmia r2!,{r0-r1}			;memmap_tbl
	stmia r2!,{r0-r1}			;memmap_tbl
	stmia r2!,{r0-r1}			;memmap_tbl

;------------------------------------------
flush		;update cpu_pc & lastbank
;------------------------------------------
	ldr r1,lastbank
	sub z80pc,z80pc,r1
	encodePC
	mov pc,lr
;----------------------------------------------------------------------------
;----------------------------------------------------------------------------
	END
