	INCLUDE equates.h
	INCLUDE memory.h
	INCLUDE io.h
	INCLUDE z80.h
	INCLUDE z80mac.h
	INCLUDE sn76496.h

	EXPORT GFX_init
	EXPORT GFX_reset
	EXPORT scanlinebp_reset
	EXPORT debug_
	EXPORT AGBinput
	EXPORT EMUinput
	EXPORT paletteinit
	EXPORT PaletteTxAll
	EXPORT makeborder
	EXPORT newframe
	EXPORT midframe
	EXPORT endframe
	EXPORT VDPstat_R
	EXPORT VDPctrl_W
	EXPORT VDPdata_R
	EXPORT VDPdata_W
	EXPORT VDPctrl1_W
	EXPORT VDPctrl3_W
	EXPORT VCounter_R
	EXPORT HCounter_R
	EXPORT gfxstate
	EXPORT gammavalue
	EXPORT bcolor
	EXPORT toprows
	EXPORT gfxlayermask
	EXPORT oambufferready
	EXPORT twitch
	EXPORT g_flicker
	EXPORT fpsenabled
	EXPORT FPSValue
	EXPORT SPRS
	EXPORT vbldummy
	EXPORT vblankfptr
	EXPORT vblankinterrupt
	EXPORT irqhandler
	EXPORT SpriteScanner
	EXPORT VDPreg0_Update
	EXPORT g_lockpanel

	EXPORT DIRTYTILES

;	IMPORT RumbleInterrupt
;	IMPORT StartRumbleComs

 AREA rom_code, CODE, READONLY

;----------------------------------------------------------------------------
GFX_init	;(called from main.c) only need to call once
;----------------------------------------------------------------------------
	mov addy,lr

	mov r0,#AGB_VRAM
	mov r1,#0
	mov r2,#0x900
	bl memset_					;clear GBA VRAM
;	mov r0,#AGB_VRAM
	add r0,r0,#0x4000
	mov r1,#0
	mov r2,#0x4000
	bl memset_					;clear GBA VRAM
	mov r0,#AGB_VRAM
	ldr r1,=0x20202020
	mov r2,#0x10
	bl memset_					;BGR color 0
	add r0,r0,#0x40
	ldr r1,=0x30303030
	mov r2,#0x10
	bl memset_					;BGR color 1

	mov r1,#0xffffff00			;build chr decode tbl
	ldr r2,=CHR_DECODE			;0x400
ppi
	mov r0,#0
	tst r1,#0x01
	orrne r0,r0,#0x10000000
	tst r1,#0x02
	orrne r0,r0,#0x01000000
	tst r1,#0x04
	orrne r0,r0,#0x00100000
	tst r1,#0x08
	orrne r0,r0,#0x00010000
	tst r1,#0x10
	orrne r0,r0,#0x00001000
	tst r1,#0x20
	orrne r0,r0,#0x00000100
	tst r1,#0x40
	orrne r0,r0,#0x00000010
	tst r1,#0x80
	orrne r0,r0,#0x00000001
	str r0,[r2],#4
	adds r1,r1,#1
	bne ppi

	bl paletteinit				;do palette mapping

	bx addy
;----------------------------------------------------------------------------
GFX_reset	;called with CPU reset
;----------------------------------------------------------------------------
	str lr,[sp,#-4]!

	ldr r0,=gfxstate
	mov r1,#0
	mov r2,#10				;10*4
	bl memset_				;clear GFX regs

	str r1,windowtop
	strb r1,ystart

	mov r1,#0x16
	bl VDPreg0_W
	mov r1,#0xA0
	bl VDPreg1_W
	mov r1,#0xFF
	bl VDPreg2_W			;nametable
	mov r1,#0xFF
	bl VDPregA_W			;IRQ counter

	mov r0,#0x0100
	str r0,BGoffset1
	mov r0,#0x0A00
	str r0,BGoffset2
	mov r0,#0x0D00
	str r0,BGoffset3

	ldr r0,=VDP_RAM
	mov r0,r0,ror#14
	str r0,vramaddr

	ldr r0,=DIRTYTILES
	mov r1,#0		
	mov r2,#0x200/4
	bl memset_

;	ldr r0,=VDP_RAM			;clear SMS VRAM
;	mov r1,#0		
;	mov r2,#0x4000/4
;	bl memset_

	mov r0,#AGB_OAM
	mov r1,#0x2a0
	mov r2,#0x100
	bl memset_				;no stray sprites please
	ldr r0,=OAM_BUFFER1
	mov r2,#0x200
	bl memset_
;	bl paletteinit			;do palette mapping
	bl makeborder
	bl scanlinebp_reset

	ldr pc,[sp],#4


;----------------------------------------------------------------------------
scanlinebp_reset
;----------------------------------------------------------------------------
	ldr r0,emuflags
	tst r0,#PALTIMING

	moveq r0,#0xDA			;NTSC
	moveq r1,#6
	movne r0,#0xF2			;PAL
	movne r1,#0x39

	str r0,scanlinebp
	strb r1,scanlineminus

	bx lr
;----------------------------------------------------------------------------
makeborder;		also called from UI.c, r0 = border type.
;----------------------------------------------------------------------------
	mov r1,#REG_BASE
	ldrb r0,machine
	cmp r0,#VDP_SMS
	moveq r0,#0x00B8			;0-184
	ldrne r0,=0x28B8			;40-184
	strh r0,[r1,#REG_WIN0H]		;Win0H
	moveq r0,#0x00A0			;0-160
	ldrne r0,=0x0898			;8-152
	strh r0,[r1,#REG_WIN0V]		;Win0V
	strh r0,[r1,#REG_WIN1V]		;Win1V
	moveq r0,#0x00F0			;0-240
	ldrne r0,=0x28C8			;40-200
	strh r0,[r1,#REG_WIN1H]		;Win1H


	ldrneb r0,bcolor
	cmpne r0,#2

	moveq r0,#0x1F40			;Disable Win0/1
	ldrne r0,=0x5F40			;Enable Win1
	ldr r2,=DisplayControl
	strh r0,[r2]

	ldr r0,=0x3F37
	biceq r0,r0,#0x0300			;r0=0x3C27
	ldr r2,=WindowIn01
	strh r0,[r2]
;	strh r0,[r1,#REG_WININ]		;WinIN0/1, Everything enabled inside Windows
	mov r0,#0x3F
	bicne r0,r0,#0x17			;r0=0x28
	strh r0,[r1,#REG_WINOUT]	;WinOUT0/1, SPR, BG0, BG1 & BG2 disable outside Win0
	bx lr
;----------------------------------------------------------------------------
paletteinit;	r0-r3 modified.
;called by ui.c:  void map_palette(char gammavalue)
;----------------------------------------------------------------------------
	stmfd sp!,{r4-r8,lr}
	mov r7,#0xF			;mask
	ldr r6,=MAPPED_RGB
	ldrb r1,gammavalue	;gamma value = 0 -> 4
	mov r4,#4096*2
	sub r4,r4,#2
nomap					;map 0000bbbbggggrrrr  ->  0bbbbbgggggrrrrr
	and r0,r7,r4,lsr#9	;Blue ready
	bl gprefix
	mov r5,r0

	and r0,r7,r4,lsr#5	;Green ready
	bl gprefix
	orr r5,r0,r5,lsl#5

	and r0,r7,r4,lsr#1	;Red ready
	bl gprefix
	orr r5,r0,r5,lsl#5

	strh r5,[r6,r4]
	subs r4,r4,#2
	bpl nomap

MapSG_Pal
	adr r7,SG_Palette
	ldr r8,=AGB_PALETTE+0x202
	ldr r6,=SMSPALBUFF+0x100
	mov r4,#16
nomapSG					;map rrrrrrrrggggggggbbbbbbbb  ->  0bbbbbgggggrrrrr
	ldrb r0,[r7,#2]		;Blue ready
	bl gammaconvert
	mov r5,r0

	ldrb r0,[r7,#1]		;Green ready
	bl gammaconvert
	orr r5,r0,r5,lsl#5

	ldrb r0,[r7],#3		;Red ready
	bl gammaconvert
	orr r5,r0,r5,lsl#5

	strh r5,[r6],#2
	strh r5,[r8],#0x20
	subs r4,r4,#1
	bne nomapSG

	ldmfd sp!,{r4-r8,lr}
	bx lr

;----------------------------------------------------------------------------
SG_Palette

;SMS version
;	DCB 0x00,0x00,0x00, 0x00,0x00,0x00, 0x00,0xAA,0x00, 0x00,0xFF,0x00, 0x00,0x00,0x55, 0x00,0x00,0xFF, 0x55,0x00,0x00, 0x00,0xFF,0xFF
;	DCB 0xAA,0x00,0x00, 0xFF,0x00,0x00, 0x55,0x55,0x00, 0xFF,0xFF,0x00, 0x00,0x55,0x00, 0xFF,0x00,0xFF, 0x55,0x55,0x55, 0xFF,0xFF,0xFF

;TMS9918 spec.
;	DCB 0,0,0,          0,0,0,          33,200,66,      94,220,120,     84,85,237,      125,118,252,    212,82,77,      66,235,245
;	DCB 252,85,84,      255,121,120,    212,193,84,     230,206,128,    33,176,59,      201,91,186,     204,204,204,    255,255,255

	DCB 0,0,0,          0,0,0,          36,218,36,      109,255,109,    36,36,255,      72,109,255,     182,36,36,      72,218,255
	DCB 255,36,36,      255,109,109,    218,218,36,     218,218,145,    36,145,36,      218,72,182,     182,182,182,    255,255,255

;----------------------------------------------------------------------------
gprefix
	orr r0,r0,r0,lsl#4
;----------------------------------------------------------------------------
gammaconvert;	takes value in r0(0-0xFF), gamma in r1(0-4),returns new value in r0=0x1F
;----------------------------------------------------------------------------
	rsb r2,r0,#0x100
	mul r3,r2,r2
	rsb r2,r3,#0x10000
	rsb r3,r1,#4
	orr r0,r0,r0,lsl#8
	mul r2,r1,r2
	mla r0,r3,r0,r2
	mov r0,r0,lsr#13

	bx lr
;----------------------------------------------------------------------------
PaletteTxAll		; Called from ui.c
;----------------------------------------------------------------------------
	stmfd sp!,{r4-r9,lr}
	ldr r3,=PALETTE_RAM
	mov r4,#0
txloop
	ldrh r0,[r3],#2
	mov r1,r4
	bl Write_Pal
	add r4,r4,#1
	cmp r4,#0x20
	bmi txloop

	ldmfd sp!,{r4-r9,lr}
	bx lr

;----------------------------------------------------------------------------
SpriteScanner_start
	stmfd sp!,{r3-r9}
;	mov r11,r11

	ldr r9,=VDP_RAM
	ldrb r0,satoffset
	and r0,r0,#0x7E
	add r9,r9,r0,lsl#7
	add r8,r9,#0x80

	ldrb r0,ntmask
	cmp r0,#0xC
	movne r2,#0xFFFFFFD0		;208 = 0xD0
	moveq r2,#0x200

	ldr r4,=SMSOAMBUFF
	add r3,r4,#0x80
	ldrb r5,scrstartline
	sub r1,r5,#0xF
	mov r6,#0
	mov r7,#0
ss1_loop
	ldrsb r0,[r9,r7]			;MasterSystem OBJ, r0=Ypos.
	cmp r0,r2
	beq ss1_end
	cmp r0,r5
	bgt ss1_chk
	cmp r0,r1
	bpl ss1_add
ss1_chk
	add r7,r7,#1
	cmp r7,#0x40
	bne ss1_loop
ss1_end
	ldr r0,=smsoamptr
	str r6,[r0]
	strb r2,[r4,r6,lsr#1]
	ldmfd sp!,{r3-r9}
	bx lr
	
ss1_add
	strb r0,[r4,r6,lsr#1]
	mov r0,r7,lsl#1
	ldrh r0,[r8,r0]				;MasterSystem OBJ, r4=Tile,Xpos.
	strh r0,[r3,r6]
	cmp r6,#0xFE
	addmi r6,r6,#2
	bmi ss1_chk
	b ss1_end

;----------------------------------------------------------------------------
VDPreg0_Update		;called from ui.c
;----------------------------------------------------------------------------
	stmfd sp!,{globalptr,lr}
	ldr globalptr,=|wram_globals0$$Base|
	ldrb r0,vdpmode1
	and r0,r0,#0x80
	mov r0,r0,lsr#5
	strb r0,lockpanel
	ldmfd sp!,{globalptr,lr}
	bx lr
;------------------------------------------------------------------------------
midframe	;called at line 0,16 or 32	(r0,r2 safe to use)
;------------------------------------------------------------------------------
	stmfd sp!,{r1,r3-r9,r11,lr}

	ldr r0,=SPRS
	ldrb r0,[r0]
	cmp r0,#0
	ldreq r0,=default_scanlinehook
	ldrne r0,=SpriteScanner
	str r0,scanlinehook
	adrne lr,mid_end
	bne SpriteScanner_start


	ldrb r0,vdpmode1
	tst r0,#4
	blne sprDMA_do_0
mid_end
	ldmfd sp!,{r1,r3-r9,r11,pc}

;-------------------------------------------------------------------------------
bg_finish	;end of frame...
;-------------------------------------------------------------------------------
	stmfd sp!,{r3-r9,r11,lr}


;	b bg_cont

;	ldrb r0,frame
;	tst r0,#0x7
;	ldmnefd sp!,{r3-r9,r11,pc}
bg_cont
;	mov r0,#0
;	strb r0,[r4]

	mov addy,#AGB_VRAM
	ldr r0,BGoffset2
	add addy,addy,r0,lsl#3
	ldr r5,=0xF000F000
	ldr r6,=0x000003FF
	ldr r7,=0x00010001
	ldrb lr,vdpyscroll1
	and r0,lr,#7
	mov lr,lr,lsr#3
	rsbs r1,r0,#4
	movmi r1,#0
	ldr r8,=TMAPBUFF
	ldrb r1,[r8,r1]!
	ldrb r0,ntmask
	cmp r0,#0xC
	ldr r11,=VDP_RAM
	addeq r11,r11,#0x700
	mov r9,#25
	addeq r9,r9,#4
	ldrb r0,lockpanel
	tst r0,#4
	movne r9,#28

	ldrb r0,vdpmode1
	tst r0,#4
	bne bgmode4

	ands r8,r0,#2		;mode2 or 0?
	ldrne r8,=0x01000100
	and r1,r1,#0xF
	add r3,r11,r1,lsl#10

	mov r4,addy
	mov r0,#0
	ldr r7,=0x80008000
	ldr r9,=0x00020002

	mov r6,#3
	ldrb r1,vdpmode2
	tst r1,#0x10		;mode1?
	beq bgmode02
;-------------------------------------------------------------------------------
bgmode1
	mov r6,#24
bgm1loop2
	mov r5,#16
bgm1loop
	ldrh r1,[r3],#2				;Read from MasterSystem Tilemap RAM
	orr r1,r1,r1,lsl#8
	bic r1,r1,#0xFF00
	orr r1,r1,r7

	str r9,[r4,r9,lsr#5]			;Write to GBA Tilemap RAM, BGR color
	str r1,[r4,#0x800]			;Write to GBA Tilemap RAM, behind sprites
	str r0,[r4],#4				;Write to GBA Tilemap RAM, in front of sprites
	subs r5,r5,#1
	bne bgm1loop
	add r3,r3,#8
	subs r6,r6,#1
	bne bgm1loop2

	ldmfd sp!,{r3-r9,r11,pc}

;----------------------------------------------------------------------------
showfps_		;fps output, r0-r3=used.
;----------------------------------------------------------------------------
	ldrb r0,fpschk
	subs r0,r0,#1
	movmi r0,#59
	strb r0,fpschk
	bxpl lr					;End if not 60 frames has passed

;	str lr,[sp,#-4]!
;	ldr r1,=StartRumbleComs
;	adr lr,ret_
;	bx r1
ret_
;	ldr lr,[sp],#4

	ldrb r0,fpsenabled
	tst r0,#1
	bxeq lr					;End if not enabled

	ldr r0,fpsvalue
	cmp r0,#0
	bxeq lr					;End if fps==0, to keep it from appearing in the menu
	mov r1,#0
	str r1,fpsvalue

	mov r1,#100
	swi 0x060000			;Division r0/r1, r0=result, r1=remainder.
	add r0,r0,#0x30
	strb r0,fpstext+5
	mov r0,r1
	mov r1,#10
	swi 0x060000			;Division r0/r1, r0=result, r1=remainder.
	add r0,r0,#0x30
	strb r0,fpstext+6
	add r1,r1,#0x30
	strb r1,fpstext+7
	

	adr r0,fpstext
	ldr r2,=DEBUGSCREEN
;	add r2,r2,r1,lsl#6
db1
	ldrb r1,[r0],#1
	orr r1,r1,#0x4100
	strh r1,[r2],#2
	tst r2,#0xE
	bne db1

	bx lr
;----------------------------------------------------------------------------
fpstext			DCB "FPS:    "
fpsenabled		DCB 0
fpschk			DCB 0
gammavalue		DCB 0
bcolor			DCB 0
toprows			DCB 0
				DCB 0
				DCB 0,0
;----------------------------------------------------------------------------
debug_		;debug output, r0=val, r1=line, r2=used.
;----------------------------------------------------------------------------
; [ DEBUG
	ldr r2,=DEBUGSCREEN
	add r2,r2,r1,lsl#6
db0
	mov r0,r0,ror#28
	and r1,r0,#0x0f
	cmp r1,#9
	addhi r1,r1,#7
	add r1,r1,#0x30
	orr r1,r1,#0x4100
	strh r1,[r2],#2
	tst r2,#15
	bne db0
; ]
	bx lr
;----------------------------------------------------------------------------
;----------------------------------------------------------------------------
	AREA wram_code2, CODE, READWRITE
irqhandler	;r0-r3,r12 are safe to use
;----------------------------------------------------------------------------
	mov r2,#REG_BASE
	mov r3,#REG_BASE
	ldr r1,[r2,#REG_IE]!
	and r1,r1,r1,lsr#16	;r1=IE&IF
	ldrh r0,[r3,#-8]
	orr r0,r0,r1
	strh r0,[r3,#-8]

		;---these CAN'T be interrupted
		ands r0,r1,#0x80
		strneh r0,[r2,#2]		;IF clear
;		bne RumbleInterrupt
		bne serialinterrupt
		;---

		;---these CAN be interrupted
		ands r0,r1,#0x01
		ldrne r12,vblankfptr
		bne jmpintr
		;----
		adreq r12,irq0
		moveq r0,r1		;if unknown interrupt occured clear it.
jmpintr
	strh r0,[r2,#2]		;IF clear

	mrs r3,spsr
	stmfd sp!,{r3,lr}
	mrs r3,cpsr
	bic r3,r3,#0x9f
	orr r3,r3,#0x1f			;--> Enable IRQ . Set CPU mode to System.
	msr cpsr_cf,r3
	stmfd sp!,{lr}
	adr lr,irq0

	mov pc,r12


irq0
	ldmfd sp!,{lr}
	mrs r3,cpsr
	bic r3,r3,#0x9f
	orr r3,r3,#0x92        		;--> Disable IRQ. Set CPU mode to IRQ
	msr cpsr_cf,r3
	ldmfd sp!,{r0,lr}
	msr spsr_cf,r0
vbldummy
	bx lr
;----------------------------------------------------------------------------
vblankfptr		DCD vbldummy			;later switched to vblankinterrupt
twitch			DCB 0
g_flicker 		DCB 1
SPRS			DCB 0					;SpriteScanning On/Off
gfxlayermask	DCB 0
vblankinterrupt;
;----------------------------------------------------------------------------
	stmfd sp!,{r4-r9,globalptr,lr}
	ldr globalptr,=|wram_globals0$$Base|

	bl Vbl_SN76496_1
	bl showfps_

	ldr r2,=DMA0BUFF	;setup DMA buffer for scrolling:
	mov r3,#160
	ldr r1,dmascrollbuff
	ldrb r6,vdpyscroll2
	ldr r7,scrollmask
	ldrb r9,lockpanel
	ldrb r0,emuflags+1
	cmp r0,#SCALED
	bhs vblscaled

vblunscaled
	mov r5,#0
	ldr r0,=toprows
	ldrb r0,[r0]
	cmp r0,#1
	bhi NoLock
	beq TopLock
	ldrb r0,vdpmode1
	tst r0,#0x40
	ldrneb r0,machine
	cmpne r0,#VDP_GG
	beq NoLock

TopLock
	mov r3,#16
	bl vbl9
	sub r5,r5,#0x10
	mov r3,#144
NoLock
	ldr r8,windowtop+12
	add r1,r1,r8
	add r6,r6,r8
	bl vbl9
	b vbl8
vbl9
	cmp r6,r7
	subpl r6,r6,r7
	movpl r7,#0x10000			;disable check next time.
	add r0,r5,r6
vbl7
	cmp r6,r7
	subeq r0,r0,r7
	add r6,r6,#1
	ldrb r12,[r1],#1
	orr r4,r12,r0,lsl#16
	str r4,[r2],#4
	str r4,[r2],#4
	str r4,[r2],#4
	orr r4,r12,r8,lsl#16
	str r4,[r2],r9
	subs r3,r3,#1
	bhi vbl7
	bx lr


vblscaled					;(scaled)
;	ldrb r0,ntmask
;	cmp r0,#0xC
;	adrne r5,vbl1
;	adreq r5,vbl3			;Fix sprite table also.
	adr r5,vbl1
	ldrb r0,ystart
	add r1,r1,r0
	add r6,r6,r0
	cmp r6,r7
	subpl r6,r6,r7
	mov r0,r6
	ldrb r8,g_flicker
	ldrb r4,twitch
	eors r4,r4,r8
	strb r4,twitch
	ldreqb r4,[r1],#1
	orreq r4,r4,r0,lsl#16
	streq r4,[r2],#4
	streq r4,[r2],#4
	streq r4,[r2],#4
	streqh r4,[r2],r9
	addeq r6,r6,#1
	cmp r6,r7
	subeq r0,r0,r7
	tst r9,#4
	blne panelscale
		ldrb r4,adjustblend
		add r4,r4,r0
		bl Mod6
		cmp r4,#0
		beq vbl3
		cmp r4,#2
		bmi vbl4
		beq vbl5
		cmp r4,#4
		bhi vbl2
		addmi r1,r1,#1
		bmi vbl6
vbl1
		ldrb r4,[r1],#1
		orr r4,r4,r0,lsl#16
		str r4,[r2],#4
		str r4,[r2],#4
		str r4,[r2],#4
		strh r4,[r2],r9
	add r6,r6,#1
	cmp r6,r7
	subeq r0,r0,r7
vbl2
		ldrb r4,[r1],#1
		orr r4,r4,r0,lsl#16
		str r4,[r2],#4
		str r4,[r2],#4
		str r4,[r2],#4
		strh r4,[r2],r9
	add r6,r6,#1
	cmp r6,r7
	subeq r0,r0,r7
vbl3
		ldrb r4,[r1],#1
		orr r4,r4,r0,lsl#16
		str r4,[r2],#4
		str r4,[r2],#4
		str r4,[r2],#4
		strh r4,[r2],r9
	add r6,r6,#1
	cmp r6,r7
	subeq r0,r0,r7
vbl4
		ldrb r4,[r1],#1
		orr r4,r4,r0,lsl#16
		str r4,[r2],#4
		str r4,[r2],#4
		str r4,[r2],#4
		strh r4,[r2],r9
	add r6,r6,#1
	cmp r6,r7
	subeq r0,r0,r7
vbl5
		ldrb r4,[r1],#2
		orr r4,r4,r0,lsl#16
		str r4,[r2],#4
		str r4,[r2],#4
		str r4,[r2],#4
		strh r4,[r2],r9
	add r6,r6,#1
	cmp r6,r7
	subeq r0,r0,r7
vbl6
		add r0,r0,#1
	add r6,r6,#1
	cmp r6,r7
	subeq r0,r0,r7

	subs r3,r3,#5
	movpl pc,r5						;vbl1 or vbl3

vbl8


	mov r1,#REG_BASE
	strh r1,[r1,#REG_DM0CNT_H]		;DMA0 stop
	strh r1,[r1,#REG_DM3CNT_H]		;DMA3 stop

	add r2,r1,#REG_DM3SAD

	ldr r0,oambufferready
	cmp r0,#0
	ldrne r3,dmaoambuffer			;DMA3 src, OAM transfer:
	movne r4,#AGB_OAM				;DMA3 dst
	movne r6,#0x84000000			;noIRQ 32bit incsrc incdst
	orrne r5,r6,#0x100			;128 sprites (1024 bytes)
	stmneia r2,{r3-r5}			;DMA3 go

	ldrne r3,=SMSPALBUFF			;DMA3 src, Palette transfer:
	movne r4,#AGB_PALETTE			;DMA3 dst
	orrne r5,r6,#0x88				;272 words (544 bytes)
	stmneia r2,{r3-r5}			;DMA3 go
	mov r0,#0
	str r0,oambufferready

	ldr r3,=DMA0BUFF				;setup HBLANK DMA for display scroll:
	add r4,r1,#REG_BG0HOFS			;set 1st value manually, HBL is AFTER 1st line
	tst r9,#4
	ldmeqia r3!,{r5-r7}
	ldmneia r3!,{r5-r8}
	stmeqia r4,{r5-r7}
	stmneia r4,{r5-r8}
	add r2,r1,#REG_DM0SAD
	ldr r5,=0xA6600003			;noIRQ hblank 32bit repeat incsrc inc_reloaddst
	add r5,r5,r9,lsr#2
	stmia r2,{r3-r5}				;DMA0 go

	ldr r2,BGoffset1
	add r0,r2,#0x0005
	strh r0,[r1,#REG_BG0CNT]
	ldr r3,=0x0283010A
	add r0,r2,r3
	strh r0,[r1,#REG_BG1CNT]
	add r0,r2,r3,lsr#16
	strh r0,[r1,#REG_BG2CNT]
	moveq r0,#0x4600
	addne r0,r2,r3
	strh r0,[r1,#REG_BG3CNT]

	ldrh r0,WindowIn01			;WinIN0/1
	bicne r0,r0,#0x0300			;r0=0x3C37
	strh r0,[r1,#REG_WININ]		;WinIN0/1, Everything enabled inside Windows

	ldrh r0,[r1,#REG_WINOUT]		;WinOUT0/1, SPR, BG0, BG1 & BG2 disable outside Win0
	orreq r0,r0,#8
	bicne r0,r0,#8
	strh r0,[r1,#REG_WINOUT]		;WinOUT0/1, SPR, BG0, BG1 & BG2 disable outside Win0

	ldrh r0,DisplayControl			;1d sprites, Win0, OBJ, BG0/1/2/3 enable. mode0.
	orrne r0,r0,#0x6000			;enable Win0 & 1
	ldrb r2,vdpmode2_bak2
	tst r2,#0x40
	biceq r0,r0,#0x1700			;Turn off sprites and bg
	ldrb r2,gfxlayermask
	bic r0,r0,r2,lsl#8
	strh r0,[r1,#REG_DISPCNT]		;set value manually

exit_vbl
	bl Vbl_SN76496_2
	ldmfd sp!,{r4-r9,globalptr,pc}

DisplayControl
	DCW 0x3F40
WindowIn01
	DCW 0x3F37

;------------------------------------------------------------------------------
panelscale
;------------------------------------------------------------------------------
	stmfd sp!,{r2-r3,lr}
	add r2,r2,#12+2
	mov r4,#0
paloop	
	strh r4,[r2],#16
	strh r4,[r2],#16
	add r4,r4,#1
	strh r4,[r2],#16
	strh r4,[r2],#16
	strh r4,[r2],#16
	subs r3,r3,#5
	bpl paloop

	ldmfd sp!,{r2-r3,pc}
;------------------------------------------------------------------------------
newframe	;called before line 0	(r0-r9 safe to use)
;------------------------------------------------------------------------------
	mov r0,#-1
	str r0,scanline			;reset scanline count
	mov r0,#0
	str r0,nametableline

	ldrb r0,vdpcounter
	str r0,lineirq
	ldrb r0,vdpyscroll
	strb r0,vdpyscroll1

	ldrb r0,vdpmode1
	ands r0,r0,#0x40
	movne r0,#15			;16 topmost lines frozen.
	str r0,scrollXline

	ldr r0,scrollbuff
	ldrb r1,vdpxscroll
	rsb r1,r1,#8
	streqb r1,[r0]
	ldrne r1,=0x08080808
	movne r2,#16/4
	bne memset_

	bx lr

;------------------------------------------------------------------------------
;midframe	;called at line 0,16 or 32	(r0,r2 safe to use)
;------------------------------------------------------------------------------
;	stmfd sp!,{r1,r3-r9,r11,lr}

;	ldrb r0,SPRS
;	cmp r0,#0
;	ldreq r0,=default_scanlinehook
;	ldrne r0,=SpriteScanner
;	str r0,scanlinehook
;	adrne lr,mid_end
;	bne SpriteScanner_start


;	ldrb r0,vdpmode1
;	tst r0,#4
;	blne sprDMA_do_0
;mid_end
;	ldmfd sp!,{r1,r3-r9,r11,pc}
;------------------------------------------------------------------------------
endframe	;called just before screen end (~line 192 & 168)	(r0,r2 safe to use)
;------------------------------------------------------------------------------
	stmfd sp!,{r1,r3-r9,r11,lr}

	ldr r0,=default_scanlinehook
	str r0,scanlinehook
	ldrb r0,nametable
	mov addy,#224
	bl NT_finnish
	bl bg_finish
;--------------------------
	adr lr,sDMARet
	ldrb r0,vdpmode1
	tst r0,#4
	bne sprDMA_do_1
	beq sprDMA_do_m2
sDMARet
;--------------------------
;	bl PaletteTxAll
;--------------------------
	ldrb r1,vdpxscroll
	bl VDPreg8_W


	ldr r2,=SMSPALBUFF
	ldr r1,=bcolor
	ldrb r0,[r1]
	cmp r0,#0
	ldreqb r1,machine
	cmpeq r1,#VDP_GG
	beq setbc
	ldrb r0,vdpmode1
	and r0,r0,#0x04					;mode4?
	ldrb r1,bdcolor
	and r1,r1,#0xF
	add r0,r1,r0,lsl#5
	add r3,r2,#0x100
	add r0,r3,r0,lsl#1
	ldrh r0,[r0]
setbc
	strh r0,[r2]


	mrs r5,cpsr
	orr r1,r5,#0x80			;--> Disable IRQ.
	msr cpsr_cf,r1

	ldrb r0,vdpyscroll1
	strb r0,vdpyscroll2

	ldrb r0,vdpmode2_bak1
	strb r0,vdpmode2_bak2

	ldr r0,dmaoambuffer
	ldr r1,tmpoambuffer
	str r0,tmpoambuffer
	str r1,dmaoambuffer

	ldr r0,scrollbuff
	ldr r1,dmascrollbuff
	str r0,dmascrollbuff
	str r1,scrollbuff

	adrl r0,BGoffset1
	ldmib r0,{r1-r2}		;load with pre increment
	ldr r3,BGoffset1
	stmia r0,{r1-r3}		;store with post increment

	mov r0,#1
	str r0,oambufferready

	adrl r0,windowtop		;load wtop, store in wtop+4.......load wtop+8, store in wtop+12
	ldmia r0,{r1-r3}		;load with post increment
	stmib r0,{r1-r3}		;store with pre increment

	msr cpsr_cf,r5			;--> restore mode,Enable IRQ.


	ldrb r4,novblankwait
	cmp r4,#2
	beq l03
l01
	ldr r0,emuflags
	tst r0,#PALTIMING
	moveq r1,#0x01			;VBL wait
	movne r1,#0x20			;Timer2 wait

	cmp r4,#1
	movne r0,#0				;wait for vblank if it hasn't allready happened.
	moveq r0,#1				;wait for next vblank.
	swi 0x040000			; Turn of CPU until IRQ if not too late allready.
	cmp r4,#3				;Check for slomo
	moveq r4,#0
	beq l01
l03

	adr lr,TransRet
;	ldrb r0,frame
;	tst r0,#0x1f
;	bne TransRet
	ldrb r0,vdpmode1
	tst r0,#4
	bne Transfer_VRAM_m4
	beq Transfer_VRAM_m2
TransRet
	ldmfd sp!,{r1,r3-r9,r11,lr}
	bx lr
;------------------------------------------------------------------------------
VDPctrl_W
;------------------------------------------------------------------------------
	ldrb r1,toggle
	eors r1,r1,#1
	strb r1,toggle

	ldr r1,vramaddr
	and r0,r0,#0xFF
	biceq r1,r1,#0xFC000000
	bicne r1,r1,#0x03FC0000
	orreq r1,r1,r0,lsl#26
	orrne r1,r1,r0,lsl#18
	str r1,vramaddr
	movne pc,lr

	movs r2,r0,lsr#6
	strb r2,vdpctrl
	ldr pc,[pc,r2,lsl#2]
	DCD 0
VDPdest
	DCD VDPctrl0_W
	DCD VDPctrl1_W
	DCD VDPctrl2_W
	DCD VDPctrl3_W
;------------------------------------------------------------------------------
VDPctrl0_W					;set read address, fill buffer.
;------------------------------------------------------------------------------
	mov r0,r1,ror#18
	ldrb r0,[r0]
	strb r0,vdpbuff
	add r1,r1,#0x00040000
	str r1,vramaddr
VDPctrl1_W
	adr r0,VDPdata_W
	str r0,VDPdata_W_ptr
	mov pc,lr
;------------------------------------------------------------------------------
VDPctrl3_W
;------------------------------------------------------------------------------
	ldrb r1,machine
	cmp r1,#VDP_GG
	adrne r0,CRAM_SMS_W
	adreq r0,CRAM_GG_W
	str r0,VDPdata_W_ptr
	mov pc,lr
;------------------------------------------------------------------------------
VDPctrl2_W
;------------------------------------------------------------------------------
	adrl r2,VDPdata_W
	str r2,VDPdata_W_ptr
	mov r1,r1,lsr#18
	and r0,r0,#0xF
	ldr pc,[pc,r0,lsl#2]
	DCD 0
VDPregs
	DCD VDPreg0_W
	DCD VDPreg1_W
	DCD VDPreg2_W
	DCD VDPreg3_W
	DCD VDPreg4_W
	DCD VDPreg5_W
	DCD VDPreg6_W
	DCD VDPreg7_W
	DCD VDPreg8_W
	DCD VDPreg9_W
	DCD VDPregA_W
	DCD VDPregF_W
	DCD VDPregF_W
	DCD VDPregF_W
	DCD VDPregF_W
	DCD VDPregF_W

;------------------------------------------------------------------------------
VDPreg0_W
;------------------------------------------------------------------------------
	strb r1,vdpmode1
	ldrb r0,dontstop
	tst r0,#1
	andne r1,r1,#0x80
	movne r1,r1,lsr#5
	strneb r1,lockpanel
	b SetHeight
;------------------------------------------------------------------------------
VDPreg1_W
;------------------------------------------------------------------------------
	strb r1,vdpmode2
;------------------------------------------------------------------------------
SetHeight
;------------------------------------------------------------------------------
	ldr r0,emuflags
	tst r0,#PALTIMING
	mov r2,#0
	movne r2,#0x18			;NTSC/PAL diff

	ldr r0,vdpmode1			;Both vdpmode regs
	tst r0,#2
	tstne r0,#0x1800		;224 and/or 240 height
	addeq r2,r2,#0xDA
	addne r2,r2,#0xEA
	str r2,scanlinebp
	moveq r0,#0xE
	movne r0,#0xC
	strb r0,ntmask
	moveq r0,#208
	movne r0,#0x200
	str r0,sprstop

	moveq r1,#32		;maxpan
	movne r1,#64
	add r0,r1,#192		;224/256
	str r0,scrollmask
	sub r0,r0,#32
	str r0,vblline
	moveq r0,#0
	movne r0,#6
	strb r0,ystart

	ldrb r0,machine
	cmp r0,#VDP_GG

	moveq r0,#152
	addeq r0,r0,r1,lsr#1
	addne r0,r1,#160
	str r0,endframeline

	mov r0,#0
	moveq r0,r1,lsr#1
	moveq r1,r1,lsr#1
	strb r0,minpan
	strb r1,maxpan
	addeq r0,r0,#8
	strb r0,scrstartline

	mov pc,lr
;------------------------------------------------------------------------------
VDPreg2_W
;------------------------------------------------------------------------------
	ldrb r0,nametable
	strb r1,nametable

	ldr addy,scanline	;addy=scanline
NT_finnish
;	add addy,addy,#1	;maybe check cycles and add 2 sometimes?
	cmp addy,#224
	movhi addy,#224
	adr r2,nametableline
	swp r1,addy,[r2]	;r1=lastline, lastline=scanline

	ldr r2,=TMAPBUFF
	add r1,r2,r1
	add r2,r2,addy
nt1
	strb r0,[r2],#-1	;fill backwards from scanline to lastline
	cmp r2,r1
	bpl nt1
	mov pc,lr

nametableline DCD 0 ;..was when?

;------------------------------------------------------------------------------
VDPreg3_W						;Color Table - offset
;------------------------------------------------------------------------------
	strb r1,ctoffset
	mov pc,lr
;------------------------------------------------------------------------------
VDPreg4_W						;Pattern Generator Table - offset
;------------------------------------------------------------------------------
	strb r1,pgoffset
	mov pc,lr
;------------------------------------------------------------------------------
VDPreg5_W						;Sprite Attribute Table - offset
;------------------------------------------------------------------------------
	strb r1,satoffset
	mov pc,lr
;------------------------------------------------------------------------------
VDPreg6_W						;Sprite tiles - offset
;------------------------------------------------------------------------------
	strb r1,sproffset
	mov pc,lr
;------------------------------------------------------------------------------
VDPreg7_W						;Backdrop Color
;------------------------------------------------------------------------------
	strb r1,bdcolor
	mov pc,lr
;------------------------------------------------------------------------------
VDPreg8_W						;Horizontal Scroll register
;------------------------------------------------------------------------------
	ldrb r0,vdpxscroll
	strb r1,vdpxscroll
	rsb r0,r0,#8

	ldr addy,scanline			;addy=scanline
	rsbs r2,cycles,#8*CYCLE
	adc addy,addy,#0			;Also add carry if cycles < 8
	cmp addy,#225
	movhi addy,#225
	ldr r1,scrollXline
	cmp r1,addy
	movpl pc,lr
	str addy,scrollXline

	ldr r2,scrollbuff
	add r1,r2,r1
	add r2,r2,addy
sx1
	strb r0,[r2],#-1			;fill backwards from scanline to lastline
	cmp r2,r1
	bhi sx1
	mov pc,lr

scrollXline DCD 0 ;..was when?

;------------------------------------------------------------------------------
VDPreg9_W						;Vertical Scroll register
;------------------------------------------------------------------------------
	strb r1,vdpyscroll
	mov pc,lr
;------------------------------------------------------------------------------
VDPregA_W						;HBlank value
;------------------------------------------------------------------------------
	strb r1,vdpcounter
;	mov pc,lr
;------------------------------------------------------------------------------
VDPregF_W
;------------------------------------------------------------------------------
	mov pc,lr

;------------------------------------------------------------------------------
;VDPdata_W					;moved to bottom of file.
;------------------------------------------------------------------------------
;	str r0,vdpbuff			;write to vdpbuffer and clear vdptoggle.
;	ldr r1,vramaddr
;	add r2,r1,#0x00040000
;	str r2,vramaddr

;	mov r2,r1,ror#18
;	strb r0,[r2]

;	ldr r2,=DIRTYTILES
;	strb z80a,[r2,r1,lsr#23]
;	mov pc,lr
;------------------------------------------------------------------------------
CRAM_SMS_W
;------------------------------------------------------------------------------
	str r0,vdpbuff			;write to vdpbuffer and clear vdptoggle.
	ldr r1,vramaddr
	add r2,r1,#0x00040000
	str r2,vramaddr

	and r0,r0,#0x3F
	orr r2,r0,r0,lsl#4
	bic r2,r2,#0xFC
	and r0,r0,#0x0C
	orr r0,r2,r0,lsl#2
	orr r0,r0,r0,lsl#2

	movs r1,r1,lsr#18
	b Write_Pal

;------------------------------------------------------------------------------
CRAM_GG_W
;------------------------------------------------------------------------------
	ldr r1,vramaddr
	add r2,r1,#0x00040000
	str r2,vramaddr
	ldrb r2,vdpbuff
	str r0,vdpbuff			;write to vdpbuffer and clear vdptoggle.

	movs r1,r1,lsr#19
	movcc pc,lr

	and r0,r0,#0x0F
	orr r0,r2,r0,lsl#8
Write_Pal
	and r1,r1,#0x1F
	ldr r2,=PALETTE_RAM
	add r2,r2,r1,lsl#1
	strh r0,[r2]
	ldr r2,=MAPPED_RGB
	mov r0,r0,lsl#1
	ldrh r0,[r2,r0]
	ldr r2,=SMSPALBUFF
	add r2,r2,r1,lsl#1
	movs r1,r1,lsl#28
	strneh r0,[r2]				;bgtile palette
	streqh r0,[r2,#0x40]		;background palette
	movcs r1,#480
	strcsh r0,[r2,r1]			;sprite palette

	mov pc,lr
;------------------------------------------------------------------------------
VDPdata_R
;------------------------------------------------------------------------------
	ldr r1,vramaddr
	add r0,r1,#0x00040000
	str r0,vramaddr
	mov r1,r1,ror#18
	ldrb r1,[r1]
	ldrb r0,vdpbuff
	str r1,vdpbuff				;write to vdpbuffer and clear vdptoggle.

	mov pc,lr
;------------------------------------------------------------------------------
VDPstat_R
;------------------------------------------------------------------------------
;	mov r11,r11					;No$GBA breakpoint
	strb z80a,toggle
	ldrb r0,vdpstat
	strb z80a,vdpstat
	strb z80a,vdppending

	mov pc,lr
;------------------------------------------------------------------------------
VCounter_R
;------------------------------------------------------------------------------
;	mov r11,r11					;No$GBA breakpoint
	ldr r0,scanline
	ldr r1,scanlinebp
	cmp r0,r1
	ldrhib r1,scanlineminus
	subhi r0,r0,r1
	mov pc,lr
;------------------------------------------------------------------------------
HCounter_R
;------------------------------------------------------------------------------
;	mov r11,r11					;No$GBA breakpoint
	ldrb r0,scanline
	mov pc,lr

;----------------------------------------------------------------------------
SpriteScanner
	stmfd sp!,{r4-r9}

	ldr r9,=VDP_RAM
	ldrb r0,satoffset
	and r0,r0,#0x7E
	add r9,r9,r0,lsl#7
	add r8,r9,#0x100

	ldr r2,sprstop
	ldr r4,=SMSOAMBUFF
	add r5,r4,#0x80
;	ldr r1,scanline				;r1 is allready scanline.
	ldr r6,smsoamptr
	mov r7,#-0x80
ss0_loop
	ldrb r0,[r9],#1				;MasterSystem OBJ, r0=Ypos.
	cmp r0,r2
	cmpne r0,r1
	beq ss0_add
ss0_chk
	adds r7,r7,#2
	bne ss0_loop
ss0_end
	str r6,smsoamptr
	strb r2,[r4,r6,lsr#1]
	ldmfd sp!,{r4-r9}
	b default_scanlinehook
	
ss0_add
	cmp r0,r2
	beq ss0_end

	strb r0,[r4,r6,lsr#1]
	ldrh r0,[r8,r7]				;MasterSystem OBJ, r4=Tile,Xpos.
	strh r0,[r5,r6]
	cmp r6,#0xFE
	addmi r6,r6,#2
	bmi ss0_chk
	b ss0_end

;----------------------------------------------------------------------------
;sprDMA_do			;Called from endframe. YATX
;----------------------------------------------------------------------------
PRIORITY EQU 0x800				;0x800=AGB OBJ priority 2

sprDMA_do_0			;Called from newframe.
	ldr r2,tmpoambuffer			;Destination
	b sprpass_do_m4

sprDMA_do_1			;Called from endframe.
	ldr r2,tmpoambuffer			;Destination
	ldrb r0,SPRS
	cmp r0,#0
	ldrne addy,=SMSOAMBUFF
	movne r8,#128					;number of sprites
	bne sprs_do
	addeq r2,r2,#0x200


sprpass_do_m4
	mov r8,#64					;number of sprites
	ldr addy,=VDP_RAM
	ldrb r0,satoffset
	and r0,r0,#0x7E
	add addy,addy,r0,lsl#7
sprs_do
	ldr r1,emuflags
	and r5,r1,#0x300
	cmp r5,#SCALED_SPRITES*256
	movne r6,#0
	moveq r6,#0x100				;r6= scale obj

	ldr r11,sprstop
	ldrb r0,vdpmode2
	movs r0,r0,lsl#31			;double pixels/8x16 size
	orrmi r6,r6,#0x00000300		;scaling+double
	orrmi r6,r6,#0x02000000		;scaling param
	orrcs r6,r6,#0x00008000		;8x16 size

	mov r0,#0
	ldrb r4,ystart				;first scanline?
	cmp r5,#UNSCALED_AUTO*256	;do autoscroll
	bhi dm4_1
	movle r4,#0
	bne dm4_0
;	ldr r3,AGBjoypad
;	ands r3,r3,#0x300
;	eornes r3,r3,#0x300
;	bne dm4_0					;stop if L or R pressed (manual scroll)
	ldrb r0,[addy,r1,lsr#16]	;follow sprite
;	tst r1,#FOLLOWMEM
;	ldreqb r0,[addy,r1,lsr#16]		;follow sprite
;	ldrneb r0,[cpu_zpage,r1,lsr#16]	;follow memory
	sub r0,r0,#0x60
	adds r0,r0,r0,asr#3
	movmi r0,#0
	ldrb r1,maxpan
	cmp r0,r1
	movpl r0,r1
	str r0,windowtop
dm4_0
	ldr r0,windowtop+8
dm4_1
	add r4,r4,r0
	ldr r5,=YSCALE_LOOKUP
	sub r5,r5,r4
	add r9,addy,#0x80
	mov r7,#PRIORITY+0x200
	orr r7,r7,#0x10000000		;For faster Y lookup.
	ldrb r0,sproffset			;First or second half of VRAM for sprites?
	tst r0,#4
	orrne r7,r7,#0x100
	ldrb r1,vdpmode1
	and r1,r1,#8
	add r1,r1,#8
	mov r1,r1,lsl#23
dm4_2
	ldrb r0,[addy],#1			;MasterSystem OBJ, r0=Ypos.
	ldrh r4,[r9],#2				;MasterSystem OBJ, r4=Tile,Xpos.
	cmp r0,r11
	beq dm4_3					;skip the rest if sprite Y=208
	and r3,r4,#0xFF
	rsb r3,r1,r3,lsl#23

	add r0,r7,r0,lsl#24
	ldrb r0,[r5,r0,lsr#24]		;y = scaled y
	orr r0,r0,r6				;size plus scaling?
	orr r0,r0,r3,lsr#7
	str r0,[r2],#4				;store OBJ Atr 0,1. Xpos, ypos, flip, scale/rot, size, shape.

	orr r0,r7,r4,lsr#8			;priority & tile offset
	bic r0,r0,r6,lsr#15			;only even tiles in 8x16 mode
	strh r0,[r2],#4				;store OBJ Atr 2. Pattern, palette.
	subs r8,r8,#1
	bne dm4_2
	bx lr

dm4_3
	mov r0,#0x2a0				;double, y=160
dm4_4
	str r0,[r2],#8
	subs r8,r8,#1
	bne dm4_4
	bx lr



;----------------------------------------------------------------------------
sprDMA_do_m2					;Called from endframe.
;----------------------------------------------------------------------------
	ldr r2,tmpoambuffer			;Destination

	ldr addy,=VDP_RAM
	ldrb r0,satoffset
	and r1,r0,#0x7F
	add addy,addy,r1,lsl#7

	ldr r1,emuflags
	and r5,r1,#0x300
	cmp r5,#SCALED_SPRITES*256
	movne r6,#0
	moveq r6,#0x100				;r6= scale obj

	ldrb r0,vdpmode2
	movs r0,r0,lsl#31			;double pixels/16x16 size
	orrmi r6,r6,r6,lsl#18		;scaling param
	orrmi r6,r6,#0x00000300		;scaling+double
	orrmi r6,r6,#0x02000000		;scaling param
	orrcs r6,r6,#0x00008000		;16x16 size

	mov r0,#0
	ldrb r4,ystart				;first scanline?
	cmp r5,#UNSCALED_AUTO*256	;do autoscroll
	bhi dm2_1
	movle r4,#0
	bne dm2_0
;	ldr r3,AGBjoypad
;	ands r3,r3,#0x300
;	eornes r3,r3,#0x300
;	bne dm2_0					;stop if L or R pressed (manual scroll)
	ldrb r0,[addy,r1,lsr#16]	;follow sprite
;	tst r1,#FOLLOWMEM
;	ldreqb r0,[addy,r1,lsr#16]		;follow sprite
;	ldrneb r0,[cpu_zpage,r1,lsr#16]	;follow memory
	sub r0,r0,#0x60
	adds r0,r0,r0,asr#3
	movmi r0,#0
	ldrb r1,maxpan
	cmp r0,r1
	movpl r0,r1
	str r0,windowtop
dm2_0
	ldr r0,windowtop+8
dm2_1
	add r4,r4,r0
	ldr r5,=YSCALE_LOOKUP
	tst r6,r6,lsl#11			;16x16 size + scaling?
	subne r5,r5,#3
	sub r5,r5,r4
	mov r8,#32					;number of sprites
	mov r7,#PRIORITY+0x300
	mov r1,#0x04000000
dm2_2
	ldr r4,[addy],#4			;MasterSystem OBJ, r0=Ypos.
	mov r0,r4,lsl#24
	cmp r0,#0xD0000000
	beq dm2_3					;skip the rest if sprite Y=208
	and r9,r4,#0xFF00
	rsb r9,r1,r9,lsl#15
	tst r4,#0x80000000			;EC early clock, x -=32.
	subne r9,r9,#0x10000000

	add r0,r0,#0x10000000
	ldrb r0,[r5,r0,lsr#24]		;y = scaled y
	orr r0,r0,r6				;size plus scaling?
	tst r4,#0xF000000			;Color 0 sprite = invisible.
	moveq r0,#0x2a0				;double, y=160
	orr r3,r0,r9,lsr#7
	str r3,[r2],#4				;store OBJ Atr 0,1. Xpos, ypos, flip, scale/rot, size, shape.

	mov r4,r4,ror#24
	orr r3,r7,r4,lsr#24			;tiles + tileoffset + priority
	orr r3,r3,r4,lsl#12			;palette
	tst r6,#0x00008000			;16x16 size?
	bicne r3,r3,#3				;only even tiles in 16x16 mode
	strh r3,[r2],#4				;store OBJ Atr 2. Pattern, palette.

	moveq r0,#0x2a0				;double, y=160
	addne r3,r3,#2				;tile+2
	addne r9,r9,#0x04000000
	tstne r6,#0x00000200		;zoom?
	addne r9,r9,#0x04000000
	orr r0,r0,r9,lsr#7
	str r0,[r2],#4				;store OBJ Atr 0,1. Xpos, ypos, flip, scale/rot, size, shape.
	strh r3,[r2],#4				;store OBJ Atr 2. Pattern, palette.

	subs r8,r8,#1
	bne dm2_2
	bx lr

dm2_3
	mov r0,#0x2a0				;double, y=160
dm2_4
	str r0,[r2],#8
	str r0,[r2],#8
	subs r8,r8,#1
	bne dm2_4
	bx lr

;----------------------------------------------------------------------------
T_data
	DCD DIRTYTILES
VDP_RAM_ptr
	DCD VDP_RAM
	DCD CHR_DECODE
	DCD AGB_VRAM+0x08000		;BGR tiles
	DCD AGB_VRAM+0x14000		;SPR tiles
;----------------------------------------------------------------------------
Transfer_VRAM_m0
;----------------------------------------------------------------------------
	add r11,r5,r1,lsl#6
	ldrb r9,[r4,r1,lsl#1]
	orr r0,r9,#0x0F
	strb r0,[r4,r1,lsl#1]
	orr r9,r9,r9,lsl#8
	orr r9,r9,r9,lsl#16
	and r2,r2,#0x07
	add r5,r5,r2,lsl#11
	add r4,r4,r2,lsl#6
	ldr r8,=0x11111111
	mov r1,#0
tileloop0_0
	ldr r0,=0x0F0F0F0F
	ldr addy,[r4]
	orr r2,addy,r0
	str r2,[r4],#4
	and addy,addy,r9
	tst addy,#0x0000000F
	addne r1,r1,#0x20
	bleq tileloop0_1
	tst addy,#0x00000F00
	addne r1,r1,#0x20
	bleq tileloop0_1
	tst addy,#0x000F0000
	addne r1,r1,#0x20
	bleq tileloop0_1
	tst addy,#0x0F000000
	addne r1,r1,#0x20
	bleq tileloop0_1
	cmp r1,#0x0800
	bne tileloop0_0

	b tileloop_spr
;----------------------------------------------------------------------------
Transfer_VRAM_m2
;----------------------------------------------------------------------------
	ldrb r2,vdpmode2
	tst r2,#0x40				;Screen on?
	moveq pc,lr
	stmfd sp!,{r10,r11,lr}
	adr r1,T_data
	ldmia r1,{r4-r8}
	ldrb r1,ctoffset
	ldrb r2,pgoffset
	tst r0,#2
	beq	Transfer_VRAM_m0
	and r1,r1,#0x80
	add r11,r5,r1,lsl#6
	add r9,r4,r1,lsl#1
	and r2,r2,#0x04
	add r5,r5,r2,lsl#11
	add r4,r4,r2,lsl#6
	ldr r8,=0x11111111
	mov r1,#0

tileloop2_0
	ldr r0,=0x0F0F0F0F
	ldr addy,[r4]
	orr r2,addy,r0
	str r2,[r4],#4
	ldr r2,[r9]
	and addy,addy,r2
	orr r2,r2,r0
	str r2,[r9],#4
	tst addy,#0x0000000F
	addne r1,r1,#0x20
	bleq tileloop2_2
	tst addy,#0x00000F00
	addne r1,r1,#0x20
	bleq tileloop2_2
	tst addy,#0x000F0000
	addne r1,r1,#0x20
	bleq tileloop2_2
	tst addy,#0x0F000000
	addne r1,r1,#0x20
	bleq tileloop2_2
	cmp r1,#0x1800
	bne tileloop2_0


;-----------------------------------------------------
tileloop_spr					;Mode0, 2 & 3 sprites.
;-----------------------------------------------------
	ldr globalptr,=|wram_globals0$$Base|	;need ptr regs init'd
	ldr r9,=0xF0F0F0F0
	ldrb r1,sproffset
	and r1,r1,#0x07
	mov r1,r1,lsl#11
	ldr r4,T_data
	ldr r5,VDP_RAM_ptr
	add r4,r4,r1,lsr#5
	add r7,r7,#0xE000						;Sprites @ 0x06016000
	sub r7,r7,r1,lsl#2
	add r8,r1,#0x800
tileloop2_1
	ldr addy,[r4]
	orr r2,addy,r9
	str r2,[r4],#4
	tst addy,#0x000000F0
	addne r1,r1,#0x20
	bleq tileloop2_3
	tst addy,#0x0000F000
	addne r1,r1,#0x20
	bleq tileloop2_3
	tst addy,#0x00F00000
	addne r1,r1,#0x20
	bleq tileloop2_3
	tst addy,#0xF0000000
	addne r1,r1,#0x20
	bleq tileloop2_3
	cmp r1,r8
	bne tileloop2_1

	ldmfd sp!,{r10,r11,pc}

;----------------------------------------------------------------------------
;----------------------------------------------------------------------------
tileloop0_1
	bic r2,r1,#0x1800
	ldrb r2,[r11,r2,lsr#6]
	mov r3,r2,lsr#4
	and r2,r2,#0x0F
tileloop0_2
	ldrb r0,[r5,r1]
	ldr r0,[r6,r0,lsl#2]
	mul r10,r0,r3
	eor r0,r0,r8
	mla r10,r0,r2,r10
	str r10,[r7,r1,lsl#2]
	add r1,r1,#1
	tst r1,#0x1F
	bne tileloop0_2

	mov pc,lr

tileloop2_2
	ldrb r2,[r11,r1]
	ldrb r0,[r5,r1]
	ldr r0,[r6,r0,lsl#2]
	mov r3,r2,lsr#4
	mul r3,r0,r3
	eor r0,r0,r8
	and r10,r2,#0x0F
	mla r3,r0,r10,r3
	str r3,[r7,r1,lsl#2]
	add r1,r1,#1
	tst r1,#0x1F
	bne tileloop2_2

	mov pc,lr

tileloop2_3
	ldrb r0,[r5,r1]
	ldr r0,[r6,r0,lsl#2]
	str r0,[r7,r1,lsl#2]
	add r1,r1,#1
	tst r1,#0x1F
	bne tileloop2_3

	mov pc,lr

;----------------------------------------------------------------------------
Transfer_VRAM_m4
;----------------------------------------------------------------------------
	stmfd sp!,{lr}
	adr r0,T_data
	ldmia r0,{r4-r8}
	mov r9,#-1
	mov r1,#0

tileloop4_0
	ldr addy,[r4]
	str r9,[r4],#4
	tst addy,#0x000000FF
	addne r1,r1,#0x20
	bleq tileloop4_1
	tst addy,#0x0000FF00
	addne r1,r1,#0x20
	bleq tileloop4_1
	tst addy,#0x00FF0000
	addne r1,r1,#0x20
	bleq tileloop4_1
	tst addy,#0xFF000000
	addne r1,r1,#0x20
	bleq tileloop4_1
	cmp r1,#0x4000
	bne tileloop4_0

	ldmfd sp!,{pc}

tileloop4_1
	ldr r0,[r5,r1]

	ands r3,r0,#0x000000FF
	ldrne r3,[r6,r3,lsl#2]
	ands r2,r0,#0x0000FF00
	ldrne r2,[r6,r2,lsr#6]
	orrne r3,r3,r2,lsl#1
	ands r2,r0,#0x00FF0000
	ldrne r2,[r6,r2,lsr#14]
	orrne r3,r3,r2,lsl#2
	ands r2,r0,#0xFF000000
	ldrne r2,[r6,r2,lsr#22]
	orrne r3,r3,r2,lsl#3

	str r3,[r7,r1]
	str r3,[r8,r1]
	add r1,r1,#4
	tst r1,#0x1C
	bne tileloop4_1

	mov pc,lr

;-------------------------------------------------------------------------------
;bgchrfinish	;end of frame...
;-------------------------------------------------------------------------------
bgmode02			;fake

bgm2loop2
	mov r5,#16*8
bgm2loop
	ldrh r1,[r3],#2				;Read from MasterSystem Tilemap RAM
	orr r1,r1,r1,lsl#8
	bic r1,r1,#0xFF00
	orr r1,r1,r7

	str r9,[r4,r9,lsr#5]		;Write to GBA Tilemap RAM, BGR color
	str r1,[r4,#0x800]			;Write to GBA Tilemap RAM, behind sprites
	str r0,[r4],#4				;Write to GBA Tilemap RAM, in front of sprites
	subs r5,r5,#1
	bne bgm2loop
	add r7,r7,r8
	subs r6,r6,#1
	bne bgm2loop2

	ldmfd sp!,{r3-r9,r11,pc}


;-------------------------------------------------------------------------------
;bgchrfinish	;end of frame...
;-------------------------------------------------------------------------------
;	ldr r5,=0xF000F000
;	ldr r6,=0x000003FF
;	ldr r7,=0x00010001
; MSB          LSB
; ---pcvhnnnnnnnnn
bgmode4
	ldrb r1,[r8],#8
	ldrb r0,ntmask
	and r1,r1,r0
	add r3,r11,r1,lsl#10
	add r3,r3,lr,lsl#6
	add r4,addy,lr,lsl#6
	add lr,lr,#1
	ldr r0,scrollmask
	cmp lr,r0,lsr#3
	subpl lr,lr,r0,lsr#3

bgm4loop
	ldr r0,[r3],#4				;Read from MasterSystem Tilemap RAM

	and r1,r7,r0,lsr#11
	str r1,[r4,r7,lsr#4]		;Write to GBA Tilemap RAM, BGR color

	bic r1,r0,r5
	and r2,r1,r5,lsr#3
	add r1,r1,r2				;XY flip + color.

	str r1,[r4,#0x800]			;Write to GBA Tilemap RAM, behind sprites
	orr r1,r1,r7,lsl#9
	tst r0,#0x10000000
	biceq r1,r1,r6,lsl#16
	tst r0,#0x00001000
	biceq r1,r1,r6
	str r1,[r4],#4				;Write to GBA Tilemap RAM, in front of sprites
	tst r4,#0x3C				;32 tiles wide
	bne bgm4loop
	subs r9,r9,#1
	bne bgmode4

	ldmfd sp!,{r3-r9,r11,pc}


;----------------------------------------------------------------------------
Mod6			;In: r4. Out: r4 = MOD result.
;----------------------------------------------------------------------------
	stmfd sp!,{r1,r2}

	ldr r1,=0x2AAAAAAB
	umull r2,r1,r4,r1
	add r2,r1,r1,lsl#1
	sub r4,r4,r2,lsl#1

	ldmfd sp!,{r1,r2}
	bx lr
;----------------------------------------------------------------------------


tmpoambuffer	DCD OAM_BUFFER1
dmaoambuffer	DCD OAM_BUFFER2

scrollbuff		DCD SCROLLBUFF1
dmascrollbuff	DCD SCROLLBUFF2

smsoamptr		DCD 0
oambufferready	DCD 0

	DCD 0
	DCD 0
 LTORG
;------------------------------------------------------------------------------
VDPdata_W
;------------------------------------------------------------------------------
	str r0,vdpbuff			;write to vdpbuffer and clear vdptoggle.
	ldr r1,vramaddr
	add r2,r1,#0x00040000
	str r2,vramaddr

	mov r2,r1,ror#18
	strb r0,[r2]

;	adr r2,DIRTYTILES
	strb z80a,[pc,r1,lsr#23]
	mov pc,lr
DIRTYTILES
	% 512
;----------------------------------------------------------------------------
	AREA wram_globals1, CODE, READWRITE

FPSValue
	DCD 0
AGBinput			;this label here for main.c to use
	DCD 0 			;AGBjoypad (why is this in gfx.s again?  um.. i forget)
EMUinput	DCD 0	;EMUjoypad (this is what the EMU sees)
	DCD 1			;adjustblend
	DCD 0			;windowtop
wtop	DCD 0,0,0	;windowtop  (this label too)   L/R scrolling in unscaled mode
gfxstate
	DCD 0 ;vramaddr
	DCD 0 ;lineirq
	DCD 0 ;endframeline
	DCD 0 ;vblline
	DCD 0 ;scanlinebp
	DCD 0 ;scrollmask
	DCD 0 ;sprstop
vdpregs
	DCB 0 ;vdpmode1
	DCB 0 ;vdpmode2
	DCB 0 ;nametable
	DCB 0 ;ctoffset
	DCB 0 ;pgoffset
	DCB 0 ;satoffset
	DCB 0 ;sproffset
	DCB 0 ;bdcolor
	DCB 0 ;vdpxscroll
	DCB 0 ;vdpyscroll
	DCB 0 ;vdpcounter

	DCB 0 ;vdpctrl
	DCB 0,0 ;vdpbuff		vdpbuff + toggle need to be together in this way.
	DCB 0,0 ;toggle
	DCB 0 ;vdpstat		VBlank + spr stat
	DCB 0 ;vdppending	line interrupt pending
	DCB 0 ;vdpmode2_bak1
	DCB 0 ;vdpmode2_bak2
	DCB 0 ;vdpyscroll1	tripple buffering
	DCB 0 ;vdpyscroll2
	DCB 0 ;ntmask
	DCB 0 ;minpan
	DCB 0 ;maxpan
	DCB 0 ;scrstartline
	DCB 0 ;irqControl
	DCB 0 ;irqPending
	DCB 0 ;ystart
	DCB 0 ;sprBank
	DCB 0 ;scanlineminus
g_lockpanel
	DCB 0 ;lockpanel
;...update load/savestate if you move things around in here
;----------------------------------------------------------------------------
	END

