	INCLUDE equates.h
	INCLUDE memory.h
	INCLUDE z80mac.h
	INCLUDE z80.h
	INCLUDE io.h
	INCLUDE gfx.h
	INCLUDE sn76496.h

	IMPORT findrom			;from main.c
	IMPORT pogoshell		;from main.c
	IMPORT pogosize			;from main.c

	EXPORT loadcart
	EXPORT savestate
	EXPORT loadstate
	EXPORT g_emuflags
	EXPORT romstart			;used in sram.c
	EXPORT romnum
	EXPORT g_BIOSBASE_SMS
	EXPORT g_BIOSBASE_GG
	EXPORT g_scaling
	EXPORT g_scaling_set
	EXPORT g_cartflags
	EXPORT g_machine
	EXPORT g_config
;-------------------------------------------------------------------------------
 AREA rom_code, CODE, READONLY
;-------------------------------------------------------------------------------
;-------------------------------------------------------------------------------
loadcart ;called from C:  r0=rom number, r1=emuflags
;-------------------------------------------------------------------------------
	mov r2,#0
;-------------------------------------------------------------------------------
loadcartnew ;called from C:  r0=rom number, r1=emuflags, r2=clearmem?
;-------------------------------------------------------------------------------
	stmfd sp!,{r0-r2,r4-r11,lr}

	ldr r1,=findrom
	bl thumbcall_r1
	add r3,r0,#64		;r0 now points to rom image (including header)

	ldr globalptr,=|wram_globals0$$Base|	;need ptr regs init'd

	ldmfd sp!,{r0-r1}
	str r0,romnumber
	ldrb r0,scalemode
	orr r1,r1,r0,lsl#8
	tst r1,#4			;GGmode
	bicne r1,r1,#0x300	;Unscaled mode
	str r1,emuflags
	moveq r1,#VDP_SMS
	movne r1,#VDP_GG
	strb r1,machine

	ldr r1,=pogoshell
	ldrb r1,[r1]
	cmp r1,#0
						;r3=rombase til end of loadcart so DON'T FUCK IT UP
	ldrne r1,=pogosize
	ldrne r1,[r1]			;Size from Pogoshell
	ldreq r1,[r3,#-60]	;size of rom in bytes (from rombuilder).
	str r3,cartbase		;set cart base
	str r3,rombase		;set rom base
	sub r0,r3,#0x4000
	str r0,rombase4k		;set rom base4k
	sub r0,r3,#0x8000
	str r0,rombase8k		;set rom base8k

	cmp r1,#0x006000		;Mahjong, SG-1000 fix
	moveq r1,#0x008000	;-||-
	cmp r1,#0x00A000		;Monaco GP, SG-1000 fix
	moveq r1,#0x010000	;-||-
	cmp r1,#0x00C000		;Home Mahjong, SG-1000 fix
	moveq r1,#0x010000	;-||-
	cmp r1,#0x090000		;SF2 fix
	movhi r1,#0x100000	;-||-
	movs r2,r1,lsr#14
	subne r2,r2,#1
	str r2,rommask		;rommask=romsize-1
	str r2,rommask_backup	;rommask=romsize-1

	mov r0,r3
	bl MapperDetect
	mov r5,r0

	ldr r1,=0x02010000
	str r1,BankMap_Bios

	cmp r2,#0x2			;32kB
	ldrmi r1,=0x02010008	;RAM for SG1000 games
	cmp r0,#1
	ldreq r1,=0x00010000	;Codemaster...
	str r1,BankMap_Cart
	str r1,BankMap0

	ldr r4,=MEMMAPTBL_
	ldr r6,=WRMEMTBL_
	ldrmi r8,=rom_W
	ldreq r8,=Codemaster_W
	ldrhi r8,=Korean_W

	mov r0,#0
tbloop1
	and r1,r0,r2
	add r1,r3,r1,lsl#14
	str r1,[r4,r0,lsl#2]
	str r8,[r6,r0,lsl#2]
	add r0,r0,#1
	cmp r0,#3
	bne tbloop1

	ldrb r1,machine
	cmp r1,#VDP_GG
	beq NoGGHeader
	ldrne r0,rombase
	addne r0,r0,#0x8000
	ldrneb r0,[r0,#-1]
	andne r0,r0,#0xF0
	cmpne r0,#0x50			;GG Japan
	cmpne r0,#0x60			;GG Export
	cmpne r0,#0x70			;GG International
NoGGHeader
	ldreq r1,biosbase_gg		;GG
	ldrne r1,biosbase_sms		;SMS
	cmp r1,#0
	moveq r1,r3
	str r1,biosbase
	mov r0,#7				;7 BIOS
	str r1,[r4,r0,lsl#2]		;MemMap
	str r8,[r6,r0,lsl#2]		;WrMem

	ldr r1,=EMU_RAM
	ldr r8,=ram0_W
	mov r0,#3				;3 RAM
	str r1,[r4,r0,lsl#2]		;MemMap
	str r8,[r6,r0,lsl#2]		;WrMem

	cmp r5,#0
	ldreq r8,=ram1S_W			;RAM with bank switch
	ldrne r8,=ram1_W			;RAM without bankswitch
	mov r0,#4				;4 RAM mirror
	str r1,[r4,r0,lsl#2]		;MemMap
	str r8,[r6,r0,lsl#2]		;WrMem

	ldr r1,=EMU_SRAM-0x8000
	ldr r8,=sram0_W			;5 SRAM
	mov r0,#5				;5 SRAM page 0
	str r1,[r4,r0,lsl#2]		;MemMap
	str r8,[r6,r0,lsl#2]		;WrMem

	ldr r1,=EMU_SRAM-0x4000
	ldr r8,=sram1_W			;6 SRAM
	mov r0,#6				;6 SRAM page 1
	str r1,[r4,r0,lsl#2]		;MemMap
	str r8,[r6,r0,lsl#2]		;WrMem


	ldr r0,=default_scanlinehook
	str r0,scanlinehook

	mov z80pc,#0				;(eliminates any encodePC errors during mapper*init)
	str z80pc,lastbank


	ldrb r1,config
	tst r1,#0x80				;BIOS on/off
	moveq r4,#0xAB			;Map in cartridge
	movne r4,#0xE3			;Map in BIOS

	strb r4,BankMap4			;BIOS disable
	bl InitMapper_
	bl reBankSwitch0_W
	bl reBankSwitch1_W
	bl reBankSwitch2_W
	bl reBankSwitchB_W

	ldmfd sp!,{r2}
	cmp r2,#0
	bne NoMemClear

	ldr r0,=EMU_SRAM		;clear RAM
	mov r1,#0		
	mov r2,#0xE000/4
	bl memset_
	ldr r0,=EMU_RAM
	strb r4,[r0]			;simulate BIOS tag.
NoMemClear

	bl GFX_reset
	bl IO_reset
	bl SN76496_reset		;sound
	bl CPU_reset
	ldmfd sp!,{r4-r11,lr}
	bx lr

;----------------------------------------------------------------------------
InitMapper_	;rom paging..
;----------------------------------------------------------------------------

	ldr r2,=WRMEMTBL_
	adr r1,writemem_tbl

	ldr r0,[r2]
	str r0,[r1],#4			;writemem_tbl, WRITE_ROM
	str r0,[r1],#4			;writemem_tbl
	str r0,[r1],#4			;writemem_tbl
	str r0,[r1],#4			;writemem_tbl
	str r0,[r1],#4			;writemem_tbl
	str r0,[r1],#4			;writemem_tbl
	ldr r0,[r2,#3*4]
	str r0,[r1],#4			;writemem_tbl, WRITE_RAM
	ldr r0,[r2,#4*4]
	str r0,[r1],#4+192		;writemem_tbl, WRITE_RAM mirror

	ldr r0,[r2,#32+3*4]			;MEMMAPTBL_
	sub r0,r0,#0xC000
	str r0,[r1],#4				;memmap_tbl
	str r0,[r1],#4				;memmap_tbl
	str r0,[r1],#4				;memmap_tbl
	str r0,[r1],#4				;memmap_tbl
	str r0,[r1],#4				;memmap_tbl
	str r0,[r1],#4				;memmap_tbl
	str r0,[r1],#4				;memmap_tbl
	str r0,[r1],#4				;memmap_tbl

	sub r0,r0,#0x2000
	str r0,[r1],#4				;memmap_tbl
	str r0,[r1],#4				;memmap_tbl
	str r0,[r1],#4				;memmap_tbl
	str r0,[r1],#4				;memmap_tbl
	str r0,[r1],#4				;memmap_tbl
	str r0,[r1],#4				;memmap_tbl
	str r0,[r1],#4				;memmap_tbl
	str r0,[r1],#4				;memmap_tbl

	bx lr

;-------------------------------------------------------------------------------
MapperDetect		;In r0=rombase, r1=size.
					;Out r0=mapper, 0=Sega, 1=Codemaster, 2=Korean.
					;Adapted from Meka.
;-------------------------------------------------------------------------------
	cmp r1,#0x8000
	movle r0,#0
	bxle lr

	stmfd sp!,{r2-r7}
	mov r3,#0			;0x8000
	mov r4,#0			;0xA000
	mov r5,#0			;0xFFFF
	mov r6,#0x8000		;compare size
	mov r7,#-1
MDloop
	ldrb r1,[r0],#1
	cmp r1,#0x32		;Z80 opcode for: LD (xxxx), A
	beq MDe
MDe2
	subs r6,r6,#1
	bne MDloop
	mov r0,#0

	add r1,r5,#1		;2?
	cmp r3,r1
	movhi r0,#1
	cmp r4,r1
	movhi r0,#2

	ldmfd sp!,{r2-r7}
	bx lr

MDe
	ldrb r1,[r0]
	ldrb r2,[r0,#1]
	orr r1,r1,r2,lsl#8
	cmp r1,#0x4000		;For Ernie Els Golf. Hopefully doesn't break anything.
	addeq r3,r3,#1
	addeq r0,r0,#2
	cmp r1,#0x8000
	addeq r3,r3,#1
	addeq r0,r0,#2
	cmp r1,#0xA000
	addeq r4,r4,#1
	addeq r0,r0,#2
	cmp r1,r7,lsr#16
	addeq r5,r5,#1
	addeq r0,r0,#2
	b MDe2
;-------------------------------------------------------------------------------
savestate	;called from ui.c.
;int savestate(void): return size.
;-------------------------------------------------------------------------------
	stmfd sp!,{r4-r9,globalptr,lr}
	ldr globalptr,=|wram_globals0$$Base|

	bl fixCpuPC_save			;adjust cpu pc (so savestates are valid after moving roms around)

;	mov r6,r0					;r6=where to copy state
	ldr r6,=STATEPTR			;r6=where state is at
	mov r0,#0					;r0 holds total size (return value)

	adr r4,savelst				;r4=list of stuff to copy
	mov r3,#(lstend-savelst)/8	;r3=items in list
ss1	ldmia r4!,{r1,r2}			;r1=what to copy, r2=how much to copy
	add r0,r0,r2
ss0	ldr r5,[r1],#4
	str r5,[r6],#4
	subs r2,r2,#4
	bne ss0
	subs r3,r3,#1
	bne ss1

	mov r4,r0					;save r0.
	bl fixCpuPC_load
	ldr r1,=0xE040				;Size of all RAM including PaletteRAM.
	add r0,r1,r4

	ldmfd sp!,{r4-r9,globalptr,lr}
	bx lr

;savelst	DCD rominfo,8,EMU_SRAM,0xE000,cpustate,104,gfxstate-16,72,SoundVariables,56,BankState,16,SMSPALBUFF,544
;savelst	DCD rominfo,8,cpustate,104,gfxstate-16,72,SoundVariables,56,BankState,16,PALETTE_RAM,0xE040
savelst	DCD rominfo,8,cpustate,104,gfxstate-16,72,SoundVariables,56,BankState,16
lstend

fixCpuPC_save
	ldr r2,lastbank
	ldr r3,cpuregs+6*4	;Z80 PC
	sub r3,r3,r2
	str r3,cpuregs+6*4

	mov pc,lr

fixCpuPC_load
	ldr z80pc,cpuregs+6*4	;Z80 PC
	encodePC
	str z80pc,cpuregs+6*4

	mov pc,lr
;-------------------------------------------------------------------------------
loadstate	;called from ui.c
;void loadstate(int rom#)	 (stateptr must be word aligned)
;-------------------------------------------------------------------------------
	stmfd sp!,{r4-r9,globalptr,lr}
	ldr globalptr,=|wram_globals0$$Base|

;	ldr r0,romnumber
;	mov r6,r1					;r6=where state is at
	ldr r6,=STATEPTR			;r6=where state is at
	ldrb r4,scalemode			;preserve scalmode config

	ldr r1,[r6]					;emuflags
;	ldrb r1,[r6]				;emuflags
	ldrb r2,[r6,#1]				;emuflags
	strb r2,scalemode			;change scalemode before loadcart
;	orr r1,r1,r2,lsl#8
;	ldrb r2,[r6,#2]				;emuflags
;	orr r1,r1,r2,lsl#16
;	ldrb r2,[r6,#3]				;emuflags
;	orr r1,r1,r2,lsl#24

	mov r2,#1
	bl loadcartnew				;cart init, without memclear.
	strb r4,scalemode			;restore scalemode config

	mov r0,#(lstend-savelst)/8	;read entire state
	adr r4,savelst
ls1	ldmia r4!,{r1,r2}
ls0	ldr r5,[r6],#4
	str r5,[r1],#4
	subs r2,r2,#4
	bne ls0
	subs r0,r0,#1
	bne ls1

	ldrb r0,BankMap4
	ldr r1,biosbase
	tst r0,#0x40				;ROM?
	ldreq r1,cartbase
	tst r0,#0x08				;BIOS?
	ldrne r1,cartbase

	str r1,rombase
	sub r1,r1,#0x4000
	str r1,rombase4k
	sub r1,r1,#0x4000
	str r1,rombase8k

	bl reBankSwitch0_W
	bl reBankSwitch1_W
	bl reBankSwitch2_W

	bl fixCpuPC_load

	ldrb r2,vdpctrl
	cmp r2,#3
	adr lr,state_ret
	ldreq pc,=VDPctrl3_W
	ldr pc,=VDPctrl1_W
state_ret

	ldr r0,=DIRTYTILES
	mov r1,#0
	mov r2,#128
	bl memset_

	bl PaletteTxAll

	ldmfd sp!,{r4-r9,globalptr,lr}
	bx lr


;-------------------------------------------------------------------------------
 AREA wram_globals2, CODE, READWRITE

	DCD 0 ;biosbase
romstart
	DCD 0 ;cartbase
	DCD 0 ;rombase
	DCD 0 ;rombase4k
	DCD 0 ;rombase8k
romnum
	DCD 0 ;romnumber
rominfo                 ;keep emuflags/BGmirror together for savestate/loadstate
g_emuflags	DCB 0 ;emuflags        (label this so UI.C can take a peek) see equates.h for bitfields
g_scaling	DCB SCALED_SPRITES ;(display type)
	% 2   ;(sprite follow val)

	DCD 0 ;rommask
	DCD 0 ;rommask_backup
	DCD 0 ;BGoffset1
	DCD 0 ;BGoffset2
	DCD 0 ;BGoffset3
g_BIOSBASE_SMS
	DCD 0 ;biosbase_sms, SMS
g_BIOSBASE_GG
	DCD 0 ;biosbase_gg, GG
g_scaling_set
	DCB 0 ;scalemode(saved display type)
g_cartflags
	DCB 0 ;cartflags
g_machine
	DCB 0 ;machine
g_config
	DCB 0		;config, bit 7=BIOS on/off, bit 6=R as Start,
BankState
	DCD 0		;BankMap_Bios
	DCD 0		;BankMap_Cart
	DCB 0,0,0,0	;BankMap0,1,2,3
	DCB 0,0,0,0	;BankMap4, IO control (BIOS select), + alignment.
;----------------------------------------------------------------------------
	END

