/*Arculator 0.8 by Tom Walker
  MEMC1a emulation*/

int flybacklines;
#include <stdio.h>
#include "arc.h"
#include <allegro.h>
#include <winalleg.h>

unsigned long memctrl;
signed short soundbuf[2][50000];
int sinprog=0;
int sdmaena=0;
int bigcyc=0;
char err2[256];
FILE *olog;
int logsound;
int osmode;
int pagesize;
int memcpages[0x2000];
int samppos=0,sampbuf=0;
AUDIOSTREAM *as;
int spdcount;
FILE *soundf;
FILE *slogfile;
int stereoimages[8];

void initsound()
{
        unsigned short *p;
        if (!soundena) return;
        if (install_sound(DIGI_DIRECTX(0),MIDI_NONE,0))
        {
                if (install_sound(DIGI_AUTODETECT,MIDI_NONE,0))
                {
                        soundena=0;
                        return;
                }
        }
/*        if (install_sound(DIGI_AUTODETECT,MIDI_NONE,0))
        {
                soundena=0;
                return;
        }*/
        as=play_audio_stream(25000>>2,16,1/*stereo*/,125000>>1,255,128);
        p=0;
        while (!p)
        {
                p=(unsigned short *)get_audio_stream_buffer(as);
                sleep(0);
        }
        memset(p,0,25000);
        free_audio_stream_buffer(as);
//        soundf=fopen("sound.pcm","wb");
//        slogfile=fopen("sound.txt","wt");
}

void deinitsound()
{
        stop_audio_stream(as);
        remove_sound();
}

signed short lastbuffer[4]={0,0,0,0};

signed short getsample(signed short temp)
{
//        float tempf;
//        tempf=((float)lastbuffer[0]*((float)9/(float)16))+((float)lastbuffer[1]*((float)5/(float)16))+((float)lastbuffer[2]*((float)1/(float)16));
//        temp+=(tempf/2);
//        lastbuffer[2]=lastbuffer[1];
//        lastbuffer[1]=lastbuffer[0];
//        lastbuffer[0]=temp;
        return temp;
}

void mixsound()
{
        int c;
        unsigned short *p;
        unsigned short p2[(25000)>>1];
        short temp;
        float tempf;
        if (!soundena) return;
        p=0;
        for (c=0;c<((25000>>1)>>1);c++)
        {
                temp=(getsample(soundbuf[sampbuf^1][c<<3])/16);
                temp+=(getsample(soundbuf[sampbuf^1][(c<<3)+2])/16);
                temp+=(getsample(soundbuf[sampbuf^1][(c<<3)+4])/16);
                temp+=(getsample(soundbuf[sampbuf^1][(c<<3)+6])/16);
                tempf=((float)lastbuffer[0]*((float)13/(float)16))+((float)lastbuffer[1]*((float)1/(float)16));
                temp+=tempf;
                lastbuffer[1]=lastbuffer[0];
                lastbuffer[0]=temp;
                p2[c<<1]=temp^0x8000;
                temp=(getsample(soundbuf[sampbuf^1][(c<<3)+1])/16);
                temp+=(getsample(soundbuf[sampbuf^1][(c<<3)+3])/16);
                temp+=(getsample(soundbuf[sampbuf^1][(c<<3)+5])/16);
                temp+=(getsample(soundbuf[sampbuf^1][(c<<3)+7])/16);
                tempf=((float)lastbuffer[2]*((float)13/(float)16))+((float)lastbuffer[3]*((float)1/(float)16));
                temp+=tempf;
                lastbuffer[3]=lastbuffer[2];
                lastbuffer[2]=temp;
                p2[(c<<1)+1]=temp^0x8000;
        }
        while (!p)
        {
                p=(unsigned short *)get_audio_stream_buffer(as);
//                sleep(0);
        }
//        memcpy(p,&soundbuf[sampbuf^1][0],50000>>1);
        for (c=0;c<((25000>>1));c++) p[c]=p2[c];
        free_audio_stream_buffer(as);
}

signed short convbyte(unsigned char v)
{//                         7C       chord = 3     p = E/14
        signed short temp=1<<((v>>5)+4);
        temp+=(((v>>1)&0xF)<<(v>>5));
        if (v&1) temp=-temp;
        return temp;
/*        unsigned char temp=(1<<(v>>5))-1;             //  temp=7
        if (v&0x80) temp+=(((v>>1)&0xF)<<((v>>5)-4));  // +14<<
        else        temp+=(((v>>1)&0xF)>>(4-(v>>5)));
        temp>>=1;
        if (v&1) temp=(temp^0xFF)+1;
        return temp;*/
}

signed short samples[8];
int samplecount=0,sampledelay=0;
//float lastsamp;

unsigned short mixsample()
{
        signed short temp2=0;
        unsigned short *temp3;
        signed short temp=samples[0];//((signed short)((signed char)convbyte(samples[0])))*8;
//        float tempf;
        temp3=&temp2;
        temp2+=temp;
/*        temp=((signed short)((signed char)convbyte(samples[1])))*16;
        temp2+=temp;
        temp=((signed short)((signed char)convbyte(samples[2])))*16;
        temp2+=temp;
        temp=((signed short)((signed char)convbyte(samples[3])))*16;
        temp2+=temp;
        temp=((signed short)((signed char)convbyte(samples[4])))*16;
        temp2+=temp;
        temp=((signed short)((signed char)convbyte(samples[5])))*16;
        temp2+=temp;
        temp=((signed short)((signed char)convbyte(samples[6])))*16;
        temp2+=temp;
        temp=((signed short)((signed char)convbyte(samples[7])))*16;
        temp2+=temp;*/
//        putc((*temp3)&0xFF,soundf);
//        putc((*temp3)>>8,soundf);
/*        tempf=((float)lastbuffer[0]*((float)13/(float)16));
        temp2+=tempf;
        lastbuffer[1]=lastbuffer[0];
        lastbuffer[0]=temp2;*/
//        if (samppos&3)
//           soundbuf[sampbuf][(samppos>>2)]+=(*temp3);
//        else
//        if ((samppos&3)==3)
//        {
/*                tempf=((float)lastbuffer[1]*((float)13/(float)16));
                temp2+=tempf;
                lastbuffer[1]=lastbuffer[0];
                lastbuffer[0]=temp2;*/
//        }
           soundbuf[sampbuf][samppos++]=samples[2];//temp;
           soundbuf[sampbuf][samppos++]=samples[3];
//        samppos++;
        if (samppos==(50000))
        {
                samppos=0;
                sampbuf^=1;
        }
        return *temp3;
}


void resetsound()
{
        unsigned short *p;
        if (!soundena) return;
        samppos=sampbuf=0;
        stop_audio_stream(as);
        as=play_audio_stream(25000>>2,16,1/*stereo*/,125000>>1,255,128);
        p=0;
        while (!p)
        {
                p=(unsigned short *)get_audio_stream_buffer(as);
                sleep(0);
        }
        memset(p,0,25000);
        free_audio_stream_buffer(as);
        sampledelay=0;
}

int soundtime;
float sampdiff;
unsigned long spos,sdif,soend,sendN,sstart2;
int nextvalid;
#define getdmaaddr(addr) (((addr>>2)&0x7FFF)<<2)
void writememc(unsigned long a)
{
//        rpclog("Write MEMC %08X\n",a);
//        if (!slogfile) slogfile=fopen("slog.txt","wt");
/*        if (a&0x7080)
        {
                sprintf(s,"Write %08X %04X\n",a,a&0x7080);
                fputs(s,slogfile);
        }*/
        switch ((a>>17)&7)
        {
                case 0: /*printf("MEMC write %08X - VINIT  = %05X\n",a,getdmaaddr(a));*/ vinit=getdmaaddr(a); /*rpclog("Vinit write %08X %07X\n",vinit,PC);*/ return;
                case 1: /*printf("MEMC write %08X - VSTART = %05X\n",a,getdmaaddr(a));*/ vstart=getdmaaddr(a); /*rpclog("Vstart write %08X %07X\n",vstart,PC);*/return;
                case 2: /*printf("MEMC write %08X - VEND   = %05X\n",a,getdmaaddr(a));*/ vend=getdmaaddr(a); /*rpclog("Vend write %08X %07X\n",vend,PC);*/return;
                case 3: /*printf("MEMC write %08X - CINIT  = %05X\n",a,getdmaaddr(a));*/ cinit=getdmaaddr(a); /*printf("CINIT=%05X\n",cinit<<2);*/ return;
                case 4:
//                rpclog("%08i MEMC write %08X - SSTART = %05X %05X\n",bigcyc,a,getdmaaddr(a),spos);
//                if (!logsound) return;
                sstart=getdmaaddr(a); /*printf("SSTART=%05X\n",sstart<<2);*/
                if (!nextvalid) nextvalid=1;
                if (nextvalid==2) nextvalid=0;
//                if (nextvalid==1)
//                {
//                soundtime=soundper*(ssend-sstart);
                        ioc.irqb&=~2;
                        updateirqs();
                        nextvalid=2;
//                }
//                spos=sstart;
//                sinprog=1;
//                for (c=sstart;c<ssend;c++) mixsamp(ram[c]);
                return;
                case 5:
//                rpclog("%08i MEMC write %08X - SEND   = %05X %05X\n",bigcyc,a,getdmaaddr(a),spos);
                sendN=getdmaaddr(a);
                if (nextvalid==1) nextvalid=2;
                if (nextvalid!=2) nextvalid=1;
//                fputs(s,slogfile);
//                soend=ssend;
//                ioc.irqb&=~2;
//                updateirqs();
                return;
                case 6:
//                rpclog("%08i MEMC write %08X - SPTR   = %05X %05X\n",bigcyc,a,getdmaaddr(a),spos);
                sptr=getdmaaddr(a); /*printf("SPTR=%05X\n",sptr); */
//                fputs(s,slogfile);
//                if (!logsound) return;
//                soundtime=27500;
                spos=sstart2=sstart<<2;
                ssend=sendN<<2;
                ioc.irqb|=2;
                updateirqs();
                nextvalid=0;
//                sinprog=1;
                return;
                case 7: osmode=(a&0x1000)?1:0; /*MEMC ctrl*/
                sdmaena=(a&0x800)?1:0;
                pagesize=(a&0xC)>>2;
                resetpagesize(pagesize);
//                rpclog("CTRL write pagesize %i %i\n",pagesize,ins);
/*                if (!olog) olog=fopen("olog.txt","wt");
                sprintf(s,"MEMC ctrl write %08X %i\n",a,sdmaena);
                fputs(s,olog);*/
                memctrl=a;
                return;
                
                default:
                sprintf(err2,"Bad MEMC adr %i %08X\n",(a>>17)&7,a);
                MessageBox(NULL,err2,"Arc",MB_OK);
                dumpregs();
                exit(-1);
        }
}

int vollevels[2][2][8]=
{
        {
                {0,4,4,4,4,4,4,4},
                {0,4,4,4,4,4,4,4}
        },
        {
                {0,6,5,4,3,2,1,0},
                {0,0,1,2,3,4,5,6}
        }
};

void pollsound()
{
        mixsample();
        if (!sdmaena) return;
        sampledelay+=4;
        if (sampledelay>=soundper)
        {
                sampledelay-=soundper;
                samples[0/*samplecount*/]=(ram[(spos>>2)&0x1FFFF]>>((spos&3)<<3))&0xFF;
                samples[0]=convbyte(samples[0])*2;
                samples[2]=(signed short)(((int)samples[0]*vollevels[stereo][0][stereoimages[spos&7]])/6);
                samples[3]=(signed short)(((int)samples[0]*vollevels[stereo][1][stereoimages[spos&7]])/6);
//                tempf=(float)lastsamp*((float)13/(float)16);
//                samples[0]+=tempf;
//                lastsamp=samples[0];
                spos++;
                if (spos==(ssend+16))
                {
                        if (nextvalid==2)
                        {
                                spos=sstart2=sstart<<2;
                                ssend=sendN<<2;
                                nextvalid=0;
                        }
                        else
                           spos=sstart2;
                        ioc.irqb|=2;
                        updateirqs();
                        sinprog=0;
                }
        }
}

int output;

void writecam(unsigned long a)
{
        int page,access,logical,c;
//        rpclog("Write CAM %08X pagesize %i %i\n",a,pagesize,ins);
        switch (pagesize)
        {
//                #if 0
                case 1: /*8k*/
                page=((a>>1)&0x3f) | ((a&1)<<6);
                access=(a>>8)&3;
                logical=(a>>13)&0x3FF;
                logical|=(a&0xC00);
//                rpclog("Map page %02X to %03X\n",page,logical);
                for (c=0;c<0x2000;c++)
                {
                        if ((memcpages[c]&~0x1FFF)==(page<<13))
                        {
                                memcpages[c]=~0;
                                memstat[c]=0;
                        }
                }
                logical<<=1;
                for (c=0;c<2;c++)
                {
                        memcpages[logical+c]=page<<13;
                        memstat[logical+c]=access+1;
                        mempoint[logical+c]=&ram[(page<<11)+(c<<10)];
                        mempointb[logical+c]=(unsigned char *)&ram[(page<<11)+(c<<10)];
                }
                break;
//                #endif
                case 2: /*16k*/
                page=((a>>2)&0x1f) | ((a&3)<<5);
                access=(a>>8)&3;
                logical=(a>>14)&0x1FF;
                logical|=(a>>1)&0x600;
                for (c=0;c<0x2000;c++)
                {
                        if ((memcpages[c]&~0x3FFF)==(page<<14))
                        {
                                memcpages[c]=~0;
                                memstat[c]=0;
                        }
                }
                logical<<=2;
                for (c=0;c<4;c++)
                {
                        memcpages[logical+c]=page<<14;
                        memstat[logical+c]=access+1;
                        mempoint[logical+c]=&ram[(page<<12)+(c<<10)];
                        mempointb[logical+c]=(unsigned char *)&ram[(page<<12)+(c<<10)];
                }
                break;
                case 3: /*32k*/
                page=((a>>3)&0xf) | ((a&1)<<4) | ((a&2)<<5) | ((a&4)<<3);
                if (a&0x80) page|=0x80;
                if (a&0x1000) page|=0x100;
                access=(a>>8)&3;
                logical=(a>>15)&0xFF;
                logical|=(a>>2)&0x300;
                for (c=0;c<0x2000;c++)
                {
                        if ((memcpages[c]&~0x7FFF)==(page<<15))
                        {
                                memcpages[c]=~0;
                                memstat[c]=0;
                        }
                }
                logical<<=3;
                for (c=0;c<8;c++)
                {
                        memcpages[logical+c]=page<<15;
                        memstat[logical+c]=access+1;
                        mempoint[logical+c]=&ram[(page<<13)+(c<<10)];
                        mempointb[logical+c]=(unsigned char *)&ram[(page<<13)+(c<<10)];
                }
                break;
                default:
                rpclog("Bad pagesize %i\n",pagesize);
                exit(-1);
        }
//        memcpermissions[logical]=access;
}
