/*Arculator 0.8 by Tom Walker
  Memory read/write functions*/
#include "arc.h"
#include <allegro.h>
#include <winalleg.h>
#include <stdio.h>

int ddensity;
int prefabort;
int timetolive;
char err2[256];
FILE *olog;
int fdcside;
int realmemsize;
void initmem(int memsize)
{
        int c,d=(memsize>>2)-1;
        realmemsize=memsize;
        ram=(unsigned long *)malloc(memsize*1024);
        rom=(unsigned long *)malloc(0x200000);
        for (c=0;c<0x4000;c++) memstat[c]=0;
        for (c=0x2000;c<0x3000;c++) memstat[c]=3;
        for (c=0x2000;c<0x3000;c++) mempoint[c]=&ram[(c&d)<<10];
        for (c=0x3800;c<0x4000;c++) memstat[c]=5;
        for (c=0x3800;c<0x4000;c++) mempoint[c]=&rom[(c&0x1FF)<<10];
        memset(ram,0,memsize*1024);
        memstat[0]=1;
        mempoint[0]=rom;
        for (c=0;c<0x4000;c++) mempointb[c]=(unsigned char *)mempoint[c];
        realmemsize=memsize;
}

void resizemem(int memsize) /*memsize is 4096,8192,16384*/
{
        int c,d=(memsize>>2)-1;
        free(ram);
        ram=(unsigned long *)malloc(memsize*1024);
        for (c=0x2000;c<0x3000;c++) mempoint[c]=&ram[(c&d)<<10];
        for (c=0x2000;c<0x3000;c++) mempointb[c]=(unsigned char *)mempoint[c];
        memset(ram,0,memsize*1024);
        realmemsize=memsize;
}

void resetpagesize(int pagesize)
{
        int c,d=(realmemsize>>2)-1,e;
//        rpclog("Resetpagesize %i %i %i %04X\n",pagesize,realmemsize,ins,d);
        if (pagesize==3 && realmemsize==2048)
        {
                for (c=0x2000;c<0x3000;c++)
                {
                        e=c&1023;
                        e=(e&1)|((e&~3)<<1);
                        mempoint[c]=&ram[((e&0x3FF)<<10)];
                }
                for (c=0x2000;c<0x3000;c++) mempointb[c]=(unsigned char *)mempoint[c];
        }
        else if (pagesize==3 && realmemsize==1024)
        {
                for (c=0x2000;c<0x3000;c++)
                {
                        e=c&511;
                        e=(e&1)|((e&~3)<<1);
                        mempoint[c]=&ram[((e&0x1FF)<<10)];
                }
                for (c=0x2000;c<0x3000;c++) mempointb[c]=(unsigned char *)mempoint[c];
        }
        else if (pagesize==3 && realmemsize==512)
        {
                for (c=0x2000;c<0x3000;c++)
                {
                        e=c&255;
                        e=(e&1)|((e&~3)<<1);
                        mempoint[c]=&ram[((e&0xFF)<<10)];
                }
                for (c=0x2000;c<0x3000;c++) mempointb[c]=(unsigned char *)mempoint[c];
        }
        else
        {
                for (c=0x2000;c<0x3000;c++) mempoint[c]=&ram[(c&d)<<10];
                for (c=0x2000;c<0x3000;c++) mempointb[c]=(unsigned char *)mempoint[c];
        }
}

unsigned long readmemf(unsigned long a)
{
        a&=0x3FFFFFC;
//        if (a&0xFC000000) { rpclog("Databort readmemf %08X\n",a); databort=2; return 0xdeadbeef; }
        switch (a>>20)
        {
//#if 0
                case 0x00: case 0x01: case 0x02: case 0x03: /*RAM*/
                case 0x04: case 0x05: case 0x06: case 0x07:
                case 0x08: case 0x09: case 0x0A: case 0x0B:
                case 0x0C: case 0x0D: case 0x0E: case 0x0F:
                case 0x10: case 0x11: case 0x12: case 0x13:
                case 0x14: case 0x15: case 0x16: case 0x17:
                case 0x18: case 0x19: case 0x1A: case 0x1B:
                case 0x1C: case 0x1D: case 0x1E: case 0x1F:
                prefabort=1;
                return 0;
                case 0x3F:
                        return 0xFFFFFFFF;
//#endif
        }
        prefabort=1;
        return 0xdeadbeef;
/*        sprintf(err2,"Bad fetch %06X %03X %04X\n",a,a>>15,a&0x7FFF);
        MessageBox(NULL,err2,"Arc",MB_OK);
        dumpregs();
        exit(-1);*/
}

unsigned char readmemfb(unsigned long a)
{
//        if (a==0x1800F42)
/*        if (a==(0x1801010))
        {
                rpclog("Read byte %08X %07X\n",a,PC);
                return mempointb[((a)>>15)&0x7FF][((a)&0x7FFF)];
        }*/
//        if (((a)&~3)==0x2D8D0)
/*        if (a==0x7DC)
        {
                if (!olog) olog=fopen("olog.txt","wt");
                sprintf(err2,"Read byte %08X %07X\n",a,PC);
                fputs(err2,olog);
                return mempointb[((a)>>15)&0x7FF][((a)&0x7FFF)];
        }*/
/*        if (((a)&~0x7FFF)==0x8000)
        {
                rpclog("Read byte %08X %07X %02X  R2=%08X R4=%08X R5=%08X\n",a,PC,mempointb[((a)>>15)&0x7FF][((a)&0x7FFF)],armregs[2],armregs[4],armregs[5]);
                return mempointb[((a)>>15)&0x7FF][((a)&0x7FFF)];
        }*/
        if (a&0xFC000000) { /*rpclog("Databort readmemfb %08X\n",a);*/ databort=2; return 0xef; }
/*        if ((a&~0xFFF)==0x8000)
        {
                printf("Read %04X %08X %02X\n",a,PC,mempointb[((a)>>15)&0x7FF][(a)&0x7FFF]);
                return mempointb[((a)>>15)&0x7FF][(a)&0x7FFF];
        }*/
        switch (a>>20)
        {
                case 0x30: /*82c711*/
//                rpclog("Readb %08X %07X\n",a,PC);
                if (a>=0x3012000 && a<=0x302A000)
                   return readfdcdma(a);
                return read82c711(a);
                case 0x32: /*IOC*/
                if ((a&0xF0000)==0xD0000) return readst506(a);
                return readioc(a);
                case 0x33:
                if (romset>3)
                {
//                        rpclog("Read IO b %08X %07X\n",a,PC);
                        if ((a&~0x1F)==0x33c0004) return readeterna(a);
                        if ((a&~0x1F)==0x3340000) return readeterna(a);
                        if ((a&~0x1F)==0x33C0000) return readeterna(a);
                }
                switch (a)
                {
                        case 0x3310000: case 0x3310004: case 0x3310008: case 0x331000C: return read1772(a); /*1772*/
                        case 0x3350050: return (fdctype)?5:0; /*82c711 ID*/
                        case 0x3350558: return 0; /*???*/
                        case 0x3350070: return 0xF; /*Monitor ID*/
                        case 0x3350078: return 0xFF; /*????*/
                        case 0x33A0000: case 0x33A0004: case 0x33A0008: case 0x33A000C: return 0xFF; /*Econet*/
                        case 0x33B0000: case 0x33B0004: case 0x33B0008: case 0x33B000C: return 0xFF; /*Serial*/
//                        case 0x33C0000: return 0;
                        case 0x33C0000: case 0x33C4000: case 0x33C8000: case 0x33CC000: /*rpclog("Readb expansion %07X %07X\n",a,PC); */return 0xFF; /*Expansion*/
                }
                if (((a>>16)&7)==5) return readst506(a);
                return 0xFF;
//                error("Read bad address %07X\n",a);
//                exit(-1);
        }
//        rpclog("Data abort b %07X\n",a);
        databort=1;
//        rpclog("Dat abort readb %07X %07X\n",a,PC);
        return 0xef;
/*        sprintf(err2,"Bad read byte %06X %03X %04X\n",a,a>>15,a&0x7FFF);
        MessageBox(NULL,err2,"Arc",MB_OK);
        dumpregs();
        exit(-1);*/
}

unsigned long readmemfl(unsigned long a)
{
/*        if (a==0x7DC)
        {
                if (!olog) olog=fopen("olog.txt","wt");
                sprintf(err2,"Read word %08X %07X\n",a,PC);
                fputs(err2,olog);
                return mempointb[((a)>>15)&0x7FF][((a)&0x7FFF)];
        }*/
/*        if (((a)&~0x7FFF)==0x8000)
        {
                rpclog("Read long %08X %07X %08X R2=%08X R4=%08X R5=%08X\n",a,PC,mempoint[((a)>>15)&0x7FF][((a)&0x7FFF)>>2],armregs[2],armregs[4],armregs[5]);
                return mempoint[((a)>>15)&0x7FF][((a)&0x7FFF)>>2];
        }*/
        if (a&0xFC000000) { /*rpclog("Databort readmemfl %08X\n",a);*/ databort=2; return 0xdeadbeef; }
        switch (a>>20)
        {
//#if 0
                case 0x00: case 0x01: case 0x02: case 0x03: /*RAM*/
                case 0x04: case 0x05: case 0x06: case 0x07:
                case 0x08: case 0x09: case 0x0A: case 0x0B:
                case 0x0C: case 0x0D: case 0x0E: case 0x0F:
                case 0x10: case 0x11: case 0x12: case 0x13:
                case 0x14: case 0x15: case 0x16: case 0x17:
                case 0x18: case 0x19: case 0x1A: case 0x1B:
                case 0x1C: case 0x1D: case 0x1E: case 0x1F:
                databort=1;
                return 0xdeadbeef;
//#endif
                case 0x30: /*82c711*/
//                rpclog("Read %08X %07X\n",a,PC);
                if (a>=0x3012000 && a<=0x302A000)
                   return readfdcdma(a);
                if ((a&0xFFF)==0x7C0) return readidew();
                return read82c711(a);
                case 0x32: /*IOC*/
                if ((a&0xF0000)==0xD0000) return readst506l(a);
                return readioc(a);
                case 0x34: case 0x35: case 0x36: case 0x37: /*Expansion ROMs*/
                return 0xFFFFFFFF;
                case 0x33:
                if (romset>3)
                {
//                        rpclog("Read IO l %08X\n",a);
                        if ((a&~0x1F)==0x33c0004) return readeterna(a);
                        if ((a&~0x1F)==0x3340000) return readeterna(a);
                        if ((a&~0x1F)==0x33C0000) return readeterna(a);
                }
                switch (a)
                {
                        case 0x3310000: case 0x3310004: case 0x3310008: case 0x331000C: return read1772(a); /*1772*/
//                        case 0x3350050: return 0xFFFFFFFF;
//                        case 0x3350078: return 0xFFFFFFFF; /*????*/
                        case 0x33A0000: case 0x33A0004: case 0x33A0008: case 0x33A000C: return 0xFFFFFFFF; /*Econet*/
                        case 0x33B0000: case 0x33B0004: case 0x33B0008: case 0x33B000C: return 0xFFFFFFFF; /*Serial*/
                        case 0x33C0000: case 0x33C4000: case 0x33C8000: case 0x33CC000: /*rpclog("Read expansion %07X %07X\n",a,PC);*/ return 0xFFFFFFFF; /*Expansion*/
                }
                if (((a>>16)&7)==5) return readst506l(a);
                return 0xFF;
        }
//        rpclog("Data abort l %07X\n",a);
        databort=1;
//        rpclog("Dat abort readl %07X %07X\n",a,PC);
        return 0xdeadbeef;
/*        sprintf(err2,"Bad read long %06X %03X %04X\n",a,a>>15,a&0x7FFF);
        MessageBox(NULL,err2,"Arc",MB_OK);
        dumpregs();
        exit(-1);*/
}

int f42count=0;
FILE *slogfile;
void writememfb(unsigned long a,unsigned char v)
{
        if (a&0xFC000000) { /*rpclog("Databort writememfb %08X\n",a);*/ databort=2; return; }
/*        if (a==0x1800F42)
        {
                rpclog("Write 1800F42 %02X %07X %i %08X %i\n",v,PC,ins,armregs[5],f42count);
                mempointb[((a)>>15)&0x7FF][(a)&0x7FFF]=v;
                output=0;
                if (f42count==7) output=1;
                f42count++;
                ins=0;
                return;
        }*/
/*        if ((a&~3)==0x1803BEC)
        {
                rpclog("Write %08X %07X %02X %08X\n",a,PC,v,a);
                mempointb[((a)>>15)&0x7FF][(a)&0x7FFF]=v;
                return;
        }*/
/*        if ((a<0x2000000) && modepritablew[memmode][memstat[((a)>>15)&0x7FF]])
        {
                if (!olog) olog=fopen("olog.txt","wt");
                sprintf(s,"Write %04X %02X %08X\n",a,v,PC);
                fputs(s,olog);
                mempointb[((a)>>15)&0x7FF][(a)&0x7FFF]=v;
//                output=1; timetolive=2500;
                return;
        }*/
        switch (a>>20)
        {
                case 0x00: case 0x01: case 0x02: case 0x03: /*RAM*/
                case 0x04: case 0x05: case 0x06: case 0x07:
                case 0x08: case 0x09: case 0x0A: case 0x0B:
                case 0x0C: case 0x0D: case 0x0E: case 0x0F:
                case 0x10: case 0x11: case 0x12: case 0x13:
                case 0x14: case 0x15: case 0x16: case 0x17:
                case 0x18: case 0x19: case 0x1A: case 0x1B:
                case 0x1C: case 0x1D: case 0x1E: case 0x1F:
                databort=1;
                return;
//                case 0x1F: return; if (a>=0x1f08000 && a<=0x1f0ffff) return; break;
                case 0x30: /*82c711*/
//                rpclog("Write %08X %02X %07X\n",a,v,PC);
                if (a>=0x3012000 && a<=0x302A000)
                {
                        writefdcdma(a,v);
                        return;
                }
                write82c711(a,v);
                return;
                case 0x32: /*IOC*/
                if ((a&0xF0000)==0xD0000) { writest506(a,v); return; }
                writeioc(a,v);
                return;
                case 0x33:
                if (romset>3)
                {
                        if ((a&~0x1F)==0x33c0004) { writeeterna(a,v); return; }
                        if ((a&~0x1F)==0x3340000) { writeeterna(a,v); return; }
                        if ((a&~0x1F)==0x33C0000) { writeeterna(a,v); return; }
                }
                switch (a)
                {
                        case 0x3310000: case 0x3310004: case 0x3310008: case 0x331000C: write1772(a,v); return; /*1772*/
                        case 0x3350010: return; /*Printer*/
                        case 0x3350018:
                        ddensity=!(v&2);                                       
/*                        if (!olog) olog=fopen("fdc.txt","wt");
                        sprintf(err2,"FDC Latch B write %02X %i\n",v,curdrive);
                        fputs(err2,olog);*/
/*printf("FDC latch B %02X\n",v);*/ return; /*FDC Latch B*/
                        case 0x3350040: /*FDC Latch A*/
                        fdcside=(v&0x10)?0:1;
                        if (!(v&1)) curdrive=0;
                        if (!(v&2)) curdrive=1;
                        if (!(v&4)) curdrive=2;
                        if (!(v&8)) curdrive=3;
/*                        if (!olog) olog=fopen("fdc.txt","wt");
                        sprintf(err2,"FDC Latch A write %02X %i\n",v,curdrive);
                        fputs(err2,olog);*/
                        updateirqs();
                        return;
                        case 0x3350048: return; /*????*/
                        case 0x3350050: return; /*IOEB*/
                        case 0x3350074: return; /*????*/
                        case 0x3350078: return; /*????*/
                        case 0x33A0000: case 0x33A0004: case 0x33A0008: case 0x33A000C: return; /*Econet*/
                        case 0x33B0000: case 0x33B0004: case 0x33B0008: case 0x33B000C: return; /*Serial*/
                }
                if (((a>>16)&7)==5) { writest506(a,v); return; }
                return;
                break;
        }
        databort=1;
//        rpclog("Dat abort writeb %07X %07X\n",a,PC);
/*        sprintf(err2,"Bad write byte %06X %03X %04X %08X\n",a,a>>15,a&0x7FFF,v);
        MessageBox(NULL,err2,"Arc",MB_OK);
        dumpregs();
        exit(-1);*/
}

void writememfl(unsigned long a,unsigned long v)
{
        if (a&0xFC000000) { /*rpclog("Databort writememfl %08X %07X\n",a,PC); */databort=2; return; }
/*        if (a==(0x1801010))
        {
                rpclog("Writel R12+284 %07X %08X %08X\n",PC,v,a);
                mempoint[((a)>>15)&0x7FF][((a)&0x7FFF)>>2]=v;
                return;
        }*/
/*        if (a==0x1803BEC)
        {
                rpclog("Write 1803BEC %02X %07X %i\n",v,PC,ins);
                mempoint[((a)>>15)&0x7FF][((a)&0x7FFF)>>2]=v;
                return;
        }*/
/*        if ((a<0x2000000) && modepritablew[memmode][memstat[((a)>>15)&0x7FF]])
        {
                sprintf(s,"Write %04X %08X %08X\n",a,v,PC);
                fputs(s,olog);
                mempoint[((a)>>15)&0x7FF][((a)&0x7FFF)>>2]=v;
//                output=1; timetolive=50;
                return;
        }*/
        switch (a>>20)
        {
                case 0x00: case 0x01: case 0x02: case 0x03: /*RAM*/
                case 0x04: case 0x05: case 0x06: case 0x07:
                case 0x08: case 0x09: case 0x0A: case 0x0B:
                case 0x0C: case 0x0D: case 0x0E: case 0x0F:
                case 0x10: case 0x11: case 0x12: case 0x13:
                case 0x14: case 0x15: case 0x16: case 0x17:
                case 0x18: case 0x19: case 0x1A: case 0x1B:
                case 0x1C: case 0x1D: case 0x1E: case 0x1F:
                databort=1;
                return;
                case 0x30: /*82c711*/
//                rpclog("Write %08X %08X %07X\n",a,v,PC);
                if (a>=0x3012000 && a<=0x302A000)
                {
                        writefdcdma(a,v);
                        return;
                }
                if ((a&0xFFF)==0x7C0)
                {
                        writeidew(v>>16);
                        return;
                }
                write82c711(a,v);
                return;
                case 0x32: /*IOC*/
                if ((a&0xF0000)==0xD0000) { writest506l(a,v); return; }
                writeioc(a,v>>16);
                return;
                case 0x33:
                if (romset>3)
                {
                        if ((a&~0x1F)==0x33c0004) { writeeterna(a,v); return; }
                        if ((a&~0x1F)==0x3340000) { writeeterna(a,v); return; }
                        if ((a&~0x1F)==0x33C0000) { writeeterna(a,v); return; }
                }
                switch (a)
                {
                        case 0x3350010: return; /*Printer*/
                        case 0x3350018: return; /*FDC latch B*/
                        case 0x3350040: return; /*FDC latch A*/
                        case 0x3350048: return; /*Video clock latch*/
                }
                if (((a>>16)&7)==5) { writest506l(a,v); return; }
                return;
                break;
                case 0x34: /*VIDC*/
                writevidc(v);
                return;
                case 0x36: /*MEMC*/
                writememc(a);
                return;
                case 0x38: case 0x39: case 0x3A: case 0x3B: /*CAM*/
                case 0x3C: case 0x3D: case 0x3E: case 0x3F:
                writecam(a);
                return;
        }
        databort=1;
//        rpclog("Dat abort writel %07X %07X\n",a,PC);
/*        sprintf(err2,"Bad write long %06X %03X %04X %08X\n",a,a>>15,a&0x7FFF,v);*/
}
       
