#include "PSXProcessorDebugger.hpp"

namespace NeoPSX
{
	PSXProcessorDebugger::PSXProcessorDebugger(TR3000Context* context)
	{
		m_psh.dwFlags |= PSH_NOAPPLYNOW;
		mPage1.reset( new PSXR3000Debugger( context ) );
		mPage2.reset( new PSXCOP0Debugger ( context ) );
		AddPage(*mPage1.get());
		AddPage(*mPage2.get());
		SetActivePage(0);
		SetTitle(_T("NeoPSX - Processor Debugger"));
	}

	////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

	void PSXProcessorDebugger::Update() const
	{
		if(::IsWindowVisible(mPage1->m_hWnd))
			mPage1->Update();
		else
			mPage2->Update();
	}
} // Namespace NeoPSX