#include "PSXPluginDialog.hpp"

namespace NeoPSX
{
	struct { LPCTSTR ItemName; DWORD ItemData; UINT LeafGraphic; } PluginTreeItems[6] =
	{
		{ "Plugins", 18, 1 },
		{ "Video"  , PSE_LT_GPU, 3 },
		{ "Sound"  , PSE_LT_SPU, 4 },
		{ "CDROM"  , PSE_LT_CDR, 5 },
		{ "PAD 1"  , PSE_LT_PAD, 6 },
		{ "PAD 2"  , PSE_LT_PAD, 6 }
	};

	struct { LPCTSTR ItemName; DWORD ItemData; } EmulationTreeItems[3] =
	{
		{ "Emulation", 19 },
		{ "Options"  , 20 },
		{ "Logging"  , 21 }
	};

	////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

	PSXPluginDialog::PSXPluginDialog(UINT SelectedLeaf)
	: mSelectedLeaf(SelectedLeaf)
	{
	}

	////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

	LRESULT PSXPluginDialog::OnInitDialog(HWND, LPARAM)
	{
		//===============================================================
		// Set the window display settings.
		//===============================================================
		ShowWindow(SW_SHOW);
		CenterWindow();
		TTSize(400);

		//===============================================================
		// Initialize progress bar control.
		//===============================================================
		mProgress = GetDlgItem(IDC_INIT_PROGRESS);
		mProgress.SetRange(0, 40);
		mConfigureTree.SetProgressControl(mProgress);
		UpdateWindow();

		//===============================================================
		// Set data exchange mode.
		//===============================================================
		DoDataExchange(FALSE);

		mConfigureTree.ModifyStyle(0, TVS_HASLINES | TVS_LINESATROOT | TVS_HASBUTTONS | TVS_INFOTIP);

		//===============================================================
		// Create the tree root and branches.
		//===============================================================
		CTreeItem Root, CurrentItem, Plugins, Emulation;
		Root      = mConfigureTree.InsertItem(_T("Configure"), TVI_ROOT, TVI_LAST);
		Root.SetImage(0, 0);

		Plugins   = Root.AddTail(_T(PluginTreeItems   [0].ItemName), PluginTreeItems[0].LeafGraphic);
		Emulation = Root.AddTail(_T(EmulationTreeItems[0].ItemName), 1);

		mProgress.StepIt();

		//===============================================================
		// Set plugin and emulation branch data.
		//===============================================================
		Root.Expand();
		mConfigureTree.SetItemData(Plugins  , (DWORD_PTR)PluginTreeItems   [0].ItemData);
		mConfigureTree.SetItemData(Emulation, (DWORD_PTR)EmulationTreeItems[0].ItemData);

		//===============================================================
		// Create our image list and set it for list view and tree view
		//===============================================================
		if(!mImageList.Create(MAKEINTRESOURCE(IDB_PLUGIN_IMAGES), 16, 16, RGB(0, 128, 128)))
			AtlMessageBox(NULL, "Could not create image list.");

		mConfigureTree.SetImageList(mImageList.m_hImageList, LVSIL_NORMAL);
		mListView.SetImageList(mImageList.m_hImageList, LVSIL_SMALL);

		mProgress.StepIt();

		//===============================================================
		// Set plugin leafs and their internal data.
		//===============================================================
		for(int i = 1; i < 6; i++)
		{
			// Set plugin branch name.
			CurrentItem = Plugins.AddTail(_T(PluginTreeItems[i].ItemName), PluginTreeItems[i].LeafGraphic);

			// Set plugin branch data.
			mConfigureTree.SetItemData(CurrentItem, (DWORD_PTR)PluginTreeItems[i].ItemData);
		}

		//===============================================================
		// Set emulations leafs and their internal data.
		//===============================================================
		for(int i = 1; i < 3; i++)
		{
			// Set the emulation branch name.
			CurrentItem = Emulation.AddTail(_T(EmulationTreeItems[i].ItemName), 2);

			// Set the emulation branch data.
			mConfigureTree.SetItemData(CurrentItem, (DWORD_PTR)EmulationTreeItems[i].ItemData);
		}
		mProgress.StepIt();
		UpdateWindow();

		//===============================================================
		// Create list view columns.
		//===============================================================
		mListView.InsertColumn(0, _T("Plugin Name")   , LVCFMT_LEFT, 195, 0);
		mListView.InsertColumn(1, _T("Plugin Version"), LVCFMT_LEFT, 119, 0);

		//===============================================================
		// Load all plugins in the plugins directory and list.
		//===============================================================
		try
		{
			EFRegistryKey RegKey("NeoPSX");
			EFString PluginDirectory = RegKey.ReadString("PluginDirectory", "Plugins", 260);

			EFPluginManager::GetSingleton().LoadPlugins(PluginDirectory);
		} catch(EFException& error) {
			AtlMessageBox(NULL, error.GetDetailedInformation().c_str());
		}

		mProgress.StepIt();

		//===============================================================
		// Select the appropriate plugin item based on input.
		//===============================================================
		Plugins.Expand();
		CTreeItem SelectedItem = Plugins.GetChild();

		for(UINT i = 1; i < mSelectedLeaf; i++)
		{
			SelectedItem = SelectedItem.GetNextSibling();
		}

		mConfigureTree.SelectItem(SelectedItem);

		//===============================================================
		// Make list view header flat styled.
		//===============================================================
		CHeaderCtrl Header = mListView.GetHeader();
		Header.ModifyStyle(HDS_BUTTONS, 0);

		mProgress.StepIt();
		mProgress.SetPos(0);

		return TRUE;
	}

	////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

	LRESULT PSXPluginDialog::OnOK(UINT, INT, HWND)
	{
		//===============================================================
		// Exchange data between window and variables.
		//===============================================================
		if(!DoDataExchange(TRUE))
			return 1;

		//===============================================================
		// Unload all of the loaded plugins.
		//===============================================================
		EFPluginManager::GetSingleton().UnloadPlugins();

		//===============================================================
		// Close the window.
		//===============================================================
		DestroyWindow();
		return 0;
	}

	////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

	LRESULT PSXPluginDialog::OnCancel(UINT, INT, HWND)
	{
		//===============================================================
		// Unload all of the loaded plugins.
		//===============================================================
		EFPluginManager::GetSingleton().UnloadPlugins();

		//===============================================================
		// Close the window.
		//===============================================================
		DestroyWindow();
		return 0;
	}
} // Namespace NeoPSX