#ifndef PSX_PLUGIN_TYPES_HPP
#define PSX_PLUGIN_TYPES_HPP

#include "EFramework.hpp"

namespace NeoPSX
{
	//////////////////////////////////////////////////////////////////////////////////////
	// PSEmuPro basic plugin function callbacks.
	//////////////////////////////////////////////////////////////////////////////////////
	typedef char* (CALLBACK* PSEgetLibName)();
	typedef ulong (CALLBACK* PSEgetLibType)();
	typedef ulong (CALLBACK* PSEgetLibVersion)();

	typedef long (CALLBACK* PSEinit)();
	typedef long (CALLBACK* PSEopen)();

	typedef long (CALLBACK* PSEconfigure)();
	typedef void (CALLBACK* PSEabout)();
	typedef long (CALLBACK* PSEtest)();

	//////////////////////////////////////////////////////////////////////////////////////
	// Plugin Type Enumerations
	//////////////////////////////////////////////////////////////////////////////////////
	enum TPluginTypes
	{
		PSE_LT_CDR = 1,
		PSE_LT_GPU = 2,
		PSE_LT_SPU = 4,
		PSE_LT_PAD = 8,
		PSE_LT_NET = 16
	};

	enum TPluginReturnValue
	{
		PSE_ERR_FAILURE = -1,
		PSE_ERR_SUCCESS =  0,
		PSE_LIB_VERSION =  1
	};

	enum TPluginInitializationReturn
	{
		PSE_INIT_ERR_SUCCESS       =  0,
		PSE_INIT_ERR_NOTCONFIGURED = -2,
		PSE_INIT_ERR_NOHARDWARE    = -3
	};

	//////////////////////////////////////////////////////////////////////////////////////
	// Basic plugin interface function pointer definitions.
	//////////////////////////////////////////////////////////////////////////////////////
	static PSEgetLibName    PSXLibraryName;
	static PSEgetLibType    PSXLibraryType;
	static PSEgetLibVersion PSXLibraryVersion;

	static PSEinit          PSXInit;
	static PSEopen          PSXOpen;

	static PSEconfigure     PSXConfigure;
	static PSEabout         PSXAbout;
	static PSEtest          PSXTest;
};

#endif // PSX_PLUGIN_TYPES_HPP