#ifndef PSX_EMULATION_DIALOG_HPP
#define PSX_EMULATION_DIALOG_HPP

#include <atlbase.h>
#include <atlwin.h>
#include <atlapp.h>
#include <atlctrls.h>
#include <atlctrlx.h>
#include <atlddx.h>
#include <atldlgs.h>
#include <atlcrack.h>
#include <atlmisc.h>
#include <ToolTipDialog.h>
#include "../resource.h"

namespace NeoPSX
{
	/// The emulation configuration dialog definition.
	class PSXEmulationDialog : public CDialogImpl< PSXEmulationDialog >, public CToolTipDialog< PSXEmulationDialog >
	{
	public:
		/////////////////////////////////////////////////////////////////////////////////////////////////
		// Message Maps

		BEGIN_MSG_MAP( PSXEmulationDialog )
			CHAIN_MSG_MAP( CToolTipDialog< PSXEmulationDialog > )
			MESSAGE_HANDLER(WM_INITDIALOG, OnInitDialog)
			COMMAND_ID_HANDLER(ID_EMULATION_OK, OnOK)
			COMMAND_ID_HANDLER(ID_EMULATION_CANCEL, OnCancel)
			COMMAND_RANGE_HANDLER(IDC_INTERPRET_RADIO, IDC_DYNAREC_RADIO, OnEmulationMethodChange)
		END_MSG_MAP()

		/////////////////////////////////////////////////////////////////////////////////////////////////
		// Enumerations

		enum { IDD = IDD_CONFIGURE_EMULATION };

		/////////////////////////////////////////////////////////////////////////////////////////////////
		// Message Handler Functions

		/** Handle the initialization of this dialog box.
		  */
		LRESULT OnInitDialog(UINT, WPARAM, LPARAM, BOOL);
		/** Closes and saves any changed dialog settings.
		  */
		LRESULT OnOK(WORD, WORD wID, HWND, BOOL);
		/** Closes without saving any changed dialog settings.
		  */
		LRESULT OnCancel(WORD, WORD wID, HWND, BOOL);
		/** Sets/clears radio buttons when one is selected.
		  */
		LRESULT OnEmulationMethodChange(WORD wNotifyCode, WORD, HWND, BOOL);
	private:
		/////////////////////////////////////////////////////////////////////////////////////////////////
		// Protected Variables

		UINT mInterpreterOff; ///< Value which indicates whether or not interpretation is off (1 = Dynarec 0 = Interpreter).
	};
} // Namespace NeoPSX

#endif // PSX_EMULATION_DIALOG_HPP