#include "EFZipOutputStream.hpp"
#include "EFException.hpp"

namespace EFramework
{
	EFZipOutputStream::EFZipOutputStream(const EFString& fileName)
	{
		//=====================================================
		// Attempt to open a GZIP compressed file for writing.
		//=====================================================
		mCompressedFile = gzopen(fileName.c_str(), "wb");

		//=====================================================
		// Check if the file was opened successfully.
		//=====================================================
		if(mCompressedFile == NULL)
		{
			EF_THROW(EFException::EC_STREAM_ERROR, "Could not open GZIP stream for writing.");
		}
	}

	/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

	void EFZipOutputStream::WriteChar(uchar& value)
	{
		gzwrite(mCompressedFile, &value, sizeof(uchar));
	}

	void EFZipOutputStream::WriteShort(ushort& value)
	{
		gzwrite(mCompressedFile, &value, sizeof(ushort));
	}

	void EFZipOutputStream::WriteInt(uint& value)
	{
		gzwrite(mCompressedFile, &value, sizeof(uint));
	}

	void EFZipOutputStream::WriteLong(ulong& value)
	{
		gzwrite(mCompressedFile, &value, sizeof(ulong));
	}

	void EFZipOutputStream::WriteBool(bool& value)
	{
		gzwrite(mCompressedFile, &value, sizeof(bool));
	}

	void EFZipOutputStream::WriteString(char* value, ulong size)
	{
		gzwrite(mCompressedFile, &value, size);
	}

	/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

	void EFZipOutputStream::CloseStream()
	{
		if(mCompressedFile)
		{
			gzflush(mCompressedFile, Z_FINISH);
			gzclose(mCompressedFile);
		}
		else
		{
			EF_THROW(EFException::EC_STREAM_ERROR, "Attempted to close a GZIP file without a valid handle.");
		}
	}
} // Namespace EFramework