#include "EFZipInputStream.hpp"

namespace EFramework
{
	EFZipInputStream::EFZipInputStream(const EFString& fileName)
	{
		//=====================================================
		// Attempt to open GZIP compressed file for reading.
		//=====================================================
		mCompressedFile = gzopen(fileName.c_str(), "rb");

		//=====================================================
		// Check if the file was opened successfully.
		//=====================================================
		if(mCompressedFile == NULL)
		{
			EF_THROW(EFException::EC_STREAM_ERROR, "Could not open GZIP stream for reading.");
		}
	}

	/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

	uchar EFZipInputStream::ReadChar()
	{
		uchar value;
		gzread(mCompressedFile, &value, sizeof(uchar));
		return value;
	}

	ushort EFZipInputStream::ReadShort()
	{
		ushort value;
		gzread(mCompressedFile, &value, sizeof(ushort));
		return value;
	}

	uint EFZipInputStream::ReadInt()
	{
		uint value;
		gzread(mCompressedFile, &value, sizeof(uint));
		return value;
	}

	ulong EFZipInputStream::ReadLong()
	{
		ulong value;
		gzread(mCompressedFile, &value, sizeof(ulong));
		return value;
	}

	bool EFZipInputStream::ReadBool()
	{
		bool value;
		gzread(mCompressedFile, &value, sizeof(bool));
		return value;
	}

	void EFZipInputStream::ReadString(char* variable, ulong size)
	{
		gzread(mCompressedFile, variable, size);
	}

	/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

	void EFZipInputStream::CloseStream()
	{
		if(mCompressedFile)
		{
			gzclose( mCompressedFile );
		}
		else
		{
			EF_THROW(EFException::EC_STREAM_ERROR, "Attempted to close a GZIP file without a valid handle.");
		}
	}
} // Namespace EFramework