#ifndef EF_SINGLETON_HPP
#define EF_SINGLETON_HPP

#include "EFPlatform.hpp"

#if defined(_DEBUG)
#include <windows.h>
#endif

namespace EFramework
{
	/// Class which creates and manages a single instance of an object.
	template<class TSingleton>
	class EFSingleton
	{
	public:
		///////////////////////////////////////////////////////////////////////////////////////////////////
		// Constructors

		/** The default constructor.
		  */
		EFSingleton()
		{ }

		///////////////////////////////////////////////////////////////////////////////////////////////////
		// Destructors

		/** The default destructor.
		  */
		~EFSingleton()
		{
			EF_UTIL_DELETE( mSingleton );
		}

		///////////////////////////////////////////////////////////////////////////////////////////////////
		// Singleton Functions

		/** Returns a reference to the singleton object.
		  */
		static TSingleton& GetSingleton() 
		{
			if(mSingleton == NULL)
			{
				mSingleton = new TSingleton();
			}

			assert(mSingleton != NULL && "The singleton pointer should never be NULL.");
			return *mSingleton;
		}

		/** Returns a pointer to the singleton object.
		  */
		static TSingleton* GetSingletonPtr()
		{
			if(mSingleton == NULL)
			{
				mSingleton = new TSingleton();
			}

			assert(mSingleton != NULL && "The singleton pointer should never be NULL.");
			return mSingleton;
		}
	private:
		///////////////////////////////////////////////////////////////////////////////////////////////////
		// Variables

		static TSingleton* mSingleton; ///< The managed singleton object.
	};

	////////////////////////////////////////////////////////////////////////////////////////////////////////////
	// Nullify our singleton
	////////////////////////////////////////////////////////////////////////////////////////////////////////////
	//template<class TSingleton> TSingleton* EFSingleton<TSingleton>::mSingleton = NULL;
} // Namespace EFramework

#endif // EF_SINGLETON_HPP