#include "PSXHardwareManager.hpp"

namespace NeoPSX
{
	PSXHardwareManager::PSXHardwareManager()
	{
		mRootCounters.Reset();
	}

	/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

	PSXHardwareManager::~PSXHardwareManager()
	{
	}

	/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

	void PSXHardwareManager::Reset()
	{
		mRootCounters.Reset();
	}

	/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

	void PSXHardwareManager::WriteByte(uint32_t address, uint8_t data)
	{
		if(mRootCounters.InRange(address))
			mRootCounters.WriteByte(address, data);
	}

	void PSXHardwareManager::WriteHword(uint32_t address, uint16_t data)
	{
		if(mRootCounters.InRange(address))
			mRootCounters.WriteHword(address, data);
	}

	void PSXHardwareManager::WriteWord(uint32_t address, uint32_t data)
	{
		if(mRootCounters.InRange(address))
			mRootCounters.WriteWord(address, data);
	}

	/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

	uint8_t PSXHardwareManager::ReadByte(uint32_t address)
	{
		if(mRootCounters.InRange(address))
			return mRootCounters.ReadByte(address);

		return NULL;
	}

	uint16_t PSXHardwareManager::ReadHword(uint32_t address)
	{
		if(mRootCounters.InRange(address))
			return mRootCounters.ReadHword(address);

		return NULL;
	}

	uint32_t PSXHardwareManager::ReadWord(uint32_t address)
	{
		if(mRootCounters.InRange(address))
			return mRootCounters.ReadWord(address);

		return NULL;
	}
} // Namespace NeoPSX