#include "PSXExecutableLoader.hpp"

namespace NeoPSX
{
	PSXExecutableLoader::PSXExecutableLoader()
	: mHeader( NULL )
	{
	}

	/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

	PSXExecutableLoader::~PSXExecutableLoader()
	{
		Close();
	}

	/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

	bool PSXExecutableLoader::Load(PSXMemory& memory, const EFString& file)
	{
		// Set up our static header data buffer.
		static char HeaderData[EFI_HEADER_SIZE];

		// Attempt to open the executable file.
		std::ifstream ExecutableFile(file.c_str(), std::ios::binary);

		if(!ExecutableFile.is_open())
		{
			return false;
		}

		// Load the executable file header.
		ExecutableFile.read((char*)&HeaderData, EFI_HEADER_SIZE);
		mHeader = (TPlaystationExecutableHeader*)&HeaderData;

		// Check for an invalid playstation executable.
		if(mHeader == NULL || memcmp(mHeader->Id, "PS-X EXE", 8) != 0)
		{
			return false;
		}

		// Load the rest of the file into memory.
		ExecutableFile.read((char*)memory.GetPointer(mHeader->TxPtr), mHeader->TxLen);
		return true;
	}

	void PSXExecutableLoader::Close()
	{
		mHeader = NULL;
	}

	/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

	uint32_t PSXExecutableLoader::GetPC() const
	{
		EF_ASSERT(mHeader != NULL);
		return mHeader->Pc;
	}

	uint32_t PSXExecutableLoader::GetSP() const
	{
		EF_ASSERT(mHeader != NULL);
		return mHeader->Sp;
	}

	uint32_t PSXExecutableLoader::GetFP() const
	{
		EF_ASSERT(mHeader != NULL);
		return mHeader->Fp;
	}

	uint32_t PSXExecutableLoader::GetGP() const
	{
		EF_ASSERT(mHeader != NULL);
		return mHeader->Gp;
	}

	uint32_t PSXExecutableLoader::GetGP0() const
	{
		EF_ASSERT(mHeader != NULL);
		return mHeader->Gp0;
	}

	uint32_t PSXExecutableLoader::GetRA() const
	{
		EF_ASSERT(mHeader != NULL);
		return mHeader->Ra;
	}

	uint32_t PSXExecutableLoader::GetK0() const
	{
		EF_ASSERT(mHeader != NULL);
		return mHeader->K0;
	}
} // Namespace NeoPSX