#ifndef EF_PLATFORM_MANAGER_HPP
#define EF_PLATFORM_MANAGER_HPP

#include "EFPlatform.hpp"
#include "EFException.hpp"
#include "EFVersionInfo.hpp"

namespace EFramework
{
	/// Indicates the current version of the error handling system.
	enum ErrorHandlingVersion
	{
		ERROR_MAJOR = 1,
		ERROR_MINOR = 1,
		ERROR_PATCH = 0
	};

	/// Indicates the current version of the user interface system.
	enum UserInterfaceVersion
	{
		USER_INTERFACE_MAJOR = 0,
		USER_INTERFACE_MINOR = 2,
		USER_INTERFACE_PATCH = 0
	};

	/// Indicates the current version of the emulation system.
	enum EmulationVersion
	{
		EMULATION_MAJOR = 0,
		EMULATION_MINOR = 6,
		EMULATION_PATCH = 0
	};

	////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

	/// Indicates the overall framework version.
	enum FrameworkVersion
	{
		FRAMEWORK_MAJOR = 0,
		FRAMEWORK_MINOR = 5,
		FRAMEWORK_PATCH = 0
	};

	////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

	/// Class which gives information about the current framework version.
	class EF_EXPORT EFPlatformManager
	{
	public:
		///////////////////////////////////////////////////////////////////////////////////////////////////
		// Constructors
		
		/** The default constructor.
		  */
		EFPlatformManager();

		///////////////////////////////////////////////////////////////////////////////////////////////////
		// Destructors
		
		/** The default destructor.
		  */
		~EFPlatformManager();

		///////////////////////////////////////////////////////////////////////////////////////////////////
		// System Version Information

		/** Returns the current version information of the framework.
		  */
		static EFVersionInfo GetFrameworkVersion();
		/** Returns the current version of the error-handling framework.
		  */
		static EFVersionInfo GetErrorVersion();
		/** Returns the current version of the emulation framework.
		  */
		static EFVersionInfo GetEmulationVersion();
		/** Returns the current version of the GUI framework.
		  */
		static EFVersionInfo GetUserInterfaceVersion();
	};

	////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

	/// A macro which will compare the header versions with the library versions.
	#define EF_COMPARE_LIBRARY_VERSIONS() { \
		EFVersionInfo framework(FRAMEWORK_MAJOR, FRAMEWORK_MINOR, FRAMEWORK_PATCH); \
		EFVersionInfo error(ERROR_MAJOR, ERROR_MINOR, ERROR_PATCH); \
		EFVersionInfo emulation(EMULATION_MAJOR, EMULATION_MINOR, EMULATION_PATCH); \
		EFVersionInfo gui(USER_INTERFACE_MAJOR, USER_INTERFACE_MINOR, USER_INTERFACE_PATCH); \
		if( \
		   (!(EFPlatformManager::GetFrameworkVersion() == framework)) || \
		   (!(EFPlatformManager::GetErrorVersion() == error))         || \
		   (!(EFPlatformManager::GetEmulationVersion() == emulation)) || \
		   (!(EFPlatformManager::GetUserInterfaceVersion() == gui))    ) \
		{ \
			EF_THROW(EFException::EC_FATAL_ERROR, "Your DLL version is not the same as your header version!"); \
		} \
	}
} // Namespace EFramework

#endif // EF_PLATFORM_MANAGER_HPP