#ifndef EF_INPUT_STREAM_HPP
#define EF_INPUT_STREAM_HPP

#include "EFException.hpp"

namespace EFramework
{
	/// Defines the base class for all input streams.
	class EF_EXPORT EFInputStream
	{
	public:
		///////////////////////////////////////////////////////////////////////////////////////////////////
		// Destructors

		/** The default destructor.
		  */
		virtual ~EFInputStream();

		///////////////////////////////////////////////////////////////////////////////////////////////////
		// Stream Writing Functions

		/** Reads a single character value from the specified stream.
		  */
		virtual uchar ReadChar() = 0;
		/** Reads a short integer value from the specified stream.
		  */
		virtual ushort ReadShort() = 0;
		/** Reads an integer value from the specified stream.
		  */
		virtual uint ReadInt() = 0;
		/** Reads a long integer value from the specified stream.
		  */
		virtual ulong ReadLong() = 0;
		/** Reads a boolean variable from the specified stream.
		  */
		virtual bool ReadBool() = 0;
		/** Reads a string from the specified stream.
		  */
		virtual void ReadString(char* variable, ulong size) = 0;

		///////////////////////////////////////////////////////////////////////////////////////////////////
		// Miscellaneous Functions

		/** Closes the current input stream.
		  */
		virtual void CloseStream();
	};
} // Namespace EFramework

#endif // EF_INPUT_STREAM_HPP