#ifndef EF_FILE_INPUT_STREAM
#define EF_FILE_INPUT_STREAM

#include "EFPlatform.hpp"
#include "EFInputStream.hpp"

namespace EFramework
{
	/// Defines an input stream from a file containing binary data.
	class EF_EXPORT EFFileInputStream : public EFInputStream
	{
	public:
		///////////////////////////////////////////////////////////////////////////////////////////////////
		// Constructors

		/** The default constructor.
		  */
		EFFileInputStream(const EFString& fileName);

		///////////////////////////////////////////////////////////////////////////////////////////////////
		// File Input Functions

		/** Reads a single character from the file stream.
		  */
		uchar ReadChar();
		/** Reads a short integer from the file stream.
		  */
		ushort ReadShort();
		/** Reads an integer from the file stream.
		  */
		uint ReadInt();
		/** Reads a long integer from the file stream.
		  */
		ulong ReadLong();
		/** Reads a boolean value from the file stream.
		  */
		bool ReadBool();
		/** Reads a group of characters from the file stream.
		  */
		void ReadString(char* variable, ulong size);

		///////////////////////////////////////////////////////////////////////////////////////////////////
		// Miscellaneous Functions

		/** Closes the current file input stream.
		  */
		void CloseStream();
	protected:
		///////////////////////////////////////////////////////////////////////////////////////////////////
		// Variables

		std::ifstream mInputFile; ///< The file from which all the data will be read.
	};
} // Namespace EFramework

#endif // EF_FILE_INPUT_STREAM