//
// NES emu  PSP̉˂(TEh)
//
#include "soundmanager.h"
#include "debug/debug.h"
#include "nes/apu/nes_apu_wrapper.h"
#include "main.h"


// TvO[g
int Snd_GetSampleRate(void)
{
	switch (setting.samplingrate) {
		case SAMPLINGRATE_11025:          return 11025;
		case SAMPLINGRATE_22050:          return 22050;
		case SAMPLINGRATE_44100: default: return 44100;
	}
}


// ʎqrbg
int Snd_GetSampleBits(void)
{
	DEBUG("Snd_GetSampleBits");
	return 16;
}

// ݍĐ̏ꏊ
int Snd_GetCurrentPlayingBank()
{
	DEBUG("Snd_GetCurrentPlayingBank");
	return g_BeforePlayBank;
}


// Lock buffers
boolean Snd_Lock(int which, void** buf, uint32* buf_len)
{
	static int g_SndRenderBank = 0;
	DEBUG("Snd_Lock");
	// RenderBankƍĐBankȂFALSE
	if (g_SndRenderBank == g_BeforePlayBank) return FALSE;
	if (g_SndRenderBank < g_BeforePlayBank) {
		*buf = &g_SoundBuf[PGA_SAMPLES * g_SndRenderBank];
		*buf_len = (g_BeforePlayBank - g_SndRenderBank) * PGA_SAMPLES * sizeof(short);
		g_SndRenderBank = g_BeforePlayBank;
	}
	else {
		*buf = &g_SoundBuf[PGA_SAMPLES * g_SndRenderBank];
		*buf_len = (SOUND_BANK_COUNT - g_SndRenderBank) * PGA_SAMPLES * sizeof(short);
		g_SndRenderBank = 0;
	}
	return TRUE;
}

// Unlock buffers
void Snd_UnLock(void)
{
 	DEBUG("Snd_UnLock");
   // Ȃ
}

// clear buffer
void Snd_ClearBuffer(void)
{
 	DEBUG("Snd_ClearBuffer");
    _memset(g_SoundBuf, 0x00, sizeof(g_SoundBuf));
}

