#if defined(GBA_COMPILE)
#include "ioreg.h"
#else
#include "dsioreg.h"
#endif
#include "int.h"
#include "timers.h"

#if defined(GBA_COMPILE)
#undef REG
#define REG(ignore, x) GBAio[REG_ ## x].data
#endif

TimerData timer_data[3][4] = {
	{ { 0, 0, 0, 0, 0, 0 }, { 0, 0, 0, 0, 0, 0 }, { 0, 0, 0, 0, 0, 0 }, { 0, 0, 0, 0, 0, 0 } },
	{ { 0, 0, 0, 0, 0, 0 }, { 0, 0, 0, 0, 0, 0 }, { 0, 0, 0, 0, 0, 0 }, { 0, 0, 0, 0, 0, 0 } },
	{ { 0, 0, 0, 0, 0, 0 }, { 0, 0, 0, 0, 0, 0 }, { 0, 0, 0, 0, 0, 0 }, { 0, 0, 0, 0, 0, 0 } }
};

void DoTimerReload(int cpu, int timer, u16 val)
{
	timer_data[cpu][timer].reload = val;	
}

void DoTimerControl(int cpu, int timer, u16 val)
{
	static int tick_lookup[] = { 1, 64, 256, 1024 };
	int number_of_ticks = tick_lookup[val&3];
	int cascade = val & (1<<2);
	int irq_enable = val & (1<<6);
	int timer_enable = val & (1<<7);
	TimerData* td = &timer_data[cpu][timer];

	td->rollover_ticks = number_of_ticks;
	td->cascade = cascade;
	if(!td->active && timer_enable) {
		td->count = td->reload;
		td->current_ticks = 0;
	}
	td->active = timer_enable;
	if(td->active) {
		REG(cpu, TM0D+(timer*2)) = td->count;
	}
	REG(cpu, TM0CNT+(timer*2)) = val;
}

int is_any_timer_active(int cpu) 
{
	int i=0;
	for(i=0;i<4;++i)
		if(timer_data[cpu][i].active)
			return 1;
	return 0;
}

// Process cacades for the given timer. This should be the
// timer that just overflowed possibly causing the next to
// cascade.
void DoTimerCascade(int cpu, int timer)
{
	if(timer < 3) {
		int ctimer = timer+1;
		TimerData* td = &timer_data[cpu][ctimer];
		if(td->cascade) {
			REG(cpu, TM0D+(ctimer*2)) = ++(td->count);
			if(td->count == 0) {
				REG(cpu, TM0D+(ctimer*2)) = td->reload;
				td->count = td->reload;
				DoTimerCascade(cpu, ctimer);
			}
		}
	}
}

void UpdateTimers(int cpu, int clk)
{
	int i=0;
	for(i=0;i<4;++i) {
		TimerData* td = &timer_data[cpu][i];
		if(td->active) {
			int overflow = 0;
			if(!td->cascade) {
				td->current_ticks += clk;
				if(td->current_ticks >= td->rollover_ticks) {
					td->current_ticks -= td->rollover_ticks;
					td->count++;
					REG(cpu, TM0D+(i*2)) = td->count;
					if(td->count == 0)
						overflow = 1;
				}
			}

			if(overflow) {
				REG(cpu, TM0D+(i*2)) = td->reload;
				td->count = td->reload;
				if(!td->cascade && (REG(cpu, TM0CNT+(i*2)) & 0x40)) 
#if defined(DS_COMPILE)
					if(cpu == ARM9_REG)
						IntFire9(1<<(3+i));
					else if(cpu == ARM7_REG)
						IntFire7(1<<(3+i));
#else
						IntFire7(1<<(3+i));
#endif
				DoTimerCascade(cpu, i);
			}
		}
	}
}

