#include "arm9.h"
#include "dsmmumain.h"

OPCODE Thumb9opUND() { return 1; }

#define Thumb9RdToEax() \
    __asm { \
        __asm mov eax,[arm9reg+ARMREG_OP*4] \
        __asm and eax,7 \
    }

#define Thumb9RdToEdx() \
    __asm { \
        __asm mov edx,[arm9reg+ARMREG_OP*4] \
        __asm and edx,7 \
    }

#define Thumb9addrRegC() \
    __asm { \
        __asm mov edx,[arm9reg+ARMREG_OP*4]    /* Read opcode */ \
        __asm mov ecx,edx                      /* Make a copy */ \
        __asm shr ecx,3                        /* Shift in Rn */ \
        __asm and ecx,7                        /* Mask to range */ \
        __asm mov ebx,[arm9reg+ecx*4]          /* Read value of Rn */ \
        __asm and edx,7                        /* Mask to Rd */ \
        __asm mov eax,[arm9reg+edx*4]          /* Read value of Rd */ \
    }

#define Thumb9addrImm5() \
    __asm { \
        __asm mov edx,[arm9reg+ARMREG_OP*4]    /* Read opcode */ \
        __asm mov ecx,edx                      /* Make a copy */ \
        __asm shr ecx,3                        /* Shift in Rn */ \
        __asm and ecx,7                        /* Mask to range */ \
        __asm mov eax,[arm9reg+ecx*4]          /* Read value of Rn */ \
        __asm mov ebx,edx                      /* Another copy */ \
        __asm shr ebx,6                        /* Shift in shftamount */ \
        __asm and ebx,31                       /* and mask off */ \
        __asm and edx,7                        /* Mask to Rd */ \
    }

#define Thumb9addrImm5shft() \
    __asm { \
        __asm mov edx,[arm9reg+ARMREG_OP*4]    /* Read opcode */ \
        __asm mov ecx,edx                      /* Make a copy */ \
        __asm shr ecx,3                        /* Shift in Rn */ \
        __asm and ecx,7                        /* Mask to range */ \
        __asm mov eax,[arm9reg+ecx*4]          /* Read value of Rn */ \
        __asm mov ebx,edx                      /* Another copy */ \
        __asm shr ebx,6                        /* Shift in shftamount */ \
        __asm and ebx,31                       /* and mask off */ \
        __asm jnz shft                         /* If zero.. */ \
        __asm mov ebx,32                       /* make 32 */ \
        __asm shft:                            /* Otherwise */ \
        __asm and edx,7                        /* Mask to Rd */ \
    }

#define Thumb9addrImm8() \
    __asm { \
        __asm mov ebx,[arm9reg+ARMREG_OP*4]    /* Read opcode */ \
        __asm and ebx,255 \
    }

#define Thumb9addrImm3() \
    __asm { \
        __asm mov ebx,[arm9reg+ARMREG_OP*4] \
        __asm mov ecx,ebx \
        __asm shr ecx,3                        /* Shift in Rn */ \
        __asm and ecx,7                        /* Mask to range */ \
        __asm mov ecx,[arm9reg+ecx*4]          /* Read value of Rn */ \
        __asm mov [arm9reg+eax*4],ecx \
        __asm shr ebx,6 \
        __asm and ebx,7                        /* Mask to Rm */ \
    }

#define Thumb9addrReg() \
    __asm { \
        __asm mov ebx,[arm9reg+ARMREG_OP*4] \
        __asm mov ecx,ebx \
        __asm shr ecx,3                        /* Shift in Rn */ \
        __asm and ecx,7                        /* Mask to range */ \
        __asm mov ecx,[arm9reg+ecx*4]          /* Read value of Rn */ \
        __asm mov [arm9reg+eax*4],ecx \
        __asm shr ebx,6 \
        __asm and ebx,7                        /* Mask to Rm */ \
        __asm mov ebx,[arm9reg+ebx*4] \
    }

#define Thumb9addrRegLS() \
    __asm { \
        __asm mov ebx,[arm9reg+ARMREG_OP*4] \
        __asm mov ecx,ebx \
        __asm shr ecx,3                        /* Shift in Rn */ \
        __asm and ecx,7                        /* Mask to range */ \
        __asm mov eax,[arm9reg+ecx*4]          /* Read value of Rn */ \
        __asm shr ebx,6 \
        __asm and ebx,7                        /* Mask to Rm */ \
        __asm mov ebx,[arm9reg+ebx*4] \
    }

#define Thumb9addrH() \
    __asm { \
        __asm mov eax,[arm9reg+ARMREG_OP*4] \
        __asm mov ecx,eax \
        __asm and eax,7 \
        __asm shr ecx,4 \
        __asm and ecx,8 \
        __asm or eax,ecx \
        __asm mov ecx,[arm9reg+ARMREG_OP*4] \
        __asm shr ecx,3                        /* Shift in Rn */ \
        __asm and ecx,15                       /* Mask to range */ \
        __asm mov ebx,[arm9reg+ecx*4]          /* Read value of Rn */ \
        __asm cmp ecx,15 \
        __asm jne nopc \
        __asm add ebx,2 \
        __asm nopc: \
    }

#define Thumb9addrPC() \
    __asm { \
        __asm mov ebx,[arm9reg+ARMREG_OP*4] \
        __asm and ebx,255\
        __asm shl ebx,2 \
        __asm mov eax,[arm9reg+15*4] \
        __asm add eax,2 \
        __asm and eax,0xFFFFFFFC \
    }

#define Thumb9addrSP() \
    __asm { \
        __asm mov ebx,[arm9reg+ARMREG_OP*4] \
        __asm and ebx,255\
        __asm shl ebx,2 \
        __asm mov eax,[arm9reg+13*4] \
    }

#define Thumb9addrPCalu() \
    __asm { \
        __asm mov ebx,[arm9reg+ARMREG_OP*4] \
        __asm and ebx,255\
        __asm shl ebx,2 \
        __asm mov ecx,[arm9reg+15*4] \
        __asm add ecx,2 \
        __asm and ecx,0xFFFFFFFC \
        __asm mov [arm9reg+eax*4],ecx \
    }

#define Thumb9addrSPalu() \
    __asm { \
        __asm mov ebx,[arm9reg+ARMREG_OP*4] \
        __asm and ebx,255\
        __asm shl ebx,2 \
        __asm mov ecx,[arm9reg+13*4] \
        __asm mov [arm9reg+eax*4],ecx \
    }

#define Thumb9addrImm7() \
    __asm { \
        __asm mov edx,[arm9reg+ARMREG_OP*4] \
        __asm mov ebx,edx \
        __asm and ebx,127 \
        __asm shl ebx,2 \
        __asm test edx,0x0080 \
        __asm je imm7done \
        __asm neg ebx \
        __asm imm7done: \
    }

#define Thumb9opTST() \
    __asm { \
        __asm and eax,ebx \
    }

#define Thumb9opCMPdp() \
    __asm { \
        __asm sub eax,ebx \
    }

#define Thumb9opCMN() \
    __asm { \
        __asm add eax,ebx \
    }

#define Thumb9opNEG() \
    __asm { \
        __asm xor eax,eax \
        __asm sub eax,ebx \
        __asm mov [arm9reg+edx*4],eax \
    }

#define Thumb9opAND() \
    __asm { \
        __asm and eax,ebx \
        __asm mov [arm9reg+edx*4],eax \
    }

#define Thumb9opEOR() \
    __asm { \
        __asm xor eax,ebx \
        __asm mov [arm9reg+edx*4],eax \
    }

#define Thumb9opORR() \
    __asm { \
        __asm or eax,ebx \
        __asm mov [arm9reg+edx*4],eax \
    }

#define Thumb9opBIC() \
    __asm { \
        __asm not ebx \
        __asm and eax,ebx \
        __asm mov [arm9reg+edx*4],eax \
    }

#define Thumb9opMUL() \
    __asm { \
        __asm mov ecx,[arm9reg+ARMREG_OP*4]    /* Read opcode */ \
        __asm and ecx,7 \
        __asm mul ebx \
        __asm mov [arm9reg+ecx*4],eax \
    }

#define Thumb9opMVN() \
    __asm { \
        __asm not ebx \
        __asm mov [arm9reg+edx*4],ebx \
    }

#define Thumb9opADC() \
    __asm { \
        __asm mov ecx,[arm9reg+ARMREG_FC*4]    /* Read in carry flag */ \
        __asm shr ecx,1                        /* Shift into x86 C */ \
        __asm adc eax,ebx                      /* Do teh adc */ \
        __asm mov [arm9reg+edx*4],eax          /* And save the result */ \
    }

#define Thumb9opSBC() \
    __asm { \
        __asm mov ecx,[arm9reg+ARMREG_FC*4] \
        __asm not ecx \
        __asm shr ecx,1 \
        __asm sbb eax,ebx \
        __asm mov [arm9reg+edx*4],eax \
    }

#define Thumb9opLSL() \
    __asm { \
        __asm mov ecx,ebx \
        __asm and ecx,255 \
        __asm jz noshft_lsl                   /* Skip if no shift */ \
        __asm cmp cl,32                       /* If greater than 32 */ \
        __asm jg overshft_lsl                 /* Shift all the way */ \
        __asm je fullshft_lsl                 /* If equal, shift to carry */ \
        __asm shl eax,cl                      /* Shift operand1 */ \
        __asm jmp shftdone_lsl                /* And skip carry read */ \
        __asm noshft_lsl:                     /* Done shifting */ \
        \
        __asm mov ecx,[arm9reg+ARMREG_FC*4]   /* Read saved carry */ \
        __asm shr ecx,1                       /* Shift into x86 c */ \
        __asm jmp shftdone_lsl                /* Skip over */ \
        __asm fullshft_lsl:                   /* Shift by 32 */ \
        __asm mov ecx,eax                     /* Make a copy */ \
        __asm xor eax,eax                     /* Rm=0 */ \
        __asm shr ecx,1                       /* Carry = Rm[0] */ \
        __asm jmp shftdone_lsl                /* Skip over */ \
        __asm overshft_lsl:                   /* Shift over 32 */ \
        __asm xor eax,eax                     /* Rm=0 */ \
        __asm shr eax,1                       /* And carry=0 */ \
        __asm shftdone_lsl:                   /* all done! */ \
        __asm mov [arm9reg+edx*4],eax \
    }

#define Thumb9opLSR() \
    __asm { \
        __asm mov ecx,ebx \
        __asm and ecx,255 \
        __asm jz noshft                       /* Skip if no shift */ \
        __asm cmp cl,32                       /* If greater than 32 */ \
        __asm jg overshft                     /* Shift all the way */ \
        __asm je fullshft                     /* If equal, shift to carry */ \
        __asm shr eax,cl                      /* Shift operand1 */ \
        __asm jmp shftdone                    /* And skip carry read */ \
        __asm noshft:                         /* Done shifting */ \
        \
        __asm mov ecx,[arm9reg+ARMREG_FC*4]   /* Read saved carry */ \
        __asm shr ecx,1                       /* Shift into x86 c */ \
        __asm jmp shftdone                    /* Skip over */ \
        __asm fullshft:                       /* Shift by 32 */ \
        __asm mov ecx,eax                     /* Make a copy */ \
        __asm xor eax,eax                     /* Rm=0 */ \
        __asm shl ecx,1                       /* Carry = Rm[31] */ \
        __asm jmp shftdone                    /* Skip over */ \
        __asm overshft:                       /* Shift over 32 */ \
        __asm xor eax,eax                     /* Rm=0 */ \
        __asm shr eax,1                       /* And carry=0 */ \
        __asm shftdone:                       /* all done! */ \
        __asm mov [arm9reg+edx*4],eax \
    }

#define Thumb9opASR() \
    __asm { \
        __asm mov ecx,ebx \
        __asm and ecx,255 \
        __asm jz noshft                       /* Skip if no shift */ \
        __asm cmp cl,32                       /* If greater than 32 */ \
        __asm jge fullshft                    /* Shift all the way */ \
        __asm sar eax,cl                      /* Shift operand1 */ \
        __asm jmp shftdone                    /* And skip carry read */ \
        __asm noshft:                         /* Done shifting */ \
	\
        __asm mov ecx,[arm9reg+ARMREG_FC*4]   /* Read saved carry */ \
        __asm shr ecx,1                       /* Shift into x86 c */ \
        __asm jmp shftdone                    /* and skip over */ \
        __asm fullshft:                       /* shift over 31 */ \
 	__asm mov ecx,eax                     /* Make a copy */ \
        __asm sar eax,31                      /* Fill with hi bit */ \
        __asm shl ecx,1                       /* Carry = Rm[31] */ \
        __asm shftdone:                       /* all done! */ \
        __asm mov [arm9reg+edx*4],eax \
    }

#define Thumb9opROR() \
    __asm { \
        __asm mov ecx,ebx                     /* Make a copy of Rn */ \
        __asm and ecx,255                     /* Get the low byte */ \
        __asm jz noshft_ror                   /* Skip if no shift */ \
        __asm and cl,31                       /* Check [4:0] */ \
        __asm jz fullshft_ror                 /* And skip if full */ \
        __asm ror eax,cl                      /* Shift operand1 */ \
        __asm jmp shftdone_ror                /* And skip carry read */ \
        __asm noshft_ror:                     /* Done shifting */ \
	\
        __asm mov ecx,[arm9reg+ARMREG_FC*4]   /* Read saved carry */ \
        __asm shr ecx,1                       /* Shift into x86 c */ \
        __asm jmp shftdone_ror                /* Skip over */ \
        __asm fullshft_ror:                   /* Shifting by full */ \
        __asm mov ecx,eax                     /* Make a copy of Rm */ \
        __asm shl ecx,1                       /* Carry = hi bit */ \
        __asm shftdone_ror:                   /* all done! */ \
        __asm mov [arm9reg+edx*4],eax \
    }

#define Thumb9opLDR() \
    __asm { \
        __asm add eax,ebx \
        __asm push edx                  /* Save Rd */ \
        __asm push eax                  /* Address */ \
        __asm xor ecx,ecx               /* Bus = 0 */ \
        __asm push ecx                  /* Push "bus number" */ \
        __asm call MMUMainrdW               /* Read a word */ \
        __asm pop ecx                   /* Clear stack */ \
        __asm pop ecx                   /* of params */ \
        __asm pop edx                   /* Get Rd back */\
	__asm mov [arm9reg+edx*4],eax   /* Write value to Rd */ \
	__asm mov eax,3 \
    }

#define Thumb9opSTR() \
    __asm { \
        __asm add eax,ebx \
        __asm mov ecx,[arm9reg+edx*4]     /* Push Rd */ \
        __asm push ecx \
        __asm push eax                    /* Push address */ \
        __asm xor ecx,ecx                 /* Bus = 0 */ \
        __asm push ecx                    /* Push "bus number" */ \
        __asm call MMUMainwrW                 /* Write thru MMUMain */ \
        __asm pop eax                     /* Clear stack */ \
        __asm pop eax                     /* of pushed */ \
        __asm pop eax                     /* parameters */ \
        __asm mov eax,2 \
    }

#define Thumb9opLDRH() \
    __asm { \
        __asm add eax,ebx \
        __asm push edx                  /* Save Rd */ \
        __asm push eax                  /* Address */ \
        __asm xor ecx,ecx               /* Bus = 0 */ \
        __asm push ecx                  /* Push "bus number" */ \
        __asm call MMUMainrdH               /* Read a word */ \
        __asm pop ecx                   /* Clear stack */ \
        __asm pop ecx                   /* of params */ \
        __asm pop edx                   /* Get Rd back */\
        __asm movzx ecx,ax \
	__asm mov [arm9reg+edx*4],ecx   /* Write value to Rd */ \
	__asm mov eax,3 \
    }

#define Thumb9opSTRH() \
    __asm { \
        __asm add eax,ebx \
        __asm mov ecx,[arm9reg+edx*4]     /* Push Rd */ \
        __asm and ecx,0x0000FFFF \
        __asm push ecx \
        __asm push eax                    /* Push address */ \
        __asm xor ecx,ecx                 /* Bus = 0 */ \
        __asm push ecx                    /* Push "bus number" */ \
        __asm call MMUMainwrH                 /* Write thru MMUMain */ \
        __asm pop eax                     /* Clear stack */ \
        __asm pop eax                     /* of pushed */ \
        __asm pop eax                     /* parameters */ \
        __asm mov eax,2 \
    }

#define Thumb9opLDRB() \
    __asm { \
        __asm add eax,ebx \
        __asm push edx                  /* Save Rd */ \
        __asm push eax                  /* Address */ \
        __asm xor ecx,ecx               /* Bus = 0 */ \
        __asm push ecx                  /* Push "bus number" */ \
        __asm call MMUMainrdB               /* Read a word */ \
        __asm pop ecx                   /* Clear stack */ \
        __asm pop ecx                   /* of params */ \
        __asm pop edx                   /* Get Rd back */\
        __asm movzx ecx,al \
	__asm mov [arm9reg+edx*4],ecx   /* Write value to Rd */ \
	__asm mov eax,3 \
    }

#define Thumb9opSTRB() \
    __asm { \
        __asm add eax,ebx \
        __asm mov ecx,[arm9reg+edx*4]     /* Push Rd */ \
        __asm and ecx,0x000000FF \
        __asm push ecx \
        __asm push eax                    /* Push address */ \
        __asm xor ecx,ecx                 /* Bus = 0 */ \
        __asm push ecx                    /* Push "bus number" */ \
        __asm call MMUMainwrB                 /* Write thru MMUMain */ \
        __asm pop eax                     /* Clear stack */ \
        __asm pop eax                     /* of pushed */ \
        __asm pop eax                     /* parameters */ \
        __asm mov eax,2 \
    }

#define Thumb9opLDRSH() \
    __asm { \
        __asm add eax,ebx \
        __asm push edx                  /* Save Rd */ \
        __asm push eax                  /* Address */ \
        __asm xor ecx,ecx               /* Bus = 0 */ \
        __asm push ecx                  /* Push "bus number" */ \
        __asm call MMUMainrdH               /* Read a word */ \
        __asm pop ecx                   /* Clear stack */ \
        __asm pop ecx                   /* of params */ \
        __asm pop edx                   /* Get Rd back */\
        __asm movsx ecx,ax \
	__asm mov [arm9reg+edx*4],ecx   /* Write value to Rd */ \
	__asm mov eax,3 \
    }

#define Thumb9opLDRSB() \
    __asm { \
        __asm add eax,ebx \
        __asm push edx                  /* Save Rd */ \
        __asm push eax                  /* Address */ \
        __asm xor ecx,ecx               /* Bus = 0 */ \
        __asm push ecx                  /* Push "bus number" */ \
        __asm call MMUMainrdB               /* Read a word */ \
        __asm pop ecx                   /* Clear stack */ \
        __asm pop ecx                   /* of params */ \
        __asm pop edx                   /* Get Rd back */\
        __asm movsx ecx,al \
	__asm mov [arm9reg+edx*4],ecx   /* Write value to Rd */ \
	__asm mov eax,3 \
    }

#define Thumb9flagsShft() \
    __asm { \
        __asm setc  [arm9reg+ARMREG_FC*4]      /* C flag */ \
        __asm mov ecx,eax \
        __asm or eax,eax \
        __asm setz [arm9reg+ARMREG_FZ*4] \
        __asm shr ecx,31 \
        __asm mov [arm9reg+ARMREG_FN*4],ecx \
        __asm mov eax,1 \
    }

#define Thumb9flagsBIT() \
    __asm { \
        __asm sets  [arm9reg+ARMREG_FN*4]      /* Copy N flag */ \
        __asm setz  [arm9reg+ARMREG_FZ*4]      /* and Z flag */ \
        __asm setc  [arm9reg+ARMREG_FC*4]      /* C flag */ \
        __asm mov eax,1 \
    }

#define Thumb9flagsADD() \
    __asm { \
        __asm sets  [arm9reg+ARMREG_FN*4]      /* Copy N flag */ \
        __asm setz  [arm9reg+ARMREG_FZ*4]      /* and Z flag */ \
        __asm seto  [arm9reg+ARMREG_FV*4]      /* V too */ \
        __asm setc  [arm9reg+ARMREG_FC*4]      /* C flag */ \
        __asm mov eax,1 \
    }

#define Thumb9flagsSUB() \
    __asm { \
        __asm sets  [arm9reg+ARMREG_FN*4]      /* Copy N flag */ \
        __asm setz  [arm9reg+ARMREG_FZ*4]      /* and Z flag */ \
        __asm seto  [arm9reg+ARMREG_FV*4]      /* V too */ \
        __asm setnc [arm9reg+ARMREG_FC*4]      /* C flag */ \
        __asm mov eax,1 \
    }

#define Thumb9opMOV()                          /* eax = Rd */ \
    __asm { \
        __asm mov ecx,[arm9reg+ARMREG_FC*4]   /* Read saved carry */ \
        __asm shr ecx,1                       /* Shift into x86 c */ \
        __asm mov [arm9reg+eax*4],ebx \
        __asm or ebx,ebx \
    }

#define Thumb9opADD()                          /* eax = Rd */ \
    __asm { \
        __asm add [arm9reg+eax*4],ebx \
    }

#define Thumb9opSUB() \
    __asm { \
        __asm sub [arm9reg+eax*4],ebx \
    }

#define Thumb9opCMP() \
    __asm { \
        __asm mov ecx,[arm9reg+eax*4] \
        __asm sub ecx,ebx \
    }

#define Thumb9addrB() \
    arm9reg.tmp2=arm9reg.curop&0x00FF; \
    arm9reg.tmp1=(arm9reg.tmp2&0x0080)? \
                 (0xFFFFFF00|arm9reg.tmp2): \
		 (0x00000000|arm9reg.tmp2)

OPCODE Thumb9opLSLimm() { Thumb9addrImm5shft(); Thumb9opLSL(); Thumb9flagsShft(); }
OPCODE Thumb9opLSRimm() { Thumb9addrImm5shft(); Thumb9opLSR(); Thumb9flagsBIT(); }
OPCODE Thumb9opASRimm() { Thumb9addrImm5shft(); Thumb9opASR(); Thumb9flagsShft(); }

OPCODE Thumb9opADDreg() { Thumb9RdToEax(); Thumb9addrReg(); Thumb9opADD(); Thumb9flagsADD(); }
OPCODE Thumb9opSUBreg() { Thumb9RdToEax(); Thumb9addrReg(); Thumb9opSUB(); Thumb9flagsSUB(); }

OPCODE Thumb9opADDimm3() { Thumb9RdToEax(); Thumb9addrImm3(); Thumb9opADD(); Thumb9flagsADD(); }
OPCODE Thumb9opSUBimm3() { Thumb9RdToEax(); Thumb9addrImm3(); Thumb9opSUB(); Thumb9flagsSUB(); }

OPCODE Thumb9opMOVimm8r0() { __asm { mov eax,0 } Thumb9addrImm8(); Thumb9opMOV(); Thumb9flagsBIT(); }
OPCODE Thumb9opMOVimm8r1() { __asm { mov eax,1 } Thumb9addrImm8(); Thumb9opMOV(); Thumb9flagsBIT(); }
OPCODE Thumb9opMOVimm8r2() { __asm { mov eax,2 } Thumb9addrImm8(); Thumb9opMOV(); Thumb9flagsBIT(); }
OPCODE Thumb9opMOVimm8r3() { __asm { mov eax,3 } Thumb9addrImm8(); Thumb9opMOV(); Thumb9flagsBIT(); }
OPCODE Thumb9opMOVimm8r4() { __asm { mov eax,4 } Thumb9addrImm8(); Thumb9opMOV(); Thumb9flagsBIT(); }
OPCODE Thumb9opMOVimm8r5() { __asm { mov eax,5 } Thumb9addrImm8(); Thumb9opMOV(); Thumb9flagsBIT(); }
OPCODE Thumb9opMOVimm8r6() { __asm { mov eax,6 } Thumb9addrImm8(); Thumb9opMOV(); Thumb9flagsBIT(); }
OPCODE Thumb9opMOVimm8r7() { __asm { mov eax,7 } Thumb9addrImm8(); Thumb9opMOV(); Thumb9flagsBIT(); }
OPCODE Thumb9opCMPimm8r0() { __asm { mov eax,0 } Thumb9addrImm8(); Thumb9opCMP(); Thumb9flagsSUB(); }
OPCODE Thumb9opCMPimm8r1() { __asm { mov eax,1 } Thumb9addrImm8(); Thumb9opCMP(); Thumb9flagsSUB(); }
OPCODE Thumb9opCMPimm8r2() { __asm { mov eax,2 } Thumb9addrImm8(); Thumb9opCMP(); Thumb9flagsSUB(); }
OPCODE Thumb9opCMPimm8r3() { __asm { mov eax,3 } Thumb9addrImm8(); Thumb9opCMP(); Thumb9flagsSUB(); }
OPCODE Thumb9opCMPimm8r4() { __asm { mov eax,4 } Thumb9addrImm8(); Thumb9opCMP(); Thumb9flagsSUB(); }
OPCODE Thumb9opCMPimm8r5() { __asm { mov eax,5 } Thumb9addrImm8(); Thumb9opCMP(); Thumb9flagsSUB(); }
OPCODE Thumb9opCMPimm8r6() { __asm { mov eax,6 } Thumb9addrImm8(); Thumb9opCMP(); Thumb9flagsSUB(); }
OPCODE Thumb9opCMPimm8r7() { __asm { mov eax,7 } Thumb9addrImm8(); Thumb9opCMP(); Thumb9flagsSUB(); }
OPCODE Thumb9opADDimm8r0() { __asm { mov eax,0 } Thumb9addrImm8(); Thumb9opADD(); Thumb9flagsADD(); }
OPCODE Thumb9opADDimm8r1() { __asm { mov eax,1 } Thumb9addrImm8(); Thumb9opADD(); Thumb9flagsADD(); }
OPCODE Thumb9opADDimm8r2() { __asm { mov eax,2 } Thumb9addrImm8(); Thumb9opADD(); Thumb9flagsADD(); }
OPCODE Thumb9opADDimm8r3() { __asm { mov eax,3 } Thumb9addrImm8(); Thumb9opADD(); Thumb9flagsADD(); }
OPCODE Thumb9opADDimm8r4() { __asm { mov eax,4 } Thumb9addrImm8(); Thumb9opADD(); Thumb9flagsADD(); }
OPCODE Thumb9opADDimm8r5() { __asm { mov eax,5 } Thumb9addrImm8(); Thumb9opADD(); Thumb9flagsADD(); }
OPCODE Thumb9opADDimm8r6() { __asm { mov eax,6 } Thumb9addrImm8(); Thumb9opADD(); Thumb9flagsADD(); }
OPCODE Thumb9opADDimm8r7() { __asm { mov eax,7 } Thumb9addrImm8(); Thumb9opADD(); Thumb9flagsADD(); }
OPCODE Thumb9opSUBimm8r0() { __asm { mov eax,0 } Thumb9addrImm8(); Thumb9opSUB(); Thumb9flagsSUB(); }
OPCODE Thumb9opSUBimm8r1() { __asm { mov eax,1 } Thumb9addrImm8(); Thumb9opSUB(); Thumb9flagsSUB(); }
OPCODE Thumb9opSUBimm8r2() { __asm { mov eax,2 } Thumb9addrImm8(); Thumb9opSUB(); Thumb9flagsSUB(); }
OPCODE Thumb9opSUBimm8r3() { __asm { mov eax,3 } Thumb9addrImm8(); Thumb9opSUB(); Thumb9flagsSUB(); }
OPCODE Thumb9opSUBimm8r4() { __asm { mov eax,4 } Thumb9addrImm8(); Thumb9opSUB(); Thumb9flagsSUB(); }
OPCODE Thumb9opSUBimm8r5() { __asm { mov eax,5 } Thumb9addrImm8(); Thumb9opSUB(); Thumb9flagsSUB(); }
OPCODE Thumb9opSUBimm8r6() { __asm { mov eax,6 } Thumb9addrImm8(); Thumb9opSUB(); Thumb9flagsSUB(); }
OPCODE Thumb9opSUBimm8r7() { __asm { mov eax,7 } Thumb9addrImm8(); Thumb9opSUB(); Thumb9flagsSUB(); }

OPCODE Thumb9opDPg1()
{
    switch(arm9reg.curop&0x00C0)
    {
        case 0x0000: Thumb9addrRegC(); Thumb9opAND(); Thumb9flagsBIT(); break;
        case 0x0040: Thumb9addrRegC(); Thumb9opEOR(); Thumb9flagsBIT(); break;
        case 0x0080: Thumb9addrRegC(); Thumb9opLSL(); Thumb9flagsShft(); break;
        case 0x00C0: Thumb9addrRegC(); Thumb9opLSR(); Thumb9flagsBIT(); break;
    }
    return 1;
}

OPCODE Thumb9opDPg2()
{
    switch(arm9reg.curop&0x00C0)
    {
        case 0x0000: Thumb9addrRegC(); Thumb9opASR(); Thumb9flagsShft(); break;
        case 0x0040: Thumb9addrRegC(); Thumb9opADC(); Thumb9flagsADD(); break;
        case 0x0080: Thumb9addrRegC(); Thumb9opSBC(); Thumb9flagsSUB(); break;
        case 0x00C0: Thumb9addrRegC(); Thumb9opROR(); Thumb9flagsShft(); break;
    }
    return 1;
}

OPCODE Thumb9opDPg3()
{
    switch(arm9reg.curop&0x00C0)
    {
        case 0x0000: Thumb9addrRegC(); Thumb9opTST(); Thumb9flagsBIT(); break;
        case 0x0040: Thumb9addrRegC(); Thumb9opNEG(); Thumb9flagsSUB(); break;
        case 0x0080: Thumb9addrRegC(); Thumb9opCMPdp(); Thumb9flagsSUB(); break;
        case 0x00C0: Thumb9addrRegC(); Thumb9opCMN(); Thumb9flagsADD(); break;
    }
    return 1;
}

OPCODE Thumb9opDPg4()
{
    switch(arm9reg.curop&0x00C0)
    {
        case 0x0000: Thumb9addrRegC(); Thumb9opORR(); Thumb9flagsBIT(); break;
        case 0x0040: Thumb9addrRegC(); Thumb9opMUL(); Thumb9flagsShft(); break;
        case 0x0080: Thumb9addrRegC(); Thumb9opBIC(); Thumb9flagsBIT(); break;
        case 0x00C0: Thumb9addrRegC(); Thumb9opMVN(); Thumb9flagsBIT(); break;
    }
    return 1;
}

OPCODE Thumb9opADDH() { Thumb9addrH(); Thumb9opADD(); return 1; }
OPCODE Thumb9opMOVH() { Thumb9addrH(); Thumb9opMOV(); return 1; }
OPCODE Thumb9opCMPH() { Thumb9addrH(); Thumb9opCMP(); Thumb9flagsSUB(); }

OPCODE Thumb9opLDRPCr0() { __asm { mov edx,0 } Thumb9addrPC(); Thumb9opLDR(); }
OPCODE Thumb9opLDRPCr1() { __asm { mov edx,1 } Thumb9addrPC(); Thumb9opLDR(); }
OPCODE Thumb9opLDRPCr2() { __asm { mov edx,2 } Thumb9addrPC(); Thumb9opLDR(); }
OPCODE Thumb9opLDRPCr3() { __asm { mov edx,3 } Thumb9addrPC(); Thumb9opLDR(); }
OPCODE Thumb9opLDRPCr4() { __asm { mov edx,4 } Thumb9addrPC(); Thumb9opLDR(); }
OPCODE Thumb9opLDRPCr5() { __asm { mov edx,5 } Thumb9addrPC(); Thumb9opLDR(); }
OPCODE Thumb9opLDRPCr6() { __asm { mov edx,6 } Thumb9addrPC(); Thumb9opLDR(); }
OPCODE Thumb9opLDRPCr7() { __asm { mov edx,7 } Thumb9addrPC(); Thumb9opLDR(); }

OPCODE Thumb9opLDRSPr0() { __asm { mov edx,0 } Thumb9addrSP(); Thumb9opLDR(); }
OPCODE Thumb9opLDRSPr1() { __asm { mov edx,1 } Thumb9addrSP(); Thumb9opLDR(); }
OPCODE Thumb9opLDRSPr2() { __asm { mov edx,2 } Thumb9addrSP(); Thumb9opLDR(); }
OPCODE Thumb9opLDRSPr3() { __asm { mov edx,3 } Thumb9addrSP(); Thumb9opLDR(); }
OPCODE Thumb9opLDRSPr4() { __asm { mov edx,4 } Thumb9addrSP(); Thumb9opLDR(); }
OPCODE Thumb9opLDRSPr5() { __asm { mov edx,5 } Thumb9addrSP(); Thumb9opLDR(); }
OPCODE Thumb9opLDRSPr6() { __asm { mov edx,6 } Thumb9addrSP(); Thumb9opLDR(); }
OPCODE Thumb9opLDRSPr7() { __asm { mov edx,7 } Thumb9addrSP(); Thumb9opLDR(); }
OPCODE Thumb9opSTRSPr0() { __asm { mov edx,0 } Thumb9addrSP(); Thumb9opSTR(); }
OPCODE Thumb9opSTRSPr1() { __asm { mov edx,1 } Thumb9addrSP(); Thumb9opSTR(); }
OPCODE Thumb9opSTRSPr2() { __asm { mov edx,2 } Thumb9addrSP(); Thumb9opSTR(); }
OPCODE Thumb9opSTRSPr3() { __asm { mov edx,3 } Thumb9addrSP(); Thumb9opSTR(); }
OPCODE Thumb9opSTRSPr4() { __asm { mov edx,4 } Thumb9addrSP(); Thumb9opSTR(); }
OPCODE Thumb9opSTRSPr5() { __asm { mov edx,5 } Thumb9addrSP(); Thumb9opSTR(); }
OPCODE Thumb9opSTRSPr6() { __asm { mov edx,6 } Thumb9addrSP(); Thumb9opSTR(); }
OPCODE Thumb9opSTRSPr7() { __asm { mov edx,7 } Thumb9addrSP(); Thumb9opSTR(); }

OPCODE Thumb9opSTRreg()   { Thumb9RdToEdx(); Thumb9addrRegLS(); Thumb9opSTR(); }
OPCODE Thumb9opLDRreg()   { Thumb9RdToEdx(); Thumb9addrRegLS(); Thumb9opLDR(); }
OPCODE Thumb9opSTRHreg()  { Thumb9RdToEdx(); Thumb9addrRegLS(); Thumb9opSTRH(); }
OPCODE Thumb9opLDRHreg()  { Thumb9RdToEdx(); Thumb9addrRegLS(); Thumb9opLDRH(); }
OPCODE Thumb9opSTRBreg()  { Thumb9RdToEdx(); Thumb9addrRegLS(); Thumb9opSTRB(); }
OPCODE Thumb9opLDRBreg()  { Thumb9RdToEdx(); Thumb9addrRegLS(); Thumb9opLDRB(); }
OPCODE Thumb9opLDRSBreg() { Thumb9RdToEdx(); Thumb9addrRegLS(); Thumb9opLDRSB(); }
OPCODE Thumb9opLDRSHreg() { Thumb9RdToEdx(); Thumb9addrRegLS(); Thumb9opLDRSH(); }

OPCODE Thumb9opSTRimm5()  { Thumb9RdToEdx(); Thumb9addrImm5(); __asm { shl ebx,2 } Thumb9opSTR(); }
OPCODE Thumb9opLDRimm5()  { Thumb9RdToEdx(); Thumb9addrImm5(); __asm { shl ebx,2 } Thumb9opLDR(); }
OPCODE Thumb9opSTRHimm5() { Thumb9RdToEdx(); Thumb9addrImm5(); __asm { shl ebx,1 } Thumb9opSTRH(); }
OPCODE Thumb9opLDRHimm5() { Thumb9RdToEdx(); Thumb9addrImm5(); __asm { shl ebx,1 } Thumb9opLDRH(); }
OPCODE Thumb9opSTRBimm5() { Thumb9RdToEdx(); Thumb9addrImm5(); Thumb9opSTRB(); }
OPCODE Thumb9opLDRBimm5() { Thumb9RdToEdx(); Thumb9addrImm5(); Thumb9opLDRB(); }

OPCODE Thumb9opADDPCr0() { __asm { mov eax,0 } Thumb9addrPCalu(); Thumb9opADD(); return 1; }
OPCODE Thumb9opADDPCr1() { __asm { mov eax,1 } Thumb9addrPCalu(); Thumb9opADD(); return 1; }
OPCODE Thumb9opADDPCr2() { __asm { mov eax,2 } Thumb9addrPCalu(); Thumb9opADD(); return 1; }
OPCODE Thumb9opADDPCr3() { __asm { mov eax,3 } Thumb9addrPCalu(); Thumb9opADD(); return 1; }
OPCODE Thumb9opADDPCr4() { __asm { mov eax,4 } Thumb9addrPCalu(); Thumb9opADD(); return 1; }
OPCODE Thumb9opADDPCr5() { __asm { mov eax,5 } Thumb9addrPCalu(); Thumb9opADD(); return 1; }
OPCODE Thumb9opADDPCr6() { __asm { mov eax,6 } Thumb9addrPCalu(); Thumb9opADD(); return 1; }
OPCODE Thumb9opADDPCr7() { __asm { mov eax,7 } Thumb9addrPCalu(); Thumb9opADD(); return 1; }
OPCODE Thumb9opADDSPr0() { __asm { mov eax,0 } Thumb9addrSPalu(); Thumb9opADD(); return 1; }
OPCODE Thumb9opADDSPr1() { __asm { mov eax,1 } Thumb9addrSPalu(); Thumb9opADD(); return 1; }
OPCODE Thumb9opADDSPr2() { __asm { mov eax,2 } Thumb9addrSPalu(); Thumb9opADD(); return 1; }
OPCODE Thumb9opADDSPr3() { __asm { mov eax,3 } Thumb9addrSPalu(); Thumb9opADD(); return 1; }
OPCODE Thumb9opADDSPr4() { __asm { mov eax,4 } Thumb9addrSPalu(); Thumb9opADD(); return 1; }
OPCODE Thumb9opADDSPr5() { __asm { mov eax,5 } Thumb9addrSPalu(); Thumb9opADD(); return 1; }
OPCODE Thumb9opADDSPr6() { __asm { mov eax,6 } Thumb9addrSPalu(); Thumb9opADD(); return 1; }
OPCODE Thumb9opADDSPr7() { __asm { mov eax,7 } Thumb9addrSPalu(); Thumb9opADD(); return 1; }

OPCODE Thumb9opADDSPimm7() { __asm { mov eax,13 } Thumb9addrImm7(); Thumb9opADD(); return 1; }

OPCODE Thumb9opBEQ() {if(ARM9condEQ()){Thumb9addrB();arm9reg.r[15]+=((signed)arm9reg.tmp1)*2+2;} return 1; }
OPCODE Thumb9opBNE() {if(ARM9condNE()){Thumb9addrB();arm9reg.r[15]+=((signed)arm9reg.tmp1)*2+2;} return 1; }
OPCODE Thumb9opBCS() {if(ARM9condCS()){Thumb9addrB();arm9reg.r[15]+=((signed)arm9reg.tmp1)*2+2;} return 1; }
OPCODE Thumb9opBCC() {if(ARM9condCC()){Thumb9addrB();arm9reg.r[15]+=((signed)arm9reg.tmp1)*2+2;} return 1; }
OPCODE Thumb9opBMI() {if(ARM9condMI()){Thumb9addrB();arm9reg.r[15]+=((signed)arm9reg.tmp1)*2+2;} return 1; }
OPCODE Thumb9opBPL() {if(ARM9condPL()){Thumb9addrB();arm9reg.r[15]+=((signed)arm9reg.tmp1)*2+2;} return 1; }
OPCODE Thumb9opBVS() {if(ARM9condVS()){Thumb9addrB();arm9reg.r[15]+=((signed)arm9reg.tmp1)*2+2;} return 1; }
OPCODE Thumb9opBVC() {if(ARM9condVC()){Thumb9addrB();arm9reg.r[15]+=((signed)arm9reg.tmp1)*2+2;} return 1; }
OPCODE Thumb9opBHI() {if(ARM9condHI()){Thumb9addrB();arm9reg.r[15]+=((signed)arm9reg.tmp1)*2+2;} return 1; }
OPCODE Thumb9opBLS() {if(ARM9condLS()){Thumb9addrB();arm9reg.r[15]+=((signed)arm9reg.tmp1)*2+2;} return 1; }
OPCODE Thumb9opBGE() {if(ARM9condGE()){Thumb9addrB();arm9reg.r[15]+=((signed)arm9reg.tmp1)*2+2;} return 1; }
OPCODE Thumb9opBLT() {if(ARM9condLT()){Thumb9addrB();arm9reg.r[15]+=((signed)arm9reg.tmp1)*2+2;} return 1; }
OPCODE Thumb9opBGT() {if(ARM9condGT()){Thumb9addrB();arm9reg.r[15]+=((signed)arm9reg.tmp1)*2+2;} return 1; }
OPCODE Thumb9opBLE() {if(ARM9condLE()){Thumb9addrB();arm9reg.r[15]+=((signed)arm9reg.tmp1)*2+2;} return 1; }
OPCODE Thumb9opBAL() {if(ARM9condAL()){Thumb9addrB();arm9reg.r[15]+=((signed)arm9reg.tmp1)*2+2;} return 1; }
OPCODE Thumb9opBNV() {if(ARM9condNV()){Thumb9addrB();arm9reg.r[15]+=((signed)arm9reg.tmp1)*2+2;} return 1; }

OPCODE Thumb9opB()
{
    arm9reg.tmp2=arm9reg.curop&0x07FF;
    arm9reg.tmp1=(arm9reg.tmp2&0x0400)?
                 (0xFFFFF800|arm9reg.tmp2):
		 (0x00000000|arm9reg.tmp2);
    arm9reg.r[15]+=((signed)arm9reg.tmp1)*2+2;
    return 3;
}

OPCODE Thumb9opBXreg()
{
    if(arm9reg.curop&0x0080) arm9reg.r[14]=arm9reg.r[15]|1;
    arm9reg.r[15]=arm9reg.r[ARM9TOP_RNH]&0xFFFFFFFE;
    arm9reg.flags[ARMFLAG_T]=arm9reg.r[ARM9TOP_RNH]&1;
#if 1 // Warning: Major hack here to work around a bug with arm9 core and devkitpro r17
    if(!arm9reg.flags[ARMFLAG_T] && (arm9reg.r[15] == 0x0200026A)) {
		arm9reg.r[15] += 2;
	}
#endif
    ARM9updateCPSR();

    return 3;
}

OPCODE Thumb9opBLsetup()
{
    arm9reg.tmp2=arm9reg.curop&0x07FF;
    arm9reg.tmp1=(arm9reg.tmp2&0x0400)?
                 (0xFFFFF800|arm9reg.tmp2):
		 (0x00000000|arm9reg.tmp2);
    arm9reg.r[14]=arm9reg.r[15]+((signed)arm9reg.tmp1)*4096+2;
    return 4;
}

OPCODE Thumb9opBLoff()
{
    arm9reg.tmp2=arm9reg.curop&0x07FF;
    arm9reg.tmp1=arm9reg.r[14];
    arm9reg.r[14]=arm9reg.r[15]|1;
    arm9reg.r[15]=arm9reg.tmp1+arm9reg.tmp2*2;
    return 4;
}

#define Thumb9opLDMIA(rg) \
    int a; \
    arm9reg.tmp1=arm9reg.r[(rg)]; \
    arm9reg.r[(rg)]+=ARM9SideSum(arm9reg.curop&0x00FF)*4; \
    for(a=0;a<=7;a++) \
    { \
        if(arm9reg.curop&(1<<a)) \
        { \
            arm9reg.r[a]=MMUMainrdW(0,arm9reg.tmp1); \
            arm9reg.tmp1+=4; \
        } \
    }

#define Thumb9opSTMIA(rg) \
    int a; \
    arm9reg.tmp1=arm9reg.r[(rg)]; \
    arm9reg.r[(rg)]+=ARM9SideSum(arm9reg.curop&0x00FF)*4; \
    for(a=0;a<=7;a++) \
    { \
        if(arm9reg.curop&(1<<a)) \
        { \
            MMUMainwrW(0,arm9reg.tmp1,arm9reg.r[a]); \
            arm9reg.tmp1+=4; \
        } \
    }

OPCODE Thumb9opPUSH()
{
    int a;
    arm9reg.tmp2=0;
    arm9reg.tmp1=arm9reg.r[13]-ARM9SideSum(arm9reg.curop&0x00FF)*4;
    arm9reg.r[13]-=ARM9SideSum(arm9reg.curop&0x00ff)*4;
    for(a=0;a<=7;a++)
    {
        if(arm9reg.curop&(1<<a))
        {
            MMUMainwrW(0,arm9reg.tmp1,arm9reg.r[a]);
            arm9reg.tmp1+=4;
        }
    }
    return 1;
}

OPCODE Thumb9opPUSHlr()
{
    int a;
    arm9reg.tmp1=arm9reg.r[13]-ARM9SideSum(arm9reg.curop&0x01FF)*4;
    arm9reg.r[13]-=ARM9SideSum(arm9reg.curop&0x01ff)*4;
    for(a=0;a<=7;a++)
    {
        if(arm9reg.curop&(1<<a))
        {
            MMUMainwrW(0,arm9reg.tmp1,arm9reg.r[a]);
            arm9reg.tmp1+=4;
        }
    }
    if(arm9reg.curop&0x0100)
        MMUMainwrW(0,arm9reg.tmp1,arm9reg.r[14]);
    return 1;
}

OPCODE Thumb9opPOP()
{
    int a;
    arm9reg.tmp1=arm9reg.r[13];
    arm9reg.r[13]+=ARM9SideSum(arm9reg.curop&0x00FF)*4;
    for(a=0;a<=7;a++)
    {
        if(arm9reg.curop&(1<<a))
        {
            arm9reg.r[a]=MMUMainrdW(0,arm9reg.tmp1);
            arm9reg.tmp1+=4;
        }
    }
    return 1;
}

OPCODE Thumb9opPOPpc()
{
    int a;
    arm9reg.tmp1=arm9reg.r[13];
    arm9reg.r[13]+=ARM9SideSum(arm9reg.curop&0x01FF)*4;
    for(a=0;a<=7;a++)
    {
        if(arm9reg.curop&(1<<a))
        {
            arm9reg.r[a]=MMUMainrdW(0,arm9reg.tmp1);
            arm9reg.tmp1+=4;
        }
    }
    if(arm9reg.curop&0x0100)
    {
        arm9reg.r[15]=MMUMainrdW(0,arm9reg.tmp1)&0xFFFFFFFE;
        //ARM5: ThumbMode=r15&1
    }
    return 1;
}

OPCODE Thumb9opBKPT() {return 1;}
OPCODE Thumb9opSWI()
{
    arm9reg.curop<<=16; 
	return ARM9opSWI();
}

OPCODE Thumb9opLDMIAr0() {Thumb9opLDMIA(0); return 3; }
OPCODE Thumb9opLDMIAr1() {Thumb9opLDMIA(1); return 3; }
OPCODE Thumb9opLDMIAr2() {Thumb9opLDMIA(2); return 3; }
OPCODE Thumb9opLDMIAr3() {Thumb9opLDMIA(3); return 3; }
OPCODE Thumb9opLDMIAr4() {Thumb9opLDMIA(4); return 3; }
OPCODE Thumb9opLDMIAr5() {Thumb9opLDMIA(5); return 3; }
OPCODE Thumb9opLDMIAr6() {Thumb9opLDMIA(6); return 3; }
OPCODE Thumb9opLDMIAr7() {Thumb9opLDMIA(7); return 3; }
OPCODE Thumb9opSTMIAr0() {Thumb9opSTMIA(0); return 2; }
OPCODE Thumb9opSTMIAr1() {Thumb9opSTMIA(1); return 2; }
OPCODE Thumb9opSTMIAr2() {Thumb9opSTMIA(2); return 2; }
OPCODE Thumb9opSTMIAr3() {Thumb9opSTMIA(3); return 2; }
OPCODE Thumb9opSTMIAr4() {Thumb9opSTMIA(4); return 2; }
OPCODE Thumb9opSTMIAr5() {Thumb9opSTMIA(5); return 2; }
OPCODE Thumb9opSTMIAr6() {Thumb9opSTMIA(6); return 2; }
OPCODE Thumb9opSTMIAr7() {Thumb9opSTMIA(7); return 2; }

