/**************************************************************************
* DSemu: Initialisation and running loop (main.c)                         *
* Released under the terms of the BSD Public Licence                      *
* Imran Nazar (tf@oopsilon.com), 2004                                     *
**************************************************************************/

#include <windows.h>
#include <commctrl.h>
#include <stdio.h>
#include "plugin.h"
#include "err.h"
#include "resource.h"
#include "emu.h"
#include "win.h"

EMUVTBL *emu=NULL;
LOGVTBL *logvt=NULL;

int ParseCommandLine(char *cmdLine, char **argv)
{
    char *ptr=cmdLine,*ptr1; int argc=0,len; 
    if(!strlen(cmdLine)) return 0;

    do
    {
        argc++; if(argc>1) ptr++;
	if(argv)
	{
	    ptr1=strpbrk(ptr," ");
	    if(ptr1) len=ptr1-ptr; else len=strlen(ptr);
	    argv[argc]=(char*)malloc(len+4); argv[argc][len]=0;
	    strncpy(argv[argc],ptr,len);
        }
    } while(ptr=strpbrk(ptr," \0"));
    return argc+1;
}

int APIENTRY WinMain(HINSTANCE hInst,
                     HINSTANCE hPrevInst,
                     LPSTR lpCmdLine,
                     int nCmdShow)
{
    MSG msg;
    HWND hWnd;
    LARGE_INTEGER qpfreq, qpcnt1={0}, qpcnt2={0};

    int a=0; int done=0;
    DWORD t1,t2; DWORD ttotal=0;

    int argc; char **argv;

    argc=ParseCommandLine(lpCmdLine,NULL);
    argv=(char**)malloc((argc+1)*sizeof(char*));
    ParseCommandLine(lpCmdLine,argv);

    pluginInit();
    logvt=(LOGVTBL*)pluginLoad("log");
    logvt->init();

    QueryPerformanceFrequency(&qpfreq);

    hWnd = WinInit(hInst, nCmdShow);
    if(!hWnd) return FALSE;

    if(argc==2) 
    {
        if(!strncmp((argv[1]+strlen(argv[1])-3),"nds",3))
            SendMessage(hWnd, WM_COMMAND, ID_MENU_FILE_OPENDS, (LPARAM)argv[1]);
        else
            SendMessage(hWnd, WM_COMMAND, ID_MENU_FILE_OPENGBA, (LPARAM)argv[1]);
    }

    while(!done)
    {
		if(emu && emu->running) {
			while(!done && PeekMessage(&msg, 0, 0, 0, PM_REMOVE)) {
		        if(msg.message == WM_QUIT)
				{
					if(emu) emu->fini();
						done=1;
				}
		        else
		        {
					if(!TranslateAccelerator(hWnd, accelTable, &msg))
					{
						TranslateMessage(&msg);
						DispatchMessage(&msg);
					}
				}
				
			}
		}
		else {
			GetMessage(&msg, 0, 0, 0);
	        if(msg.message == WM_QUIT)
			{
				if(emu) emu->fini();
					done=1;
			}
	        else
	        {
				if(!TranslateAccelerator(hWnd, accelTable, &msg))
				{
					TranslateMessage(&msg);
					DispatchMessage(&msg);
				}
			}
		}
				

		if(emu && emu->running)
		{
            //Credit-where-credit's-due---mic
            if(emu->fixfps)
            {
                QueryPerformanceCounter(&qpcnt2);
	        while (((qpcnt2.QuadPart-qpcnt1.QuadPart)<<16)/qpfreq.QuadPart < 1092)
	        {
                    QueryPerformanceCounter(&qpcnt2);
                }
                qpcnt1 = qpcnt2;
            }

		    if(!a) { 
				timeBeginPeriod(1); 
				t1=timeGetTime(); 
			}
		    emu->frame(); a++;
	   	    if(a==10)
   			{
                t2=timeGetTime(); 
				timeEndPeriod(1); 
				a=0;
                ttotal=(t2-t1);
                SendMessage(hWnd, WM_STATUSFPS, ttotal, 0);
            }
        }
        else {
			Sleep(5);
		}
    }

    logvt->fini(); pluginUnload("log");
    return 0;
}

/*** EOF:main.c **********************************************************/

