/**************************************************************************
* DSemu: I/O register access control and position constants (ioreg.h)     *
* Released under the terms of the BSD Public Licence                      *
* Imran Nazar (tf@oopsilon.com), 2004                                     *
**************************************************************************/

#ifndef __IOREG_H_
#define __IOREG_H_

#include "defs.h"

typedef struct {
    union {
        u16 data;
        u8 b[2];
    };
    u16 flags;
} IOREG;

extern IOREG GBAio[512];

#define REG_FLAG_R 1
#define REG_FLAG_W 2

#define REG_DISPCNT    0x000
#define REG_GREENSWAP  0x001
#define REG_DISPSTAT   0x002
#define REG_VCOUNT     0x003
#define REG_BG0CNT     0x004
#define REG_BG1CNT     0x005
#define REG_BG2CNT     0x006
#define REG_BG3CNT     0x007
#define REG_BG0HOFS    0x008
#define REG_BG0VOFS    0x009
#define REG_BG1HOFS    0x00A
#define REG_BG1VOFS    0x00B
#define REG_BG2HOFS    0x00C
#define REG_BG2VOFS    0x00D
#define REG_BG3HOFS    0x00E
#define REG_BG3VOFS    0x00F
#define REG_BG2PA      0x010
#define REG_BG2PB      0x011
#define REG_BG2PC      0x012
#define REG_BG2PD      0x013
#define REG_BG2XL      0x014
#define REG_BG2XH      0x015
#define REG_BG2YL      0x016
#define REG_BG2YH      0x017
#define REG_BG3PA      0x018
#define REG_BG3PB      0x019
#define REG_BG3PC      0x01A
#define REG_BG3PD      0x01B
#define REG_BG3XL      0x01C
#define REG_BG3XH      0x01D
#define REG_BG3YL      0x01E
#define REG_BG3YH      0x01F
#define REG_WIN0H      0x020
#define REG_WIN1H      0x021
#define REG_WIN0V      0x022
#define REG_WIN1V      0x023
#define REG_WININ      0x024
#define REG_WINOUT     0x025
#define REG_MOSAIC     0x026
#define REG_BLDCNT     0x028
#define REG_BLDALPHA   0x029
#define REG_BLDY       0x02A

#define REG_DMA0SAD_L  0x058
#define REG_DMA0SAD_H  0x059
#define REG_DMA0DAD_L  0x05A
#define REG_DMA0DAD_H  0x05B
#define REG_DMA0CNT_L  0x05C
#define REG_DMA0CNT_H  0x05D
#define REG_DMA1SAD_L  0x05E
#define REG_DMA1SAD_H  0x05F
#define REG_DMA1DAD_L  0x060
#define REG_DMA1DAD_H  0x061
#define REG_DMA1CNT_L  0x062
#define REG_DMA1CNT_H  0x063
#define REG_DMA2SAD_L  0x064
#define REG_DMA2SAD_H  0x065
#define REG_DMA2DAD_L  0x066
#define REG_DMA2DAD_H  0x067
#define REG_DMA2CNT_L  0x068
#define REG_DMA2CNT_H  0x069
#define REG_DMA3SAD_L  0x06A
#define REG_DMA3SAD_H  0x06B
#define REG_DMA3DAD_L  0x06C
#define REG_DMA3DAD_H  0x06D
#define REG_DMA3CNT_L  0x06E
#define REG_DMA3CNT_H  0x06F

#define REG_TIME       0x080 //( (vu16*)0x4000100)
#define REG_TM0D       0x080 //(*(vu16*)0x4000100)
#define REG_TM0CNT     0x081 //(*(vu16*)0x4000102)
#define REG_TM1D       0x082 //(*(vu16*)0x4000104)
#define REG_TM1CNT     0x083 //(*(vu16*)0x4000106)
#define REG_TM2D       0x084 //(*(vu16*)0x4000108)
#define REG_TM2CNT     0x085 //(*(vu16*)0x400010A)
#define REG_TM3D       0x086 //(*(vu16*)0x400010C)
#define REG_TM3CNT     0x087 //(*(vu16*)0x400010E)

#define REG_KEYINPUT   0x098
#define REG_KEYCNT     0x099

#define REG_IE         0x100
#define REG_IF         0x101
#define REG_IME        0x104

#define REG(x) GBAio[REG_ ## x].data

#endif//__IOREG_H_

/*** EOF:ioreg.h *********************************************************/

