/**************************************************************************
* DSemu: Memory management function definitions (mmu.h)                   *
* Released under the terms of the BSD Public Licence                      *
* Imran Nazar (tf@oopsilon.com), 2004                                     *
**************************************************************************/

#ifndef __MMUMain_H_
#define __MMUMain_H_

#include "defs.h"
#include "cache.h"

int MMUMaininit(char*);
int MMUMainreset();
void MMUMainfini();

u8  MMUMainrdB(u32, u32);
u16 MMUMainrdH(u32, u32);
u32 MMUMainrdW(u32, u32);
RAMWORD MMUMainrdS(u32, u32);

void MMUMainwrB(u32, u32, u8 );
void MMUMainwrH(u32, u32, u16);
void MMUMainwrW(u32, u32, u32);
void MMUMainwrS(u32, u32, RAMWORD);

extern OPCODE ARM9condAL(), ARM9opUNL();
extern RAMWORD ARM9opDecode(u32);

#endif//__MMUMain_H_

/*** EOF:mmu.h ***********************************************************/

