/**************************************************************************
* DSemu: Direct Memory Access operation (dma.c)                           *
* Released under the terms of the BSD Public Licence                      *
* Imran Nazar (tf@oopsilon.com), 2004                                     *
**************************************************************************/

#include "dma.h"
#include "dsmmumain.h"
#include "dsioreg.h"
#include "vtbl.h"

extern u8* VRAMmap[553];

void DMA3()
{
//    char str[512];
    u32 src, dest, size, a, w; u16 h,hl,hh; int wordsize, srcinc, destinc;

    hl=REG(ARMX_REG,DMA3SAD_L); hh=REG(ARMX_REG,DMA3SAD_H); src =hl+(hh<<16);
    hl=REG(ARMX_REG,DMA3DAD_L); hh=REG(ARMX_REG,DMA3DAD_H); dest=hl+(hh<<16);
    if(REG(ARMX_REG,DMA3CNT_H)&DMA_TYPEMSK) wordsize=4; else wordsize=2;
    size=REG(ARMX_REG,DMA3CNT_L)*wordsize;
	// TODO: FIX this workaround for bug in setting DMA register size.
	if(size == 0)
		size = 256*256*wordsize;
#if 0
    sprintf(str,"DMA3: %04Xh bytes in %d-byte units from %08X to %08X.",size,wordsize,src,dest);
    logvt->append(str);
#endif
    switch(REG(ARMX_REG,DMA3CNT_H)&DMA_SRCMSK)
    {
        case DMA_SRCINC: srcinc=wordsize; break;
        case DMA_SRCDEC: srcinc=-wordsize; break;
        case DMA_SRCFIX: srcinc=0; break;
        case DMA_SRCINR: srcinc=wordsize; break;
    }
    switch(REG(ARMX_REG,DMA3CNT_H)&DMA_DESTMSK)
    {
        case DMA_DESTINC: destinc=wordsize; break;
        case DMA_DESTDEC: destinc=-wordsize; break;
        case DMA_DESTFIX: destinc=0; break;
        case DMA_DESTINR: destinc=wordsize; break;
    }
//    sprintf(str,"DMA3: srcinc=%d, destinc=%d", srcinc, destinc);
//    logvt->append(str);
    if(wordsize==2)
    {
		if(src >= 0x06000000 && src < 0x07000000 &&
			dest>= 0x06000000 && dest< 0x07000000 &&
			destinc==2)
		{
			// TODO: Check that this is safe...
			u8* true_src = VRAMmap[(src&0x00FFFFFF)/0x4000];
			u8* true_dest = VRAMmap[(dest&0x00FFFFFF)/0x4000];
			memcpy(true_dest, true_src, size);				
		}
		else
		{
			for(a=0;a<size;a+=2)
			{
	            h=MMUMainrdH(0,src); MMUMainwrH(0,dest,h);
				src+=srcinc; dest+=destinc;
			}
		}
    } else {
        for(a=0;a<size;a+=4)
        {
            w=MMUMainrdW(0,src); MMUMainwrW(0,dest,w);
            src+=srcinc; dest+=destinc;
	    }
    }
}

void DMA3log()
{
}

void DMAcheck(u16 activate)
{
    static u16 oldcnt3=0;
    if(REG(ARMX_REG,DMA3CNT_H)!=oldcnt3)
    {
        oldcnt3=REG(ARMX_REG,DMA3CNT_H);
        if(oldcnt3&DMA_EN)
        {
	    if(activate==(oldcnt3&DMA_TIMEMSK)) DMA3();
            REG(ARMX_REG,DMA3CNT_H)&=0x7FFF;
            if(oldcnt3&DMA_REPEAT) REG(ARMX_REG,DMA3CNT_H)|=DMA_EN;
        }
    }
}

/*** EOF:dma.c ***********************************************************/

