/**************************************************************************
* DSemu: Computationnal Accelerators: divide and square root (dsaccelerators.h)*
* Released under the terms of the BSD Public Licence                      *
* Crazyjul                      , 2005                                    *
**************************************************************************/

#ifndef __DS_ACCELERATORS__
#define __DS_ACCELERATORS__

void initialize_accelerators_registers();
void UpdateAcceleratorsRegisters(u8 cycle_count);

u8 do_accelerators_read_byte(int cpu, u32 addr);
u16 do_accelerators_read_half(int cpu, u32 addr);
u32 do_accelerators_read_word(int cpu, u32 addr);
void do_accelerators_write_byte(int cpu, u32 addr, u8 value);
void do_accelerators_write_half(int cpu, u32 addr, u16 value);
void do_accelerators_write_word(int cpu, u32 addr, u32 value);

#endif