/**************************************************************************
* DSemu: ARM9 core definitions and opcode pointer table (arm9func.h)      *
* Released under the terms of the BSD Public Licence                      *
* Imran Nazar (tf@oopsilon.com), 2004                                     *
**************************************************************************/

#ifndef __ARM9FUNC_H_
#define __ARM9FUNC_H_

#include "defs.h"
#include "cache.h"

int ARM9exec();
int ARM9execfor(int);
void ARM9dbgOut();
void ARM9modesw(int,int);
void ARM9status(int,int);
void ARM9updateCPSR(), ARM9splitCPSR();
int ARM9init(char*,u32*);
void ARM9fini();
int ARM9reset();
__int64 ARM9getClock();
void ARM9addClock(int);
void ARM9irq();

extern int MMUinit();
extern void MMUfini();
extern void MMUreg(int,void*);
extern void MMUunreg(int);
extern u8  MMUrdB(u32, u32);
extern u16 MMUrdH(u32, u32);
extern u32 MMUrdW(u32, u32);
extern RAMWORD MMUrdS(u32, u32);
extern void MMUwrB(u32, u32, u8 );
extern void MMUwrH(u32, u32, u16);
extern void MMUwrW(u32, u32, u32);
extern void MMUwrS(u32, u32, RAMWORD);

extern char *ARM9DASM(u32);

char ARM9modes[7][4]={"USR","SYS","FIQ","IRQ","SUP","ABT","UND"};
int ARM9modetocpsr[7]={ARMS_M_USR,ARMS_M_SYS,ARMS_M_FIQ,ARMS_M_IRQ,
                      ARMS_M_SVC,ARMS_M_ABT,ARMS_M_UND};
int ARM9cpsrtomode[16]={0,2,3,4,-1,-1,-1,5,-1,-1,-1,6,-1,-1,-1,1};

int ARM9condEQ(), ARM9condNE(), ARM9condCS(), ARM9condCC();
int ARM9condMI(), ARM9condPL(), ARM9condVS(), ARM9condVC();
int ARM9condHI(), ARM9condLS(), ARM9condGE(), ARM9condLT();
int ARM9condGT(), ARM9condLE(), ARM9condAL(), ARM9condNV();

static intfptr ARM9cond[]={
  ARM9condEQ, ARM9condNE, ARM9condCS, ARM9condCC,
  ARM9condMI, ARM9condPL, ARM9condVS, ARM9condVC,
  ARM9condHI, ARM9condLS, ARM9condGE, ARM9condLT,
  ARM9condGT, ARM9condLE, ARM9condAL, ARM9condNV,
};

//---UNdefined/predictable-------------------------------------------------

OPCODE ARM9opUNP();
OPCODE ARM9opUND();
OPCODE ARM9opUNI();
OPCODE ARM9opUNL();
RAMWORD ARM9opDecode(u32);

//---Uberdecoders----------------------------------------------------------

OPCODE ARM9opDPS0();      /* 0 - Data processing Shifted */
OPCODE ARM9opDPS1();      /* 1 - Data processing Shifted */
OPCODE ARM9opDPI0();      /* 2 - Data processing Immediate */
OPCODE ARM9opDPI1();      /* 3 - Data processing Immediate */
OPCODE ARM9opLSIpt();     /* 4 - Load/store Immediate Post-indexed */
OPCODE ARM9opLSIof();     /* 5 - Load/store Immediate Preidx/Offset */
OPCODE ARM9opLSRpt();     /* 6 - Load/store Register Post-indexed */
OPCODE ARM9opLSRof();     /* 7 - Load/store Register Preidx/Offset */
OPCODE ARM9opLSMf();      /* 8 - Load/store Multiple Load:Full */
OPCODE ARM9opLSMe();      /* 9 - Load/store Multiple Load:Empty */
OPCODE ARM9opB();         /* A - Branch */
OPCODE ARM9opBL();        /* B - Branch+Link */
OPCODE ARM9opLSCof();     /* C - Load/store Copro Preidx/Offset */
OPCODE ARM9opLSCpt();     /* D - Load/store Copro Post-indexed */
OPCODE ARM9opCP();        /* E - Copro Data/Reg handling */
OPCODE ARM9opSWI();       /* F - Software Interrupt */

//---Branch (with Link)----------------------------------------------------

OPCODE ARM9opB(), ARM9opBL();

OPCODE ARM9opBX();
OPCODE ARM9opBLX(), ARM9opBLXr();

//---DP (DataProcessing); LsL/LsR/AsR/RoR; Immediate/Register--------------

OPCODE ARM9opANDlli(), ARM9opANDllr();
OPCODE ARM9opANDlri(), ARM9opANDlrr();
OPCODE ARM9opANDari(), ARM9opANDarr();
OPCODE ARM9opANDrri(), ARM9opANDrrr();
OPCODE ARM9opANDimm();

OPCODE ARM9opEORlli(), ARM9opEORllr();
OPCODE ARM9opEORlri(), ARM9opEORlrr();
OPCODE ARM9opEORari(), ARM9opEORarr();
OPCODE ARM9opEORrri(), ARM9opEORrrr();
OPCODE ARM9opEORimm();

OPCODE ARM9opSUBlli(), ARM9opSUBllr();
OPCODE ARM9opSUBlri(), ARM9opSUBlrr();
OPCODE ARM9opSUBari(), ARM9opSUBarr();
OPCODE ARM9opSUBrri(), ARM9opSUBrrr();
OPCODE ARM9opSUBimm();

OPCODE ARM9opRSBlli(), ARM9opRSBllr();
OPCODE ARM9opRSBlri(), ARM9opRSBlrr();
OPCODE ARM9opRSBari(), ARM9opRSBarr();
OPCODE ARM9opRSBrri(), ARM9opRSBrrr();
OPCODE ARM9opRSBimm();

OPCODE ARM9opADDlli(), ARM9opADDllr();
OPCODE ARM9opADDlri(), ARM9opADDlrr();
OPCODE ARM9opADDari(), ARM9opADDarr();
OPCODE ARM9opADDrri(), ARM9opADDrrr();
OPCODE ARM9opADDimm();

OPCODE ARM9opADClli(), ARM9opADCllr();
OPCODE ARM9opADClri(), ARM9opADClrr();
OPCODE ARM9opADCari(), ARM9opADCarr();
OPCODE ARM9opADCrri(), ARM9opADCrrr();
OPCODE ARM9opADCimm();

OPCODE ARM9opSBClli(), ARM9opSBCllr();
OPCODE ARM9opSBClri(), ARM9opSBClrr();
OPCODE ARM9opSBCari(), ARM9opSBCarr();
OPCODE ARM9opSBCrri(), ARM9opSBCrrr();
OPCODE ARM9opSBCimm();

OPCODE ARM9opRSClli(), ARM9opRSCllr();
OPCODE ARM9opRSClri(), ARM9opRSClrr();
OPCODE ARM9opRSCari(), ARM9opRSCarr();
OPCODE ARM9opRSCrri(), ARM9opRSCrrr();
OPCODE ARM9opRSCimm();

OPCODE ARM9opORRlli(), ARM9opORRllr();
OPCODE ARM9opORRlri(), ARM9opORRlrr();
OPCODE ARM9opORRari(), ARM9opORRarr();
OPCODE ARM9opORRrri(), ARM9opORRrrr();
OPCODE ARM9opORRimm();

OPCODE ARM9opMOVlli(), ARM9opMOVllr();
OPCODE ARM9opMOVlri(), ARM9opMOVlrr();
OPCODE ARM9opMOVari(), ARM9opMOVarr();
OPCODE ARM9opMOVrri(), ARM9opMOVrrr();
OPCODE ARM9opMOVimm();

OPCODE ARM9opBIClli(), ARM9opBICllr();
OPCODE ARM9opBIClri(), ARM9opBIClrr();
OPCODE ARM9opBICari(), ARM9opBICarr();
OPCODE ARM9opBICrri(), ARM9opBICrrr();
OPCODE ARM9opBICimm();

OPCODE ARM9opMVNlli(), ARM9opMVNllr();
OPCODE ARM9opMVNlri(), ARM9opMVNlrr();
OPCODE ARM9opMVNari(), ARM9opMVNarr();
OPCODE ARM9opMVNrri(), ARM9opMVNrrr();
OPCODE ARM9opMVNimm();

OPCODE ARM9opANDSlli(), ARM9opANDSllr();
OPCODE ARM9opANDSlri(), ARM9opANDSlrr();
OPCODE ARM9opANDSari(), ARM9opANDSarr();
OPCODE ARM9opANDSrri(), ARM9opANDSrrr();
OPCODE ARM9opANDSimm();

OPCODE ARM9opEORSlli(), ARM9opEORSllr();
OPCODE ARM9opEORSlri(), ARM9opEORSlrr();
OPCODE ARM9opEORSari(), ARM9opEORSarr();
OPCODE ARM9opEORSrri(), ARM9opEORSrrr();
OPCODE ARM9opEORSimm();

OPCODE ARM9opSUBSlli(), ARM9opSUBSllr();
OPCODE ARM9opSUBSlri(), ARM9opSUBSlrr();
OPCODE ARM9opSUBSari(), ARM9opSUBSarr();
OPCODE ARM9opSUBSrri(), ARM9opSUBSrrr();
OPCODE ARM9opSUBSimm();

OPCODE ARM9opRSBSlli(), ARM9opRSBSllr();
OPCODE ARM9opRSBSlri(), ARM9opRSBSlrr();
OPCODE ARM9opRSBSari(), ARM9opRSBSarr();
OPCODE ARM9opRSBSrri(), ARM9opRSBSrrr();
OPCODE ARM9opRSBSimm();

OPCODE ARM9opADDSlli(), ARM9opADDSllr();
OPCODE ARM9opADDSlri(), ARM9opADDSlrr();
OPCODE ARM9opADDSari(), ARM9opADDSarr();
OPCODE ARM9opADDSrri(), ARM9opADDSrrr();
OPCODE ARM9opADDSimm();

OPCODE ARM9opADCSlli(), ARM9opADCSllr();
OPCODE ARM9opADCSlri(), ARM9opADCSlrr();
OPCODE ARM9opADCSari(), ARM9opADCSarr();
OPCODE ARM9opADCSrri(), ARM9opADCSrrr();
OPCODE ARM9opADCSimm();

OPCODE ARM9opSBCSlli(), ARM9opSBCSllr();
OPCODE ARM9opSBCSlri(), ARM9opSBCSlrr();
OPCODE ARM9opSBCSari(), ARM9opSBCSarr();
OPCODE ARM9opSBCSrri(), ARM9opSBCSrrr();
OPCODE ARM9opSBCSimm();

OPCODE ARM9opRSCSlli(), ARM9opRSCSllr();
OPCODE ARM9opRSCSlri(), ARM9opRSCSlrr();
OPCODE ARM9opRSCSari(), ARM9opRSCSarr();
OPCODE ARM9opRSCSrri(), ARM9opRSCSrrr();
OPCODE ARM9opRSCSimm();

OPCODE ARM9opTSTSlli(), ARM9opTSTSllr();
OPCODE ARM9opTSTSlri(), ARM9opTSTSlrr();
OPCODE ARM9opTSTSari(), ARM9opTSTSarr();
OPCODE ARM9opTSTSrri(), ARM9opTSTSrrr();
OPCODE ARM9opTSTSimm();

OPCODE ARM9opTEQSlli(), ARM9opTEQSllr();
OPCODE ARM9opTEQSlri(), ARM9opTEQSlrr();
OPCODE ARM9opTEQSari(), ARM9opTEQSarr();
OPCODE ARM9opTEQSrri(), ARM9opTEQSrrr();
OPCODE ARM9opTEQSimm();

OPCODE ARM9opCMPSlli(), ARM9opCMPSllr();
OPCODE ARM9opCMPSlri(), ARM9opCMPSlrr();
OPCODE ARM9opCMPSari(), ARM9opCMPSarr();
OPCODE ARM9opCMPSrri(), ARM9opCMPSrrr();
OPCODE ARM9opCMPSimm();

OPCODE ARM9opCMNSlli(), ARM9opCMNSllr();
OPCODE ARM9opCMNSlri(), ARM9opCMNSlrr();
OPCODE ARM9opCMNSari(), ARM9opCMNSarr();
OPCODE ARM9opCMNSrri(), ARM9opCMNSrrr();
OPCODE ARM9opCMNSimm();

OPCODE ARM9opORRSlli(), ARM9opORRSllr();
OPCODE ARM9opORRSlri(), ARM9opORRSlrr();
OPCODE ARM9opORRSari(), ARM9opORRSarr();
OPCODE ARM9opORRSrri(), ARM9opORRSrrr();
OPCODE ARM9opORRSimm();

OPCODE ARM9opMOVSlli(), ARM9opMOVSllr();
OPCODE ARM9opMOVSlri(), ARM9opMOVSlrr();
OPCODE ARM9opMOVSari(), ARM9opMOVSarr();
OPCODE ARM9opMOVSrri(), ARM9opMOVSrrr();
OPCODE ARM9opMOVSimm();

OPCODE ARM9opBICSlli(), ARM9opBICSllr();
OPCODE ARM9opBICSlri(), ARM9opBICSlrr();
OPCODE ARM9opBICSari(), ARM9opBICSarr();
OPCODE ARM9opBICSrri(), ARM9opBICSrrr();
OPCODE ARM9opBICSimm();

OPCODE ARM9opMVNSlli(), ARM9opMVNSllr();
OPCODE ARM9opMVNSlri(), ARM9opMVNSlrr();
OPCODE ARM9opMVNSari(), ARM9opMVNSarr();
OPCODE ARM9opMVNSrri(), ARM9opMVNSrrr();
OPCODE ARM9opMVNSimm();

//---AR (ARithmetic); REGister/IMMediate-----------------------------------

OPCODE ARM9opMUL(), ARM9opMLA();
OPCODE ARM9opUMULL(), ARM9opUMLAL(), ARM9opSMULL(), ARM9opSMLAL();

OPCODE ARM9opMULS(), ARM9opMLAS();
OPCODE ARM9opUMULLS(), ARM9opUMLALS(), ARM9opSMULLS(), ARM9opSMLALS();

//---Move Register From Status; Imm/Reg; Cpsr/Spsr-------------------------

OPCODE ARM9opMRSrc(), ARM9opMRSrs();

//---Move Status from Register; Cpsr/Spsr----------------------------------

OPCODE ARM9opMSRrc(), ARM9opMSRrs();
OPCODE ARM9opMSRic(), ARM9opMSRis();

//---LS (Load/Store); PReidx/OFfset/PsTidx; Imm/Reg; Minus/Plus; (Shift)---

OPCODE ARM9opLDRptim(), ARM9opLDRofim(), ARM9opLDRprim();
OPCODE ARM9opLDRptip(), ARM9opLDRofip(), ARM9opLDRprip();
OPCODE ARM9opLDRptrm(), ARM9opLDRofrm(), ARM9opLDRprrm();
OPCODE ARM9opLDRptrp(), ARM9opLDRofrp(), ARM9opLDRprrp();

OPCODE ARM9opSTRptim(), ARM9opSTRofim(), ARM9opSTRprim();
OPCODE ARM9opSTRptip(), ARM9opSTRofip(), ARM9opSTRprip();
OPCODE ARM9opSTRptrm(), ARM9opSTRofrm(), ARM9opSTRprrm();
OPCODE ARM9opSTRptrp(), ARM9opSTRofrp(), ARM9opSTRprrp();

OPCODE ARM9opLDRBptim(), ARM9opLDRBofim(), ARM9opLDRBprim();
OPCODE ARM9opLDRBptip(), ARM9opLDRBofip(), ARM9opLDRBprip();
OPCODE ARM9opLDRBptrm(), ARM9opLDRBofrm(), ARM9opLDRBprrm();
OPCODE ARM9opLDRBptrp(), ARM9opLDRBofrp(), ARM9opLDRBprrp();

OPCODE ARM9opSTRBptim(), ARM9opSTRBofim(), ARM9opSTRBprim();
OPCODE ARM9opSTRBptip(), ARM9opSTRBofip(), ARM9opSTRBprip();
OPCODE ARM9opSTRBptrm(), ARM9opSTRBofrm(), ARM9opSTRBprrm();
OPCODE ARM9opSTRBptrp(), ARM9opSTRBofrp(), ARM9opSTRBprrp();

OPCODE ARM9opLDRHptim(), ARM9opLDRHofim(), ARM9opLDRHprim();
OPCODE ARM9opLDRHptip(), ARM9opLDRHofip(), ARM9opLDRHprip();
OPCODE ARM9opLDRHptrm(), ARM9opLDRHofrm(), ARM9opLDRHprrm();
OPCODE ARM9opLDRHptrp(), ARM9opLDRHofrp(), ARM9opLDRHprrp();

OPCODE ARM9opSTRHptim(), ARM9opSTRHofim(), ARM9opSTRHprim();
OPCODE ARM9opSTRHptip(), ARM9opSTRHofip(), ARM9opSTRHprip();
OPCODE ARM9opSTRHptrm(), ARM9opSTRHofrm(), ARM9opSTRHprrm();
OPCODE ARM9opSTRHptrp(), ARM9opSTRHofrp(), ARM9opSTRHprrp();

OPCODE ARM9opLDRTptim(), ARM9opLDRTofim(), ARM9opLDRTprim();
OPCODE ARM9opLDRTptip(), ARM9opLDRTofip(), ARM9opLDRTprip();
OPCODE ARM9opLDRTptrm(), ARM9opLDRTofrm(), ARM9opLDRTprrm();
OPCODE ARM9opLDRTptrp(), ARM9opLDRTofrp(), ARM9opLDRTprrp();

OPCODE ARM9opSTRTptim(), ARM9opSTRTofim(), ARM9opSTRTprim();
OPCODE ARM9opSTRTptip(), ARM9opSTRTofip(), ARM9opSTRTprip();
OPCODE ARM9opSTRTptrm(), ARM9opSTRTofrm(), ARM9opSTRTprrm();
OPCODE ARM9opSTRTptrp(), ARM9opSTRTofrp(), ARM9opSTRTprrp();

OPCODE ARM9opLDRBTptim(), ARM9opLDRBTofim(), ARM9opLDRBTprim();
OPCODE ARM9opLDRBTptip(), ARM9opLDRBTofip(), ARM9opLDRBTprip();
OPCODE ARM9opLDRBTptrm(), ARM9opLDRBTofrm(), ARM9opLDRBTprrm();
OPCODE ARM9opLDRBTptrp(), ARM9opLDRBTofrp(), ARM9opLDRBTprrp();

OPCODE ARM9opSTRBTptim(), ARM9opSTRBTofim(), ARM9opSTRBTprim();
OPCODE ARM9opSTRBTptip(), ARM9opSTRBTofip(), ARM9opSTRBTprip();
OPCODE ARM9opSTRBTptrm(), ARM9opSTRBTofrm(), ARM9opSTRBTprrm();
OPCODE ARM9opSTRBTptrp(), ARM9opSTRBTofrp(), ARM9opSTRBTprrp();

OPCODE ARM9opLDRSHptim(), ARM9opLDRSHofim(), ARM9opLDRSHprim();
OPCODE ARM9opLDRSHptip(), ARM9opLDRSHofip(), ARM9opLDRSHprip();
OPCODE ARM9opLDRSHptrm(), ARM9opLDRSHofrm(), ARM9opLDRSHprrm();
OPCODE ARM9opLDRSHptrp(), ARM9opLDRSHofrp(), ARM9opLDRSHprrp();

OPCODE ARM9opLDRSBptim(), ARM9opLDRSBofim(), ARM9opLDRSBprim();
OPCODE ARM9opLDRSBptip(), ARM9opLDRSBofip(), ARM9opLDRSBprip();
OPCODE ARM9opLDRSBptrm(), ARM9opLDRSBofrm(), ARM9opLDRSBprrm();
OPCODE ARM9opLDRSBptrp(), ARM9opLDRSBofrp(), ARM9opLDRSBprrp();

OPCODE ARM9opLDRptrmll(), ARM9opLDRofrmll(), ARM9opLDRprrmll();
OPCODE ARM9opLDRptrpll(), ARM9opLDRofrpll(), ARM9opLDRprrpll();
OPCODE ARM9opLDRptrmlr(), ARM9opLDRofrmlr(), ARM9opLDRprrmlr();
OPCODE ARM9opLDRptrplr(), ARM9opLDRofrplr(), ARM9opLDRprrplr();
OPCODE ARM9opLDRptrmar(), ARM9opLDRofrmar(), ARM9opLDRprrmar();
OPCODE ARM9opLDRptrpar(), ARM9opLDRofrpar(), ARM9opLDRprrpar();
OPCODE ARM9opLDRptrmrr(), ARM9opLDRofrmrr(), ARM9opLDRprrmrr();
OPCODE ARM9opLDRptrprr(), ARM9opLDRofrprr(), ARM9opLDRprrprr();

OPCODE ARM9opSTRptrmll(), ARM9opSTRofrmll(), ARM9opSTRprrmll();
OPCODE ARM9opSTRptrpll(), ARM9opSTRofrpll(), ARM9opSTRprrpll();
OPCODE ARM9opSTRptrmlr(), ARM9opSTRofrmlr(), ARM9opSTRprrmlr();
OPCODE ARM9opSTRptrplr(), ARM9opSTRofrplr(), ARM9opSTRprrplr();
OPCODE ARM9opSTRptrmar(), ARM9opSTRofrmar(), ARM9opSTRprrmar();
OPCODE ARM9opSTRptrpar(), ARM9opSTRofrpar(), ARM9opSTRprrpar();
OPCODE ARM9opSTRptrmrr(), ARM9opSTRofrmrr(), ARM9opSTRprrmrr();
OPCODE ARM9opSTRptrprr(), ARM9opSTRofrprr(), ARM9opSTRprrprr();

OPCODE ARM9opLDRBptrmll(), ARM9opLDRBofrmll(), ARM9opLDRBprrmll();
OPCODE ARM9opLDRBptrpll(), ARM9opLDRBofrpll(), ARM9opLDRBprrpll();
OPCODE ARM9opLDRBptrmlr(), ARM9opLDRBofrmlr(), ARM9opLDRBprrmlr();
OPCODE ARM9opLDRBptrplr(), ARM9opLDRBofrplr(), ARM9opLDRBprrplr();
OPCODE ARM9opLDRBptrmar(), ARM9opLDRBofrmar(), ARM9opLDRBprrmar();
OPCODE ARM9opLDRBptrpar(), ARM9opLDRBofrpar(), ARM9opLDRBprrpar();
OPCODE ARM9opLDRBptrmrr(), ARM9opLDRBofrmrr(), ARM9opLDRBprrmrr();
OPCODE ARM9opLDRBptrprr(), ARM9opLDRBofrprr(), ARM9opLDRBprrprr();

OPCODE ARM9opSTRBptrmll(), ARM9opSTRBofrmll(), ARM9opSTRBprrmll();
OPCODE ARM9opSTRBptrpll(), ARM9opSTRBofrpll(), ARM9opSTRBprrpll();
OPCODE ARM9opSTRBptrmlr(), ARM9opSTRBofrmlr(), ARM9opSTRBprrmlr();
OPCODE ARM9opSTRBptrplr(), ARM9opSTRBofrplr(), ARM9opSTRBprrplr();
OPCODE ARM9opSTRBptrmar(), ARM9opSTRBofrmar(), ARM9opSTRBprrmar();
OPCODE ARM9opSTRBptrpar(), ARM9opSTRBofrpar(), ARM9opSTRBprrpar();
OPCODE ARM9opSTRBptrmrr(), ARM9opSTRBofrmrr(), ARM9opSTRBprrmrr();
OPCODE ARM9opSTRBptrprr(), ARM9opSTRBofrprr(), ARM9opSTRBprrprr();

OPCODE ARM9opLDRTptrmll(), ARM9opLDRTofrmll(), ARM9opLDRTprrmll();
OPCODE ARM9opLDRTptrpll(), ARM9opLDRTofrpll(), ARM9opLDRTprrpll();
OPCODE ARM9opLDRTptrmlr(), ARM9opLDRTofrmlr(), ARM9opLDRTprrmlr();
OPCODE ARM9opLDRTptrplr(), ARM9opLDRTofrplr(), ARM9opLDRTprrplr();
OPCODE ARM9opLDRTptrmar(), ARM9opLDRTofrmar(), ARM9opLDRTprrmar();
OPCODE ARM9opLDRTptrpar(), ARM9opLDRTofrpar(), ARM9opLDRTprrpar();
OPCODE ARM9opLDRTptrmrr(), ARM9opLDRTofrmrr(), ARM9opLDRTprrmrr();
OPCODE ARM9opLDRTptrprr(), ARM9opLDRTofrprr(), ARM9opLDRTprrprr();

OPCODE ARM9opSTRTptrmll(), ARM9opSTRTofrmll(), ARM9opSTRTprrmll();
OPCODE ARM9opSTRTptrpll(), ARM9opSTRTofrpll(), ARM9opSTRTprrpll();
OPCODE ARM9opSTRTptrmlr(), ARM9opSTRTofrmlr(), ARM9opSTRTprrmlr();
OPCODE ARM9opSTRTptrplr(), ARM9opSTRTofrplr(), ARM9opSTRTprrplr();
OPCODE ARM9opSTRTptrmar(), ARM9opSTRTofrmar(), ARM9opSTRTprrmar();
OPCODE ARM9opSTRTptrpar(), ARM9opSTRTofrpar(), ARM9opSTRTprrpar();
OPCODE ARM9opSTRTptrmrr(), ARM9opSTRTofrmrr(), ARM9opSTRTprrmrr();
OPCODE ARM9opSTRTptrprr(), ARM9opSTRTofrprr(), ARM9opSTRTprrprr();

OPCODE ARM9opLDRBTptrmll(), ARM9opLDRBTofrmll(), ARM9opLDRBTprrmll();
OPCODE ARM9opLDRBTptrpll(), ARM9opLDRBTofrpll(), ARM9opLDRBTprrpll();
OPCODE ARM9opLDRBTptrmlr(), ARM9opLDRBTofrmlr(), ARM9opLDRBTprrmlr();
OPCODE ARM9opLDRBTptrplr(), ARM9opLDRBTofrplr(), ARM9opLDRBTprrplr();
OPCODE ARM9opLDRBTptrmar(), ARM9opLDRBTofrmar(), ARM9opLDRBTprrmar();
OPCODE ARM9opLDRBTptrpar(), ARM9opLDRBTofrpar(), ARM9opLDRBTprrpar();
OPCODE ARM9opLDRBTptrmrr(), ARM9opLDRBTofrmrr(), ARM9opLDRBTprrmrr();
OPCODE ARM9opLDRBTptrprr(), ARM9opLDRBTofrprr(), ARM9opLDRBTprrprr();

OPCODE ARM9opSTRBTptrmll(), ARM9opSTRBTofrmll(), ARM9opSTRBTprrmll();
OPCODE ARM9opSTRBTptrpll(), ARM9opSTRBTofrpll(), ARM9opSTRBTprrpll();
OPCODE ARM9opSTRBTptrmlr(), ARM9opSTRBTofrmlr(), ARM9opSTRBTprrmlr();
OPCODE ARM9opSTRBTptrplr(), ARM9opSTRBTofrplr(), ARM9opSTRBTprrplr();
OPCODE ARM9opSTRBTptrmar(), ARM9opSTRBTofrmar(), ARM9opSTRBTprrmar();
OPCODE ARM9opSTRBTptrpar(), ARM9opSTRBTofrpar(), ARM9opSTRBTprrpar();
OPCODE ARM9opSTRBTptrmrr(), ARM9opSTRBTofrmrr(), ARM9opSTRBTprrmrr();
OPCODE ARM9opSTRBTptrprr(), ARM9opSTRBTofrprr(), ARM9opSTRBTprrprr();

//---SWP-------------------------------------------------------------------

OPCODE ARM9opSWP(), ARM9opSWPB();

//---LoaD/STore Multiple; Increment/Decrement After/Before-----------------

OPCODE ARM9opLDMIA(), ARM9opLDMIB(), ARM9opLDMDA(), ARM9opLDMDB();
OPCODE ARM9opSTMIA(), ARM9opSTMIB(), ARM9opSTMDA(), ARM9opSTMDB();

OPCODE ARM9opLDMIAu(), ARM9opLDMIBu(), ARM9opLDMDAu(), ARM9opLDMDBu();
OPCODE ARM9opSTMIAu(), ARM9opSTMIBu(), ARM9opSTMDAu(), ARM9opSTMDBu();

OPCODE ARM9opLDMIAw(), ARM9opLDMIBw(), ARM9opLDMDAw(), ARM9opLDMDBw();
OPCODE ARM9opSTMIAw(), ARM9opSTMIBw(), ARM9opSTMDAw(), ARM9opSTMDBw();

OPCODE ARM9opLDMIAuw(), ARM9opLDMIBuw(), ARM9opLDMDAuw(), ARM9opLDMDBuw();
OPCODE ARM9opSTMIAuw(), ARM9opSTMIBuw(), ARM9opSTMDAuw(), ARM9opSTMDBuw();

//---SoftWare Interrupts---------------------------------------------------

OPCODE ARM9opSWI();

//---ARM9 additions--------------------------------------------------------

OPCODE ARM9opCLZ();
OPCODE ARM9opBKPT();

OPCODE ARM9opLDRDptim(), ARM9opLDRDofim(), ARM9opLDRDprim();
OPCODE ARM9opLDRDptip(), ARM9opLDRDofip(), ARM9opLDRDprip();
OPCODE ARM9opLDRDptrm(), ARM9opLDRDofrm(), ARM9opLDRDprrm();
OPCODE ARM9opLDRDptrp(), ARM9opLDRDofrp(), ARM9opLDRDprrp();

OPCODE ARM9opSTRDptim(), ARM9opSTRDofim(), ARM9opSTRDprim();
OPCODE ARM9opSTRDptip(), ARM9opSTRDofip(), ARM9opSTRDprip();
OPCODE ARM9opSTRDptrm(), ARM9opSTRDofrm(), ARM9opSTRDprrm();
OPCODE ARM9opSTRDptrp(), ARM9opSTRDofrp(), ARM9opSTRDprrp();

OPCODE ARM9opSMULBB(), ARM9opSMULBT(), ARM9opSMULTB(), ARM9opSMULTT();
OPCODE ARM9opSMLABB(), ARM9opSMLABT(), ARM9opSMLATB(), ARM9opSMLATT();
OPCODE ARM9opQADD();

OPCODE ARM9opMRC();
OPCODE ARM9opMCR();
OPCODE ARM9opCDP();

u32 ARM9cp15Get(int,int,int,int);
void ARM9cp15Set(int,int,int,int,int);
void ARM9cp15DP(int,int,int,int,int);

//---Thumb ops-------------------------------------------------------------

OPCODE Thumb9opUND();

OPCODE Thumb9opLSLimm(), Thumb9opLSRimm(), Thumb9opASRimm();
OPCODE Thumb9opADDreg(), Thumb9opSUBreg();
OPCODE Thumb9opADDimm3(), Thumb9opSUBimm3();

OPCODE Thumb9opMOVimm8r0(), Thumb9opMOVimm8r1();
OPCODE Thumb9opMOVimm8r2(), Thumb9opMOVimm8r3();
OPCODE Thumb9opMOVimm8r4(), Thumb9opMOVimm8r5();
OPCODE Thumb9opMOVimm8r6(), Thumb9opMOVimm8r7();
OPCODE Thumb9opCMPimm8r0(), Thumb9opCMPimm8r1();
OPCODE Thumb9opCMPimm8r2(), Thumb9opCMPimm8r3();
OPCODE Thumb9opCMPimm8r4(), Thumb9opCMPimm8r5();
OPCODE Thumb9opCMPimm8r6(), Thumb9opCMPimm8r7();
OPCODE Thumb9opADDimm8r0(), Thumb9opADDimm8r1();
OPCODE Thumb9opADDimm8r2(), Thumb9opADDimm8r3();
OPCODE Thumb9opADDimm8r4(), Thumb9opADDimm8r5();
OPCODE Thumb9opADDimm8r6(), Thumb9opADDimm8r7();
OPCODE Thumb9opSUBimm8r0(), Thumb9opSUBimm8r1();
OPCODE Thumb9opSUBimm8r2(), Thumb9opSUBimm8r3();
OPCODE Thumb9opSUBimm8r4(), Thumb9opSUBimm8r5();
OPCODE Thumb9opSUBimm8r6(), Thumb9opSUBimm8r7();

OPCODE Thumb9opDPg1(), Thumb9opDPg2(), Thumb9opDPg3(), Thumb9opDPg4();
OPCODE Thumb9opADDH(), Thumb9opMOVH(), Thumb9opCMPH(), Thumb9opBXreg();

OPCODE Thumb9opLDRPCr0(), Thumb9opLDRPCr1();
OPCODE Thumb9opLDRPCr2(), Thumb9opLDRPCr3();
OPCODE Thumb9opLDRPCr4(), Thumb9opLDRPCr5();
OPCODE Thumb9opLDRPCr6(), Thumb9opLDRPCr7();

OPCODE Thumb9opSTRSPr0(), Thumb9opSTRSPr1();
OPCODE Thumb9opSTRSPr2(), Thumb9opSTRSPr3();
OPCODE Thumb9opSTRSPr4(), Thumb9opSTRSPr5();
OPCODE Thumb9opSTRSPr6(), Thumb9opSTRSPr7();
OPCODE Thumb9opLDRSPr0(), Thumb9opLDRSPr1();
OPCODE Thumb9opLDRSPr2(), Thumb9opLDRSPr3();
OPCODE Thumb9opLDRSPr4(), Thumb9opLDRSPr5();
OPCODE Thumb9opLDRSPr6(), Thumb9opLDRSPr7();

OPCODE Thumb9opSTRreg(),  Thumb9opLDRreg();
OPCODE Thumb9opSTRHreg(), Thumb9opLDRHreg();
OPCODE Thumb9opSTRBreg(), Thumb9opLDRBreg();

OPCODE Thumb9opLDRSBreg(), Thumb9opLDRSHreg();

OPCODE Thumb9opSTRimm5(),  Thumb9opLDRimm5();
OPCODE Thumb9opSTRBimm5(), Thumb9opLDRBimm5();
OPCODE Thumb9opSTRHimm5(), Thumb9opLDRHimm5();

OPCODE Thumb9opADDPCr0(), Thumb9opADDPCr1();
OPCODE Thumb9opADDPCr2(), Thumb9opADDPCr3();
OPCODE Thumb9opADDPCr4(), Thumb9opADDPCr5();
OPCODE Thumb9opADDPCr6(), Thumb9opADDPCr7();
OPCODE Thumb9opADDSPr0(), Thumb9opADDSPr1();
OPCODE Thumb9opADDSPr2(), Thumb9opADDSPr3();
OPCODE Thumb9opADDSPr4(), Thumb9opADDSPr5();
OPCODE Thumb9opADDSPr6(), Thumb9opADDSPr7();
OPCODE Thumb9opADDSPimm7();

OPCODE Thumb9opPUSH(), Thumb9opPUSHlr();
OPCODE Thumb9opPOP(),  Thumb9opPOPpc();

OPCODE Thumb9opBKPT(), Thumb9opSWI();

OPCODE Thumb9opLDMIAr0(), Thumb9opLDMIAr1();
OPCODE Thumb9opLDMIAr2(), Thumb9opLDMIAr3();
OPCODE Thumb9opLDMIAr4(), Thumb9opLDMIAr5();
OPCODE Thumb9opLDMIAr6(), Thumb9opLDMIAr7();
OPCODE Thumb9opSTMIAr0(), Thumb9opSTMIAr1();
OPCODE Thumb9opSTMIAr2(), Thumb9opSTMIAr3();
OPCODE Thumb9opSTMIAr4(), Thumb9opSTMIAr5();
OPCODE Thumb9opSTMIAr6(), Thumb9opSTMIAr7();

OPCODE Thumb9opBEQ(), Thumb9opBNE();
OPCODE Thumb9opBCS(), Thumb9opBCC();
OPCODE Thumb9opBMI(), Thumb9opBPL();
OPCODE Thumb9opBVS(), Thumb9opBVC();
OPCODE Thumb9opBHI(), Thumb9opBLS();
OPCODE Thumb9opBGE(), Thumb9opBLT();
OPCODE Thumb9opBGT(), Thumb9opBLE();

OPCODE Thumb9opB(), Thumb9opBLsetup(), Thumb9opBLoff();

//---And so it begins------------------------------------------------------

typedef struct {
    opfptr op;
    u32 cyc;
    u32 pad1,pad2;
} ARM9OPDESC;

//---Opcode function pointer table. Indexed by 27-20|7-4-------------------

//const fptr arm9uber[16]={
//    ARM9opDPS0,      /* 0 - Data processing Shifted */
//    ARM9opDPS1,      /* 1 - Data processing Shifted */
//    ARM9opDPI0,      /* 2 - Data processing Immediate */
//    ARM9opDPI1,      /* 3 - Data processing Immediate */
//    ARM9opLSIpt,     /* 4 - Load/store Immediate Post-indexed */
//    ARM9opLSIof,     /* 5 - Load/store Immediate Preidx/Offset */
//    ARM9opLSRpt,     /* 6 - Load/store Register Post-indexed */
//    ARM9opLSRof,     /* 7 - Load/store Register Preidx/Offset */
//    ARM9opLSMf,      /* 8 - Load/store Multiple Load:Full */
//    ARM9opLSMe,      /* 9 - Load/store Multiple Load:Empty */
//    ARM9opB,         /* A - Branch */
//    ARM9opBL,        /* B - Branch+Link */
//    ARM9opLSCof,     /* C - Load/store Copro Preidx/Offset */
//    ARM9opLSCpt,     /* D - Load/store Copro Post-indexed */
//    ARM9opCP,        /* E - Copro Data/Reg handling */
//    ARM9opSWI        /* F - Software Interrupt */
//};

const ARM9OPDESC arm9opsDPS0[]={
    /*0x00*/
    {ARM9opANDlli      ,2},
    {ARM9opANDllr      ,2},
    {ARM9opANDlri      ,2},
    {ARM9opANDlrr      ,2},
    {ARM9opANDari      ,2},
    {ARM9opANDarr      ,2},
    {ARM9opANDrri      ,2},
    {ARM9opANDrrr      ,2},
    {ARM9opANDlli      ,2},
    {ARM9opMUL         ,3},
    {ARM9opANDlri      ,2},
    {ARM9opSTRHptrm    ,2},
    {ARM9opANDari      ,2},
    {ARM9opLDRDptrm    ,3},  // ++ARM5E
    {ARM9opANDrri      ,2},
    {ARM9opSTRDptrm    ,3},  // ++ARM5E

    /*0x01*/
    {ARM9opANDSlli     ,2},
    {ARM9opANDSllr     ,2},
    {ARM9opANDSlri     ,2},
    {ARM9opANDSlrr     ,2},
    {ARM9opANDSari     ,2},
    {ARM9opANDSarr     ,2},
    {ARM9opANDSrri     ,2},
    {ARM9opANDSrrr     ,2},
    {ARM9opANDSlli     ,2},
    {ARM9opMULS        ,3},
    {ARM9opANDSlri     ,2},
    {ARM9opLDRHptrm    ,3},
    {ARM9opANDSari     ,2},
    {ARM9opLDRSBptrm   ,3},
    {ARM9opANDSrri     ,2},
    {ARM9opLDRSHptrm   ,3},

    /*0x02*/
    {ARM9opEORlli      ,2},
    {ARM9opEORllr      ,2},
    {ARM9opEORlri      ,2},
    {ARM9opEORlrr      ,2},
    {ARM9opEORari      ,2},
    {ARM9opEORarr      ,2},
    {ARM9opEORrri      ,2},
    {ARM9opEORrrr      ,2},
    {ARM9opEORlli      ,2},
    {ARM9opMLA         ,4},
    {ARM9opEORlri      ,2},
    {ARM9opSTRHptrm    ,2},
    {ARM9opEORari      ,2},
    {ARM9opLDRDptrm    ,3},  // ++ARM5E
    {ARM9opEORrri      ,2},
    {ARM9opSTRDptrm    ,3},  // ++ARM5E

    /*0x03*/
    {ARM9opEORSlli     ,2},
    {ARM9opEORSllr     ,2},
    {ARM9opEORSlri     ,2},
    {ARM9opEORSlrr     ,2},
    {ARM9opEORSari     ,2},
    {ARM9opEORSarr     ,2},
    {ARM9opEORSrri     ,2},
    {ARM9opEORSrrr     ,2},
    {ARM9opEORSlli     ,2},
    {ARM9opMLAS        ,4},
    {ARM9opEORSlri     ,2},
    {ARM9opLDRHptrm    ,3},
    {ARM9opEORSari     ,2},
    {ARM9opLDRSBptrm   ,3},
    {ARM9opEORSrri     ,2},
    {ARM9opLDRSHptrm   ,3},

    /*0x04*/
    {ARM9opSUBlli      ,2},
    {ARM9opSUBllr      ,2},
    {ARM9opSUBlri      ,2},
    {ARM9opSUBlrr      ,2},
    {ARM9opSUBari      ,2},
    {ARM9opSUBarr      ,2},
    {ARM9opSUBrri      ,2},
    {ARM9opSUBrrr      ,2},
    {ARM9opSUBlli      ,2},
    {ARM9opUNP         ,1},  // Unallocated
    {ARM9opSUBlri      ,2},
    {ARM9opSTRHptim    ,2},
    {ARM9opSUBari      ,2},
    {ARM9opLDRDptim    ,3},  // ++ARM5E
    {ARM9opSUBrri      ,2},
    {ARM9opSTRDptim    ,3},  // ++ARM5E

    /*0x05*/
    {ARM9opSUBSlli     ,2},
    {ARM9opSUBSllr     ,2},
    {ARM9opSUBSlri     ,2},
    {ARM9opSUBSlrr     ,2},
    {ARM9opSUBSari     ,2},
    {ARM9opSUBSarr     ,2},
    {ARM9opSUBSrri     ,2},
    {ARM9opSUBSrrr     ,2},
    {ARM9opSUBSlli     ,2},
    {ARM9opUNL         ,1},  // Unallocated [reindexed]
    {ARM9opSUBSlri     ,2},
    {ARM9opLDRHptim    ,3},
    {ARM9opSUBSari     ,2},
    {ARM9opLDRSBptim   ,3},
    {ARM9opSUBSrri     ,2},
    {ARM9opLDRSHptim   ,3},

    /*0x06*/
    {ARM9opRSBlli      ,2},
    {ARM9opRSBllr      ,2},
    {ARM9opRSBlri      ,2},
    {ARM9opRSBlrr      ,2},
    {ARM9opRSBari      ,2},
    {ARM9opRSBarr      ,2},
    {ARM9opRSBrri      ,2},
    {ARM9opRSBrrr      ,2},
    {ARM9opRSBlli      ,2},
    {ARM9opUNP         ,1},  // Unallocated
    {ARM9opRSBlri      ,2},
    {ARM9opSTRHptim    ,2},
    {ARM9opRSBari      ,2},
    {ARM9opLDRDptim    ,3},  // ++ARM5E
    {ARM9opRSBrri      ,2},
    {ARM9opSTRDptim    ,3},  // ++ARM5E

    /*0x07*/
    {ARM9opRSBSlli     ,2},
    {ARM9opRSBSllr     ,2},
    {ARM9opRSBSlri     ,2},
    {ARM9opRSBSlrr     ,2},
    {ARM9opRSBSari     ,2},
    {ARM9opRSBSarr     ,2},
    {ARM9opRSBSrri     ,2},
    {ARM9opRSBSrrr     ,2},
    {ARM9opRSBSlli     ,2},
    {ARM9opUNP         ,1},  // Unallocated
    {ARM9opRSBSlri     ,2},
    {ARM9opLDRHptim    ,3},
    {ARM9opRSBSari     ,2},
    {ARM9opLDRSBptim   ,3},
    {ARM9opRSBSrri     ,2},
    {ARM9opLDRSHptim   ,3},

    /*0x08*/
    {ARM9opADDlli      ,2},
    {ARM9opADDllr      ,2},
    {ARM9opADDlri      ,2},
    {ARM9opADDlrr      ,2},
    {ARM9opADDari      ,2},
    {ARM9opADDarr      ,2},
    {ARM9opADDrri      ,2},
    {ARM9opADDrrr      ,2},
    {ARM9opADDlli      ,2},
    {ARM9opUMULL       ,4},
    {ARM9opADDlri      ,2},
    {ARM9opSTRHptrp    ,2},
    {ARM9opADDari      ,2},
    {ARM9opLDRDptrp    ,3},  // ++ARM5E
    {ARM9opADDrri      ,2},
    {ARM9opSTRDptrp    ,3},  // ++ARM5E

    /*0x09*/
    {ARM9opADDSlli     ,2},
    {ARM9opADDSllr     ,2},
    {ARM9opADDSlri     ,2},
    {ARM9opADDSlrr     ,2},
    {ARM9opADDSari     ,2},
    {ARM9opADDSarr     ,2},
    {ARM9opADDSrri     ,2},
    {ARM9opADDSrrr     ,2},
    {ARM9opADDSlli     ,2},
    {ARM9opUMULLS      ,4},
    {ARM9opADDSlri     ,2},
    {ARM9opLDRHptrp    ,3},
    {ARM9opADDSari     ,2},
    {ARM9opLDRSBptrp   ,3},
    {ARM9opADDSrri     ,2},
    {ARM9opLDRSHptrp   ,3},

    /*0x0A*/
    {ARM9opADClli      ,2},
    {ARM9opADCllr      ,2},
    {ARM9opADClri      ,2},
    {ARM9opADClrr      ,2},
    {ARM9opADCari      ,2},
    {ARM9opADCarr      ,2},
    {ARM9opADCrri      ,2},
    {ARM9opADCrrr      ,2},
    {ARM9opADClli      ,2},
    {ARM9opUMLAL       ,5},
    {ARM9opADClri      ,2},
    {ARM9opSTRHptrp    ,2},
    {ARM9opADCari      ,2},
    {ARM9opLDRDptrp    ,3},  // ++ARM5E
    {ARM9opADCrri      ,2},
    {ARM9opSTRDptrp    ,3},  // ++ARM5E

    /*0x0B*/
    {ARM9opADCSlli     ,2},
    {ARM9opADCSllr     ,2},
    {ARM9opADCSlri     ,2},
    {ARM9opADCSlrr     ,2},
    {ARM9opADCSari     ,2},
    {ARM9opADCSarr     ,2},
    {ARM9opADCSrri     ,2},
    {ARM9opADCSrrr     ,2},
    {ARM9opADCSlli     ,2},
    {ARM9opUMLALS      ,5},
    {ARM9opADCSlri     ,2},
    {ARM9opLDRHptrp    ,3},
    {ARM9opADCSari     ,2},
    {ARM9opLDRSBptrp   ,3},
    {ARM9opADCSrri     ,2},
    {ARM9opLDRSHptrp   ,3},

    /*0x0C*/
    {ARM9opSBClli      ,2},
    {ARM9opSBCllr      ,2},
    {ARM9opSBClri      ,2},
    {ARM9opSBClrr      ,2},
    {ARM9opSBCari      ,2},
    {ARM9opSBCarr      ,2},
    {ARM9opSBCrri      ,2},
    {ARM9opSBCrrr      ,2},
    {ARM9opSBClli      ,2},
    {ARM9opSMULL       ,4},
    {ARM9opSBClri      ,2},
    {ARM9opSTRHptip    ,2},
    {ARM9opSBCari      ,2},
    {ARM9opLDRDptip    ,3},  // ++ARM5E
    {ARM9opSBCrri      ,2},
    {ARM9opSTRDptip    ,3},  // ++ARM5E

    /*0x0D*/
    {ARM9opSBCSlli     ,2},
    {ARM9opSBCSllr     ,2},
    {ARM9opSBCSlri     ,2},
    {ARM9opSBCSlrr     ,2},
    {ARM9opSBCSari     ,2},
    {ARM9opSBCSarr     ,2},
    {ARM9opSBCSrri     ,2},
    {ARM9opSBCSrrr     ,2},
    {ARM9opSBCSlli     ,2},
    {ARM9opSMULLS      ,4},
    {ARM9opSBCSlri     ,2},
    {ARM9opLDRHptip    ,3},
    {ARM9opSBCSari     ,2},
    {ARM9opLDRSBptip   ,3},
    {ARM9opSBCSrri     ,2},
    {ARM9opLDRSHptip   ,3},

    /*0x0E*/
    {ARM9opRSClli      ,2},
    {ARM9opRSCllr      ,2},
    {ARM9opRSClri      ,2},
    {ARM9opRSClrr      ,2},
    {ARM9opRSCari      ,2},
    {ARM9opRSCarr      ,2},
    {ARM9opRSCrri      ,2},
    {ARM9opRSCrrr      ,2},
    {ARM9opRSClli      ,2},
    {ARM9opSMLAL       ,5},
    {ARM9opRSClri      ,2},
    {ARM9opSTRHptip    ,2},
    {ARM9opRSCari      ,2},
    {ARM9opLDRDptip    ,3},  // ++ARM5E
    {ARM9opRSCrri      ,2},
    {ARM9opSTRDptip    ,3},  // ++ARM5E

    /*0x0F*/
    {ARM9opRSCSlli     ,2},
    {ARM9opRSCSllr     ,2},
    {ARM9opRSCSlri     ,2},
    {ARM9opRSCSlrr     ,2},
    {ARM9opRSCSari     ,2},
    {ARM9opRSCSarr     ,2},
    {ARM9opRSCSrri     ,2},
    {ARM9opRSCSrrr     ,2},
    {ARM9opRSCSlli     ,2},
    {ARM9opSMLALS      ,5},
    {ARM9opRSCSlri     ,2},
    {ARM9opLDRHptip    ,3},
    {ARM9opRSCSari     ,2},
    {ARM9opLDRSBptip   ,3},
    {ARM9opRSCSrri     ,2},
    {ARM9opLDRSHptip   ,3},
};

const ARM9OPDESC arm9opsDPS1[]={
    /*0x10*/
    {ARM9opMRSrc       ,1},
    {ARM9opUNP         ,1},  // MRS with non-zero 7-4
    {ARM9opUNP         ,1},  // MRS with non-zero 7-4
    {ARM9opUNP         ,1},  // MRS with non-zero 7-4
    {ARM9opUNP         ,1},  // MRS with non-zero 7-4
    {ARM9opUNP         ,1},  // Defined in ARM5E!
    {ARM9opUNP         ,1},  // MRS with non-zero 7-4
    {ARM9opUNP         ,1},  // MRS with non-zero 7-4
    {ARM9opUNP         ,1},  // Defined in ARM5E!
    {ARM9opSWP         ,4},
    {ARM9opUNP         ,1},  // Defined in ARM5E!
    {ARM9opSTRHofrm    ,2},
    {ARM9opUNP         ,1},  // Defined in ARM5E!
    {ARM9opLDRDofrm    ,3},  // ++ARM5E
    {ARM9opUNP         ,1},  // Defined in ARM5E!
    {ARM9opSTRDofrm    ,3},  // ++ARM5E

    /*0x11*/
    {ARM9opTSTSlli     ,2},
    {ARM9opTSTSllr     ,2},
    {ARM9opTSTSlri     ,2},
    {ARM9opTSTSlrr     ,2},
    {ARM9opTSTSari     ,2},
    {ARM9opTSTSarr     ,2},
    {ARM9opTSTSrri     ,2},
    {ARM9opTSTSrrr     ,2},
    {ARM9opTSTSlli     ,2},
    {ARM9opUNP         ,1},  // Unallocated
    {ARM9opTSTSlri     ,2},
    {ARM9opLDRHofrm    ,3},
    {ARM9opTSTSari     ,2},
    {ARM9opLDRSBofrm   ,3},
    {ARM9opTSTSrri     ,2},
    {ARM9opLDRSHofrm   ,3},

    /*0x12*/
    {ARM9opMSRrc       ,1},
    {ARM9opBX          ,3},
    {ARM9opUNP         ,1},  // Unallocated
    {ARM9opBLXr        ,3},
    {ARM9opUNP         ,1},  // Unallocated
    {ARM9opUNP         ,1},  // Defined in ARM5E!
    {ARM9opUNP         ,1},  // Unallocated
    {ARM9opBKPT        ,1},  // ++ARM5
    {ARM9opUNP         ,1},  // Defined in ARM5E!
    {ARM9opUNP         ,1},  // Unallocated
    {ARM9opUNP         ,1},  // Defined in ARM5E!
    {ARM9opSTRHprrm    ,2},
    {ARM9opUNP         ,1},  // Defined in ARM5E!
    {ARM9opLDRDprrm    ,3},  // ++ARM5E
    {ARM9opUNP         ,1},  // Defined in ARM5E!
    {ARM9opSTRDprrm    ,3},  // ++ARM5E

    /*0x13*/
    {ARM9opTEQSlli     ,2},
    {ARM9opTEQSllr     ,2},
    {ARM9opTEQSlri     ,2},
    {ARM9opTEQSlrr     ,2},
    {ARM9opTEQSari     ,2},
    {ARM9opTEQSarr     ,2},
    {ARM9opTEQSrri     ,2},
    {ARM9opTEQSrrr     ,2},
    {ARM9opTEQSlli     ,2},
    {ARM9opUNP         ,1},  // Unallocated
    {ARM9opTEQSlri     ,2},
    {ARM9opLDRHprrm    ,3},
    {ARM9opTEQSari     ,2},
    {ARM9opLDRSBprrm   ,3},
    {ARM9opTEQSrri     ,2},
    {ARM9opLDRSHprrm   ,3},

    /*0x14*/
    {ARM9opMRSrs       ,1},
    {ARM9opUNP         ,1},  // Unallocated
    {ARM9opUNP         ,1},  // Unallocated
    {ARM9opUNP         ,1},  // Unallocated
    {ARM9opUNP         ,1},  // Unallocated
    {ARM9opUNP         ,1},  // Defined in ARM5E!
    {ARM9opUNP         ,1},  // Unallocated
    {ARM9opUNP         ,1},  // Unallocated
    {ARM9opUNP         ,1},  // Defined in ARM5E!
    {ARM9opSWPB        ,4},
    {ARM9opUNP         ,1},  // Defined in ARM5E!
    {ARM9opSTRHofim    ,2},
    {ARM9opUNP         ,1},  // Defined in ARM5E!
    {ARM9opLDRDofim    ,3},  // ++ARM5E
    {ARM9opUNP         ,1},  // Defined in ARM5E!
    {ARM9opSTRDofim    ,3},  // ++ARM5E

    /*0x15*/
    {ARM9opCMPSlli     ,2},
    {ARM9opCMPSllr     ,2},
    {ARM9opCMPSlri     ,2},
    {ARM9opCMPSlrr     ,2},
    {ARM9opCMPSari     ,2},
    {ARM9opCMPSarr     ,2},
    {ARM9opCMPSrri     ,2},
    {ARM9opCMPSrrr     ,2},
    {ARM9opCMPSlli     ,2},
    {ARM9opUNP         ,1},  // Unallocated
    {ARM9opCMPSlri     ,2},
    {ARM9opLDRHofim    ,3},
    {ARM9opCMPSari     ,2},
    {ARM9opLDRSBofim   ,3},
    {ARM9opCMPSrri     ,2},
    {ARM9opLDRSHofim   ,3},

    /*0x16*/
    {ARM9opMSRrs       ,1},
    {ARM9opCLZ         ,1},  // ++ARM5
    {ARM9opUNP         ,1},  // Unallocated
    {ARM9opUNP         ,1},  // Unallocated
    {ARM9opUNP         ,1},  // Unallocated
    {ARM9opUNP         ,1},  // Defined in ARM5E!
    {ARM9opUNP         ,1},  // Unallocated
    {ARM9opUNP         ,1},  // Unallocated
    {ARM9opUNP         ,1},  // Defined in ARM5E!
    {ARM9opUNP         ,1},  // Unallocated
    {ARM9opUNP         ,1},  // Defined in ARM5E!
    {ARM9opSTRHprim    ,2},
    {ARM9opUNP         ,1},  // Defined in ARM5E!
    {ARM9opLDRDprim    ,3},  // ++ARM5E
    {ARM9opUNP         ,1},  // Defined in ARM5E!
    {ARM9opSTRDprim    ,3},  // ++ARM5E

    /*0x17*/
    {ARM9opCMNSlli     ,2},
    {ARM9opCMNSllr     ,2},
    {ARM9opCMNSlri     ,2},
    {ARM9opCMNSlrr     ,2},
    {ARM9opCMNSari     ,2},
    {ARM9opCMNSarr     ,2},
    {ARM9opCMNSrri     ,2},
    {ARM9opCMNSrrr     ,2},
    {ARM9opCMNSlli     ,2},
    {ARM9opUNP         ,1},  // Unallocated
    {ARM9opCMNSlri     ,2},
    {ARM9opLDRHprim    ,3},
    {ARM9opCMNSari     ,2},
    {ARM9opLDRSBprim   ,3},
    {ARM9opCMNSrri     ,2},
    {ARM9opLDRSHprim   ,3},

    /*0x18*/
    {ARM9opORRlli      ,2},
    {ARM9opORRllr      ,2},
    {ARM9opORRlri      ,2},
    {ARM9opORRlrr      ,2},
    {ARM9opORRari      ,2},
    {ARM9opORRarr      ,2},
    {ARM9opORRrri      ,2},
    {ARM9opORRrrr      ,2},
    {ARM9opORRlli      ,2},
    {ARM9opUNP         ,1},  // Unallocated
    {ARM9opORRlri      ,2},
    {ARM9opSTRHofrp    ,2},
    {ARM9opORRari      ,2},
    {ARM9opLDRDofrp    ,3},  // ++ARM5E
    {ARM9opORRrri      ,2},
    {ARM9opSTRDofrp    ,3},  // ++ARM5E

    /*0x19*/
    {ARM9opORRSlli     ,2},
    {ARM9opORRSllr     ,2},
    {ARM9opORRSlri     ,2},
    {ARM9opORRSlrr     ,2},
    {ARM9opORRSari     ,2},
    {ARM9opORRSarr     ,2},
    {ARM9opORRSrri     ,2},
    {ARM9opORRSrrr     ,2},
    {ARM9opORRSlli     ,2},
    {ARM9opUNP         ,1},  // Unallocated
    {ARM9opORRSlri     ,2},
    {ARM9opLDRHofrp    ,3},
    {ARM9opORRSari     ,2},
    {ARM9opLDRSBofrp   ,3},
    {ARM9opORRSrri     ,2},
    {ARM9opLDRSHofrp   ,3},

    /*0x1A*/
    {ARM9opMOVlli      ,2},
    {ARM9opMOVllr      ,2},
    {ARM9opMOVlri      ,2},
    {ARM9opMOVlrr      ,2},
    {ARM9opMOVari      ,2},
    {ARM9opMOVarr      ,2},
    {ARM9opMOVrri      ,2},
    {ARM9opMOVrrr      ,2},
    {ARM9opMOVlli      ,2},
    {ARM9opUNP         ,1},  // Unallocated
    {ARM9opMOVlri      ,2},
    {ARM9opSTRHprrp    ,2},
    {ARM9opMOVari      ,2},
    {ARM9opLDRDprrp    ,3},  // ++ARM5E
    {ARM9opMOVrri      ,2},
    {ARM9opSTRDprrp    ,3},  // ++ARM5E

    /*0x1B*/
    {ARM9opMOVSlli     ,2},
    {ARM9opMOVSllr     ,2},
    {ARM9opMOVSlri     ,2},
    {ARM9opMOVSlrr     ,2},
    {ARM9opMOVSari     ,2},
    {ARM9opMOVSarr     ,2},
    {ARM9opMOVSrri     ,2},
    {ARM9opMOVSrrr     ,2},
    {ARM9opMOVSlli     ,2},
    {ARM9opUNP         ,1},  // Unallocated
    {ARM9opMOVSlri     ,2},
    {ARM9opLDRHprrp    ,3},
    {ARM9opMOVSari     ,2},
    {ARM9opLDRSBprrp   ,3},
    {ARM9opMOVSrri     ,2},
    {ARM9opLDRSHprrp   ,3},

    /*0x1C*/
    {ARM9opBIClli      ,2},
    {ARM9opBICllr      ,2},
    {ARM9opBIClri      ,2},
    {ARM9opBIClrr      ,2},
    {ARM9opBICari      ,2},
    {ARM9opBICarr      ,2},
    {ARM9opBICrri      ,2},
    {ARM9opBICrrr      ,2},
    {ARM9opBIClli      ,2},
    {ARM9opUNP         ,1},  // Unallocated
    {ARM9opBIClri      ,2},
    {ARM9opSTRHofip    ,2},
    {ARM9opBICari      ,2},
    {ARM9opLDRDofip    ,3},  // ++ARM5E
    {ARM9opBICrri      ,2},
    {ARM9opSTRDofip    ,3},  // ++ARM5E

    /*0x1D*/
    {ARM9opBICSlli     ,2},
    {ARM9opBICSllr     ,2},
    {ARM9opBICSlri     ,2},
    {ARM9opBICSlrr     ,2},
    {ARM9opBICSari     ,2},
    {ARM9opBICSarr     ,2},
    {ARM9opBICSrri     ,2},
    {ARM9opBICSrrr     ,2},
    {ARM9opBICSlli     ,2},
    {ARM9opUNP         ,1},  // Unallocated
    {ARM9opBICSlri     ,2},
    {ARM9opLDRHofip    ,3},
    {ARM9opBICSari     ,2},
    {ARM9opLDRSBofip   ,3},
    {ARM9opBICSrri     ,2},
    {ARM9opLDRSHofip   ,3},

    /*0x1E*/
    {ARM9opMVNlli      ,2},
    {ARM9opMVNllr      ,2},
    {ARM9opMVNlri      ,2},
    {ARM9opMVNlrr      ,2},
    {ARM9opMVNari      ,2},
    {ARM9opMVNarr      ,2},
    {ARM9opMVNrri      ,2},
    {ARM9opMVNrrr      ,2},
    {ARM9opMVNlli      ,2},
    {ARM9opUNP         ,1},  // Unallocated
    {ARM9opMVNlri      ,2},
    {ARM9opSTRHprip    ,2},
    {ARM9opMVNari      ,2},
    {ARM9opLDRDprip    ,3},  // ++ARM5E
    {ARM9opMVNrri      ,2},
    {ARM9opSTRDprip    ,3},  // ++ARM5E

    /*0x1F*/
    {ARM9opMVNSlli     ,2},
    {ARM9opMVNSllr     ,2},
    {ARM9opMVNSlri     ,2},
    {ARM9opMVNSlrr     ,2},
    {ARM9opMVNSari     ,2},
    {ARM9opMVNSarr     ,2},
    {ARM9opMVNSrri     ,2},
    {ARM9opMVNSrrr     ,2},
    {ARM9opMVNSlli     ,2},
    {ARM9opUNP         ,1},  // Unallocated
    {ARM9opMVNSlri     ,2},
    {ARM9opLDRHprip    ,3},
    {ARM9opMVNSari     ,2},
    {ARM9opLDRSBprip   ,3},
    {ARM9opMVNSrri     ,2},
    {ARM9opLDRSHprip   ,3},
};

const opfptr arm9ops[]={
    /*0x00*/
    ARM9opANDlli      ,
    ARM9opANDllr      ,
    ARM9opANDlri      ,
    ARM9opANDlrr      ,
    ARM9opANDari      ,
    ARM9opANDarr      ,
    ARM9opANDrri      ,
    ARM9opANDrrr      ,
    ARM9opANDlli      ,
    ARM9opMUL         ,
    ARM9opANDlri      ,
    ARM9opSTRHptrm    ,
    ARM9opANDari      ,
    ARM9opLDRDptrm    ,  // ++ARM5E
    ARM9opANDrri      ,
    ARM9opSTRDptrm    ,  // ++ARM5E

    /*0x01*/
    ARM9opANDSlli     ,
    ARM9opANDSllr     ,
    ARM9opANDSlri     ,
    ARM9opANDSlrr     ,
    ARM9opANDSari     ,
    ARM9opANDSarr     ,
    ARM9opANDSrri     ,
    ARM9opANDSrrr     ,
    ARM9opANDSlli     ,
    ARM9opMULS        ,
    ARM9opANDSlri     ,
    ARM9opLDRHptrm    ,
    ARM9opANDSari     ,
    ARM9opLDRSBptrm   ,
    ARM9opANDSrri     ,
    ARM9opLDRSHptrm   ,

    /*0x02*/
    ARM9opEORlli      ,
    ARM9opEORllr      ,
    ARM9opEORlri      ,
    ARM9opEORlrr      ,
    ARM9opEORari      ,
    ARM9opEORarr      ,
    ARM9opEORrri      ,
    ARM9opEORrrr      ,
    ARM9opEORlli      ,
    ARM9opMLA         ,
    ARM9opEORlri      ,
    ARM9opSTRHptrm    ,
    ARM9opEORari      ,
    ARM9opLDRDptrm    ,  // ++ARM5E
    ARM9opEORrri      ,
    ARM9opSTRDptrm    ,  // ++ARM5E

    /*0x03*/
    ARM9opEORSlli     ,
    ARM9opEORSllr     ,
    ARM9opEORSlri     ,
    ARM9opEORSlrr     ,
    ARM9opEORSari     ,
    ARM9opEORSarr     ,
    ARM9opEORSrri     ,
    ARM9opEORSrrr     ,
    ARM9opEORSlli     ,
    ARM9opMLAS        ,
    ARM9opEORSlri     ,
    ARM9opLDRHptrm    ,
    ARM9opEORSari     ,
    ARM9opLDRSBptrm   ,
    ARM9opEORSrri     ,
    ARM9opLDRSHptrm   ,

    /*0x04*/
    ARM9opSUBlli      ,
    ARM9opSUBllr      ,
    ARM9opSUBlri      ,
    ARM9opSUBlrr      ,
    ARM9opSUBari      ,
    ARM9opSUBarr      ,
    ARM9opSUBrri      ,
    ARM9opSUBrrr      ,
    ARM9opSUBlli      ,
    ARM9opUNP         ,  // Unallocated
    ARM9opSUBlri      ,
    ARM9opSTRHptim    ,
    ARM9opSUBari      ,
    ARM9opLDRDptim    ,  // ++ARM5E
    ARM9opSUBrri      ,
    ARM9opSTRDptim    ,  // ++ARM5E

    /*0x05*/
    ARM9opSUBSlli     ,
    ARM9opSUBSllr     ,
    ARM9opSUBSlri     ,
    ARM9opSUBSlrr     ,
    ARM9opSUBSari     ,
    ARM9opSUBSarr     ,
    ARM9opSUBSrri     ,
    ARM9opSUBSrrr     ,
    ARM9opSUBSlli     ,
    ARM9opUNL         ,  // Unallocated [reindexed]
    ARM9opSUBSlri     ,
    ARM9opLDRHptim    ,
    ARM9opSUBSari     ,
    ARM9opLDRSBptim   ,
    ARM9opSUBSrri     ,
    ARM9opLDRSHptim   ,

    /*0x06*/
    ARM9opRSBlli      ,
    ARM9opRSBllr      ,
    ARM9opRSBlri      ,
    ARM9opRSBlrr      ,
    ARM9opRSBari      ,
    ARM9opRSBarr      ,
    ARM9opRSBrri      ,
    ARM9opRSBrrr      ,
    ARM9opRSBlli      ,
    ARM9opUNP         ,  // Unallocated
    ARM9opRSBlri      ,
    ARM9opSTRHptim    ,
    ARM9opRSBari      ,
    ARM9opLDRDptim    ,  // ++ARM5E
    ARM9opRSBrri      ,
    ARM9opSTRDptim    ,  // ++ARM5E

    /*0x07*/
    ARM9opRSBSlli     ,
    ARM9opRSBSllr     ,
    ARM9opRSBSlri     ,
    ARM9opRSBSlrr     ,
    ARM9opRSBSari     ,
    ARM9opRSBSarr     ,
    ARM9opRSBSrri     ,
    ARM9opRSBSrrr     ,
    ARM9opRSBSlli     ,
    ARM9opUNP         ,  // Unallocated
    ARM9opRSBSlri     ,
    ARM9opLDRHptim    ,
    ARM9opRSBSari     ,
    ARM9opLDRSBptim   ,
    ARM9opRSBSrri     ,
    ARM9opLDRSHptim   ,

    /*0x08*/
    ARM9opADDlli      ,
    ARM9opADDllr      ,
    ARM9opADDlri      ,
    ARM9opADDlrr      ,
    ARM9opADDari      ,
    ARM9opADDarr      ,
    ARM9opADDrri      ,
    ARM9opADDrrr      ,
    ARM9opADDlli      ,
    ARM9opUMULL       ,
    ARM9opADDlri      ,
    ARM9opSTRHptrp    ,
    ARM9opADDari      ,
    ARM9opLDRDptrp    ,  // ++ARM5E
    ARM9opADDrri      ,
    ARM9opSTRDptrp    ,  // ++ARM5E

    /*0x09*/
    ARM9opADDSlli     ,
    ARM9opADDSllr     ,
    ARM9opADDSlri     ,
    ARM9opADDSlrr     ,
    ARM9opADDSari     ,
    ARM9opADDSarr     ,
    ARM9opADDSrri     ,
    ARM9opADDSrrr     ,
    ARM9opADDSlli     ,
    ARM9opUMULLS      ,
    ARM9opADDSlri     ,
    ARM9opLDRHptrp    ,
    ARM9opADDSari     ,
    ARM9opLDRSBptrp   ,
    ARM9opADDSrri     ,
    ARM9opLDRSHptrp   ,

    /*0x0A*/
    ARM9opADClli      ,
    ARM9opADCllr      ,
    ARM9opADClri      ,
    ARM9opADClrr      ,
    ARM9opADCari      ,
    ARM9opADCarr      ,
    ARM9opADCrri      ,
    ARM9opADCrrr      ,
    ARM9opADClli      ,
    ARM9opUMLAL       ,
    ARM9opADClri      ,
    ARM9opSTRHptrp    ,
    ARM9opADCari      ,
    ARM9opLDRDptrp    ,  // ++ARM5E
    ARM9opADCrri      ,
    ARM9opSTRDptrp    ,  // ++ARM5E

    /*0x0B*/
    ARM9opADCSlli     ,
    ARM9opADCSllr     ,
    ARM9opADCSlri     ,
    ARM9opADCSlrr     ,
    ARM9opADCSari     ,
    ARM9opADCSarr     ,
    ARM9opADCSrri     ,
    ARM9opADCSrrr     ,
    ARM9opADCSlli     ,
    ARM9opUMLALS      ,
    ARM9opADCSlri     ,
    ARM9opLDRHptrp    ,
    ARM9opADCSari     ,
    ARM9opLDRSBptrp   ,
    ARM9opADCSrri     ,
    ARM9opLDRSHptrp   ,

    /*0x0C*/
    ARM9opSBClli      ,
    ARM9opSBCllr      ,
    ARM9opSBClri      ,
    ARM9opSBClrr      ,
    ARM9opSBCari      ,
    ARM9opSBCarr      ,
    ARM9opSBCrri      ,
    ARM9opSBCrrr      ,
    ARM9opSBClli      ,
    ARM9opSMULL       ,
    ARM9opSBClri      ,
    ARM9opSTRHptip    ,
    ARM9opSBCari      ,
    ARM9opLDRDptip    ,  // ++ARM5E
    ARM9opSBCrri      ,
    ARM9opSTRDptip    ,  // ++ARM5E

    /*0x0D*/
    ARM9opSBCSlli     ,
    ARM9opSBCSllr     ,
    ARM9opSBCSlri     ,
    ARM9opSBCSlrr     ,
    ARM9opSBCSari     ,
    ARM9opSBCSarr     ,
    ARM9opSBCSrri     ,
    ARM9opSBCSrrr     ,
    ARM9opSBCSlli     ,
    ARM9opSMULLS      ,
    ARM9opSBCSlri     ,
    ARM9opLDRHptip    ,
    ARM9opSBCSari     ,
    ARM9opLDRSBptip   ,
    ARM9opSBCSrri     ,
    ARM9opLDRSHptip   ,

    /*0x0E*/
    ARM9opRSClli      ,
    ARM9opRSCllr      ,
    ARM9opRSClri      ,
    ARM9opRSClrr      ,
    ARM9opRSCari      ,
    ARM9opRSCarr      ,
    ARM9opRSCrri      ,
    ARM9opRSCrrr      ,
    ARM9opRSClli      ,
    ARM9opSMLAL       ,
    ARM9opRSClri      ,
    ARM9opSTRHptip    ,
    ARM9opRSCari      ,
    ARM9opLDRDptip    ,  // ++ARM5E
    ARM9opRSCrri      ,
    ARM9opSTRDptip    ,  // ++ARM5E

    /*0x0F*/
    ARM9opRSCSlli     ,
    ARM9opRSCSllr     ,
    ARM9opRSCSlri     ,
    ARM9opRSCSlrr     ,
    ARM9opRSCSari     ,
    ARM9opRSCSarr     ,
    ARM9opRSCSrri     ,
    ARM9opRSCSrrr     ,
    ARM9opRSCSlli     ,
    ARM9opSMLALS      ,
    ARM9opRSCSlri     ,
    ARM9opLDRHptip    ,
    ARM9opRSCSari     ,
    ARM9opLDRSBptip   ,
    ARM9opRSCSrri     ,
    ARM9opLDRSHptip   ,

    /*0x10*/
    ARM9opMRSrc       ,
    ARM9opUNP         ,  // MRS with non-zero 7-4
    ARM9opUNP         ,  // MRS with non-zero 7-4
    ARM9opUNP         ,  // MRS with non-zero 7-4
    ARM9opUNP         ,  // MRS with non-zero 7-4
    ARM9opQADD        ,  // ++ARM5E
    ARM9opUNP         ,  // MRS with non-zero 7-4
    ARM9opUNP         ,  // MRS with non-zero 7-4
    ARM9opSMLABB      ,  // ++ARM5E
    ARM9opSWP         ,
    ARM9opSMLATB      ,  // ++ARM5E
    ARM9opSTRHofrm    ,
    ARM9opSMLABT      ,  // ++ARM5E
    ARM9opLDRDofrm    ,  // ++ARM5E
    ARM9opSMLATT      ,  // ++ARM5E
    ARM9opSTRDofrm    ,  // ++ARM5E

    /*0x11*/
    ARM9opTSTSlli     ,
    ARM9opTSTSllr     ,
    ARM9opTSTSlri     ,
    ARM9opTSTSlrr     ,
    ARM9opTSTSari     ,
    ARM9opTSTSarr     ,
    ARM9opTSTSrri     ,
    ARM9opTSTSrrr     ,
    ARM9opTSTSlli     ,
    ARM9opUNP         ,  // Unallocated
    ARM9opTSTSlri     ,
    ARM9opLDRHofrm    ,
    ARM9opTSTSari     ,
    ARM9opLDRSBofrm   ,
    ARM9opTSTSrri     ,
    ARM9opLDRSHofrm   ,

    /*0x12*/
    ARM9opMSRrc       ,
    ARM9opBX          ,
    ARM9opUNP         ,  // Unallocated
    ARM9opBLXr        ,
    ARM9opUNP         ,  // Unallocated
    ARM9opUNP         ,  // Defined in ARM5E!
    ARM9opUNP         ,  // Unallocated
    ARM9opBKPT        ,  // ++ARM5
    ARM9opUNP         ,  // Defined in ARM5E!
    ARM9opUNP         ,  // Unallocated
    ARM9opUNP         ,  // Defined in ARM5E!
    ARM9opSTRHprrm    ,
    ARM9opUNP         ,  // Defined in ARM5E!
    ARM9opLDRDprrm    ,  // ++ARM5E
    ARM9opUNP         ,  // Defined in ARM5E!
    ARM9opSTRDprrm    ,  // ++ARM5E

    /*0x13*/
    ARM9opTEQSlli     ,
    ARM9opTEQSllr     ,
    ARM9opTEQSlri     ,
    ARM9opTEQSlrr     ,
    ARM9opTEQSari     ,
    ARM9opTEQSarr     ,
    ARM9opTEQSrri     ,
    ARM9opTEQSrrr     ,
    ARM9opTEQSlli     ,
    ARM9opUNP         ,  // Unallocated
    ARM9opTEQSlri     ,
    ARM9opLDRHprrm    ,
    ARM9opTEQSari     ,
    ARM9opLDRSBprrm   ,
    ARM9opTEQSrri     ,
    ARM9opLDRSHprrm   ,

    /*0x14*/
    ARM9opMRSrs       ,
    ARM9opUNP         ,  // Unallocated
    ARM9opUNP         ,  // Unallocated
    ARM9opUNP         ,  // Unallocated
    ARM9opUNP         ,  // Unallocated
    ARM9opUNP         ,  // Defined in ARM5E!
    ARM9opUNP         ,  // Unallocated
    ARM9opUNP         ,  // Unallocated
    ARM9opUNP         ,  // Defined in ARM5E!
    ARM9opSWPB        ,
    ARM9opUNP         ,  // Defined in ARM5E!
    ARM9opSTRHofim    ,
    ARM9opUNP         ,  // Defined in ARM5E!
    ARM9opLDRDofim    ,  // ++ARM5E
    ARM9opUNP         ,  // Defined in ARM5E!
    ARM9opSTRDofim    ,  // ++ARM5E

    /*0x15*/
    ARM9opCMPSlli     ,
    ARM9opCMPSllr     ,
    ARM9opCMPSlri     ,
    ARM9opCMPSlrr     ,
    ARM9opCMPSari     ,
    ARM9opCMPSarr     ,
    ARM9opCMPSrri     ,
    ARM9opCMPSrrr     ,
    ARM9opCMPSlli     ,
    ARM9opUNP         ,  // Unallocated
    ARM9opCMPSlri     ,
    ARM9opLDRHofim    ,
    ARM9opCMPSari     ,
    ARM9opLDRSBofim   ,
    ARM9opCMPSrri     ,
    ARM9opLDRSHofim   ,

    /*0x16*/
    ARM9opMSRrs       ,
    ARM9opCLZ         ,  // ++ARM5
    ARM9opUNP         ,  // Unallocated
    ARM9opUNP         ,  // Unallocated
    ARM9opUNP         ,  // Unallocated
    ARM9opUNP         ,  // Defined in ARM5E!
    ARM9opUNP         ,  // Unallocated
    ARM9opUNP         ,  // Unallocated
    ARM9opSMULBB      ,  // ++ARM5E
    ARM9opUNP         ,  // Unallocated
    ARM9opSMULTB      ,  // ++ARM5E
    ARM9opSTRHprim    ,
    ARM9opSMULBT      ,  // ++ARM5E
    ARM9opLDRDprim    ,  // ++ARM5E
    ARM9opSMULTT      ,  // ++ARM5E
    ARM9opSTRDprim    ,  // ++ARM5E

    /*0x17*/
    ARM9opCMNSlli     ,
    ARM9opCMNSllr     ,
    ARM9opCMNSlri     ,
    ARM9opCMNSlrr     ,
    ARM9opCMNSari     ,
    ARM9opCMNSarr     ,
    ARM9opCMNSrri     ,
    ARM9opCMNSrrr     ,
    ARM9opCMNSlli     ,
    ARM9opUNP         ,  // Unallocated
    ARM9opCMNSlri     ,
    ARM9opLDRHprim    ,
    ARM9opCMNSari     ,
    ARM9opLDRSBprim   ,
    ARM9opCMNSrri     ,
    ARM9opLDRSHprim   ,

    /*0x18*/
    ARM9opORRlli      ,
    ARM9opORRllr      ,
    ARM9opORRlri      ,
    ARM9opORRlrr      ,
    ARM9opORRari      ,
    ARM9opORRarr      ,
    ARM9opORRrri      ,
    ARM9opORRrrr      ,
    ARM9opORRlli      ,
    ARM9opUNP         ,  // Unallocated
    ARM9opORRlri      ,
    ARM9opSTRHofrp    ,
    ARM9opORRari      ,
    ARM9opLDRDofrp    ,  // ++ARM5E
    ARM9opORRrri      ,
    ARM9opSTRDofrp    ,  // ++ARM5E

    /*0x19*/
    ARM9opORRSlli     ,
    ARM9opORRSllr     ,
    ARM9opORRSlri     ,
    ARM9opORRSlrr     ,
    ARM9opORRSari     ,
    ARM9opORRSarr     ,
    ARM9opORRSrri     ,
    ARM9opORRSrrr     ,
    ARM9opORRSlli     ,
    ARM9opUNP         ,  // Unallocated
    ARM9opORRSlri     ,
    ARM9opLDRHofrp    ,
    ARM9opORRSari     ,
    ARM9opLDRSBofrp   ,
    ARM9opORRSrri     ,
    ARM9opLDRSHofrp   ,

    /*0x1A*/
    ARM9opMOVlli      ,
    ARM9opMOVllr      ,
    ARM9opMOVlri      ,
    ARM9opMOVlrr      ,
    ARM9opMOVari      ,
    ARM9opMOVarr      ,
    ARM9opMOVrri      ,
    ARM9opMOVrrr      ,
    ARM9opMOVlli      ,
    ARM9opUNP         ,  // Unallocated
    ARM9opMOVlri      ,
    ARM9opSTRHprrp    ,
    ARM9opMOVari      ,
    ARM9opLDRDprrp    ,  // ++ARM5E
    ARM9opMOVrri      ,
    ARM9opSTRDprrp    ,  // ++ARM5E

    /*0x1B*/
    ARM9opMOVSlli     ,
    ARM9opMOVSllr     ,
    ARM9opMOVSlri     ,
    ARM9opMOVSlrr     ,
    ARM9opMOVSari     ,
    ARM9opMOVSarr     ,
    ARM9opMOVSrri     ,
    ARM9opMOVSrrr     ,
    ARM9opMOVSlli     ,
    ARM9opUNP         ,  // Unallocated
    ARM9opMOVSlri     ,
    ARM9opLDRHprrp    ,
    ARM9opMOVSari     ,
    ARM9opLDRSBprrp   ,
    ARM9opMOVSrri     ,
    ARM9opLDRSHprrp   ,

    /*0x1C*/
    ARM9opBIClli      ,
    ARM9opBICllr      ,
    ARM9opBIClri      ,
    ARM9opBIClrr      ,
    ARM9opBICari      ,
    ARM9opBICarr      ,
    ARM9opBICrri      ,
    ARM9opBICrrr      ,
    ARM9opBIClli      ,
    ARM9opUNP         ,  // Unallocated
    ARM9opBIClri      ,
    ARM9opSTRHofip    ,
    ARM9opBICari      ,
    ARM9opLDRDofip    ,  // ++ARM5E
    ARM9opBICrri      ,
    ARM9opSTRDofip    ,  // ++ARM5E

    /*0x1D*/
    ARM9opBICSlli     ,
    ARM9opBICSllr     ,
    ARM9opBICSlri     ,
    ARM9opBICSlrr     ,
    ARM9opBICSari     ,
    ARM9opBICSarr     ,
    ARM9opBICSrri     ,
    ARM9opBICSrrr     ,
    ARM9opBICSlli     ,
    ARM9opUNP         ,  // Unallocated
    ARM9opBICSlri     ,
    ARM9opLDRHofip    ,
    ARM9opBICSari     ,
    ARM9opLDRSBofip   ,
    ARM9opBICSrri     ,
    ARM9opLDRSHofip   ,

    /*0x1E*/
    ARM9opMVNlli      ,
    ARM9opMVNllr      ,
    ARM9opMVNlri      ,
    ARM9opMVNlrr      ,
    ARM9opMVNari      ,
    ARM9opMVNarr      ,
    ARM9opMVNrri      ,
    ARM9opMVNrrr      ,
    ARM9opMVNlli      ,
    ARM9opUNP         ,  // Unallocated
    ARM9opMVNlri      ,
    ARM9opSTRHprip    ,
    ARM9opMVNari      ,
    ARM9opLDRDprip    ,  // ++ARM5E
    ARM9opMVNrri      ,
    ARM9opSTRDprip    ,  // ++ARM5E

    /*0x1F*/
    ARM9opMVNSlli     ,
    ARM9opMVNSllr     ,
    ARM9opMVNSlri     ,
    ARM9opMVNSlrr     ,
    ARM9opMVNSari     ,
    ARM9opMVNSarr     ,
    ARM9opMVNSrri     ,
    ARM9opMVNSrrr     ,
    ARM9opMVNSlli     ,
    ARM9opUNP         ,  // Unallocated
    ARM9opMVNSlri     ,
    ARM9opLDRHprip    ,
    ARM9opMVNSari     ,
    ARM9opLDRSBprip   ,
    ARM9opMVNSrri     ,
    ARM9opLDRSHprip   ,

    /*0x20*/
    ARM9opANDimm      ,
    ARM9opANDimm      ,
    ARM9opANDimm      ,
    ARM9opANDimm      ,
    ARM9opANDimm      ,
    ARM9opANDimm      ,
    ARM9opANDimm      ,
    ARM9opANDimm      ,
    ARM9opANDimm      ,
    ARM9opANDimm      ,
    ARM9opANDimm      ,
    ARM9opANDimm      ,
    ARM9opANDimm      ,
    ARM9opANDimm      ,
    ARM9opANDimm      ,
    ARM9opANDimm      ,

    /*0x21*/
    ARM9opANDSimm     ,
    ARM9opANDSimm     ,
    ARM9opANDSimm     ,
    ARM9opANDSimm     ,
    ARM9opANDSimm     ,
    ARM9opANDSimm     ,
    ARM9opANDSimm     ,
    ARM9opANDSimm     ,
    ARM9opANDSimm     ,
    ARM9opANDSimm     ,
    ARM9opANDSimm     ,
    ARM9opANDSimm     ,
    ARM9opANDSimm     ,
    ARM9opANDSimm     ,
    ARM9opANDSimm     ,
    ARM9opANDSimm     ,

    /*0x22*/
    ARM9opEORimm      ,
    ARM9opEORimm      ,
    ARM9opEORimm      ,
    ARM9opEORimm      ,
    ARM9opEORimm      ,
    ARM9opEORimm      ,
    ARM9opEORimm      ,
    ARM9opEORimm      ,
    ARM9opEORimm      ,
    ARM9opEORimm      ,
    ARM9opEORimm      ,
    ARM9opEORimm      ,
    ARM9opEORimm      ,
    ARM9opEORimm      ,
    ARM9opEORimm      ,
    ARM9opEORimm      ,

    /*0x23*/
    ARM9opEORSimm     ,
    ARM9opEORSimm     ,
    ARM9opEORSimm     ,
    ARM9opEORSimm     ,
    ARM9opEORSimm     ,
    ARM9opEORSimm     ,
    ARM9opEORSimm     ,
    ARM9opEORSimm     ,
    ARM9opEORSimm     ,
    ARM9opEORSimm     ,
    ARM9opEORSimm     ,
    ARM9opEORSimm     ,
    ARM9opEORSimm     ,
    ARM9opEORSimm     ,
    ARM9opEORSimm     ,
    ARM9opEORSimm     ,

    /*0x24*/
    ARM9opSUBimm      ,
    ARM9opSUBimm      ,
    ARM9opSUBimm      ,
    ARM9opSUBimm      ,
    ARM9opSUBimm      ,
    ARM9opSUBimm      ,
    ARM9opSUBimm      ,
    ARM9opSUBimm      ,
    ARM9opSUBimm      ,
    ARM9opSUBimm      ,
    ARM9opSUBimm      ,
    ARM9opSUBimm      ,
    ARM9opSUBimm      ,
    ARM9opSUBimm      ,
    ARM9opSUBimm      ,
    ARM9opSUBimm      ,

    /*0x25*/
    ARM9opSUBSimm     ,
    ARM9opSUBSimm     ,
    ARM9opSUBSimm     ,
    ARM9opSUBSimm     ,
    ARM9opSUBSimm     ,
    ARM9opSUBSimm     ,
    ARM9opSUBSimm     ,
    ARM9opSUBSimm     ,
    ARM9opSUBSimm     ,
    ARM9opSUBSimm     ,
    ARM9opSUBSimm     ,
    ARM9opSUBSimm     ,
    ARM9opSUBSimm     ,
    ARM9opSUBSimm     ,
    ARM9opSUBSimm     ,
    ARM9opSUBSimm     ,

    /*0x26*/
    ARM9opRSBimm      ,
    ARM9opRSBimm      ,
    ARM9opRSBimm      ,
    ARM9opRSBimm      ,
    ARM9opRSBimm      ,
    ARM9opRSBimm      ,
    ARM9opRSBimm      ,
    ARM9opRSBimm      ,
    ARM9opRSBimm      ,
    ARM9opRSBimm      ,
    ARM9opRSBimm      ,
    ARM9opRSBimm      ,
    ARM9opRSBimm      ,
    ARM9opRSBimm      ,
    ARM9opRSBimm      ,
    ARM9opRSBimm      ,

    /*0x27*/
    ARM9opRSBSimm     ,
    ARM9opRSBSimm     ,
    ARM9opRSBSimm     ,
    ARM9opRSBSimm     ,
    ARM9opRSBSimm     ,
    ARM9opRSBSimm     ,
    ARM9opRSBSimm     ,
    ARM9opRSBSimm     ,
    ARM9opRSBSimm     ,
    ARM9opRSBSimm     ,
    ARM9opRSBSimm     ,
    ARM9opRSBSimm     ,
    ARM9opRSBSimm     ,
    ARM9opRSBSimm     ,
    ARM9opRSBSimm     ,
    ARM9opRSBSimm     ,

    /*0x28*/
    ARM9opADDimm      ,
    ARM9opADDimm      ,
    ARM9opADDimm      ,
    ARM9opADDimm      ,
    ARM9opADDimm      ,
    ARM9opADDimm      ,
    ARM9opADDimm      ,
    ARM9opADDimm      ,
    ARM9opADDimm      ,
    ARM9opADDimm      ,
    ARM9opADDimm      ,
    ARM9opADDimm      ,
    ARM9opADDimm      ,
    ARM9opADDimm      ,
    ARM9opADDimm      ,
    ARM9opADDimm      ,

    /*0x29*/
    ARM9opADDSimm     ,
    ARM9opADDSimm     ,
    ARM9opADDSimm     ,
    ARM9opADDSimm     ,
    ARM9opADDSimm     ,
    ARM9opADDSimm     ,
    ARM9opADDSimm     ,
    ARM9opADDSimm     ,
    ARM9opADDSimm     ,
    ARM9opADDSimm     ,
    ARM9opADDSimm     ,
    ARM9opADDSimm     ,
    ARM9opADDSimm     ,
    ARM9opADDSimm     ,
    ARM9opADDSimm     ,
    ARM9opADDSimm     ,

    /*0x2A*/
    ARM9opADCimm      ,
    ARM9opADCimm      ,
    ARM9opADCimm      ,
    ARM9opADCimm      ,
    ARM9opADCimm      ,
    ARM9opADCimm      ,
    ARM9opADCimm      ,
    ARM9opADCimm      ,
    ARM9opADCimm      ,
    ARM9opADCimm      ,
    ARM9opADCimm      ,
    ARM9opADCimm      ,
    ARM9opADCimm      ,
    ARM9opADCimm      ,
    ARM9opADCimm      ,
    ARM9opADCimm      ,

    /*0x2B*/
    ARM9opADCSimm     ,
    ARM9opADCSimm     ,
    ARM9opADCSimm     ,
    ARM9opADCSimm     ,
    ARM9opADCSimm     ,
    ARM9opADCSimm     ,
    ARM9opADCSimm     ,
    ARM9opADCSimm     ,
    ARM9opADCSimm     ,
    ARM9opADCSimm     ,
    ARM9opADCSimm     ,
    ARM9opADCSimm     ,
    ARM9opADCSimm     ,
    ARM9opADCSimm     ,
    ARM9opADCSimm     ,
    ARM9opADCSimm     ,

    /*0x2C*/
    ARM9opSBCimm      ,
    ARM9opSBCimm      ,
    ARM9opSBCimm      ,
    ARM9opSBCimm      ,
    ARM9opSBCimm      ,
    ARM9opSBCimm      ,
    ARM9opSBCimm      ,
    ARM9opSBCimm      ,
    ARM9opSBCimm      ,
    ARM9opSBCimm      ,
    ARM9opSBCimm      ,
    ARM9opSBCimm      ,
    ARM9opSBCimm      ,
    ARM9opSBCimm      ,
    ARM9opSBCimm      ,
    ARM9opSBCimm      ,

    /*0x2D*/
    ARM9opSBCSimm     ,
    ARM9opSBCSimm     ,
    ARM9opSBCSimm     ,
    ARM9opSBCSimm     ,
    ARM9opSBCSimm     ,
    ARM9opSBCSimm     ,
    ARM9opSBCSimm     ,
    ARM9opSBCSimm     ,
    ARM9opSBCSimm     ,
    ARM9opSBCSimm     ,
    ARM9opSBCSimm     ,
    ARM9opSBCSimm     ,
    ARM9opSBCSimm     ,
    ARM9opSBCSimm     ,
    ARM9opSBCSimm     ,
    ARM9opSBCSimm     ,

    /*0x2E*/
    ARM9opRSCimm      ,
    ARM9opRSCimm      ,
    ARM9opRSCimm      ,
    ARM9opRSCimm      ,
    ARM9opRSCimm      ,
    ARM9opRSCimm      ,
    ARM9opRSCimm      ,
    ARM9opRSCimm      ,
    ARM9opRSCimm      ,
    ARM9opRSCimm      ,
    ARM9opRSCimm      ,
    ARM9opRSCimm      ,
    ARM9opRSCimm      ,
    ARM9opRSCimm      ,
    ARM9opRSCimm      ,
    ARM9opRSCimm      ,

    /*0x2F*/
    ARM9opRSCSimm     ,
    ARM9opRSCSimm     ,
    ARM9opRSCSimm     ,
    ARM9opRSCSimm     ,
    ARM9opRSCSimm     ,
    ARM9opRSCSimm     ,
    ARM9opRSCSimm     ,
    ARM9opRSCSimm     ,
    ARM9opRSCSimm     ,
    ARM9opRSCSimm     ,
    ARM9opRSCSimm     ,
    ARM9opRSCSimm     ,
    ARM9opRSCSimm     ,
    ARM9opRSCSimm     ,
    ARM9opRSCSimm     ,
    ARM9opRSCSimm     ,

    /*0x30*/
    ARM9opUND         ,
    ARM9opUND         ,
    ARM9opUND         ,
    ARM9opUND         ,
    ARM9opUND         ,
    ARM9opUND         ,
    ARM9opUND         ,
    ARM9opUND         ,
    ARM9opUND         ,
    ARM9opUND         ,
    ARM9opUND         ,
    ARM9opUND         ,
    ARM9opUND         ,
    ARM9opUND         ,
    ARM9opUND         ,
    ARM9opUND         ,

    /*0x31*/
    ARM9opTSTSimm     ,
    ARM9opTSTSimm     ,
    ARM9opTSTSimm     ,
    ARM9opTSTSimm     ,
    ARM9opTSTSimm     ,
    ARM9opTSTSimm     ,
    ARM9opTSTSimm     ,
    ARM9opTSTSimm     ,
    ARM9opTSTSimm     ,
    ARM9opTSTSimm     ,
    ARM9opTSTSimm     ,
    ARM9opTSTSimm     ,
    ARM9opTSTSimm     ,
    ARM9opTSTSimm     ,
    ARM9opTSTSimm     ,
    ARM9opTSTSimm     ,

    /*0x32*/
    ARM9opMSRic       ,
    ARM9opMSRic       ,
    ARM9opMSRic       ,
    ARM9opMSRic       ,
    ARM9opMSRic       ,
    ARM9opMSRic       ,
    ARM9opMSRic       ,
    ARM9opMSRic       ,
    ARM9opMSRic       ,
    ARM9opMSRic       ,
    ARM9opMSRic       ,
    ARM9opMSRic       ,
    ARM9opMSRic       ,
    ARM9opMSRic       ,
    ARM9opMSRic       ,
    ARM9opMSRic       ,

    /*0x33*/
    ARM9opTEQSimm     ,
    ARM9opTEQSimm     ,
    ARM9opTEQSimm     ,
    ARM9opTEQSimm     ,
    ARM9opTEQSimm     ,
    ARM9opTEQSimm     ,
    ARM9opTEQSimm     ,
    ARM9opTEQSimm     ,
    ARM9opTEQSimm     ,
    ARM9opTEQSimm     ,
    ARM9opTEQSimm     ,
    ARM9opTEQSimm     ,
    ARM9opTEQSimm     ,
    ARM9opTEQSimm     ,
    ARM9opTEQSimm     ,
    ARM9opTEQSimm     ,

    /*0x34*/
    ARM9opUND         ,
    ARM9opUND         ,
    ARM9opUND         ,
    ARM9opUND         ,
    ARM9opUND         ,
    ARM9opUND         ,
    ARM9opUND         ,
    ARM9opUND         ,
    ARM9opUND         ,
    ARM9opUND         ,
    ARM9opUND         ,
    ARM9opUND         ,
    ARM9opUND         ,
    ARM9opUND         ,
    ARM9opUND         ,
    ARM9opUND         ,

    /*0x35*/
    ARM9opCMPSimm     ,
    ARM9opCMPSimm     ,
    ARM9opCMPSimm     ,
    ARM9opCMPSimm     ,
    ARM9opCMPSimm     ,
    ARM9opCMPSimm     ,
    ARM9opCMPSimm     ,
    ARM9opCMPSimm     ,
    ARM9opCMPSimm     ,
    ARM9opCMPSimm     ,
    ARM9opCMPSimm     ,
    ARM9opCMPSimm     ,
    ARM9opCMPSimm     ,
    ARM9opCMPSimm     ,
    ARM9opCMPSimm     ,
    ARM9opCMPSimm     ,

    /*0x36*/
    ARM9opMSRis       ,
    ARM9opMSRis       ,
    ARM9opMSRis       ,
    ARM9opMSRis       ,
    ARM9opMSRis       ,
    ARM9opMSRis       ,
    ARM9opMSRis       ,
    ARM9opMSRis       ,
    ARM9opMSRis       ,
    ARM9opMSRis       ,
    ARM9opMSRis       ,
    ARM9opMSRis       ,
    ARM9opMSRis       ,
    ARM9opMSRis       ,
    ARM9opMSRis       ,
    ARM9opMSRis       ,

    /*0x37*/
    ARM9opCMNSimm     ,
    ARM9opCMNSimm     ,
    ARM9opCMNSimm     ,
    ARM9opCMNSimm     ,
    ARM9opCMNSimm     ,
    ARM9opCMNSimm     ,
    ARM9opCMNSimm     ,
    ARM9opCMNSimm     ,
    ARM9opCMNSimm     ,
    ARM9opCMNSimm     ,
    ARM9opCMNSimm     ,
    ARM9opCMNSimm     ,
    ARM9opCMNSimm     ,
    ARM9opCMNSimm     ,
    ARM9opCMNSimm     ,
    ARM9opCMNSimm     ,

    /*0x38*/
    ARM9opORRimm      ,
    ARM9opORRimm      ,
    ARM9opORRimm      ,
    ARM9opORRimm      ,
    ARM9opORRimm      ,
    ARM9opORRimm      ,
    ARM9opORRimm      ,
    ARM9opORRimm      ,
    ARM9opORRimm      ,
    ARM9opORRimm      ,
    ARM9opORRimm      ,
    ARM9opORRimm      ,
    ARM9opORRimm      ,
    ARM9opORRimm      ,
    ARM9opORRimm      ,
    ARM9opORRimm      ,

    /*0x39*/
    ARM9opORRSimm     ,
    ARM9opORRSimm     ,
    ARM9opORRSimm     ,
    ARM9opORRSimm     ,
    ARM9opORRSimm     ,
    ARM9opORRSimm     ,
    ARM9opORRSimm     ,
    ARM9opORRSimm     ,
    ARM9opORRSimm     ,
    ARM9opORRSimm     ,
    ARM9opORRSimm     ,
    ARM9opORRSimm     ,
    ARM9opORRSimm     ,
    ARM9opORRSimm     ,
    ARM9opORRSimm     ,
    ARM9opORRSimm     ,

    /*0x3A*/
    ARM9opMOVimm      ,
    ARM9opMOVimm      ,
    ARM9opMOVimm      ,
    ARM9opMOVimm      ,
    ARM9opMOVimm      ,
    ARM9opMOVimm      ,
    ARM9opMOVimm      ,
    ARM9opMOVimm      ,
    ARM9opMOVimm      ,
    ARM9opMOVimm      ,
    ARM9opMOVimm      ,
    ARM9opMOVimm      ,
    ARM9opMOVimm      ,
    ARM9opMOVimm      ,
    ARM9opMOVimm      ,
    ARM9opMOVimm      ,

    /*0x3B*/
    ARM9opMOVSimm     ,
    ARM9opMOVSimm     ,
    ARM9opMOVSimm     ,
    ARM9opMOVSimm     ,
    ARM9opMOVSimm     ,
    ARM9opMOVSimm     ,
    ARM9opMOVSimm     ,
    ARM9opMOVSimm     ,
    ARM9opMOVSimm     ,
    ARM9opMOVSimm     ,
    ARM9opMOVSimm     ,
    ARM9opMOVSimm     ,
    ARM9opMOVSimm     ,
    ARM9opMOVSimm     ,
    ARM9opMOVSimm     ,
    ARM9opMOVSimm     ,

    /*0x3C*/
    ARM9opBICimm      ,
    ARM9opBICimm      ,
    ARM9opBICimm      ,
    ARM9opBICimm      ,
    ARM9opBICimm      ,
    ARM9opBICimm      ,
    ARM9opBICimm      ,
    ARM9opBICimm      ,
    ARM9opBICimm      ,
    ARM9opBICimm      ,
    ARM9opBICimm      ,
    ARM9opBICimm      ,
    ARM9opBICimm      ,
    ARM9opBICimm      ,
    ARM9opBICimm      ,
    ARM9opBICimm      ,

    /*0x3D*/
    ARM9opBICSimm     ,
    ARM9opBICSimm     ,
    ARM9opBICSimm     ,
    ARM9opBICSimm     ,
    ARM9opBICSimm     ,
    ARM9opBICSimm     ,
    ARM9opBICSimm     ,
    ARM9opBICSimm     ,
    ARM9opBICSimm     ,
    ARM9opBICSimm     ,
    ARM9opBICSimm     ,
    ARM9opBICSimm     ,
    ARM9opBICSimm     ,
    ARM9opBICSimm     ,
    ARM9opBICSimm     ,
    ARM9opBICSimm     ,

    /*0x3E*/
    ARM9opMVNimm      ,
    ARM9opMVNimm      ,
    ARM9opMVNimm      ,
    ARM9opMVNimm      ,
    ARM9opMVNimm      ,
    ARM9opMVNimm      ,
    ARM9opMVNimm      ,
    ARM9opMVNimm      ,
    ARM9opMVNimm      ,
    ARM9opMVNimm      ,
    ARM9opMVNimm      ,
    ARM9opMVNimm      ,
    ARM9opMVNimm      ,
    ARM9opMVNimm      ,
    ARM9opMVNimm      ,
    ARM9opMVNimm      ,

    /*0x3F*/
    ARM9opMVNSimm     ,
    ARM9opMVNSimm     ,
    ARM9opMVNSimm     ,
    ARM9opMVNSimm     ,
    ARM9opMVNSimm     ,
    ARM9opMVNSimm     ,
    ARM9opMVNSimm     ,
    ARM9opMVNSimm     ,
    ARM9opMVNSimm     ,
    ARM9opMVNSimm     ,
    ARM9opMVNSimm     ,
    ARM9opMVNSimm     ,
    ARM9opMVNSimm     ,
    ARM9opMVNSimm     ,
    ARM9opMVNSimm     ,
    ARM9opMVNSimm     ,

    /*0x40*/
    ARM9opSTRptim     ,
    ARM9opSTRptim     ,
    ARM9opSTRptim     ,
    ARM9opSTRptim     ,
    ARM9opSTRptim     ,
    ARM9opSTRptim     ,
    ARM9opSTRptim     ,
    ARM9opSTRptim     ,
    ARM9opSTRptim     ,
    ARM9opSTRptim     ,
    ARM9opSTRptim     ,
    ARM9opSTRptim     ,
    ARM9opSTRptim     ,
    ARM9opSTRptim     ,
    ARM9opSTRptim     ,
    ARM9opSTRptim     ,

    /*0x41*/
    ARM9opLDRptim     ,
    ARM9opLDRptim     ,
    ARM9opLDRptim     ,
    ARM9opLDRptim     ,
    ARM9opLDRptim     ,
    ARM9opLDRptim     ,
    ARM9opLDRptim     ,
    ARM9opLDRptim     ,
    ARM9opLDRptim     ,
    ARM9opLDRptim     ,
    ARM9opLDRptim     ,
    ARM9opLDRptim     ,
    ARM9opLDRptim     ,
    ARM9opLDRptim     ,
    ARM9opLDRptim     ,
    ARM9opLDRptim     ,

    /*0x42*/
    ARM9opSTRTptim    ,
    ARM9opSTRTptim    ,
    ARM9opSTRTptim    ,
    ARM9opSTRTptim    ,
    ARM9opSTRTptim    ,
    ARM9opSTRTptim    ,
    ARM9opSTRTptim    ,
    ARM9opSTRTptim    ,
    ARM9opSTRTptim    ,
    ARM9opSTRTptim    ,
    ARM9opSTRTptim    ,
    ARM9opSTRTptim    ,
    ARM9opSTRTptim    ,
    ARM9opSTRTptim    ,
    ARM9opSTRTptim    ,
    ARM9opSTRTptim    ,

    /*0x43*/
    ARM9opLDRTptim    ,
    ARM9opLDRTptim    ,
    ARM9opLDRTptim    ,
    ARM9opLDRTptim    ,
    ARM9opLDRTptim    ,
    ARM9opLDRTptim    ,
    ARM9opLDRTptim    ,
    ARM9opLDRTptim    ,
    ARM9opLDRTptim    ,
    ARM9opLDRTptim    ,
    ARM9opLDRTptim    ,
    ARM9opLDRTptim    ,
    ARM9opLDRTptim    ,
    ARM9opLDRTptim    ,
    ARM9opLDRTptim    ,
    ARM9opLDRTptim    ,

    /*0x44*/
    ARM9opSTRBptim    ,
    ARM9opSTRBptim    ,
    ARM9opSTRBptim    ,
    ARM9opSTRBptim    ,
    ARM9opSTRBptim    ,
    ARM9opSTRBptim    ,
    ARM9opSTRBptim    ,
    ARM9opSTRBptim    ,
    ARM9opSTRBptim    ,
    ARM9opSTRBptim    ,
    ARM9opSTRBptim    ,
    ARM9opSTRBptim    ,
    ARM9opSTRBptim    ,
    ARM9opSTRBptim    ,
    ARM9opSTRBptim    ,
    ARM9opSTRBptim    ,

    /*0x45*/
    ARM9opLDRBptim    ,
    ARM9opLDRBptim    ,
    ARM9opLDRBptim    ,
    ARM9opLDRBptim    ,
    ARM9opLDRBptim    ,
    ARM9opLDRBptim    ,
    ARM9opLDRBptim    ,
    ARM9opLDRBptim    ,
    ARM9opLDRBptim    ,
    ARM9opLDRBptim    ,
    ARM9opLDRBptim    ,
    ARM9opLDRBptim    ,
    ARM9opLDRBptim    ,
    ARM9opLDRBptim    ,
    ARM9opLDRBptim    ,
    ARM9opLDRBptim    ,

    /*0x46*/
    ARM9opSTRBTptim   ,
    ARM9opSTRBTptim   ,
    ARM9opSTRBTptim   ,
    ARM9opSTRBTptim   ,
    ARM9opSTRBTptim   ,
    ARM9opSTRBTptim   ,
    ARM9opSTRBTptim   ,
    ARM9opSTRBTptim   ,
    ARM9opSTRBTptim   ,
    ARM9opSTRBTptim   ,
    ARM9opSTRBTptim   ,
    ARM9opSTRBTptim   ,
    ARM9opSTRBTptim   ,
    ARM9opSTRBTptim   ,
    ARM9opSTRBTptim   ,
    ARM9opSTRBTptim   ,

    /*0x47*/
    ARM9opLDRBTptim   ,
    ARM9opLDRBTptim   ,
    ARM9opLDRBTptim   ,
    ARM9opLDRBTptim   ,
    ARM9opLDRBTptim   ,
    ARM9opLDRBTptim   ,
    ARM9opLDRBTptim   ,
    ARM9opLDRBTptim   ,
    ARM9opLDRBTptim   ,
    ARM9opLDRBTptim   ,
    ARM9opLDRBTptim   ,
    ARM9opLDRBTptim   ,
    ARM9opLDRBTptim   ,
    ARM9opLDRBTptim   ,
    ARM9opLDRBTptim   ,
    ARM9opLDRBTptim   ,

    /*0x48*/
    ARM9opSTRptip     ,
    ARM9opSTRptip     ,
    ARM9opSTRptip     ,
    ARM9opSTRptip     ,
    ARM9opSTRptip     ,
    ARM9opSTRptip     ,
    ARM9opSTRptip     ,
    ARM9opSTRptip     ,
    ARM9opSTRptip     ,
    ARM9opSTRptip     ,
    ARM9opSTRptip     ,
    ARM9opSTRptip     ,
    ARM9opSTRptip     ,
    ARM9opSTRptip     ,
    ARM9opSTRptip     ,
    ARM9opSTRptip     ,

    /*0x49*/
    ARM9opLDRptip     ,
    ARM9opLDRptip     ,
    ARM9opLDRptip     ,
    ARM9opLDRptip     ,
    ARM9opLDRptip     ,
    ARM9opLDRptip     ,
    ARM9opLDRptip     ,
    ARM9opLDRptip     ,
    ARM9opLDRptip     ,
    ARM9opLDRptip     ,
    ARM9opLDRptip     ,
    ARM9opLDRptip     ,
    ARM9opLDRptip     ,
    ARM9opLDRptip     ,
    ARM9opLDRptip     ,
    ARM9opLDRptip     ,

    /*0x4A*/
    ARM9opSTRTptip    ,
    ARM9opSTRTptip    ,
    ARM9opSTRTptip    ,
    ARM9opSTRTptip    ,
    ARM9opSTRTptip    ,
    ARM9opSTRTptip    ,
    ARM9opSTRTptip    ,
    ARM9opSTRTptip    ,
    ARM9opSTRTptip    ,
    ARM9opSTRTptip    ,
    ARM9opSTRTptip    ,
    ARM9opSTRTptip    ,
    ARM9opSTRTptip    ,
    ARM9opSTRTptip    ,
    ARM9opSTRTptip    ,
    ARM9opSTRTptip    ,

    /*0x4B*/
    ARM9opLDRTptip    ,
    ARM9opLDRTptip    ,
    ARM9opLDRTptip    ,
    ARM9opLDRTptip    ,
    ARM9opLDRTptip    ,
    ARM9opLDRTptip    ,
    ARM9opLDRTptip    ,
    ARM9opLDRTptip    ,
    ARM9opLDRTptip    ,
    ARM9opLDRTptip    ,
    ARM9opLDRTptip    ,
    ARM9opLDRTptip    ,
    ARM9opLDRTptip    ,
    ARM9opLDRTptip    ,
    ARM9opLDRTptip    ,
    ARM9opLDRTptip    ,

    /*0x4C*/
    ARM9opSTRBptip    ,
    ARM9opSTRBptip    ,
    ARM9opSTRBptip    ,
    ARM9opSTRBptip    ,
    ARM9opSTRBptip    ,
    ARM9opSTRBptip    ,
    ARM9opSTRBptip    ,
    ARM9opSTRBptip    ,
    ARM9opSTRBptip    ,
    ARM9opSTRBptip    ,
    ARM9opSTRBptip    ,
    ARM9opSTRBptip    ,
    ARM9opSTRBptip    ,
    ARM9opSTRBptip    ,
    ARM9opSTRBptip    ,
    ARM9opSTRBptip    ,

    /*0x4D*/
    ARM9opLDRBptip    ,
    ARM9opLDRBptip    ,
    ARM9opLDRBptip    ,
    ARM9opLDRBptip    ,
    ARM9opLDRBptip    ,
    ARM9opLDRBptip    ,
    ARM9opLDRBptip    ,
    ARM9opLDRBptip    ,
    ARM9opLDRBptip    ,
    ARM9opLDRBptip    ,
    ARM9opLDRBptip    ,
    ARM9opLDRBptip    ,
    ARM9opLDRBptip    ,
    ARM9opLDRBptip    ,
    ARM9opLDRBptip    ,
    ARM9opLDRBptip    ,

    /*0x4E*/
    ARM9opSTRBTptip   ,
    ARM9opSTRBTptip   ,
    ARM9opSTRBTptip   ,
    ARM9opSTRBTptip   ,
    ARM9opSTRBTptip   ,
    ARM9opSTRBTptip   ,
    ARM9opSTRBTptip   ,
    ARM9opSTRBTptip   ,
    ARM9opSTRBTptip   ,
    ARM9opSTRBTptip   ,
    ARM9opSTRBTptip   ,
    ARM9opSTRBTptip   ,
    ARM9opSTRBTptip   ,
    ARM9opSTRBTptip   ,
    ARM9opSTRBTptip   ,
    ARM9opSTRBTptip   ,

    /*0x4F*/
    ARM9opLDRBTptip   ,
    ARM9opLDRBTptip   ,
    ARM9opLDRBTptip   ,
    ARM9opLDRBTptip   ,
    ARM9opLDRBTptip   ,
    ARM9opLDRBTptip   ,
    ARM9opLDRBTptip   ,
    ARM9opLDRBTptip   ,
    ARM9opLDRBTptip   ,
    ARM9opLDRBTptip   ,
    ARM9opLDRBTptip   ,
    ARM9opLDRBTptip   ,
    ARM9opLDRBTptip   ,
    ARM9opLDRBTptip   ,
    ARM9opLDRBTptip   ,
    ARM9opLDRBTptip   ,

    /*0x50*/
    ARM9opSTRofim     ,
    ARM9opSTRofim     ,
    ARM9opSTRofim     ,
    ARM9opSTRofim     ,
    ARM9opSTRofim     ,
    ARM9opSTRofim     ,
    ARM9opSTRofim     ,
    ARM9opSTRofim     ,
    ARM9opSTRofim     ,
    ARM9opSTRofim     ,
    ARM9opSTRofim     ,
    ARM9opSTRofim     ,
    ARM9opSTRofim     ,
    ARM9opSTRofim     ,
    ARM9opSTRofim     ,
    ARM9opSTRofim     ,

    /*0x51*/
    ARM9opLDRofim     ,
    ARM9opLDRofim     ,
    ARM9opLDRofim     ,
    ARM9opLDRofim     ,
    ARM9opLDRofim     ,
    ARM9opLDRofim     ,
    ARM9opLDRofim     ,
    ARM9opLDRofim     ,
    ARM9opLDRofim     ,
    ARM9opLDRofim     ,
    ARM9opLDRofim     ,
    ARM9opLDRofim     ,
    ARM9opLDRofim     ,
    ARM9opLDRofim     ,
    ARM9opLDRofim     ,
    ARM9opLDRofim     ,

    /*0x52*/
    ARM9opSTRprim     ,
    ARM9opSTRprim     ,
    ARM9opSTRprim     ,
    ARM9opSTRprim     ,
    ARM9opSTRprim     ,
    ARM9opSTRprim     ,
    ARM9opSTRprim     ,
    ARM9opSTRprim     ,
    ARM9opSTRprim     ,
    ARM9opSTRprim     ,
    ARM9opSTRprim     ,
    ARM9opSTRprim     ,
    ARM9opSTRprim     ,
    ARM9opSTRprim     ,
    ARM9opSTRprim     ,
    ARM9opSTRprim     ,

    /*0x53*/
    ARM9opLDRprim     ,
    ARM9opLDRprim     ,
    ARM9opLDRprim     ,
    ARM9opLDRprim     ,
    ARM9opLDRprim     ,
    ARM9opLDRprim     ,
    ARM9opLDRprim     ,
    ARM9opLDRprim     ,
    ARM9opLDRprim     ,
    ARM9opLDRprim     ,
    ARM9opLDRprim     ,
    ARM9opLDRprim     ,
    ARM9opLDRprim     ,
    ARM9opLDRprim     ,
    ARM9opLDRprim     ,
    ARM9opLDRprim     ,

    /*0x54*/
    ARM9opSTRBofim    ,
    ARM9opSTRBofim    ,
    ARM9opSTRBofim    ,
    ARM9opSTRBofim    ,
    ARM9opSTRBofim    ,
    ARM9opSTRBofim    ,
    ARM9opSTRBofim    ,
    ARM9opSTRBofim    ,
    ARM9opSTRBofim    ,
    ARM9opSTRBofim    ,
    ARM9opSTRBofim    ,
    ARM9opSTRBofim    ,
    ARM9opSTRBofim    ,
    ARM9opSTRBofim    ,
    ARM9opSTRBofim    ,
    ARM9opSTRBofim    ,

    /*0x55*/
    ARM9opLDRBofim    ,
    ARM9opLDRBofim    ,
    ARM9opLDRBofim    ,
    ARM9opLDRBofim    ,
    ARM9opLDRBofim    ,
    ARM9opLDRBofim    ,
    ARM9opLDRBofim    ,
    ARM9opLDRBofim    ,
    ARM9opLDRBofim    ,
    ARM9opLDRBofim    ,
    ARM9opLDRBofim    ,
    ARM9opLDRBofim    ,
    ARM9opLDRBofim    ,
    ARM9opLDRBofim    ,
    ARM9opLDRBofim    ,
    ARM9opLDRBofim    ,

    /*0x56*/
    ARM9opSTRBprim    ,
    ARM9opSTRBprim    ,
    ARM9opSTRBprim    ,
    ARM9opSTRBprim    ,
    ARM9opSTRBprim    ,
    ARM9opSTRBprim    ,
    ARM9opSTRBprim    ,
    ARM9opSTRBprim    ,
    ARM9opSTRBprim    ,
    ARM9opSTRBprim    ,
    ARM9opSTRBprim    ,
    ARM9opSTRBprim    ,
    ARM9opSTRBprim    ,
    ARM9opSTRBprim    ,
    ARM9opSTRBprim    ,
    ARM9opSTRBprim    ,

    /*0x57*/
    ARM9opLDRBprim    ,
    ARM9opLDRBprim    ,
    ARM9opLDRBprim    ,
    ARM9opLDRBprim    ,
    ARM9opLDRBprim    ,
    ARM9opLDRBprim    ,
    ARM9opLDRBprim    ,
    ARM9opLDRBprim    ,
    ARM9opLDRBprim    ,
    ARM9opLDRBprim    ,
    ARM9opLDRBprim    ,
    ARM9opLDRBprim    ,
    ARM9opLDRBprim    ,
    ARM9opLDRBprim    ,
    ARM9opLDRBprim    ,
    ARM9opLDRBprim    ,

    /*0x58*/
    ARM9opSTRofip     ,
    ARM9opSTRofip     ,
    ARM9opSTRofip     ,
    ARM9opSTRofip     ,
    ARM9opSTRofip     ,
    ARM9opSTRofip     ,
    ARM9opSTRofip     ,
    ARM9opSTRofip     ,
    ARM9opSTRofip     ,
    ARM9opSTRofip     ,
    ARM9opSTRofip     ,
    ARM9opSTRofip     ,
    ARM9opSTRofip     ,
    ARM9opSTRofip     ,
    ARM9opSTRofip     ,
    ARM9opSTRofip     ,

    /*0x59*/
    ARM9opLDRofip     ,
    ARM9opLDRofip     ,
    ARM9opLDRofip     ,
    ARM9opLDRofip     ,
    ARM9opLDRofip     ,
    ARM9opLDRofip     ,
    ARM9opLDRofip     ,
    ARM9opLDRofip     ,
    ARM9opLDRofip     ,
    ARM9opLDRofip     ,
    ARM9opLDRofip     ,
    ARM9opLDRofip     ,
    ARM9opLDRofip     ,
    ARM9opLDRofip     ,
    ARM9opLDRofip     ,
    ARM9opLDRofip     ,

    /*0x5A*/
    ARM9opSTRprip     ,
    ARM9opSTRprip     ,
    ARM9opSTRprip     ,
    ARM9opSTRprip     ,
    ARM9opSTRprip     ,
    ARM9opSTRprip     ,
    ARM9opSTRprip     ,
    ARM9opSTRprip     ,
    ARM9opSTRprip     ,
    ARM9opSTRprip     ,
    ARM9opSTRprip     ,
    ARM9opSTRprip     ,
    ARM9opSTRprip     ,
    ARM9opSTRprip     ,
    ARM9opSTRprip     ,
    ARM9opSTRprip     ,

    /*0x5B*/
    ARM9opLDRprip     ,
    ARM9opLDRprip     ,
    ARM9opLDRprip     ,
    ARM9opLDRprip     ,
    ARM9opLDRprip     ,
    ARM9opLDRprip     ,
    ARM9opLDRprip     ,
    ARM9opLDRprip     ,
    ARM9opLDRprip     ,
    ARM9opLDRprip     ,
    ARM9opLDRprip     ,
    ARM9opLDRprip     ,
    ARM9opLDRprip     ,
    ARM9opLDRprip     ,
    ARM9opLDRprip     ,
    ARM9opLDRprip     ,

    /*0x5C*/
    ARM9opSTRBofip    ,
    ARM9opSTRBofip    ,
    ARM9opSTRBofip    ,
    ARM9opSTRBofip    ,
    ARM9opSTRBofip    ,
    ARM9opSTRBofip    ,
    ARM9opSTRBofip    ,
    ARM9opSTRBofip    ,
    ARM9opSTRBofip    ,
    ARM9opSTRBofip    ,
    ARM9opSTRBofip    ,
    ARM9opSTRBofip    ,
    ARM9opSTRBofip    ,
    ARM9opSTRBofip    ,
    ARM9opSTRBofip    ,
    ARM9opSTRBofip    ,

    /*0x5D*/
    ARM9opLDRBofip    ,
    ARM9opLDRBofip    ,
    ARM9opLDRBofip    ,
    ARM9opLDRBofip    ,
    ARM9opLDRBofip    ,
    ARM9opLDRBofip    ,
    ARM9opLDRBofip    ,
    ARM9opLDRBofip    ,
    ARM9opLDRBofip    ,
    ARM9opLDRBofip    ,
    ARM9opLDRBofip    ,
    ARM9opLDRBofip    ,
    ARM9opLDRBofip    ,
    ARM9opLDRBofip    ,
    ARM9opLDRBofip    ,
    ARM9opLDRBofip    ,

    /*0x5E*/
    ARM9opSTRBprip    ,
    ARM9opSTRBprip    ,
    ARM9opSTRBprip    ,
    ARM9opSTRBprip    ,
    ARM9opSTRBprip    ,
    ARM9opSTRBprip    ,
    ARM9opSTRBprip    ,
    ARM9opSTRBprip    ,
    ARM9opSTRBprip    ,
    ARM9opSTRBprip    ,
    ARM9opSTRBprip    ,
    ARM9opSTRBprip    ,
    ARM9opSTRBprip    ,
    ARM9opSTRBprip    ,
    ARM9opSTRBprip    ,
    ARM9opSTRBprip    ,

    /*0x5F*/
    ARM9opLDRBprip    ,
    ARM9opLDRBprip    ,
    ARM9opLDRBprip    ,
    ARM9opLDRBprip    ,
    ARM9opLDRBprip    ,
    ARM9opLDRBprip    ,
    ARM9opLDRBprip    ,
    ARM9opLDRBprip    ,
    ARM9opLDRBprip    ,
    ARM9opLDRBprip    ,
    ARM9opLDRBprip    ,
    ARM9opLDRBprip    ,
    ARM9opLDRBprip    ,
    ARM9opLDRBprip    ,
    ARM9opLDRBprip    ,
    ARM9opLDRBprip    ,

    /*0x60*/
    ARM9opSTRptrmll   ,
    ARM9opUND         ,
    ARM9opSTRptrmlr   ,
    ARM9opUND         ,
    ARM9opSTRptrmar   ,
    ARM9opUND         ,
    ARM9opSTRptrmrr   ,
    ARM9opUND         ,
    ARM9opSTRptrmll   ,
    ARM9opUND         ,
    ARM9opSTRptrmlr   ,
    ARM9opUND         ,
    ARM9opSTRptrmar   ,
    ARM9opUND         ,
    ARM9opSTRptrmrr   ,
    ARM9opUND         ,

    /*0x61*/
    ARM9opLDRptrmll   ,
    ARM9opUND         ,
    ARM9opLDRptrmlr   ,
    ARM9opUND         ,
    ARM9opLDRptrmar   ,
    ARM9opUND         ,
    ARM9opLDRptrmrr   ,
    ARM9opUND         ,
    ARM9opLDRptrmll   ,
    ARM9opUND         ,
    ARM9opLDRptrmlr   ,
    ARM9opUND         ,
    ARM9opLDRptrmar   ,
    ARM9opUND         ,
    ARM9opLDRptrmrr   ,
    ARM9opUND         ,

    /*0x62*/
    ARM9opSTRTptrmll  ,
    ARM9opUND         ,
    ARM9opSTRTptrmlr  ,
    ARM9opUND         ,
    ARM9opSTRTptrmar  ,
    ARM9opUND         ,
    ARM9opSTRTptrmrr  ,
    ARM9opUND         ,
    ARM9opSTRTptrmll  ,
    ARM9opUND         ,
    ARM9opSTRTptrmlr  ,
    ARM9opUND         ,
    ARM9opSTRTptrmar  ,
    ARM9opUND         ,
    ARM9opSTRTptrmrr  ,
    ARM9opUND         ,

    /*0x63*/
    ARM9opLDRTptrmll  ,
    ARM9opUND         ,
    ARM9opLDRTptrmlr  ,
    ARM9opUND         ,
    ARM9opLDRTptrmar  ,
    ARM9opUND         ,
    ARM9opLDRTptrmrr  ,
    ARM9opUND         ,
    ARM9opLDRTptrmll  ,
    ARM9opUND         ,
    ARM9opLDRTptrmlr  ,
    ARM9opUND         ,
    ARM9opLDRTptrmar  ,
    ARM9opUND         ,
    ARM9opLDRTptrmrr  ,
    ARM9opUND         ,

    /*0x64*/
    ARM9opSTRBptrmll  ,
    ARM9opUND         ,
    ARM9opSTRBptrmlr  ,
    ARM9opUND         ,
    ARM9opSTRBptrmar  ,
    ARM9opUND         ,
    ARM9opSTRBptrmrr  ,
    ARM9opUND         ,
    ARM9opSTRBptrmll  ,
    ARM9opUND         ,
    ARM9opSTRBptrmlr  ,
    ARM9opUND         ,
    ARM9opSTRBptrmar  ,
    ARM9opUND         ,
    ARM9opSTRBptrmrr  ,
    ARM9opUND         ,

    /*0x65*/
    ARM9opLDRBptrmll  ,
    ARM9opUND         ,
    ARM9opLDRBptrmlr  ,
    ARM9opUND         ,
    ARM9opLDRBptrmar  ,
    ARM9opUND         ,
    ARM9opLDRBptrmrr  ,
    ARM9opUND         ,
    ARM9opLDRBptrmll  ,
    ARM9opUND         ,
    ARM9opLDRBptrmlr  ,
    ARM9opUND         ,
    ARM9opLDRBptrmar  ,
    ARM9opUND         ,
    ARM9opLDRBptrmrr  ,
    ARM9opUND         ,

    /*0x66*/
    ARM9opSTRBTptrmll ,
    ARM9opUND         ,
    ARM9opSTRBTptrmlr ,
    ARM9opUND         ,
    ARM9opSTRBTptrmar ,
    ARM9opUND         ,
    ARM9opSTRBTptrmrr ,
    ARM9opUND         ,
    ARM9opSTRBTptrmll ,
    ARM9opUND         ,
    ARM9opSTRBTptrmlr ,
    ARM9opUND         ,
    ARM9opSTRBTptrmar ,
    ARM9opUND         ,
    ARM9opSTRBTptrmrr ,
    ARM9opUND         ,

    /*0x67*/
    ARM9opLDRBTptrmll ,
    ARM9opUND         ,
    ARM9opLDRBTptrmlr ,
    ARM9opUND         ,
    ARM9opLDRBTptrmar ,
    ARM9opUND         ,
    ARM9opLDRBTptrmrr ,
    ARM9opUND         ,
    ARM9opLDRBTptrmll ,
    ARM9opUND         ,
    ARM9opLDRBTptrmlr ,
    ARM9opUND         ,
    ARM9opLDRBTptrmar ,
    ARM9opUND         ,
    ARM9opLDRBTptrmrr ,
    ARM9opUND         ,

    /*0x68*/
    ARM9opSTRptrpll   ,
    ARM9opUND         ,
    ARM9opSTRptrplr   ,
    ARM9opUND         ,
    ARM9opSTRptrpar   ,
    ARM9opUND         ,
    ARM9opSTRptrprr   ,
    ARM9opUND         ,
    ARM9opSTRptrpll   ,
    ARM9opUND         ,
    ARM9opSTRptrplr   ,
    ARM9opUND         ,
    ARM9opSTRptrpar   ,
    ARM9opUND         ,
    ARM9opSTRptrprr   ,
    ARM9opUND         ,

    /*0x69*/
    ARM9opLDRptrpll   ,
    ARM9opUND         ,
    ARM9opLDRptrplr   ,
    ARM9opUND         ,
    ARM9opLDRptrpar   ,
    ARM9opUND         ,
    ARM9opLDRptrprr   ,
    ARM9opUND         ,
    ARM9opLDRptrpll   ,
    ARM9opUND         ,
    ARM9opLDRptrplr   ,
    ARM9opUND         ,
    ARM9opLDRptrpar   ,
    ARM9opUND         ,
    ARM9opLDRptrprr   ,
    ARM9opUND         ,

    /*0x6A*/
    ARM9opSTRTptrpll  ,
    ARM9opUND         ,
    ARM9opSTRTptrplr  ,
    ARM9opUND         ,
    ARM9opSTRTptrpar  ,
    ARM9opUND         ,
    ARM9opSTRTptrprr  ,
    ARM9opUND         ,
    ARM9opSTRTptrpll  ,
    ARM9opUND         ,
    ARM9opSTRTptrplr  ,
    ARM9opUND         ,
    ARM9opSTRTptrpar  ,
    ARM9opUND         ,
    ARM9opSTRTptrprr  ,
    ARM9opUND         ,

    /*0x6B*/
    ARM9opLDRTptrpll  ,
    ARM9opUND         ,
    ARM9opLDRTptrplr  ,
    ARM9opUND         ,
    ARM9opLDRTptrpar  ,
    ARM9opUND         ,
    ARM9opLDRTptrprr  ,
    ARM9opUND         ,
    ARM9opLDRTptrpll  ,
    ARM9opUND         ,
    ARM9opLDRTptrplr  ,
    ARM9opUND         ,
    ARM9opLDRTptrpar  ,
    ARM9opUND         ,
    ARM9opLDRTptrprr  ,
    ARM9opUND         ,

    /*0x6C*/
    ARM9opSTRBptrpll  ,
    ARM9opUND         ,
    ARM9opSTRBptrplr  ,
    ARM9opUND         ,
    ARM9opSTRBptrpar  ,
    ARM9opUND         ,
    ARM9opSTRBptrprr  ,
    ARM9opUND         ,
    ARM9opSTRBptrpll  ,
    ARM9opUND         ,
    ARM9opSTRBptrplr  ,
    ARM9opUND         ,
    ARM9opSTRBptrpar  ,
    ARM9opUND         ,
    ARM9opSTRBptrprr  ,
    ARM9opUND         ,

    /*0x6D*/
    ARM9opLDRBptrpll  ,
    ARM9opUND         ,
    ARM9opLDRBptrplr  ,
    ARM9opUND         ,
    ARM9opLDRBptrpar  ,
    ARM9opUND         ,
    ARM9opLDRBptrprr  ,
    ARM9opUND         ,
    ARM9opLDRBptrpll  ,
    ARM9opUND         ,
    ARM9opLDRBptrplr  ,
    ARM9opUND         ,
    ARM9opLDRBptrpar  ,
    ARM9opUND         ,
    ARM9opLDRBptrprr  ,
    ARM9opUND         ,

    /*0x6E*/
    ARM9opSTRBTptrpll ,
    ARM9opUND         ,
    ARM9opSTRBTptrplr ,
    ARM9opUND         ,
    ARM9opSTRBTptrpar ,
    ARM9opUND         ,
    ARM9opSTRBTptrprr ,
    ARM9opUND         ,
    ARM9opSTRBTptrpll ,
    ARM9opUND         ,
    ARM9opSTRBTptrplr ,
    ARM9opUND         ,
    ARM9opSTRBTptrpar ,
    ARM9opUND         ,
    ARM9opSTRBTptrprr ,
    ARM9opUND         ,

    /*0x6F*/
    ARM9opLDRBTptrpll ,
    ARM9opUND         ,
    ARM9opLDRBTptrplr ,
    ARM9opUND         ,
    ARM9opLDRBTptrpar ,
    ARM9opUND         ,
    ARM9opLDRBTptrprr ,
    ARM9opUND         ,
    ARM9opLDRBTptrpll ,
    ARM9opUND         ,
    ARM9opLDRBTptrplr ,
    ARM9opUND         ,
    ARM9opLDRBTptrpar ,
    ARM9opUND         ,
    ARM9opLDRBTptrprr ,
    ARM9opUND         ,

    /*0x70*/
    ARM9opSTRofrmll   ,
    ARM9opUND         ,
    ARM9opSTRofrmlr   ,
    ARM9opUND         ,
    ARM9opSTRofrmar   ,
    ARM9opUND         ,
    ARM9opSTRofrmrr   ,
    ARM9opUND         ,
    ARM9opSTRofrmll   ,
    ARM9opUND         ,
    ARM9opSTRofrmlr   ,
    ARM9opUND         ,
    ARM9opSTRofrmar   ,
    ARM9opUND         ,
    ARM9opSTRofrmrr   ,
    ARM9opUND         ,

    /*0x71*/
    ARM9opLDRofrmll   ,
    ARM9opUND         ,
    ARM9opLDRofrmlr   ,
    ARM9opUND         ,
    ARM9opLDRofrmar   ,
    ARM9opUND         ,
    ARM9opLDRofrmrr   ,
    ARM9opUND         ,
    ARM9opLDRofrmll   ,
    ARM9opUND         ,
    ARM9opLDRofrmlr   ,
    ARM9opUND         ,
    ARM9opLDRofrmar   ,
    ARM9opUND         ,
    ARM9opLDRofrmrr   ,
    ARM9opUND         ,

    /*0x72*/
    ARM9opSTRprrmll   ,
    ARM9opUND         ,
    ARM9opSTRprrmlr   ,
    ARM9opUND         ,
    ARM9opSTRprrmar   ,
    ARM9opUND         ,
    ARM9opSTRprrmrr   ,
    ARM9opUND         ,
    ARM9opSTRprrmll   ,
    ARM9opUND         ,
    ARM9opSTRprrmlr   ,
    ARM9opUND         ,
    ARM9opSTRprrmar   ,
    ARM9opUND         ,
    ARM9opSTRprrmrr   ,
    ARM9opUND         ,

    /*0x73*/
    ARM9opLDRprrmll   ,
    ARM9opUND         ,
    ARM9opLDRprrmlr   ,
    ARM9opUND         ,
    ARM9opLDRprrmar   ,
    ARM9opUND         ,
    ARM9opLDRprrmrr   ,
    ARM9opUND         ,
    ARM9opLDRprrmll   ,
    ARM9opUND         ,
    ARM9opLDRprrmlr   ,
    ARM9opUND         ,
    ARM9opLDRprrmar   ,
    ARM9opUND         ,
    ARM9opLDRprrmrr   ,
    ARM9opUND         ,

    /*0x74*/
    ARM9opSTRBofrmll  ,
    ARM9opUND         ,
    ARM9opSTRBofrmlr  ,
    ARM9opUND         ,
    ARM9opSTRBofrmar  ,
    ARM9opUND         ,
    ARM9opSTRBofrmrr  ,
    ARM9opUND         ,
    ARM9opSTRBofrmll  ,
    ARM9opUND         ,
    ARM9opSTRBofrmlr  ,
    ARM9opUND         ,
    ARM9opSTRBofrmar  ,
    ARM9opUND         ,
    ARM9opSTRBofrmrr  ,
    ARM9opUND         ,

    /*0x75*/
    ARM9opLDRBofrmll  ,
    ARM9opUND         ,
    ARM9opLDRBofrmlr  ,
    ARM9opUND         ,
    ARM9opLDRBofrmar  ,
    ARM9opUND         ,
    ARM9opLDRBofrmrr  ,
    ARM9opUND         ,
    ARM9opLDRBofrmll  ,
    ARM9opUND         ,
    ARM9opLDRBofrmlr  ,
    ARM9opUND         ,
    ARM9opLDRBofrmar  ,
    ARM9opUND         ,
    ARM9opLDRBofrmrr  ,
    ARM9opUND         ,

    /*0x76*/
    ARM9opSTRBprrmll  ,
    ARM9opUND         ,
    ARM9opSTRBprrmlr  ,
    ARM9opUND         ,
    ARM9opSTRBprrmar  ,
    ARM9opUND         ,
    ARM9opSTRBprrmrr  ,
    ARM9opUND         ,
    ARM9opSTRBprrmll  ,
    ARM9opUND         ,
    ARM9opSTRBprrmlr  ,
    ARM9opUND         ,
    ARM9opSTRBprrmar  ,
    ARM9opUND         ,
    ARM9opSTRBprrmrr  ,
    ARM9opUND         ,

    /*0x77*/
    ARM9opLDRBprrmll  ,
    ARM9opUND         ,
    ARM9opLDRBprrmlr  ,
    ARM9opUND         ,
    ARM9opLDRBprrmar  ,
    ARM9opUND         ,
    ARM9opLDRBprrmrr  ,
    ARM9opUND         ,
    ARM9opLDRBprrmll  ,
    ARM9opUND         ,
    ARM9opLDRBprrmlr  ,
    ARM9opUND         ,
    ARM9opLDRBprrmar  ,
    ARM9opUND         ,
    ARM9opLDRBprrmrr  ,
    ARM9opUND         ,

    /*0x78*/
    ARM9opSTRofrpll   ,
    ARM9opUND         ,
    ARM9opSTRofrplr   ,
    ARM9opUND         ,
    ARM9opSTRofrpar   ,
    ARM9opUND         ,
    ARM9opSTRofrprr   ,
    ARM9opUND         ,
    ARM9opSTRofrpll   ,
    ARM9opUND         ,
    ARM9opSTRofrplr   ,
    ARM9opUND         ,
    ARM9opSTRofrpar   ,
    ARM9opUND         ,
    ARM9opSTRofrprr   ,
    ARM9opUND         ,

    /*0x79*/
    ARM9opLDRofrpll   ,
    ARM9opUND         ,
    ARM9opLDRofrplr   ,
    ARM9opUND         ,
    ARM9opLDRofrpar   ,
    ARM9opUND         ,
    ARM9opLDRofrprr   ,
    ARM9opUND         ,
    ARM9opLDRofrpll   ,
    ARM9opUND         ,
    ARM9opLDRofrplr   ,
    ARM9opUND         ,
    ARM9opLDRofrpar   ,
    ARM9opUND         ,
    ARM9opLDRofrprr   ,
    ARM9opUND         ,

    /*0x7A*/
    ARM9opSTRprrpll   ,
    ARM9opUND         ,
    ARM9opSTRprrplr   ,
    ARM9opUND         ,
    ARM9opSTRprrpar   ,
    ARM9opUND         ,
    ARM9opSTRprrprr   ,
    ARM9opUND         ,
    ARM9opSTRprrpll   ,
    ARM9opUND         ,
    ARM9opSTRprrplr   ,
    ARM9opUND         ,
    ARM9opSTRprrpar   ,
    ARM9opUND         ,
    ARM9opSTRprrprr   ,
    ARM9opUND         ,

    /*0x7B*/
    ARM9opLDRprrpll   ,
    ARM9opUND         ,
    ARM9opLDRprrplr   ,
    ARM9opUND         ,
    ARM9opLDRprrpar   ,
    ARM9opUND         ,
    ARM9opLDRprrprr   ,
    ARM9opUND         ,
    ARM9opLDRprrpll   ,
    ARM9opUND         ,
    ARM9opLDRprrplr   ,
    ARM9opUND         ,
    ARM9opLDRprrpar   ,
    ARM9opUND         ,
    ARM9opLDRprrprr   ,
    ARM9opUND         ,

    /*0x7C*/
    ARM9opSTRBofrpll  ,
    ARM9opUND         ,
    ARM9opSTRBofrplr  ,
    ARM9opUND         ,
    ARM9opSTRBofrpar  ,
    ARM9opUND         ,
    ARM9opSTRBofrprr  ,
    ARM9opUND         ,
    ARM9opSTRBofrpll  ,
    ARM9opUND         ,
    ARM9opSTRBofrplr  ,
    ARM9opUND         ,
    ARM9opSTRBofrpar  ,
    ARM9opUND         ,
    ARM9opSTRBofrprr  ,
    ARM9opUND         ,

    /*0x7D*/
    ARM9opLDRBofrpll  ,
    ARM9opUND         ,
    ARM9opLDRBofrplr  ,
    ARM9opUND         ,
    ARM9opLDRBofrpar  ,
    ARM9opUND         ,
    ARM9opLDRBofrprr  ,
    ARM9opUND         ,
    ARM9opLDRBofrpll  ,
    ARM9opUND         ,
    ARM9opLDRBofrplr  ,
    ARM9opUND         ,
    ARM9opLDRBofrpar  ,
    ARM9opUND         ,
    ARM9opLDRBofrprr  ,
    ARM9opUND         ,

    /*0x7E*/
    ARM9opSTRBprrpll  ,
    ARM9opUND         ,
    ARM9opSTRBprrplr  ,
    ARM9opUND         ,
    ARM9opSTRBprrpar  ,
    ARM9opUND         ,
    ARM9opSTRBprrprr  ,
    ARM9opUND         ,
    ARM9opSTRBprrpll  ,
    ARM9opUND         ,
    ARM9opSTRBprrplr  ,
    ARM9opUND         ,
    ARM9opSTRBprrpar  ,
    ARM9opUND         ,
    ARM9opSTRBprrprr  ,
    ARM9opUND         ,

    /*0x7F*/
    ARM9opLDRBprrpll  ,
    ARM9opUND         ,
    ARM9opLDRBprrplr  ,
    ARM9opUND         ,
    ARM9opLDRBprrpar  ,
    ARM9opUND         ,
    ARM9opLDRBprrprr  ,
    ARM9opUND         ,
    ARM9opLDRBprrpll  ,
    ARM9opUND         ,
    ARM9opLDRBprrplr  ,
    ARM9opUND         ,
    ARM9opLDRBprrpar  ,
    ARM9opUND         ,
    ARM9opLDRBprrprr  ,
    ARM9opUND         ,

    /*0x80*/
    ARM9opSTMDA       ,
    ARM9opSTMDA       ,
    ARM9opSTMDA       ,
    ARM9opSTMDA       ,
    ARM9opSTMDA       ,
    ARM9opSTMDA       ,
    ARM9opSTMDA       ,
    ARM9opSTMDA       ,
    ARM9opSTMDA       ,
    ARM9opSTMDA       ,
    ARM9opSTMDA       ,
    ARM9opSTMDA       ,
    ARM9opSTMDA       ,
    ARM9opSTMDA       ,
    ARM9opSTMDA       ,
    ARM9opSTMDA       ,

    /*0x81*/
    ARM9opLDMDA       ,
    ARM9opLDMDA       ,
    ARM9opLDMDA       ,
    ARM9opLDMDA       ,
    ARM9opLDMDA       ,
    ARM9opLDMDA       ,
    ARM9opLDMDA       ,
    ARM9opLDMDA       ,
    ARM9opLDMDA       ,
    ARM9opLDMDA       ,
    ARM9opLDMDA       ,
    ARM9opLDMDA       ,
    ARM9opLDMDA       ,
    ARM9opLDMDA       ,
    ARM9opLDMDA       ,
    ARM9opLDMDA       ,

    /*0x82*/
    ARM9opSTMDAw      ,
    ARM9opSTMDAw      ,
    ARM9opSTMDAw      ,
    ARM9opSTMDAw      ,
    ARM9opSTMDAw      ,
    ARM9opSTMDAw      ,
    ARM9opSTMDAw      ,
    ARM9opSTMDAw      ,
    ARM9opSTMDAw      ,
    ARM9opSTMDAw      ,
    ARM9opSTMDAw      ,
    ARM9opSTMDAw      ,
    ARM9opSTMDAw      ,
    ARM9opSTMDAw      ,
    ARM9opSTMDAw      ,
    ARM9opSTMDAw      ,

    /*0x83*/
    ARM9opLDMDAw      ,
    ARM9opLDMDAw      ,
    ARM9opLDMDAw      ,
    ARM9opLDMDAw      ,
    ARM9opLDMDAw      ,
    ARM9opLDMDAw      ,
    ARM9opLDMDAw      ,
    ARM9opLDMDAw      ,
    ARM9opLDMDAw      ,
    ARM9opLDMDAw      ,
    ARM9opLDMDAw      ,
    ARM9opLDMDAw      ,
    ARM9opLDMDAw      ,
    ARM9opLDMDAw      ,
    ARM9opLDMDAw      ,
    ARM9opLDMDAw      ,

    /*0x84*/
    ARM9opSTMDAu      ,
    ARM9opSTMDAu      ,
    ARM9opSTMDAu      ,
    ARM9opSTMDAu      ,
    ARM9opSTMDAu      ,
    ARM9opSTMDAu      ,
    ARM9opSTMDAu      ,
    ARM9opSTMDAu      ,
    ARM9opSTMDAu      ,
    ARM9opSTMDAu      ,
    ARM9opSTMDAu      ,
    ARM9opSTMDAu      ,
    ARM9opSTMDAu      ,
    ARM9opSTMDAu      ,
    ARM9opSTMDAu      ,
    ARM9opSTMDAu      ,

    /*0x85*/
    ARM9opLDMDAu      ,
    ARM9opLDMDAu      ,
    ARM9opLDMDAu      ,
    ARM9opLDMDAu      ,
    ARM9opLDMDAu      ,
    ARM9opLDMDAu      ,
    ARM9opLDMDAu      ,
    ARM9opLDMDAu      ,
    ARM9opLDMDAu      ,
    ARM9opLDMDAu      ,
    ARM9opLDMDAu      ,
    ARM9opLDMDAu      ,
    ARM9opLDMDAu      ,
    ARM9opLDMDAu      ,
    ARM9opLDMDAu      ,
    ARM9opLDMDAu      ,

    /*0x86*/
    ARM9opSTMDAuw     ,
    ARM9opSTMDAuw     ,
    ARM9opSTMDAuw     ,
    ARM9opSTMDAuw     ,
    ARM9opSTMDAuw     ,
    ARM9opSTMDAuw     ,
    ARM9opSTMDAuw     ,
    ARM9opSTMDAuw     ,
    ARM9opSTMDAuw     ,
    ARM9opSTMDAuw     ,
    ARM9opSTMDAuw     ,
    ARM9opSTMDAuw     ,
    ARM9opSTMDAuw     ,
    ARM9opSTMDAuw     ,
    ARM9opSTMDAuw     ,
    ARM9opSTMDAuw     ,

    /*0x87*/
    ARM9opLDMDAuw     ,
    ARM9opLDMDAuw     ,
    ARM9opLDMDAuw     ,
    ARM9opLDMDAuw     ,
    ARM9opLDMDAuw     ,
    ARM9opLDMDAuw     ,
    ARM9opLDMDAuw     ,
    ARM9opLDMDAuw     ,
    ARM9opLDMDAuw     ,
    ARM9opLDMDAuw     ,
    ARM9opLDMDAuw     ,
    ARM9opLDMDAuw     ,
    ARM9opLDMDAuw     ,
    ARM9opLDMDAuw     ,
    ARM9opLDMDAuw     ,
    ARM9opLDMDAuw     ,

    /*0x88*/
    ARM9opSTMIA       ,
    ARM9opSTMIA       ,
    ARM9opSTMIA       ,
    ARM9opSTMIA       ,
    ARM9opSTMIA       ,
    ARM9opSTMIA       ,
    ARM9opSTMIA       ,
    ARM9opSTMIA       ,
    ARM9opSTMIA       ,
    ARM9opSTMIA       ,
    ARM9opSTMIA       ,
    ARM9opSTMIA       ,
    ARM9opSTMIA       ,
    ARM9opSTMIA       ,
    ARM9opSTMIA       ,
    ARM9opSTMIA       ,

    /*0x89*/
    ARM9opLDMIA       ,
    ARM9opLDMIA       ,
    ARM9opLDMIA       ,
    ARM9opLDMIA       ,
    ARM9opLDMIA       ,
    ARM9opLDMIA       ,
    ARM9opLDMIA       ,
    ARM9opLDMIA       ,
    ARM9opLDMIA       ,
    ARM9opLDMIA       ,
    ARM9opLDMIA       ,
    ARM9opLDMIA       ,
    ARM9opLDMIA       ,
    ARM9opLDMIA       ,
    ARM9opLDMIA       ,
    ARM9opLDMIA       ,

    /*0x8A*/
    ARM9opSTMIAw      ,
    ARM9opSTMIAw      ,
    ARM9opSTMIAw      ,
    ARM9opSTMIAw      ,
    ARM9opSTMIAw      ,
    ARM9opSTMIAw      ,
    ARM9opSTMIAw      ,
    ARM9opSTMIAw      ,
    ARM9opSTMIAw      ,
    ARM9opSTMIAw      ,
    ARM9opSTMIAw      ,
    ARM9opSTMIAw      ,
    ARM9opSTMIAw      ,
    ARM9opSTMIAw      ,
    ARM9opSTMIAw      ,
    ARM9opSTMIAw      ,

    /*0x8B*/
    ARM9opLDMIAw      ,
    ARM9opLDMIAw      ,
    ARM9opLDMIAw      ,
    ARM9opLDMIAw      ,
    ARM9opLDMIAw      ,
    ARM9opLDMIAw      ,
    ARM9opLDMIAw      ,
    ARM9opLDMIAw      ,
    ARM9opLDMIAw      ,
    ARM9opLDMIAw      ,
    ARM9opLDMIAw      ,
    ARM9opLDMIAw      ,
    ARM9opLDMIAw      ,
    ARM9opLDMIAw      ,
    ARM9opLDMIAw      ,
    ARM9opLDMIAw      ,

    /*0x8C*/
    ARM9opSTMIAu      ,
    ARM9opSTMIAu      ,
    ARM9opSTMIAu      ,
    ARM9opSTMIAu      ,
    ARM9opSTMIAu      ,
    ARM9opSTMIAu      ,
    ARM9opSTMIAu      ,
    ARM9opSTMIAu      ,
    ARM9opSTMIAu      ,
    ARM9opSTMIAu      ,
    ARM9opSTMIAu      ,
    ARM9opSTMIAu      ,
    ARM9opSTMIAu      ,
    ARM9opSTMIAu      ,
    ARM9opSTMIAu      ,
    ARM9opSTMIAu      ,

    /*0x8D*/
    ARM9opLDMIAu      ,
    ARM9opLDMIAu      ,
    ARM9opLDMIAu      ,
    ARM9opLDMIAu      ,
    ARM9opLDMIAu      ,
    ARM9opLDMIAu      ,
    ARM9opLDMIAu      ,
    ARM9opLDMIAu      ,
    ARM9opLDMIAu      ,
    ARM9opLDMIAu      ,
    ARM9opLDMIAu      ,
    ARM9opLDMIAu      ,
    ARM9opLDMIAu      ,
    ARM9opLDMIAu      ,
    ARM9opLDMIAu      ,
    ARM9opLDMIAu      ,

    /*0x8E*/
    ARM9opSTMIAuw     ,
    ARM9opSTMIAuw     ,
    ARM9opSTMIAuw     ,
    ARM9opSTMIAuw     ,
    ARM9opSTMIAuw     ,
    ARM9opSTMIAuw     ,
    ARM9opSTMIAuw     ,
    ARM9opSTMIAuw     ,
    ARM9opSTMIAuw     ,
    ARM9opSTMIAuw     ,
    ARM9opSTMIAuw     ,
    ARM9opSTMIAuw     ,
    ARM9opSTMIAuw     ,
    ARM9opSTMIAuw     ,
    ARM9opSTMIAuw     ,
    ARM9opSTMIAuw     ,

    /*0x8F*/
    ARM9opLDMIAuw     ,
    ARM9opLDMIAuw     ,
    ARM9opLDMIAuw     ,
    ARM9opLDMIAuw     ,
    ARM9opLDMIAuw     ,
    ARM9opLDMIAuw     ,
    ARM9opLDMIAuw     ,
    ARM9opLDMIAuw     ,
    ARM9opLDMIAuw     ,
    ARM9opLDMIAuw     ,
    ARM9opLDMIAuw     ,
    ARM9opLDMIAuw     ,
    ARM9opLDMIAuw     ,
    ARM9opLDMIAuw     ,
    ARM9opLDMIAuw     ,
    ARM9opLDMIAuw     ,

    /*0x90*/
    ARM9opSTMDB       ,
    ARM9opSTMDB       ,
    ARM9opSTMDB       ,
    ARM9opSTMDB       ,
    ARM9opSTMDB       ,
    ARM9opSTMDB       ,
    ARM9opSTMDB       ,
    ARM9opSTMDB       ,
    ARM9opSTMDB       ,
    ARM9opSTMDB       ,
    ARM9opSTMDB       ,
    ARM9opSTMDB       ,
    ARM9opSTMDB       ,
    ARM9opSTMDB       ,
    ARM9opSTMDB       ,
    ARM9opSTMDB       ,

    /*0x91*/
    ARM9opLDMDB       ,
    ARM9opLDMDB       ,
    ARM9opLDMDB       ,
    ARM9opLDMDB       ,
    ARM9opLDMDB       ,
    ARM9opLDMDB       ,
    ARM9opLDMDB       ,
    ARM9opLDMDB       ,
    ARM9opLDMDB       ,
    ARM9opLDMDB       ,
    ARM9opLDMDB       ,
    ARM9opLDMDB       ,
    ARM9opLDMDB       ,
    ARM9opLDMDB       ,
    ARM9opLDMDB       ,
    ARM9opLDMDB       ,

    /*0x92*/
    ARM9opSTMDBw      ,
    ARM9opSTMDBw      ,
    ARM9opSTMDBw      ,
    ARM9opSTMDBw      ,
    ARM9opSTMDBw      ,
    ARM9opSTMDBw      ,
    ARM9opSTMDBw      ,
    ARM9opSTMDBw      ,
    ARM9opSTMDBw      ,
    ARM9opSTMDBw      ,
    ARM9opSTMDBw      ,
    ARM9opSTMDBw      ,
    ARM9opSTMDBw      ,
    ARM9opSTMDBw      ,
    ARM9opSTMDBw      ,
    ARM9opSTMDBw      ,

    /*0x93*/
    ARM9opLDMDBw      ,
    ARM9opLDMDBw      ,
    ARM9opLDMDBw      ,
    ARM9opLDMDBw      ,
    ARM9opLDMDBw      ,
    ARM9opLDMDBw      ,
    ARM9opLDMDBw      ,
    ARM9opLDMDBw      ,
    ARM9opLDMDBw      ,
    ARM9opLDMDBw      ,
    ARM9opLDMDBw      ,
    ARM9opLDMDBw      ,
    ARM9opLDMDBw      ,
    ARM9opLDMDBw      ,
    ARM9opLDMDBw      ,
    ARM9opLDMDBw      ,

    /*0x94*/
    ARM9opSTMDBu      ,
    ARM9opSTMDBu      ,
    ARM9opSTMDBu      ,
    ARM9opSTMDBu      ,
    ARM9opSTMDBu      ,
    ARM9opSTMDBu      ,
    ARM9opSTMDBu      ,
    ARM9opSTMDBu      ,
    ARM9opSTMDBu      ,
    ARM9opSTMDBu      ,
    ARM9opSTMDBu      ,
    ARM9opSTMDBu      ,
    ARM9opSTMDBu      ,
    ARM9opSTMDBu      ,
    ARM9opSTMDBu      ,
    ARM9opSTMDBu      ,

    /*0x95*/
    ARM9opLDMDBu      ,
    ARM9opLDMDBu      ,
    ARM9opLDMDBu      ,
    ARM9opLDMDBu      ,
    ARM9opLDMDBu      ,
    ARM9opLDMDBu      ,
    ARM9opLDMDBu      ,
    ARM9opLDMDBu      ,
    ARM9opLDMDBu      ,
    ARM9opLDMDBu      ,
    ARM9opLDMDBu      ,
    ARM9opLDMDBu      ,
    ARM9opLDMDBu      ,
    ARM9opLDMDBu      ,
    ARM9opLDMDBu      ,
    ARM9opLDMDBu      ,

    /*0x96*/
    ARM9opSTMDBuw     ,
    ARM9opSTMDBuw     ,
    ARM9opSTMDBuw     ,
    ARM9opSTMDBuw     ,
    ARM9opSTMDBuw     ,
    ARM9opSTMDBuw     ,
    ARM9opSTMDBuw     ,
    ARM9opSTMDBuw     ,
    ARM9opSTMDBuw     ,
    ARM9opSTMDBuw     ,
    ARM9opSTMDBuw     ,
    ARM9opSTMDBuw     ,
    ARM9opSTMDBuw     ,
    ARM9opSTMDBuw     ,
    ARM9opSTMDBuw     ,
    ARM9opSTMDBuw     ,

    /*0x97*/
    ARM9opLDMDBuw     ,
    ARM9opLDMDBuw     ,
    ARM9opLDMDBuw     ,
    ARM9opLDMDBuw     ,
    ARM9opLDMDBuw     ,
    ARM9opLDMDBuw     ,
    ARM9opLDMDBuw     ,
    ARM9opLDMDBuw     ,
    ARM9opLDMDBuw     ,
    ARM9opLDMDBuw     ,
    ARM9opLDMDBuw     ,
    ARM9opLDMDBuw     ,
    ARM9opLDMDBuw     ,
    ARM9opLDMDBuw     ,
    ARM9opLDMDBuw     ,
    ARM9opLDMDBuw     ,

    /*0x98*/
    ARM9opSTMIB       ,
    ARM9opSTMIB       ,
    ARM9opSTMIB       ,
    ARM9opSTMIB       ,
    ARM9opSTMIB       ,
    ARM9opSTMIB       ,
    ARM9opSTMIB       ,
    ARM9opSTMIB       ,
    ARM9opSTMIB       ,
    ARM9opSTMIB       ,
    ARM9opSTMIB       ,
    ARM9opSTMIB       ,
    ARM9opSTMIB       ,
    ARM9opSTMIB       ,
    ARM9opSTMIB       ,
    ARM9opSTMIB       ,

    /*0x99*/
    ARM9opLDMIB       ,
    ARM9opLDMIB       ,
    ARM9opLDMIB       ,
    ARM9opLDMIB       ,
    ARM9opLDMIB       ,
    ARM9opLDMIB       ,
    ARM9opLDMIB       ,
    ARM9opLDMIB       ,
    ARM9opLDMIB       ,
    ARM9opLDMIB       ,
    ARM9opLDMIB       ,
    ARM9opLDMIB       ,
    ARM9opLDMIB       ,
    ARM9opLDMIB       ,
    ARM9opLDMIB       ,
    ARM9opLDMIB       ,

    /*0x9A*/
    ARM9opSTMIBw      ,
    ARM9opSTMIBw      ,
    ARM9opSTMIBw      ,
    ARM9opSTMIBw      ,
    ARM9opSTMIBw      ,
    ARM9opSTMIBw      ,
    ARM9opSTMIBw      ,
    ARM9opSTMIBw      ,
    ARM9opSTMIBw      ,
    ARM9opSTMIBw      ,
    ARM9opSTMIBw      ,
    ARM9opSTMIBw      ,
    ARM9opSTMIBw      ,
    ARM9opSTMIBw      ,
    ARM9opSTMIBw      ,
    ARM9opSTMIBw      ,

    /*0x9B*/
    ARM9opLDMIBw      ,
    ARM9opLDMIBw      ,
    ARM9opLDMIBw      ,
    ARM9opLDMIBw      ,
    ARM9opLDMIBw      ,
    ARM9opLDMIBw      ,
    ARM9opLDMIBw      ,
    ARM9opLDMIBw      ,
    ARM9opLDMIBw      ,
    ARM9opLDMIBw      ,
    ARM9opLDMIBw      ,
    ARM9opLDMIBw      ,
    ARM9opLDMIBw      ,
    ARM9opLDMIBw      ,
    ARM9opLDMIBw      ,
    ARM9opLDMIBw      ,

    /*0x9C*/
    ARM9opSTMIBu      ,
    ARM9opSTMIBu      ,
    ARM9opSTMIBu      ,
    ARM9opSTMIBu      ,
    ARM9opSTMIBu      ,
    ARM9opSTMIBu      ,
    ARM9opSTMIBu      ,
    ARM9opSTMIBu      ,
    ARM9opSTMIBu      ,
    ARM9opSTMIBu      ,
    ARM9opSTMIBu      ,
    ARM9opSTMIBu      ,
    ARM9opSTMIBu      ,
    ARM9opSTMIBu      ,
    ARM9opSTMIBu      ,
    ARM9opSTMIBu      ,

    /*0x9D*/
    ARM9opLDMIBu      ,
    ARM9opLDMIBu      ,
    ARM9opLDMIBu      ,
    ARM9opLDMIBu      ,
    ARM9opLDMIBu      ,
    ARM9opLDMIBu      ,
    ARM9opLDMIBu      ,
    ARM9opLDMIBu      ,
    ARM9opLDMIBu      ,
    ARM9opLDMIBu      ,
    ARM9opLDMIBu      ,
    ARM9opLDMIBu      ,
    ARM9opLDMIBu      ,
    ARM9opLDMIBu      ,
    ARM9opLDMIBu      ,
    ARM9opLDMIBu      ,

    /*0x9E*/
    ARM9opSTMIBuw     ,
    ARM9opSTMIBuw     ,
    ARM9opSTMIBuw     ,
    ARM9opSTMIBuw     ,
    ARM9opSTMIBuw     ,
    ARM9opSTMIBuw     ,
    ARM9opSTMIBuw     ,
    ARM9opSTMIBuw     ,
    ARM9opSTMIBuw     ,
    ARM9opSTMIBuw     ,
    ARM9opSTMIBuw     ,
    ARM9opSTMIBuw     ,
    ARM9opSTMIBuw     ,
    ARM9opSTMIBuw     ,
    ARM9opSTMIBuw     ,
    ARM9opSTMIBuw     ,

    /*0x9F*/
    ARM9opLDMIBuw     ,
    ARM9opLDMIBuw     ,
    ARM9opLDMIBuw     ,
    ARM9opLDMIBuw     ,
    ARM9opLDMIBuw     ,
    ARM9opLDMIBuw     ,
    ARM9opLDMIBuw     ,
    ARM9opLDMIBuw     ,
    ARM9opLDMIBuw     ,
    ARM9opLDMIBuw     ,
    ARM9opLDMIBuw     ,
    ARM9opLDMIBuw     ,
    ARM9opLDMIBuw     ,
    ARM9opLDMIBuw     ,
    ARM9opLDMIBuw     ,
    ARM9opLDMIBuw     ,

    /*0xA0*/
    ARM9opB           ,
    ARM9opB           ,
    ARM9opB           ,
    ARM9opB           ,
    ARM9opB           ,
    ARM9opB           ,
    ARM9opB           ,
    ARM9opB           ,
    ARM9opB           ,
    ARM9opB           ,
    ARM9opB           ,
    ARM9opB           ,
    ARM9opB           ,
    ARM9opB           ,
    ARM9opB           ,
    ARM9opB           ,

    /*0xA1*/
    ARM9opB           ,
    ARM9opB           ,
    ARM9opB           ,
    ARM9opB           ,
    ARM9opB           ,
    ARM9opB           ,
    ARM9opB           ,
    ARM9opB           ,
    ARM9opB           ,
    ARM9opB           ,
    ARM9opB           ,
    ARM9opB           ,
    ARM9opB           ,
    ARM9opB           ,
    ARM9opB           ,
    ARM9opB           ,

    /*0xA2*/
    ARM9opB           ,
    ARM9opB           ,
    ARM9opB           ,
    ARM9opB           ,
    ARM9opB           ,
    ARM9opB           ,
    ARM9opB           ,
    ARM9opB           ,
    ARM9opB           ,
    ARM9opB           ,
    ARM9opB           ,
    ARM9opB           ,
    ARM9opB           ,
    ARM9opB           ,
    ARM9opB           ,
    ARM9opB           ,

    /*0xA3*/
    ARM9opB           ,
    ARM9opB           ,
    ARM9opB           ,
    ARM9opB           ,
    ARM9opB           ,
    ARM9opB           ,
    ARM9opB           ,
    ARM9opB           ,
    ARM9opB           ,
    ARM9opB           ,
    ARM9opB           ,
    ARM9opB           ,
    ARM9opB           ,
    ARM9opB           ,
    ARM9opB           ,
    ARM9opB           ,

    /*0xA4*/
    ARM9opB           ,
    ARM9opB           ,
    ARM9opB           ,
    ARM9opB           ,
    ARM9opB           ,
    ARM9opB           ,
    ARM9opB           ,
    ARM9opB           ,
    ARM9opB           ,
    ARM9opB           ,
    ARM9opB           ,
    ARM9opB           ,
    ARM9opB           ,
    ARM9opB           ,
    ARM9opB           ,
    ARM9opB           ,

    /*0xA5*/
    ARM9opB           ,
    ARM9opB           ,
    ARM9opB           ,
    ARM9opB           ,
    ARM9opB           ,
    ARM9opB           ,
    ARM9opB           ,
    ARM9opB           ,
    ARM9opB           ,
    ARM9opB           ,
    ARM9opB           ,
    ARM9opB           ,
    ARM9opB           ,
    ARM9opB           ,
    ARM9opB           ,
    ARM9opB           ,

    /*0xA6*/
    ARM9opB           ,
    ARM9opB           ,
    ARM9opB           ,
    ARM9opB           ,
    ARM9opB           ,
    ARM9opB           ,
    ARM9opB           ,
    ARM9opB           ,
    ARM9opB           ,
    ARM9opB           ,
    ARM9opB           ,
    ARM9opB           ,
    ARM9opB           ,
    ARM9opB           ,
    ARM9opB           ,
    ARM9opB           ,

    /*0xA7*/
    ARM9opB           ,
    ARM9opB           ,
    ARM9opB           ,
    ARM9opB           ,
    ARM9opB           ,
    ARM9opB           ,
    ARM9opB           ,
    ARM9opB           ,
    ARM9opB           ,
    ARM9opB           ,
    ARM9opB           ,
    ARM9opB           ,
    ARM9opB           ,
    ARM9opB           ,
    ARM9opB           ,
    ARM9opB           ,

    /*0xA8*/
    ARM9opB           ,
    ARM9opB           ,
    ARM9opB           ,
    ARM9opB           ,
    ARM9opB           ,
    ARM9opB           ,
    ARM9opB           ,
    ARM9opB           ,
    ARM9opB           ,
    ARM9opB           ,
    ARM9opB           ,
    ARM9opB           ,
    ARM9opB           ,
    ARM9opB           ,
    ARM9opB           ,
    ARM9opB           ,

    /*0xA9*/
    ARM9opB           ,
    ARM9opB           ,
    ARM9opB           ,
    ARM9opB           ,
    ARM9opB           ,
    ARM9opB           ,
    ARM9opB           ,
    ARM9opB           ,
    ARM9opB           ,
    ARM9opB           ,
    ARM9opB           ,
    ARM9opB           ,
    ARM9opB           ,
    ARM9opB           ,
    ARM9opB           ,
    ARM9opB           ,

    /*0xAA*/
    ARM9opB           ,
    ARM9opB           ,
    ARM9opB           ,
    ARM9opB           ,
    ARM9opB           ,
    ARM9opB           ,
    ARM9opB           ,
    ARM9opB           ,
    ARM9opB           ,
    ARM9opB           ,
    ARM9opB           ,
    ARM9opB           ,
    ARM9opB           ,
    ARM9opB           ,
    ARM9opB           ,
    ARM9opB           ,

    /*0xAB*/
    ARM9opB           ,
    ARM9opB           ,
    ARM9opB           ,
    ARM9opB           ,
    ARM9opB           ,
    ARM9opB           ,
    ARM9opB           ,
    ARM9opB           ,
    ARM9opB           ,
    ARM9opB           ,
    ARM9opB           ,
    ARM9opB           ,
    ARM9opB           ,
    ARM9opB           ,
    ARM9opB           ,
    ARM9opB           ,

    /*0xAC*/
    ARM9opB           ,
    ARM9opB           ,
    ARM9opB           ,
    ARM9opB           ,
    ARM9opB           ,
    ARM9opB           ,
    ARM9opB           ,
    ARM9opB           ,
    ARM9opB           ,
    ARM9opB           ,
    ARM9opB           ,
    ARM9opB           ,
    ARM9opB           ,
    ARM9opB           ,
    ARM9opB           ,
    ARM9opB           ,

    /*0xAD*/
    ARM9opB           ,
    ARM9opB           ,
    ARM9opB           ,
    ARM9opB           ,
    ARM9opB           ,
    ARM9opB           ,
    ARM9opB           ,
    ARM9opB           ,
    ARM9opB           ,
    ARM9opB           ,
    ARM9opB           ,
    ARM9opB           ,
    ARM9opB           ,
    ARM9opB           ,
    ARM9opB           ,
    ARM9opB           ,

    /*0xAE*/
    ARM9opB           ,
    ARM9opB           ,
    ARM9opB           ,
    ARM9opB           ,
    ARM9opB           ,
    ARM9opB           ,
    ARM9opB           ,
    ARM9opB           ,
    ARM9opB           ,
    ARM9opB           ,
    ARM9opB           ,
    ARM9opB           ,
    ARM9opB           ,
    ARM9opB           ,
    ARM9opB           ,
    ARM9opB           ,

    /*0xAF*/
    ARM9opB           ,
    ARM9opB           ,
    ARM9opB           ,
    ARM9opB           ,
    ARM9opB           ,
    ARM9opB           ,
    ARM9opB           ,
    ARM9opB           ,
    ARM9opB           ,
    ARM9opB           ,
    ARM9opB           ,
    ARM9opB           ,
    ARM9opB           ,
    ARM9opB           ,
    ARM9opB           ,
    ARM9opB           ,

    /*0xB0*/
    ARM9opBL          ,
    ARM9opBL          ,
    ARM9opBL          ,
    ARM9opBL          ,
    ARM9opBL          ,
    ARM9opBL          ,
    ARM9opBL          ,
    ARM9opBL          ,
    ARM9opBL          ,
    ARM9opBL          ,
    ARM9opBL          ,
    ARM9opBL          ,
    ARM9opBL          ,
    ARM9opBL          ,
    ARM9opBL          ,
    ARM9opBL          ,

    /*0xB1*/
    ARM9opBL          ,
    ARM9opBL          ,
    ARM9opBL          ,
    ARM9opBL          ,
    ARM9opBL          ,
    ARM9opBL          ,
    ARM9opBL          ,
    ARM9opBL          ,
    ARM9opBL          ,
    ARM9opBL          ,
    ARM9opBL          ,
    ARM9opBL          ,
    ARM9opBL          ,
    ARM9opBL          ,
    ARM9opBL          ,
    ARM9opBL          ,

    /*0xB2*/
    ARM9opBL          ,
    ARM9opBL          ,
    ARM9opBL          ,
    ARM9opBL          ,
    ARM9opBL          ,
    ARM9opBL          ,
    ARM9opBL          ,
    ARM9opBL          ,
    ARM9opBL          ,
    ARM9opBL          ,
    ARM9opBL          ,
    ARM9opBL          ,
    ARM9opBL          ,
    ARM9opBL          ,
    ARM9opBL          ,
    ARM9opBL          ,

    /*0xB3*/
    ARM9opBL          ,
    ARM9opBL          ,
    ARM9opBL          ,
    ARM9opBL          ,
    ARM9opBL          ,
    ARM9opBL          ,
    ARM9opBL          ,
    ARM9opBL          ,
    ARM9opBL          ,
    ARM9opBL          ,
    ARM9opBL          ,
    ARM9opBL          ,
    ARM9opBL          ,
    ARM9opBL          ,
    ARM9opBL          ,
    ARM9opBL          ,

    /*0xB4*/
    ARM9opBL          ,
    ARM9opBL          ,
    ARM9opBL          ,
    ARM9opBL          ,
    ARM9opBL          ,
    ARM9opBL          ,
    ARM9opBL          ,
    ARM9opBL          ,
    ARM9opBL          ,
    ARM9opBL          ,
    ARM9opBL          ,
    ARM9opBL          ,
    ARM9opBL          ,
    ARM9opBL          ,
    ARM9opBL          ,
    ARM9opBL          ,

    /*0xB5*/
    ARM9opBL          ,
    ARM9opBL          ,
    ARM9opBL          ,
    ARM9opBL          ,
    ARM9opBL          ,
    ARM9opBL          ,
    ARM9opBL          ,
    ARM9opBL          ,
    ARM9opBL          ,
    ARM9opBL          ,
    ARM9opBL          ,
    ARM9opBL          ,
    ARM9opBL          ,
    ARM9opBL          ,
    ARM9opBL          ,
    ARM9opBL          ,

    /*0xB6*/
    ARM9opBL          ,
    ARM9opBL          ,
    ARM9opBL          ,
    ARM9opBL          ,
    ARM9opBL          ,
    ARM9opBL          ,
    ARM9opBL          ,
    ARM9opBL          ,
    ARM9opBL          ,
    ARM9opBL          ,
    ARM9opBL          ,
    ARM9opBL          ,
    ARM9opBL          ,
    ARM9opBL          ,
    ARM9opBL          ,
    ARM9opBL          ,

    /*0xB7*/
    ARM9opBL          ,
    ARM9opBL          ,
    ARM9opBL          ,
    ARM9opBL          ,
    ARM9opBL          ,
    ARM9opBL          ,
    ARM9opBL          ,
    ARM9opBL          ,
    ARM9opBL          ,
    ARM9opBL          ,
    ARM9opBL          ,
    ARM9opBL          ,
    ARM9opBL          ,
    ARM9opBL          ,
    ARM9opBL          ,
    ARM9opBL          ,

    /*0xB8*/
    ARM9opBL          ,
    ARM9opBL          ,
    ARM9opBL          ,
    ARM9opBL          ,
    ARM9opBL          ,
    ARM9opBL          ,
    ARM9opBL          ,
    ARM9opBL          ,
    ARM9opBL          ,
    ARM9opBL          ,
    ARM9opBL          ,
    ARM9opBL          ,
    ARM9opBL          ,
    ARM9opBL          ,
    ARM9opBL          ,
    ARM9opBL          ,

    /*0xB9*/
    ARM9opBL          ,
    ARM9opBL          ,
    ARM9opBL          ,
    ARM9opBL          ,
    ARM9opBL          ,
    ARM9opBL          ,
    ARM9opBL          ,
    ARM9opBL          ,
    ARM9opBL          ,
    ARM9opBL          ,
    ARM9opBL          ,
    ARM9opBL          ,
    ARM9opBL          ,
    ARM9opBL          ,
    ARM9opBL          ,
    ARM9opBL          ,

    /*0xBA*/
    ARM9opBL          ,
    ARM9opBL          ,
    ARM9opBL          ,
    ARM9opBL          ,
    ARM9opBL          ,
    ARM9opBL          ,
    ARM9opBL          ,
    ARM9opBL          ,
    ARM9opBL          ,
    ARM9opBL          ,
    ARM9opBL          ,
    ARM9opBL          ,
    ARM9opBL          ,
    ARM9opBL          ,
    ARM9opBL          ,
    ARM9opBL          ,

    /*0xBB*/
    ARM9opBL          ,
    ARM9opBL          ,
    ARM9opBL          ,
    ARM9opBL          ,
    ARM9opBL          ,
    ARM9opBL          ,
    ARM9opBL          ,
    ARM9opBL          ,
    ARM9opBL          ,
    ARM9opBL          ,
    ARM9opBL          ,
    ARM9opBL          ,
    ARM9opBL          ,
    ARM9opBL          ,
    ARM9opBL          ,
    ARM9opBL          ,

    /*0xBC*/
    ARM9opBL          ,
    ARM9opBL          ,
    ARM9opBL          ,
    ARM9opBL          ,
    ARM9opBL          ,
    ARM9opBL          ,
    ARM9opBL          ,
    ARM9opBL          ,
    ARM9opBL          ,
    ARM9opBL          ,
    ARM9opBL          ,
    ARM9opBL          ,
    ARM9opBL          ,
    ARM9opBL          ,
    ARM9opBL          ,
    ARM9opBL          ,

    /*0xBD*/
    ARM9opBL          ,
    ARM9opBL          ,
    ARM9opBL          ,
    ARM9opBL          ,
    ARM9opBL          ,
    ARM9opBL          ,
    ARM9opBL          ,
    ARM9opBL          ,
    ARM9opBL          ,
    ARM9opBL          ,
    ARM9opBL          ,
    ARM9opBL          ,
    ARM9opBL          ,
    ARM9opBL          ,
    ARM9opBL          ,
    ARM9opBL          ,

    /*0xBE*/
    ARM9opBL          ,
    ARM9opBL          ,
    ARM9opBL          ,
    ARM9opBL          ,
    ARM9opBL          ,
    ARM9opBL          ,
    ARM9opBL          ,
    ARM9opBL          ,
    ARM9opBL          ,
    ARM9opBL          ,
    ARM9opBL          ,
    ARM9opBL          ,
    ARM9opBL          ,
    ARM9opBL          ,
    ARM9opBL          ,
    ARM9opBL          ,

    /*0xBF*/
    ARM9opBL          ,
    ARM9opBL          ,
    ARM9opBL          ,
    ARM9opBL          ,
    ARM9opBL          ,
    ARM9opBL          ,
    ARM9opBL          ,
    ARM9opBL          ,
    ARM9opBL          ,
    ARM9opBL          ,
    ARM9opBL          ,
    ARM9opBL          ,
    ARM9opBL          ,
    ARM9opBL          ,
    ARM9opBL          ,
    ARM9opBL          ,

    /*0xC0*/ // Coprocessors undefined here!
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,

    /*0xC1*/
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,

    /*0xC2*/
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,

    /*0xC3*/
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,

    /*0xC4*/
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,

    /*0xC5*/
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,

    /*0xC6*/
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,

    /*0xC7*/
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,

    /*0xC8*/
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,

    /*0xC9*/
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,

    /*0xCA*/
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,

    /*0xCB*/
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,

    /*0xCC*/
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,

    /*0xCD*/
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,

    /*0xCE*/
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,

    /*0xCF*/
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,

    /*0xD0*/
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,

    /*0xD1*/
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,

    /*0xD2*/
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,

    /*0xD3*/
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,

    /*0xD4*/
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,

    /*0xD5*/
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,

    /*0xD6*/
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,

    /*0xD7*/
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,

    /*0xD8*/
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,

    /*0xD9*/
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,

    /*0xDA*/
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,

    /*0xDB*/
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,

    /*0xDC*/
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,

    /*0xDD*/
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,

    /*0xDE*/
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,

    /*0xDF*/
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,
    ARM9opUNI         ,

    /*0xE0*/
    ARM9opCDP         ,
    ARM9opMCR         ,
    ARM9opCDP         ,
    ARM9opMCR         ,
    ARM9opCDP         ,
    ARM9opMCR         ,
    ARM9opCDP         ,
    ARM9opMCR         ,
    ARM9opCDP         ,
    ARM9opMCR         ,
    ARM9opCDP         ,
    ARM9opMCR         ,
    ARM9opCDP         ,
    ARM9opMCR         ,
    ARM9opCDP         ,
    ARM9opMCR         ,

    /*0xE1*/
    ARM9opCDP         ,
    ARM9opMRC         ,
    ARM9opCDP         ,
    ARM9opMRC         ,
    ARM9opCDP         ,
    ARM9opMRC         ,
    ARM9opCDP         ,
    ARM9opMRC         ,
    ARM9opCDP         ,
    ARM9opMRC         ,
    ARM9opCDP         ,
    ARM9opMRC         ,
    ARM9opCDP         ,
    ARM9opMRC         ,
    ARM9opCDP         ,
    ARM9opMRC         ,

    /*0xE2*/
    ARM9opCDP         ,
    ARM9opMCR         ,
    ARM9opCDP         ,
    ARM9opMCR         ,
    ARM9opCDP         ,
    ARM9opMCR         ,
    ARM9opCDP         ,
    ARM9opMCR         ,
    ARM9opCDP         ,
    ARM9opMCR         ,
    ARM9opCDP         ,
    ARM9opMCR         ,
    ARM9opCDP         ,
    ARM9opMCR         ,
    ARM9opCDP         ,
    ARM9opMCR         ,

    /*0xE3*/
    ARM9opCDP         ,
    ARM9opMRC         ,
    ARM9opCDP         ,
    ARM9opMRC         ,
    ARM9opCDP         ,
    ARM9opMRC         ,
    ARM9opCDP         ,
    ARM9opMRC         ,
    ARM9opCDP         ,
    ARM9opMRC         ,
    ARM9opCDP         ,
    ARM9opMRC         ,
    ARM9opCDP         ,
    ARM9opMRC         ,
    ARM9opCDP         ,
    ARM9opMRC         ,

    /*0xE4*/
    ARM9opCDP         ,
    ARM9opMCR         ,
    ARM9opCDP         ,
    ARM9opMCR         ,
    ARM9opCDP         ,
    ARM9opMCR         ,
    ARM9opCDP         ,
    ARM9opMCR         ,
    ARM9opCDP         ,
    ARM9opMCR         ,
    ARM9opCDP         ,
    ARM9opMCR         ,
    ARM9opCDP         ,
    ARM9opMCR         ,
    ARM9opCDP         ,
    ARM9opMCR         ,

    /*0xE5*/
    ARM9opCDP         ,
    ARM9opMRC         ,
    ARM9opCDP         ,
    ARM9opMRC         ,
    ARM9opCDP         ,
    ARM9opMRC         ,
    ARM9opCDP         ,
    ARM9opMRC         ,
    ARM9opCDP         ,
    ARM9opMRC         ,
    ARM9opCDP         ,
    ARM9opMRC         ,
    ARM9opCDP         ,
    ARM9opMRC         ,
    ARM9opCDP         ,
    ARM9opMRC         ,

    /*0xE6*/
    ARM9opCDP         ,
    ARM9opMCR         ,
    ARM9opCDP         ,
    ARM9opMCR         ,
    ARM9opCDP         ,
    ARM9opMCR         ,
    ARM9opCDP         ,
    ARM9opMCR         ,
    ARM9opCDP         ,
    ARM9opMCR         ,
    ARM9opCDP         ,
    ARM9opMCR         ,
    ARM9opCDP         ,
    ARM9opMCR         ,
    ARM9opCDP         ,
    ARM9opMCR         ,

    /*0xE7*/
    ARM9opCDP         ,
    ARM9opMRC         ,
    ARM9opCDP         ,
    ARM9opMRC         ,
    ARM9opCDP         ,
    ARM9opMRC         ,
    ARM9opCDP         ,
    ARM9opMRC         ,
    ARM9opCDP         ,
    ARM9opMRC         ,
    ARM9opCDP         ,
    ARM9opMRC         ,
    ARM9opCDP         ,
    ARM9opMRC         ,
    ARM9opCDP         ,
    ARM9opMRC         ,

    /*0xE8*/
    ARM9opCDP         ,
    ARM9opMCR         ,
    ARM9opCDP         ,
    ARM9opMCR         ,
    ARM9opCDP         ,
    ARM9opMCR         ,
    ARM9opCDP         ,
    ARM9opMCR         ,
    ARM9opCDP         ,
    ARM9opMCR         ,
    ARM9opCDP         ,
    ARM9opMCR         ,
    ARM9opCDP         ,
    ARM9opMCR         ,
    ARM9opCDP         ,
    ARM9opMCR         ,

    /*0xE9*/
    ARM9opCDP         ,
    ARM9opMRC         ,
    ARM9opCDP         ,
    ARM9opMRC         ,
    ARM9opCDP         ,
    ARM9opMRC         ,
    ARM9opCDP         ,
    ARM9opMRC         ,
    ARM9opCDP         ,
    ARM9opMRC         ,
    ARM9opCDP         ,
    ARM9opMRC         ,
    ARM9opCDP         ,
    ARM9opMRC         ,
    ARM9opCDP         ,
    ARM9opMRC         ,

    /*0xEA*/
    ARM9opCDP         ,
    ARM9opMCR         ,
    ARM9opCDP         ,
    ARM9opMCR         ,
    ARM9opCDP         ,
    ARM9opMCR         ,
    ARM9opCDP         ,
    ARM9opMCR         ,
    ARM9opCDP         ,
    ARM9opMCR         ,
    ARM9opCDP         ,
    ARM9opMCR         ,
    ARM9opCDP         ,
    ARM9opMCR         ,
    ARM9opCDP         ,
    ARM9opMCR         ,

    /*0xEB*/
    ARM9opCDP         ,
    ARM9opMRC         ,
    ARM9opCDP         ,
    ARM9opMRC         ,
    ARM9opCDP         ,
    ARM9opMRC         ,
    ARM9opCDP         ,
    ARM9opMRC         ,
    ARM9opCDP         ,
    ARM9opMRC         ,
    ARM9opCDP         ,
    ARM9opMRC         ,
    ARM9opCDP         ,
    ARM9opMRC         ,
    ARM9opCDP         ,
    ARM9opMRC         ,

    /*0xEC*/
    ARM9opCDP         ,
    ARM9opMCR         ,
    ARM9opCDP         ,
    ARM9opMCR         ,
    ARM9opCDP         ,
    ARM9opMCR         ,
    ARM9opCDP         ,
    ARM9opMCR         ,
    ARM9opCDP         ,
    ARM9opMCR         ,
    ARM9opCDP         ,
    ARM9opMCR         ,
    ARM9opCDP         ,
    ARM9opMCR         ,
    ARM9opCDP         ,
    ARM9opMCR         ,

    /*0xED*/
    ARM9opCDP         ,
    ARM9opMRC         ,
    ARM9opCDP         ,
    ARM9opMRC         ,
    ARM9opCDP         ,
    ARM9opMRC         ,
    ARM9opCDP         ,
    ARM9opMRC         ,
    ARM9opCDP         ,
    ARM9opMRC         ,
    ARM9opCDP         ,
    ARM9opMRC         ,
    ARM9opCDP         ,
    ARM9opMRC         ,
    ARM9opCDP         ,
    ARM9opMRC         ,

    /*0xEE*/
    ARM9opCDP         ,
    ARM9opMCR         ,
    ARM9opCDP         ,
    ARM9opMCR         ,
    ARM9opCDP         ,
    ARM9opMCR         ,
    ARM9opCDP         ,
    ARM9opMCR         ,
    ARM9opCDP         ,
    ARM9opMCR         ,
    ARM9opCDP         ,
    ARM9opMCR         ,
    ARM9opCDP         ,
    ARM9opMCR         ,
    ARM9opCDP         ,
    ARM9opMCR         ,

    /*0xEF*/
    ARM9opCDP         ,
    ARM9opMRC         ,
    ARM9opCDP         ,
    ARM9opMRC         ,
    ARM9opCDP         ,
    ARM9opMRC         ,
    ARM9opCDP         ,
    ARM9opMRC         ,
    ARM9opCDP         ,
    ARM9opMRC         ,
    ARM9opCDP         ,
    ARM9opMRC         ,
    ARM9opCDP         ,
    ARM9opMRC         ,
    ARM9opCDP         ,
    ARM9opMRC         ,

    /*0xF0*/
    ARM9opSWI         ,
    ARM9opSWI         ,
    ARM9opSWI         ,
    ARM9opSWI         ,
    ARM9opSWI         ,
    ARM9opSWI         ,
    ARM9opSWI         ,
    ARM9opSWI         ,
    ARM9opSWI         ,
    ARM9opSWI         ,
    ARM9opSWI         ,
    ARM9opSWI         ,
    ARM9opSWI         ,
    ARM9opSWI         ,
    ARM9opSWI         ,
    ARM9opSWI         ,

    /*0xF1*/
    ARM9opSWI         ,
    ARM9opSWI         ,
    ARM9opSWI         ,
    ARM9opSWI         ,
    ARM9opSWI         ,
    ARM9opSWI         ,
    ARM9opSWI         ,
    ARM9opSWI         ,
    ARM9opSWI         ,
    ARM9opSWI         ,
    ARM9opSWI         ,
    ARM9opSWI         ,
    ARM9opSWI         ,
    ARM9opSWI         ,
    ARM9opSWI         ,
    ARM9opSWI         ,

    /*0xF2*/
    ARM9opSWI         ,
    ARM9opSWI         ,
    ARM9opSWI         ,
    ARM9opSWI         ,
    ARM9opSWI         ,
    ARM9opSWI         ,
    ARM9opSWI         ,
    ARM9opSWI         ,
    ARM9opSWI         ,
    ARM9opSWI         ,
    ARM9opSWI         ,
    ARM9opSWI         ,
    ARM9opSWI         ,
    ARM9opSWI         ,
    ARM9opSWI         ,
    ARM9opSWI         ,

    /*0xF3*/
    ARM9opSWI         ,
    ARM9opSWI         ,
    ARM9opSWI         ,
    ARM9opSWI         ,
    ARM9opSWI         ,
    ARM9opSWI         ,
    ARM9opSWI         ,
    ARM9opSWI         ,
    ARM9opSWI         ,
    ARM9opSWI         ,
    ARM9opSWI         ,
    ARM9opSWI         ,
    ARM9opSWI         ,
    ARM9opSWI         ,
    ARM9opSWI         ,
    ARM9opSWI         ,

    /*0xF4*/
    ARM9opSWI         ,
    ARM9opSWI         ,
    ARM9opSWI         ,
    ARM9opSWI         ,
    ARM9opSWI         ,
    ARM9opSWI         ,
    ARM9opSWI         ,
    ARM9opSWI         ,
    ARM9opSWI         ,
    ARM9opSWI         ,
    ARM9opSWI         ,
    ARM9opSWI         ,
    ARM9opSWI         ,
    ARM9opSWI         ,
    ARM9opSWI         ,
    ARM9opSWI         ,

    /*0xF5*/
    ARM9opSWI         ,
    ARM9opSWI         ,
    ARM9opSWI         ,
    ARM9opSWI         ,
    ARM9opSWI         ,
    ARM9opSWI         ,
    ARM9opSWI         ,
    ARM9opSWI         ,
    ARM9opSWI         ,
    ARM9opSWI         ,
    ARM9opSWI         ,
    ARM9opSWI         ,
    ARM9opSWI         ,
    ARM9opSWI         ,
    ARM9opSWI         ,
    ARM9opSWI         ,

    /*0xF6*/
    ARM9opSWI         ,
    ARM9opSWI         ,
    ARM9opSWI         ,
    ARM9opSWI         ,
    ARM9opSWI         ,
    ARM9opSWI         ,
    ARM9opSWI         ,
    ARM9opSWI         ,
    ARM9opSWI         ,
    ARM9opSWI         ,
    ARM9opSWI         ,
    ARM9opSWI         ,
    ARM9opSWI         ,
    ARM9opSWI         ,
    ARM9opSWI         ,
    ARM9opSWI         ,

    /*0xF7*/
    ARM9opSWI         ,
    ARM9opSWI         ,
    ARM9opSWI         ,
    ARM9opSWI         ,
    ARM9opSWI         ,
    ARM9opSWI         ,
    ARM9opSWI         ,
    ARM9opSWI         ,
    ARM9opSWI         ,
    ARM9opSWI         ,
    ARM9opSWI         ,
    ARM9opSWI         ,
    ARM9opSWI         ,
    ARM9opSWI         ,
    ARM9opSWI         ,
    ARM9opSWI         ,

    /*0xF8*/
    ARM9opSWI         ,
    ARM9opSWI         ,
    ARM9opSWI         ,
    ARM9opSWI         ,
    ARM9opSWI         ,
    ARM9opSWI         ,
    ARM9opSWI         ,
    ARM9opSWI         ,
    ARM9opSWI         ,
    ARM9opSWI         ,
    ARM9opSWI         ,
    ARM9opSWI         ,
    ARM9opSWI         ,
    ARM9opSWI         ,
    ARM9opSWI         ,
    ARM9opSWI         ,

    /*0xF9*/
    ARM9opSWI         ,
    ARM9opSWI         ,
    ARM9opSWI         ,
    ARM9opSWI         ,
    ARM9opSWI         ,
    ARM9opSWI         ,
    ARM9opSWI         ,
    ARM9opSWI         ,
    ARM9opSWI         ,
    ARM9opSWI         ,
    ARM9opSWI         ,
    ARM9opSWI         ,
    ARM9opSWI         ,
    ARM9opSWI         ,
    ARM9opSWI         ,
    ARM9opSWI         ,

    /*0xFA*/
    ARM9opSWI         ,
    ARM9opSWI         ,
    ARM9opSWI         ,
    ARM9opSWI         ,
    ARM9opSWI         ,
    ARM9opSWI         ,
    ARM9opSWI         ,
    ARM9opSWI         ,
    ARM9opSWI         ,
    ARM9opSWI         ,
    ARM9opSWI         ,
    ARM9opSWI         ,
    ARM9opSWI         ,
    ARM9opSWI         ,
    ARM9opSWI         ,
    ARM9opSWI         ,

    /*0xFB*/
    ARM9opSWI         ,
    ARM9opSWI         ,
    ARM9opSWI         ,
    ARM9opSWI         ,
    ARM9opSWI         ,
    ARM9opSWI         ,
    ARM9opSWI         ,
    ARM9opSWI         ,
    ARM9opSWI         ,
    ARM9opSWI         ,
    ARM9opSWI         ,
    ARM9opSWI         ,
    ARM9opSWI         ,
    ARM9opSWI         ,
    ARM9opSWI         ,
    ARM9opSWI         ,

    /*0xFC*/
    ARM9opSWI         ,
    ARM9opSWI         ,
    ARM9opSWI         ,
    ARM9opSWI         ,
    ARM9opSWI         ,
    ARM9opSWI         ,
    ARM9opSWI         ,
    ARM9opSWI         ,
    ARM9opSWI         ,
    ARM9opSWI         ,
    ARM9opSWI         ,
    ARM9opSWI         ,
    ARM9opSWI         ,
    ARM9opSWI         ,
    ARM9opSWI         ,
    ARM9opSWI         ,

    /*0xFD*/
    ARM9opSWI         ,
    ARM9opSWI         ,
    ARM9opSWI         ,
    ARM9opSWI         ,
    ARM9opSWI         ,
    ARM9opSWI         ,
    ARM9opSWI         ,
    ARM9opSWI         ,
    ARM9opSWI         ,
    ARM9opSWI         ,
    ARM9opSWI         ,
    ARM9opSWI         ,
    ARM9opSWI         ,
    ARM9opSWI         ,
    ARM9opSWI         ,
    ARM9opSWI         ,

    /*0xFE*/
    ARM9opSWI         ,
    ARM9opSWI         ,
    ARM9opSWI         ,
    ARM9opSWI         ,
    ARM9opSWI         ,
    ARM9opSWI         ,
    ARM9opSWI         ,
    ARM9opSWI         ,
    ARM9opSWI         ,
    ARM9opSWI         ,
    ARM9opSWI         ,
    ARM9opSWI         ,
    ARM9opSWI         ,
    ARM9opSWI         ,
    ARM9opSWI         ,
    ARM9opSWI         ,

    /*0xFF*/
    ARM9opSWI         ,
    ARM9opSWI         ,
    ARM9opSWI         ,
    ARM9opSWI         ,
    ARM9opSWI         ,
    ARM9opSWI         ,
    ARM9opSWI         ,
    ARM9opSWI         ,
    ARM9opSWI         ,
    ARM9opSWI         ,
    ARM9opSWI         ,
    ARM9opSWI         ,
    ARM9opSWI         ,
    ARM9opSWI         ,
    ARM9opSWI         ,
    ARM9opSWI         ,
};

const opfptr thumb9ops[]={
    //0x00
    Thumb9opLSLimm    ,
    Thumb9opLSLimm    ,
    Thumb9opLSLimm    ,
    Thumb9opLSLimm    ,
    Thumb9opLSLimm    ,
    Thumb9opLSLimm    ,
    Thumb9opLSLimm    ,
    Thumb9opLSLimm    ,
    Thumb9opLSRimm    ,
    Thumb9opLSRimm    ,
    Thumb9opLSRimm    ,
    Thumb9opLSRimm    ,
    Thumb9opLSRimm    ,
    Thumb9opLSRimm    ,
    Thumb9opLSRimm    ,
    Thumb9opLSRimm    ,

    //0x10
    Thumb9opASRimm    ,
    Thumb9opASRimm    ,
    Thumb9opASRimm    ,
    Thumb9opASRimm    ,
    Thumb9opASRimm    ,
    Thumb9opASRimm    ,
    Thumb9opASRimm    ,
    Thumb9opASRimm    ,
    Thumb9opADDreg    ,
    Thumb9opADDreg    ,
    Thumb9opSUBreg    ,
    Thumb9opSUBreg    ,
    Thumb9opADDimm3   ,
    Thumb9opADDimm3   ,
    Thumb9opSUBimm3   ,
    Thumb9opSUBimm3   ,

    //0x20
    Thumb9opMOVimm8r0 ,
    Thumb9opMOVimm8r1 ,
    Thumb9opMOVimm8r2 ,
    Thumb9opMOVimm8r3 ,
    Thumb9opMOVimm8r4 ,
    Thumb9opMOVimm8r5 ,
    Thumb9opMOVimm8r6 ,
    Thumb9opMOVimm8r7 ,
    Thumb9opCMPimm8r0 ,
    Thumb9opCMPimm8r1 ,
    Thumb9opCMPimm8r2 ,
    Thumb9opCMPimm8r3 ,
    Thumb9opCMPimm8r4 ,
    Thumb9opCMPimm8r5 ,
    Thumb9opCMPimm8r6 ,
    Thumb9opCMPimm8r7 ,

    //0x30
    Thumb9opADDimm8r0 ,
    Thumb9opADDimm8r1 ,
    Thumb9opADDimm8r2 ,
    Thumb9opADDimm8r3 ,
    Thumb9opADDimm8r4 ,
    Thumb9opADDimm8r5 ,
    Thumb9opADDimm8r6 ,
    Thumb9opADDimm8r7 ,
    Thumb9opSUBimm8r0 ,
    Thumb9opSUBimm8r1 ,
    Thumb9opSUBimm8r2 ,
    Thumb9opSUBimm8r3 ,
    Thumb9opSUBimm8r4 ,
    Thumb9opSUBimm8r5 ,
    Thumb9opSUBimm8r6 ,
    Thumb9opSUBimm8r7 ,

    //0x40
    Thumb9opDPg1      ,
    Thumb9opDPg2      ,
    Thumb9opDPg3      ,
    Thumb9opDPg4      ,
    Thumb9opADDH      ,
    Thumb9opCMPH      ,
    Thumb9opMOVH      ,
    Thumb9opBXreg     ,
    Thumb9opLDRPCr0   ,
    Thumb9opLDRPCr1   ,
    Thumb9opLDRPCr2   ,
    Thumb9opLDRPCr3   ,
    Thumb9opLDRPCr4   ,
    Thumb9opLDRPCr5   ,
    Thumb9opLDRPCr6   ,
    Thumb9opLDRPCr7   ,

    //0x50
    Thumb9opSTRreg    ,
    Thumb9opSTRreg    ,
    Thumb9opSTRHreg   ,
    Thumb9opSTRHreg   ,
    Thumb9opSTRBreg   ,
    Thumb9opSTRBreg   ,
    Thumb9opLDRSBreg  ,
    Thumb9opLDRSBreg  ,
    Thumb9opLDRreg    ,
    Thumb9opLDRreg    ,
    Thumb9opLDRHreg   ,
    Thumb9opLDRHreg   ,
    Thumb9opLDRBreg   ,
    Thumb9opLDRBreg   ,
    Thumb9opLDRSHreg  ,
    Thumb9opLDRSHreg  ,

    //0x60
    Thumb9opSTRimm5   ,
    Thumb9opSTRimm5   ,
    Thumb9opSTRimm5   ,
    Thumb9opSTRimm5   ,
    Thumb9opSTRimm5   ,
    Thumb9opSTRimm5   ,
    Thumb9opSTRimm5   ,
    Thumb9opSTRimm5   ,
    Thumb9opLDRimm5   ,
    Thumb9opLDRimm5   ,
    Thumb9opLDRimm5   ,
    Thumb9opLDRimm5   ,
    Thumb9opLDRimm5   ,
    Thumb9opLDRimm5   ,
    Thumb9opLDRimm5   ,
    Thumb9opLDRimm5   ,

    //0x70
    Thumb9opSTRBimm5  ,
    Thumb9opSTRBimm5  ,
    Thumb9opSTRBimm5  ,
    Thumb9opSTRBimm5  ,
    Thumb9opSTRBimm5  ,
    Thumb9opSTRBimm5  ,
    Thumb9opSTRBimm5  ,
    Thumb9opSTRBimm5  ,
    Thumb9opLDRBimm5  ,
    Thumb9opLDRBimm5  ,
    Thumb9opLDRBimm5  ,
    Thumb9opLDRBimm5  ,
    Thumb9opLDRBimm5  ,
    Thumb9opLDRBimm5  ,
    Thumb9opLDRBimm5  ,
    Thumb9opLDRBimm5  ,

    //0x80
    Thumb9opSTRHimm5  ,
    Thumb9opSTRHimm5  ,
    Thumb9opSTRHimm5  ,
    Thumb9opSTRHimm5  ,
    Thumb9opSTRHimm5  ,
    Thumb9opSTRHimm5  ,
    Thumb9opSTRHimm5  ,
    Thumb9opSTRHimm5  ,
    Thumb9opLDRHimm5  ,
    Thumb9opLDRHimm5  ,
    Thumb9opLDRHimm5  ,
    Thumb9opLDRHimm5  ,
    Thumb9opLDRHimm5  ,
    Thumb9opLDRHimm5  ,
    Thumb9opLDRHimm5  ,
    Thumb9opLDRHimm5  ,

    //0x90
    Thumb9opSTRSPr0   ,
    Thumb9opSTRSPr1   ,
    Thumb9opSTRSPr2   ,
    Thumb9opSTRSPr3   ,
    Thumb9opSTRSPr4   ,
    Thumb9opSTRSPr5   ,
    Thumb9opSTRSPr6   ,
    Thumb9opSTRSPr7   ,
    Thumb9opLDRSPr0   ,
    Thumb9opLDRSPr1   ,
    Thumb9opLDRSPr2   ,
    Thumb9opLDRSPr3   ,
    Thumb9opLDRSPr4   ,
    Thumb9opLDRSPr5   ,
    Thumb9opLDRSPr6   ,
    Thumb9opLDRSPr7   ,

    //0xA0
    Thumb9opADDPCr0   ,
    Thumb9opADDPCr1   ,
    Thumb9opADDPCr2   ,
    Thumb9opADDPCr3   ,
    Thumb9opADDPCr4   ,
    Thumb9opADDPCr5   ,
    Thumb9opADDPCr6   ,
    Thumb9opADDPCr7   ,
    Thumb9opADDSPr0   ,
    Thumb9opADDSPr1   ,
    Thumb9opADDSPr2   ,
    Thumb9opADDSPr3   ,
    Thumb9opADDSPr4   ,
    Thumb9opADDSPr5   ,
    Thumb9opADDSPr6   ,
    Thumb9opADDSPr7   ,

    //0xB0
    Thumb9opADDSPimm7 ,
    Thumb9opUND       ,  // Misc map: unallocated
    Thumb9opUND       ,  // Misc map: unallocated
    Thumb9opUND       ,  // Misc map: unallocated
    Thumb9opPUSH      ,
    Thumb9opPUSHlr    ,
    Thumb9opUND       ,  // Misc map: unallocated
    Thumb9opUND       ,  // Misc map: unallocated
    Thumb9opUND       ,  // Misc map: unallocated
    Thumb9opUND       ,  // Misc map: unallocated
    Thumb9opUND       ,  // Misc map: unallocated
    Thumb9opUND       ,  // Misc map: unallocated
    Thumb9opPOP       ,
    Thumb9opPOPpc     ,
    Thumb9opBKPT      ,
    Thumb9opUND       ,  // Misc map: unallocated

    //0xC0
    Thumb9opSTMIAr0   ,
    Thumb9opSTMIAr1   ,
    Thumb9opSTMIAr2   ,
    Thumb9opSTMIAr3   ,
    Thumb9opSTMIAr4   ,
    Thumb9opSTMIAr5   ,
    Thumb9opSTMIAr6   ,
    Thumb9opSTMIAr7   ,
    Thumb9opLDMIAr0   ,
    Thumb9opLDMIAr1   ,
    Thumb9opLDMIAr2   ,
    Thumb9opLDMIAr3   ,
    Thumb9opLDMIAr4   ,
    Thumb9opLDMIAr5   ,
    Thumb9opLDMIAr6   ,
    Thumb9opLDMIAr7   ,

    //0xD0
    Thumb9opBEQ       ,
    Thumb9opBNE       ,
    Thumb9opBCS       ,
    Thumb9opBCC       ,
    Thumb9opBMI       ,
    Thumb9opBPL       ,
    Thumb9opBVS       ,
    Thumb9opBVC       ,
    Thumb9opBHI       ,
    Thumb9opBLS       ,
    Thumb9opBGE       ,
    Thumb9opBLT       ,
    Thumb9opBGT       ,
    Thumb9opBLE       ,
    Thumb9opUND       ,  // Covered by unconditional
    Thumb9opSWI       ,

    //0xE0
    Thumb9opB         ,
    Thumb9opB         ,
    Thumb9opB         ,
    Thumb9opB         ,
    Thumb9opB         ,
    Thumb9opB         ,
    Thumb9opB         ,
    Thumb9opB         ,
    Thumb9opUND       ,  // Defined in ARM5!
    Thumb9opUND       ,  // Defined in ARM5!
    Thumb9opUND       ,  // Defined in ARM5!
    Thumb9opUND       ,  // Defined in ARM5!
    Thumb9opUND       ,  // Defined in ARM5!
    Thumb9opUND       ,  // Defined in ARM5!
    Thumb9opUND       ,  // Defined in ARM5!
    Thumb9opUND       ,  // Defined in ARM5!

    //0xF0
    Thumb9opBLsetup   ,
    Thumb9opBLsetup   ,
    Thumb9opBLsetup   ,
    Thumb9opBLsetup   ,
    Thumb9opBLsetup   ,
    Thumb9opBLsetup   ,
    Thumb9opBLsetup   ,
    Thumb9opBLsetup   ,
    Thumb9opBLoff     ,
    Thumb9opBLoff     ,
    Thumb9opBLoff     ,
    Thumb9opBLoff     ,
    Thumb9opBLoff     ,
    Thumb9opBLoff     ,
    Thumb9opBLoff     ,
    Thumb9opBLoff     ,
};

#endif//__ARM9FUNC_H_

/*** EOF:arm9func.h ******************************************************/

