#include <stdio.h>
#include "sram.h"

static unsigned char m_sram[SRAM_SIZE];

void sram_clear ( void )	{
	
	unsigned int i;

	for( i=0 ; i<SRAM_SIZE ; i++ )
		m_sram[i] = 0;

}

unsigned char sram_read ( unsigned int address ) {

	address = address - SRAM_ADDRESS;
	
	if ( address > SRAM_SIZE )
		return 0;

	return m_sram[address];

}

void sram_write ( unsigned int address, unsigned char value )	{

	address = address - SRAM_ADDRESS;

	if ( address < SRAM_SIZE )
		m_sram[address] = value;
	
}

int sram_load ( const char *file_name )	{
	
	FILE *file;

	file = fopen ( file_name, "rb" );
	if( file == NULL )
		return (int)NULL;

	fread ( m_sram, SRAM_SIZE, 1, file );

	fclose ( file );

	return 1;

}

int sram_save ( const char *file_name )	{

	FILE *file;

	file = fopen ( file_name, "wb" );
	if( file == NULL )
		return (int)NULL;

	fwrite ( m_sram, SRAM_SIZE, 1, file );

	fclose ( file );

	return 1;

}