/**************************************************************************
* DSemu: Memory management function definitions (mmu.h)                   *
* Released under the terms of the BSD Public Licence                      *
* Imran Nazar (tf@oopsilon.com), 2004                                     *
**************************************************************************/

#ifndef __MMU_H_
#define __MMU_H_

#include "defs.h"
#include "cache.h"

RAMWORD *EWRAM, *IWRAM, *GameROM, *BIOS;

int MMUinit(char*);
int MMUreset();
void MMUfini();

u8  MMUrdB(u32, u32);
u16 MMUrdH(u32, u32);
u32 MMUrdW(u32, u32);
RAMWORD MMUrdS(u32, u32);

void MMUwrB(u32, u32, u8 );
void MMUwrH(u32, u32, u16);
void MMUwrW(u32, u32, u32);
void MMUwrS(u32, u32, RAMWORD);

extern OPCODE ARM7condAL(), ARM7opUNL();
extern RAMWORD ARM7opDecode(u32);

#endif//__MMU_H_

/*** EOF:mmu.h ***********************************************************/

