/**************************************************************************
* DSemu: Atomic message logging module (log.c)                            *
* Released under the terms of the BSD Public Licence                      *
* Imran Nazar (tf@oopsilon.com), 2004                                     *
**************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#ifdef _MSC_VER
#include <windows.h>
#else
#include <sys/time.h>
#endif

#include "vtbl.h"
#include "log.h"

char LogPath[8100];

LOGVTBL *getVt()
{
    return &vtbl;
}

//-------------------------------------------------------------------------
// Function: LogInit
// Notes: Doesn't actually do anything, serves as a INIT placeholder.

void LogInit()
{
  char str[8192]; int a,len;
  GetModuleFileName(NULL,str,8192);
  len=strlen(str);
  for(a=len;a;a--) if(str[a]=='\\') break;
  str[a]=0;

  sprintf(LogPath, "%s\\log.txt", str);
  vtbl.file=LogPath;
  LogAppend("");
  sprintf(str,"Opening log: %s",LogPath);
  LogAppend(str);
  LogAppend("LOG: Starting session.");
}

//-------------------------------------------------------------------------
// Function: LogShutdown
// Notes: Again, just a placeholder really.

void LogShutdown()
{
  LogAppend("LOG: Ending session.");
}

//-------------------------------------------------------------------------
// Function: logvt->append
// Notes: The meat of the logging facility. Acts as an atomic function, so
//        the logfile isn't open for extended periods. The timing is
//        system-dependent, so MSVC's #define is used to check compilers.

void LogAppend(char *str)
{
  FILE *log;

#ifdef _MSC_VER

  SYSTEMTIME ti;
  log=fopen(LogPath,"a");
  if(!log)
  {
      MessageBox(NULL, "Unable to initialise logfile. DSemu cannot continue.", "Logging Initialisation Error", MB_OK);
      exit(1);
  }
  GetSystemTime(&ti);
  fprintf(log,"[%04d%02d%02d.%02d:%02d:%02d] %s\n",ti.wYear,ti.wMonth,ti.wDay,
                                                   ti.wHour,ti.wMinute,ti.wSecond,str);
#else

  struct tm ti; time_t t;
  log=fopen("log.txt","a"); if(!log) exit(1);
  time(&t); localtime_r(&t,&ti);
  fprintf(log,"[%04d%02d%02d.%02d:%02d:%02d] %s\n",ti.tm_year+1900,ti.tm_mon+1,ti.tm_mday,
                                                   ti.tm_hour,ti.tm_min,ti.tm_sec,str);

#endif

  fclose(log);
}

/*** EOF:log.c ***********************************************************/

