/**************************************************************************
* DSemu: System-wide integer size definitions (defs.h)                    *
* Released under the terms of the BSD Public Licence                      *
* Imran Nazar (tf@oopsilon.com), 2004                                     *
**************************************************************************/

#ifndef __DEFS_H_
#define __DEFS_H_

#include "config.h"

#ifndef FALSE
#define FALSE 1
#endif

#ifndef TRUE
#define TRUE 0
#endif

typedef unsigned char u8;
typedef unsigned short u16;
typedef unsigned int u32;
typedef unsigned __int64 u64;

typedef signed char s8;
typedef signed short s16;
typedef signed int s32;
typedef signed __int64 s64;

typedef int OPCODE;

typedef void (*fptr)();
typedef int (*intfptr)();
typedef OPCODE (*opfptr)();

#ifndef _MSC_VER
#define __int64 long long
#endif

#define PLUGIN_CPU 1
#define PLUGIN_MMU 2
#define PLUGIN_GPU 3
#define PLUGIN_APU 4

#endif//__DEFS_H_

/*** EOF:defs.h **********************************************************/

