/**************************************************************************
* DSemu: ARM9 per-instruction disassembler (arm9dasm.c)                   *
* Released under the terms of the BSD Public Licence                      *
* Imran Nazar (tf@oopsilon.com), 2004                                     *
**************************************************************************/

#include <stdio.h>
#include <string.h>
#include "arm9dasm.h"
//#include "vtbl.h"

char *ARM9DASM(u32 op)
{
    static char str[100];
    u16 idx=((op&0x0FF00000)>>16)+((op&0x000000F0)>>4);
    arm9dasmops[idx].addr(op);
    arm9dasmstr[32]=0;
    sprintf(str,arm9dasmops[idx].op,
        ARM9DASMcond[((op&0xF0000000)>>28)],arm9dasmstr);
    return str;
}

char *Thumb9DASM(u32 op)
{
    static char str[100];
    u8 idx=((op&0xFF00)>>8);
    thumb9dasmops[idx].addr(op);
    arm9dasmstr[32]=0;
    sprintf(str,thumb9dasmops[idx].op,arm9dasmstr);
    return str;
}

void ARM9DASMun(u32 op)
{
    sprintf(arm9dasmstr,"");
}

//---Branching-------------------------------------------------------------

void ARM9DASMb(u32 op)
{
    signed int b = (op&0x00800000)?(0xFF000000|(op&0x00FFFFFF))
                                  :(op&0x00FFFFFF);
    sprintf(arm9dasmstr,"$%08X",arm9reg.tmp1+8+(b*4));
}

void ARM9DASMbreg(u32 op)
{
    sprintf(arm9dasmstr,"r%d",ARM9DASM_RM);
}

//---Data Processing addressing modes, opcodes-----------------------------

void ARM9DASMreg(u32 op)
{
    sprintf(arm9dasmstr,"r%d, r%d, r%d", ARM9DASM_RD, ARM9DASM_RN, ARM9DASM_RM);
}

void ARM9DASMimm(u32 op)
{
    arm9dasmtmp3 = op&255;
    arm9dasmtmp4 = (op&0x00000F00)>>7;
    arm9dasmtmp1 = (arm9dasmtmp3>>arm9dasmtmp4)|((arm9dasmtmp3&((1<<arm9dasmtmp4)-1))<<(32-arm9dasmtmp4));
    sprintf(arm9dasmstr,"r%d, r%d, #$%08X", ARM9DASM_RD, ARM9DASM_RN, arm9dasmtmp1);
}

void ARM9DASMlli(u32 op)
{
    arm9dasmtmp4=(op&0x00000F80)>>7;
    (arm9dasmtmp4)?
       sprintf(arm9dasmstr,"r%d, r%d, r%d, LSL #%d", ARM9DASM_RD, ARM9DASM_RN, ARM9DASM_RM, arm9dasmtmp4):
       sprintf(arm9dasmstr,"r%d, r%d, r%d", ARM9DASM_RD, ARM9DASM_RN, ARM9DASM_RM);
}

void ARM9DASMllr(u32 op)
{
    sprintf(arm9dasmstr,"r%d, r%d, r%d, LSL r%d", ARM9DASM_RD, ARM9DASM_RN, ARM9DASM_RM, ARM9DASM_RS);
}

void ARM9DASMlri(u32 op)
{
    arm9dasmtmp4=(op&0x00000F80)>>7;
    sprintf(arm9dasmstr,"r%d, r%d, r%d, LSR #%d", ARM9DASM_RD, ARM9DASM_RN, ARM9DASM_RM, arm9dasmtmp4);
}

void ARM9DASMlrr(u32 op)
{
    sprintf(arm9dasmstr,"r%d, r%d, r%d, LSR r%d", ARM9DASM_RD, ARM9DASM_RN, ARM9DASM_RM, ARM9DASM_RS);
}

void ARM9DASMari(u32 op) 
{
    arm9dasmtmp4=(op&0x00000F80)>>7; 
    sprintf(arm9dasmstr,"r%d, r%d, r%d, ASR #%d", ARM9DASM_RD, ARM9DASM_RN, ARM9DASM_RM, arm9dasmtmp4);
}

void ARM9DASMarr(u32 op)
{
    sprintf(arm9dasmstr,"r%d, r%d, r%d, ASR r%d", ARM9DASM_RD, ARM9DASM_RN, ARM9DASM_RM, ARM9DASM_RS);
}

void ARM9DASMrri(u32 op) 
{
    arm9dasmtmp4=(op&0x00000F80)>>7;
    if(arm9dasmtmp4)
        sprintf(arm9dasmstr,"r%d, r%d, r%d, ROR #%d", ARM9DASM_RD, ARM9DASM_RN, ARM9DASM_RM, arm9dasmtmp4);
    else
        sprintf(arm9dasmstr,"r%d, r%d, r%d, RRX", ARM9DASM_RD, ARM9DASM_RN, ARM9DASM_RM);
}

void ARM9DASMrrr(u32 op) 
{
    sprintf(arm9dasmstr,"r%d, r%d, r%d, ROR r%d", ARM9DASM_RD, ARM9DASM_RN, ARM9DASM_RM, ARM9DASM_RS);
}

//---Load/Store addressing modes, opcodes----------------------------------

void ARM9DASMofim(u32 op) 
{
    sprintf(arm9dasmstr,"r%d, [r%d, #-$%03X]", ARM9DASM_RD, ARM9DASM_RN, op&0x00000FFF);
}

void ARM9DASMofip(u32 op)
{
    sprintf(arm9dasmstr,"r%d, [r%d, #+$%03X]", ARM9DASM_RD, ARM9DASM_RN, op&0x00000FFF);
}

void ARM9DASMofrm(u32 op) 
{
    sprintf(arm9dasmstr,"r%d, [r%d, -r%d]", ARM9DASM_RD, ARM9DASM_RN, ARM9DASM_RM);
}

void ARM9DASMofrmll(u32 op)
{
    arm9dasmtmp4=(op&0x00000F80)>>7; 
    sprintf(arm9dasmstr,"r%d, [r%d, -r%d, LSL #%d]", ARM9DASM_RD, ARM9DASM_RN, ARM9DASM_RM, arm9dasmtmp4);
}

void ARM9DASMofrmlr(u32 op) 
{
    arm9dasmtmp4=(op&0x00000F80)>>7;
    sprintf(arm9dasmstr,"r%d, [r%d, -r%d, LSR #%d]", ARM9DASM_RD, ARM9DASM_RN, ARM9DASM_RM, arm9dasmtmp4);
}

void ARM9DASMofrmar(u32 op)
{
    arm9dasmtmp4=(op&0x00000F80)>>7; 
    sprintf(arm9dasmstr,"r%d, [r%d, -r%d, ASR #%d]", ARM9DASM_RD, ARM9DASM_RN, ARM9DASM_RM, arm9dasmtmp4);
}

void ARM9DASMofrmrr(u32 op) 
{
    arm9dasmtmp4=(op&0x00000F80)>>7;
    if(arm9dasmtmp4)
        sprintf(arm9dasmstr,"r%d, [r%d, -r%d, ROR #%d]", ARM9DASM_RD, ARM9DASM_RN, ARM9DASM_RM, arm9dasmtmp4);
    else
        sprintf(arm9dasmstr,"r%d, [r%d, -r%d, RRX]", ARM9DASM_RD, ARM9DASM_RN, ARM9DASM_RM);
}

void ARM9DASMofrp(u32 op) 
{
    sprintf(arm9dasmstr,"r%d, [r%d, +r%d]", ARM9DASM_RD, ARM9DASM_RN, ARM9DASM_RM);
}    

void ARM9DASMofrpll(u32 op) 
{
    arm9dasmtmp4=(op&0x00000F80)>>7;
    sprintf(arm9dasmstr,"r%d, [r%d, +r%d, LSL #%d]", ARM9DASM_RD, ARM9DASM_RN, ARM9DASM_RM, arm9dasmtmp4);
}

void ARM9DASMofrplr(u32 op) 
{
    arm9dasmtmp4=(op&0x00000F80)>>7; 
    sprintf(arm9dasmstr,"r%d, [r%d, +r%d, LSR #%d]", ARM9DASM_RD, ARM9DASM_RN, ARM9DASM_RM, arm9dasmtmp4);
}

void ARM9DASMofrpar(u32 op)
{
    arm9dasmtmp4=(op&0x00000F80)>>7; 
    sprintf(arm9dasmstr,"r%d, [r%d, +r%d, ASR #%d]", ARM9DASM_RD, ARM9DASM_RN, ARM9DASM_RM, arm9dasmtmp4);
}

void ARM9DASMofrprr(u32 op) 
{
    arm9dasmtmp4=(op&0x00000F80)>>7;
    if(arm9dasmtmp4)
        sprintf(arm9dasmstr,"r%d, [r%d, +r%d, ROR #%d]", ARM9DASM_RD, ARM9DASM_RN, ARM9DASM_RM, arm9dasmtmp4);
    else
        sprintf(arm9dasmstr,"r%d, [r%d, +r%d, RRX]", ARM9DASM_RD, ARM9DASM_RN, ARM9DASM_RM);
}

void ARM9DASMprim(u32 op) 
{
    sprintf(arm9dasmstr,"r%d, [r%d, #-$%03X]!", ARM9DASM_RD, ARM9DASM_RN, op&0x00000FFF);
}

void ARM9DASMprip(u32 op) 
{
    sprintf(arm9dasmstr,"r%d, [r%d, #+$%03X]!", ARM9DASM_RD, ARM9DASM_RN, op&0x00000FFF);
}

void ARM9DASMprrm(u32 op)
{
    sprintf(arm9dasmstr,"r%d, [r%d, -r%d]!", ARM9DASM_RD, ARM9DASM_RN, ARM9DASM_RM);
}

void ARM9DASMprrmll(u32 op)
{
    arm9dasmtmp4=(op&0x00000F80)>>7; 
    sprintf(arm9dasmstr,"r%d, [r%d, -r%d, LSL #%d]!", ARM9DASM_RD, ARM9DASM_RN, ARM9DASM_RM, arm9dasmtmp4);
}

void ARM9DASMprrmlr(u32 op) 
{
    arm9dasmtmp4=(op&0x00000F80)>>7; 
    sprintf(arm9dasmstr,"r%d, [r%d, -r%d, LSR #%d]!", ARM9DASM_RD, ARM9DASM_RN, ARM9DASM_RM, arm9dasmtmp4);
}

void ARM9DASMprrmar(u32 op)
{
    arm9dasmtmp4=(op&0x00000F80)>>7;
    sprintf(arm9dasmstr,"r%d, [r%d, -r%d, ASR #%d]!", ARM9DASM_RD, ARM9DASM_RN, ARM9DASM_RM, arm9dasmtmp4);
}

void ARM9DASMprrmrr(u32 op) 
{
    arm9dasmtmp4=(op&0x00000F80)>>7;
    if(arm9dasmtmp4)
        sprintf(arm9dasmstr,"r%d, [r%d, -r%d, ROR #%d]!", ARM9DASM_RD, ARM9DASM_RN, ARM9DASM_RM, arm9dasmtmp4);
    else
        sprintf(arm9dasmstr,"r%d, [r%d, -r%d, RRX]!", ARM9DASM_RD, ARM9DASM_RN, ARM9DASM_RM);
}

void ARM9DASMprrp(u32 op)
{
    sprintf(arm9dasmstr,"r%d, [r%d, +r%d]!", ARM9DASM_RD, ARM9DASM_RN, ARM9DASM_RM);
}

void ARM9DASMprrpll(u32 op)
{
    arm9dasmtmp4=(op&0x00000F80)>>7; 
    sprintf(arm9dasmstr,"r%d, [r%d, +r%d, LSL #%d]!", ARM9DASM_RD, ARM9DASM_RN, ARM9DASM_RM, arm9dasmtmp4);
}

void ARM9DASMprrplr(u32 op)
{
    arm9dasmtmp4=(op&0x00000F80)>>7; 
    sprintf(arm9dasmstr,"r%d, [r%d, +r%d, LSR #%d]!", ARM9DASM_RD, ARM9DASM_RN, ARM9DASM_RM, arm9dasmtmp4);
}

void ARM9DASMprrpar(u32 op)
{
    arm9dasmtmp4=(op&0x00000F80)>>7;
    sprintf(arm9dasmstr,"r%d, [r%d, +r%d, ASR #%d]!", ARM9DASM_RD, ARM9DASM_RN, ARM9DASM_RM, arm9dasmtmp4);
}

void ARM9DASMprrprr(u32 op)
{
    arm9dasmtmp4=(op&0x00000F80)>>7;
    if(arm9dasmtmp4)
        sprintf(arm9dasmstr,"r%d, [r%d, +r%d, ROR #%d]!", ARM9DASM_RD, ARM9DASM_RN, ARM9DASM_RM, arm9dasmtmp4);
    else
        sprintf(arm9dasmstr,"r%d, [r%d, +r%d, RRX]!", ARM9DASM_RD, ARM9DASM_RN, ARM9DASM_RM);
}

void ARM9DASMptim(u32 op)
{
    sprintf(arm9dasmstr,"r%d, [r%d], #-$%03X", ARM9DASM_RD, ARM9DASM_RN, op&0x00000FFF);
}

void ARM9DASMptip(u32 op) 
{
    sprintf(arm9dasmstr,"r%d, [r%d], #+$%03X", ARM9DASM_RD, ARM9DASM_RN, op&0x00000FFF);
}

void ARM9DASMptrm(u32 op) 
{
    sprintf(arm9dasmstr,"r%d, [r%d], -r%d", ARM9DASM_RD, ARM9DASM_RN, ARM9DASM_RM);
}

void ARM9DASMptrmll(u32 op)
{
    arm9dasmtmp4=(op&0x00000F80)>>7; 
    sprintf(arm9dasmstr,"r%d, [r%d], -r%d, LSL #%d", ARM9DASM_RD, ARM9DASM_RN, ARM9DASM_RM, arm9dasmtmp4);
}

void ARM9DASMptrmlr(u32 op) 
{
    arm9dasmtmp4=(op&0x00000F80)>>7;
    sprintf(arm9dasmstr,"r%d, [r%d], -r%d, LSR #%d", ARM9DASM_RD, ARM9DASM_RN, ARM9DASM_RM, arm9dasmtmp4);
}

void ARM9DASMptrmar(u32 op)
{
    arm9dasmtmp4=(op&0x00000F80)>>7; 
    sprintf(arm9dasmstr,"r%d, [r%d], -r%d, ASR #%d", ARM9DASM_RD, ARM9DASM_RN, ARM9DASM_RM, arm9dasmtmp4);
}

void ARM9DASMptrmrr(u32 op)
{
    arm9dasmtmp4=(op&0x00000F80)>>7; 
    if(arm9dasmtmp4)
        sprintf(arm9dasmstr,"r%d, [r%d], -r%d, ROR #%d", ARM9DASM_RD, ARM9DASM_RN, ARM9DASM_RM, arm9dasmtmp4);
    else
        sprintf(arm9dasmstr,"r%d, [r%d], -r%d, RRX", ARM9DASM_RD, ARM9DASM_RN, ARM9DASM_RM);
}

void ARM9DASMptrp(u32 op)
{
    sprintf(arm9dasmstr,"r%d, [r%d], +r%d", ARM9DASM_RD, ARM9DASM_RN, ARM9DASM_RM);
}

void ARM9DASMptrpll(u32 op)
{
    arm9dasmtmp4=(op&0x00000F80)>>7;
    sprintf(arm9dasmstr,"r%d, [r%d], +r%d, LSL #%d", ARM9DASM_RD, ARM9DASM_RN, ARM9DASM_RM, arm9dasmtmp4);
}

void ARM9DASMptrplr(u32 op) 
{
    arm9dasmtmp4=(op&0x00000F80)>>7; 
    sprintf(arm9dasmstr,"r%d, [r%d], +r%d, LSR #%d", ARM9DASM_RD, ARM9DASM_RN, ARM9DASM_RM, arm9dasmtmp4);
}

void ARM9DASMptrpar(u32 op)
{
    arm9dasmtmp4=(op&0x00000F80)>>7; 
    sprintf(arm9dasmstr,"r%d, [r%d], +r%d, ASR #%d", ARM9DASM_RD, ARM9DASM_RN, ARM9DASM_RM, arm9dasmtmp4);
}

void ARM9DASMptrprr(u32 op)
{
    arm9dasmtmp4=(op&0x00000F80)>>7; 
    if(arm9dasmtmp4)
        sprintf(arm9dasmstr,"r%d, [r%d], +r%d, ROR #%d", ARM9DASM_RD, ARM9DASM_RN, ARM9DASM_RM, arm9dasmtmp4);
    else
        sprintf(arm9dasmstr,"r%d, [r%d], +r%d, RRX", ARM9DASM_RD, ARM9DASM_RN, ARM9DASM_RM);
}

void ARM9DASMlmofim(u32 op)
{
    sprintf(arm9dasmstr,"r%d, [r%d, #-$%1X%1X]", ARM9DASM_RD, ARM9DASM_RN, ARM9DASM_RS, ARM9DASM_RM);
}

void ARM9DASMlmofip(u32 op)
{
    sprintf(arm9dasmstr,"r%d, [r%d, #+$%1X%1X]", ARM9DASM_RD, ARM9DASM_RN, ARM9DASM_RS, ARM9DASM_RM);
}

void ARM9DASMlmprim(u32 op)
{
    sprintf(arm9dasmstr,"r%d, [r%d, #-$%1X%1X]!", ARM9DASM_RD, ARM9DASM_RN, ARM9DASM_RS, ARM9DASM_RM);
}

void ARM9DASMlmprip(u32 op)
{
    sprintf(arm9dasmstr,"r%d, [r%d, #+$%1X%1X]!", ARM9DASM_RD, ARM9DASM_RN, ARM9DASM_RS, ARM9DASM_RM);
}

void ARM9DASMlmptim(u32 op)
{
    sprintf(arm9dasmstr,"r%d, [r%d], #-$%1X%1X", ARM9DASM_RD, ARM9DASM_RN, ARM9DASM_RS, ARM9DASM_RM);
}

void ARM9DASMlmptip(u32 op)
{
    sprintf(arm9dasmstr,"r%d, [r%d], #+$%1X%1X", ARM9DASM_RD, ARM9DASM_RN, ARM9DASM_RS, ARM9DASM_RM);
}

//-------------------------------------------------------------------------

//-------------------------------------------------------------------------

// Credit: Costis
void ARM9DASMlm(u32 op)
{
    int i, b_start, b_end, inWord=op;
    char str[520],regstr[512];
    sprintf(str,"r%d",ARM9DASM_RN);
    if(op&0x00200000) sprintf(str,"%s!",str);
    sprintf(regstr,",{");
    b_start = b_end = -1;
    for (i = 0; i < 16; i++)
    {
        if ((inWord & 1) && (b_start < 0)) b_start = i;
	else if (!(inWord & 1))
	{
	    b_end = i - 1;
	    if (b_start >= 0)
	    {
 	        if(strlen(regstr)==2)
 	        {
		    if(b_start!=b_end) sprintf(regstr, "%sr%d-r%d", regstr, b_start, b_end);
		    else sprintf(regstr, "%sr%d", regstr, b_start);
		} else {
		    if(b_start!=b_end) sprintf(regstr, "%s,r%d-r%d", regstr, b_start, b_end);
		    else sprintf(regstr, "%s,r%d", regstr, b_start);
		}
	    }
  	    b_start = -1;
	}
	inWord >>= 1;
    }
    sprintf(str,"%s%s}",str,regstr);
    if(op&0x00400000) sprintf(str,"%s^",str);
    sprintf(arm9dasmstr,"%s",str);
}

//-------------------------------------------------------------------------

void ARM9DASMmrsrs(u32 op)
{
    sprintf(arm9dasmstr,"r%d, cpsr",ARM9DASM_RD);
}

void ARM9DASMmrsrc(u32 op)
{
    sprintf(arm9dasmstr,"r%d, spsr",ARM9DASM_RD);
}

void ARM9DASMmsric(u32 op)
{
    arm9dasmtmp3 = op&255; 
    arm9dasmtmp4 = (op&0x00000F00)>>7; 
    arm9dasmtmp1 = (arm9dasmtmp3>>arm9dasmtmp4)|((arm9dasmtmp3&((1<<arm9dasmtmp4)-1))<<(32-arm9dasmtmp4)); 
    sprintf(arm9dasmstr,"cpsr_%c%c%c%c, #%08X",
        ((op&0x00010000)?'c':'_'), ((op&0x00020000)?'x':'_'),
        ((op&0x00040000)?'s':'_'), ((op&0x00080000)?'f':'_'), arm9dasmtmp1);
	
}

void ARM9DASMmsris(u32 op)
{
    arm9dasmtmp3 = op&255; 
    arm9dasmtmp4 = (op&0x00000F00)>>7;
    arm9dasmtmp1 = (arm9dasmtmp3>>arm9dasmtmp4)|((arm9dasmtmp3&((1<<arm9dasmtmp4)-1))<<(32-arm9dasmtmp4));
    sprintf(arm9dasmstr,"spsr_%c%c%c%c, #%08X",
        ((op&0x00010000)?'c':'_'), ((op&0x00020000)?'x':'_'),
        ((op&0x00040000)?'s':'_'), ((op&0x00080000)?'f':'_'), arm9dasmtmp1);
}

void ARM9DASMmsrrc(u32 op)
{
    sprintf(arm9dasmstr,"cpsr_%c%c%c%c, r%d",
        ((op&0x00010000)?'c':'_'), ((op&0x00020000)?'x':'_'),
        ((op&0x00040000)?'s':'_'), ((op&0x00080000)?'f':'_'), ARM9DASM_RM);
}

void ARM9DASMmsrrs(u32 op)
{
    sprintf(arm9dasmstr,"spsr_%c%c%c%c, r%d",
        ((op&0x00010000)?'c':'_'), ((op&0x00020000)?'x':'_'),
        ((op&0x00040000)?'s':'_'), ((op&0x00080000)?'f':'_'), ARM9DASM_RM);
}

//-------------------------------------------------------------------------

void ARM9DASMswp(u32 op)
{
    sprintf(arm9dasmstr,"r%d, r%d, [r%d]",ARM9DASM_RD,ARM9DASM_RM,ARM9DASM_RN);
}

void ARM9DASMswi(u32 op)
{
    sprintf(arm9dasmstr,"$%06X",op&0x00FFFFFF);
}

//-------------------------------------------------------------------------

void ARM9DASMmul(u32 op)
{
    sprintf(arm9dasmstr,"r%d, r%d, r%d",ARM9DASM_RN,ARM9DASM_RM,ARM9DASM_RS);
}

void ARM9DASMmla(u32 op)
{
    sprintf(arm9dasmstr,"r%d, r%d, r%d, r%d",ARM9DASM_RN,ARM9DASM_RM,ARM9DASM_RS,ARM9DASM_RD);
}

void ARM9DASMmull(u32 op)
{
}

//-------------------------------------------------------------------------

void ARM9DASMmcr(u32 op)
{
    sprintf(arm9dasmstr,"p%1X, %1X, r%d, c%d, c%d, %1X",ARM9DASM_RS,ARM9DASM_RO>>1,ARM9DASM_RD,ARM9DASM_RN,ARM9DASM_RM,ARM9DASM_RP>>1);
}

void ARM9DASMcpd(u32 op)
{
    sprintf(arm9dasmstr,"p%1X, %1X, c%d, c%d, c%d, %1X",ARM9DASM_RS,ARM9DASM_RO>>1,ARM9DASM_RD,ARM9DASM_RN,ARM9DASM_RM,ARM9DASM_RP>>1);
}

//-------------------------------------------------------------------------

void Thumb9DASMimm5(u32 op)
{
    sprintf(arm9dasmstr,"r%d, [r%d, #$%02X",TMB7DASM_RD,TMB7DASM_RN,TMB7DASM_IMM5);
}

void Thumb9DASMimm5shft(u32 op)
{
    sprintf(arm9dasmstr,"r%d, r%d, #$%02X",TMB7DASM_RD,TMB7DASM_RN,TMB7DASM_IMM5);
}

void Thumb9DASMimm7(u32 op)
{
    if(op&0x0080) sprintf(arm9dasmstr,"SUB sp, sp, #$%02X",TMB7DASM_IMM7);
    else          sprintf(arm9dasmstr,"ADD sp, sp, #$%02X",TMB7DASM_IMM7);
}

void Thumb9DASMimm8(u32 op)
{
    sprintf(arm9dasmstr,"r%d, #$%02X",TMB7DASM_RS, TMB7DASM_IMM8);
}

void Thumb9DASMimm3(u32 op)
{
    sprintf(arm9dasmstr,"r%d, r%d, #$%01X",TMB7DASM_RD,TMB7DASM_RN,TMB7DASM_RM);
}

void Thumb9DASMb(u32 op)
{
    signed int b = (op&0x0400)?(0xFFFFFC00|(op&0x03FF))
                                          :(op&0x03FF);
    sprintf(arm9dasmstr,"$%08X",arm9reg.r[15]+4+(b*2));
}

void Thumb9DASMbx(u32 op)
{
    if(op&0x0080)
        sprintf(arm9dasmstr,"BLX r%d",TMB7DASM_RNH);
    else
        sprintf(arm9dasmstr,"BX r%d",TMB7DASM_RNH);
}

void Thumb9DASMbl(u32 op)
{
    sprintf(arm9dasmstr,"$%03X",TMB7DASM_IMM11);
}

void Thumb9DASMbc(u32 op)
{
    signed int b = (op&0x00FF)?(0xFFFFFF00|(op&0x00FF))
                                          :(op&0x00FF);
    sprintf(arm9dasmstr,"$%08X",arm9reg.r[15]+4+(b*2));
}

void Thumb9DASMh(u32 op)
{
    sprintf(arm9dasmstr,"r%d, r%d",TMB7DASM_RDH,TMB7DASM_RNH);
}

void Thumb9DASMldm(u32 op)
{
    int i, b_start, b_end, inWord=op;
    char str[512];
    sprintf(str,"{");
    b_start = b_end = -1;
    for (i = 0; i < 8; i++)
    {
        if ((inWord & 1) && (b_start < 0)) b_start = i;
	else if (!(inWord & 1))
	{
	    b_end = i - 1;
	    if (b_start >= 0)
	    {
 	        if(strlen(str)==1)
 	        {
		    if (b_start != b_end) sprintf (str, "%sr%d-r%d", str, b_start, b_end);
		    else sprintf (str, "%sr%d", str, b_start);
		} else {
		    if (b_start != b_end) sprintf (str, "%s,r%d-r%d", str, b_start, b_end);
		    else sprintf (str, "%s,r%d", str, b_start);
		}
	    }
  	    b_start = -1;
	}
	inWord >>= 1;
    }
    sprintf(arm9dasmstr,"%s}",str);
}

void Thumb9DASMdp1(u32 op)
{
    switch((op&0x00C0)>>6)
    {
        case 0: sprintf(arm9dasmstr,"AND r%d, r%d",TMB7DASM_RD,TMB7DASM_RN); break;
        case 1: sprintf(arm9dasmstr,"EOR r%d, r%d",TMB7DASM_RD,TMB7DASM_RN); break;
        case 2: sprintf(arm9dasmstr,"LSL r%d, r%d",TMB7DASM_RD,TMB7DASM_RN); break;
        case 3: sprintf(arm9dasmstr,"LSR r%d, r%d",TMB7DASM_RD,TMB7DASM_RN); break;
    }
}

void Thumb9DASMdp2(u32 op)
{
    switch((op&0x00C0)>>6)
    {
        case 0: sprintf(arm9dasmstr,"ASR r%d, r%d",TMB7DASM_RD,TMB7DASM_RN); break;
        case 1: sprintf(arm9dasmstr,"ADC r%d, r%d",TMB7DASM_RD,TMB7DASM_RN); break;
        case 2: sprintf(arm9dasmstr,"SBC r%d, r%d",TMB7DASM_RD,TMB7DASM_RN); break;
        case 3: sprintf(arm9dasmstr,"ROR r%d, r%d",TMB7DASM_RD,TMB7DASM_RN); break;
    }
}

void Thumb9DASMdp3(u32 op)
{
    switch((op&0x00C0)>>6)
    {
        case 0: sprintf(arm9dasmstr,"TST r%d, r%d",TMB7DASM_RD,TMB7DASM_RN); break;
        case 1: sprintf(arm9dasmstr,"NEG r%d"     ,TMB7DASM_RD); break;
        case 2: sprintf(arm9dasmstr,"CMP r%d, r%d",TMB7DASM_RD,TMB7DASM_RN); break;
        case 3: sprintf(arm9dasmstr,"CMN r%d, r%d",TMB7DASM_RD,TMB7DASM_RN); break;
    }
}

void Thumb9DASMdp4(u32 op)
{
    switch((op&0x00C0)>>6)
    {
        case 0: sprintf(arm9dasmstr,"ORR r%d, r%d",TMB7DASM_RD,TMB7DASM_RN); break;
        case 1: sprintf(arm9dasmstr,"MUL r%d, r%d",TMB7DASM_RD,TMB7DASM_RN); break;
        case 2: sprintf(arm9dasmstr,"BIC r%d, r%d",TMB7DASM_RD,TMB7DASM_RN); break;
        case 3: sprintf(arm9dasmstr,"MVN r%d, r%d",TMB7DASM_RD,TMB7DASM_RN); break;
    }
}

void Thumb9DASMreg(u32 op)
{
    sprintf(arm9dasmstr,"r%d, r%d",TMB7DASM_RD,TMB7DASM_RN);
}

void Thumb9DASMund(u32 op)
{
    sprintf(arm9dasmstr,"");
}

void Thumb9DASMpc(u32 op)
{
    sprintf(arm9dasmstr,"[pc, #$%02X*4]",TMB7DASM_IMM8);
}

void Thumb9DASMsp(u32 op)
{
    sprintf(arm9dasmstr,"[sp, #$%02X*4]",TMB7DASM_IMM8);
}

void Thumb9DASMbkpt(u32 op)
{
    sprintf(arm9dasmstr,"");
}

void Thumb9DASMswi(u32 op)
{
    sprintf(arm9dasmstr,"$%02X",op&0x00FF);
}

/*** EOF:arm9dasm.c ******************************************************/

