/**************************************************************************
* DSemu: ARM7 disassembler definitions and string table (arm7dasm.h)      *
* Released under the terms of the BSD Public Licence                      *
* Imran Nazar (tf@oopsilon.com), 2004                                     *
**************************************************************************/

#ifndef __ARM7DASM_H_
#define __ARM7DASM_H_

#include "defs.h"
#include "arm.h"

u32 arm7dasmtmp1, arm7dasmtmp2, arm7dasmtmp3, arm7dasmtmp4;
char arm7dasmstr[40];

extern ARMREGS arm7reg;

char *ARM7DASMcond[]={
    "EQ","NE","CS","CC",
    "MI","PL","VS","VC",
    "HI","LS","GE","LT",
    "GT","LE","","NV",
};

#define ARM7DASM_RO ((op&0x00F00000)>>20)
#define ARM7DASM_RP ((op&0x0000000F0)>>4)

#define ARM7DASM_RN (op&0x000F0000)>>16
#define ARM7DASM_RD (op&0x0000F000)>>12
#define ARM7DASM_RM (op&0x0000000F)
#define ARM7DASM_RS (op&0x00000F00)>>8

#define TMB7DASM_RD (op&0x0007)
#define TMB7DASM_RN (op&0x0038)>>3
#define TMB7DASM_RM (op&0x01C0)>>6
#define TMB7DASM_RS (op&0x0700)>>8
#define TMB7DASM_RDH (op&0x0007)|((op&0x0080)>>4)
#define TMB7DASM_RNH ((op&0x0078)>>3)
#define TMB7DASM_IMM5 (op&0x07C0)>>6
#define TMB7DASM_IMM8 (op&0x00FF)
#define TMB7DASM_IMM7 (op&0x007F)
#define TMB7DASM_IMM11 (op&0x07FF)
char *ARM7DASM(u32);

void ARM7DASMun(u32);

void ARM7DASMb(u32), ARM7DASMbreg(u32);

void ARM7DASMreg(u32), ARM7DASMimm(u32);
void ARM7DASMlli(u32), ARM7DASMllr(u32);
void ARM7DASMlri(u32), ARM7DASMlrr(u32);
void ARM7DASMari(u32), ARM7DASMarr(u32);
void ARM7DASMrri(u32), ARM7DASMrrr(u32);

void ARM7DASMofim(u32), ARM7DASMofip(u32);
void ARM7DASMofrm(u32), ARM7DASMofrp(u32);
void ARM7DASMprim(u32), ARM7DASMprip(u32);
void ARM7DASMprrm(u32), ARM7DASMprrp(u32);
void ARM7DASMptim(u32), ARM7DASMptip(u32);
void ARM7DASMptrm(u32), ARM7DASMptrp(u32);

void ARM7DASMlmofim(u32), ARM7DASMlmofip(u32);
void ARM7DASMlmprim(u32), ARM7DASMlmprip(u32);
void ARM7DASMlmptim(u32), ARM7DASMlmptip(u32);

void ARM7DASMofrmll(u32), ARM7DASMofrpll(u32);
void ARM7DASMofrmlr(u32), ARM7DASMofrplr(u32);
void ARM7DASMofrmar(u32), ARM7DASMofrpar(u32);
void ARM7DASMofrmrr(u32), ARM7DASMofrprr(u32);
void ARM7DASMprrmll(u32), ARM7DASMprrpll(u32);
void ARM7DASMprrmlr(u32), ARM7DASMprrplr(u32);
void ARM7DASMprrmar(u32), ARM7DASMprrpar(u32);
void ARM7DASMprrmrr(u32), ARM7DASMprrprr(u32);
void ARM7DASMptrmll(u32), ARM7DASMptrpll(u32);
void ARM7DASMptrmlr(u32), ARM7DASMptrplr(u32);
void ARM7DASMptrmar(u32), ARM7DASMptrpar(u32);
void ARM7DASMptrmrr(u32), ARM7DASMptrprr(u32);

void ARM7DASMlm(u32);

void ARM7DASMmrsrs(u32), ARM7DASMmrsrc(u32);
void ARM7DASMmsrrs(u32), ARM7DASMmsrrc(u32);
void ARM7DASMmsris(u32), ARM7DASMmsric(u32);

void ARM7DASMswp(u32);
void ARM7DASMswi(u32);

void ARM7DASMmul(u32);
void ARM7DASMmla(u32);
void ARM7DASMmull(u32);

void ARM7DASMcpd(u32), ARM7DASMmcr(u32);

void Thumb7DASMimm5(u32), Thumb7DASMimm5shft(u32);
void Thumb7DASMimm3(u32), Thumb7DASMimm8(u32);
void Thumb7DASMimm7(u32);
void Thumb7DASMbc(u32),   Thumb7DASMb(u32);
void Thumb7DASMbl(u32),   Thumb7DASMbx(u32);
void Thumb7DASMldm(u32),  Thumb7DASMh(u32);
void Thumb7DASMbkpt(u32), Thumb7DASMswi(u32);
void Thumb7DASMpc(u32),   Thumb7DASMsp(u32);
void Thumb7DASMdp1(u32),  Thumb7DASMdp2(u32);
void Thumb7DASMdp3(u32),  Thumb7DASMdp4(u32);
void Thumb7DASMreg(u32),  Thumb7DASMund(u32);

//---And so it begins------------------------------------------------------

typedef struct {
    char op[16];
    void (*addr)(u32);
} ARM7DASMOPDESC;

//---Opcode function pointer table. Indexed by 27-20|7-4-------------------

const ARM7DASMOPDESC arm7dasmops[]={
    //0x00
    {"AND%s %s",ARM7DASMlli      },
    {"AND%s %s",ARM7DASMllr      },
    {"AND%s %s",ARM7DASMlri      },
    {"AND%s %s",ARM7DASMlrr      },
    {"AND%s %s",ARM7DASMari      },
    {"AND%s %s",ARM7DASMarr      },
    {"AND%s %s",ARM7DASMrri      },
    {"AND%s %s",ARM7DASMrrr      },
    {"AND%s %s",ARM7DASMlli      },
    {"MUL%s %s",ARM7DASMmul      },
    {"AND%s %s",ARM7DASMlri      },
    {"STRH%s %s",ARM7DASMptrm    },
    {"AND%s %s",ARM7DASMari      },
    {"UNP%s %s",ARM7DASMun       },  // Defined in 5E!
    {"AND%s %s",ARM7DASMrri      },
    {"UNP%s %s",ARM7DASMun       },  // Defined in 5E!

    //0x01
    {"AND%sS %s",ARM7DASMlli     },
    {"AND%sS %s",ARM7DASMllr     },
    {"AND%sS %s",ARM7DASMlri     },
    {"AND%sS %s",ARM7DASMlrr     },
    {"AND%sS %s",ARM7DASMari     },
    {"AND%sS %s",ARM7DASMarr     },
    {"AND%sS %s",ARM7DASMrri     },
    {"AND%sS %s",ARM7DASMrrr     },
    {"AND%sS %s",ARM7DASMlli     },
    {"MUL%sS %s",ARM7DASMmul     },
    {"AND%sS %s",ARM7DASMlri     },
    {"LDRH%s %s",ARM7DASMptrm    },
    {"AND%sS %s",ARM7DASMari     },
    {"LDRSB%s %s",ARM7DASMptrm   },
    {"AND%sS %s",ARM7DASMrri     },
    {"LDRSH%s %s",ARM7DASMptrm   },

    //0x02
    {"EOR%s %s",ARM7DASMlli      },
    {"EOR%s %s",ARM7DASMllr      },
    {"EOR%s %s",ARM7DASMlri      },
    {"EOR%s %s",ARM7DASMlrr      },
    {"EOR%s %s",ARM7DASMari      },
    {"EOR%s %s",ARM7DASMarr      },
    {"EOR%s %s",ARM7DASMrri      },
    {"EOR%s %s",ARM7DASMrrr      },
    {"EOR%s %s",ARM7DASMlli      },
    {"MLA%s %s",ARM7DASMmla      },
    {"EOR%s %s",ARM7DASMlri      },
    {"STRH%s %s",ARM7DASMptrm    },  // Post-indexed with W bit
    {"EOR%s %s",ARM7DASMari      },
    {"UNP%s %s",ARM7DASMun       },  // Post-indexed with W bit
    {"EOR%s %s",ARM7DASMrri      },
    {"OPR%s %s",ARM7DASMun       },  // Post-indexed with W bit [reindexed]

    //0x03
    {"EOR%sS %s",ARM7DASMlli     },
    {"EOR%sS %s",ARM7DASMllr     },
    {"EOR%sS %s",ARM7DASMlri     },
    {"EOR%sS %s",ARM7DASMlrr     },
    {"EOR%sS %s",ARM7DASMari     },
    {"EOR%sS %s",ARM7DASMarr     },
    {"EOR%sS %s",ARM7DASMrri     },
    {"EOR%sS %s",ARM7DASMrrr     },
    {"EOR%sS %s",ARM7DASMlli     },
    {"MLA%sS %s",ARM7DASMmla     },
    {"EOR%sS %s",ARM7DASMlri     },
    {"LDRH%s %s",ARM7DASMptrm    },  // Post-indexed with W bit
    {"EOR%sS %s",ARM7DASMari     },
    {"LDRSB%s %s",ARM7DASMptrm   },  // Post-indexed with W bit
    {"EOR%sS %s",ARM7DASMrri     },
    {"LDRSH%s %s",ARM7DASMptrm   },  // Post-indexed with W bit

    //0x04
    {"SUB%s %s",ARM7DASMlli      },
    {"SUB%s %s",ARM7DASMllr      },
    {"SUB%s %s",ARM7DASMlri      },
    {"SUB%s %s",ARM7DASMlrr      },
    {"SUB%s %s",ARM7DASMari      },
    {"SUB%s %s",ARM7DASMarr      },
    {"SUB%s %s",ARM7DASMrri      },
    {"SUB%s %s",ARM7DASMrrr      },
    {"SUB%s %s",ARM7DASMlli      },
    {"UNP%s %s",ARM7DASMun       },  // Unallocated
    {"SUB%s %s",ARM7DASMlri      },
    {"STRH%s %s",ARM7DASMlmptim  },
    {"SUB%s %s",ARM7DASMari      },
    {"UNP%s %s",ARM7DASMun       },  // Defined in 5E!
    {"SUB%s %s",ARM7DASMrri      },
    {"UNP%s %s",ARM7DASMun       },  // Defined in 5E!

    //0x05
    {"SUB%sS %s",ARM7DASMlli     },
    {"SUB%sS %s",ARM7DASMllr     },
    {"SUB%sS %s",ARM7DASMlri     },
    {"SUB%sS %s",ARM7DASMlrr     },
    {"SUB%sS %s",ARM7DASMari     },
    {"SUB%sS %s",ARM7DASMarr     },
    {"SUB%sS %s",ARM7DASMrri     },
    {"SUB%sS %s",ARM7DASMrrr     },
    {"SUB%sS %s",ARM7DASMlli     },
    {"UNP%s %s",ARM7DASMun       },  // Unallocated
    {"SUB%sS %s",ARM7DASMlri     },
    {"LDRH%s %s",ARM7DASMlmptim  },
    {"SUB%sS %s",ARM7DASMari     },
    {"LDRSB%s %s",ARM7DASMlmptim },
    {"SUB%sS %s",ARM7DASMrri     },
    {"LDRSH%s %s",ARM7DASMlmptim },

    //0x06
    {"RSB%s %s",ARM7DASMlli      },
    {"RSB%s %s",ARM7DASMllr      },
    {"RSB%s %s",ARM7DASMlri      },
    {"RSB%s %s",ARM7DASMlrr      },
    {"RSB%s %s",ARM7DASMari      },
    {"RSB%s %s",ARM7DASMarr      },
    {"RSB%s %s",ARM7DASMrri      },
    {"RSB%s %s",ARM7DASMrrr      },
    {"RSB%s %s",ARM7DASMlli      },
    {"UNP%s %s",ARM7DASMun       },  // Unallocated
    {"RSB%s %s",ARM7DASMlri      },
    {"STRH%s %s",ARM7DASMlmptim  },  // Post-indexed with W bit
    {"RSB%s %s",ARM7DASMari      },
    {"UNP%s %s",ARM7DASMun       },  // Post-indexed with W bit
    {"RSB%s %s",ARM7DASMrri      },
    {"UNP%s %s",ARM7DASMun       },  // Post-indexed with W bit

    //0x07
    {"RSB%sS %s",ARM7DASMlli     },
    {"RSB%sS %s",ARM7DASMllr     },
    {"RSB%sS %s",ARM7DASMlri     },
    {"RSB%sS %s",ARM7DASMlrr     },
    {"RSB%sS %s",ARM7DASMari     },
    {"RSB%sS %s",ARM7DASMarr     },
    {"RSB%sS %s",ARM7DASMrri     },
    {"RSB%sS %s",ARM7DASMrrr     },
    {"RSB%sS %s",ARM7DASMlli     },
    {"UNP%s %s",ARM7DASMun       },  // Unallocated
    {"RSB%sS %s",ARM7DASMlri     },
    {"LDRH%s %s",ARM7DASMlmptim  },  // Post-indexed with W bit
    {"RSB%sS %s",ARM7DASMari     },
    {"LDRSB%s %s",ARM7DASMlmptim },  // Post-indexed with W bit
    {"RSB%sS %s",ARM7DASMrri     },
    {"LDRSH%s %s",ARM7DASMlmptim },  // Post-indexed with W bit

    //0x08
    {"ADD%s %s",ARM7DASMlli      },
    {"ADD%s %s",ARM7DASMllr      },
    {"ADD%s %s",ARM7DASMlri      },
    {"ADD%s %s",ARM7DASMlrr      },
    {"ADD%s %s",ARM7DASMari      },
    {"ADD%s %s",ARM7DASMarr      },
    {"ADD%s %s",ARM7DASMrri      },
    {"ADD%s %s",ARM7DASMrrr      },
    {"ADD%s %s",ARM7DASMlli      },
    {"UMULL%s %s",ARM7DASMmull   },
    {"ADD%s %s",ARM7DASMlri      },
    {"STRH%s %s",ARM7DASMptrp    },
    {"ADD%s %s",ARM7DASMari      },
    {"UNP%s %s",ARM7DASMun       },  // Defined in 5E!
    {"ADD%s %s",ARM7DASMrri      },
    {"UNP%s %s",ARM7DASMun       },  // Defined in 5E!

    //0x09
    {"ADD%sS %s",ARM7DASMlli     },
    {"ADD%sS %s",ARM7DASMllr     },
    {"ADD%sS %s",ARM7DASMlri     },
    {"ADD%sS %s",ARM7DASMlrr     },
    {"ADD%sS %s",ARM7DASMari     },
    {"ADD%sS %s",ARM7DASMarr     },
    {"ADD%sS %s",ARM7DASMrri     },
    {"ADD%sS %s",ARM7DASMrrr     },
    {"ADD%sS %s",ARM7DASMlli     },
    {"UMULL%sS %s",ARM7DASMmull  },
    {"ADD%sS %s",ARM7DASMlri     },
    {"LDRH%s %s",ARM7DASMptrp    },
    {"ADD%sS %s",ARM7DASMari     },
    {"LDRSB%s %s",ARM7DASMptrp   },
    {"ADD%sS %s",ARM7DASMrri     },
    {"LDRSH%s %s",ARM7DASMptrp   },

    //0x0A
    {"ADC%s %s",ARM7DASMlli      },
    {"ADC%s %s",ARM7DASMllr      },
    {"ADC%s %s",ARM7DASMlri      },
    {"ADC%s %s",ARM7DASMlrr      },
    {"ADC%s %s",ARM7DASMari      },
    {"ADC%s %s",ARM7DASMarr      },
    {"ADC%s %s",ARM7DASMrri      },
    {"ADC%s %s",ARM7DASMrrr      },
    {"ADC%s %s",ARM7DASMlli      },
    {"UMLAL%s %s",ARM7DASMmull   },
    {"ADC%s %s",ARM7DASMlri      },
    {"STRH%s %s",ARM7DASMptrp    },  // Post-indexed with W bit
    {"ADC%s %s",ARM7DASMari      },
    {"UNP%s %s",ARM7DASMun       },  // Post-indexed with W bit
    {"ADC%s %s",ARM7DASMrri      },
    {"UNP%s %s",ARM7DASMun       },  // Post-indexed with W bit

    //0x0B
    {"ADC%sS %s",ARM7DASMlli     },
    {"ADC%sS %s",ARM7DASMllr     },
    {"ADC%sS %s",ARM7DASMlri     },
    {"ADC%sS %s",ARM7DASMlrr     },
    {"ADC%sS %s",ARM7DASMari     },
    {"ADC%sS %s",ARM7DASMarr     },
    {"ADC%sS %s",ARM7DASMrri     },
    {"ADC%sS %s",ARM7DASMrrr     },
    {"ADC%sS %s",ARM7DASMlli     },
    {"UMLAL%sS %s",ARM7DASMmull  },
    {"ADC%sS %s",ARM7DASMlri     },
    {"LDRH%s %s",ARM7DASMptrm    },  // Post-indexed with W bit
    {"ADC%sS %s",ARM7DASMari     },
    {"LDRSB%s %s",ARM7DASMptrm   },  // Post-indexed with W bit
    {"ADC%sS %s",ARM7DASMrri     },
    {"LDRSH%s %s",ARM7DASMptrm   },  // Post-indexed with W bit

    //0x0C
    {"SBC%s %s",ARM7DASMlli      },
    {"SBC%s %s",ARM7DASMllr      },
    {"SBC%s %s",ARM7DASMlri      },
    {"SBC%s %s",ARM7DASMlrr      },
    {"SBC%s %s",ARM7DASMari      },
    {"SBC%s %s",ARM7DASMarr      },
    {"SBC%s %s",ARM7DASMrri      },
    {"SBC%s %s",ARM7DASMrrr      },
    {"SBC%s %s",ARM7DASMlli      },
    {"SMULL%s %s",ARM7DASMmull   },
    {"SBC%s %s",ARM7DASMlri      },
    {"STRH%s %s",ARM7DASMlmptip  },
    {"SBC%s %s",ARM7DASMari      },
    {"UNP%s %s",ARM7DASMun       },  // Defined in 5E!
    {"SBC%s %s",ARM7DASMrri      },
    {"UNP%s %s",ARM7DASMun       },  // Defined in 5E!

    //0x0D
    {"SBC%sS %s",ARM7DASMlli     },
    {"SBC%sS %s",ARM7DASMllr     },
    {"SBC%sS %s",ARM7DASMlri     },
    {"SBC%sS %s",ARM7DASMlrr     },
    {"SBC%sS %s",ARM7DASMari     },
    {"SBC%sS %s",ARM7DASMarr     },
    {"SBC%sS %s",ARM7DASMrri     },
    {"SBC%sS %s",ARM7DASMrrr     },
    {"SBC%sS %s",ARM7DASMlli     },
    {"SMULL%sS %s",ARM7DASMmull  },
    {"SBC%sS %s",ARM7DASMlri     },
    {"LDRH%s %s",ARM7DASMlmptip  },
    {"SBC%sS %s",ARM7DASMari     },
    {"LDRSB%s %s",ARM7DASMlmptip },
    {"SBC%sS %s",ARM7DASMrri     },
    {"LDRSH%s %s",ARM7DASMlmptip },

    //0x0E
    {"RSC%s %s",ARM7DASMlli      },
    {"RSC%s %s",ARM7DASMllr      },
    {"RSC%s %s",ARM7DASMlri      },
    {"RSC%s %s",ARM7DASMlrr      },
    {"RSC%s %s",ARM7DASMari      },
    {"RSC%s %s",ARM7DASMarr      },
    {"RSC%s %s",ARM7DASMrri      },
    {"RSC%s %s",ARM7DASMrrr      },
    {"RSC%s %s",ARM7DASMlli      },
    {"SMLAL%s %s",ARM7DASMmull   },
    {"RSC%s %s",ARM7DASMlri      },
    {"STRH%s %s",ARM7DASMlmptip  },  // Post-indexed with W bit
    {"RSC%s %s",ARM7DASMari      },
    {"UNP%s %s",ARM7DASMun       },  // Post-indexed with W bit
    {"RSC%s %s",ARM7DASMrri      },
    {"UNP%s %s",ARM7DASMun       },  // Post-indexed with W bit

    //0x0F
    {"RSC%sS %s",ARM7DASMlli     },
    {"RSC%sS %s",ARM7DASMllr     },
    {"RSC%sS %s",ARM7DASMlri     },
    {"RSC%sS %s",ARM7DASMlrr     },
    {"RSC%sS %s",ARM7DASMari     },
    {"RSC%sS %s",ARM7DASMarr     },
    {"RSC%sS %s",ARM7DASMrri     },
    {"RSC%sS %s",ARM7DASMrrr     },
    {"RSC%sS %s",ARM7DASMlli     },
    {"SMLAL%sS %s",ARM7DASMmull  },
    {"RSC%sS %s",ARM7DASMlri     },
    {"LDRH%s %s",ARM7DASMlmptip  },  // Post-indexed with W bit
    {"RSC%sS %s",ARM7DASMari     },
    {"LDRSB%s %s",ARM7DASMlmptip },  // Post-indexed with W bit
    {"RSC%sS %s",ARM7DASMrri     },
    {"LDRSH%s %s",ARM7DASMlmptip },  // Post-indexed with W bit

    //0x10
    {"MRS%s %s",ARM7DASMmrsrc    },
    {"UNP%s %s",ARM7DASMun       },  // MRS with non-zero 7-4
    {"UNP%s %s",ARM7DASMun       },  // MRS with non-zero 7-4
    {"UNP%s %s",ARM7DASMun       },  // MRS with non-zero 7-4
    {"UNP%s %s",ARM7DASMun       },  // MRS with non-zero 7-4
    {"UNP%s %s",ARM7DASMun       },  // Defined in ARM5E!
    {"UNP%s %s",ARM7DASMun       },  // MRS with non-zero 7-4
    {"UNP%s %s",ARM7DASMun       },  // MRS with non-zero 7-4
    {"SMLABB%s %s",ARM7DASMmla   },  // ++ARM5E
    {"SWP%s %s",ARM7DASMswp      },
    {"SMLATB%s %s",ARM7DASMmla   },  // ++ARM5E
    {"STRH%s %s",ARM7DASMofrm    },
    {"SMLABT%s %s",ARM7DASMmla   },  // ++ARM5E
    {"UNP%s %s",ARM7DASMun       },  // Defined in ARM5E!
    {"SMLATT%s %s",ARM7DASMmla   },  // ++ARM5E
    {"UNP%s %s",ARM7DASMun       },  // Defined in ARM5E!

    //0x11
    {"TST%sS %s",ARM7DASMlli     },
    {"TST%sS %s",ARM7DASMllr     },
    {"TST%sS %s",ARM7DASMlri     },
    {"TST%sS %s",ARM7DASMlrr     },
    {"TST%sS %s",ARM7DASMari     },
    {"TST%sS %s",ARM7DASMarr     },
    {"TST%sS %s",ARM7DASMrri     },
    {"TST%sS %s",ARM7DASMrrr     },
    {"TST%sS %s",ARM7DASMlli     },
    {"UNP%s %s",ARM7DASMun       },  // Unallocated
    {"TST%sS %s",ARM7DASMlri     },
    {"LDRH%s %s",ARM7DASMofrm    },
    {"TST%sS %s",ARM7DASMari     },
    {"LDRSB%s %s",ARM7DASMofrm   },
    {"TST%sS %s",ARM7DASMrri     },
    {"LDRSH%s %s",ARM7DASMofrm   },

    //0x12
    {"MSR%s %s",ARM7DASMmsrrc    },
    {"BX%s %s",ARM7DASMbreg      },
    {"UNP%s %s",ARM7DASMun       },  // Unallocated
    {"BLX%s %s",ARM7DASMbreg     },
    {"UNP%s %s",ARM7DASMun       },  // Unallocated
    {"UNP%s %s",ARM7DASMun       },  // Defined in ARM5E!
    {"UNP%s %s",ARM7DASMun       },  // Unallocated
    {"BKPT%s %s",ARM7DASMun      },  // Defined in ARM5E!
    {"UNP%s %s",ARM7DASMun       },  // Defined in ARM5E!
    {"UNP%s %s",ARM7DASMun       },  // Unallocated
    {"UNP%s %s",ARM7DASMun       },  // Defined in ARM5E!
    {"STRH%s %s",ARM7DASMprrm    },
    {"UNP%s %s",ARM7DASMun       },  // Defined in ARM5E!
    {"UNP%s %s",ARM7DASMun       },  // Defined in ARM5E!
    {"UNP%s %s",ARM7DASMun       },  // Defined in ARM5E!
    {"UNP%s %s",ARM7DASMun       },  // Defined in ARM5E!

    //0x13
    {"TEQ%sS %s",ARM7DASMlli     },
    {"TEQ%sS %s",ARM7DASMllr     },
    {"TEQ%sS %s",ARM7DASMlri     },
    {"TEQ%sS %s",ARM7DASMlrr     },
    {"TEQ%sS %s",ARM7DASMari     },
    {"TEQ%sS %s",ARM7DASMarr     },
    {"TEQ%sS %s",ARM7DASMrri     },
    {"TEQ%sS %s",ARM7DASMrrr     },
    {"TEQ%sS %s",ARM7DASMlli     },
    {"UNP%s %s",ARM7DASMun       },  // Unallocated
    {"TEQ%sS %s",ARM7DASMlri     },
    {"LDRH%s %s",ARM7DASMprrm    },
    {"TEQ%sS %s",ARM7DASMari     },
    {"LDRSB%s %s",ARM7DASMprrm   },
    {"TEQ%sS %s",ARM7DASMrri     },
    {"LDRSH%s %s",ARM7DASMprrm   },

    //0x14
    {"MRS%s %s",ARM7DASMmrsrs    },
    {"UNP%s %s",ARM7DASMun       },  // Unallocated
    {"UNP%s %s",ARM7DASMun       },  // Unallocated
    {"UNP%s %s",ARM7DASMun       },  // Unallocated
    {"UNP%s %s",ARM7DASMun       },  // Unallocated
    {"UNP%s %s",ARM7DASMun       },  // Defined in ARM5E!
    {"UNP%s %s",ARM7DASMun       },  // Unallocated
    {"UNP%s %s",ARM7DASMun       },  // Unallocated
    {"UNP%s %s",ARM7DASMun       },  // Defined in ARM5E!
    {"SWPB%s %s",ARM7DASMswp     },
    {"UNP%s %s",ARM7DASMun       },  // Defined in ARM5E!
    {"STRH%s %s",ARM7DASMlmofim  },
    {"UNP%s %s",ARM7DASMun       },  // Defined in ARM5E!
    {"UNP%s %s",ARM7DASMun       },  // Defined in ARM5E!
    {"UNP%s %s",ARM7DASMun       },  // Defined in ARM5E!
    {"UNP%s %s",ARM7DASMun       },  // Defined in ARM5E!

    //0x15
    {"CMP%sS %s",ARM7DASMlli     },
    {"CMP%sS %s",ARM7DASMllr     },
    {"CMP%sS %s",ARM7DASMlri     },
    {"CMP%sS %s",ARM7DASMlrr     },
    {"CMP%sS %s",ARM7DASMari     },
    {"CMP%sS %s",ARM7DASMarr     },
    {"CMP%sS %s",ARM7DASMrri     },
    {"CMP%sS %s",ARM7DASMrrr     },
    {"CMP%sS %s",ARM7DASMlli     },
    {"UNP%s %s",ARM7DASMun       },  // Unallocated
    {"CMP%sS %s",ARM7DASMlri     },
    {"LDRH%s %s",ARM7DASMlmofim  },
    {"CMP%sS %s",ARM7DASMari     },
    {"LDRSB%s %s",ARM7DASMlmofim },
    {"CMP%sS %s",ARM7DASMrri     },
    {"LDRSH%s %s",ARM7DASMlmofim },

    //0x16
    {"MSR%s %s",ARM7DASMmsrrs    },
    {"UNP%s %s",ARM7DASMun       },  // Unallocated
    {"UNP%s %s",ARM7DASMun       },  // Unallocated
    {"UNP%s %s",ARM7DASMun       },  // Unallocated
    {"UNP%s %s",ARM7DASMun       },  // Unallocated
    {"UNP%s %s",ARM7DASMun       },  // Defined in ARM5E!
    {"UNP%s %s",ARM7DASMun       },  // Unallocated
    {"UNP%s %s",ARM7DASMun       },  // Unallocated
    {"SMULBB%s %s",ARM7DASMmul   },  // ++ARM5E
    {"UNP%s %s",ARM7DASMun       },  // Unallocated
    {"SMULTB%s %s",ARM7DASMmul   },  // ++ARM5E
    {"STRH%s %s",ARM7DASMlmprim  },
    {"SMULBT%s %s",ARM7DASMmul   },  // ++ARM5E
    {"UNP%s %s",ARM7DASMun       },  // Defined in ARM5E!
    {"SMULTT%s %s",ARM7DASMmul   },  // ++ARM5E
    {"UNP%s %s",ARM7DASMun       },  // Defined in ARM5E!

    //0x17
    {"CMN%sS %s",ARM7DASMlli     },
    {"CMN%sS %s",ARM7DASMllr     },
    {"CMN%sS %s",ARM7DASMlri     },
    {"CMN%sS %s",ARM7DASMlrr     },
    {"CMN%sS %s",ARM7DASMari     },
    {"CMN%sS %s",ARM7DASMarr     },
    {"CMN%sS %s",ARM7DASMrri     },
    {"CMN%sS %s",ARM7DASMrrr     },
    {"CMN%sS %s",ARM7DASMlli     },
    {"UNP%s %s",ARM7DASMun       },  // Unallocated
    {"CMN%sS %s",ARM7DASMlri     },
    {"LDRH%s %s",ARM7DASMlmprim  },
    {"CMN%sS %s",ARM7DASMari     },
    {"LDRSB%s %s",ARM7DASMlmprim },
    {"CMN%sS %s",ARM7DASMrri     },
    {"LDRSH%s %s",ARM7DASMlmprim },

    //0x18
    {"ORR%s %s",ARM7DASMlli      },
    {"ORR%s %s",ARM7DASMllr      },
    {"ORR%s %s",ARM7DASMlri      },
    {"ORR%s %s",ARM7DASMlrr      },
    {"ORR%s %s",ARM7DASMari      },
    {"ORR%s %s",ARM7DASMarr      },
    {"ORR%s %s",ARM7DASMrri      },
    {"ORR%s %s",ARM7DASMrrr      },
    {"ORR%s %s",ARM7DASMlli      },
    {"UNP%s %s",ARM7DASMun       },  // Unallocated
    {"ORR%s %s",ARM7DASMlri      },
    {"STRH%s %s",ARM7DASMofrp    },
    {"ORR%s %s",ARM7DASMari      },
    {"UNP%s %s",ARM7DASMun       },  // Defined in 5E!
    {"ORR%s %s",ARM7DASMrri      },
    {"UNP%s %s",ARM7DASMun       },  // Defined in 5E!

    //0x19
    {"ORR%sS %s",ARM7DASMlli     },
    {"ORR%sS %s",ARM7DASMllr     },
    {"ORR%sS %s",ARM7DASMlri     },
    {"ORR%sS %s",ARM7DASMlrr     },
    {"ORR%sS %s",ARM7DASMari     },
    {"ORR%sS %s",ARM7DASMarr     },
    {"ORR%sS %s",ARM7DASMrri     },
    {"ORR%sS %s",ARM7DASMrrr     },
    {"ORR%sS %s",ARM7DASMlli     },
    {"UNP%s %s",ARM7DASMun       },  // Unallocated
    {"ORR%sS %s",ARM7DASMlri     },
    {"LDRH%s %s",ARM7DASMofrp    },
    {"ORR%sS %s",ARM7DASMari     },
    {"LDRSB%s %s",ARM7DASMofrp   },
    {"ORR%sS %s",ARM7DASMrri     },
    {"LDRSH%s %s",ARM7DASMofrp   },

    //0x1A
    {"MOV%s %s",ARM7DASMlli      },
    {"MOV%s %s",ARM7DASMllr      },
    {"MOV%s %s",ARM7DASMlri      },
    {"MOV%s %s",ARM7DASMlrr      },
    {"MOV%s %s",ARM7DASMari      },
    {"MOV%s %s",ARM7DASMarr      },
    {"MOV%s %s",ARM7DASMrri      },
    {"MOV%s %s",ARM7DASMrrr      },
    {"MOV%s %s",ARM7DASMlli      },
    {"UNP%s %s",ARM7DASMun       },  // Unallocated
    {"MOV%s %s",ARM7DASMlri      },
    {"STRH%s %s",ARM7DASMprrp    },
    {"MOV%s %s",ARM7DASMari      },
    {"UNP%s %s",ARM7DASMun       },  // Defined in 5E!
    {"MOV%s %s",ARM7DASMrri      },
    {"UNP%s %s",ARM7DASMun       },  // Defined in 5E!

    //0x1B
    {"MOV%sS %s",ARM7DASMlli     },
    {"MOV%sS %s",ARM7DASMllr     },
    {"MOV%sS %s",ARM7DASMlri     },
    {"MOV%sS %s",ARM7DASMlrr     },
    {"MOV%sS %s",ARM7DASMari     },
    {"MOV%sS %s",ARM7DASMarr     },
    {"MOV%sS %s",ARM7DASMrri     },
    {"MOV%sS %s",ARM7DASMrrr     },
    {"MOV%sS %s",ARM7DASMlli     },
    {"UNP%s %s",ARM7DASMun       },  // Unallocated
    {"MOV%sS %s",ARM7DASMlri     },
    {"LDRH%s %s",ARM7DASMprrp    },
    {"MOV%sS %s",ARM7DASMari     },
    {"LDRSB%s %s",ARM7DASMprrp   },
    {"MOV%sS %s",ARM7DASMrri     },
    {"LDRSH%s %s",ARM7DASMprrp   },

    //0x1C
    {"BIC%s %s",ARM7DASMlli      },
    {"BIC%s %s",ARM7DASMllr      },
    {"BIC%s %s",ARM7DASMlri      },
    {"BIC%s %s",ARM7DASMlrr      },
    {"BIC%s %s",ARM7DASMari      },
    {"BIC%s %s",ARM7DASMarr      },
    {"BIC%s %s",ARM7DASMrri      },
    {"BIC%s %s",ARM7DASMrrr      },
    {"BIC%s %s",ARM7DASMlli      },
    {"UNP%s %s",ARM7DASMun       },  // Unallocated
    {"BIC%s %s",ARM7DASMlri      },
    {"STRH%s %s",ARM7DASMlmofip  },
    {"BIC%s %s",ARM7DASMari      },
    {"UNP%s %s",ARM7DASMun       },  // Defined in 5E!
    {"BIC%s %s",ARM7DASMrri      },
    {"UNP%s %s",ARM7DASMun       },  // Defined in 5E!

    //0x1D
    {"BIC%sS %s",ARM7DASMlli     },
    {"BIC%sS %s",ARM7DASMllr     },
    {"BIC%sS %s",ARM7DASMlri     },
    {"BIC%sS %s",ARM7DASMlrr     },
    {"BIC%sS %s",ARM7DASMari     },
    {"BIC%sS %s",ARM7DASMarr     },
    {"BIC%sS %s",ARM7DASMrri     },
    {"BIC%sS %s",ARM7DASMrrr     },
    {"BIC%sS %s",ARM7DASMlli     },
    {"UNP%s %s",ARM7DASMun       },  // Unallocated
    {"BIC%sS %s",ARM7DASMlri     },
    {"LDRH%s %s",ARM7DASMlmofip  },
    {"BIC%sS %s",ARM7DASMari     },
    {"LDRSB%s %s",ARM7DASMlmofip },
    {"BIC%sS %s",ARM7DASMrri     },
    {"LDRSH%s %s",ARM7DASMlmofip },

    //0x1E
    {"MVN%s %s",ARM7DASMlli      },
    {"MVN%s %s",ARM7DASMllr      },
    {"MVN%s %s",ARM7DASMlri      },
    {"MVN%s %s",ARM7DASMlrr      },
    {"MVN%s %s",ARM7DASMari      },
    {"MVN%s %s",ARM7DASMarr      },
    {"MVN%s %s",ARM7DASMrri      },
    {"MVN%s %s",ARM7DASMrrr      },
    {"MVN%s %s",ARM7DASMlli      },
    {"UNP%s %s",ARM7DASMun       },  // Unallocated
    {"MVN%s %s",ARM7DASMlri      },
    {"STRH%s %s",ARM7DASMlmprip  },
    {"MVN%s %s",ARM7DASMari      },
    {"UNP%s %s",ARM7DASMun       },  // Defined in 5E!
    {"MVN%s %s",ARM7DASMrri      },
    {"UNP%s %s",ARM7DASMun       },  // Defined in 5E!

    //0x1F
    {"MVN%sS %s",ARM7DASMlli     },
    {"MVN%sS %s",ARM7DASMllr     },
    {"MVN%sS %s",ARM7DASMlri     },
    {"MVN%sS %s",ARM7DASMlrr     },
    {"MVN%sS %s",ARM7DASMari     },
    {"MVN%sS %s",ARM7DASMarr     },
    {"MVN%sS %s",ARM7DASMrri     },
    {"MVN%sS %s",ARM7DASMrrr     },
    {"MVN%sS %s",ARM7DASMlli     },
    {"UNP%s %s",ARM7DASMun       },  // Unallocated
    {"MVN%sS %s",ARM7DASMlri     },
    {"LDRH%s %s",ARM7DASMlmprip  },
    {"MVN%sS %s",ARM7DASMari     },
    {"LDRSB%s %s",ARM7DASMlmprip },
    {"MVN%sS %s",ARM7DASMrri     },
    {"LDRSH%s %s",ARM7DASMlmprip },

    //0x20
    {"AND%s %s",ARM7DASMimm      },
    {"AND%s %s",ARM7DASMimm      },
    {"AND%s %s",ARM7DASMimm      },
    {"AND%s %s",ARM7DASMimm      },
    {"AND%s %s",ARM7DASMimm      },
    {"AND%s %s",ARM7DASMimm      },
    {"AND%s %s",ARM7DASMimm      },
    {"AND%s %s",ARM7DASMimm      },
    {"AND%s %s",ARM7DASMimm      },
    {"AND%s %s",ARM7DASMimm      },
    {"AND%s %s",ARM7DASMimm      },
    {"AND%s %s",ARM7DASMimm      },
    {"AND%s %s",ARM7DASMimm      },
    {"AND%s %s",ARM7DASMimm      },
    {"AND%s %s",ARM7DASMimm      },
    {"AND%s %s",ARM7DASMimm      },

    //0x21
    {"AND%sS %s",ARM7DASMimm     },
    {"AND%sS %s",ARM7DASMimm     },
    {"AND%sS %s",ARM7DASMimm     },
    {"AND%sS %s",ARM7DASMimm     },
    {"AND%sS %s",ARM7DASMimm     },
    {"AND%sS %s",ARM7DASMimm     },
    {"AND%sS %s",ARM7DASMimm     },
    {"AND%sS %s",ARM7DASMimm     },
    {"AND%sS %s",ARM7DASMimm     },
    {"AND%sS %s",ARM7DASMimm     },
    {"AND%sS %s",ARM7DASMimm     },
    {"AND%sS %s",ARM7DASMimm     },
    {"AND%sS %s",ARM7DASMimm     },
    {"AND%sS %s",ARM7DASMimm     },
    {"AND%sS %s",ARM7DASMimm     },
    {"AND%sS %s",ARM7DASMimm     },

    //0x22
    {"EOR%s %s",ARM7DASMimm      },
    {"EOR%s %s",ARM7DASMimm      },
    {"EOR%s %s",ARM7DASMimm      },
    {"EOR%s %s",ARM7DASMimm      },
    {"EOR%s %s",ARM7DASMimm      },
    {"EOR%s %s",ARM7DASMimm      },
    {"EOR%s %s",ARM7DASMimm      },
    {"EOR%s %s",ARM7DASMimm      },
    {"EOR%s %s",ARM7DASMimm      },
    {"EOR%s %s",ARM7DASMimm      },
    {"EOR%s %s",ARM7DASMimm      },
    {"EOR%s %s",ARM7DASMimm      },
    {"EOR%s %s",ARM7DASMimm      },
    {"EOR%s %s",ARM7DASMimm      },
    {"EOR%s %s",ARM7DASMimm      },
    {"EOR%s %s",ARM7DASMimm      },

    //0x23
    {"EOR%sS %s",ARM7DASMimm     },
    {"EOR%sS %s",ARM7DASMimm     },
    {"EOR%sS %s",ARM7DASMimm     },
    {"EOR%sS %s",ARM7DASMimm     },
    {"EOR%sS %s",ARM7DASMimm     },
    {"EOR%sS %s",ARM7DASMimm     },
    {"EOR%sS %s",ARM7DASMimm     },
    {"EOR%sS %s",ARM7DASMimm     },
    {"EOR%sS %s",ARM7DASMimm     },
    {"EOR%sS %s",ARM7DASMimm     },
    {"EOR%sS %s",ARM7DASMimm     },
    {"EOR%sS %s",ARM7DASMimm     },
    {"EOR%sS %s",ARM7DASMimm     },
    {"EOR%sS %s",ARM7DASMimm     },
    {"EOR%sS %s",ARM7DASMimm     },
    {"EOR%sS %s",ARM7DASMimm     },

    //0x24
    {"SUB%s %s",ARM7DASMimm      },
    {"SUB%s %s",ARM7DASMimm      },
    {"SUB%s %s",ARM7DASMimm      },
    {"SUB%s %s",ARM7DASMimm      },
    {"SUB%s %s",ARM7DASMimm      },
    {"SUB%s %s",ARM7DASMimm      },
    {"SUB%s %s",ARM7DASMimm      },
    {"SUB%s %s",ARM7DASMimm      },
    {"SUB%s %s",ARM7DASMimm      },
    {"SUB%s %s",ARM7DASMimm      },
    {"SUB%s %s",ARM7DASMimm      },
    {"SUB%s %s",ARM7DASMimm      },
    {"SUB%s %s",ARM7DASMimm      },
    {"SUB%s %s",ARM7DASMimm      },
    {"SUB%s %s",ARM7DASMimm      },
    {"SUB%s %s",ARM7DASMimm      },

    //0x25
    {"SUB%sS %s",ARM7DASMimm     },
    {"SUB%sS %s",ARM7DASMimm     },
    {"SUB%sS %s",ARM7DASMimm     },
    {"SUB%sS %s",ARM7DASMimm     },
    {"SUB%sS %s",ARM7DASMimm     },
    {"SUB%sS %s",ARM7DASMimm     },
    {"SUB%sS %s",ARM7DASMimm     },
    {"SUB%sS %s",ARM7DASMimm     },
    {"SUB%sS %s",ARM7DASMimm     },
    {"SUB%sS %s",ARM7DASMimm     },
    {"SUB%sS %s",ARM7DASMimm     },
    {"SUB%sS %s",ARM7DASMimm     },
    {"SUB%sS %s",ARM7DASMimm     },
    {"SUB%sS %s",ARM7DASMimm     },
    {"SUB%sS %s",ARM7DASMimm     },
    {"SUB%sS %s",ARM7DASMimm     },

    //0x26
    {"RSB%s %s",ARM7DASMimm      },
    {"RSB%s %s",ARM7DASMimm      },
    {"RSB%s %s",ARM7DASMimm      },
    {"RSB%s %s",ARM7DASMimm      },
    {"RSB%s %s",ARM7DASMimm      },
    {"RSB%s %s",ARM7DASMimm      },
    {"RSB%s %s",ARM7DASMimm      },
    {"RSB%s %s",ARM7DASMimm      },
    {"RSB%s %s",ARM7DASMimm      },
    {"RSB%s %s",ARM7DASMimm      },
    {"RSB%s %s",ARM7DASMimm      },
    {"RSB%s %s",ARM7DASMimm      },
    {"RSB%s %s",ARM7DASMimm      },
    {"RSB%s %s",ARM7DASMimm      },
    {"RSB%s %s",ARM7DASMimm      },
    {"RSB%s %s",ARM7DASMimm      },

    //0x27
    {"RSB%sS %s",ARM7DASMimm     },
    {"RSB%sS %s",ARM7DASMimm     },
    {"RSB%sS %s",ARM7DASMimm     },
    {"RSB%sS %s",ARM7DASMimm     },
    {"RSB%sS %s",ARM7DASMimm     },
    {"RSB%sS %s",ARM7DASMimm     },
    {"RSB%sS %s",ARM7DASMimm     },
    {"RSB%sS %s",ARM7DASMimm     },
    {"RSB%sS %s",ARM7DASMimm     },
    {"RSB%sS %s",ARM7DASMimm     },
    {"RSB%sS %s",ARM7DASMimm     },
    {"RSB%sS %s",ARM7DASMimm     },
    {"RSB%sS %s",ARM7DASMimm     },
    {"RSB%sS %s",ARM7DASMimm     },
    {"RSB%sS %s",ARM7DASMimm     },
    {"RSB%sS %s",ARM7DASMimm     },

    //0x28
    {"ADD%s %s",ARM7DASMimm      },
    {"ADD%s %s",ARM7DASMimm      },
    {"ADD%s %s",ARM7DASMimm      },
    {"ADD%s %s",ARM7DASMimm      },
    {"ADD%s %s",ARM7DASMimm      },
    {"ADD%s %s",ARM7DASMimm      },
    {"ADD%s %s",ARM7DASMimm      },
    {"ADD%s %s",ARM7DASMimm      },
    {"ADD%s %s",ARM7DASMimm      },
    {"ADD%s %s",ARM7DASMimm      },
    {"ADD%s %s",ARM7DASMimm      },
    {"ADD%s %s",ARM7DASMimm      },
    {"ADD%s %s",ARM7DASMimm      },
    {"ADD%s %s",ARM7DASMimm      },
    {"ADD%s %s",ARM7DASMimm      },
    {"ADD%s %s",ARM7DASMimm      },

    //0x29
    {"ADD%sS %s",ARM7DASMimm     },
    {"ADD%sS %s",ARM7DASMimm     },
    {"ADD%sS %s",ARM7DASMimm     },
    {"ADD%sS %s",ARM7DASMimm     },
    {"ADD%sS %s",ARM7DASMimm     },
    {"ADD%sS %s",ARM7DASMimm     },
    {"ADD%sS %s",ARM7DASMimm     },
    {"ADD%sS %s",ARM7DASMimm     },
    {"ADD%sS %s",ARM7DASMimm     },
    {"ADD%sS %s",ARM7DASMimm     },
    {"ADD%sS %s",ARM7DASMimm     },
    {"ADD%sS %s",ARM7DASMimm     },
    {"ADD%sS %s",ARM7DASMimm     },
    {"ADD%sS %s",ARM7DASMimm     },
    {"ADD%sS %s",ARM7DASMimm     },
    {"ADD%sS %s",ARM7DASMimm     },

    //0x2A
    {"ADC%s %s",ARM7DASMimm      },
    {"ADC%s %s",ARM7DASMimm      },
    {"ADC%s %s",ARM7DASMimm      },
    {"ADC%s %s",ARM7DASMimm      },
    {"ADC%s %s",ARM7DASMimm      },
    {"ADC%s %s",ARM7DASMimm      },
    {"ADC%s %s",ARM7DASMimm      },
    {"ADC%s %s",ARM7DASMimm      },
    {"ADC%s %s",ARM7DASMimm      },
    {"ADC%s %s",ARM7DASMimm      },
    {"ADC%s %s",ARM7DASMimm      },
    {"ADC%s %s",ARM7DASMimm      },
    {"ADC%s %s",ARM7DASMimm      },
    {"ADC%s %s",ARM7DASMimm      },
    {"ADC%s %s",ARM7DASMimm      },
    {"ADC%s %s",ARM7DASMimm      },

    //0x2B
    {"ADC%sS %s",ARM7DASMimm     },
    {"ADC%sS %s",ARM7DASMimm     },
    {"ADC%sS %s",ARM7DASMimm     },
    {"ADC%sS %s",ARM7DASMimm     },
    {"ADC%sS %s",ARM7DASMimm     },
    {"ADC%sS %s",ARM7DASMimm     },
    {"ADC%sS %s",ARM7DASMimm     },
    {"ADC%sS %s",ARM7DASMimm     },
    {"ADC%sS %s",ARM7DASMimm     },
    {"ADC%sS %s",ARM7DASMimm     },
    {"ADC%sS %s",ARM7DASMimm     },
    {"ADC%sS %s",ARM7DASMimm     },
    {"ADC%sS %s",ARM7DASMimm     },
    {"ADC%sS %s",ARM7DASMimm     },
    {"ADC%sS %s",ARM7DASMimm     },
    {"ADC%sS %s",ARM7DASMimm     },

    //0x2C
    {"SBC%s %s",ARM7DASMimm      },
    {"SBC%s %s",ARM7DASMimm      },
    {"SBC%s %s",ARM7DASMimm      },
    {"SBC%s %s",ARM7DASMimm      },
    {"SBC%s %s",ARM7DASMimm      },
    {"SBC%s %s",ARM7DASMimm      },
    {"SBC%s %s",ARM7DASMimm      },
    {"SBC%s %s",ARM7DASMimm      },
    {"SBC%s %s",ARM7DASMimm      },
    {"SBC%s %s",ARM7DASMimm      },
    {"SBC%s %s",ARM7DASMimm      },
    {"SBC%s %s",ARM7DASMimm      },
    {"SBC%s %s",ARM7DASMimm      },
    {"SBC%s %s",ARM7DASMimm      },
    {"SBC%s %s",ARM7DASMimm      },
    {"SBC%s %s",ARM7DASMimm      },

    //0x2D
    {"SBC%sS %s",ARM7DASMimm     },
    {"SBC%sS %s",ARM7DASMimm     },
    {"SBC%sS %s",ARM7DASMimm     },
    {"SBC%sS %s",ARM7DASMimm     },
    {"SBC%sS %s",ARM7DASMimm     },
    {"SBC%sS %s",ARM7DASMimm     },
    {"SBC%sS %s",ARM7DASMimm     },
    {"SBC%sS %s",ARM7DASMimm     },
    {"SBC%sS %s",ARM7DASMimm     },
    {"SBC%sS %s",ARM7DASMimm     },
    {"SBC%sS %s",ARM7DASMimm     },
    {"SBC%sS %s",ARM7DASMimm     },
    {"SBC%sS %s",ARM7DASMimm     },
    {"SBC%sS %s",ARM7DASMimm     },
    {"SBC%sS %s",ARM7DASMimm     },
    {"SBC%sS %s",ARM7DASMimm     },

    //0x2E
    {"RSC%s %s",ARM7DASMimm      },
    {"RSC%s %s",ARM7DASMimm      },
    {"RSC%s %s",ARM7DASMimm      },
    {"RSC%s %s",ARM7DASMimm      },
    {"RSC%s %s",ARM7DASMimm      },
    {"RSC%s %s",ARM7DASMimm      },
    {"RSC%s %s",ARM7DASMimm      },
    {"RSC%s %s",ARM7DASMimm      },
    {"RSC%s %s",ARM7DASMimm      },
    {"RSC%s %s",ARM7DASMimm      },
    {"RSC%s %s",ARM7DASMimm      },
    {"RSC%s %s",ARM7DASMimm      },
    {"RSC%s %s",ARM7DASMimm      },
    {"RSC%s %s",ARM7DASMimm      },
    {"RSC%s %s",ARM7DASMimm      },
    {"RSC%s %s",ARM7DASMimm      },

    //0x2F
    {"RSC%sS %s",ARM7DASMimm     },
    {"RSC%sS %s",ARM7DASMimm     },
    {"RSC%sS %s",ARM7DASMimm     },
    {"RSC%sS %s",ARM7DASMimm     },
    {"RSC%sS %s",ARM7DASMimm     },
    {"RSC%sS %s",ARM7DASMimm     },
    {"RSC%sS %s",ARM7DASMimm     },
    {"RSC%sS %s",ARM7DASMimm     },
    {"RSC%sS %s",ARM7DASMimm     },
    {"RSC%sS %s",ARM7DASMimm     },
    {"RSC%sS %s",ARM7DASMimm     },
    {"RSC%sS %s",ARM7DASMimm     },
    {"RSC%sS %s",ARM7DASMimm     },
    {"RSC%sS %s",ARM7DASMimm     },
    {"RSC%sS %s",ARM7DASMimm     },
    {"RSC%sS %s",ARM7DASMimm     },

    //0x30
    {"UND%s %s",ARM7DASMun       },
    {"UND%s %s",ARM7DASMun       },
    {"UND%s %s",ARM7DASMun       },
    {"UND%s %s",ARM7DASMun       },
    {"UND%s %s",ARM7DASMun       },
    {"UND%s %s",ARM7DASMun       },
    {"UND%s %s",ARM7DASMun       },
    {"UND%s %s",ARM7DASMun       },
    {"UND%s %s",ARM7DASMun       },
    {"UND%s %s",ARM7DASMun       },
    {"UND%s %s",ARM7DASMun       },
    {"UND%s %s",ARM7DASMun       },
    {"UND%s %s",ARM7DASMun       },
    {"UND%s %s",ARM7DASMun       },
    {"UND%s %s",ARM7DASMun       },
    {"UND%s %s",ARM7DASMun       },

    //0x31
    {"TST%sS %s",ARM7DASMimm     },
    {"TST%sS %s",ARM7DASMimm     },
    {"TST%sS %s",ARM7DASMimm     },
    {"TST%sS %s",ARM7DASMimm     },
    {"TST%sS %s",ARM7DASMimm     },
    {"TST%sS %s",ARM7DASMimm     },
    {"TST%sS %s",ARM7DASMimm     },
    {"TST%sS %s",ARM7DASMimm     },
    {"TST%sS %s",ARM7DASMimm     },
    {"TST%sS %s",ARM7DASMimm     },
    {"TST%sS %s",ARM7DASMimm     },
    {"TST%sS %s",ARM7DASMimm     },
    {"TST%sS %s",ARM7DASMimm     },
    {"TST%sS %s",ARM7DASMimm     },
    {"TST%sS %s",ARM7DASMimm     },
    {"TST%sS %s",ARM7DASMimm     },

    //0x32
    {"MSR%s %s",ARM7DASMmsric       },
    {"MSR%s %s",ARM7DASMmsric       },
    {"MSR%s %s",ARM7DASMmsric       },
    {"MSR%s %s",ARM7DASMmsric       },
    {"MSR%s %s",ARM7DASMmsric       },
    {"MSR%s %s",ARM7DASMmsric       },
    {"MSR%s %s",ARM7DASMmsric       },
    {"MSR%s %s",ARM7DASMmsric       },
    {"MSR%s %s",ARM7DASMmsric       },
    {"MSR%s %s",ARM7DASMmsric       },
    {"MSR%s %s",ARM7DASMmsric       },
    {"MSR%s %s",ARM7DASMmsric       },
    {"MSR%s %s",ARM7DASMmsric       },
    {"MSR%s %s",ARM7DASMmsric       },
    {"MSR%s %s",ARM7DASMmsric       },
    {"MSR%s %s",ARM7DASMmsric       },

    //0x33
    {"TEQ%sS %s",ARM7DASMimm     },
    {"TEQ%sS %s",ARM7DASMimm     },
    {"TEQ%sS %s",ARM7DASMimm     },
    {"TEQ%sS %s",ARM7DASMimm     },
    {"TEQ%sS %s",ARM7DASMimm     },
    {"TEQ%sS %s",ARM7DASMimm     },
    {"TEQ%sS %s",ARM7DASMimm     },
    {"TEQ%sS %s",ARM7DASMimm     },
    {"TEQ%sS %s",ARM7DASMimm     },
    {"TEQ%sS %s",ARM7DASMimm     },
    {"TEQ%sS %s",ARM7DASMimm     },
    {"TEQ%sS %s",ARM7DASMimm     },
    {"TEQ%sS %s",ARM7DASMimm     },
    {"TEQ%sS %s",ARM7DASMimm     },
    {"TEQ%sS %s",ARM7DASMimm     },
    {"TEQ%sS %s",ARM7DASMimm     },

    //0x34
    {"UND%s %s",ARM7DASMun       },
    {"UND%s %s",ARM7DASMun       },
    {"UND%s %s",ARM7DASMun       },
    {"UND%s %s",ARM7DASMun       },
    {"UND%s %s",ARM7DASMun       },
    {"UND%s %s",ARM7DASMun       },
    {"UND%s %s",ARM7DASMun       },
    {"UND%s %s",ARM7DASMun       },
    {"UND%s %s",ARM7DASMun       },
    {"UND%s %s",ARM7DASMun       },
    {"UND%s %s",ARM7DASMun       },
    {"UND%s %s",ARM7DASMun       },
    {"UND%s %s",ARM7DASMun       },
    {"UND%s %s",ARM7DASMun       },
    {"UND%s %s",ARM7DASMun       },
    {"UND%s %s",ARM7DASMun       },

    //0x35
    {"CMP%sS %s",ARM7DASMimm     },
    {"CMP%sS %s",ARM7DASMimm     },
    {"CMP%sS %s",ARM7DASMimm     },
    {"CMP%sS %s",ARM7DASMimm     },
    {"CMP%sS %s",ARM7DASMimm     },
    {"CMP%sS %s",ARM7DASMimm     },
    {"CMP%sS %s",ARM7DASMimm     },
    {"CMP%sS %s",ARM7DASMimm     },
    {"CMP%sS %s",ARM7DASMimm     },
    {"CMP%sS %s",ARM7DASMimm     },
    {"CMP%sS %s",ARM7DASMimm     },
    {"CMP%sS %s",ARM7DASMimm     },
    {"CMP%sS %s",ARM7DASMimm     },
    {"CMP%sS %s",ARM7DASMimm     },
    {"CMP%sS %s",ARM7DASMimm     },
    {"CMP%sS %s",ARM7DASMimm     },

    //0x36
    {"MSR%s %s",ARM7DASMmsris       },
    {"MSR%s %s",ARM7DASMmsris       },
    {"MSR%s %s",ARM7DASMmsris       },
    {"MSR%s %s",ARM7DASMmsris       },
    {"MSR%s %s",ARM7DASMmsris       },
    {"MSR%s %s",ARM7DASMmsris       },
    {"MSR%s %s",ARM7DASMmsris       },
    {"MSR%s %s",ARM7DASMmsris       },
    {"MSR%s %s",ARM7DASMmsris       },
    {"MSR%s %s",ARM7DASMmsris       },
    {"MSR%s %s",ARM7DASMmsris       },
    {"MSR%s %s",ARM7DASMmsris       },
    {"MSR%s %s",ARM7DASMmsris       },
    {"MSR%s %s",ARM7DASMmsris       },
    {"MSR%s %s",ARM7DASMmsris       },
    {"MSR%s %s",ARM7DASMmsris       },

    //0x37
    {"CMN%sS %s",ARM7DASMimm     },
    {"CMN%sS %s",ARM7DASMimm     },
    {"CMN%sS %s",ARM7DASMimm     },
    {"CMN%sS %s",ARM7DASMimm     },
    {"CMN%sS %s",ARM7DASMimm     },
    {"CMN%sS %s",ARM7DASMimm     },
    {"CMN%sS %s",ARM7DASMimm     },
    {"CMN%sS %s",ARM7DASMimm     },
    {"CMN%sS %s",ARM7DASMimm     },
    {"CMN%sS %s",ARM7DASMimm     },
    {"CMN%sS %s",ARM7DASMimm     },
    {"CMN%sS %s",ARM7DASMimm     },
    {"CMN%sS %s",ARM7DASMimm     },
    {"CMN%sS %s",ARM7DASMimm     },
    {"CMN%sS %s",ARM7DASMimm     },
    {"CMN%sS %s",ARM7DASMimm     },

    //0x38
    {"ORR%s %s",ARM7DASMimm      },
    {"ORR%s %s",ARM7DASMimm      },
    {"ORR%s %s",ARM7DASMimm      },
    {"ORR%s %s",ARM7DASMimm      },
    {"ORR%s %s",ARM7DASMimm      },
    {"ORR%s %s",ARM7DASMimm      },
    {"ORR%s %s",ARM7DASMimm      },
    {"ORR%s %s",ARM7DASMimm      },
    {"ORR%s %s",ARM7DASMimm      },
    {"ORR%s %s",ARM7DASMimm      },
    {"ORR%s %s",ARM7DASMimm      },
    {"ORR%s %s",ARM7DASMimm      },
    {"ORR%s %s",ARM7DASMimm      },
    {"ORR%s %s",ARM7DASMimm      },
    {"ORR%s %s",ARM7DASMimm      },
    {"ORR%s %s",ARM7DASMimm      },

    //0x39
    {"ORR%sS %s",ARM7DASMimm     },
    {"ORR%sS %s",ARM7DASMimm     },
    {"ORR%sS %s",ARM7DASMimm     },
    {"ORR%sS %s",ARM7DASMimm     },
    {"ORR%sS %s",ARM7DASMimm     },
    {"ORR%sS %s",ARM7DASMimm     },
    {"ORR%sS %s",ARM7DASMimm     },
    {"ORR%sS %s",ARM7DASMimm     },
    {"ORR%sS %s",ARM7DASMimm     },
    {"ORR%sS %s",ARM7DASMimm     },
    {"ORR%sS %s",ARM7DASMimm     },
    {"ORR%sS %s",ARM7DASMimm     },
    {"ORR%sS %s",ARM7DASMimm     },
    {"ORR%sS %s",ARM7DASMimm     },
    {"ORR%sS %s",ARM7DASMimm     },
    {"ORR%sS %s",ARM7DASMimm     },

    //0x3A
    {"MOV%s %s",ARM7DASMimm      },
    {"MOV%s %s",ARM7DASMimm      },
    {"MOV%s %s",ARM7DASMimm      },
    {"MOV%s %s",ARM7DASMimm      },
    {"MOV%s %s",ARM7DASMimm      },
    {"MOV%s %s",ARM7DASMimm      },
    {"MOV%s %s",ARM7DASMimm      },
    {"MOV%s %s",ARM7DASMimm      },
    {"MOV%s %s",ARM7DASMimm      },
    {"MOV%s %s",ARM7DASMimm      },
    {"MOV%s %s",ARM7DASMimm      },
    {"MOV%s %s",ARM7DASMimm      },
    {"MOV%s %s",ARM7DASMimm      },
    {"MOV%s %s",ARM7DASMimm      },
    {"MOV%s %s",ARM7DASMimm      },
    {"MOV%s %s",ARM7DASMimm      },

    //0x3B
    {"MOV%sS %s",ARM7DASMimm     },
    {"MOV%sS %s",ARM7DASMimm     },
    {"MOV%sS %s",ARM7DASMimm     },
    {"MOV%sS %s",ARM7DASMimm     },
    {"MOV%sS %s",ARM7DASMimm     },
    {"MOV%sS %s",ARM7DASMimm     },
    {"MOV%sS %s",ARM7DASMimm     },
    {"MOV%sS %s",ARM7DASMimm     },
    {"MOV%sS %s",ARM7DASMimm     },
    {"MOV%sS %s",ARM7DASMimm     },
    {"MOV%sS %s",ARM7DASMimm     },
    {"MOV%sS %s",ARM7DASMimm     },
    {"MOV%sS %s",ARM7DASMimm     },
    {"MOV%sS %s",ARM7DASMimm     },
    {"MOV%sS %s",ARM7DASMimm     },
    {"MOV%sS %s",ARM7DASMimm     },

    //0x3C
    {"BIC%s %s",ARM7DASMimm      },
    {"BIC%s %s",ARM7DASMimm      },
    {"BIC%s %s",ARM7DASMimm      },
    {"BIC%s %s",ARM7DASMimm      },
    {"BIC%s %s",ARM7DASMimm      },
    {"BIC%s %s",ARM7DASMimm      },
    {"BIC%s %s",ARM7DASMimm      },
    {"BIC%s %s",ARM7DASMimm      },
    {"BIC%s %s",ARM7DASMimm      },
    {"BIC%s %s",ARM7DASMimm      },
    {"BIC%s %s",ARM7DASMimm      },
    {"BIC%s %s",ARM7DASMimm      },
    {"BIC%s %s",ARM7DASMimm      },
    {"BIC%s %s",ARM7DASMimm      },
    {"BIC%s %s",ARM7DASMimm      },
    {"BIC%s %s",ARM7DASMimm      },

    //0x3D
    {"BIC%sS %s",ARM7DASMimm     },
    {"BIC%sS %s",ARM7DASMimm     },
    {"BIC%sS %s",ARM7DASMimm     },
    {"BIC%sS %s",ARM7DASMimm     },
    {"BIC%sS %s",ARM7DASMimm     },
    {"BIC%sS %s",ARM7DASMimm     },
    {"BIC%sS %s",ARM7DASMimm     },
    {"BIC%sS %s",ARM7DASMimm     },
    {"BIC%sS %s",ARM7DASMimm     },
    {"BIC%sS %s",ARM7DASMimm     },
    {"BIC%sS %s",ARM7DASMimm     },
    {"BIC%sS %s",ARM7DASMimm     },
    {"BIC%sS %s",ARM7DASMimm     },
    {"BIC%sS %s",ARM7DASMimm     },
    {"BIC%sS %s",ARM7DASMimm     },
    {"BIC%sS %s",ARM7DASMimm     },

    //0x3E
    {"MVN%s %s",ARM7DASMimm      },
    {"MVN%s %s",ARM7DASMimm      },
    {"MVN%s %s",ARM7DASMimm      },
    {"MVN%s %s",ARM7DASMimm      },
    {"MVN%s %s",ARM7DASMimm      },
    {"MVN%s %s",ARM7DASMimm      },
    {"MVN%s %s",ARM7DASMimm      },
    {"MVN%s %s",ARM7DASMimm      },
    {"MVN%s %s",ARM7DASMimm      },
    {"MVN%s %s",ARM7DASMimm      },
    {"MVN%s %s",ARM7DASMimm      },
    {"MVN%s %s",ARM7DASMimm      },
    {"MVN%s %s",ARM7DASMimm      },
    {"MVN%s %s",ARM7DASMimm      },
    {"MVN%s %s",ARM7DASMimm      },
    {"MVN%s %s",ARM7DASMimm      },

    //0x3F
    {"MVN%sS %s",ARM7DASMimm     },
    {"MVN%sS %s",ARM7DASMimm     },
    {"MVN%sS %s",ARM7DASMimm     },
    {"MVN%sS %s",ARM7DASMimm     },
    {"MVN%sS %s",ARM7DASMimm     },
    {"MVN%sS %s",ARM7DASMimm     },
    {"MVN%sS %s",ARM7DASMimm     },
    {"MVN%sS %s",ARM7DASMimm     },
    {"MVN%sS %s",ARM7DASMimm     },
    {"MVN%sS %s",ARM7DASMimm     },
    {"MVN%sS %s",ARM7DASMimm     },
    {"MVN%sS %s",ARM7DASMimm     },
    {"MVN%sS %s",ARM7DASMimm     },
    {"MVN%sS %s",ARM7DASMimm     },
    {"MVN%sS %s",ARM7DASMimm     },
    {"MVN%sS %s",ARM7DASMimm     },

    //0x40
    {"STR%s %s",ARM7DASMptim     },
    {"STR%s %s",ARM7DASMptim     },
    {"STR%s %s",ARM7DASMptim     },
    {"STR%s %s",ARM7DASMptim     },
    {"STR%s %s",ARM7DASMptim     },
    {"STR%s %s",ARM7DASMptim     },
    {"STR%s %s",ARM7DASMptim     },
    {"STR%s %s",ARM7DASMptim     },
    {"STR%s %s",ARM7DASMptim     },
    {"STR%s %s",ARM7DASMptim     },
    {"STR%s %s",ARM7DASMptim     },
    {"STR%s %s",ARM7DASMptim     },
    {"STR%s %s",ARM7DASMptim     },
    {"STR%s %s",ARM7DASMptim     },
    {"STR%s %s",ARM7DASMptim     },
    {"STR%s %s",ARM7DASMptim     },

    //0x41
    {"LDR%s %s",ARM7DASMptim     },
    {"LDR%s %s",ARM7DASMptim     },
    {"LDR%s %s",ARM7DASMptim     },
    {"LDR%s %s",ARM7DASMptim     },
    {"LDR%s %s",ARM7DASMptim     },
    {"LDR%s %s",ARM7DASMptim     },
    {"LDR%s %s",ARM7DASMptim     },
    {"LDR%s %s",ARM7DASMptim     },
    {"LDR%s %s",ARM7DASMptim     },
    {"LDR%s %s",ARM7DASMptim     },
    {"LDR%s %s",ARM7DASMptim     },
    {"LDR%s %s",ARM7DASMptim     },
    {"LDR%s %s",ARM7DASMptim     },
    {"LDR%s %s",ARM7DASMptim     },
    {"LDR%s %s",ARM7DASMptim     },
    {"LDR%s %s",ARM7DASMptim     },

    //0x42
    {"STRT%s %s",ARM7DASMptim    },
    {"STRT%s %s",ARM7DASMptim    },
    {"STRT%s %s",ARM7DASMptim    },
    {"STRT%s %s",ARM7DASMptim    },
    {"STRT%s %s",ARM7DASMptim    },
    {"STRT%s %s",ARM7DASMptim    },
    {"STRT%s %s",ARM7DASMptim    },
    {"STRT%s %s",ARM7DASMptim    },
    {"STRT%s %s",ARM7DASMptim    },
    {"STRT%s %s",ARM7DASMptim    },
    {"STRT%s %s",ARM7DASMptim    },
    {"STRT%s %s",ARM7DASMptim    },
    {"STRT%s %s",ARM7DASMptim    },
    {"STRT%s %s",ARM7DASMptim    },
    {"STRT%s %s",ARM7DASMptim    },
    {"STRT%s %s",ARM7DASMptim    },

    //0x43
    {"LDRT%s %s",ARM7DASMptim    },
    {"LDRT%s %s",ARM7DASMptim    },
    {"LDRT%s %s",ARM7DASMptim    },
    {"LDRT%s %s",ARM7DASMptim    },
    {"LDRT%s %s",ARM7DASMptim    },
    {"LDRT%s %s",ARM7DASMptim    },
    {"LDRT%s %s",ARM7DASMptim    },
    {"LDRT%s %s",ARM7DASMptim    },
    {"LDRT%s %s",ARM7DASMptim    },
    {"LDRT%s %s",ARM7DASMptim    },
    {"LDRT%s %s",ARM7DASMptim    },
    {"LDRT%s %s",ARM7DASMptim    },
    {"LDRT%s %s",ARM7DASMptim    },
    {"LDRT%s %s",ARM7DASMptim    },
    {"LDRT%s %s",ARM7DASMptim    },
    {"LDRT%s %s",ARM7DASMptim    },

    //0x44
    {"STRB%s %s",ARM7DASMptim    },
    {"STRB%s %s",ARM7DASMptim    },
    {"STRB%s %s",ARM7DASMptim    },
    {"STRB%s %s",ARM7DASMptim    },
    {"STRB%s %s",ARM7DASMptim    },
    {"STRB%s %s",ARM7DASMptim    },
    {"STRB%s %s",ARM7DASMptim    },
    {"STRB%s %s",ARM7DASMptim    },
    {"STRB%s %s",ARM7DASMptim    },
    {"STRB%s %s",ARM7DASMptim    },
    {"STRB%s %s",ARM7DASMptim    },
    {"STRB%s %s",ARM7DASMptim    },
    {"STRB%s %s",ARM7DASMptim    },
    {"STRB%s %s",ARM7DASMptim    },
    {"STRB%s %s",ARM7DASMptim    },
    {"STRB%s %s",ARM7DASMptim    },

    //0x45
    {"LDRB%s %s",ARM7DASMptim    },
    {"LDRB%s %s",ARM7DASMptim    },
    {"LDRB%s %s",ARM7DASMptim    },
    {"LDRB%s %s",ARM7DASMptim    },
    {"LDRB%s %s",ARM7DASMptim    },
    {"LDRB%s %s",ARM7DASMptim    },
    {"LDRB%s %s",ARM7DASMptim    },
    {"LDRB%s %s",ARM7DASMptim    },
    {"LDRB%s %s",ARM7DASMptim    },
    {"LDRB%s %s",ARM7DASMptim    },
    {"LDRB%s %s",ARM7DASMptim    },
    {"LDRB%s %s",ARM7DASMptim    },
    {"LDRB%s %s",ARM7DASMptim    },
    {"LDRB%s %s",ARM7DASMptim    },
    {"LDRB%s %s",ARM7DASMptim    },
    {"LDRB%s %s",ARM7DASMptim    },

    //0x46
    {"STRBT%s %s",ARM7DASMptim   },
    {"STRBT%s %s",ARM7DASMptim   },
    {"STRBT%s %s",ARM7DASMptim   },
    {"STRBT%s %s",ARM7DASMptim   },
    {"STRBT%s %s",ARM7DASMptim   },
    {"STRBT%s %s",ARM7DASMptim   },
    {"STRBT%s %s",ARM7DASMptim   },
    {"STRBT%s %s",ARM7DASMptim   },
    {"STRBT%s %s",ARM7DASMptim   },
    {"STRBT%s %s",ARM7DASMptim   },
    {"STRBT%s %s",ARM7DASMptim   },
    {"STRBT%s %s",ARM7DASMptim   },
    {"STRBT%s %s",ARM7DASMptim   },
    {"STRBT%s %s",ARM7DASMptim   },
    {"STRBT%s %s",ARM7DASMptim   },
    {"STRBT%s %s",ARM7DASMptim   },

    //0x47
    {"LDRBT%s %s",ARM7DASMptim   },
    {"LDRBT%s %s",ARM7DASMptim   },
    {"LDRBT%s %s",ARM7DASMptim   },
    {"LDRBT%s %s",ARM7DASMptim   },
    {"LDRBT%s %s",ARM7DASMptim   },
    {"LDRBT%s %s",ARM7DASMptim   },
    {"LDRBT%s %s",ARM7DASMptim   },
    {"LDRBT%s %s",ARM7DASMptim   },
    {"LDRBT%s %s",ARM7DASMptim   },
    {"LDRBT%s %s",ARM7DASMptim   },
    {"LDRBT%s %s",ARM7DASMptim   },
    {"LDRBT%s %s",ARM7DASMptim   },
    {"LDRBT%s %s",ARM7DASMptim   },
    {"LDRBT%s %s",ARM7DASMptim   },
    {"LDRBT%s %s",ARM7DASMptim   },
    {"LDRBT%s %s",ARM7DASMptim   },

    //0x48
    {"STR%s %s",ARM7DASMptip     },
    {"STR%s %s",ARM7DASMptip     },
    {"STR%s %s",ARM7DASMptip     },
    {"STR%s %s",ARM7DASMptip     },
    {"STR%s %s",ARM7DASMptip     },
    {"STR%s %s",ARM7DASMptip     },
    {"STR%s %s",ARM7DASMptip     },
    {"STR%s %s",ARM7DASMptip     },
    {"STR%s %s",ARM7DASMptip     },
    {"STR%s %s",ARM7DASMptip     },
    {"STR%s %s",ARM7DASMptip     },
    {"STR%s %s",ARM7DASMptip     },
    {"STR%s %s",ARM7DASMptip     },
    {"STR%s %s",ARM7DASMptip     },
    {"STR%s %s",ARM7DASMptip     },
    {"STR%s %s",ARM7DASMptip     },

    //0x49
    {"LDR%s %s",ARM7DASMptip     },
    {"LDR%s %s",ARM7DASMptip     },
    {"LDR%s %s",ARM7DASMptip     },
    {"LDR%s %s",ARM7DASMptip     },
    {"LDR%s %s",ARM7DASMptip     },
    {"LDR%s %s",ARM7DASMptip     },
    {"LDR%s %s",ARM7DASMptip     },
    {"LDR%s %s",ARM7DASMptip     },
    {"LDR%s %s",ARM7DASMptip     },
    {"LDR%s %s",ARM7DASMptip     },
    {"LDR%s %s",ARM7DASMptip     },
    {"LDR%s %s",ARM7DASMptip     },
    {"LDR%s %s",ARM7DASMptip     },
    {"LDR%s %s",ARM7DASMptip     },
    {"LDR%s %s",ARM7DASMptip     },
    {"LDR%s %s",ARM7DASMptip     },

    //0x4A
    {"STRT%s %s",ARM7DASMptip    },
    {"STRT%s %s",ARM7DASMptip    },
    {"STRT%s %s",ARM7DASMptip    },
    {"STRT%s %s",ARM7DASMptip    },
    {"STRT%s %s",ARM7DASMptip    },
    {"STRT%s %s",ARM7DASMptip    },
    {"STRT%s %s",ARM7DASMptip    },
    {"STRT%s %s",ARM7DASMptip    },
    {"STRT%s %s",ARM7DASMptip    },
    {"STRT%s %s",ARM7DASMptip    },
    {"STRT%s %s",ARM7DASMptip    },
    {"STRT%s %s",ARM7DASMptip    },
    {"STRT%s %s",ARM7DASMptip    },
    {"STRT%s %s",ARM7DASMptip    },
    {"STRT%s %s",ARM7DASMptip    },
    {"STRT%s %s",ARM7DASMptip    },

    //0x4B
    {"LDRT%s %s",ARM7DASMptip    },
    {"LDRT%s %s",ARM7DASMptip    },
    {"LDRT%s %s",ARM7DASMptip    },
    {"LDRT%s %s",ARM7DASMptip    },
    {"LDRT%s %s",ARM7DASMptip    },
    {"LDRT%s %s",ARM7DASMptip    },
    {"LDRT%s %s",ARM7DASMptip    },
    {"LDRT%s %s",ARM7DASMptip    },
    {"LDRT%s %s",ARM7DASMptip    },
    {"LDRT%s %s",ARM7DASMptip    },
    {"LDRT%s %s",ARM7DASMptip    },
    {"LDRT%s %s",ARM7DASMptip    },
    {"LDRT%s %s",ARM7DASMptip    },
    {"LDRT%s %s",ARM7DASMptip    },
    {"LDRT%s %s",ARM7DASMptip    },
    {"LDRT%s %s",ARM7DASMptip    },

    //0x4C
    {"STRB%s %s",ARM7DASMptip    },
    {"STRB%s %s",ARM7DASMptip    },
    {"STRB%s %s",ARM7DASMptip    },
    {"STRB%s %s",ARM7DASMptip    },
    {"STRB%s %s",ARM7DASMptip    },
    {"STRB%s %s",ARM7DASMptip    },
    {"STRB%s %s",ARM7DASMptip    },
    {"STRB%s %s",ARM7DASMptip    },
    {"STRB%s %s",ARM7DASMptip    },
    {"STRB%s %s",ARM7DASMptip    },
    {"STRB%s %s",ARM7DASMptip    },
    {"STRB%s %s",ARM7DASMptip    },
    {"STRB%s %s",ARM7DASMptip    },
    {"STRB%s %s",ARM7DASMptip    },
    {"STRB%s %s",ARM7DASMptip    },
    {"STRB%s %s",ARM7DASMptip    },

    //0x4D
    {"LDRB%s %s",ARM7DASMptip    },
    {"LDRB%s %s",ARM7DASMptip    },
    {"LDRB%s %s",ARM7DASMptip    },
    {"LDRB%s %s",ARM7DASMptip    },
    {"LDRB%s %s",ARM7DASMptip    },
    {"LDRB%s %s",ARM7DASMptip    },
    {"LDRB%s %s",ARM7DASMptip    },
    {"LDRB%s %s",ARM7DASMptip    },
    {"LDRB%s %s",ARM7DASMptip    },
    {"LDRB%s %s",ARM7DASMptip    },
    {"LDRB%s %s",ARM7DASMptip    },
    {"LDRB%s %s",ARM7DASMptip    },
    {"LDRB%s %s",ARM7DASMptip    },
    {"LDRB%s %s",ARM7DASMptip    },
    {"LDRB%s %s",ARM7DASMptip    },
    {"LDRB%s %s",ARM7DASMptip    },

    //0x4E
    {"STRBT%s %s",ARM7DASMptip   },
    {"STRBT%s %s",ARM7DASMptip   },
    {"STRBT%s %s",ARM7DASMptip   },
    {"STRBT%s %s",ARM7DASMptip   },
    {"STRBT%s %s",ARM7DASMptip   },
    {"STRBT%s %s",ARM7DASMptip   },
    {"STRBT%s %s",ARM7DASMptip   },
    {"STRBT%s %s",ARM7DASMptip   },
    {"STRBT%s %s",ARM7DASMptip   },
    {"STRBT%s %s",ARM7DASMptip   },
    {"STRBT%s %s",ARM7DASMptip   },
    {"STRBT%s %s",ARM7DASMptip   },
    {"STRBT%s %s",ARM7DASMptip   },
    {"STRBT%s %s",ARM7DASMptip   },
    {"STRBT%s %s",ARM7DASMptip   },
    {"STRBT%s %s",ARM7DASMptip   },

    //0x4F
    {"LDRBT%s %s",ARM7DASMptip   },
    {"LDRBT%s %s",ARM7DASMptip   },
    {"LDRBT%s %s",ARM7DASMptip   },
    {"LDRBT%s %s",ARM7DASMptip   },
    {"LDRBT%s %s",ARM7DASMptip   },
    {"LDRBT%s %s",ARM7DASMptip   },
    {"LDRBT%s %s",ARM7DASMptip   },
    {"LDRBT%s %s",ARM7DASMptip   },
    {"LDRBT%s %s",ARM7DASMptip   },
    {"LDRBT%s %s",ARM7DASMptip   },
    {"LDRBT%s %s",ARM7DASMptip   },
    {"LDRBT%s %s",ARM7DASMptip   },
    {"LDRBT%s %s",ARM7DASMptip   },
    {"LDRBT%s %s",ARM7DASMptip   },
    {"LDRBT%s %s",ARM7DASMptip   },
    {"LDRBT%s %s",ARM7DASMptip   },

    //0x50
    {"STR%s %s",ARM7DASMofim     },
    {"STR%s %s",ARM7DASMofim     },
    {"STR%s %s",ARM7DASMofim     },
    {"STR%s %s",ARM7DASMofim     },
    {"STR%s %s",ARM7DASMofim     },
    {"STR%s %s",ARM7DASMofim     },
    {"STR%s %s",ARM7DASMofim     },
    {"STR%s %s",ARM7DASMofim     },
    {"STR%s %s",ARM7DASMofim     },
    {"STR%s %s",ARM7DASMofim     },
    {"STR%s %s",ARM7DASMofim     },
    {"STR%s %s",ARM7DASMofim     },
    {"STR%s %s",ARM7DASMofim     },
    {"STR%s %s",ARM7DASMofim     },
    {"STR%s %s",ARM7DASMofim     },
    {"STR%s %s",ARM7DASMofim     },

    //0x51
    {"LDR%s %s",ARM7DASMofim     },
    {"LDR%s %s",ARM7DASMofim     },
    {"LDR%s %s",ARM7DASMofim     },
    {"LDR%s %s",ARM7DASMofim     },
    {"LDR%s %s",ARM7DASMofim     },
    {"LDR%s %s",ARM7DASMofim     },
    {"LDR%s %s",ARM7DASMofim     },
    {"LDR%s %s",ARM7DASMofim     },
    {"LDR%s %s",ARM7DASMofim     },
    {"LDR%s %s",ARM7DASMofim     },
    {"LDR%s %s",ARM7DASMofim     },
    {"LDR%s %s",ARM7DASMofim     },
    {"LDR%s %s",ARM7DASMofim     },
    {"LDR%s %s",ARM7DASMofim     },
    {"LDR%s %s",ARM7DASMofim     },
    {"LDR%s %s",ARM7DASMofim     },

    //0x52
    {"STR%s %s",ARM7DASMprim     },
    {"STR%s %s",ARM7DASMprim     },
    {"STR%s %s",ARM7DASMprim     },
    {"STR%s %s",ARM7DASMprim     },
    {"STR%s %s",ARM7DASMprim     },
    {"STR%s %s",ARM7DASMprim     },
    {"STR%s %s",ARM7DASMprim     },
    {"STR%s %s",ARM7DASMprim     },
    {"STR%s %s",ARM7DASMprim     },
    {"STR%s %s",ARM7DASMprim     },
    {"STR%s %s",ARM7DASMprim     },
    {"STR%s %s",ARM7DASMprim     },
    {"STR%s %s",ARM7DASMprim     },
    {"STR%s %s",ARM7DASMprim     },
    {"STR%s %s",ARM7DASMprim     },
    {"STR%s %s",ARM7DASMprim     },

    //0x53
    {"LDR%s %s",ARM7DASMprim     },
    {"LDR%s %s",ARM7DASMprim     },
    {"LDR%s %s",ARM7DASMprim     },
    {"LDR%s %s",ARM7DASMprim     },
    {"LDR%s %s",ARM7DASMprim     },
    {"LDR%s %s",ARM7DASMprim     },
    {"LDR%s %s",ARM7DASMprim     },
    {"LDR%s %s",ARM7DASMprim     },
    {"LDR%s %s",ARM7DASMprim     },
    {"LDR%s %s",ARM7DASMprim     },
    {"LDR%s %s",ARM7DASMprim     },
    {"LDR%s %s",ARM7DASMprim     },
    {"LDR%s %s",ARM7DASMprim     },
    {"LDR%s %s",ARM7DASMprim     },
    {"LDR%s %s",ARM7DASMprim     },
    {"LDR%s %s",ARM7DASMprim     },

    //0x54
    {"STRB%s %s",ARM7DASMofim    },
    {"STRB%s %s",ARM7DASMofim    },
    {"STRB%s %s",ARM7DASMofim    },
    {"STRB%s %s",ARM7DASMofim    },
    {"STRB%s %s",ARM7DASMofim    },
    {"STRB%s %s",ARM7DASMofim    },
    {"STRB%s %s",ARM7DASMofim    },
    {"STRB%s %s",ARM7DASMofim    },
    {"STRB%s %s",ARM7DASMofim    },
    {"STRB%s %s",ARM7DASMofim    },
    {"STRB%s %s",ARM7DASMofim    },
    {"STRB%s %s",ARM7DASMofim    },
    {"STRB%s %s",ARM7DASMofim    },
    {"STRB%s %s",ARM7DASMofim    },
    {"STRB%s %s",ARM7DASMofim    },
    {"STRB%s %s",ARM7DASMofim    },

    //0x55
    {"LDRB%s %s",ARM7DASMofim    },
    {"LDRB%s %s",ARM7DASMofim    },
    {"LDRB%s %s",ARM7DASMofim    },
    {"LDRB%s %s",ARM7DASMofim    },
    {"LDRB%s %s",ARM7DASMofim    },
    {"LDRB%s %s",ARM7DASMofim    },
    {"LDRB%s %s",ARM7DASMofim    },
    {"LDRB%s %s",ARM7DASMofim    },
    {"LDRB%s %s",ARM7DASMofim    },
    {"LDRB%s %s",ARM7DASMofim    },
    {"LDRB%s %s",ARM7DASMofim    },
    {"LDRB%s %s",ARM7DASMofim    },
    {"LDRB%s %s",ARM7DASMofim    },
    {"LDRB%s %s",ARM7DASMofim    },
    {"LDRB%s %s",ARM7DASMofim    },
    {"LDRB%s %s",ARM7DASMofim    },

    //0x56
    {"STRB%s %s",ARM7DASMprim    },
    {"STRB%s %s",ARM7DASMprim    },
    {"STRB%s %s",ARM7DASMprim    },
    {"STRB%s %s",ARM7DASMprim    },
    {"STRB%s %s",ARM7DASMprim    },
    {"STRB%s %s",ARM7DASMprim    },
    {"STRB%s %s",ARM7DASMprim    },
    {"STRB%s %s",ARM7DASMprim    },
    {"STRB%s %s",ARM7DASMprim    },
    {"STRB%s %s",ARM7DASMprim    },
    {"STRB%s %s",ARM7DASMprim    },
    {"STRB%s %s",ARM7DASMprim    },
    {"STRB%s %s",ARM7DASMprim    },
    {"STRB%s %s",ARM7DASMprim    },
    {"STRB%s %s",ARM7DASMprim    },
    {"STRB%s %s",ARM7DASMprim    },

    //0x57
    {"LDRB%s %s",ARM7DASMprim    },
    {"LDRB%s %s",ARM7DASMprim    },
    {"LDRB%s %s",ARM7DASMprim    },
    {"LDRB%s %s",ARM7DASMprim    },
    {"LDRB%s %s",ARM7DASMprim    },
    {"LDRB%s %s",ARM7DASMprim    },
    {"LDRB%s %s",ARM7DASMprim    },
    {"LDRB%s %s",ARM7DASMprim    },
    {"LDRB%s %s",ARM7DASMprim    },
    {"LDRB%s %s",ARM7DASMprim    },
    {"LDRB%s %s",ARM7DASMprim    },
    {"LDRB%s %s",ARM7DASMprim    },
    {"LDRB%s %s",ARM7DASMprim    },
    {"LDRB%s %s",ARM7DASMprim    },
    {"LDRB%s %s",ARM7DASMprim    },
    {"LDRB%s %s",ARM7DASMprim    },

    //0x58
    {"STR%s %s",ARM7DASMofip     },
    {"STR%s %s",ARM7DASMofip     },
    {"STR%s %s",ARM7DASMofip     },
    {"STR%s %s",ARM7DASMofip     },
    {"STR%s %s",ARM7DASMofip     },
    {"STR%s %s",ARM7DASMofip     },
    {"STR%s %s",ARM7DASMofip     },
    {"STR%s %s",ARM7DASMofip     },
    {"STR%s %s",ARM7DASMofip     },
    {"STR%s %s",ARM7DASMofip     },
    {"STR%s %s",ARM7DASMofip     },
    {"STR%s %s",ARM7DASMofip     },
    {"STR%s %s",ARM7DASMofip     },
    {"STR%s %s",ARM7DASMofip     },
    {"STR%s %s",ARM7DASMofip     },
    {"STR%s %s",ARM7DASMofip     },

    //0x59
    {"LDR%s %s",ARM7DASMofip     },
    {"LDR%s %s",ARM7DASMofip     },
    {"LDR%s %s",ARM7DASMofip     },
    {"LDR%s %s",ARM7DASMofip     },
    {"LDR%s %s",ARM7DASMofip     },
    {"LDR%s %s",ARM7DASMofip     },
    {"LDR%s %s",ARM7DASMofip     },
    {"LDR%s %s",ARM7DASMofip     },
    {"LDR%s %s",ARM7DASMofip     },
    {"LDR%s %s",ARM7DASMofip     },
    {"LDR%s %s",ARM7DASMofip     },
    {"LDR%s %s",ARM7DASMofip     },
    {"LDR%s %s",ARM7DASMofip     },
    {"LDR%s %s",ARM7DASMofip     },
    {"LDR%s %s",ARM7DASMofip     },
    {"LDR%s %s",ARM7DASMofip     },

    //0x5A
    {"STR%s %s",ARM7DASMprip     },
    {"STR%s %s",ARM7DASMprip     },
    {"STR%s %s",ARM7DASMprip     },
    {"STR%s %s",ARM7DASMprip     },
    {"STR%s %s",ARM7DASMprip     },
    {"STR%s %s",ARM7DASMprip     },
    {"STR%s %s",ARM7DASMprip     },
    {"STR%s %s",ARM7DASMprip     },
    {"STR%s %s",ARM7DASMprip     },
    {"STR%s %s",ARM7DASMprip     },
    {"STR%s %s",ARM7DASMprip     },
    {"STR%s %s",ARM7DASMprip     },
    {"STR%s %s",ARM7DASMprip     },
    {"STR%s %s",ARM7DASMprip     },
    {"STR%s %s",ARM7DASMprip     },
    {"STR%s %s",ARM7DASMprip     },

    //0x5B
    {"LDR%s %s",ARM7DASMprip     },
    {"LDR%s %s",ARM7DASMprip     },
    {"LDR%s %s",ARM7DASMprip     },
    {"LDR%s %s",ARM7DASMprip     },
    {"LDR%s %s",ARM7DASMprip     },
    {"LDR%s %s",ARM7DASMprip     },
    {"LDR%s %s",ARM7DASMprip     },
    {"LDR%s %s",ARM7DASMprip     },
    {"LDR%s %s",ARM7DASMprip     },
    {"LDR%s %s",ARM7DASMprip     },
    {"LDR%s %s",ARM7DASMprip     },
    {"LDR%s %s",ARM7DASMprip     },
    {"LDR%s %s",ARM7DASMprip     },
    {"LDR%s %s",ARM7DASMprip     },
    {"LDR%s %s",ARM7DASMprip     },
    {"LDR%s %s",ARM7DASMprip     },

    //0x5C
    {"STRB%s %s",ARM7DASMofip    },
    {"STRB%s %s",ARM7DASMofip    },
    {"STRB%s %s",ARM7DASMofip    },
    {"STRB%s %s",ARM7DASMofip    },
    {"STRB%s %s",ARM7DASMofip    },
    {"STRB%s %s",ARM7DASMofip    },
    {"STRB%s %s",ARM7DASMofip    },
    {"STRB%s %s",ARM7DASMofip    },
    {"STRB%s %s",ARM7DASMofip    },
    {"STRB%s %s",ARM7DASMofip    },
    {"STRB%s %s",ARM7DASMofip    },
    {"STRB%s %s",ARM7DASMofip    },
    {"STRB%s %s",ARM7DASMofip    },
    {"STRB%s %s",ARM7DASMofip    },
    {"STRB%s %s",ARM7DASMofip    },
    {"STRB%s %s",ARM7DASMofip    },

    //0x5D
    {"LDRB%s %s",ARM7DASMofip    },
    {"LDRB%s %s",ARM7DASMofip    },
    {"LDRB%s %s",ARM7DASMofip    },
    {"LDRB%s %s",ARM7DASMofip    },
    {"LDRB%s %s",ARM7DASMofip    },
    {"LDRB%s %s",ARM7DASMofip    },
    {"LDRB%s %s",ARM7DASMofip    },
    {"LDRB%s %s",ARM7DASMofip    },
    {"LDRB%s %s",ARM7DASMofip    },
    {"LDRB%s %s",ARM7DASMofip    },
    {"LDRB%s %s",ARM7DASMofip    },
    {"LDRB%s %s",ARM7DASMofip    },
    {"LDRB%s %s",ARM7DASMofip    },
    {"LDRB%s %s",ARM7DASMofip    },
    {"LDRB%s %s",ARM7DASMofip    },
    {"LDRB%s %s",ARM7DASMofip    },

    //0x5E
    {"STRB%s %s",ARM7DASMprip    },
    {"STRB%s %s",ARM7DASMprip    },
    {"STRB%s %s",ARM7DASMprip    },
    {"STRB%s %s",ARM7DASMprip    },
    {"STRB%s %s",ARM7DASMprip    },
    {"STRB%s %s",ARM7DASMprip    },
    {"STRB%s %s",ARM7DASMprip    },
    {"STRB%s %s",ARM7DASMprip    },
    {"STRB%s %s",ARM7DASMprip    },
    {"STRB%s %s",ARM7DASMprip    },
    {"STRB%s %s",ARM7DASMprip    },
    {"STRB%s %s",ARM7DASMprip    },
    {"STRB%s %s",ARM7DASMprip    },
    {"STRB%s %s",ARM7DASMprip    },
    {"STRB%s %s",ARM7DASMprip    },
    {"STRB%s %s",ARM7DASMprip    },

    //0x5F
    {"LDRB%s %s",ARM7DASMprip    },
    {"LDRB%s %s",ARM7DASMprip    },
    {"LDRB%s %s",ARM7DASMprip    },
    {"LDRB%s %s",ARM7DASMprip    },
    {"LDRB%s %s",ARM7DASMprip    },
    {"LDRB%s %s",ARM7DASMprip    },
    {"LDRB%s %s",ARM7DASMprip    },
    {"LDRB%s %s",ARM7DASMprip    },
    {"LDRB%s %s",ARM7DASMprip    },
    {"LDRB%s %s",ARM7DASMprip    },
    {"LDRB%s %s",ARM7DASMprip    },
    {"LDRB%s %s",ARM7DASMprip    },
    {"LDRB%s %s",ARM7DASMprip    },
    {"LDRB%s %s",ARM7DASMprip    },
    {"LDRB%s %s",ARM7DASMprip    },
    {"LDRB%s %s",ARM7DASMprip    },

    //0x60
    {"STR%s %s",ARM7DASMptrmll   },
    {"UND%s %s",ARM7DASMun       },
    {"STR%s %s",ARM7DASMptrmlr   },
    {"UND%s %s",ARM7DASMun       },
    {"STR%s %s",ARM7DASMptrmar   },
    {"UND%s %s",ARM7DASMun       },
    {"STR%s %s",ARM7DASMptrmrr   },
    {"UND%s %s",ARM7DASMun       },
    {"STR%s %s",ARM7DASMptrmll   },
    {"UND%s %s",ARM7DASMun       },
    {"STR%s %s",ARM7DASMptrmlr   },
    {"UND%s %s",ARM7DASMun       },
    {"STR%s %s",ARM7DASMptrmar   },
    {"UND%s %s",ARM7DASMun       },
    {"STR%s %s",ARM7DASMptrmrr   },
    {"UND%s %s",ARM7DASMun       },

    //0x61
    {"LDR%s %s",ARM7DASMptrmll   },
    {"UND%s %s",ARM7DASMun       },
    {"LDR%s %s",ARM7DASMptrmlr   },
    {"UND%s %s",ARM7DASMun       },
    {"LDR%s %s",ARM7DASMptrmar   },
    {"UND%s %s",ARM7DASMun       },
    {"LDR%s %s",ARM7DASMptrmrr   },
    {"UND%s %s",ARM7DASMun       },
    {"LDR%s %s",ARM7DASMptrmll   },
    {"UND%s %s",ARM7DASMun       },
    {"LDR%s %s",ARM7DASMptrmlr   },
    {"UND%s %s",ARM7DASMun       },
    {"LDR%s %s",ARM7DASMptrmar   },
    {"UND%s %s",ARM7DASMun       },
    {"LDR%s %s",ARM7DASMptrmrr   },
    {"UND%s %s",ARM7DASMun       },

    //0x62
    {"STRT%s %s",ARM7DASMptrmll  },
    {"UND%s %s",ARM7DASMun       },
    {"STRT%s %s",ARM7DASMptrmlr  },
    {"UND%s %s",ARM7DASMun       },
    {"STRT%s %s",ARM7DASMptrmar  },
    {"UND%s %s",ARM7DASMun       },
    {"STRT%s %s",ARM7DASMptrmrr  },
    {"UND%s %s",ARM7DASMun       },
    {"STRT%s %s",ARM7DASMptrmll  },
    {"UND%s %s",ARM7DASMun       },
    {"STRT%s %s",ARM7DASMptrmlr  },
    {"UND%s %s",ARM7DASMun       },
    {"STRT%s %s",ARM7DASMptrmar  },
    {"UND%s %s",ARM7DASMun       },
    {"STRT%s %s",ARM7DASMptrmrr  },
    {"UND%s %s",ARM7DASMun       },

    //0x63
    {"LDRT%s %s",ARM7DASMptrmll  },
    {"UND%s %s",ARM7DASMun       },
    {"LDRT%s %s",ARM7DASMptrmlr  },
    {"UND%s %s",ARM7DASMun       },
    {"LDRT%s %s",ARM7DASMptrmar  },
    {"UND%s %s",ARM7DASMun       },
    {"LDRT%s %s",ARM7DASMptrmrr  },
    {"UND%s %s",ARM7DASMun       },
    {"LDRT%s %s",ARM7DASMptrmll  },
    {"UND%s %s",ARM7DASMun       },
    {"LDRT%s %s",ARM7DASMptrmlr  },
    {"UND%s %s",ARM7DASMun       },
    {"LDRT%s %s",ARM7DASMptrmar  },
    {"UND%s %s",ARM7DASMun       },
    {"LDRT%s %s",ARM7DASMptrmrr  },
    {"UND%s %s",ARM7DASMun       },

    //0x64
    {"STRB%s %s",ARM7DASMptrmll  },
    {"UND%s %s",ARM7DASMun       },
    {"STRB%s %s",ARM7DASMptrmlr  },
    {"UND%s %s",ARM7DASMun       },
    {"STRB%s %s",ARM7DASMptrmar  },
    {"UND%s %s",ARM7DASMun       },
    {"STRB%s %s",ARM7DASMptrmrr  },
    {"UND%s %s",ARM7DASMun       },
    {"STRB%s %s",ARM7DASMptrmll  },
    {"UND%s %s",ARM7DASMun       },
    {"STRB%s %s",ARM7DASMptrmlr  },
    {"UND%s %s",ARM7DASMun       },
    {"STRB%s %s",ARM7DASMptrmar  },
    {"UND%s %s",ARM7DASMun       },
    {"STRB%s %s",ARM7DASMptrmrr  },
    {"UND%s %s",ARM7DASMun       },

    //0x65
    {"LDRB%s %s",ARM7DASMptrmll  },
    {"UND%s %s",ARM7DASMun       },
    {"LDRB%s %s",ARM7DASMptrmlr  },
    {"UND%s %s",ARM7DASMun       },
    {"LDRB%s %s",ARM7DASMptrmar  },
    {"UND%s %s",ARM7DASMun       },
    {"LDRB%s %s",ARM7DASMptrmrr  },
    {"UND%s %s",ARM7DASMun       },
    {"LDRB%s %s",ARM7DASMptrmll  },
    {"UND%s %s",ARM7DASMun       },
    {"LDRB%s %s",ARM7DASMptrmlr  },
    {"UND%s %s",ARM7DASMun       },
    {"LDRB%s %s",ARM7DASMptrmar  },
    {"UND%s %s",ARM7DASMun       },
    {"LDRB%s %s",ARM7DASMptrmrr  },
    {"UND%s %s",ARM7DASMun       },

    //0x66
    {"STRBT%s %s",ARM7DASMptrmll },
    {"UND%s %s",ARM7DASMun       },
    {"STRBT%s %s",ARM7DASMptrmlr },
    {"UND%s %s",ARM7DASMun       },
    {"STRBT%s %s",ARM7DASMptrmar },
    {"UND%s %s",ARM7DASMun       },
    {"STRBT%s %s",ARM7DASMptrmrr },
    {"UND%s %s",ARM7DASMun       },
    {"STRBT%s %s",ARM7DASMptrmll },
    {"UND%s %s",ARM7DASMun       },
    {"STRBT%s %s",ARM7DASMptrmlr },
    {"UND%s %s",ARM7DASMun       },
    {"STRBT%s %s",ARM7DASMptrmar },
    {"UND%s %s",ARM7DASMun       },
    {"STRBT%s %s",ARM7DASMptrmrr },
    {"UND%s %s",ARM7DASMun       },

    //0x67
    {"LDRBT%s %s",ARM7DASMptrmll },
    {"UND%s %s",ARM7DASMun       },
    {"LDRBT%s %s",ARM7DASMptrmlr },
    {"UND%s %s",ARM7DASMun       },
    {"LDRBT%s %s",ARM7DASMptrmar },
    {"UND%s %s",ARM7DASMun       },
    {"LDRBT%s %s",ARM7DASMptrmrr },
    {"UND%s %s",ARM7DASMun       },
    {"LDRBT%s %s",ARM7DASMptrmll },
    {"UND%s %s",ARM7DASMun       },
    {"LDRBT%s %s",ARM7DASMptrmlr },
    {"UND%s %s",ARM7DASMun       },
    {"LDRBT%s %s",ARM7DASMptrmar },
    {"UND%s %s",ARM7DASMun       },
    {"LDRBT%s %s",ARM7DASMptrmrr },
    {"UND%s %s",ARM7DASMun       },

    //0x68
    {"STR%s %s",ARM7DASMptrpll   },
    {"UND%s %s",ARM7DASMun       },
    {"STR%s %s",ARM7DASMptrplr   },
    {"UND%s %s",ARM7DASMun       },
    {"STR%s %s",ARM7DASMptrpar   },
    {"UND%s %s",ARM7DASMun       },
    {"STR%s %s",ARM7DASMptrprr   },
    {"UND%s %s",ARM7DASMun       },
    {"STR%s %s",ARM7DASMptrpll   },
    {"UND%s %s",ARM7DASMun       },
    {"STR%s %s",ARM7DASMptrplr   },
    {"UND%s %s",ARM7DASMun       },
    {"STR%s %s",ARM7DASMptrpar   },
    {"UND%s %s",ARM7DASMun       },
    {"STR%s %s",ARM7DASMptrprr   },
    {"UND%s %s",ARM7DASMun       },

    //0x69
    {"LDR%s %s",ARM7DASMptrpll   },
    {"UND%s %s",ARM7DASMun       },
    {"LDR%s %s",ARM7DASMptrplr   },
    {"UND%s %s",ARM7DASMun       },
    {"LDR%s %s",ARM7DASMptrpar   },
    {"UND%s %s",ARM7DASMun       },
    {"LDR%s %s",ARM7DASMptrprr   },
    {"UND%s %s",ARM7DASMun       },
    {"LDR%s %s",ARM7DASMptrpll   },
    {"UND%s %s",ARM7DASMun       },
    {"LDR%s %s",ARM7DASMptrplr   },
    {"UND%s %s",ARM7DASMun       },
    {"LDR%s %s",ARM7DASMptrpar   },
    {"UND%s %s",ARM7DASMun       },
    {"LDR%s %s",ARM7DASMptrprr   },
    {"UND%s %s",ARM7DASMun       },

    //0x6A
    {"STRT%s %s",ARM7DASMptrpll  },
    {"UND%s %s",ARM7DASMun       },
    {"STRT%s %s",ARM7DASMptrplr  },
    {"UND%s %s",ARM7DASMun       },
    {"STRT%s %s",ARM7DASMptrpar  },
    {"UND%s %s",ARM7DASMun       },
    {"STRT%s %s",ARM7DASMptrprr  },
    {"UND%s %s",ARM7DASMun       },
    {"STRT%s %s",ARM7DASMptrpll  },
    {"UND%s %s",ARM7DASMun       },
    {"STRT%s %s",ARM7DASMptrplr  },
    {"UND%s %s",ARM7DASMun       },
    {"STRT%s %s",ARM7DASMptrpar  },
    {"UND%s %s",ARM7DASMun       },
    {"STRT%s %s",ARM7DASMptrprr  },
    {"UND%s %s",ARM7DASMun       },

    //0x6B
    {"LDRT%s %s",ARM7DASMptrpll  },
    {"UND%s %s",ARM7DASMun       },
    {"LDRT%s %s",ARM7DASMptrplr  },
    {"UND%s %s",ARM7DASMun       },
    {"LDRT%s %s",ARM7DASMptrpar  },
    {"UND%s %s",ARM7DASMun       },
    {"LDRT%s %s",ARM7DASMptrprr  },
    {"UND%s %s",ARM7DASMun       },
    {"LDRT%s %s",ARM7DASMptrpll  },
    {"UND%s %s",ARM7DASMun       },
    {"LDRT%s %s",ARM7DASMptrplr  },
    {"UND%s %s",ARM7DASMun       },
    {"LDRT%s %s",ARM7DASMptrpar  },
    {"UND%s %s",ARM7DASMun       },
    {"LDRT%s %s",ARM7DASMptrprr  },
    {"UND%s %s",ARM7DASMun       },

    //0x6C
    {"STRB%s %s",ARM7DASMptrpll  },
    {"UND%s %s",ARM7DASMun       },
    {"STRB%s %s",ARM7DASMptrplr  },
    {"UND%s %s",ARM7DASMun       },
    {"STRB%s %s",ARM7DASMptrpar  },
    {"UND%s %s",ARM7DASMun       },
    {"STRB%s %s",ARM7DASMptrprr  },
    {"UND%s %s",ARM7DASMun       },
    {"STRB%s %s",ARM7DASMptrpll  },
    {"UND%s %s",ARM7DASMun       },
    {"STRB%s %s",ARM7DASMptrplr  },
    {"UND%s %s",ARM7DASMun       },
    {"STRB%s %s",ARM7DASMptrpar  },
    {"UND%s %s",ARM7DASMun       },
    {"STRB%s %s",ARM7DASMptrprr  },
    {"UND%s %s",ARM7DASMun       },

    //0x6D
    {"LDRB%s %s",ARM7DASMptrpll  },
    {"UND%s %s",ARM7DASMun       },
    {"LDRB%s %s",ARM7DASMptrplr  },
    {"UND%s %s",ARM7DASMun       },
    {"LDRB%s %s",ARM7DASMptrpar  },
    {"UND%s %s",ARM7DASMun       },
    {"LDRB%s %s",ARM7DASMptrprr  },
    {"UND%s %s",ARM7DASMun       },
    {"LDRB%s %s",ARM7DASMptrpll  },
    {"UND%s %s",ARM7DASMun       },
    {"LDRB%s %s",ARM7DASMptrplr  },
    {"UND%s %s",ARM7DASMun       },
    {"LDRB%s %s",ARM7DASMptrpar  },
    {"UND%s %s",ARM7DASMun       },
    {"LDRB%s %s",ARM7DASMptrprr  },
    {"UND%s %s",ARM7DASMun       },

    //0x6E
    {"STRBT%s %s",ARM7DASMptrpll },
    {"UND%s %s",ARM7DASMun       },
    {"STRBT%s %s",ARM7DASMptrplr },
    {"UND%s %s",ARM7DASMun       },
    {"STRBT%s %s",ARM7DASMptrpar },
    {"UND%s %s",ARM7DASMun       },
    {"STRBT%s %s",ARM7DASMptrprr },
    {"UND%s %s",ARM7DASMun       },
    {"STRBT%s %s",ARM7DASMptrpll },
    {"UND%s %s",ARM7DASMun       },
    {"STRBT%s %s",ARM7DASMptrplr },
    {"UND%s %s",ARM7DASMun       },
    {"STRBT%s %s",ARM7DASMptrpar },
    {"UND%s %s",ARM7DASMun       },
    {"STRBT%s %s",ARM7DASMptrprr },
    {"UND%s %s",ARM7DASMun       },

    //0x6F
    {"LDRBT%s %s",ARM7DASMptrpll },
    {"UND%s %s",ARM7DASMun       },
    {"LDRBT%s %s",ARM7DASMptrplr },
    {"UND%s %s",ARM7DASMun       },
    {"LDRBT%s %s",ARM7DASMptrpar },
    {"UND%s %s",ARM7DASMun       },
    {"LDRBT%s %s",ARM7DASMptrprr },
    {"UND%s %s",ARM7DASMun       },
    {"LDRBT%s %s",ARM7DASMptrpll },
    {"UND%s %s",ARM7DASMun       },
    {"LDRBT%s %s",ARM7DASMptrplr },
    {"UND%s %s",ARM7DASMun       },
    {"LDRBT%s %s",ARM7DASMptrpar },
    {"UND%s %s",ARM7DASMun       },
    {"LDRBT%s %s",ARM7DASMptrprr },
    {"UND%s %s",ARM7DASMun       },

    //0x70
    {"STR%s %s",ARM7DASMofrmll   },
    {"UND%s %s",ARM7DASMun       },
    {"STR%s %s",ARM7DASMofrmlr   },
    {"UND%s %s",ARM7DASMun       },
    {"STR%s %s",ARM7DASMofrmar   },
    {"UND%s %s",ARM7DASMun       },
    {"STR%s %s",ARM7DASMofrmrr   },
    {"UND%s %s",ARM7DASMun       },
    {"STR%s %s",ARM7DASMofrmll   },
    {"UND%s %s",ARM7DASMun       },
    {"STR%s %s",ARM7DASMofrmlr   },
    {"UND%s %s",ARM7DASMun       },
    {"STR%s %s",ARM7DASMofrmar   },
    {"UND%s %s",ARM7DASMun       },
    {"STR%s %s",ARM7DASMofrmrr   },
    {"UND%s %s",ARM7DASMun       },

    //0x71
    {"LDR%s %s",ARM7DASMofrmll   },
    {"UND%s %s",ARM7DASMun       },
    {"LDR%s %s",ARM7DASMofrmlr   },
    {"UND%s %s",ARM7DASMun       },
    {"LDR%s %s",ARM7DASMofrmar   },
    {"UND%s %s",ARM7DASMun       },
    {"LDR%s %s",ARM7DASMofrmrr   },
    {"UND%s %s",ARM7DASMun       },
    {"LDR%s %s",ARM7DASMofrmll   },
    {"UND%s %s",ARM7DASMun       },
    {"LDR%s %s",ARM7DASMofrmlr   },
    {"UND%s %s",ARM7DASMun       },
    {"LDR%s %s",ARM7DASMofrmar   },
    {"UND%s %s",ARM7DASMun       },
    {"LDR%s %s",ARM7DASMofrmrr   },
    {"UND%s %s",ARM7DASMun       },

    //0x72
    {"STR%s %s",ARM7DASMprrmll   },
    {"UND%s %s",ARM7DASMun       },
    {"STR%s %s",ARM7DASMprrmlr   },
    {"UND%s %s",ARM7DASMun       },
    {"STR%s %s",ARM7DASMprrmar   },
    {"UND%s %s",ARM7DASMun       },
    {"STR%s %s",ARM7DASMprrmrr   },
    {"UND%s %s",ARM7DASMun       },
    {"STR%s %s",ARM7DASMprrmll   },
    {"UND%s %s",ARM7DASMun       },
    {"STR%s %s",ARM7DASMprrmlr   },
    {"UND%s %s",ARM7DASMun       },
    {"STR%s %s",ARM7DASMprrmar   },
    {"UND%s %s",ARM7DASMun       },
    {"STR%s %s",ARM7DASMprrmrr   },
    {"UND%s %s",ARM7DASMun       },

    //0x73
    {"LDR%s %s",ARM7DASMprrmll   },
    {"UND%s %s",ARM7DASMun       },
    {"LDR%s %s",ARM7DASMprrmlr   },
    {"UND%s %s",ARM7DASMun       },
    {"LDR%s %s",ARM7DASMprrmar   },
    {"UND%s %s",ARM7DASMun       },
    {"LDR%s %s",ARM7DASMprrmrr   },
    {"UND%s %s",ARM7DASMun       },
    {"LDR%s %s",ARM7DASMprrmll   },
    {"UND%s %s",ARM7DASMun       },
    {"LDR%s %s",ARM7DASMprrmlr   },
    {"UND%s %s",ARM7DASMun       },
    {"LDR%s %s",ARM7DASMprrmar   },
    {"UND%s %s",ARM7DASMun       },
    {"LDR%s %s",ARM7DASMprrmrr   },
    {"UND%s %s",ARM7DASMun       },

    //0x74
    {"STRB%s %s",ARM7DASMofrmll  },
    {"UND%s %s",ARM7DASMun       },
    {"STRB%s %s",ARM7DASMofrmlr  },
    {"UND%s %s",ARM7DASMun       },
    {"STRB%s %s",ARM7DASMofrmar  },
    {"UND%s %s",ARM7DASMun       },
    {"STRB%s %s",ARM7DASMofrmrr  },
    {"UND%s %s",ARM7DASMun       },
    {"STRB%s %s",ARM7DASMofrmll  },
    {"UND%s %s",ARM7DASMun       },
    {"STRB%s %s",ARM7DASMofrmlr  },
    {"UND%s %s",ARM7DASMun       },
    {"STRB%s %s",ARM7DASMofrmar  },
    {"UND%s %s",ARM7DASMun       },
    {"STRB%s %s",ARM7DASMofrmrr  },
    {"UND%s %s",ARM7DASMun       },

    //0x75
    {"LDRB%s %s",ARM7DASMofrmll  },
    {"UND%s %s",ARM7DASMun       },
    {"LDRB%s %s",ARM7DASMofrmlr  },
    {"UND%s %s",ARM7DASMun       },
    {"LDRB%s %s",ARM7DASMofrmar  },
    {"UND%s %s",ARM7DASMun       },
    {"LDRB%s %s",ARM7DASMofrmrr  },
    {"UND%s %s",ARM7DASMun       },
    {"LDRB%s %s",ARM7DASMofrmll  },
    {"UND%s %s",ARM7DASMun       },
    {"LDRB%s %s",ARM7DASMofrmlr  },
    {"UND%s %s",ARM7DASMun       },
    {"LDRB%s %s",ARM7DASMofrmar  },
    {"UND%s %s",ARM7DASMun       },
    {"LDRB%s %s",ARM7DASMofrmrr  },
    {"UND%s %s",ARM7DASMun       },

    //0x76
    {"STRB%s %s",ARM7DASMprrmll  },
    {"UND%s %s",ARM7DASMun       },
    {"STRB%s %s",ARM7DASMprrmlr  },
    {"UND%s %s",ARM7DASMun       },
    {"STRB%s %s",ARM7DASMprrmar  },
    {"UND%s %s",ARM7DASMun       },
    {"STRB%s %s",ARM7DASMprrmrr  },
    {"UND%s %s",ARM7DASMun       },
    {"STRB%s %s",ARM7DASMprrmll  },
    {"UND%s %s",ARM7DASMun       },
    {"STRB%s %s",ARM7DASMprrmlr  },
    {"UND%s %s",ARM7DASMun       },
    {"STRB%s %s",ARM7DASMprrmar  },
    {"UND%s %s",ARM7DASMun       },
    {"STRB%s %s",ARM7DASMprrmrr  },
    {"UND%s %s",ARM7DASMun       },

    //0x77
    {"LDRB%s %s",ARM7DASMprrmll  },
    {"UND%s %s",ARM7DASMun       },
    {"LDRB%s %s",ARM7DASMprrmlr  },
    {"UND%s %s",ARM7DASMun       },
    {"LDRB%s %s",ARM7DASMprrmar  },
    {"UND%s %s",ARM7DASMun       },
    {"LDRB%s %s",ARM7DASMprrmrr  },
    {"UND%s %s",ARM7DASMun       },
    {"LDRB%s %s",ARM7DASMprrmll  },
    {"UND%s %s",ARM7DASMun       },
    {"LDRB%s %s",ARM7DASMprrmlr  },
    {"UND%s %s",ARM7DASMun       },
    {"LDRB%s %s",ARM7DASMprrmar  },
    {"UND%s %s",ARM7DASMun       },
    {"LDRB%s %s",ARM7DASMprrmrr  },
    {"UND%s %s",ARM7DASMun       },

    //0x78
    {"STR%s %s",ARM7DASMofrpll   },
    {"UND%s %s",ARM7DASMun       },
    {"STR%s %s",ARM7DASMofrplr   },
    {"UND%s %s",ARM7DASMun       },
    {"STR%s %s",ARM7DASMofrpar   },
    {"UND%s %s",ARM7DASMun       },
    {"STR%s %s",ARM7DASMofrprr   },
    {"UND%s %s",ARM7DASMun       },
    {"STR%s %s",ARM7DASMofrpll   },
    {"UND%s %s",ARM7DASMun       },
    {"STR%s %s",ARM7DASMofrplr   },
    {"UND%s %s",ARM7DASMun       },
    {"STR%s %s",ARM7DASMofrpar   },
    {"UND%s %s",ARM7DASMun       },
    {"STR%s %s",ARM7DASMofrprr   },
    {"UND%s %s",ARM7DASMun       },

    //0x79
    {"LDR%s %s",ARM7DASMofrpll   },
    {"UND%s %s",ARM7DASMun       },
    {"LDR%s %s",ARM7DASMofrplr   },
    {"UND%s %s",ARM7DASMun       },
    {"LDR%s %s",ARM7DASMofrpar   },
    {"UND%s %s",ARM7DASMun       },
    {"LDR%s %s",ARM7DASMofrprr   },
    {"UND%s %s",ARM7DASMun       },
    {"LDR%s %s",ARM7DASMofrpll   },
    {"UND%s %s",ARM7DASMun       },
    {"LDR%s %s",ARM7DASMofrplr   },
    {"UND%s %s",ARM7DASMun       },
    {"LDR%s %s",ARM7DASMofrpar   },
    {"UND%s %s",ARM7DASMun       },
    {"LDR%s %s",ARM7DASMofrprr   },
    {"UND%s %s",ARM7DASMun       },

    //0x7A
    {"STR%s %s",ARM7DASMprrpll   },
    {"UND%s %s",ARM7DASMun       },
    {"STR%s %s",ARM7DASMprrplr   },
    {"UND%s %s",ARM7DASMun       },
    {"STR%s %s",ARM7DASMprrpar   },
    {"UND%s %s",ARM7DASMun       },
    {"STR%s %s",ARM7DASMprrprr   },
    {"UND%s %s",ARM7DASMun       },
    {"STR%s %s",ARM7DASMprrpll   },
    {"UND%s %s",ARM7DASMun       },
    {"STR%s %s",ARM7DASMprrplr   },
    {"UND%s %s",ARM7DASMun       },
    {"STR%s %s",ARM7DASMprrpar   },
    {"UND%s %s",ARM7DASMun       },
    {"STR%s %s",ARM7DASMprrprr   },
    {"UND%s %s",ARM7DASMun       },

    //0x7B
    {"LDR%s %s",ARM7DASMprrpll   },
    {"UND%s %s",ARM7DASMun       },
    {"LDR%s %s",ARM7DASMprrplr   },
    {"UND%s %s",ARM7DASMun       },
    {"LDR%s %s",ARM7DASMprrpar   },
    {"UND%s %s",ARM7DASMun       },
    {"LDR%s %s",ARM7DASMprrprr   },
    {"UND%s %s",ARM7DASMun       },
    {"LDR%s %s",ARM7DASMprrpll   },
    {"UND%s %s",ARM7DASMun       },
    {"LDR%s %s",ARM7DASMprrplr   },
    {"UND%s %s",ARM7DASMun       },
    {"LDR%s %s",ARM7DASMprrpar   },
    {"UND%s %s",ARM7DASMun       },
    {"LDR%s %s",ARM7DASMprrprr   },
    {"UND%s %s",ARM7DASMun       },

    //0x7C
    {"STRB%s %s",ARM7DASMofrpll  },
    {"UND%s %s",ARM7DASMun       },
    {"STRB%s %s",ARM7DASMofrplr  },
    {"UND%s %s",ARM7DASMun       },
    {"STRB%s %s",ARM7DASMofrpar  },
    {"UND%s %s",ARM7DASMun       },
    {"STRB%s %s",ARM7DASMofrprr  },
    {"UND%s %s",ARM7DASMun       },
    {"STRB%s %s",ARM7DASMofrpll  },
    {"UND%s %s",ARM7DASMun       },
    {"STRB%s %s",ARM7DASMofrplr  },
    {"UND%s %s",ARM7DASMun       },
    {"STRB%s %s",ARM7DASMofrpar  },
    {"UND%s %s",ARM7DASMun       },
    {"STRB%s %s",ARM7DASMofrprr  },
    {"UND%s %s",ARM7DASMun       },

    //0x7D
    {"LDRB%s %s",ARM7DASMofrpll  },
    {"UND%s %s",ARM7DASMun       },
    {"LDRB%s %s",ARM7DASMofrplr  },
    {"UND%s %s",ARM7DASMun       },
    {"LDRB%s %s",ARM7DASMofrpar  },
    {"UND%s %s",ARM7DASMun       },
    {"LDRB%s %s",ARM7DASMofrprr  },
    {"UND%s %s",ARM7DASMun       },
    {"LDRB%s %s",ARM7DASMofrpll  },
    {"UND%s %s",ARM7DASMun       },
    {"LDRB%s %s",ARM7DASMofrplr  },
    {"UND%s %s",ARM7DASMun       },
    {"LDRB%s %s",ARM7DASMofrpar  },
    {"UND%s %s",ARM7DASMun       },
    {"LDRB%s %s",ARM7DASMofrprr  },
    {"UND%s %s",ARM7DASMun       },

    //0x7E
    {"STRB%s %s",ARM7DASMprrpll  },
    {"UND%s %s",ARM7DASMun       },
    {"STRB%s %s",ARM7DASMprrplr  },
    {"UND%s %s",ARM7DASMun       },
    {"STRB%s %s",ARM7DASMprrpar  },
    {"UND%s %s",ARM7DASMun       },
    {"STRB%s %s",ARM7DASMprrprr  },
    {"UND%s %s",ARM7DASMun       },
    {"STRB%s %s",ARM7DASMprrpll  },
    {"UND%s %s",ARM7DASMun       },
    {"STRB%s %s",ARM7DASMprrplr  },
    {"UND%s %s",ARM7DASMun       },
    {"STRB%s %s",ARM7DASMprrpar  },
    {"UND%s %s",ARM7DASMun       },
    {"STRB%s %s",ARM7DASMprrprr  },
    {"UND%s %s",ARM7DASMun       },

    //0x7F
    {"LDRB%s %s",ARM7DASMprrpll  },
    {"UND%s %s",ARM7DASMun       },
    {"LDRB%s %s",ARM7DASMprrplr  },
    {"UND%s %s",ARM7DASMun       },
    {"LDRB%s %s",ARM7DASMprrpar  },
    {"UND%s %s",ARM7DASMun       },
    {"LDRB%s %s",ARM7DASMprrprr  },
    {"UND%s %s",ARM7DASMun       },
    {"LDRB%s %s",ARM7DASMprrpll  },
    {"UND%s %s",ARM7DASMun       },
    {"LDRB%s %s",ARM7DASMprrplr  },
    {"UND%s %s",ARM7DASMun       },
    {"LDRB%s %s",ARM7DASMprrpar  },
    {"UND%s %s",ARM7DASMun       },
    {"LDRB%s %s",ARM7DASMprrprr  },
    {"UND%s %s",ARM7DASMun       },

    //0x80
    {"STMDA%s %s",ARM7DASMlm       },
    {"STMDA%s %s",ARM7DASMlm       },
    {"STMDA%s %s",ARM7DASMlm       },
    {"STMDA%s %s",ARM7DASMlm       },
    {"STMDA%s %s",ARM7DASMlm       },
    {"STMDA%s %s",ARM7DASMlm       },
    {"STMDA%s %s",ARM7DASMlm       },
    {"STMDA%s %s",ARM7DASMlm       },
    {"STMDA%s %s",ARM7DASMlm       },
    {"STMDA%s %s",ARM7DASMlm       },
    {"STMDA%s %s",ARM7DASMlm       },
    {"STMDA%s %s",ARM7DASMlm       },
    {"STMDA%s %s",ARM7DASMlm       },
    {"STMDA%s %s",ARM7DASMlm       },
    {"STMDA%s %s",ARM7DASMlm       },
    {"STMDA%s %s",ARM7DASMlm       },

    //0x81
    {"LDMDA%s %s",ARM7DASMlm       },
    {"LDMDA%s %s",ARM7DASMlm       },
    {"LDMDA%s %s",ARM7DASMlm       },
    {"LDMDA%s %s",ARM7DASMlm       },
    {"LDMDA%s %s",ARM7DASMlm       },
    {"LDMDA%s %s",ARM7DASMlm       },
    {"LDMDA%s %s",ARM7DASMlm       },
    {"LDMDA%s %s",ARM7DASMlm       },
    {"LDMDA%s %s",ARM7DASMlm       },
    {"LDMDA%s %s",ARM7DASMlm       },
    {"LDMDA%s %s",ARM7DASMlm       },
    {"LDMDA%s %s",ARM7DASMlm       },
    {"LDMDA%s %s",ARM7DASMlm       },
    {"LDMDA%s %s",ARM7DASMlm       },
    {"LDMDA%s %s",ARM7DASMlm       },
    {"LDMDA%s %s",ARM7DASMlm       },

    //0x82
    {"STMDA%s %s",ARM7DASMlm      },
    {"STMDA%s %s",ARM7DASMlm      },
    {"STMDA%s %s",ARM7DASMlm      },
    {"STMDA%s %s",ARM7DASMlm      },
    {"STMDA%s %s",ARM7DASMlm      },
    {"STMDA%s %s",ARM7DASMlm      },
    {"STMDA%s %s",ARM7DASMlm      },
    {"STMDA%s %s",ARM7DASMlm      },
    {"STMDA%s %s",ARM7DASMlm      },
    {"STMDA%s %s",ARM7DASMlm      },
    {"STMDA%s %s",ARM7DASMlm      },
    {"STMDA%s %s",ARM7DASMlm      },
    {"STMDA%s %s",ARM7DASMlm      },
    {"STMDA%s %s",ARM7DASMlm      },
    {"STMDA%s %s",ARM7DASMlm      },
    {"STMDA%s %s",ARM7DASMlm      },

    //0x83
    {"LDMDA%s %s",ARM7DASMlm      },
    {"LDMDA%s %s",ARM7DASMlm      },
    {"LDMDA%s %s",ARM7DASMlm      },
    {"LDMDA%s %s",ARM7DASMlm      },
    {"LDMDA%s %s",ARM7DASMlm      },
    {"LDMDA%s %s",ARM7DASMlm      },
    {"LDMDA%s %s",ARM7DASMlm      },
    {"LDMDA%s %s",ARM7DASMlm      },
    {"LDMDA%s %s",ARM7DASMlm      },
    {"LDMDA%s %s",ARM7DASMlm      },
    {"LDMDA%s %s",ARM7DASMlm      },
    {"LDMDA%s %s",ARM7DASMlm      },
    {"LDMDA%s %s",ARM7DASMlm      },
    {"LDMDA%s %s",ARM7DASMlm      },
    {"LDMDA%s %s",ARM7DASMlm      },
    {"LDMDA%s %s",ARM7DASMlm      },

    //0x84
    {"STMDA%s %s",ARM7DASMlm      },
    {"STMDA%s %s",ARM7DASMlm      },
    {"STMDA%s %s",ARM7DASMlm      },
    {"STMDA%s %s",ARM7DASMlm      },
    {"STMDA%s %s",ARM7DASMlm      },
    {"STMDA%s %s",ARM7DASMlm      },
    {"STMDA%s %s",ARM7DASMlm      },
    {"STMDA%s %s",ARM7DASMlm      },
    {"STMDA%s %s",ARM7DASMlm      },
    {"STMDA%s %s",ARM7DASMlm      },
    {"STMDA%s %s",ARM7DASMlm      },
    {"STMDA%s %s",ARM7DASMlm      },
    {"STMDA%s %s",ARM7DASMlm      },
    {"STMDA%s %s",ARM7DASMlm      },
    {"STMDA%s %s",ARM7DASMlm      },
    {"STMDA%s %s",ARM7DASMlm      },

    //0x85
    {"LDMDA%s %s",ARM7DASMlm      },
    {"LDMDA%s %s",ARM7DASMlm      },
    {"LDMDA%s %s",ARM7DASMlm      },
    {"LDMDA%s %s",ARM7DASMlm      },
    {"LDMDA%s %s",ARM7DASMlm      },
    {"LDMDA%s %s",ARM7DASMlm      },
    {"LDMDA%s %s",ARM7DASMlm      },
    {"LDMDA%s %s",ARM7DASMlm      },
    {"LDMDA%s %s",ARM7DASMlm      },
    {"LDMDA%s %s",ARM7DASMlm      },
    {"LDMDA%s %s",ARM7DASMlm      },
    {"LDMDA%s %s",ARM7DASMlm      },
    {"LDMDA%s %s",ARM7DASMlm      },
    {"LDMDA%s %s",ARM7DASMlm      },
    {"LDMDA%s %s",ARM7DASMlm      },
    {"LDMDA%s %s",ARM7DASMlm      },

    //0x86
    {"STMDA%s %s",ARM7DASMlm     },
    {"STMDA%s %s",ARM7DASMlm     },
    {"STMDA%s %s",ARM7DASMlm     },
    {"STMDA%s %s",ARM7DASMlm     },
    {"STMDA%s %s",ARM7DASMlm     },
    {"STMDA%s %s",ARM7DASMlm     },
    {"STMDA%s %s",ARM7DASMlm     },
    {"STMDA%s %s",ARM7DASMlm     },
    {"STMDA%s %s",ARM7DASMlm     },
    {"STMDA%s %s",ARM7DASMlm     },
    {"STMDA%s %s",ARM7DASMlm     },
    {"STMDA%s %s",ARM7DASMlm     },
    {"STMDA%s %s",ARM7DASMlm     },
    {"STMDA%s %s",ARM7DASMlm     },
    {"STMDA%s %s",ARM7DASMlm     },
    {"STMDA%s %s",ARM7DASMlm     },

    //0x87
    {"LDMDA%s %s",ARM7DASMlm     },
    {"LDMDA%s %s",ARM7DASMlm     },
    {"LDMDA%s %s",ARM7DASMlm     },
    {"LDMDA%s %s",ARM7DASMlm     },
    {"LDMDA%s %s",ARM7DASMlm     },
    {"LDMDA%s %s",ARM7DASMlm     },
    {"LDMDA%s %s",ARM7DASMlm     },
    {"LDMDA%s %s",ARM7DASMlm     },
    {"LDMDA%s %s",ARM7DASMlm     },
    {"LDMDA%s %s",ARM7DASMlm     },
    {"LDMDA%s %s",ARM7DASMlm     },
    {"LDMDA%s %s",ARM7DASMlm     },
    {"LDMDA%s %s",ARM7DASMlm     },
    {"LDMDA%s %s",ARM7DASMlm     },
    {"LDMDA%s %s",ARM7DASMlm     },
    {"LDMDA%s %s",ARM7DASMlm     },

    //0x88
    {"STMIA%s %s",ARM7DASMlm       },
    {"STMIA%s %s",ARM7DASMlm       },
    {"STMIA%s %s",ARM7DASMlm       },
    {"STMIA%s %s",ARM7DASMlm       },
    {"STMIA%s %s",ARM7DASMlm       },
    {"STMIA%s %s",ARM7DASMlm       },
    {"STMIA%s %s",ARM7DASMlm       },
    {"STMIA%s %s",ARM7DASMlm       },
    {"STMIA%s %s",ARM7DASMlm       },
    {"STMIA%s %s",ARM7DASMlm       },
    {"STMIA%s %s",ARM7DASMlm       },
    {"STMIA%s %s",ARM7DASMlm       },
    {"STMIA%s %s",ARM7DASMlm       },
    {"STMIA%s %s",ARM7DASMlm       },
    {"STMIA%s %s",ARM7DASMlm       },
    {"STMIA%s %s",ARM7DASMlm       },

    //0x89
    {"LDMIA%s %s",ARM7DASMlm       },
    {"LDMIA%s %s",ARM7DASMlm       },
    {"LDMIA%s %s",ARM7DASMlm       },
    {"LDMIA%s %s",ARM7DASMlm       },
    {"LDMIA%s %s",ARM7DASMlm       },
    {"LDMIA%s %s",ARM7DASMlm       },
    {"LDMIA%s %s",ARM7DASMlm       },
    {"LDMIA%s %s",ARM7DASMlm       },
    {"LDMIA%s %s",ARM7DASMlm       },
    {"LDMIA%s %s",ARM7DASMlm       },
    {"LDMIA%s %s",ARM7DASMlm       },
    {"LDMIA%s %s",ARM7DASMlm       },
    {"LDMIA%s %s",ARM7DASMlm       },
    {"LDMIA%s %s",ARM7DASMlm       },
    {"LDMIA%s %s",ARM7DASMlm       },
    {"LDMIA%s %s",ARM7DASMlm       },

    //0x8A
    {"STMIA%s %s",ARM7DASMlm      },
    {"STMIA%s %s",ARM7DASMlm      },
    {"STMIA%s %s",ARM7DASMlm      },
    {"STMIA%s %s",ARM7DASMlm      },
    {"STMIA%s %s",ARM7DASMlm      },
    {"STMIA%s %s",ARM7DASMlm      },
    {"STMIA%s %s",ARM7DASMlm      },
    {"STMIA%s %s",ARM7DASMlm      },
    {"STMIA%s %s",ARM7DASMlm      },
    {"STMIA%s %s",ARM7DASMlm      },
    {"STMIA%s %s",ARM7DASMlm      },
    {"STMIA%s %s",ARM7DASMlm      },
    {"STMIA%s %s",ARM7DASMlm      },
    {"STMIA%s %s",ARM7DASMlm      },
    {"STMIA%s %s",ARM7DASMlm      },
    {"STMIA%s %s",ARM7DASMlm      },

    //0x8B
    {"LDMIA%s %s",ARM7DASMlm      },
    {"LDMIA%s %s",ARM7DASMlm      },
    {"LDMIA%s %s",ARM7DASMlm      },
    {"LDMIA%s %s",ARM7DASMlm      },
    {"LDMIA%s %s",ARM7DASMlm      },
    {"LDMIA%s %s",ARM7DASMlm      },
    {"LDMIA%s %s",ARM7DASMlm      },
    {"LDMIA%s %s",ARM7DASMlm      },
    {"LDMIA%s %s",ARM7DASMlm      },
    {"LDMIA%s %s",ARM7DASMlm      },
    {"LDMIA%s %s",ARM7DASMlm      },
    {"LDMIA%s %s",ARM7DASMlm      },
    {"LDMIA%s %s",ARM7DASMlm      },
    {"LDMIA%s %s",ARM7DASMlm      },
    {"LDMIA%s %s",ARM7DASMlm      },
    {"LDMIA%s %s",ARM7DASMlm      },

    //0x8C
    {"STMIA%s %s",ARM7DASMlm      },
    {"STMIA%s %s",ARM7DASMlm      },
    {"STMIA%s %s",ARM7DASMlm      },
    {"STMIA%s %s",ARM7DASMlm      },
    {"STMIA%s %s",ARM7DASMlm      },
    {"STMIA%s %s",ARM7DASMlm      },
    {"STMIA%s %s",ARM7DASMlm      },
    {"STMIA%s %s",ARM7DASMlm      },
    {"STMIA%s %s",ARM7DASMlm      },
    {"STMIA%s %s",ARM7DASMlm      },
    {"STMIA%s %s",ARM7DASMlm      },
    {"STMIA%s %s",ARM7DASMlm      },
    {"STMIA%s %s",ARM7DASMlm      },
    {"STMIA%s %s",ARM7DASMlm      },
    {"STMIA%s %s",ARM7DASMlm      },
    {"STMIA%s %s",ARM7DASMlm      },

    //0x8D
    {"LDMIA%s %s",ARM7DASMlm      },
    {"LDMIA%s %s",ARM7DASMlm      },
    {"LDMIA%s %s",ARM7DASMlm      },
    {"LDMIA%s %s",ARM7DASMlm      },
    {"LDMIA%s %s",ARM7DASMlm      },
    {"LDMIA%s %s",ARM7DASMlm      },
    {"LDMIA%s %s",ARM7DASMlm      },
    {"LDMIA%s %s",ARM7DASMlm      },
    {"LDMIA%s %s",ARM7DASMlm      },
    {"LDMIA%s %s",ARM7DASMlm      },
    {"LDMIA%s %s",ARM7DASMlm      },
    {"LDMIA%s %s",ARM7DASMlm      },
    {"LDMIA%s %s",ARM7DASMlm      },
    {"LDMIA%s %s",ARM7DASMlm      },
    {"LDMIA%s %s",ARM7DASMlm      },
    {"LDMIA%s %s",ARM7DASMlm      },

    //0x8E
    {"STMIA%s %s",ARM7DASMlm     },
    {"STMIA%s %s",ARM7DASMlm     },
    {"STMIA%s %s",ARM7DASMlm     },
    {"STMIA%s %s",ARM7DASMlm     },
    {"STMIA%s %s",ARM7DASMlm     },
    {"STMIA%s %s",ARM7DASMlm     },
    {"STMIA%s %s",ARM7DASMlm     },
    {"STMIA%s %s",ARM7DASMlm     },
    {"STMIA%s %s",ARM7DASMlm     },
    {"STMIA%s %s",ARM7DASMlm     },
    {"STMIA%s %s",ARM7DASMlm     },
    {"STMIA%s %s",ARM7DASMlm     },
    {"STMIA%s %s",ARM7DASMlm     },
    {"STMIA%s %s",ARM7DASMlm     },
    {"STMIA%s %s",ARM7DASMlm     },
    {"STMIA%s %s",ARM7DASMlm     },

    //0x8F
    {"LDMIA%s %s",ARM7DASMlm     },
    {"LDMIA%s %s",ARM7DASMlm     },
    {"LDMIA%s %s",ARM7DASMlm     },
    {"LDMIA%s %s",ARM7DASMlm     },
    {"LDMIA%s %s",ARM7DASMlm     },
    {"LDMIA%s %s",ARM7DASMlm     },
    {"LDMIA%s %s",ARM7DASMlm     },
    {"LDMIA%s %s",ARM7DASMlm     },
    {"LDMIA%s %s",ARM7DASMlm     },
    {"LDMIA%s %s",ARM7DASMlm     },
    {"LDMIA%s %s",ARM7DASMlm     },
    {"LDMIA%s %s",ARM7DASMlm     },
    {"LDMIA%s %s",ARM7DASMlm     },
    {"LDMIA%s %s",ARM7DASMlm     },
    {"LDMIA%s %s",ARM7DASMlm     },
    {"LDMIA%s %s",ARM7DASMlm     },

    //0x90
    {"STMDB%s %s",ARM7DASMlm       },
    {"STMDB%s %s",ARM7DASMlm       },
    {"STMDB%s %s",ARM7DASMlm       },
    {"STMDB%s %s",ARM7DASMlm       },
    {"STMDB%s %s",ARM7DASMlm       },
    {"STMDB%s %s",ARM7DASMlm       },
    {"STMDB%s %s",ARM7DASMlm       },
    {"STMDB%s %s",ARM7DASMlm       },
    {"STMDB%s %s",ARM7DASMlm       },
    {"STMDB%s %s",ARM7DASMlm       },
    {"STMDB%s %s",ARM7DASMlm       },
    {"STMDB%s %s",ARM7DASMlm       },
    {"STMDB%s %s",ARM7DASMlm       },
    {"STMDB%s %s",ARM7DASMlm       },
    {"STMDB%s %s",ARM7DASMlm       },
    {"STMDB%s %s",ARM7DASMlm       },

    //0x91
    {"LDMDB%s %s",ARM7DASMlm       },
    {"LDMDB%s %s",ARM7DASMlm       },
    {"LDMDB%s %s",ARM7DASMlm       },
    {"LDMDB%s %s",ARM7DASMlm       },
    {"LDMDB%s %s",ARM7DASMlm       },
    {"LDMDB%s %s",ARM7DASMlm       },
    {"LDMDB%s %s",ARM7DASMlm       },
    {"LDMDB%s %s",ARM7DASMlm       },
    {"LDMDB%s %s",ARM7DASMlm       },
    {"LDMDB%s %s",ARM7DASMlm       },
    {"LDMDB%s %s",ARM7DASMlm       },
    {"LDMDB%s %s",ARM7DASMlm       },
    {"LDMDB%s %s",ARM7DASMlm       },
    {"LDMDB%s %s",ARM7DASMlm       },
    {"LDMDB%s %s",ARM7DASMlm       },
    {"LDMDB%s %s",ARM7DASMlm       },

    //0x92
    {"STMDB%s %s",ARM7DASMlm      },
    {"STMDB%s %s",ARM7DASMlm      },
    {"STMDB%s %s",ARM7DASMlm      },
    {"STMDB%s %s",ARM7DASMlm      },
    {"STMDB%s %s",ARM7DASMlm      },
    {"STMDB%s %s",ARM7DASMlm      },
    {"STMDB%s %s",ARM7DASMlm      },
    {"STMDB%s %s",ARM7DASMlm      },
    {"STMDB%s %s",ARM7DASMlm      },
    {"STMDB%s %s",ARM7DASMlm      },
    {"STMDB%s %s",ARM7DASMlm      },
    {"STMDB%s %s",ARM7DASMlm      },
    {"STMDB%s %s",ARM7DASMlm      },
    {"STMDB%s %s",ARM7DASMlm      },
    {"STMDB%s %s",ARM7DASMlm      },
    {"STMDB%s %s",ARM7DASMlm      },

    //0x93
    {"LDMDB%s %s",ARM7DASMlm      },
    {"LDMDB%s %s",ARM7DASMlm      },
    {"LDMDB%s %s",ARM7DASMlm      },
    {"LDMDB%s %s",ARM7DASMlm      },
    {"LDMDB%s %s",ARM7DASMlm      },
    {"LDMDB%s %s",ARM7DASMlm      },
    {"LDMDB%s %s",ARM7DASMlm      },
    {"LDMDB%s %s",ARM7DASMlm      },
    {"LDMDB%s %s",ARM7DASMlm      },
    {"LDMDB%s %s",ARM7DASMlm      },
    {"LDMDB%s %s",ARM7DASMlm      },
    {"LDMDB%s %s",ARM7DASMlm      },
    {"LDMDB%s %s",ARM7DASMlm      },
    {"LDMDB%s %s",ARM7DASMlm      },
    {"LDMDB%s %s",ARM7DASMlm      },
    {"LDMDB%s %s",ARM7DASMlm      },

    //0x94
    {"STMDB%s %s",ARM7DASMlm      },
    {"STMDB%s %s",ARM7DASMlm      },
    {"STMDB%s %s",ARM7DASMlm      },
    {"STMDB%s %s",ARM7DASMlm      },
    {"STMDB%s %s",ARM7DASMlm      },
    {"STMDB%s %s",ARM7DASMlm      },
    {"STMDB%s %s",ARM7DASMlm      },
    {"STMDB%s %s",ARM7DASMlm      },
    {"STMDB%s %s",ARM7DASMlm      },
    {"STMDB%s %s",ARM7DASMlm      },
    {"STMDB%s %s",ARM7DASMlm      },
    {"STMDB%s %s",ARM7DASMlm      },
    {"STMDB%s %s",ARM7DASMlm      },
    {"STMDB%s %s",ARM7DASMlm      },
    {"STMDB%s %s",ARM7DASMlm      },
    {"STMDB%s %s",ARM7DASMlm      },

    //0x95
    {"LDMDB%s %s",ARM7DASMlm      },
    {"LDMDB%s %s",ARM7DASMlm      },
    {"LDMDB%s %s",ARM7DASMlm      },
    {"LDMDB%s %s",ARM7DASMlm      },
    {"LDMDB%s %s",ARM7DASMlm      },
    {"LDMDB%s %s",ARM7DASMlm      },
    {"LDMDB%s %s",ARM7DASMlm      },
    {"LDMDB%s %s",ARM7DASMlm      },
    {"LDMDB%s %s",ARM7DASMlm      },
    {"LDMDB%s %s",ARM7DASMlm      },
    {"LDMDB%s %s",ARM7DASMlm      },
    {"LDMDB%s %s",ARM7DASMlm      },
    {"LDMDB%s %s",ARM7DASMlm      },
    {"LDMDB%s %s",ARM7DASMlm      },
    {"LDMDB%s %s",ARM7DASMlm      },
    {"LDMDB%s %s",ARM7DASMlm      },

    //0x96
    {"STMDB%s %s",ARM7DASMlm     },
    {"STMDB%s %s",ARM7DASMlm     },
    {"STMDB%s %s",ARM7DASMlm     },
    {"STMDB%s %s",ARM7DASMlm     },
    {"STMDB%s %s",ARM7DASMlm     },
    {"STMDB%s %s",ARM7DASMlm     },
    {"STMDB%s %s",ARM7DASMlm     },
    {"STMDB%s %s",ARM7DASMlm     },
    {"STMDB%s %s",ARM7DASMlm     },
    {"STMDB%s %s",ARM7DASMlm     },
    {"STMDB%s %s",ARM7DASMlm     },
    {"STMDB%s %s",ARM7DASMlm     },
    {"STMDB%s %s",ARM7DASMlm     },
    {"STMDB%s %s",ARM7DASMlm     },
    {"STMDB%s %s",ARM7DASMlm     },
    {"STMDB%s %s",ARM7DASMlm     },

    //0x97
    {"LDMDB%s %s",ARM7DASMlm     },
    {"LDMDB%s %s",ARM7DASMlm     },
    {"LDMDB%s %s",ARM7DASMlm     },
    {"LDMDB%s %s",ARM7DASMlm     },
    {"LDMDB%s %s",ARM7DASMlm     },
    {"LDMDB%s %s",ARM7DASMlm     },
    {"LDMDB%s %s",ARM7DASMlm     },
    {"LDMDB%s %s",ARM7DASMlm     },
    {"LDMDB%s %s",ARM7DASMlm     },
    {"LDMDB%s %s",ARM7DASMlm     },
    {"LDMDB%s %s",ARM7DASMlm     },
    {"LDMDB%s %s",ARM7DASMlm     },
    {"LDMDB%s %s",ARM7DASMlm     },
    {"LDMDB%s %s",ARM7DASMlm     },
    {"LDMDB%s %s",ARM7DASMlm     },
    {"LDMDB%s %s",ARM7DASMlm     },

    //0x98
    {"STMIB%s %s",ARM7DASMlm       },
    {"STMIB%s %s",ARM7DASMlm       },
    {"STMIB%s %s",ARM7DASMlm       },
    {"STMIB%s %s",ARM7DASMlm       },
    {"STMIB%s %s",ARM7DASMlm       },
    {"STMIB%s %s",ARM7DASMlm       },
    {"STMIB%s %s",ARM7DASMlm       },
    {"STMIB%s %s",ARM7DASMlm       },
    {"STMIB%s %s",ARM7DASMlm       },
    {"STMIB%s %s",ARM7DASMlm       },
    {"STMIB%s %s",ARM7DASMlm       },
    {"STMIB%s %s",ARM7DASMlm       },
    {"STMIB%s %s",ARM7DASMlm       },
    {"STMIB%s %s",ARM7DASMlm       },
    {"STMIB%s %s",ARM7DASMlm       },
    {"STMIB%s %s",ARM7DASMlm       },

    //0x99
    {"LDMIB%s %s",ARM7DASMlm       },
    {"LDMIB%s %s",ARM7DASMlm       },
    {"LDMIB%s %s",ARM7DASMlm       },
    {"LDMIB%s %s",ARM7DASMlm       },
    {"LDMIB%s %s",ARM7DASMlm       },
    {"LDMIB%s %s",ARM7DASMlm       },
    {"LDMIB%s %s",ARM7DASMlm       },
    {"LDMIB%s %s",ARM7DASMlm       },
    {"LDMIB%s %s",ARM7DASMlm       },
    {"LDMIB%s %s",ARM7DASMlm       },
    {"LDMIB%s %s",ARM7DASMlm       },
    {"LDMIB%s %s",ARM7DASMlm       },
    {"LDMIB%s %s",ARM7DASMlm       },
    {"LDMIB%s %s",ARM7DASMlm       },
    {"LDMIB%s %s",ARM7DASMlm       },
    {"LDMIB%s %s",ARM7DASMlm       },

    //0x9A
    {"STMIB%s %s",ARM7DASMlm      },
    {"STMIB%s %s",ARM7DASMlm      },
    {"STMIB%s %s",ARM7DASMlm      },
    {"STMIB%s %s",ARM7DASMlm      },
    {"STMIB%s %s",ARM7DASMlm      },
    {"STMIB%s %s",ARM7DASMlm      },
    {"STMIB%s %s",ARM7DASMlm      },
    {"STMIB%s %s",ARM7DASMlm      },
    {"STMIB%s %s",ARM7DASMlm      },
    {"STMIB%s %s",ARM7DASMlm      },
    {"STMIB%s %s",ARM7DASMlm      },
    {"STMIB%s %s",ARM7DASMlm      },
    {"STMIB%s %s",ARM7DASMlm      },
    {"STMIB%s %s",ARM7DASMlm      },
    {"STMIB%s %s",ARM7DASMlm      },
    {"STMIB%s %s",ARM7DASMlm      },

    //0x9B
    {"LDMIB%s %s",ARM7DASMlm      },
    {"LDMIB%s %s",ARM7DASMlm      },
    {"LDMIB%s %s",ARM7DASMlm      },
    {"LDMIB%s %s",ARM7DASMlm      },
    {"LDMIB%s %s",ARM7DASMlm      },
    {"LDMIB%s %s",ARM7DASMlm      },
    {"LDMIB%s %s",ARM7DASMlm      },
    {"LDMIB%s %s",ARM7DASMlm      },
    {"LDMIB%s %s",ARM7DASMlm      },
    {"LDMIB%s %s",ARM7DASMlm      },
    {"LDMIB%s %s",ARM7DASMlm      },
    {"LDMIB%s %s",ARM7DASMlm      },
    {"LDMIB%s %s",ARM7DASMlm      },
    {"LDMIB%s %s",ARM7DASMlm      },
    {"LDMIB%s %s",ARM7DASMlm      },
    {"LDMIB%s %s",ARM7DASMlm      },

    //0x9C
    {"STMIB%s %s",ARM7DASMlm      },
    {"STMIB%s %s",ARM7DASMlm      },
    {"STMIB%s %s",ARM7DASMlm      },
    {"STMIB%s %s",ARM7DASMlm      },
    {"STMIB%s %s",ARM7DASMlm      },
    {"STMIB%s %s",ARM7DASMlm      },
    {"STMIB%s %s",ARM7DASMlm      },
    {"STMIB%s %s",ARM7DASMlm      },
    {"STMIB%s %s",ARM7DASMlm      },
    {"STMIB%s %s",ARM7DASMlm      },
    {"STMIB%s %s",ARM7DASMlm      },
    {"STMIB%s %s",ARM7DASMlm      },
    {"STMIB%s %s",ARM7DASMlm      },
    {"STMIB%s %s",ARM7DASMlm      },
    {"STMIB%s %s",ARM7DASMlm      },
    {"STMIB%s %s",ARM7DASMlm      },

    //0x9D
    {"LDMIB%s %s",ARM7DASMlm      },
    {"LDMIB%s %s",ARM7DASMlm      },
    {"LDMIB%s %s",ARM7DASMlm      },
    {"LDMIB%s %s",ARM7DASMlm      },
    {"LDMIB%s %s",ARM7DASMlm      },
    {"LDMIB%s %s",ARM7DASMlm      },
    {"LDMIB%s %s",ARM7DASMlm      },
    {"LDMIB%s %s",ARM7DASMlm      },
    {"LDMIB%s %s",ARM7DASMlm      },
    {"LDMIB%s %s",ARM7DASMlm      },
    {"LDMIB%s %s",ARM7DASMlm      },
    {"LDMIB%s %s",ARM7DASMlm      },
    {"LDMIB%s %s",ARM7DASMlm      },
    {"LDMIB%s %s",ARM7DASMlm      },
    {"LDMIB%s %s",ARM7DASMlm      },
    {"LDMIB%s %s",ARM7DASMlm      },

    //0x9E
    {"STMIB%s %s",ARM7DASMlm     },
    {"STMIB%s %s",ARM7DASMlm     },
    {"STMIB%s %s",ARM7DASMlm     },
    {"STMIB%s %s",ARM7DASMlm     },
    {"STMIB%s %s",ARM7DASMlm     },
    {"STMIB%s %s",ARM7DASMlm     },
    {"STMIB%s %s",ARM7DASMlm     },
    {"STMIB%s %s",ARM7DASMlm     },
    {"STMIB%s %s",ARM7DASMlm     },
    {"STMIB%s %s",ARM7DASMlm     },
    {"STMIB%s %s",ARM7DASMlm     },
    {"STMIB%s %s",ARM7DASMlm     },
    {"STMIB%s %s",ARM7DASMlm     },
    {"STMIB%s %s",ARM7DASMlm     },
    {"STMIB%s %s",ARM7DASMlm     },
    {"STMIB%s %s",ARM7DASMlm     },

    //0x9F
    {"LDMIB%s %s",ARM7DASMlm     },
    {"LDMIB%s %s",ARM7DASMlm     },
    {"LDMIB%s %s",ARM7DASMlm     },
    {"LDMIB%s %s",ARM7DASMlm     },
    {"LDMIB%s %s",ARM7DASMlm     },
    {"LDMIB%s %s",ARM7DASMlm     },
    {"LDMIB%s %s",ARM7DASMlm     },
    {"LDMIB%s %s",ARM7DASMlm     },
    {"LDMIB%s %s",ARM7DASMlm     },
    {"LDMIB%s %s",ARM7DASMlm     },
    {"LDMIB%s %s",ARM7DASMlm     },
    {"LDMIB%s %s",ARM7DASMlm     },
    {"LDMIB%s %s",ARM7DASMlm     },
    {"LDMIB%s %s",ARM7DASMlm     },
    {"LDMIB%s %s",ARM7DASMlm     },
    {"LDMIB%s %s",ARM7DASMlm     },

    //0xA0
    {"B%s %s",ARM7DASMb           },
    {"B%s %s",ARM7DASMb           },
    {"B%s %s",ARM7DASMb           },
    {"B%s %s",ARM7DASMb           },
    {"B%s %s",ARM7DASMb           },
    {"B%s %s",ARM7DASMb           },
    {"B%s %s",ARM7DASMb           },
    {"B%s %s",ARM7DASMb           },
    {"B%s %s",ARM7DASMb           },
    {"B%s %s",ARM7DASMb           },
    {"B%s %s",ARM7DASMb           },
    {"B%s %s",ARM7DASMb           },
    {"B%s %s",ARM7DASMb           },
    {"B%s %s",ARM7DASMb           },
    {"B%s %s",ARM7DASMb           },
    {"B%s %s",ARM7DASMb           },

    //0xA1
    {"B%s %s",ARM7DASMb           },
    {"B%s %s",ARM7DASMb           },
    {"B%s %s",ARM7DASMb           },
    {"B%s %s",ARM7DASMb           },
    {"B%s %s",ARM7DASMb           },
    {"B%s %s",ARM7DASMb           },
    {"B%s %s",ARM7DASMb           },
    {"B%s %s",ARM7DASMb           },
    {"B%s %s",ARM7DASMb           },
    {"B%s %s",ARM7DASMb           },
    {"B%s %s",ARM7DASMb           },
    {"B%s %s",ARM7DASMb           },
    {"B%s %s",ARM7DASMb           },
    {"B%s %s",ARM7DASMb           },
    {"B%s %s",ARM7DASMb           },
    {"B%s %s",ARM7DASMb           },

    //0xA2
    {"B%s %s",ARM7DASMb           },
    {"B%s %s",ARM7DASMb           },
    {"B%s %s",ARM7DASMb           },
    {"B%s %s",ARM7DASMb           },
    {"B%s %s",ARM7DASMb           },
    {"B%s %s",ARM7DASMb           },
    {"B%s %s",ARM7DASMb           },
    {"B%s %s",ARM7DASMb           },
    {"B%s %s",ARM7DASMb           },
    {"B%s %s",ARM7DASMb           },
    {"B%s %s",ARM7DASMb           },
    {"B%s %s",ARM7DASMb           },
    {"B%s %s",ARM7DASMb           },
    {"B%s %s",ARM7DASMb           },
    {"B%s %s",ARM7DASMb           },
    {"B%s %s",ARM7DASMb           },

    //0xA3
    {"B%s %s",ARM7DASMb           },
    {"B%s %s",ARM7DASMb           },
    {"B%s %s",ARM7DASMb           },
    {"B%s %s",ARM7DASMb           },
    {"B%s %s",ARM7DASMb           },
    {"B%s %s",ARM7DASMb           },
    {"B%s %s",ARM7DASMb           },
    {"B%s %s",ARM7DASMb           },
    {"B%s %s",ARM7DASMb           },
    {"B%s %s",ARM7DASMb           },
    {"B%s %s",ARM7DASMb           },
    {"B%s %s",ARM7DASMb           },
    {"B%s %s",ARM7DASMb           },
    {"B%s %s",ARM7DASMb           },
    {"B%s %s",ARM7DASMb           },
    {"B%s %s",ARM7DASMb           },

    //0xA4
    {"B%s %s",ARM7DASMb           },
    {"B%s %s",ARM7DASMb           },
    {"B%s %s",ARM7DASMb           },
    {"B%s %s",ARM7DASMb           },
    {"B%s %s",ARM7DASMb           },
    {"B%s %s",ARM7DASMb           },
    {"B%s %s",ARM7DASMb           },
    {"B%s %s",ARM7DASMb           },
    {"B%s %s",ARM7DASMb           },
    {"B%s %s",ARM7DASMb           },
    {"B%s %s",ARM7DASMb           },
    {"B%s %s",ARM7DASMb           },
    {"B%s %s",ARM7DASMb           },
    {"B%s %s",ARM7DASMb           },
    {"B%s %s",ARM7DASMb           },
    {"B%s %s",ARM7DASMb           },

    //0xA5
    {"B%s %s",ARM7DASMb           },
    {"B%s %s",ARM7DASMb           },
    {"B%s %s",ARM7DASMb           },
    {"B%s %s",ARM7DASMb           },
    {"B%s %s",ARM7DASMb           },
    {"B%s %s",ARM7DASMb           },
    {"B%s %s",ARM7DASMb           },
    {"B%s %s",ARM7DASMb           },
    {"B%s %s",ARM7DASMb           },
    {"B%s %s",ARM7DASMb           },
    {"B%s %s",ARM7DASMb           },
    {"B%s %s",ARM7DASMb           },
    {"B%s %s",ARM7DASMb           },
    {"B%s %s",ARM7DASMb           },
    {"B%s %s",ARM7DASMb           },
    {"B%s %s",ARM7DASMb           },

    //0xA6
    {"B%s %s",ARM7DASMb           },
    {"B%s %s",ARM7DASMb           },
    {"B%s %s",ARM7DASMb           },
    {"B%s %s",ARM7DASMb           },
    {"B%s %s",ARM7DASMb           },
    {"B%s %s",ARM7DASMb           },
    {"B%s %s",ARM7DASMb           },
    {"B%s %s",ARM7DASMb           },
    {"B%s %s",ARM7DASMb           },
    {"B%s %s",ARM7DASMb           },
    {"B%s %s",ARM7DASMb           },
    {"B%s %s",ARM7DASMb           },
    {"B%s %s",ARM7DASMb           },
    {"B%s %s",ARM7DASMb           },
    {"B%s %s",ARM7DASMb           },
    {"B%s %s",ARM7DASMb           },

    //0xA7
    {"B%s %s",ARM7DASMb           },
    {"B%s %s",ARM7DASMb           },
    {"B%s %s",ARM7DASMb           },
    {"B%s %s",ARM7DASMb           },
    {"B%s %s",ARM7DASMb           },
    {"B%s %s",ARM7DASMb           },
    {"B%s %s",ARM7DASMb           },
    {"B%s %s",ARM7DASMb           },
    {"B%s %s",ARM7DASMb           },
    {"B%s %s",ARM7DASMb           },
    {"B%s %s",ARM7DASMb           },
    {"B%s %s",ARM7DASMb           },
    {"B%s %s",ARM7DASMb           },
    {"B%s %s",ARM7DASMb           },
    {"B%s %s",ARM7DASMb           },
    {"B%s %s",ARM7DASMb           },

    //0xA8
    {"B%s %s",ARM7DASMb           },
    {"B%s %s",ARM7DASMb           },
    {"B%s %s",ARM7DASMb           },
    {"B%s %s",ARM7DASMb           },
    {"B%s %s",ARM7DASMb           },
    {"B%s %s",ARM7DASMb           },
    {"B%s %s",ARM7DASMb           },
    {"B%s %s",ARM7DASMb           },
    {"B%s %s",ARM7DASMb           },
    {"B%s %s",ARM7DASMb           },
    {"B%s %s",ARM7DASMb           },
    {"B%s %s",ARM7DASMb           },
    {"B%s %s",ARM7DASMb           },
    {"B%s %s",ARM7DASMb           },
    {"B%s %s",ARM7DASMb           },
    {"B%s %s",ARM7DASMb           },

    //0xA9
    {"B%s %s",ARM7DASMb           },
    {"B%s %s",ARM7DASMb           },
    {"B%s %s",ARM7DASMb           },
    {"B%s %s",ARM7DASMb           },
    {"B%s %s",ARM7DASMb           },
    {"B%s %s",ARM7DASMb           },
    {"B%s %s",ARM7DASMb           },
    {"B%s %s",ARM7DASMb           },
    {"B%s %s",ARM7DASMb           },
    {"B%s %s",ARM7DASMb           },
    {"B%s %s",ARM7DASMb           },
    {"B%s %s",ARM7DASMb           },
    {"B%s %s",ARM7DASMb           },
    {"B%s %s",ARM7DASMb           },
    {"B%s %s",ARM7DASMb           },
    {"B%s %s",ARM7DASMb           },

    //0xAA
    {"B%s %s",ARM7DASMb           },
    {"B%s %s",ARM7DASMb           },
    {"B%s %s",ARM7DASMb           },
    {"B%s %s",ARM7DASMb           },
    {"B%s %s",ARM7DASMb           },
    {"B%s %s",ARM7DASMb           },
    {"B%s %s",ARM7DASMb           },
    {"B%s %s",ARM7DASMb           },
    {"B%s %s",ARM7DASMb           },
    {"B%s %s",ARM7DASMb           },
    {"B%s %s",ARM7DASMb           },
    {"B%s %s",ARM7DASMb           },
    {"B%s %s",ARM7DASMb           },
    {"B%s %s",ARM7DASMb           },
    {"B%s %s",ARM7DASMb           },
    {"B%s %s",ARM7DASMb           },

    //0xAB
    {"B%s %s",ARM7DASMb           },
    {"B%s %s",ARM7DASMb           },
    {"B%s %s",ARM7DASMb           },
    {"B%s %s",ARM7DASMb           },
    {"B%s %s",ARM7DASMb           },
    {"B%s %s",ARM7DASMb           },
    {"B%s %s",ARM7DASMb           },
    {"B%s %s",ARM7DASMb           },
    {"B%s %s",ARM7DASMb           },
    {"B%s %s",ARM7DASMb           },
    {"B%s %s",ARM7DASMb           },
    {"B%s %s",ARM7DASMb           },
    {"B%s %s",ARM7DASMb           },
    {"B%s %s",ARM7DASMb           },
    {"B%s %s",ARM7DASMb           },
    {"B%s %s",ARM7DASMb           },

    //0xAC
    {"B%s %s",ARM7DASMb           },
    {"B%s %s",ARM7DASMb           },
    {"B%s %s",ARM7DASMb           },
    {"B%s %s",ARM7DASMb           },
    {"B%s %s",ARM7DASMb           },
    {"B%s %s",ARM7DASMb           },
    {"B%s %s",ARM7DASMb           },
    {"B%s %s",ARM7DASMb           },
    {"B%s %s",ARM7DASMb           },
    {"B%s %s",ARM7DASMb           },
    {"B%s %s",ARM7DASMb           },
    {"B%s %s",ARM7DASMb           },
    {"B%s %s",ARM7DASMb           },
    {"B%s %s",ARM7DASMb           },
    {"B%s %s",ARM7DASMb           },
    {"B%s %s",ARM7DASMb           },

    //0xAD
    {"B%s %s",ARM7DASMb           },
    {"B%s %s",ARM7DASMb           },
    {"B%s %s",ARM7DASMb           },
    {"B%s %s",ARM7DASMb           },
    {"B%s %s",ARM7DASMb           },
    {"B%s %s",ARM7DASMb           },
    {"B%s %s",ARM7DASMb           },
    {"B%s %s",ARM7DASMb           },
    {"B%s %s",ARM7DASMb           },
    {"B%s %s",ARM7DASMb           },
    {"B%s %s",ARM7DASMb           },
    {"B%s %s",ARM7DASMb           },
    {"B%s %s",ARM7DASMb           },
    {"B%s %s",ARM7DASMb           },
    {"B%s %s",ARM7DASMb           },
    {"B%s %s",ARM7DASMb           },

    //0xAE
    {"B%s %s",ARM7DASMb           },
    {"B%s %s",ARM7DASMb           },
    {"B%s %s",ARM7DASMb           },
    {"B%s %s",ARM7DASMb           },
    {"B%s %s",ARM7DASMb           },
    {"B%s %s",ARM7DASMb           },
    {"B%s %s",ARM7DASMb           },
    {"B%s %s",ARM7DASMb           },
    {"B%s %s",ARM7DASMb           },
    {"B%s %s",ARM7DASMb           },
    {"B%s %s",ARM7DASMb           },
    {"B%s %s",ARM7DASMb           },
    {"B%s %s",ARM7DASMb           },
    {"B%s %s",ARM7DASMb           },
    {"B%s %s",ARM7DASMb           },
    {"B%s %s",ARM7DASMb           },

    //0xAF
    {"B%s %s",ARM7DASMb           },
    {"B%s %s",ARM7DASMb           },
    {"B%s %s",ARM7DASMb           },
    {"B%s %s",ARM7DASMb           },
    {"B%s %s",ARM7DASMb           },
    {"B%s %s",ARM7DASMb           },
    {"B%s %s",ARM7DASMb           },
    {"B%s %s",ARM7DASMb           },
    {"B%s %s",ARM7DASMb           },
    {"B%s %s",ARM7DASMb           },
    {"B%s %s",ARM7DASMb           },
    {"B%s %s",ARM7DASMb           },
    {"B%s %s",ARM7DASMb           },
    {"B%s %s",ARM7DASMb           },
    {"B%s %s",ARM7DASMb           },
    {"B%s %s",ARM7DASMb           },

    //0xB0
    {"BL%s %s",ARM7DASMb          },
    {"BL%s %s",ARM7DASMb          },
    {"BL%s %s",ARM7DASMb          },
    {"BL%s %s",ARM7DASMb          },
    {"BL%s %s",ARM7DASMb          },
    {"BL%s %s",ARM7DASMb          },
    {"BL%s %s",ARM7DASMb          },
    {"BL%s %s",ARM7DASMb          },
    {"BL%s %s",ARM7DASMb          },
    {"BL%s %s",ARM7DASMb          },
    {"BL%s %s",ARM7DASMb          },
    {"BL%s %s",ARM7DASMb          },
    {"BL%s %s",ARM7DASMb          },
    {"BL%s %s",ARM7DASMb          },
    {"BL%s %s",ARM7DASMb          },
    {"BL%s %s",ARM7DASMb          },

    //0xB1
    {"BL%s %s",ARM7DASMb          },
    {"BL%s %s",ARM7DASMb          },
    {"BL%s %s",ARM7DASMb          },
    {"BL%s %s",ARM7DASMb          },
    {"BL%s %s",ARM7DASMb          },
    {"BL%s %s",ARM7DASMb          },
    {"BL%s %s",ARM7DASMb          },
    {"BL%s %s",ARM7DASMb          },
    {"BL%s %s",ARM7DASMb          },
    {"BL%s %s",ARM7DASMb          },
    {"BL%s %s",ARM7DASMb          },
    {"BL%s %s",ARM7DASMb          },
    {"BL%s %s",ARM7DASMb          },
    {"BL%s %s",ARM7DASMb          },
    {"BL%s %s",ARM7DASMb          },
    {"BL%s %s",ARM7DASMb          },

    //0xB2
    {"BL%s %s",ARM7DASMb          },
    {"BL%s %s",ARM7DASMb          },
    {"BL%s %s",ARM7DASMb          },
    {"BL%s %s",ARM7DASMb          },
    {"BL%s %s",ARM7DASMb          },
    {"BL%s %s",ARM7DASMb          },
    {"BL%s %s",ARM7DASMb          },
    {"BL%s %s",ARM7DASMb          },
    {"BL%s %s",ARM7DASMb          },
    {"BL%s %s",ARM7DASMb          },
    {"BL%s %s",ARM7DASMb          },
    {"BL%s %s",ARM7DASMb          },
    {"BL%s %s",ARM7DASMb          },
    {"BL%s %s",ARM7DASMb          },
    {"BL%s %s",ARM7DASMb          },
    {"BL%s %s",ARM7DASMb          },

    //0xB3
    {"BL%s %s",ARM7DASMb          },
    {"BL%s %s",ARM7DASMb          },
    {"BL%s %s",ARM7DASMb          },
    {"BL%s %s",ARM7DASMb          },
    {"BL%s %s",ARM7DASMb          },
    {"BL%s %s",ARM7DASMb          },
    {"BL%s %s",ARM7DASMb          },
    {"BL%s %s",ARM7DASMb          },
    {"BL%s %s",ARM7DASMb          },
    {"BL%s %s",ARM7DASMb          },
    {"BL%s %s",ARM7DASMb          },
    {"BL%s %s",ARM7DASMb          },
    {"BL%s %s",ARM7DASMb          },
    {"BL%s %s",ARM7DASMb          },
    {"BL%s %s",ARM7DASMb          },
    {"BL%s %s",ARM7DASMb          },

    //0xB4
    {"BL%s %s",ARM7DASMb          },
    {"BL%s %s",ARM7DASMb          },
    {"BL%s %s",ARM7DASMb          },
    {"BL%s %s",ARM7DASMb          },
    {"BL%s %s",ARM7DASMb          },
    {"BL%s %s",ARM7DASMb          },
    {"BL%s %s",ARM7DASMb          },
    {"BL%s %s",ARM7DASMb          },
    {"BL%s %s",ARM7DASMb          },
    {"BL%s %s",ARM7DASMb          },
    {"BL%s %s",ARM7DASMb          },
    {"BL%s %s",ARM7DASMb          },
    {"BL%s %s",ARM7DASMb          },
    {"BL%s %s",ARM7DASMb          },
    {"BL%s %s",ARM7DASMb          },
    {"BL%s %s",ARM7DASMb          },

    //0xB5
    {"BL%s %s",ARM7DASMb          },
    {"BL%s %s",ARM7DASMb          },
    {"BL%s %s",ARM7DASMb          },
    {"BL%s %s",ARM7DASMb          },
    {"BL%s %s",ARM7DASMb          },
    {"BL%s %s",ARM7DASMb          },
    {"BL%s %s",ARM7DASMb          },
    {"BL%s %s",ARM7DASMb          },
    {"BL%s %s",ARM7DASMb          },
    {"BL%s %s",ARM7DASMb          },
    {"BL%s %s",ARM7DASMb          },
    {"BL%s %s",ARM7DASMb          },
    {"BL%s %s",ARM7DASMb          },
    {"BL%s %s",ARM7DASMb          },
    {"BL%s %s",ARM7DASMb          },
    {"BL%s %s",ARM7DASMb          },

    //0xB6
    {"BL%s %s",ARM7DASMb          },
    {"BL%s %s",ARM7DASMb          },
    {"BL%s %s",ARM7DASMb          },
    {"BL%s %s",ARM7DASMb          },
    {"BL%s %s",ARM7DASMb          },
    {"BL%s %s",ARM7DASMb          },
    {"BL%s %s",ARM7DASMb          },
    {"BL%s %s",ARM7DASMb          },
    {"BL%s %s",ARM7DASMb          },
    {"BL%s %s",ARM7DASMb          },
    {"BL%s %s",ARM7DASMb          },
    {"BL%s %s",ARM7DASMb          },
    {"BL%s %s",ARM7DASMb          },
    {"BL%s %s",ARM7DASMb          },
    {"BL%s %s",ARM7DASMb          },
    {"BL%s %s",ARM7DASMb          },

    //0xB7
    {"BL%s %s",ARM7DASMb          },
    {"BL%s %s",ARM7DASMb          },
    {"BL%s %s",ARM7DASMb          },
    {"BL%s %s",ARM7DASMb          },
    {"BL%s %s",ARM7DASMb          },
    {"BL%s %s",ARM7DASMb          },
    {"BL%s %s",ARM7DASMb          },
    {"BL%s %s",ARM7DASMb          },
    {"BL%s %s",ARM7DASMb          },
    {"BL%s %s",ARM7DASMb          },
    {"BL%s %s",ARM7DASMb          },
    {"BL%s %s",ARM7DASMb          },
    {"BL%s %s",ARM7DASMb          },
    {"BL%s %s",ARM7DASMb          },
    {"BL%s %s",ARM7DASMb          },
    {"BL%s %s",ARM7DASMb          },

    //0xB8
    {"BL%s %s",ARM7DASMb          },
    {"BL%s %s",ARM7DASMb          },
    {"BL%s %s",ARM7DASMb          },
    {"BL%s %s",ARM7DASMb          },
    {"BL%s %s",ARM7DASMb          },
    {"BL%s %s",ARM7DASMb          },
    {"BL%s %s",ARM7DASMb          },
    {"BL%s %s",ARM7DASMb          },
    {"BL%s %s",ARM7DASMb          },
    {"BL%s %s",ARM7DASMb          },
    {"BL%s %s",ARM7DASMb          },
    {"BL%s %s",ARM7DASMb          },
    {"BL%s %s",ARM7DASMb          },
    {"BL%s %s",ARM7DASMb          },
    {"BL%s %s",ARM7DASMb          },
    {"BL%s %s",ARM7DASMb          },

    //0xB9
    {"BL%s %s",ARM7DASMb          },
    {"BL%s %s",ARM7DASMb          },
    {"BL%s %s",ARM7DASMb          },
    {"BL%s %s",ARM7DASMb          },
    {"BL%s %s",ARM7DASMb          },
    {"BL%s %s",ARM7DASMb          },
    {"BL%s %s",ARM7DASMb          },
    {"BL%s %s",ARM7DASMb          },
    {"BL%s %s",ARM7DASMb          },
    {"BL%s %s",ARM7DASMb          },
    {"BL%s %s",ARM7DASMb          },
    {"BL%s %s",ARM7DASMb          },
    {"BL%s %s",ARM7DASMb          },
    {"BL%s %s",ARM7DASMb          },
    {"BL%s %s",ARM7DASMb          },
    {"BL%s %s",ARM7DASMb          },

    //0xBA
    {"BL%s %s",ARM7DASMb          },
    {"BL%s %s",ARM7DASMb          },
    {"BL%s %s",ARM7DASMb          },
    {"BL%s %s",ARM7DASMb          },
    {"BL%s %s",ARM7DASMb          },
    {"BL%s %s",ARM7DASMb          },
    {"BL%s %s",ARM7DASMb          },
    {"BL%s %s",ARM7DASMb          },
    {"BL%s %s",ARM7DASMb          },
    {"BL%s %s",ARM7DASMb          },
    {"BL%s %s",ARM7DASMb          },
    {"BL%s %s",ARM7DASMb          },
    {"BL%s %s",ARM7DASMb          },
    {"BL%s %s",ARM7DASMb          },
    {"BL%s %s",ARM7DASMb          },
    {"BL%s %s",ARM7DASMb          },

    //0xBB
    {"BL%s %s",ARM7DASMb          },
    {"BL%s %s",ARM7DASMb          },
    {"BL%s %s",ARM7DASMb          },
    {"BL%s %s",ARM7DASMb          },
    {"BL%s %s",ARM7DASMb          },
    {"BL%s %s",ARM7DASMb          },
    {"BL%s %s",ARM7DASMb          },
    {"BL%s %s",ARM7DASMb          },
    {"BL%s %s",ARM7DASMb          },
    {"BL%s %s",ARM7DASMb          },
    {"BL%s %s",ARM7DASMb          },
    {"BL%s %s",ARM7DASMb          },
    {"BL%s %s",ARM7DASMb          },
    {"BL%s %s",ARM7DASMb          },
    {"BL%s %s",ARM7DASMb          },
    {"BL%s %s",ARM7DASMb          },

    //0xBC
    {"BL%s %s",ARM7DASMb          },
    {"BL%s %s",ARM7DASMb          },
    {"BL%s %s",ARM7DASMb          },
    {"BL%s %s",ARM7DASMb          },
    {"BL%s %s",ARM7DASMb          },
    {"BL%s %s",ARM7DASMb          },
    {"BL%s %s",ARM7DASMb          },
    {"BL%s %s",ARM7DASMb          },
    {"BL%s %s",ARM7DASMb          },
    {"BL%s %s",ARM7DASMb          },
    {"BL%s %s",ARM7DASMb          },
    {"BL%s %s",ARM7DASMb          },
    {"BL%s %s",ARM7DASMb          },
    {"BL%s %s",ARM7DASMb          },
    {"BL%s %s",ARM7DASMb          },
    {"BL%s %s",ARM7DASMb          },

    //0xBD
    {"BL%s %s",ARM7DASMb          },
    {"BL%s %s",ARM7DASMb          },
    {"BL%s %s",ARM7DASMb          },
    {"BL%s %s",ARM7DASMb          },
    {"BL%s %s",ARM7DASMb          },
    {"BL%s %s",ARM7DASMb          },
    {"BL%s %s",ARM7DASMb          },
    {"BL%s %s",ARM7DASMb          },
    {"BL%s %s",ARM7DASMb          },
    {"BL%s %s",ARM7DASMb          },
    {"BL%s %s",ARM7DASMb          },
    {"BL%s %s",ARM7DASMb          },
    {"BL%s %s",ARM7DASMb          },
    {"BL%s %s",ARM7DASMb          },
    {"BL%s %s",ARM7DASMb          },
    {"BL%s %s",ARM7DASMb          },

    //0xBE
    {"BL%s %s",ARM7DASMb          },
    {"BL%s %s",ARM7DASMb          },
    {"BL%s %s",ARM7DASMb          },
    {"BL%s %s",ARM7DASMb          },
    {"BL%s %s",ARM7DASMb          },
    {"BL%s %s",ARM7DASMb          },
    {"BL%s %s",ARM7DASMb          },
    {"BL%s %s",ARM7DASMb          },
    {"BL%s %s",ARM7DASMb          },
    {"BL%s %s",ARM7DASMb          },
    {"BL%s %s",ARM7DASMb          },
    {"BL%s %s",ARM7DASMb          },
    {"BL%s %s",ARM7DASMb          },
    {"BL%s %s",ARM7DASMb          },
    {"BL%s %s",ARM7DASMb          },
    {"BL%s %s",ARM7DASMb          },

    //0xBF
    {"BL%s %s",ARM7DASMb          },
    {"BL%s %s",ARM7DASMb          },
    {"BL%s %s",ARM7DASMb          },
    {"BL%s %s",ARM7DASMb          },
    {"BL%s %s",ARM7DASMb          },
    {"BL%s %s",ARM7DASMb          },
    {"BL%s %s",ARM7DASMb          },
    {"BL%s %s",ARM7DASMb          },
    {"BL%s %s",ARM7DASMb          },
    {"BL%s %s",ARM7DASMb          },
    {"BL%s %s",ARM7DASMb          },
    {"BL%s %s",ARM7DASMb          },
    {"BL%s %s",ARM7DASMb          },
    {"BL%s %s",ARM7DASMb          },
    {"BL%s %s",ARM7DASMb          },
    {"BL%s %s",ARM7DASMb          },

    //0xC0 // Coprocessors undefined here!
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },

    //0xC1
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },

    //0xC2
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },

    //0xC3
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },

    //0xC4
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },

    //0xC5
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },

    //0xC6
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },

    //0xC7
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },

    //0xC8
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },

    //0xC9
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },

    //0xCA
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },

    //0xCB
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },

    //0xCC
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },

    //0xCD
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },

    //0xCE
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },

    //0xCF
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },

    //0xD0
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },

    //0xD1
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },

    //0xD2
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },

    //0xD3
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },

    //0xD4
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },

    //0xD5
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },

    //0xD6
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },

    //0xD7
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },

    //0xD8
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },

    //0xD9
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },

    //0xDA
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },

    //0xDB
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },

    //0xDC
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },

    //0xDD
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },

    //0xDE
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },

    //0xDF
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },
    {"UNI%s %s",ARM7DASMun  },

    //0xE0
    {"CDP%s %s",ARM7DASMcpd         },
    {"MCR%s %s",ARM7DASMmcr         },
    {"CDP%s %s",ARM7DASMcpd         },
    {"MCR%s %s",ARM7DASMmcr         },
    {"CDP%s %s",ARM7DASMcpd         },
    {"MCR%s %s",ARM7DASMmcr         },
    {"CDP%s %s",ARM7DASMcpd         },
    {"MCR%s %s",ARM7DASMmcr         },
    {"CDP%s %s",ARM7DASMcpd         },
    {"MCR%s %s",ARM7DASMmcr         },
    {"CDP%s %s",ARM7DASMcpd         },
    {"MCR%s %s",ARM7DASMmcr         },
    {"CDP%s %s",ARM7DASMcpd         },
    {"MCR%s %s",ARM7DASMmcr         },
    {"CDP%s %s",ARM7DASMcpd         },
    {"MCR%s %s",ARM7DASMmcr         },

    //0xE1
    {"CDP%s %s",ARM7DASMcpd         },
    {"MRC%s %s",ARM7DASMmcr         },
    {"CDP%s %s",ARM7DASMcpd         },
    {"MRC%s %s",ARM7DASMmcr         },
    {"CDP%s %s",ARM7DASMcpd         },
    {"MRC%s %s",ARM7DASMmcr         },
    {"CDP%s %s",ARM7DASMcpd         },
    {"MRC%s %s",ARM7DASMmcr         },
    {"CDP%s %s",ARM7DASMcpd         },
    {"MRC%s %s",ARM7DASMmcr         },
    {"CDP%s %s",ARM7DASMcpd         },
    {"MRC%s %s",ARM7DASMmcr         },
    {"CDP%s %s",ARM7DASMcpd         },
    {"MRC%s %s",ARM7DASMmcr         },
    {"CDP%s %s",ARM7DASMcpd         },
    {"MRC%s %s",ARM7DASMmcr         },

    //0xE2
    {"CDP%s %s",ARM7DASMcpd         },
    {"MCR%s %s",ARM7DASMmcr         },
    {"CDP%s %s",ARM7DASMcpd         },
    {"MCR%s %s",ARM7DASMmcr         },
    {"CDP%s %s",ARM7DASMcpd         },
    {"MCR%s %s",ARM7DASMmcr         },
    {"CDP%s %s",ARM7DASMcpd         },
    {"MCR%s %s",ARM7DASMmcr         },
    {"CDP%s %s",ARM7DASMcpd         },
    {"MCR%s %s",ARM7DASMmcr         },
    {"CDP%s %s",ARM7DASMcpd         },
    {"MCR%s %s",ARM7DASMmcr         },
    {"CDP%s %s",ARM7DASMcpd         },
    {"MCR%s %s",ARM7DASMmcr         },
    {"CDP%s %s",ARM7DASMcpd         },
    {"MCR%s %s",ARM7DASMmcr         },

    //0xE3
    {"CDP%s %s",ARM7DASMcpd         },
    {"MRC%s %s",ARM7DASMmcr         },
    {"CDP%s %s",ARM7DASMcpd         },
    {"MRC%s %s",ARM7DASMmcr         },
    {"CDP%s %s",ARM7DASMcpd         },
    {"MRC%s %s",ARM7DASMmcr         },
    {"CDP%s %s",ARM7DASMcpd         },
    {"MRC%s %s",ARM7DASMmcr         },
    {"CDP%s %s",ARM7DASMcpd         },
    {"MRC%s %s",ARM7DASMmcr         },
    {"CDP%s %s",ARM7DASMcpd         },
    {"MRC%s %s",ARM7DASMmcr         },
    {"CDP%s %s",ARM7DASMcpd         },
    {"MRC%s %s",ARM7DASMmcr         },
    {"CDP%s %s",ARM7DASMcpd         },
    {"MRC%s %s",ARM7DASMmcr         },

    //0xE4
    {"CDP%s %s",ARM7DASMcpd         },
    {"MCR%s %s",ARM7DASMmcr         },
    {"CDP%s %s",ARM7DASMcpd         },
    {"MCR%s %s",ARM7DASMmcr         },
    {"CDP%s %s",ARM7DASMcpd         },
    {"MCR%s %s",ARM7DASMmcr         },
    {"CDP%s %s",ARM7DASMcpd         },
    {"MCR%s %s",ARM7DASMmcr         },
    {"CDP%s %s",ARM7DASMcpd         },
    {"MCR%s %s",ARM7DASMmcr         },
    {"CDP%s %s",ARM7DASMcpd         },
    {"MCR%s %s",ARM7DASMmcr         },
    {"CDP%s %s",ARM7DASMcpd         },
    {"MCR%s %s",ARM7DASMmcr         },
    {"CDP%s %s",ARM7DASMcpd         },
    {"MCR%s %s",ARM7DASMmcr         },

    //0xE5
    {"CDP%s %s",ARM7DASMcpd         },
    {"MRC%s %s",ARM7DASMmcr         },
    {"CDP%s %s",ARM7DASMcpd         },
    {"MRC%s %s",ARM7DASMmcr         },
    {"CDP%s %s",ARM7DASMcpd         },
    {"MRC%s %s",ARM7DASMmcr         },
    {"CDP%s %s",ARM7DASMcpd         },
    {"MRC%s %s",ARM7DASMmcr         },
    {"CDP%s %s",ARM7DASMcpd         },
    {"MRC%s %s",ARM7DASMmcr         },
    {"CDP%s %s",ARM7DASMcpd         },
    {"MRC%s %s",ARM7DASMmcr         },
    {"CDP%s %s",ARM7DASMcpd         },
    {"MRC%s %s",ARM7DASMmcr         },
    {"CDP%s %s",ARM7DASMcpd         },
    {"MRC%s %s",ARM7DASMmcr         },

    //0xE6
    {"CDP%s %s",ARM7DASMcpd         },
    {"MCR%s %s",ARM7DASMmcr         },
    {"CDP%s %s",ARM7DASMcpd         },
    {"MCR%s %s",ARM7DASMmcr         },
    {"CDP%s %s",ARM7DASMcpd         },
    {"MCR%s %s",ARM7DASMmcr         },
    {"CDP%s %s",ARM7DASMcpd         },
    {"MCR%s %s",ARM7DASMmcr         },
    {"CDP%s %s",ARM7DASMcpd         },
    {"MCR%s %s",ARM7DASMmcr         },
    {"CDP%s %s",ARM7DASMcpd         },
    {"MCR%s %s",ARM7DASMmcr         },
    {"CDP%s %s",ARM7DASMcpd         },
    {"MCR%s %s",ARM7DASMmcr         },
    {"CDP%s %s",ARM7DASMcpd         },
    {"MCR%s %s",ARM7DASMmcr         },

    //0xE7
    {"CDP%s %s",ARM7DASMcpd         },
    {"MRC%s %s",ARM7DASMmcr         },
    {"CDP%s %s",ARM7DASMcpd         },
    {"MRC%s %s",ARM7DASMmcr         },
    {"CDP%s %s",ARM7DASMcpd         },
    {"MRC%s %s",ARM7DASMmcr         },
    {"CDP%s %s",ARM7DASMcpd         },
    {"MRC%s %s",ARM7DASMmcr         },
    {"CDP%s %s",ARM7DASMcpd         },
    {"MRC%s %s",ARM7DASMmcr         },
    {"CDP%s %s",ARM7DASMcpd         },
    {"MRC%s %s",ARM7DASMmcr         },
    {"CDP%s %s",ARM7DASMcpd         },
    {"MRC%s %s",ARM7DASMmcr         },
    {"CDP%s %s",ARM7DASMcpd         },
    {"MRC%s %s",ARM7DASMmcr         },

    //0xE8
    {"CDP%s %s",ARM7DASMcpd         },
    {"MCR%s %s",ARM7DASMmcr         },
    {"CDP%s %s",ARM7DASMcpd         },
    {"MCR%s %s",ARM7DASMmcr         },
    {"CDP%s %s",ARM7DASMcpd         },
    {"MCR%s %s",ARM7DASMmcr         },
    {"CDP%s %s",ARM7DASMcpd         },
    {"MCR%s %s",ARM7DASMmcr         },
    {"CDP%s %s",ARM7DASMcpd         },
    {"MCR%s %s",ARM7DASMmcr         },
    {"CDP%s %s",ARM7DASMcpd         },
    {"MCR%s %s",ARM7DASMmcr         },
    {"CDP%s %s",ARM7DASMcpd         },
    {"MCR%s %s",ARM7DASMmcr         },
    {"CDP%s %s",ARM7DASMcpd         },
    {"MCR%s %s",ARM7DASMmcr         },

    //0xE9
    {"CDP%s %s",ARM7DASMcpd         },
    {"MRC%s %s",ARM7DASMmcr         },
    {"CDP%s %s",ARM7DASMcpd         },
    {"MRC%s %s",ARM7DASMmcr         },
    {"CDP%s %s",ARM7DASMcpd         },
    {"MRC%s %s",ARM7DASMmcr         },
    {"CDP%s %s",ARM7DASMcpd         },
    {"MRC%s %s",ARM7DASMmcr         },
    {"CDP%s %s",ARM7DASMcpd         },
    {"MRC%s %s",ARM7DASMmcr         },
    {"CDP%s %s",ARM7DASMcpd         },
    {"MRC%s %s",ARM7DASMmcr         },
    {"CDP%s %s",ARM7DASMcpd         },
    {"MRC%s %s",ARM7DASMmcr         },
    {"CDP%s %s",ARM7DASMcpd         },
    {"MRC%s %s",ARM7DASMmcr         },

    //0xEA
    {"CDP%s %s",ARM7DASMcpd         },
    {"MCR%s %s",ARM7DASMmcr         },
    {"CDP%s %s",ARM7DASMcpd         },
    {"MCR%s %s",ARM7DASMmcr         },
    {"CDP%s %s",ARM7DASMcpd         },
    {"MCR%s %s",ARM7DASMmcr         },
    {"CDP%s %s",ARM7DASMcpd         },
    {"MCR%s %s",ARM7DASMmcr         },
    {"CDP%s %s",ARM7DASMcpd         },
    {"MCR%s %s",ARM7DASMmcr         },
    {"CDP%s %s",ARM7DASMcpd         },
    {"MCR%s %s",ARM7DASMmcr         },
    {"CDP%s %s",ARM7DASMcpd         },
    {"MCR%s %s",ARM7DASMmcr         },
    {"CDP%s %s",ARM7DASMcpd         },
    {"MCR%s %s",ARM7DASMmcr         },

    //0xEB
    {"CDP%s %s",ARM7DASMcpd         },
    {"MRC%s %s",ARM7DASMmcr         },
    {"CDP%s %s",ARM7DASMcpd         },
    {"MRC%s %s",ARM7DASMmcr         },
    {"CDP%s %s",ARM7DASMcpd         },
    {"MRC%s %s",ARM7DASMmcr         },
    {"CDP%s %s",ARM7DASMcpd         },
    {"MRC%s %s",ARM7DASMmcr         },
    {"CDP%s %s",ARM7DASMcpd         },
    {"MRC%s %s",ARM7DASMmcr         },
    {"CDP%s %s",ARM7DASMcpd         },
    {"MRC%s %s",ARM7DASMmcr         },
    {"CDP%s %s",ARM7DASMcpd         },
    {"MRC%s %s",ARM7DASMmcr         },
    {"CDP%s %s",ARM7DASMcpd         },
    {"MRC%s %s",ARM7DASMmcr         },

    //0xEC
    {"CDP%s %s",ARM7DASMcpd         },
    {"MCR%s %s",ARM7DASMmcr         },
    {"CDP%s %s",ARM7DASMcpd         },
    {"MCR%s %s",ARM7DASMmcr         },
    {"CDP%s %s",ARM7DASMcpd         },
    {"MCR%s %s",ARM7DASMmcr         },
    {"CDP%s %s",ARM7DASMcpd         },
    {"MCR%s %s",ARM7DASMmcr         },
    {"CDP%s %s",ARM7DASMcpd         },
    {"MCR%s %s",ARM7DASMmcr         },
    {"CDP%s %s",ARM7DASMcpd         },
    {"MCR%s %s",ARM7DASMmcr         },
    {"CDP%s %s",ARM7DASMcpd         },
    {"MCR%s %s",ARM7DASMmcr         },
    {"CDP%s %s",ARM7DASMcpd         },
    {"MCR%s %s",ARM7DASMmcr         },

    //0xED
    {"CDP%s %s",ARM7DASMcpd         },
    {"MRC%s %s",ARM7DASMmcr         },
    {"CDP%s %s",ARM7DASMcpd         },
    {"MRC%s %s",ARM7DASMmcr         },
    {"CDP%s %s",ARM7DASMcpd         },
    {"MRC%s %s",ARM7DASMmcr         },
    {"CDP%s %s",ARM7DASMcpd         },
    {"MRC%s %s",ARM7DASMmcr         },
    {"CDP%s %s",ARM7DASMcpd         },
    {"MRC%s %s",ARM7DASMmcr         },
    {"CDP%s %s",ARM7DASMcpd         },
    {"MRC%s %s",ARM7DASMmcr         },
    {"CDP%s %s",ARM7DASMcpd         },
    {"MRC%s %s",ARM7DASMmcr         },
    {"CDP%s %s",ARM7DASMcpd         },
    {"MRC%s %s",ARM7DASMmcr         },

    //0xEE
    {"CDP%s %s",ARM7DASMcpd         },
    {"MCR%s %s",ARM7DASMmcr         },
    {"CDP%s %s",ARM7DASMcpd         },
    {"MCR%s %s",ARM7DASMmcr         },
    {"CDP%s %s",ARM7DASMcpd         },
    {"MCR%s %s",ARM7DASMmcr         },
    {"CDP%s %s",ARM7DASMcpd         },
    {"MCR%s %s",ARM7DASMmcr         },
    {"CDP%s %s",ARM7DASMcpd         },
    {"MCR%s %s",ARM7DASMmcr         },
    {"CDP%s %s",ARM7DASMcpd         },
    {"MCR%s %s",ARM7DASMmcr         },
    {"CDP%s %s",ARM7DASMcpd         },
    {"MCR%s %s",ARM7DASMmcr         },
    {"CDP%s %s",ARM7DASMcpd         },
    {"MCR%s %s",ARM7DASMmcr         },

    //0xEF
    {"CDP%s %s",ARM7DASMcpd         },
    {"MRC%s %s",ARM7DASMmcr         },
    {"CDP%s %s",ARM7DASMcpd         },
    {"MRC%s %s",ARM7DASMmcr         },
    {"CDP%s %s",ARM7DASMcpd         },
    {"MRC%s %s",ARM7DASMmcr         },
    {"CDP%s %s",ARM7DASMcpd         },
    {"MRC%s %s",ARM7DASMmcr         },
    {"CDP%s %s",ARM7DASMcpd         },
    {"MRC%s %s",ARM7DASMmcr         },
    {"CDP%s %s",ARM7DASMcpd         },
    {"MRC%s %s",ARM7DASMmcr         },
    {"CDP%s %s",ARM7DASMcpd         },
    {"MRC%s %s",ARM7DASMmcr         },
    {"CDP%s %s",ARM7DASMcpd         },
    {"MRC%s %s",ARM7DASMmcr         },

    //0xF0
    {"SWI%s %s",ARM7DASMswi         },
    {"SWI%s %s",ARM7DASMswi         },
    {"SWI%s %s",ARM7DASMswi         },
    {"SWI%s %s",ARM7DASMswi         },
    {"SWI%s %s",ARM7DASMswi         },
    {"SWI%s %s",ARM7DASMswi         },
    {"SWI%s %s",ARM7DASMswi         },
    {"SWI%s %s",ARM7DASMswi         },
    {"SWI%s %s",ARM7DASMswi         },
    {"SWI%s %s",ARM7DASMswi         },
    {"SWI%s %s",ARM7DASMswi         },
    {"SWI%s %s",ARM7DASMswi         },
    {"SWI%s %s",ARM7DASMswi         },
    {"SWI%s %s",ARM7DASMswi         },
    {"SWI%s %s",ARM7DASMswi         },
    {"SWI%s %s",ARM7DASMswi         },

    //0xF1
    {"SWI%s %s",ARM7DASMswi         },
    {"SWI%s %s",ARM7DASMswi         },
    {"SWI%s %s",ARM7DASMswi         },
    {"SWI%s %s",ARM7DASMswi         },
    {"SWI%s %s",ARM7DASMswi         },
    {"SWI%s %s",ARM7DASMswi         },
    {"SWI%s %s",ARM7DASMswi         },
    {"SWI%s %s",ARM7DASMswi         },
    {"SWI%s %s",ARM7DASMswi         },
    {"SWI%s %s",ARM7DASMswi         },
    {"SWI%s %s",ARM7DASMswi         },
    {"SWI%s %s",ARM7DASMswi         },
    {"SWI%s %s",ARM7DASMswi         },
    {"SWI%s %s",ARM7DASMswi         },
    {"SWI%s %s",ARM7DASMswi         },
    {"SWI%s %s",ARM7DASMswi         },

    //0xF2
    {"SWI%s %s",ARM7DASMswi         },
    {"SWI%s %s",ARM7DASMswi         },
    {"SWI%s %s",ARM7DASMswi         },
    {"SWI%s %s",ARM7DASMswi         },
    {"SWI%s %s",ARM7DASMswi         },
    {"SWI%s %s",ARM7DASMswi         },
    {"SWI%s %s",ARM7DASMswi         },
    {"SWI%s %s",ARM7DASMswi         },
    {"SWI%s %s",ARM7DASMswi         },
    {"SWI%s %s",ARM7DASMswi         },
    {"SWI%s %s",ARM7DASMswi         },
    {"SWI%s %s",ARM7DASMswi         },
    {"SWI%s %s",ARM7DASMswi         },
    {"SWI%s %s",ARM7DASMswi         },
    {"SWI%s %s",ARM7DASMswi         },
    {"SWI%s %s",ARM7DASMswi         },

    //0xF3
    {"SWI%s %s",ARM7DASMswi         },
    {"SWI%s %s",ARM7DASMswi         },
    {"SWI%s %s",ARM7DASMswi         },
    {"SWI%s %s",ARM7DASMswi         },
    {"SWI%s %s",ARM7DASMswi         },
    {"SWI%s %s",ARM7DASMswi         },
    {"SWI%s %s",ARM7DASMswi         },
    {"SWI%s %s",ARM7DASMswi         },
    {"SWI%s %s",ARM7DASMswi         },
    {"SWI%s %s",ARM7DASMswi         },
    {"SWI%s %s",ARM7DASMswi         },
    {"SWI%s %s",ARM7DASMswi         },
    {"SWI%s %s",ARM7DASMswi         },
    {"SWI%s %s",ARM7DASMswi         },
    {"SWI%s %s",ARM7DASMswi         },
    {"SWI%s %s",ARM7DASMswi         },

    //0xF4
    {"SWI%s %s",ARM7DASMswi         },
    {"SWI%s %s",ARM7DASMswi         },
    {"SWI%s %s",ARM7DASMswi         },
    {"SWI%s %s",ARM7DASMswi         },
    {"SWI%s %s",ARM7DASMswi         },
    {"SWI%s %s",ARM7DASMswi         },
    {"SWI%s %s",ARM7DASMswi         },
    {"SWI%s %s",ARM7DASMswi         },
    {"SWI%s %s",ARM7DASMswi         },
    {"SWI%s %s",ARM7DASMswi         },
    {"SWI%s %s",ARM7DASMswi         },
    {"SWI%s %s",ARM7DASMswi         },
    {"SWI%s %s",ARM7DASMswi         },
    {"SWI%s %s",ARM7DASMswi         },
    {"SWI%s %s",ARM7DASMswi         },
    {"SWI%s %s",ARM7DASMswi         },

    //0xF5
    {"SWI%s %s",ARM7DASMswi         },
    {"SWI%s %s",ARM7DASMswi         },
    {"SWI%s %s",ARM7DASMswi         },
    {"SWI%s %s",ARM7DASMswi         },
    {"SWI%s %s",ARM7DASMswi         },
    {"SWI%s %s",ARM7DASMswi         },
    {"SWI%s %s",ARM7DASMswi         },
    {"SWI%s %s",ARM7DASMswi         },
    {"SWI%s %s",ARM7DASMswi         },
    {"SWI%s %s",ARM7DASMswi         },
    {"SWI%s %s",ARM7DASMswi         },
    {"SWI%s %s",ARM7DASMswi         },
    {"SWI%s %s",ARM7DASMswi         },
    {"SWI%s %s",ARM7DASMswi         },
    {"SWI%s %s",ARM7DASMswi         },
    {"SWI%s %s",ARM7DASMswi         },

    //0xF6
    {"SWI%s %s",ARM7DASMswi         },
    {"SWI%s %s",ARM7DASMswi         },
    {"SWI%s %s",ARM7DASMswi         },
    {"SWI%s %s",ARM7DASMswi         },
    {"SWI%s %s",ARM7DASMswi         },
    {"SWI%s %s",ARM7DASMswi         },
    {"SWI%s %s",ARM7DASMswi         },
    {"SWI%s %s",ARM7DASMswi         },
    {"SWI%s %s",ARM7DASMswi         },
    {"SWI%s %s",ARM7DASMswi         },
    {"SWI%s %s",ARM7DASMswi         },
    {"SWI%s %s",ARM7DASMswi         },
    {"SWI%s %s",ARM7DASMswi         },
    {"SWI%s %s",ARM7DASMswi         },
    {"SWI%s %s",ARM7DASMswi         },
    {"SWI%s %s",ARM7DASMswi         },

    //0xF7
    {"SWI%s %s",ARM7DASMswi         },
    {"SWI%s %s",ARM7DASMswi         },
    {"SWI%s %s",ARM7DASMswi         },
    {"SWI%s %s",ARM7DASMswi         },
    {"SWI%s %s",ARM7DASMswi         },
    {"SWI%s %s",ARM7DASMswi         },
    {"SWI%s %s",ARM7DASMswi         },
    {"SWI%s %s",ARM7DASMswi         },
    {"SWI%s %s",ARM7DASMswi         },
    {"SWI%s %s",ARM7DASMswi         },
    {"SWI%s %s",ARM7DASMswi         },
    {"SWI%s %s",ARM7DASMswi         },
    {"SWI%s %s",ARM7DASMswi         },
    {"SWI%s %s",ARM7DASMswi         },
    {"SWI%s %s",ARM7DASMswi         },
    {"SWI%s %s",ARM7DASMswi         },

    //0xF8
    {"SWI%s %s",ARM7DASMswi         },
    {"SWI%s %s",ARM7DASMswi         },
    {"SWI%s %s",ARM7DASMswi         },
    {"SWI%s %s",ARM7DASMswi         },
    {"SWI%s %s",ARM7DASMswi         },
    {"SWI%s %s",ARM7DASMswi         },
    {"SWI%s %s",ARM7DASMswi         },
    {"SWI%s %s",ARM7DASMswi         },
    {"SWI%s %s",ARM7DASMswi         },
    {"SWI%s %s",ARM7DASMswi         },
    {"SWI%s %s",ARM7DASMswi         },
    {"SWI%s %s",ARM7DASMswi         },
    {"SWI%s %s",ARM7DASMswi         },
    {"SWI%s %s",ARM7DASMswi         },
    {"SWI%s %s",ARM7DASMswi         },
    {"SWI%s %s",ARM7DASMswi         },

    //0xF9
    {"SWI%s %s",ARM7DASMswi         },
    {"SWI%s %s",ARM7DASMswi         },
    {"SWI%s %s",ARM7DASMswi         },
    {"SWI%s %s",ARM7DASMswi         },
    {"SWI%s %s",ARM7DASMswi         },
    {"SWI%s %s",ARM7DASMswi         },
    {"SWI%s %s",ARM7DASMswi         },
    {"SWI%s %s",ARM7DASMswi         },
    {"SWI%s %s",ARM7DASMswi         },
    {"SWI%s %s",ARM7DASMswi         },
    {"SWI%s %s",ARM7DASMswi         },
    {"SWI%s %s",ARM7DASMswi         },
    {"SWI%s %s",ARM7DASMswi         },
    {"SWI%s %s",ARM7DASMswi         },
    {"SWI%s %s",ARM7DASMswi         },
    {"SWI%s %s",ARM7DASMswi         },

    //0xFA
    {"SWI%s %s",ARM7DASMswi         },
    {"SWI%s %s",ARM7DASMswi         },
    {"SWI%s %s",ARM7DASMswi         },
    {"SWI%s %s",ARM7DASMswi         },
    {"SWI%s %s",ARM7DASMswi         },
    {"SWI%s %s",ARM7DASMswi         },
    {"SWI%s %s",ARM7DASMswi         },
    {"SWI%s %s",ARM7DASMswi         },
    {"SWI%s %s",ARM7DASMswi         },
    {"SWI%s %s",ARM7DASMswi         },
    {"SWI%s %s",ARM7DASMswi         },
    {"SWI%s %s",ARM7DASMswi         },
    {"SWI%s %s",ARM7DASMswi         },
    {"SWI%s %s",ARM7DASMswi         },
    {"SWI%s %s",ARM7DASMswi         },
    {"SWI%s %s",ARM7DASMswi         },

    //0xFB
    {"SWI%s %s",ARM7DASMswi         },
    {"SWI%s %s",ARM7DASMswi         },
    {"SWI%s %s",ARM7DASMswi         },
    {"SWI%s %s",ARM7DASMswi         },
    {"SWI%s %s",ARM7DASMswi         },
    {"SWI%s %s",ARM7DASMswi         },
    {"SWI%s %s",ARM7DASMswi         },
    {"SWI%s %s",ARM7DASMswi         },
    {"SWI%s %s",ARM7DASMswi         },
    {"SWI%s %s",ARM7DASMswi         },
    {"SWI%s %s",ARM7DASMswi         },
    {"SWI%s %s",ARM7DASMswi         },
    {"SWI%s %s",ARM7DASMswi         },
    {"SWI%s %s",ARM7DASMswi         },
    {"SWI%s %s",ARM7DASMswi         },
    {"SWI%s %s",ARM7DASMswi         },

    //0xFC
    {"SWI%s %s",ARM7DASMswi         },
    {"SWI%s %s",ARM7DASMswi         },
    {"SWI%s %s",ARM7DASMswi         },
    {"SWI%s %s",ARM7DASMswi         },
    {"SWI%s %s",ARM7DASMswi         },
    {"SWI%s %s",ARM7DASMswi         },
    {"SWI%s %s",ARM7DASMswi         },
    {"SWI%s %s",ARM7DASMswi         },
    {"SWI%s %s",ARM7DASMswi         },
    {"SWI%s %s",ARM7DASMswi         },
    {"SWI%s %s",ARM7DASMswi         },
    {"SWI%s %s",ARM7DASMswi         },
    {"SWI%s %s",ARM7DASMswi         },
    {"SWI%s %s",ARM7DASMswi         },
    {"SWI%s %s",ARM7DASMswi         },
    {"SWI%s %s",ARM7DASMswi         },

    //0xFD
    {"SWI%s %s",ARM7DASMswi         },
    {"SWI%s %s",ARM7DASMswi         },
    {"SWI%s %s",ARM7DASMswi         },
    {"SWI%s %s",ARM7DASMswi         },
    {"SWI%s %s",ARM7DASMswi         },
    {"SWI%s %s",ARM7DASMswi         },
    {"SWI%s %s",ARM7DASMswi         },
    {"SWI%s %s",ARM7DASMswi         },
    {"SWI%s %s",ARM7DASMswi         },
    {"SWI%s %s",ARM7DASMswi         },
    {"SWI%s %s",ARM7DASMswi         },
    {"SWI%s %s",ARM7DASMswi         },
    {"SWI%s %s",ARM7DASMswi         },
    {"SWI%s %s",ARM7DASMswi         },
    {"SWI%s %s",ARM7DASMswi         },
    {"SWI%s %s",ARM7DASMswi         },

    //0xFE
    {"SWI%s %s",ARM7DASMswi         },
    {"SWI%s %s",ARM7DASMswi         },
    {"SWI%s %s",ARM7DASMswi         },
    {"SWI%s %s",ARM7DASMswi         },
    {"SWI%s %s",ARM7DASMswi         },
    {"SWI%s %s",ARM7DASMswi         },
    {"SWI%s %s",ARM7DASMswi         },
    {"SWI%s %s",ARM7DASMswi         },
    {"SWI%s %s",ARM7DASMswi         },
    {"SWI%s %s",ARM7DASMswi         },
    {"SWI%s %s",ARM7DASMswi         },
    {"SWI%s %s",ARM7DASMswi         },
    {"SWI%s %s",ARM7DASMswi         },
    {"SWI%s %s",ARM7DASMswi         },
    {"SWI%s %s",ARM7DASMswi         },
    {"SWI%s %s",ARM7DASMswi         },

    //0xFF
    {"SWI%s %s",ARM7DASMswi         },
    {"SWI%s %s",ARM7DASMswi         },
    {"SWI%s %s",ARM7DASMswi         },
    {"SWI%s %s",ARM7DASMswi         },
    {"SWI%s %s",ARM7DASMswi         },
    {"SWI%s %s",ARM7DASMswi         },
    {"SWI%s %s",ARM7DASMswi         },
    {"SWI%s %s",ARM7DASMswi         },
    {"SWI%s %s",ARM7DASMswi         },
    {"SWI%s %s",ARM7DASMswi         },
    {"SWI%s %s",ARM7DASMswi         },
    {"SWI%s %s",ARM7DASMswi         },
    {"SWI%s %s",ARM7DASMswi         },
    {"SWI%s %s",ARM7DASMswi         },
    {"SWI%s %s",ARM7DASMswi         },
    {"SWI%s %s",ARM7DASMswi         },

};

const ARM7DASMOPDESC thumb7dasmops[]={

    //0x00
    {"LSL %s",   Thumb7DASMimm5shft},
    {"LSL %s",   Thumb7DASMimm5shft},
    {"LSL %s",   Thumb7DASMimm5shft},
    {"LSL %s",   Thumb7DASMimm5shft},
    {"LSL %s",   Thumb7DASMimm5shft},
    {"LSL %s",   Thumb7DASMimm5shft},
    {"LSL %s",   Thumb7DASMimm5shft},
    {"LSL %s",   Thumb7DASMimm5shft},
    {"LSR %s",   Thumb7DASMimm5shft},
    {"LSR %s",   Thumb7DASMimm5shft},
    {"LSR %s",   Thumb7DASMimm5shft},
    {"LSR %s",   Thumb7DASMimm5shft},
    {"LSR %s",   Thumb7DASMimm5shft},
    {"LSR %s",   Thumb7DASMimm5shft},
    {"LSR %s",   Thumb7DASMimm5shft},
    {"LSR %s",   Thumb7DASMimm5shft},

    //0x10
    {"ASR %s",   Thumb7DASMimm5shft},
    {"ASR %s",   Thumb7DASMimm5shft},
    {"ASR %s",   Thumb7DASMimm5shft},
    {"ASR %s",   Thumb7DASMimm5shft},
    {"ASR %s",   Thumb7DASMimm5shft},
    {"ASR %s",   Thumb7DASMimm5shft},
    {"ASR %s",   Thumb7DASMimm5shft},
    {"ASR %s",   Thumb7DASMimm5shft},
    {"ADD %s",   Thumb7DASMreg     },
    {"ADD %s",   Thumb7DASMreg     },
    {"SUB %s",   Thumb7DASMreg     },
    {"SUB %s",   Thumb7DASMreg     },
    {"ADD %s",   Thumb7DASMimm3    },
    {"ADD %s",   Thumb7DASMimm3    },
    {"SUB %s",   Thumb7DASMimm3    },
    {"SUB %s",   Thumb7DASMimm3    },

    //0x20
    {"MOV r0, %s",Thumb7DASMimm8    },
    {"MOV r1, %s",Thumb7DASMimm8    },
    {"MOV r2, %s",Thumb7DASMimm8    },
    {"MOV r3, %s",Thumb7DASMimm8    },
    {"MOV r4, %s",Thumb7DASMimm8    },
    {"MOV r5, %s",Thumb7DASMimm8    },
    {"MOV r6, %s",Thumb7DASMimm8    },
    {"MOV r7, %s",Thumb7DASMimm8    },
    {"CMP r0, %s",Thumb7DASMimm8    },
    {"CMP r1, %s",Thumb7DASMimm8    },
    {"CMP r2, %s",Thumb7DASMimm8    },
    {"CMP r3, %s",Thumb7DASMimm8    },
    {"CMP r4, %s",Thumb7DASMimm8    },
    {"CMP r5, %s",Thumb7DASMimm8    },
    {"CMP r6, %s",Thumb7DASMimm8    },
    {"CMP r7, %s",Thumb7DASMimm8    },

    //0x30
    {"ADD r0, %s",Thumb7DASMimm8    },
    {"ADD r1, %s",Thumb7DASMimm8    },
    {"ADD r2, %s",Thumb7DASMimm8    },
    {"ADD r3, %s",Thumb7DASMimm8    },
    {"ADD r4, %s",Thumb7DASMimm8    },
    {"ADD r5, %s",Thumb7DASMimm8    },
    {"ADD r6, %s",Thumb7DASMimm8    },
    {"ADD r7, %s",Thumb7DASMimm8    },
    {"SUB r0, %s",Thumb7DASMimm8    },
    {"SUB r1, %s",Thumb7DASMimm8    },
    {"SUB r2, %s",Thumb7DASMimm8    },
    {"SUB r3, %s",Thumb7DASMimm8    },
    {"SUB r4, %s",Thumb7DASMimm8    },
    {"SUB r5, %s",Thumb7DASMimm8    },
    {"SUB r6, %s",Thumb7DASMimm8    },
    {"SUB r7, %s",Thumb7DASMimm8    },

    //0x40
    {"%s",       Thumb7DASMdp1     },
    {"%s",       Thumb7DASMdp2     },
    {"%s",       Thumb7DASMdp3     },
    {"%s",       Thumb7DASMdp4     },
    {"ADD %s",   Thumb7DASMh       },
    {"CMP %s",   Thumb7DASMh       },
    {"MOV %s",   Thumb7DASMh       },
    {"%s",       Thumb7DASMbx      },
    {"LDR r0, %s",Thumb7DASMpc      },
    {"LDR r1, %s",Thumb7DASMpc      },
    {"LDR r2, %s",Thumb7DASMpc      },
    {"LDR r3, %s",Thumb7DASMpc      },
    {"LDR r4, %s",Thumb7DASMpc      },
    {"LDR r5, %s",Thumb7DASMpc      },
    {"LDR r6, %s",Thumb7DASMpc      },
    {"LDR r7, %s",Thumb7DASMpc      },

    //0x50
    {"STR %s",   Thumb7DASMreg     },
    {"STR %s",   Thumb7DASMreg     },
    {"STRH %s",  Thumb7DASMreg     },
    {"STRH %s",  Thumb7DASMreg     },
    {"STRB %s",  Thumb7DASMreg     },
    {"STRB %s",  Thumb7DASMreg     },
    {"LDRSB %s", Thumb7DASMreg     },
    {"LDRSB %s", Thumb7DASMreg     },
    {"LDR %s",   Thumb7DASMreg     },
    {"LDR %s",   Thumb7DASMreg     },
    {"LDRH %s",  Thumb7DASMreg     },
    {"LDRH %s",  Thumb7DASMreg     },
    {"LDRB %s",  Thumb7DASMreg     },
    {"LDRB %s",  Thumb7DASMreg     },
    {"LDRSH %s", Thumb7DASMreg     },
    {"LDRSH %s", Thumb7DASMreg     },

    //0x60
    {"STR %s*4]",Thumb7DASMimm5    },
    {"STR %s*4]",Thumb7DASMimm5    },
    {"STR %s*4]",Thumb7DASMimm5    },
    {"STR %s*4]",Thumb7DASMimm5    },
    {"STR %s*4]",Thumb7DASMimm5    },
    {"STR %s*4]",Thumb7DASMimm5    },
    {"STR %s*4]",Thumb7DASMimm5    },
    {"STR %s*4]",Thumb7DASMimm5    },
    {"LDR %s*4]",Thumb7DASMimm5    },
    {"LDR %s*4]",Thumb7DASMimm5    },
    {"LDR %s*4]",Thumb7DASMimm5    },
    {"LDR %s*4]",Thumb7DASMimm5    },
    {"LDR %s*4]",Thumb7DASMimm5    },
    {"LDR %s*4]",Thumb7DASMimm5    },
    {"LDR %s*4]",Thumb7DASMimm5    },
    {"LDR %s*4]",Thumb7DASMimm5    },

    //0x70
    {"STRB %s]", Thumb7DASMimm5    },
    {"STRB %s]", Thumb7DASMimm5    },
    {"STRB %s]", Thumb7DASMimm5    },
    {"STRB %s]", Thumb7DASMimm5    },
    {"STRB %s]", Thumb7DASMimm5    },
    {"STRB %s]", Thumb7DASMimm5    },
    {"STRB %s]", Thumb7DASMimm5    },
    {"STRB %s]", Thumb7DASMimm5    },
    {"LDRB %s]", Thumb7DASMimm5    },
    {"LDRB %s]", Thumb7DASMimm5    },
    {"LDRB %s]", Thumb7DASMimm5    },
    {"LDRB %s]", Thumb7DASMimm5    },
    {"LDRB %s]", Thumb7DASMimm5    },
    {"LDRB %s]", Thumb7DASMimm5    },
    {"LDRB %s]", Thumb7DASMimm5    },
    {"LDRB %s]", Thumb7DASMimm5    },

    //0x80
    {"STRH %s*2]",Thumb7DASMimm5   },
    {"STRH %s*2]",Thumb7DASMimm5   },
    {"STRH %s*2]",Thumb7DASMimm5   },
    {"STRH %s*2]",Thumb7DASMimm5   },
    {"STRH %s*2]",Thumb7DASMimm5   },
    {"STRH %s*2]",Thumb7DASMimm5   },
    {"STRH %s*2]",Thumb7DASMimm5   },
    {"STRH %s*2]",Thumb7DASMimm5   },
    {"LDRH %s*2]",Thumb7DASMimm5   },
    {"LDRH %s*2]",Thumb7DASMimm5   },
    {"LDRH %s*2]",Thumb7DASMimm5   },
    {"LDRH %s*2]",Thumb7DASMimm5   },
    {"LDRH %s*2]",Thumb7DASMimm5   },
    {"LDRH %s*2]",Thumb7DASMimm5   },
    {"LDRH %s*2]",Thumb7DASMimm5   },
    {"LDRH %s*2]",Thumb7DASMimm5   },

    //0x90
    {"STR r0, %s",Thumb7DASMsp      },
    {"STR r1, %s",Thumb7DASMsp      },
    {"STR r2, %s",Thumb7DASMsp      },
    {"STR r3, %s",Thumb7DASMsp      },
    {"STR r4, %s",Thumb7DASMsp      },
    {"STR r5, %s",Thumb7DASMsp      },
    {"STR r6, %s",Thumb7DASMsp      },
    {"STR r7, %s",Thumb7DASMsp      },
    {"LDR r0, %s",Thumb7DASMsp      },
    {"LDR r1, %s",Thumb7DASMsp      },
    {"LDR r2, %s",Thumb7DASMsp      },
    {"LDR r3, %s",Thumb7DASMsp      },
    {"LDR r4, %s",Thumb7DASMsp      },
    {"LDR r5, %s",Thumb7DASMsp      },
    {"LDR r6, %s",Thumb7DASMsp      },
    {"LDR r7, %s",Thumb7DASMsp      },

    //0xA0
    {"ADD r0, %s",Thumb7DASMpc      },
    {"ADD r1, %s",Thumb7DASMpc      },
    {"ADD r2, %s",Thumb7DASMpc      },
    {"ADD r3, %s",Thumb7DASMpc      },
    {"ADD r4, %s",Thumb7DASMpc      },
    {"ADD r5, %s",Thumb7DASMpc      },
    {"ADD r6, %s",Thumb7DASMpc      },
    {"ADD r7, %s",Thumb7DASMpc      },
    {"ADD r0, %s",Thumb7DASMsp      },
    {"ADD r1, %s",Thumb7DASMsp      },
    {"ADD r2, %s",Thumb7DASMsp      },
    {"ADD r3, %s",Thumb7DASMsp      },
    {"ADD r4, %s",Thumb7DASMsp      },
    {"ADD r5, %s",Thumb7DASMsp      },
    {"ADD r6, %s",Thumb7DASMsp      },
    {"ADD r7, %s",Thumb7DASMsp      },

    //0xB0
    {"%s",       Thumb7DASMimm7    },
    {"UND %s",   Thumb7DASMund     },  // Misc map: unallocated
    {"UND %s",   Thumb7DASMund     },  // Misc map: unallocated
    {"UND %s",   Thumb7DASMund     },  // Misc map: unallocated
    {"PUSH %s",  Thumb7DASMldm     },
    {"PUSH %s, LR",Thumb7DASMldm    },
    {"UND %s",   Thumb7DASMund     },  // Misc map: unallocated
    {"UND %s",   Thumb7DASMund     },  // Misc map: unallocated
    {"UND %s",   Thumb7DASMund     },  // Misc map: unallocated
    {"UND %s",   Thumb7DASMund     },  // Misc map: unallocated
    {"UND %s",   Thumb7DASMund     },  // Misc map: unallocated
    {"UND %s",   Thumb7DASMund     },  // Misc map: unallocated
    {"POP %s",   Thumb7DASMldm     },
    {"POP %s, PC",Thumb7DASMldm     },
    {"BKPT %s",  Thumb7DASMbkpt    },
    {"UND %s",   Thumb7DASMund     },  // Misc map: unallocated

    //0xC0
    {"STMIA r0!, %s", Thumb7DASMldm },
    {"STMIA r1!, %s", Thumb7DASMldm },
    {"STMIA r2!, %s", Thumb7DASMldm },
    {"STMIA r3!, %s", Thumb7DASMldm },
    {"STMIA r4!, %s", Thumb7DASMldm },
    {"STMIA r5!, %s", Thumb7DASMldm },
    {"STMIA r6!, %s", Thumb7DASMldm },
    {"STMIA r7!, %s", Thumb7DASMldm },
    {"LDMIA r0!, %s", Thumb7DASMldm },
    {"LDMIA r1!, %s", Thumb7DASMldm },
    {"LDMIA r2!, %s", Thumb7DASMldm },
    {"LDMIA r3!, %s", Thumb7DASMldm },
    {"LDMIA r4!, %s", Thumb7DASMldm },
    {"LDMIA r5!, %s", Thumb7DASMldm },
    {"LDMIA r6!, %s", Thumb7DASMldm },
    {"LDMIA r7!, %s", Thumb7DASMldm },

    //0xD0
    {"BEQ %s",   Thumb7DASMbc      },
    {"BNE %s",   Thumb7DASMbc      },
    {"BCS %s",   Thumb7DASMbc      },
    {"BCC %s",   Thumb7DASMbc      },
    {"BMI %s",   Thumb7DASMbc      },
    {"BPL %s",   Thumb7DASMbc      },
    {"BVS %s",   Thumb7DASMbc      },
    {"BVC %s",   Thumb7DASMbc      },
    {"BHI %s",   Thumb7DASMbc      },
    {"BLS %s",   Thumb7DASMbc      },
    {"BGE %s",   Thumb7DASMbc      },
    {"BLT %s",   Thumb7DASMbc      },
    {"BGT %s",   Thumb7DASMbc      },
    {"BLE %s",   Thumb7DASMbc      },
    {"UND %s",   Thumb7DASMund     },  // Covered by unconditional
    {"SWI %s",   Thumb7DASMswi     },

    //0xE0
    {"B %s",     Thumb7DASMb       },
    {"B %s",     Thumb7DASMb       },
    {"B %s",     Thumb7DASMb       },
    {"B %s",     Thumb7DASMb       },
    {"B %s",     Thumb7DASMb       },
    {"B %s",     Thumb7DASMb       },
    {"B %s",     Thumb7DASMb       },
    {"B %s",     Thumb7DASMb       },
    {"UND %s",   Thumb7DASMund     },  // Defined in ARM5!
    {"UND %s",   Thumb7DASMund     },  // Defined in ARM5!
    {"UND %s",   Thumb7DASMund     },  // Defined in ARM5!
    {"UND %s",   Thumb7DASMund     },  // Defined in ARM5!
    {"UND %s",   Thumb7DASMund     },  // Defined in ARM5!
    {"UND %s",   Thumb7DASMund     },  // Defined in ARM5!
    {"UND %s",   Thumb7DASMund     },  // Defined in ARM5!
    {"UND %s",   Thumb7DASMund     },  // Defined in ARM5!

    //0xF0
    {"BL %s*2048",Thumb7DASMbl     },
    {"BL %s*2048",Thumb7DASMbl     },
    {"BL %s*2048",Thumb7DASMbl     },
    {"BL %s*2048",Thumb7DASMbl     },
    {"BL %s*2048",Thumb7DASMbl     },
    {"BL %s*2048",Thumb7DASMbl     },
    {"BL %s*2048",Thumb7DASMbl     },
    {"BL %s*2048",Thumb7DASMbl     },
    {"BL +%s",   Thumb7DASMbl      },
    {"BL +%s",   Thumb7DASMbl      },
    {"BL +%s",   Thumb7DASMbl      },
    {"BL +%s",   Thumb7DASMbl      },
    {"BL +%s",   Thumb7DASMbl      },
    {"BL +%s",   Thumb7DASMbl      },
    {"BL +%s",   Thumb7DASMbl      },
    {"BL +%s",   Thumb7DASMbl      },
};

#endif//__ARM7DASM_H_

/*** EOF:arm7dasm.h ******************************************************/

