/**************************************************************************
* DSemu: ARM7 per-instruction disassembler (arm7dasm.c)                   *
* Released under the terms of the BSD Public Licence                      *
* Imran Nazar (tf@oopsilon.com), 2004                                     *
**************************************************************************/

#include <stdio.h>
#include "arm7dasm.h"
#include <string.h>
//#include "vtbl.h"

char *ARM7DASM(u32 op)
{
    static char str[100];
    u16 idx=((op&0x0FF00000)>>16)+((op&0x000000F0)>>4);
    arm7dasmops[idx].addr(op);
    arm7dasmstr[32]=0;
    sprintf(str,arm7dasmops[idx].op,
        ARM7DASMcond[((op&0xF0000000)>>28)],arm7dasmstr);
    return str;
}

char *Thumb7DASM(u32 op)
{
    static char str[100];
    u8 idx=((op&0xFF00)>>8);
    thumb7dasmops[idx].addr(op);
    arm7dasmstr[32]=0;
    sprintf(str,thumb7dasmops[idx].op,arm7dasmstr);
    return str;
}

void ARM7DASMun(u32 op)
{
    sprintf(arm7dasmstr,"");
}

//---Branching-------------------------------------------------------------

void ARM7DASMb(u32 op)
{
    signed int b = (op&0x00800000)?(0xFF000000|(op&0x00FFFFFF))
                                  :(op&0x00FFFFFF);
    sprintf(arm7dasmstr,"$%08X",arm7reg.tmp1+8+(b*4));
}

void ARM7DASMbreg(u32 op)
{
    sprintf(arm7dasmstr,"r%d",ARM7DASM_RM);
}

//---Data Processing addressing modes, opcodes-----------------------------

void ARM7DASMreg(u32 op)
{
    sprintf(arm7dasmstr,"r%d, r%d, r%d", ARM7DASM_RD, ARM7DASM_RN, ARM7DASM_RM);
}

void ARM7DASMimm(u32 op)
{
    arm7dasmtmp3 = op&255;
    arm7dasmtmp4 = (op&0x00000F00)>>7;
    arm7dasmtmp1 = (arm7dasmtmp3>>arm7dasmtmp4)|((arm7dasmtmp3&((1<<arm7dasmtmp4)-1))<<(32-arm7dasmtmp4));
    sprintf(arm7dasmstr,"r%d, r%d, #$%08X", ARM7DASM_RD, ARM7DASM_RN, arm7dasmtmp1);
}

void ARM7DASMlli(u32 op)
{
    arm7dasmtmp4=(op&0x00000F80)>>7;
    (arm7dasmtmp4)?
       sprintf(arm7dasmstr,"r%d, r%d, r%d, LSL #%d", ARM7DASM_RD, ARM7DASM_RN, ARM7DASM_RM, arm7dasmtmp4):
       sprintf(arm7dasmstr,"r%d, r%d, r%d", ARM7DASM_RD, ARM7DASM_RN, ARM7DASM_RM);
}

void ARM7DASMllr(u32 op)
{
    sprintf(arm7dasmstr,"r%d, r%d, r%d, LSL r%d", ARM7DASM_RD, ARM7DASM_RN, ARM7DASM_RM, ARM7DASM_RS);
}

void ARM7DASMlri(u32 op)
{
    arm7dasmtmp4=(op&0x00000F80)>>7;
    sprintf(arm7dasmstr,"r%d, r%d, r%d, LSR #%d", ARM7DASM_RD, ARM7DASM_RN, ARM7DASM_RM, arm7dasmtmp4);
}

void ARM7DASMlrr(u32 op)
{
    sprintf(arm7dasmstr,"r%d, r%d, r%d, LSR r%d", ARM7DASM_RD, ARM7DASM_RN, ARM7DASM_RM, ARM7DASM_RS);
}

void ARM7DASMari(u32 op) 
{
    arm7dasmtmp4=(op&0x00000F80)>>7; 
    sprintf(arm7dasmstr,"r%d, r%d, r%d, ASR #%d", ARM7DASM_RD, ARM7DASM_RN, ARM7DASM_RM, arm7dasmtmp4);
}

void ARM7DASMarr(u32 op)
{
    sprintf(arm7dasmstr,"r%d, r%d, r%d, ASR r%d", ARM7DASM_RD, ARM7DASM_RN, ARM7DASM_RM, ARM7DASM_RS);
}

void ARM7DASMrri(u32 op) 
{
    arm7dasmtmp4=(op&0x00000F80)>>7;
    if(arm7dasmtmp4)
        sprintf(arm7dasmstr,"r%d, r%d, r%d, ROR #%d", ARM7DASM_RD, ARM7DASM_RN, ARM7DASM_RM, arm7dasmtmp4);
    else
        sprintf(arm7dasmstr,"r%d, r%d, r%d, RRX", ARM7DASM_RD, ARM7DASM_RN, ARM7DASM_RM);
}

void ARM7DASMrrr(u32 op) 
{
    sprintf(arm7dasmstr,"r%d, r%d, r%d, ROR r%d", ARM7DASM_RD, ARM7DASM_RN, ARM7DASM_RM, ARM7DASM_RS);
}

//---Load/Store addressing modes, opcodes----------------------------------

void ARM7DASMofim(u32 op) 
{
    sprintf(arm7dasmstr,"r%d, [r%d, #-$%03X]", ARM7DASM_RD, ARM7DASM_RN, op&0x00000FFF);
}

void ARM7DASMofip(u32 op)
{
    sprintf(arm7dasmstr,"r%d, [r%d, #+$%03X]", ARM7DASM_RD, ARM7DASM_RN, op&0x00000FFF);
}

void ARM7DASMofrm(u32 op) 
{
    sprintf(arm7dasmstr,"r%d, [r%d, -r%d]", ARM7DASM_RD, ARM7DASM_RN, ARM7DASM_RM);
}

void ARM7DASMofrmll(u32 op)
{
    arm7dasmtmp4=(op&0x00000F80)>>7; 
    sprintf(arm7dasmstr,"r%d, [r%d, -r%d, LSL #%d]", ARM7DASM_RD, ARM7DASM_RN, ARM7DASM_RM, arm7dasmtmp4);
}

void ARM7DASMofrmlr(u32 op) 
{
    arm7dasmtmp4=(op&0x00000F80)>>7;
    sprintf(arm7dasmstr,"r%d, [r%d, -r%d, LSR #%d]", ARM7DASM_RD, ARM7DASM_RN, ARM7DASM_RM, arm7dasmtmp4);
}

void ARM7DASMofrmar(u32 op)
{
    arm7dasmtmp4=(op&0x00000F80)>>7; 
    sprintf(arm7dasmstr,"r%d, [r%d, -r%d, ASR #%d]", ARM7DASM_RD, ARM7DASM_RN, ARM7DASM_RM, arm7dasmtmp4);
}

void ARM7DASMofrmrr(u32 op) 
{
    arm7dasmtmp4=(op&0x00000F80)>>7;
    if(arm7dasmtmp4)
        sprintf(arm7dasmstr,"r%d, [r%d, -r%d, ROR #%d]", ARM7DASM_RD, ARM7DASM_RN, ARM7DASM_RM, arm7dasmtmp4);
    else
        sprintf(arm7dasmstr,"r%d, [r%d, -r%d, RRX]", ARM7DASM_RD, ARM7DASM_RN, ARM7DASM_RM);
}

void ARM7DASMofrp(u32 op) 
{
    sprintf(arm7dasmstr,"r%d, [r%d, +r%d]", ARM7DASM_RD, ARM7DASM_RN, ARM7DASM_RM);
}    

void ARM7DASMofrpll(u32 op) 
{
    arm7dasmtmp4=(op&0x00000F80)>>7;
    sprintf(arm7dasmstr,"r%d, [r%d, +r%d, LSL #%d]", ARM7DASM_RD, ARM7DASM_RN, ARM7DASM_RM, arm7dasmtmp4);
}

void ARM7DASMofrplr(u32 op) 
{
    arm7dasmtmp4=(op&0x00000F80)>>7; 
    sprintf(arm7dasmstr,"r%d, [r%d, +r%d, LSR #%d]", ARM7DASM_RD, ARM7DASM_RN, ARM7DASM_RM, arm7dasmtmp4);
}

void ARM7DASMofrpar(u32 op)
{
    arm7dasmtmp4=(op&0x00000F80)>>7; 
    sprintf(arm7dasmstr,"r%d, [r%d, +r%d, ASR #%d]", ARM7DASM_RD, ARM7DASM_RN, ARM7DASM_RM, arm7dasmtmp4);
}

void ARM7DASMofrprr(u32 op) 
{
    arm7dasmtmp4=(op&0x00000F80)>>7;
    if(arm7dasmtmp4)
        sprintf(arm7dasmstr,"r%d, [r%d, +r%d, ROR #%d]", ARM7DASM_RD, ARM7DASM_RN, ARM7DASM_RM, arm7dasmtmp4);
    else
        sprintf(arm7dasmstr,"r%d, [r%d, +r%d, RRX]", ARM7DASM_RD, ARM7DASM_RN, ARM7DASM_RM);
}

void ARM7DASMprim(u32 op) 
{
    sprintf(arm7dasmstr,"r%d, [r%d, #-$%03X]!", ARM7DASM_RD, ARM7DASM_RN, op&0x00000FFF);
}

void ARM7DASMprip(u32 op) 
{
    sprintf(arm7dasmstr,"r%d, [r%d, #+$%03X]!", ARM7DASM_RD, ARM7DASM_RN, op&0x00000FFF);
}

void ARM7DASMprrm(u32 op)
{
    sprintf(arm7dasmstr,"r%d, [r%d, -r%d]!", ARM7DASM_RD, ARM7DASM_RN, ARM7DASM_RM);
}

void ARM7DASMprrmll(u32 op)
{
    arm7dasmtmp4=(op&0x00000F80)>>7; 
    sprintf(arm7dasmstr,"r%d, [r%d, -r%d, LSL #%d]!", ARM7DASM_RD, ARM7DASM_RN, ARM7DASM_RM, arm7dasmtmp4);
}

void ARM7DASMprrmlr(u32 op) 
{
    arm7dasmtmp4=(op&0x00000F80)>>7; 
    sprintf(arm7dasmstr,"r%d, [r%d, -r%d, LSR #%d]!", ARM7DASM_RD, ARM7DASM_RN, ARM7DASM_RM, arm7dasmtmp4);
}

void ARM7DASMprrmar(u32 op)
{
    arm7dasmtmp4=(op&0x00000F80)>>7;
    sprintf(arm7dasmstr,"r%d, [r%d, -r%d, ASR #%d]!", ARM7DASM_RD, ARM7DASM_RN, ARM7DASM_RM, arm7dasmtmp4);
}

void ARM7DASMprrmrr(u32 op) 
{
    arm7dasmtmp4=(op&0x00000F80)>>7;
    if(arm7dasmtmp4)
        sprintf(arm7dasmstr,"r%d, [r%d, -r%d, ROR #%d]!", ARM7DASM_RD, ARM7DASM_RN, ARM7DASM_RM, arm7dasmtmp4);
    else
        sprintf(arm7dasmstr,"r%d, [r%d, -r%d, RRX]!", ARM7DASM_RD, ARM7DASM_RN, ARM7DASM_RM);
}

void ARM7DASMprrp(u32 op)
{
    sprintf(arm7dasmstr,"r%d, [r%d, +r%d]!", ARM7DASM_RD, ARM7DASM_RN, ARM7DASM_RM);
}

void ARM7DASMprrpll(u32 op)
{
    arm7dasmtmp4=(op&0x00000F80)>>7; 
    sprintf(arm7dasmstr,"r%d, [r%d, +r%d, LSL #%d]!", ARM7DASM_RD, ARM7DASM_RN, ARM7DASM_RM, arm7dasmtmp4);
}

void ARM7DASMprrplr(u32 op)
{
    arm7dasmtmp4=(op&0x00000F80)>>7; 
    sprintf(arm7dasmstr,"r%d, [r%d, +r%d, LSR #%d]!", ARM7DASM_RD, ARM7DASM_RN, ARM7DASM_RM, arm7dasmtmp4);
}

void ARM7DASMprrpar(u32 op)
{
    arm7dasmtmp4=(op&0x00000F80)>>7;
    sprintf(arm7dasmstr,"r%d, [r%d, +r%d, ASR #%d]!", ARM7DASM_RD, ARM7DASM_RN, ARM7DASM_RM, arm7dasmtmp4);
}

void ARM7DASMprrprr(u32 op)
{
    arm7dasmtmp4=(op&0x00000F80)>>7;
    if(arm7dasmtmp4)
        sprintf(arm7dasmstr,"r%d, [r%d, +r%d, ROR #%d]!", ARM7DASM_RD, ARM7DASM_RN, ARM7DASM_RM, arm7dasmtmp4);
    else
        sprintf(arm7dasmstr,"r%d, [r%d, +r%d, RRX]!", ARM7DASM_RD, ARM7DASM_RN, ARM7DASM_RM);
}

void ARM7DASMptim(u32 op)
{
    sprintf(arm7dasmstr,"r%d, [r%d], #-$%03X", ARM7DASM_RD, ARM7DASM_RN, op&0x00000FFF);
}

void ARM7DASMptip(u32 op) 
{
    sprintf(arm7dasmstr,"r%d, [r%d], #+$%03X", ARM7DASM_RD, ARM7DASM_RN, op&0x00000FFF);
}

void ARM7DASMptrm(u32 op) 
{
    sprintf(arm7dasmstr,"r%d, [r%d], -r%d", ARM7DASM_RD, ARM7DASM_RN, ARM7DASM_RM);
}

void ARM7DASMptrmll(u32 op)
{
    arm7dasmtmp4=(op&0x00000F80)>>7; 
    sprintf(arm7dasmstr,"r%d, [r%d], -r%d, LSL #%d", ARM7DASM_RD, ARM7DASM_RN, ARM7DASM_RM, arm7dasmtmp4);
}

void ARM7DASMptrmlr(u32 op) 
{
    arm7dasmtmp4=(op&0x00000F80)>>7;
    sprintf(arm7dasmstr,"r%d, [r%d], -r%d, LSR #%d", ARM7DASM_RD, ARM7DASM_RN, ARM7DASM_RM, arm7dasmtmp4);
}

void ARM7DASMptrmar(u32 op)
{
    arm7dasmtmp4=(op&0x00000F80)>>7; 
    sprintf(arm7dasmstr,"r%d, [r%d], -r%d, ASR #%d", ARM7DASM_RD, ARM7DASM_RN, ARM7DASM_RM, arm7dasmtmp4);
}

void ARM7DASMptrmrr(u32 op)
{
    arm7dasmtmp4=(op&0x00000F80)>>7; 
    if(arm7dasmtmp4)
        sprintf(arm7dasmstr,"r%d, [r%d], -r%d, ROR #%d", ARM7DASM_RD, ARM7DASM_RN, ARM7DASM_RM, arm7dasmtmp4);
    else
        sprintf(arm7dasmstr,"r%d, [r%d], -r%d, RRX", ARM7DASM_RD, ARM7DASM_RN, ARM7DASM_RM);
}

void ARM7DASMptrp(u32 op)
{
    sprintf(arm7dasmstr,"r%d, [r%d], +r%d", ARM7DASM_RD, ARM7DASM_RN, ARM7DASM_RM);
}

void ARM7DASMptrpll(u32 op)
{
    arm7dasmtmp4=(op&0x00000F80)>>7;
    sprintf(arm7dasmstr,"r%d, [r%d], +r%d, LSL #%d", ARM7DASM_RD, ARM7DASM_RN, ARM7DASM_RM, arm7dasmtmp4);
}

void ARM7DASMptrplr(u32 op) 
{
    arm7dasmtmp4=(op&0x00000F80)>>7; 
    sprintf(arm7dasmstr,"r%d, [r%d], +r%d, LSR #%d", ARM7DASM_RD, ARM7DASM_RN, ARM7DASM_RM, arm7dasmtmp4);
}

void ARM7DASMptrpar(u32 op)
{
    arm7dasmtmp4=(op&0x00000F80)>>7; 
    sprintf(arm7dasmstr,"r%d, [r%d], +r%d, ASR #%d", ARM7DASM_RD, ARM7DASM_RN, ARM7DASM_RM, arm7dasmtmp4);
}

void ARM7DASMptrprr(u32 op)
{
    arm7dasmtmp4=(op&0x00000F80)>>7; 
    if(arm7dasmtmp4)
        sprintf(arm7dasmstr,"r%d, [r%d], +r%d, ROR #%d", ARM7DASM_RD, ARM7DASM_RN, ARM7DASM_RM, arm7dasmtmp4);
    else
        sprintf(arm7dasmstr,"r%d, [r%d], +r%d, RRX", ARM7DASM_RD, ARM7DASM_RN, ARM7DASM_RM);
}

void ARM7DASMlmofim(u32 op)
{
    sprintf(arm7dasmstr,"r%d, [r%d, #-$%1X%1X]", ARM7DASM_RD, ARM7DASM_RN, ARM7DASM_RS, ARM7DASM_RM);
}

void ARM7DASMlmofip(u32 op)
{
    sprintf(arm7dasmstr,"r%d, [r%d, #+$%1X%1X]", ARM7DASM_RD, ARM7DASM_RN, ARM7DASM_RS, ARM7DASM_RM);
}

void ARM7DASMlmprim(u32 op)
{
    sprintf(arm7dasmstr,"r%d, [r%d, #-$%1X%1X]!", ARM7DASM_RD, ARM7DASM_RN, ARM7DASM_RS, ARM7DASM_RM);
}

void ARM7DASMlmprip(u32 op)
{
    sprintf(arm7dasmstr,"r%d, [r%d, #+$%1X%1X]!", ARM7DASM_RD, ARM7DASM_RN, ARM7DASM_RS, ARM7DASM_RM);
}

void ARM7DASMlmptim(u32 op)
{
    sprintf(arm7dasmstr,"r%d, [r%d], #-$%1X%1X", ARM7DASM_RD, ARM7DASM_RN, ARM7DASM_RS, ARM7DASM_RM);
}

void ARM7DASMlmptip(u32 op)
{
    sprintf(arm7dasmstr,"r%d, [r%d], #+$%1X%1X", ARM7DASM_RD, ARM7DASM_RN, ARM7DASM_RS, ARM7DASM_RM);
}

//-------------------------------------------------------------------------

//-------------------------------------------------------------------------

// Credit: Costis
void ARM7DASMlm(u32 op)
{
    int i, b_start, b_end, inWord=op;
    char str[520],regstr[512];
    sprintf(str,"r%d",ARM7DASM_RN);
    if(op&0x00200000) sprintf(str,"%s!",str);
    sprintf(regstr,",{");
    b_start = b_end = -1;
    for (i = 0; i < 16; i++)
    {
        if ((inWord & 1) && (b_start < 0)) b_start = i;
	else if (!(inWord & 1))
	{
	    b_end = i - 1;
	    if (b_start >= 0)
	    {
 	        if(strlen(regstr)==2)
 	        {
		    if(b_start!=b_end) sprintf(regstr, "%sr%d-r%d", regstr, b_start, b_end);
		    else sprintf(regstr, "%sr%d", regstr, b_start);
		} else {
		    if(b_start!=b_end) sprintf(regstr, "%s,r%d-r%d", regstr, b_start, b_end);
		    else sprintf(regstr, "%s,r%d", regstr, b_start);
		}
	    }
  	    b_start = -1;
	}
	inWord >>= 1;
    }
    sprintf(str,"%s%s}",str,regstr);
    if(op&0x00400000) sprintf(str,"%s^",str);
    sprintf(arm7dasmstr,"%s",str);
}

//-------------------------------------------------------------------------

void ARM7DASMmrsrs(u32 op)
{
    sprintf(arm7dasmstr,"r%d, cpsr",ARM7DASM_RD);
}

void ARM7DASMmrsrc(u32 op)
{
    sprintf(arm7dasmstr,"r%d, spsr",ARM7DASM_RD);
}

void ARM7DASMmsric(u32 op)
{
    arm7dasmtmp3 = op&255; 
    arm7dasmtmp4 = (op&0x00000F00)>>7; 
    arm7dasmtmp1 = (arm7dasmtmp3>>arm7dasmtmp4)|((arm7dasmtmp3&((1<<arm7dasmtmp4)-1))<<(32-arm7dasmtmp4)); 
    sprintf(arm7dasmstr,"cpsr_%c%c%c%c, #%08X",
        ((op&0x00010000)?'c':'_'), ((op&0x00020000)?'x':'_'),
        ((op&0x00040000)?'s':'_'), ((op&0x00080000)?'f':'_'), arm7dasmtmp1);
	
}

void ARM7DASMmsris(u32 op)
{
    arm7dasmtmp3 = op&255; 
    arm7dasmtmp4 = (op&0x00000F00)>>7;
    arm7dasmtmp1 = (arm7dasmtmp3>>arm7dasmtmp4)|((arm7dasmtmp3&((1<<arm7dasmtmp4)-1))<<(32-arm7dasmtmp4));
    sprintf(arm7dasmstr,"spsr_%c%c%c%c, #%08X",
        ((op&0x00010000)?'c':'_'), ((op&0x00020000)?'x':'_'),
        ((op&0x00040000)?'s':'_'), ((op&0x00080000)?'f':'_'), arm7dasmtmp1);
}

void ARM7DASMmsrrc(u32 op)
{
    sprintf(arm7dasmstr,"cpsr_%c%c%c%c, r%d",
        ((op&0x00010000)?'c':'_'), ((op&0x00020000)?'x':'_'),
        ((op&0x00040000)?'s':'_'), ((op&0x00080000)?'f':'_'), ARM7DASM_RM);
}

void ARM7DASMmsrrs(u32 op)
{
    sprintf(arm7dasmstr,"spsr_%c%c%c%c, r%d",
        ((op&0x00010000)?'c':'_'), ((op&0x00020000)?'x':'_'),
        ((op&0x00040000)?'s':'_'), ((op&0x00080000)?'f':'_'), ARM7DASM_RM);
}

//-------------------------------------------------------------------------

void ARM7DASMswp(u32 op)
{
    sprintf(arm7dasmstr,"r%d, r%d, [r%d]",ARM7DASM_RD,ARM7DASM_RM,ARM7DASM_RN);
}

void ARM7DASMswi(u32 op)
{
    sprintf(arm7dasmstr,"$%06X",op&0x00FFFFFF);
}

//-------------------------------------------------------------------------

void ARM7DASMmul(u32 op)
{
    sprintf(arm7dasmstr,"r%d, r%d, r%d",ARM7DASM_RN,ARM7DASM_RM,ARM7DASM_RS);
}

void ARM7DASMmla(u32 op)
{
    sprintf(arm7dasmstr,"r%d, r%d, r%d, r%d",ARM7DASM_RN,ARM7DASM_RM,ARM7DASM_RS,ARM7DASM_RD);
}

void ARM7DASMmull(u32 op)
{
}

//-------------------------------------------------------------------------

void ARM7DASMmcr(u32 op)
{
    sprintf(arm7dasmstr,"p%1X, %1X, r%d, c%d, c%d, %1X",ARM7DASM_RS,ARM7DASM_RO>>1,ARM7DASM_RD,ARM7DASM_RN,ARM7DASM_RM,ARM7DASM_RP>>1);
}

void ARM7DASMcpd(u32 op)
{
    sprintf(arm7dasmstr,"p%1X, %1X, c%d, c%d, c%d, %1X",ARM7DASM_RS,ARM7DASM_RO>>1,ARM7DASM_RD,ARM7DASM_RN,ARM7DASM_RM,ARM7DASM_RP>>1);
}

//-------------------------------------------------------------------------

void Thumb7DASMimm5(u32 op)
{
    sprintf(arm7dasmstr,"r%d, [r%d, #$%02X",TMB7DASM_RD,TMB7DASM_RN,TMB7DASM_IMM5);
}

void Thumb7DASMimm5shft(u32 op)
{
    sprintf(arm7dasmstr,"r%d, r%d, #$%02X",TMB7DASM_RD,TMB7DASM_RN,TMB7DASM_IMM5);
}

void Thumb7DASMimm7(u32 op)
{
    if(op&0x0080) sprintf(arm7dasmstr,"SUB sp, sp, #$%02X",TMB7DASM_IMM7);
    else          sprintf(arm7dasmstr,"ADD sp, sp, #$%02X",TMB7DASM_IMM7);
}

void Thumb7DASMimm8(u32 op)
{
    sprintf(arm7dasmstr,"r%d, #$%02X",TMB7DASM_RS, TMB7DASM_IMM8);
}

void Thumb7DASMimm3(u32 op)
{
    sprintf(arm7dasmstr,"r%d, r%d, #$%01X",TMB7DASM_RD,TMB7DASM_RN,TMB7DASM_RM);
}

void Thumb7DASMb(u32 op)
{
    signed int b = (op&0x0400)?(0xFFFFFC00|(op&0x03FF))
                                          :(op&0x03FF);
    sprintf(arm7dasmstr,"$%08X",arm7reg.r[15]+4+(b*2));
}

void Thumb7DASMbx(u32 op)
{
    if(op&0x0080)
        sprintf(arm7dasmstr,"BLX r%d",TMB7DASM_RNH);
    else
        sprintf(arm7dasmstr,"BX r%d",TMB7DASM_RNH);
}

void Thumb7DASMbl(u32 op)
{
    sprintf(arm7dasmstr,"$%03X",TMB7DASM_IMM11);
}

void Thumb7DASMbc(u32 op)
{
    signed int b = (op&0x00FF)?(0xFFFFFF00|(op&0x00FF))
                                          :(op&0x00FF);
    sprintf(arm7dasmstr,"$%08X",arm7reg.r[15]+4+(b*2));
}

void Thumb7DASMh(u32 op)
{
    sprintf(arm7dasmstr,"r%d, r%d",TMB7DASM_RDH,TMB7DASM_RNH);
}

void Thumb7DASMldm(u32 op)
{
    int i, b_start, b_end, inWord=op;
    char str[512];
    sprintf(str,"{");
    b_start = b_end = -1;
    for (i = 0; i < 8; i++)
    {
        if ((inWord & 1) && (b_start < 0)) b_start = i;
	else if (!(inWord & 1))
	{
	    b_end = i - 1;
	    if (b_start >= 0)
	    {
 	        if(strlen(str)==1)
 	        {
		    if (b_start != b_end) sprintf (str, "%sr%d-r%d", str, b_start, b_end);
		    else sprintf (str, "%sr%d", str, b_start);
		} else {
		    if (b_start != b_end) sprintf (str, "%s,r%d-r%d", str, b_start, b_end);
		    else sprintf (str, "%s,r%d", str, b_start);
		}
	    }
  	    b_start = -1;
	}
	inWord >>= 1;
    }
    sprintf(arm7dasmstr,"%s}",str);
}

void Thumb7DASMdp1(u32 op)
{
    switch((op&0x00C0)>>6)
    {
        case 0: sprintf(arm7dasmstr,"AND r%d, r%d",TMB7DASM_RD,TMB7DASM_RN); break;
        case 1: sprintf(arm7dasmstr,"EOR r%d, r%d",TMB7DASM_RD,TMB7DASM_RN); break;
        case 2: sprintf(arm7dasmstr,"LSL r%d, r%d",TMB7DASM_RD,TMB7DASM_RN); break;
        case 3: sprintf(arm7dasmstr,"LSR r%d, r%d",TMB7DASM_RD,TMB7DASM_RN); break;
    }
}

void Thumb7DASMdp2(u32 op)
{
    switch((op&0x00C0)>>6)
    {
        case 0: sprintf(arm7dasmstr,"ASR r%d, r%d",TMB7DASM_RD,TMB7DASM_RN); break;
        case 1: sprintf(arm7dasmstr,"ADC r%d, r%d",TMB7DASM_RD,TMB7DASM_RN); break;
        case 2: sprintf(arm7dasmstr,"SBC r%d, r%d",TMB7DASM_RD,TMB7DASM_RN); break;
        case 3: sprintf(arm7dasmstr,"ROR r%d, r%d",TMB7DASM_RD,TMB7DASM_RN); break;
    }
}

void Thumb7DASMdp3(u32 op)
{
    switch((op&0x00C0)>>6)
    {
        case 0: sprintf(arm7dasmstr,"TST r%d, r%d",TMB7DASM_RD,TMB7DASM_RN); break;
        case 1: sprintf(arm7dasmstr,"NEG r%d"     ,TMB7DASM_RD); break;
        case 2: sprintf(arm7dasmstr,"CMP r%d, r%d",TMB7DASM_RD,TMB7DASM_RN); break;
        case 3: sprintf(arm7dasmstr,"CMN r%d, r%d",TMB7DASM_RD,TMB7DASM_RN); break;
    }
}

void Thumb7DASMdp4(u32 op)
{
    switch((op&0x00C0)>>6)
    {
        case 0: sprintf(arm7dasmstr,"ORR r%d, r%d",TMB7DASM_RD,TMB7DASM_RN); break;
        case 1: sprintf(arm7dasmstr,"MUL r%d, r%d",TMB7DASM_RD,TMB7DASM_RN); break;
        case 2: sprintf(arm7dasmstr,"BIC r%d, r%d",TMB7DASM_RD,TMB7DASM_RN); break;
        case 3: sprintf(arm7dasmstr,"MVN r%d, r%d",TMB7DASM_RD,TMB7DASM_RN); break;
    }
}

void Thumb7DASMreg(u32 op)
{
    sprintf(arm7dasmstr,"r%d, r%d",TMB7DASM_RD,TMB7DASM_RN);
}

void Thumb7DASMund(u32 op)
{
    sprintf(arm7dasmstr,"");
}

void Thumb7DASMpc(u32 op)
{
    sprintf(arm7dasmstr,"[pc, #$%02X*4]",TMB7DASM_IMM8);
}

void Thumb7DASMsp(u32 op)
{
    sprintf(arm7dasmstr,"[sp, #$%02X*4]",TMB7DASM_IMM8);
}

void Thumb7DASMbkpt(u32 op)
{
    sprintf(arm7dasmstr,"");
}

void Thumb7DASMswi(u32 op)
{
    sprintf(arm7dasmstr,"$%02X",op&0x00FF);
}

/*** EOF:arm7dasm.c ******************************************************/

