/**************************************************************************
* DSemu: VTable structure definitions (vtbl.h)                            *
* Released under the terms of the BSD Public Licence                      *
* Imran Nazar (tf@oopsilon.com), 2004                                     *
**************************************************************************/

#ifndef __VTBL_H_
#define __VTBL_H_

#include <windows.h>
#include "defs.h"
#include "emu.h"

typedef struct {
    void (*init)();
    void (*fini)();
    void (*append)(char*);
    char *file;
} LOGVTBL;

extern LOGVTBL *logvt;

typedef struct {
    int (*init)(char*,LOGVTBL*,HWND);
    void (*fini)();
    int (*reset)();
    void (*keyin)(u32,u32);
    void (*frame)();
    void (*line)();
    void (*step)();
    void (*refresh)();
    void (*resize)(int);
    int (*kidwin)(int);

	int (*sram_load) ( const char * );
	int (*sram_save) ( const char * );

    int running;
    int animate;
    int fixfps;
    int gpuon;
} EMUVTBL;

#endif//__VTBL_H_

/*** EOF:vtbl.h **********************************************************/

