/**************************************************************************
* DSemu: Plugin loading and management (plugin.c)                         *
* Released under the terms of the BSD Public Licence                      *
* Imran Nazar (tf@oopsilon.com), 2004                                     *
**************************************************************************/

#include <windows.h>
#include <stdio.h>
#include "plugin.h"

PLUGIN plugins[4];

void pluginInit()
{
    int a;
    for(a=0;a<4;a++)
    {
        strcpy(plugins[a].name,"");
        plugins[a].dll=NULL;
    }
}

void *pluginLoad(char *pl)
{
    char *file; int a=0, done=0;
    HANDLE handle; 

    file=malloc(strlen(pl)+6);
    sprintf(file,"%s.dll",pl);
    handle=LoadLibrary(pl);
    free(file);
    if(!handle) return NULL;
    do
    {
        if(a==4) return NULL;
        if(!plugins[a].dll)
        {
            strcpy(plugins[a].name,pl);
            plugins[a].dll=handle;
            done=1;
        }
        a++;
    } while(!done);
    return (void*)GetProcAddress(handle,"getVt")();
}

void pluginUnload(char *pl)
{
    int a=0, done=0; 
    do
    {
        if(!strcmp(plugins[a].name,pl))
        {
            FreeLibrary(plugins[a].dll);
            plugins[a].dll=NULL;
            strcpy(plugins[a].name,"");
            done=1;
        }
        a++;
    } while(!done);
}

/*** EOF:plugin.c ********************************************************/

