/**************************************************************************
* DSemu: Graphics functions and definitions (gpu.h)                       *
* Released under the terms of the BSD Public Licence                      *
* Imran Nazar (tf@oopsilon.com), 2004                                     *
**************************************************************************/

#ifndef __GPU_H_
#define __GPU_H_

#include "defs.h"

int GPUinit();
void GPUfini();
void GPUreset();
void GPUscanline(u16*);
void GPUclearHBL();
void GPUpal(u16*);
void GPUpalcol(u16*,int);
void GPUstatus();

void GPUwrH(u32,u16);
void GPUwrW(u32,u32);
u16 GPUrdH(u32);
u32 GPUrdW(u32);

#define STAT_VBLANK  1
#define STAT_HBLANK  2
#define STAT_VCOUNT  4
#define STAT_INTVBL  8
#define STAT_INTHBL 16
#define STAT_INTVCT 32

#define OAM0 OAM[sprnum*4+0]
#define OAM1 OAM[sprnum*4+1]
#define OAM2 OAM[sprnum*4+2]
#define OAM3 OAM[sprnum*4+3]

#endif//__GPU_H_

/*** EOF:gpu.h ***********************************************************/

