/**************************************************************************
* DSemu: Emulation interface function definitions (gba.h)                 *
* Released under the terms of the BSD Public Licence                      *
* Imran Nazar (tf@oopsilon.com), 2004                                     *
**************************************************************************/

#ifndef __GBA_H_
#define __GBA_H_

#include <windows.h>
#include "defs.h"
#include "vtbl.h"
#include "emu.h"
#include "sram.h"

int emuInit(char*, LOGVTBL*, HWND);
void emuFini();
void emuRefresh();
void emuStep();
int emuReset();
void emuFrame();
void emuLine();
void emuLineDbg();
void emuStatus();
void emuResize(int);
void emuMMUDump(u32,int);
void emuGPUCol(int);
void emuKeySet(u32, u32);
int emuChildWin(int);

EMUVTBL* getVt();

EMUVTBL vtbl={emuInit, emuFini, emuReset, emuKeySet,
              emuFrame, emuLineDbg, emuStep,emuRefresh,
	      emuResize, emuChildWin,
		  sram_load,sram_save,
	      0,0,1,1};

#endif//__GBA_H_

/*** EOF:gba.h ***********************************************************/

