/**************************************************************************
* DSemu: Interrupt triggering and flag clear (int.c)                      *
* Released under the terms of the BSD Public Licence                      *
* Imran Nazar (tf@oopsilon.com), 2004                                     *
**************************************************************************/

#include "defs.h"
#include "int.h"
#include "arm9.h"
#include "arm7.h"
#include "dsioreg.h"

u16 int7Fired=0;
u16 int9Fired=0;
extern u16 intr9Bitmask;
extern u16 intrBitmask;

// TODO: interrupts are 32bit...
void IntFire9(u16 interrupt) 
{
	int9Fired|=interrupt;
}

void IntFire7(u16 interrupt) 
{
	int7Fired|=interrupt;
}

void IntFire(u16 interrupt)
{
	int9Fired|=interrupt;
	int7Fired|=interrupt;
}

void Int9Clear(u32 interrupt)
{
    REG(ARM9_REG,IF)&= ~interrupt;
	ARM9InterruptFlagChanged();
}

void Int7Clear(u32 interrupt)
{
    REG(ARM7_REG,IF)&=~interrupt;
	ARM7InterruptFlagChanged();
}

/*** EOF:int.c ***********************************************************/

