/**************************************************************************
* DSemu: ARM9 Specific registers and fields (arm9.h)                      *
* Released under the terms of the BSD Public Licence                      *
* Imran Nazar (tf@oopsilon.com), 2004                                     *
**************************************************************************/

#ifndef __ARM9_H_
#define __ARM9_H_

#include "arm.h"

extern ARMREGS arm9reg;
extern int cpu9Halted;

#define ARM9OP_RN ((arm9reg.curop&ARMMSK_RN)>>16)
#define ARM9OP_RD ((arm9reg.curop&ARMMSK_RD)>>12)
#define ARM9OP_RS ((arm9reg.curop&ARMMSK_RS)>>8)
#define ARM9OP_RM (arm9reg.curop&ARMMSK_RM)

#define ARM9TOP_RD (arm9reg.curop&ARMTMSK_RD)
#define ARM9TOP_RN ((arm9reg.curop&ARMTMSK_RN)>>3)
#define ARM9TOP_RM ((arm9reg.curop&ARMTMSK_RM)>>6)

#define ARM9TOP_RDH ((arm9reg.curop&ARMTMSK_RD)|((arm9reg.curop&0x0080)>>4))
#define ARM9TOP_RNH (((arm9reg.curop&ARMTMSK_RN)>>3)|((arm9reg.curop&0x0040)>>3))

//Redefinitions of some functions defined in arm9func.h by used elsewhere
int ARM9init(char *file, u32 *dbgbuf);
void ARM9fini();
int ARM9execfor(int count);
void ARM9status(int offset, int mode);
int ARM9reset();
void ARM9addClock(int clk);
void ARM9InterruptFlagChanged();
char *Thumb9DASM(u32 op);

#endif//__ARM9_H_

/*** EOF:arm9.h **********************************************************/

