// Windows Header Files:
#include <windows.h>
#include <windowsx.h>
#include <commctrl.h>
#include <winuser.h>

// C RunTime Header Files
#include <stdlib.h>
#include <malloc.h>
#include <memory.h>
#include <tchar.h>

#include "CEventQueue.h"
#include "CMenu.h"
#include "CScrollBar.h"

#include "avigenerator.h"
#include "beeampee.h"
#include "resource.h"
#include "zombie.h"
#include "disarm.h"
#include "ndsfile.h"
#include "mspal.h"
#include "ioregs.h"
#include "ipc.h"


#define NUM_WINDOWS		12


// Menuitem enumerators
#define IDM_ROM_INFO					1003
#define IDM_CLOSE						1004
#define IDM_SCREENSHOT					1005
//#define IDM_SCREEN_BOTH					1008
//#define IDM_MOVIE_START					1009
//#define IDM_MOVIE_STOP					1010
//#define IDM_MOVIE_SETUP					1011
#define IDM_EXIT						1012

#define IDM_RUN							1101
#define IDM_PAUSE						1102
#define IDM_RESET						1103

#define IDM_ABOUT						1301

#define IDC_MAINSCR						1901
#define IDC_SUBSCR						1902

#define IDC_MEMCOMBO					1950


#define FRAMES_PER_SECOND	60.0f


#define WINERROR(message) wsprintf(szBuffer,"%s\nError code = %08X.",message,GetLastError()); \
	                      MessageBox(NULL,szBuffer,"Error",MB_ICONERROR)

#define COMMDLGERROR(message) wsprintf(szBuffer,"%s\nError code = %08X.",message,CommDlgExtendedError()); \
	                      MessageBox(NULL,szBuffer,"Error",MB_ICONERROR)
 
#define WINPRINT(fmtstr,val) wsprintf(szBuffer,fmtstr,val); \
	                         WriteConsole(hOut,szBuffer,lstrlen(szBuffer),&dwDummy,NULL)

typedef struct
{
	HWND hwnd;
	bool active;
} window;


int __stdcall hub(int,int,void*,void*);

LRESULT CALLBACK page1_dlgproc(HWND,UINT,WPARAM,LPARAM);
LRESULT CALLBACK page2_dlgproc(HWND,UINT,WPARAM,LPARAM);
LRESULT CALLBACK page3_dlgproc(HWND,UINT,WPARAM,LPARAM);
LRESULT CALLBACK page4_dlgproc(HWND,UINT,WPARAM,LPARAM);


HWND			hMain,hPropsheet,hMainChk,hSubChk,hMainScr,hSubScr,hStatus,hPalw,hDbgw,hMemw;
HWND			hScrollbar1,hScrollbar2,hComboMem;
HDC				paldc,dbgdc,memdc,disdc,iodc,twdc;
HFONT			font;
HANDLE			hOut;
HINSTANCE		hInst=NULL,hCPU,hMMU,hGPU,hINP;
HACCEL			haccel;
PAINTSTRUCT		ps;
MSG				msg;
UINT			defaultFontID;

unsigned int	*arm9_regs,*arm7_regs;
char			**pageTable;
char			vPath[256],*szPath,currDir[256];
int				mirrorIPC = 1;
NDSFileHeader	hdr;
MSPAL			mspal;

char			dbgMessages[32][64];
int				dbgMsgCount=0;
int				dbgMsgPos=0,memVPos=0x00800000; //,disVPos=0x02004000>>2;
SCROLLINFO		si,si2,si3,si4;
CScrollBar		memviewScroll,disasmScroll,debugScroll;
COLORREF		colors[8];
unsigned int	memview_lut[13] = {0x00000000,0x00800000,0x02000000,0x02004000,
                                   0x04000000,0x04001000,0x05000000,0x05000400,
								   0x06000000,0x06200000,
					  		       0x06800000,0x07000000,0x08000000};
palette_dib		*pdib;
int				palUpdateMode=1;

DLGPROC			PageDlgProc[4] = {(DLGPROC)page1_dlgproc,(DLGPROC)page2_dlgproc,
							   	(DLGPROC)page3_dlgproc,(DLGPROC)page4_dlgproc,};
CMenu			*menu;
OPENFILENAME	ofName;
window			windows[NUM_WINDOWS];
RECT			rect2;

CEventQueue		*eq;

LARGE_INTEGER	perfCnt1,perfCnt2,perfFreq;

DWORD			dwDummy,dwTimerOf;

char			szBuffer[256],szFnBuffer[400],szBuffer3[256];
char			szFileNameOnly[400];

touchpad		touch;

char			szPropsheetCaption[5][16] = {"CPU         ","Memory      ",
						                     "Video       ","Audio       ",
						    			     "Input       "};
int				propSheetButtons[] = {IDOK, IDCANCEL, 0x3021, IDHELP};

cpu_init_callback cpu_init;
cpu_reset_callback cpu_reset;
cpu_get_callback cpu_get;
cpu_set_callback cpu_set;
cpu_execute_until_callback cpu_execute_until;

mmu_init_callback mmu_init;
mmu_reset_callback mmu_reset;
mmu_get_callback mmu_get;
mmu_set_callback mmu_set;
mmu_close_callback mmu_close;
mmu_read_word_callback mmu_read_word;
mmu_read_dword_callback mmu_read_dword;
mmu_write_byte_callback mmu_write_byte;
mmu_write_word_callback mmu_write_word;
mmu_write_dword_callback mmu_write_dword;

gpu_init_callback gpu_init;
gpu_reset_callback gpu_reset;
gpu_get_callback gpu_get;
gpu_set_callback gpu_set;
gpu_hblank_callback gpu_hblank;
gpu_advance_line_callback gpu_advance_line;
gpu_close_callback gpu_close;

mmu_init_callback inp_init;
mmu_reset_callback inp_reset;
mmu_get_callback inp_get;
mmu_set_callback inp_set;
mmu_close_callback inp_close;

int				keys[256];
int				renderer=0;
int				fpsLimit=1,frameskip=0;
bool			run,quit,romLoaded;
float			cpuEmuSpeed;
char			*cart;
UINT			speed,cycles,samples,frames,visCycles,totCycles,romSize;
int				blockDMA=0;

SYSTEMTIME		systime;
int				ipcLoc=0,ipcFormat=1;
bool			openCon;
unsigned char	theme = 6;
int				tsCalibX1,tsCalibY1,tsCalibX2,tsCalibY2;
char			iniFn[256];
unsigned short	tileData[64];
palette_dib		tile;


BITMAPINFOHEADER aviBih;
CAVIGenerator	avigen;
char			*framebuffer;
int				aviFramesRecorded,aviFrameLimit=0;
int				aviFrameSelection;
int				recordMain=1,recordSub=1,int aviRate=30;
char			szAviFn[256] = "c:\\dualis.avi";
bool			aviStreamCreated=false,aviIsRecording=false,aviCodecSelected=false;

bool			pendingPause,pendingScreenshot;
int				bmpFrameSelection;
int				screenshots=0;
loaded_bitmap	bmp_framebuf;
char			szScrFn[256];


#define UYVY 0x59565955


void avi_setup()
{
	memset(&aviBih,0, sizeof(BITMAPINFOHEADER));
	// filling bitmap info structure.
	aviBih.biSize = sizeof(BITMAPINFOHEADER);
	aviBih.biWidth = 256;
	aviBih.biHeight = (recordMain && recordSub) ? 384 : 192;
	aviBih.biPlanes = 1;
	aviBih.biBitCount = 24;
	aviBih.biSizeImage = (((aviBih.biWidth*aviBih.biBitCount+31)/32)*4)*aviBih.biHeight; 
	aviBih.biCompression = BI_RGB; //UYVY; 
	
	// Set fps
	avigen.SetRate(aviRate);
	
	// Give info about bitmap
	avigen.SetBitmapHeader(&aviBih);	
}


void avi_start_recording()
{
	if (aviIsRecording)
	{
		MessageBox(NULL,"Already recoding","AVI recorder",MB_ICONINFORMATION|MB_OK);
		return;
	}

	if ((!recordMain) && (!recordSub))
		return;

	avi_setup();

	// Set filename, extension ".avi" is appended if necessary
	//avigen.SetFileName(_T(szAviFn));

	if (!aviStreamCreated)
	{
		if (avigen.CreateStream() != AVIERR_OK)
		{
			MessageBox(NULL,"Failed to create stream","AVI recorder",MB_ICONERROR|MB_OK);
			return;
		}
		aviStreamCreated = true;
	}

	if (!aviCodecSelected)
	{
		if (avigen.CodecSelect() != AVIERR_OK)
		{
			MessageBox(NULL,"No compressor selected","AVI recorder",MB_ICONERROR|MB_OK);
			return;
		}
		aviCodecSelected = true;
	}

	if (avigen.PrepareStream() != AVIERR_OK)
	{
		return;
	}
	aviIsRecording = true;


	aviFramesRecorded = 0;

	if (recordMain)
	{
		if (recordSub)
			aviFrameSelection = GPU_FRAMEBUFFER_BGR24;
		else
			aviFrameSelection = GPU_FRAMEBUFFER_MAIN_BGR24;
	} else
		aviFrameSelection = GPU_FRAMEBUFFER_SUB_BGR24;
}



void avi_record_frame()
{
	if (aviIsRecording)
	{
		if ((!aviFrameLimit) || (aviFramesRecorded < aviFrameLimit))
		{
			aviFramesRecorded++;
			framebuffer = (char*)gpu_get(aviFrameSelection);
			if (framebuffer)
				avigen.AddFrame((BYTE*)framebuffer);
		}
	}
}


void avi_stop_recording()
{
	aviIsRecording = false;
	aviStreamCreated = false;
	avigen.ReleaseEngine();
}



void screenshot()
{
	framebuffer = (char*)gpu_get(bmpFrameSelection);
	if (framebuffer)
	{
		wsprintf(szScrFn,"%s\\dualis%02d.bmp",szPath,screenshots);
		screenshots++;
		bmp_framebuf.bpp = 24;
		bmp_framebuf.lpbits = framebuffer;
		bmp_framebuf.xdim = 256;
		bmp_framebuf.ydim = (bmpFrameSelection==GPU_FRAMEBUFFER_BGR24) ? 384 : 192;
		bmp_save(szScrFn,&bmp_framebuf,&bmp_framebuf);
	}
}



void emulate()
{
	LONGLONG t1;
	UINT c1;
	event e;
	int i;

	// Send message to the debug console
	hub(TELL,ZOMBIE_DEBUG_MSG,"Beginning emulation",0);

	SendMessage(hStatus,SB_SETTEXT,2,(LPARAM)"Running");
	GetLocalTime(&systime);

	while (run)
	{
		// Pull the next event off the queue
		eq->dequeue(&e);

		// Execute the number of cycles up till the next event, and measure
		// the time it took to do it.
		QueryPerformanceCounter(&perfCnt1);
		c1 = cpu_execute_until(e.timestamp);
		QueryPerformanceCounter(&perfCnt2);
		
		// Update the current execution speed measure
		t1 = perfCnt2.QuadPart - perfCnt1.QuadPart;
		if (t1>1)
		{
			cpuEmuSpeed += (float)(c1 - cycles) / (float)t1;
			samples++;
		}

		// Check the kind of event that occured
		switch (e.data&0xFF)
		{
			case EV_HBLANK_START:
				cycles = c1;
				gpu_hblank();
				break;

			case EV_HBLANK_END:
				gpu_advance_line();
				cycles = c1;

				// Process window messages
				while(PeekMessage(&msg,NULL,0,0,1))
				{
					if (!TranslateAccelerator( 
							hMain,      // handle to receiving window 
							haccel,     // handle to active accelerator table 
							&msg))      // message data 
					{
						TranslateMessage(&msg);
						DispatchMessage(&msg);
					}
				}

				e.timestamp = cycles+visCycles; e.data = EV_HBLANK_START;
				eq->enqueue(&e);
				e.timestamp = cycles+totCycles; e.data = EV_HBLANK_END;
				eq->enqueue(&e);				
				break;

			case EV_TIMER_OVERFLOW:
				mmu_set(MMU_TIMER_OVERFLOW,e.data&0xFF0000,0);
				cycles = c1;
				break;
		}
	}
}



void reset_machine(bool hard)
{
	float f;
	int totlines,linesize,hbipixels,scale,i;
	event e;
	static char usrname[]="G.W. Bush";
	static char usrmsg[]="Dubya haqd your ds!";

	// Reset MMU plugin
	if (!mmu_reset())
	{
		hub(TELL,ZOMBIE_DEBUG_MSG,"mmu_reset failed",0);
		WINERROR("mmu_reset failed.");
		gpu_close();
		mmu_close();
		ExitProcess(0);
	}

	// Reset input plugin
	inp_reset();

	// Personal info ////////////////////////////////
	mmu_write_byte(0x23FFC82,theme); 
	mmu_write_byte(0x23FFC83,7); 
	mmu_write_byte(0x23FFC84,6); 
	
	for (i=0; i<strlen(usrname); i++)
	{
		mmu_write_byte(0x23FFC86+i+i+1,0);
		mmu_write_byte(0x23FFC86+i+i,usrname[i]);
	}
	
	for (i=0; i<strlen(usrmsg); i++)
	{
		mmu_write_byte(0x23FFC9C+i+i+1,0);
		mmu_write_byte(0x23FFC9C+i+i,usrmsg[i]);
	}

	mmu_write_byte(0x23FFCD0,strlen(usrmsg));
	mmu_write_byte(0x23FFCD1,0);
	mmu_write_byte(0x23FFC9A,strlen(usrname));
	mmu_write_byte(0x23FFC9B,0);

	mmu_write_word(0x23FFCD8,tsCalibX1);
	mmu_write_word(0x23FFCDA,tsCalibY1);
	mmu_write_byte(0x23FFCDC,0x20);
	mmu_write_byte(0x23FFCDD,0x20);

	mmu_write_word(0x23FFCDE,tsCalibX2);
	mmu_write_word(0x23FFCE0,tsCalibY2);
	mmu_write_byte(0x23FFCE2,256-0x20);
	mmu_write_byte(0x23FFCE3,192-0x20);

	mmu_set(PLUGIN_SETTING, 11, mirrorIPC);
	/////////////////////////////////////////////////

	// Reset CPU plugin
	cpu_reset();

	// Reset GPU plugin
	gpu_reset();

	//apu_reset,{}) 

	// Copy the ARM9 binary to RAM
	pageTable = (char**)mmu_get(MMU_PAGE_TABLE);
	memcpy(pageTable[hdr.uARM9CopyTo>>20]+(hdr.uARM9CopyTo&0xFFFFF), cart, romSize);

	wsprintf(szBuffer,"Copying %08X bytes to %08X\n",romSize,hdr.uARM9CopyTo);
	WriteConsole(hOut,szBuffer,lstrlen(szBuffer),(unsigned long*)&dwDummy,NULL);

	//wsprintf(szBuffer,"[%08X] = %08X\n",0,*(int*)(pageTable[0x20]+0x199220));
	//WriteConsole(hOut,szBuffer,lstrlen(szBuffer),(unsigned long*)&dwDummy,NULL);
	

	speed = cpu_get(CPU_SPEED);
	scale = cpu_get(CPU_CYCLE_SCALING);
	cpu_set(CPU_CYCLE_COUNT,0,0);
	cycles = cpu_get(CPU_CYCLE_COUNT);

	// Reset the ARM9 program counter
	hub(TELL,CPU_REG_PC,(void*)hdr.uARM9ExecuteFrom,0);

	// Get a pointer to the ARM9 pagetable
	pageTable = (char**)mmu_get(MMU_PAGE_TABLE);

	// Scanlines per frame
	totlines = 263; 
	
	// Pixels during hblank 
	hbipixels = 99; 

	// Pixels per scanline
	linesize = 355; 

	// Cycles per scanline (visible part)
	visCycles = 1536 * 2;

	// Cycles per scanline (total)
	totCycles = 2130 * 2;

	// Flush the event queue
	eq->flush();

	// Initialize the queue
	if (!run)
	{
		e.timestamp = cycles+visCycles; e.data = EV_HBLANK_START;
		eq->enqueue(&e);
		e.timestamp = cycles+totCycles; e.data = EV_HBLANK_END;
		eq->enqueue(&e);
	}

	disasmScroll.pos = 0x02004000>>2;

	pendingPause = pendingScreenshot = false;
}
	



// Returns the directory that the program is being executed from
const char *get_path()
{
	if (*vPath) return vPath;
	ZeroMemory(vPath, sizeof(vPath));
	GetModuleFileName(hInst, vPath, sizeof(vPath));
	char *p = vPath + lstrlen(vPath);
	while (p >= vPath && *p != '\\') p--;
	if (++p >= vPath) *p = 0;
	return vPath;
}



// Force a desired window size and/or position
void force_window_size(HWND hWnd,int x,int y,int width,int height)
{
	RECT rect3;

	GetWindowRect(hWnd,&rect3);
	rect3.right -= rect3.left;
	rect3.bottom -= rect3.top;

	GetClientRect(hWnd,&rect2);
	if ((rect2.right!=width)||(rect2.bottom!=height))
	{
		SetWindowPos(hWnd, NULL, x, y,
			         rect3.right+(width-rect2.right),
					 rect3.bottom+(height-rect2.bottom),
					 SWP_NOZORDER);
	} else
	{
		SetWindowPos(hWnd, NULL, x, y,
			         0,0,
					 SWP_NOSIZE|SWP_NOZORDER);
	}
}



void init()
{
	if (openCon)
	{
		AllocConsole();
		hOut = GetStdHandle(STD_OUTPUT_HANDLE);
	}

	// Get the performance counter update frequency
	QueryPerformanceFrequency(&perfFreq);

	// Load plugins
	wsprintf(szBuffer,"%s\\arm9.dll",szPath);
	if ((hCPU = LoadLibrary(szBuffer)) == NULL)
	{
		WINERROR("LoadLibrary failed.");
		ExitProcess(0);
	}

	wsprintf(szBuffer,"%s\\dsmmu.dll",szPath);
	if ((hMMU = LoadLibrary(szBuffer)) == NULL)
	{
		WINERROR("LoadLibrary failed.");
		ExitProcess(0);
	}

	wsprintf(szBuffer,"%s\\dsgpu.dll",szPath);
	if ((hGPU = LoadLibrary(szBuffer)) == NULL)
	{
		WINERROR("LoadLibrary failed.");
		ExitProcess(0);
	}

	wsprintf(szBuffer,"%s\\input.dll",szPath);
	if ((hINP = LoadLibrary(szBuffer)) == NULL)
	{
		WINERROR("LoadLibrary failed.");
		ExitProcess(0);
	}

	cpu_init = (cpu_init_callback)GetProcAddress(hCPU,"cpu_init");
	cpu_reset = (cpu_reset_callback)GetProcAddress(hCPU,"cpu_reset");
	cpu_get = (cpu_get_callback)GetProcAddress(hCPU,"cpu_get");
	cpu_set = (cpu_set_callback)GetProcAddress(hCPU,"cpu_set");
	cpu_execute_until = (cpu_execute_until_callback)GetProcAddress(hCPU,"cpu_execute_until");

	mmu_init = (mmu_init_callback)GetProcAddress(hMMU,"mmu_init");
	mmu_reset = (mmu_reset_callback)GetProcAddress(hMMU,"mmu_reset");
	mmu_get = (mmu_get_callback)GetProcAddress(hMMU,"mmu_get");
	mmu_set = (mmu_set_callback)GetProcAddress(hMMU,"mmu_set");
	mmu_close = (mmu_close_callback)GetProcAddress(hMMU,"mmu_close");
	mmu_read_word = (mmu_read_word_callback)GetProcAddress(hMMU,"mmu_read_word");
	mmu_read_dword = (mmu_read_dword_callback)GetProcAddress(hMMU,"mmu_read_dword");
	mmu_write_byte = (mmu_write_byte_callback)GetProcAddress(hMMU,"mmu_write_byte");
	mmu_write_word = (mmu_write_word_callback)GetProcAddress(hMMU,"mmu_write_word");
	mmu_write_dword = (mmu_write_dword_callback)GetProcAddress(hMMU,"mmu_write_dword");

	gpu_init = (gpu_init_callback)GetProcAddress(hGPU,"gpu_init");
	gpu_reset = (gpu_reset_callback)GetProcAddress(hGPU,"gpu_reset");
	gpu_get = (gpu_get_callback)GetProcAddress(hGPU,"gpu_get");
	gpu_set = (gpu_set_callback)GetProcAddress(hGPU,"gpu_set");
	gpu_hblank = (gpu_hblank_callback)GetProcAddress(hGPU,"gpu_hblank");
	gpu_advance_line = (gpu_advance_line_callback)GetProcAddress(hGPU,"gpu_advance_line");
	gpu_close = (gpu_close_callback)GetProcAddress(hGPU,"gpu_close");


	inp_init = (mmu_init_callback)GetProcAddress(hINP,"inp_init");
	inp_reset = (mmu_reset_callback)GetProcAddress(hINP,"inp_reset");
	inp_get = (mmu_get_callback)GetProcAddress(hINP,"inp_get");
	inp_set = (mmu_set_callback)GetProcAddress(hINP,"inp_set");
	inp_close = (mmu_close_callback)GetProcAddress(hINP,"inp_close");

	if (cpu_init((zombie_callback)hub)==0)
	{
		WINERROR("cpu_init failed.");
		ExitProcess(0);
	}

	if (mmu_init((zombie_callback)hub)==0)
	{
		WINERROR("mmu_init failed.");
		ExitProcess(0);
	}

	mmu_set(PLUGIN_SETTING, 20, ipcFormat);

	if (gpu_init((zombie_callback)hub)==0)
	{
		WINERROR("gpu_init failed.");
		ExitProcess(0);
	}

	if (gpu_get(GPU_RENDERER_OK)==0)
	{
		gpu_close();
		mmu_close();
		MessageBox(NULL,"Failed to find a suitable rendering mode.","Error",MB_ICONERROR);
		ExitProcess(0);
	}

	gpu_set(PLUGIN_SETTING, 0, frameskip);
	gpu_set(PLUGIN_SETTING, 1, fpsLimit);
	gpu_set(PLUGIN_SETTING, 20, renderer);

	if (inp_init((zombie_callback)hub)==0)
	{
		gpu_close();
		mmu_close();
		WINERROR("inp_init failed.");
		ExitProcess(0);
	}

	pageTable = (char**)mmu_get(MMU_PAGE_TABLE);

	romLoaded = false;

	memviewScroll.pos = 0x00800000;
	disasmScroll.pos = 0x02004000>>2;

	pendingPause = pendingScreenshot = false;
}



void __stdcall apu_write_stub(unsigned char c1,unsigned char c2)
{
}



int __stdcall hub(int direction,int topic,void *param1,void *param2)
{
	event e;
	int i;


	switch (direction)
	{
		case ASK:
			
			switch(topic)
			{
				case CPU_IRQ_CALLBACK: 
				case CPU_CYCLE_COUNT: 
				case CPU_REG: 
				case CPU_REG_PC: 
				case CPU_DMA_CALLBACK: 
					return cpu_get(topic);

				case MMU_PAGE_TABLE: 
					//hub(TELL,ZOMBIE_DEBUG_MSG,"Returning page table",0);
				case MMU_DTCM:
				case MMU_ITCM:
				case MMU_IRQ_OK:
				case MMU_READ_BYTE_CALLBACK:
				case MMU_GET_CALLBACK: 
				case MMU_READ_WORD_CALLBACK: 
				case MMU_READ_WORD_CALLBACKS: 
				case MMU_READ_DWORD_CALLBACK: 
				case MMU_READ_DWORD_CALLBACKS: 
				case MMU_WRITE_BYTE_CALLBACK: 
				case MMU_WRITE_WORD_CALLBACK: 
				case MMU_WRITE_WORD_CALLBACKS: 
				case MMU_WRITE_DWORD_CALLBACK: 
				case MMU_WRITE_DWORD_CALLBACKS: 
				case MMU_TRANSLATE_ADDRESS_CALLBACK: 
				case MMU_IRQ_CALLBACK:
				case MMU_VRAM_BANKS:
					return mmu_get(topic);

				case GPU_MEMORY:
					//hub(TELL,ZOMBIE_DEBUG_MSG,"Asking for GPU memory",0);
					return gpu_get(topic);
				case GPU_SET_CALLBACK:
					return (int)gpu_set;
				case GPU_GET_CALLBACK:
					return (int)gpu_get;

				case APU_WRITE_CALLBACK:
					return (int)apu_write_stub;

				case ZOMBIE_WINDOW_HANDLE: 
					return (int)windows[(int)param1&0xFF].hwnd;

				case ZOMBIE_ROM_BASE:
					return (int)cart;
				case ZOMBIE_ROM_SIZE: 
					return romSize;
				case ZOMBIE_KEYSTATE: 
					return keys[(int)param1 & 0xFF];

				case TOUCHPAD_DATA:
					return (int)&touch;

			}
			//wsprintf(szBuffer,"Return default value (0) for message 0x%X",topic);
			//hub(TELL,ZOMBIE_DEBUG_MSG,szBuffer,0);
			return 0;

		case TELL:
			switch (topic)
			{
				case ZOMBIE_EVENT:
					e.data = (UINT)param1;
					e.timestamp = (UINT)param2;
					eq->enqueue(&e);
					break;

				case MMU_IRQ:
				case MMU_IRQ_OVER:
					mmu_set(topic,(unsigned int)param1,(int)param2);
					break;
				case MMU_READ_WORD_CALLBACKS:
					cpu_set(topic,(unsigned int)param1,(int)param2);
					break;

				case INPUT_KEYDOWN:
					mmu_set(ZOMBIE_KEYSTATE,(unsigned int)param1,1);
					break;
				case INPUT_KEYUP:
					mmu_set(ZOMBIE_KEYSTATE,(unsigned int)param1,0);
					break;

				case ZOMBIE_DEBUG_MSG:
					// string pointer in param1
					if (dbgMsgCount==32)
					{
						for (i=0; i<31; i++)
							strcpy(dbgMessages[i],dbgMessages[i+1]);
						strncpy(dbgMessages[31],(const char*)param1,48);
					} else
						//strcpy(dbgMessages[dbgMsgCount++],(const char*)param1);
						strncpy(dbgMessages[dbgMsgCount++],(const char*)param1,48);

					si.nPos = dbgMsgPos;
			        si.nMax   = dbgMsgCount-1;
			        SetScrollInfo(hScrollbar1, SB_CTL, &si, TRUE);

					if (windows[4].active)
					{
						rect2.left = 8;
						rect2.top = 32;
						rect2.right = 250;
						rect2.bottom = -1;
						InvalidateRect(windows[4].hwnd,NULL,TRUE);
					}
					break;
					
				case MMU_TCM_REMAP:
					mmu_set(topic,(unsigned int)param1,(int)param2);
					break;

				case ZOMBIE_HALT:
					run = false;
					break;

				case CPU_SPEED: 
					speed = (UINT)param1;
					break;

				case CPU_CYCLE_PTR: 
					mmu_set(topic,(unsigned int)param1,(unsigned int)param2);
					//apu_set(topic,param1,param2)
					break;

				case CPU_IO_HANDLER: 
					cpu_set(topic,(unsigned int)param1,(unsigned int)param2);
					break;

				case CPU_REG_PC:
					//MessageBox(NULL,"CPU_REG_PC","Message",MB_OK);
					cpu_set(topic,(unsigned int)param1,(unsigned int)param2);
					break;
			
				case GPU_FRAME_COMPLETED: 
					frames++;
					if (windows[3].active && run && (palUpdateMode==4))
						InvalidateRect(windows[3].hwnd,NULL,FALSE);
					if (pendingPause)
					{
						run = false;
						pendingPause = false;
					}
					if (pendingScreenshot)
					{
						pendingScreenshot = false;
						screenshot();

					}
					//apu_mix();
					avi_record_frame();
					break;

				case GPU_VBLANK_ACTION: 
				case GPU_HBLANK_ACTION: 
					gpu_set(topic,(unsigned int)param1,(unsigned int)param2);
					break;

			}
			return 0;
	}

	//wsprintf(szBuffer,"Bad direction (%X, %X, %X, %X)",direction,topic,param1,param2);
	//hub(TELL,ZOMBIE_DEBUG_MSG,szBuffer,0);
	return 0;
}


char *load_nds(char *fname)
{
	HANDLE hFile;
	DWORD dwBytesRead;

	hFile = CreateFile(fname, GENERIC_READ, 0, NULL, OPEN_EXISTING,
                       FILE_ATTRIBUTE_NORMAL|FILE_FLAG_SEQUENTIAL_SCAN,
                       NULL);
	if (hFile == INVALID_HANDLE_VALUE)
		return 0;

	ReadFile(hFile,&hdr,sizeof(NDSFileHeader),&dwBytesRead,NULL);

	if (hdr.uARM9Size > (64*1024*1024))
	{
		wsprintf(szBuffer,"%s will not be loaded. Bad header or invalid file format (ARM9Size = %d)",
			hdr.uARM9Size);
		MessageBox(NULL,szBuffer,"Error",MB_ICONERROR);
		CloseHandle(hFile);
		return NULL;
	}

	if (hdr.uARM9Size > (32*1024*1024))
	{
		wsprintf(szBuffer,"Suspect ARM9 size: %d bytes.\nAre you sure you wish to proceed?",
				hdr.uARM9Size);
		if (MessageBox(NULL,szBuffer,"Question",MB_YESNO|MB_ICONQUESTION)!=IDYES)
		{
			CloseHandle(hFile);
			return NULL;
		}
	}
	/*wsprintf(szBuffer,"arm9 loc: %08X\narm9 exec: %08X\narm9 copyto: %08X\narm9 size: %08X\n",
				hdr.uARM9Source,hdr.uARM9ExecuteFrom,hdr.uARM9CopyTo,hdr.uARM9Size);
	WriteConsole(hOut,szBuffer,strlen(szBuffer),(LPDWORD)&dwDummy,NULL);*/
	
	romSize = hdr.uARM9Size;
	cart = (char*)LocalAlloc(LPTR,romSize);
	memset(cart,0,romSize);
	SetFilePointer(hFile,hdr.uARM9Source,NULL,FILE_BEGIN);
	ReadFile(hFile,cart,romSize,&dwBytesRead,NULL);
	if (dwBytesRead != romSize)
	{
		LocalFree((HLOCAL)cart);
		return 0;
	}
	CloseHandle(hFile);

	unsigned int *ucart=(unsigned int*)cart;
	for (int i=0; i<romSize/4; i++)
	{
		if (ucart[i] == 0x41e3421a) //0xa2522004)
		{
			wsprintf(szBuffer,"Found match at %x\n",i*4);
			WriteConsole(hOut,szBuffer,strlen(szBuffer),(LPDWORD)&dwDummy,NULL);
		}
	}


	EnableMenuItem(menu->popups[0]->hMenu,IDM_ROM_INFO,MF_ENABLED);

	return cart;
}


char *load_rom(char *fname)
{
	HANDLE hFile;
	DWORD dwBytesRead;
	char *p;
	int l;

	EnableMenuItem(menu->popups[0]->hMenu,IDM_ROM_INFO,MF_GRAYED);

	l = lstrlen(fname);
	if (l>3)
	{
		p = &fname[l-3];
		if (strcmp(p,"nds")==0)
			return load_nds(fname);
	}
	
	hFile = CreateFile(fname, GENERIC_READ, 0, NULL, OPEN_EXISTING,
                       FILE_ATTRIBUTE_NORMAL|FILE_FLAG_SEQUENTIAL_SCAN,
                       NULL);
	if (hFile == INVALID_HANDLE_VALUE)
		return 0;

	romSize = GetFileSize(hFile,NULL);
	cart = (char*)LocalAlloc(LPTR,romSize);
	memset(cart,0,romSize);
	ReadFile(hFile,cart,romSize,&dwBytesRead,NULL);
	if (dwBytesRead != romSize)
	{
		LocalFree((HLOCAL)cart);
		return 0;
	}
	CloseHandle(hFile);
	hdr.uARM9CopyTo = 0x2004000;
	hdr.uARM9ExecuteFrom = 0x2004000;
	return cart;
}




int get_openfilename(char *szBuf, char *szTitle, char *szFilter)
{
   ofName.lStructSize = sizeof(OPENFILENAME);
   ofName.hwndOwner = hMain;
   ofName.lpstrFilter = szFilter;
   ofName.nFilterIndex = 1;
   ofName.lpstrFile = szBuf;
   ofName.lpstrFileTitle = szFileNameOnly;
   ofName.nMaxFile = 399;
   ofName.nMaxFileTitle = 200;
   ofName.lpstrInitialDir = NULL;
   ofName.lpstrTitle = szTitle;
   ofName.Flags = OFN_EXPLORER | OFN_OVERWRITEPROMPT;
   return (GetOpenFileName(&ofName));
}


int get_savefilename(char *szBuf, char *szTitle, char *szFilter)
{
   ofName.lStructSize = sizeof(OPENFILENAME);
   ofName.hwndOwner = hMain;
   ofName.lpstrFilter = szFilter;
   ofName.nFilterIndex = 1;
   ofName.lpstrFile = szBuf;
   ofName.lpstrFileTitle = szFileNameOnly;
   ofName.nMaxFile = 399;
   ofName.nMaxFileTitle = 200;
   ofName.lpstrInitialDir = NULL;
   ofName.lpstrTitle = szTitle;
   ofName.Flags = OFN_EXPLORER | OFN_OVERWRITEPROMPT;
   return (GetSaveFileName(&ofName));
}



HWND create_window(char *pszTitle,char *pszClass,char *pszIcon,char *pszCursor,int nColor,int xdim,int ydim,WNDPROC msgHandler)
{
	HWND hWindow;
	HICON hIcon;
	HCURSOR hCursor;
	WNDCLASSEX wc;
	ATOM aClass;

	if (pszIcon != NULL)
		hIcon = LoadIcon(hInst,pszIcon);
	else
		hIcon = LoadIcon(hInst,MAKEINTRESOURCE(IDI_ICON1)); //IDI_APPLICATION);

	if (pszCursor != NULL)
		hCursor = LoadIcon(hInst,pszCursor);
	else
		hCursor = LoadCursor(NULL,IDC_ARROW);

	wc.cbSize = sizeof(wc);
	wc.style = CS_OWNDC | CS_HREDRAW | CS_VREDRAW;
	wc.hIcon = wc.hIconSm = hIcon;
	wc.cbClsExtra = wc.cbWndExtra = 16;
	wc.hCursor = hCursor;
	wc.hbrBackground = (HBRUSH)MAKEINTRESOURCE(nColor+1);
	wc.hInstance = hInst;
	wc.lpfnWndProc = msgHandler;
	wc.lpszClassName = pszClass;
	wc.lpszMenuName = NULL; 

	if ((aClass=RegisterClassExA(&wc))==0)
	{
		WINERROR("RegisterClassEx failed.");
		ExitProcess(0);
	}

	if (strcmp(pszClass,"SbScrClass")==0)
	{
		rect2.top = 0;
		rect2.left = 0;
		rect2.right = 255;
		rect2.bottom = 383;
		AdjustWindowRect(&rect2,WS_POPUP|WS_CAPTION|WS_BORDER|WS_SYSMENU|WS_MINIMIZEBOX,0);
		hWindow = CreateWindowEx(NULL,(LPSTR)aClass,pszTitle,WS_POPUP|WS_CAPTION|WS_BORDER|WS_SYSMENU|WS_MINIMIZEBOX,
			40,40,rect2.right,rect2.bottom,NULL,NULL,hInst,NULL);
	} else
	{ 
		rect2.right = xdim;
		rect2.bottom = ydim;
		hWindow = CreateWindowEx(NULL,(LPSTR)aClass,pszTitle,WS_CAPTION|WS_BORDER|WS_SYSMENU|WS_MINIMIZEBOX, //(WS_OVERLAPPED|WS_CAPTION|WS_SYSMENU|WS_THICKFRAME|WS_MINIMIZEBOX),
			40,40,rect2.right,rect2.bottom,NULL,NULL,hInst,NULL);
	}

 
	if (hWindow==NULL)
	{
		WINERROR("CreateWindowEx failed.");
		ExitProcess(0);
	}

	return hWindow;
}



void CALLBACK propsheet_callback(HWND hwndPropSheet, UINT uMsg, LPARAM lParam)
{
	switch(uMsg)
	{
		// Called before the dialog is created, hwndPropSheet = NULL, lParam points to dialog resource
		case PSCB_PRECREATE:
		{
			LPDLGTEMPLATE lpTemplate = (LPDLGTEMPLATE)lParam;
			lpTemplate->style &= ~WS_VISIBLE;
		}
		break;
		
		// Called after the dialog is created
		case PSCB_INITIALIZED:
		break;
		
	}
}


LRESULT CALLBACK page1_dlgproc(HWND hdlg, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
	LPNMHDR lpnmhdr;
	HWND hwnd,hCtl;
	static int irqEnabled=1;

	switch (uMsg)
	{
	case WM_COMMAND:
		switch (LOWORD(wParam))
		{
			case IDC_CHECK1:
				hCtl = GetDlgItem(hdlg,IDC_CHECK1);
				irqEnabled = (SendMessage(hCtl,BM_GETCHECK,0,0)==BST_CHECKED) ? 1 : 0;
				cpu_set(CPU_ENABLE_IRQ,irqEnabled,irqEnabled);
				break;
		}
		SetFocus(hMain);
		break;

	case WM_NOTIFY:
		lpnmhdr = (NMHDR*)lParam;
		
		switch (lpnmhdr->code)
		{
		case PSN_APPLY:   // Sent when OK or Apply button pressed
            break;
			
		case PSN_RESET:   // Sent when Cancel button pressed
            break;
			
		case PSN_SETACTIVE:
			hwnd = GetDlgItem(hdlg,IDC_CHECK1);
			SendMessage(hwnd,BM_SETCHECK,irqEnabled,0);
            break;
			
		default:
            break;
		}
		break;
		
		default:
			break;
	}
	
	return FALSE;
}


LRESULT CALLBACK page2_dlgproc(HWND hdlg, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
	LPNMHDR lpnmhdr;
	HWND hCtl;
	int i;
	static bool firstTime=true;

	switch (uMsg)
	{
	case WM_COMMAND:
		switch(LOWORD(wParam))
		{
			case IDC_IPC_1:
			case IDC_IPC_2:
				hCtl = GetDlgItem(hdlg,IDC_IPC_1);
				ipcLoc = (SendMessage(hCtl,BM_GETCHECK,0,0)==BST_CHECKED) ? 0 : 1;
				mmu_set(PLUGIN_SETTING,10,ipcLoc);
				break;
			case IDC_CHECK1:
				hCtl = GetDlgItem(hdlg,IDC_CHECK1);
				mirrorIPC = (SendMessage(hCtl, BM_GETCHECK, 0, 0)==BST_CHECKED) ? 1 : 0;
				mmu_set(PLUGIN_SETTING, 11, mirrorIPC);
				break;

			case IDC_COMBO1:
			case IDC_COMBO2:
				return 0;
			case IDC_COMBO3:
				//wsprintf(szBuffer,"COMBO1: %X",HIWORD(wParam));
				//hub(TELL,ZOMBIE_DEBUG_MSG,szBuffer,0);
				if (HIWORD(wParam)==CBN_SELCHANGE)
				{
					hCtl = GetDlgItem(hdlg,LOWORD(wParam));
					theme = SendMessage(hCtl,CB_GETCURSEL,0,0);
					//if (romLoaded)
						mmu_write_byte(0x23FFC82,theme);
				}
				return 0;
				break;

			case IDC_COMBO4:
				if (HIWORD(wParam)==CBN_SELCHANGE)
				{
					hCtl = GetDlgItem(hdlg,LOWORD(wParam));
					ipcFormat = SendMessage(hCtl,CB_GETCURSEL,0,0)+1;
					//if (romLoaded)
						mmu_set(PLUGIN_SETTING,20,ipcFormat);
				}
				return 0;
				break;

		}
		SetFocus(hMain);
		break;

	case WM_INITDIALOG:
		//SetWindowLong(hdlg, DWL_USER, lParam);
		if (firstTime)
		{
			hCtl = GetDlgItem(hdlg,IDC_EDIT1);
			SetWindowText(hCtl,"G.W. Bush");

			hCtl = GetDlgItem(hdlg,IDC_COMBO1);
			SendMessage(hCtl,CB_ADDSTRING,0,(LPARAM)"January");
			SendMessage(hCtl,CB_ADDSTRING,0,(LPARAM)"February");
			SendMessage(hCtl,CB_ADDSTRING,0,(LPARAM)"March");
			SendMessage(hCtl,CB_ADDSTRING,0,(LPARAM)"April");
			SendMessage(hCtl,CB_ADDSTRING,0,(LPARAM)"May");
			SendMessage(hCtl,CB_ADDSTRING,0,(LPARAM)"June");
			SendMessage(hCtl,CB_ADDSTRING,0,(LPARAM)"July");
			SendMessage(hCtl,CB_ADDSTRING,0,(LPARAM)"August");
			SendMessage(hCtl,CB_ADDSTRING,0,(LPARAM)"September");
			SendMessage(hCtl,CB_ADDSTRING,0,(LPARAM)"October");
			SendMessage(hCtl,CB_ADDSTRING,0,(LPARAM)"November");
			SendMessage(hCtl,CB_ADDSTRING,0,(LPARAM)"December");
			SendMessage(hCtl,CB_SETCURSEL,6,0);

			hCtl = GetDlgItem(hdlg,IDC_COMBO3);
			SendMessage(hCtl,CB_ADDSTRING,0,(LPARAM)"Gray");
			SendMessage(hCtl,CB_ADDSTRING,0,(LPARAM)"Maroon");
			SendMessage(hCtl,CB_ADDSTRING,0,(LPARAM)"Red");
			SendMessage(hCtl,CB_ADDSTRING,0,(LPARAM)"Pink");
			SendMessage(hCtl,CB_ADDSTRING,0,(LPARAM)"Orange");
			SendMessage(hCtl,CB_ADDSTRING,0,(LPARAM)"Yellow");
			SendMessage(hCtl,CB_ADDSTRING,0,(LPARAM)"Lime");
			SendMessage(hCtl,CB_ADDSTRING,0,(LPARAM)"Green");
			SendMessage(hCtl,CB_ADDSTRING,0,(LPARAM)"Dark Green");
			SendMessage(hCtl,CB_ADDSTRING,0,(LPARAM)"Teal");
			SendMessage(hCtl,CB_ADDSTRING,0,(LPARAM)"Light Blue");
			SendMessage(hCtl,CB_ADDSTRING,0,(LPARAM)"Blue");
			SendMessage(hCtl,CB_ADDSTRING,0,(LPARAM)"Dark Blue");
			SendMessage(hCtl,CB_ADDSTRING,0,(LPARAM)"Dark Purple");
			SendMessage(hCtl,CB_ADDSTRING,0,(LPARAM)"Light Purple");
			SendMessage(hCtl,CB_ADDSTRING,0,(LPARAM)"Dark Pink");
			SendMessage(hCtl,CB_SETCURSEL,(theme>15)?15:theme,0);

			hCtl = GetDlgItem(hdlg,IDC_COMBO4);
			SendMessage(hCtl,CB_ADDSTRING,0,(LPARAM)"v1");
			SendMessage(hCtl,CB_ADDSTRING,0,(LPARAM)"v2");
			SendMessage(hCtl,CB_SETCURSEL,ipcFormat-1,0);

			hCtl = GetDlgItem(hdlg,IDC_COMBO2);
			for (i=1; i<32; i++)
			{
				wsprintf(szBuffer,"%d",i);
				SendMessage(hCtl,CB_ADDSTRING,0,(LPARAM)szBuffer);
			}
			SendMessage(hCtl,CB_SETCURSEL,5,0);
			firstTime = false;
		}			
		break;

	case WM_NOTIFY:
		lpnmhdr = (NMHDR*)lParam;
		
		switch (lpnmhdr->code)
		{
		case PSN_APPLY:   //sent when OK or Apply button pressed
            break;
			
		case PSN_RESET:   //sent when Cancel button pressed
            break;
			
		case PSN_SETACTIVE:
			//SetWindowLong(hdlg, DWL_USER, lParam);
			hCtl = GetDlgItem(hdlg,IDC_IPC_1);
			SendMessage(hCtl,BM_SETCHECK,1-ipcLoc,0);
			hCtl = GetDlgItem(hdlg,IDC_IPC_2);
			SendMessage(hCtl,BM_SETCHECK,ipcLoc,0);
			hCtl = GetDlgItem(hdlg,IDC_CHECK1);
			SendMessage(hCtl,BM_SETCHECK,mirrorIPC,0);
			break;
			
		default:
            break;
		}
		break;
		
		default:
			break;
	}
	
	return FALSE;
}


LRESULT CALLBACK page3_dlgproc(HWND hdlg, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
	LPNMHDR lpnmhdr;
	HWND hCtl;
	int i;
	static bool firstTime=true;
	static int texFrmt = 1;

	switch (uMsg)
	{
	case WM_COMMAND:
		switch(LOWORD(wParam))
		{
			case IDC_CHECK_FPS:
				//MessageBox(NULL,"WM_COMMAND","DIALOG2",MB_OK);
				hCtl = GetDlgItem(hdlg,IDC_CHECK_FPS);
				fpsLimit = (SendMessage(hCtl,BM_GETCHECK,0,0)==BST_CHECKED) ? 1 : 0;
				gpu_set(PLUGIN_SETTING,1,fpsLimit);
				break;
			case IDC_RADIO_TEX1:
				hCtl = GetDlgItem(hdlg,IDC_RADIO_TEX1);
				texFrmt = (SendMessage(hCtl,BM_GETCHECK,0,0)==BST_CHECKED) ? 0 : 1;
				gpu_set(PLUGIN_SETTING,5,0x8366-(texFrmt*0x332));
				break;
			case IDC_RADIO_TEX2:
				hCtl = GetDlgItem(hdlg,IDC_RADIO_TEX2);
				texFrmt = (SendMessage(hCtl,BM_GETCHECK,0,0)==BST_CHECKED) ? 1 : 0;
				gpu_set(PLUGIN_SETTING,5,0x8366-(texFrmt*0x332));
				break;

			case IDC_RADIO_OGL:
				hCtl = GetDlgItem(hdlg,IDC_RADIO_TEX1);
				EnableWindow(hCtl, TRUE);
				hCtl = GetDlgItem(hdlg,IDC_RADIO_TEX2);
				EnableWindow(hCtl, TRUE);
				renderer = 0;
				gpu_set(PLUGIN_SETTING,20,renderer);
				break;
			case IDC_RADIO_D3D:
			case IDC_RADIO_GDI:
				hCtl = GetDlgItem(hdlg,IDC_RADIO_TEX1);
				EnableWindow(hCtl, FALSE);
				hCtl = GetDlgItem(hdlg,IDC_RADIO_TEX2);
				EnableWindow(hCtl, FALSE);
				hCtl = GetDlgItem(hdlg,IDC_RADIO_OGL);
				renderer = ((SendMessage(hCtl,BM_GETCHECK,0,0)==BST_CHECKED) ? 0 : -1);
				if (renderer == -1)
				{
					hCtl = GetDlgItem(hdlg,IDC_RADIO_D3D);
					renderer = ((SendMessage(hCtl,BM_GETCHECK,0,0)==BST_CHECKED) ? 1 : 2);
				}
				gpu_set(PLUGIN_SETTING,20,renderer);
				break;

			case IDC_BG0_EN:
			case IDC_BG1_EN:
			case IDC_BG2_EN:
			case IDC_BG3_EN:
			case IDC_OBJ_EN:
				hCtl = GetDlgItem(hdlg,LOWORD(wParam));
				gpu_set(PLUGIN_SETTING,8,(LOWORD(wParam)-IDC_BG0_EN)|((SendMessage(hCtl,BM_GETCHECK,0,0)==BST_CHECKED) ? 0x10000 : 0));
				break;

			case IDC_BG0_EN2:
			case IDC_BG1_EN2:
			case IDC_BG2_EN2:
			case IDC_BG3_EN2:
			case IDC_OBJ_EN2:
				hCtl = GetDlgItem(hdlg,LOWORD(wParam));
				gpu_set(PLUGIN_SETTING,8,(LOWORD(wParam)-IDC_BG0_EN2)|0x100|((SendMessage(hCtl,BM_GETCHECK,0,0)==BST_CHECKED) ? 0x10000 : 0));
				break;

			case IDC_COMBO_SKIP:
				if (HIWORD(wParam)==CBN_SELCHANGE)
				{
					hCtl = GetDlgItem(hdlg,LOWORD(wParam));
					frameskip = SendMessage(hCtl,CB_GETCURSEL,0,0);
					gpu_set(PLUGIN_SETTING,0,frameskip);
				}
				return 0;

		}
		SetFocus(hMain);
		break;

	case WM_NOTIFY:
		lpnmhdr = (NMHDR*)lParam;
		
		switch (lpnmhdr->code)
		{
		case PSN_APPLY:   //sent when OK or Apply button pressed
            break;
			
		case PSN_RESET:   //sent when Cancel button pressed
            break;
			
		case PSN_SETACTIVE:
			if (firstTime)
			{
				hCtl = GetDlgItem(hdlg,IDC_COMBO_SKIP);
				SendMessage(hCtl,CB_ADDSTRING,0,(LPARAM)"0");
				SendMessage(hCtl,CB_ADDSTRING,0,(LPARAM)"1");
				SendMessage(hCtl,CB_ADDSTRING,0,(LPARAM)"2");
				SendMessage(hCtl,CB_ADDSTRING,0,(LPARAM)"3");
				SendMessage(hCtl,CB_ADDSTRING,0,(LPARAM)"4");
				SendMessage(hCtl,CB_ADDSTRING,0,(LPARAM)"5");
				SendMessage(hCtl,CB_ADDSTRING,0,(LPARAM)"6");
				SendMessage(hCtl,CB_ADDSTRING,0,(LPARAM)"7");
				SendMessage(hCtl,CB_ADDSTRING,0,(LPARAM)"8");
				SendMessage(hCtl,CB_ADDSTRING,0,(LPARAM)"9");
				SendMessage(hCtl,CB_SETCURSEL,frameskip,0);
				//EnableWindow(hCtl,TRUE);
			}

			hCtl = GetDlgItem(hdlg,IDC_RADIO_OGL+renderer);
			SendMessage(hCtl,BM_SETCHECK,1,0);
			if (gpu_get != NULL)
				if ((gpu_get(GPU_RENDERER_OK)&2)==0)
				{
					hCtl = GetDlgItem(hdlg,IDC_RADIO_D3D);
					EnableWindow(hCtl,FALSE);
				}

			hCtl = GetDlgItem(hdlg,IDC_RADIO_TEX1);
			SendMessage(hCtl,BM_SETCHECK,1-texFrmt,0);
			hCtl = GetDlgItem(hdlg,IDC_RADIO_TEX2);
			SendMessage(hCtl,BM_SETCHECK,texFrmt,0);

			hCtl = GetDlgItem(hdlg,IDC_CHECK_FPS);
			SendMessage(hCtl,BM_SETCHECK,fpsLimit,0);
			hCtl = GetDlgItem(hdlg,IDC_3D_BUFFER);
			SendMessage(hCtl,BM_SETCHECK,1,0);

			for (i=IDC_BG0_EN; i<=IDC_OBJ_EN; i++)
			{
				hCtl = GetDlgItem(hdlg,i);
				SendMessage(hCtl,BM_SETCHECK,1,0);
				hCtl = GetDlgItem(hdlg,i+11);
				SendMessage(hCtl,BM_SETCHECK,1,0);
			}

			firstTime = false;

			break;
			
		default:
            break;
		}
		break;
		
		default:
			break;
	}
	
	return FALSE;
}


LRESULT CALLBACK page4_dlgproc(HWND hdlg, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
	LPNMHDR lpnmhdr;
	
	switch (uMsg)
	{
	case WM_NOTIFY:
		lpnmhdr = (NMHDR*)lParam;
		
		switch (lpnmhdr->code)
		{
		case PSN_APPLY:   //sent when OK or Apply button pressed
            break;
			
		case PSN_RESET:   //sent when Cancel button pressed
            break;
			
		case PSN_SETACTIVE:
			break;
			
		default:
            break;
		}
		break;
		
		default:
			break;
	}
	
	return FALSE;
}


HWND create_propsheet()
{
	PROPSHEETPAGE psp[4];
	PROPSHEETHEADER psh;
	int i;

	memset(psp, 0, sizeof(PROPSHEETPAGE) * 2);
	memset(&psh, 0, sizeof(PROPSHEETHEADER));

	for (i=0; i<4; i++)
	{
		psp[i].dwSize		 = sizeof(PROPSHEETPAGE);
		psp[i].dwFlags		 = PSP_USETITLE;
		psp[i].hInstance	 = hInst;
		psp[i].pszTemplate	 = MAKEINTRESOURCE(IDD_DIALOG1+i);
		psp[i].pszIcon		 = NULL;
		psp[i].pfnDlgProc	 = (DLGPROC)PageDlgProc[i];
		psp[i].pszTitle 	 = TEXT(szPropsheetCaption[i]);
		//	psp[0].lParam		 = 0;
	}	
	
	//Fill out the PROPSHEETHEADER
	psh.dwSize			 = sizeof(PROPSHEETHEADER);
	psh.dwFlags 		 = PSH_PROPSHEETPAGE | PSH_USECALLBACK| PSH_MODELESS;
	psh.hwndParent		 = hMain;
	psh.hInstance        = NULL;
	psh.pszIcon 		 = NULL;
	psh.pszCaption		 = NULL;
	psh.nPages			 = sizeof(psp) / sizeof(PROPSHEETPAGE);
	psh.nStartPage		 = 2;
	psh.ppsp			 = (LPCPROPSHEETPAGE) &psp;
	psh.pfnCallback 	 = (PFNPROPSHEETCALLBACK)propsheet_callback;
	
	return (HWND)PropertySheet(&psh);
}


void center_propsheet(DWORD dwSize)
{
	RECT rect;

	GetWindowRect(hPropsheet, &rect);

	int xL = LOWORD(dwSize) / 2 - (rect.right - rect.left) / 2;
	int yT = HIWORD(dwSize) / 2 - (rect.bottom - rect.top) / 2;

	/*SetWindowPos(hPropsheet, NULL, 0, 20, LOWORD(dwSize), HIWORD(dwSize),
				 SWP_NOZORDER | SWP_NOACTIVATE);*/
	MoveWindow(hPropsheet,0,20,LOWORD(dwSize),HIWORD(dwSize),TRUE);
}


void init_propsheet_size()
{
	RECT rectWnd;
	RECT rectButton;

	GetWindowRect(hPropsheet,&rectWnd);
	HWND hWnd = GetDlgItem(hPropsheet, IDOK);
	
	if(!hWnd)
	{
		//DebugBreak();
		return;
	}

	GetWindowRect(hWnd, &rectButton);
	ShowWindow(hPropsheet,SW_SHOW);

	/*SetWindowPos(hPropsheet, NULL, 0, 20,
		rectWnd.right - rectWnd.left, rectButton.top - rectWnd.top,
	 SWP_NOZORDER | SWP_NOACTIVATE | SWP_SHOWWINDOW);*/

	for (int i=0; i<4; i++)
	{
		hWnd = GetDlgItem(hPropsheet, propSheetButtons[i]);
		if (hWnd != NULL)
		{
			ShowWindow(hWnd, SW_HIDE);
			EnableWindow(hWnd, FALSE);
		}
	}
}



// Configuration dialog callback
BOOL CALLBACK DlgProc5(HWND hdlg, UINT msg, WPARAM wParam, LPARAM lParam) {
	//static char stemp[64];
	int i;
	HWND hCmb;

   switch(msg) {
		case WM_INITDIALOG:
			SetWindowLong(hdlg, DWL_USER, lParam);
			hCmb = GetDlgItem(hdlg,IDC_EDIT1);
			SetWindowText(hCmb,"Release 12\r\n Mic, 2005\r\n\r\nConsult the README if having any problems.");
			return TRUE;

		case WM_COMMAND:
			switch(LOWORD(wParam)) {
				case IDOK:
					EndDialog(hdlg, 0);
					return TRUE;

				case IDCANCEL:
					EndDialog(hdlg, 1);
					return FALSE;

				default:
					break;
			}
			break;
   }

	return FALSE;
}



// Configuration dialog callback
BOOL CALLBACK DlgProc6(HWND hdlg, UINT msg, WPARAM wParam, LPARAM lParam) {
	//static char stemp[64];
	int i;
	HWND hCmb,hSize1,hSize2;

   switch(msg) {
		case WM_INITDIALOG:
			return TRUE;

		case WM_COMMAND:
			switch(LOWORD(wParam)) {
				case IDOK:
					EndDialog(hdlg, 0);
					return TRUE;

				case IDCANCEL:
					EndDialog(hdlg, 1);
					return FALSE;

				default:
					break;
			}
			break;
   }

	return FALSE;
}




// Memory viewer callback
BOOL CALLBACK DlgProc7(HWND hdlg, UINT msg, WPARAM wParam, LPARAM lParam) {
	int i,j,k,l;
	HWND hCmb,hCtl,hSize2;
	HWND hScroll;
	static int mview=IDC_RADIO_B;
	int x,y;
	static unsigned int adrPick=0xffffffff;

   switch(msg) {
		case WM_INITDIALOG:
			SetWindowLong(hdlg, DWL_USER, lParam);

			memdc = GetDC(hdlg);

			SelectObject(memdc, font);
			SetBkColor(memdc,GetSysColor(COLOR_MENU));
			SetTextColor(memdc,RGB(128,20,20));

			hCmb = GetDlgItem(hdlg,IDC_COMBO_MEM);
			SendMessage(hCmb,CB_ADDSTRING,0,(LPARAM)"0x00000000");
			SendMessage(hCmb,CB_ADDSTRING,0,(LPARAM)"0x00800000");
			SendMessage(hCmb,CB_ADDSTRING,0,(LPARAM)"0x02000000");
			SendMessage(hCmb,CB_ADDSTRING,0,(LPARAM)"0x02004000");
			SendMessage(hCmb,CB_ADDSTRING,0,(LPARAM)"0x04000000");
			SendMessage(hCmb,CB_ADDSTRING,0,(LPARAM)"0x04001000");
			SendMessage(hCmb,CB_ADDSTRING,0,(LPARAM)"0x05000000");
			SendMessage(hCmb,CB_ADDSTRING,0,(LPARAM)"0x05000400");
			SendMessage(hCmb,CB_ADDSTRING,0,(LPARAM)"0x06000000");
			SendMessage(hCmb,CB_ADDSTRING,0,(LPARAM)"0x06200000");
			SendMessage(hCmb,CB_ADDSTRING,0,(LPARAM)"0x06800000");
			SendMessage(hCmb,CB_ADDSTRING,0,(LPARAM)"0x07000000");
			SendMessage(hCmb,CB_ADDSTRING,0,(LPARAM)"0x08000000");
			SendMessage(hCmb,CB_SETCURSEL,4,0);
			EnableWindow(hCmb,TRUE);

			//SendMessage(hCmb,CB_GETCOMBOBOXINFO,0,&cbnfo);

			memviewScroll.hwnd = GetDlgItem(hdlg, IDC_SCROLLBAR1);
			memviewScroll.set_range(0,0x0FFFFFFF);
			memviewScroll.set_page_size(0x100);
			memviewScroll.set_pos(memviewScroll.pos);

			hCtl = GetDlgItem(hdlg,mview);
			SendMessage(hCtl,BM_SETCHECK,1,0);
	
			x = y = -1;

			return TRUE;


		case WM_SIZE:
			return 0;
		
		case WM_LBUTTONDOWN:
			x = LOWORD(lParam);
			y = HIWORD(lParam);
			// 78,114  240,276
			if ((x>=78) && (y>=113) && (x<240) && (y<276))
			{
				x -= 78;
				y -= 113;
				x /= 20;
				y /= 14;

				adrPick = j = ((memviewScroll.pos + y)<<3) + (x&4);
				if (romLoaded)
				{
					k = mmu_read_word(j) | (mmu_read_word(j+2)<<16);
					//l = mmu_read_word(j+(i<<3)+4)|(mmu_read_word(j+(i<<3)+6)<<16);
				} else
					k = l = 0;

				wsprintf(szBuffer,"0x%08x",j);
				hCtl = GetDlgItem(hdlg,IDC_COMBO_MEM);
				SetWindowText(hCtl,szBuffer);

				wsprintf(szBuffer,"0x%08x",k);
				hCtl = GetDlgItem(hdlg,IDC_EDIT1);
				SetWindowText(hCtl,szBuffer);
				//MessageBox(NULL,szBuffer,"foo",MB_OK);

			}

			break;

		case WM_VSCROLL:
			if ((HWND)lParam != memviewScroll.hwnd)
				break;
			memviewScroll.get_pos();
			switch (LOWORD(wParam))
			{
				case SB_TOP:
					memviewScroll.pos = 0;
					break;

				case SB_LINEUP:
					if (memviewScroll.pos > 0)
						memviewScroll.pos--;
					break;
				case SB_PAGEUP:
					if (memviewScroll.pos > 12)
						memviewScroll.pos -= 12;
					break;

				case SB_THUMBPOSITION:
					memviewScroll.pos = HIWORD(wParam);
					break;

				case SB_THUMBTRACK:
					memviewScroll.pos = memviewScroll.get_tracker_pos();
					break;

				case SB_LINEDOWN:
					if (memviewScroll.pos < 0x0FFFFF80)
						memviewScroll.pos++;
					break;
				case SB_PAGEDOWN:
					if (memviewScroll.pos < 0x0FFFFFC0)
						memviewScroll.pos += 12;
					break;

				case SB_BOTTOM:
					memviewScroll.pos = 0x0FFFFF80;
					break;
			}
			memviewScroll.set_pos(memviewScroll.pos);
			InvalidateRect(hdlg,NULL,TRUE);
			break;

		case WM_PAINT:
			BeginPaint(hdlg,&ps);
			
			MoveToEx(memdc, 8, 58+44, NULL);
			LineTo(memdc, 304,58+44);

			hCtl = GetDlgItem(hdlg,IDC_RADIO_B);
			if (SendMessage(hCtl,BM_GETCHECK,0,0) == BST_CHECKED)
			{
				mview = IDC_RADIO_B;
			} else 
			{
				hCtl = GetDlgItem(hdlg,IDC_RADIO_H);
				if (SendMessage(hCtl,BM_GETCHECK,0,0) == BST_CHECKED)
				{
					mview = IDC_RADIO_H;
				} else
					mview = IDC_RADIO_W;
			}

			j = memviewScroll.pos<<3; 
			for (i=0; i<12; i++)
			{
				//if (i>12) break;
				if (romLoaded)
				{
					k = mmu_read_word(j+(i<<3))|(mmu_read_word(j+(i<<3)+2)<<16);
					l = mmu_read_word(j+(i<<3)+4)|(mmu_read_word(j+(i<<3)+6)<<16);
				} else
					k = l = 0;

				if (mview == IDC_RADIO_B)
				{
					wsprintf(szBuffer,"%08X: %02X %02X %02X %02X %02X %02X %02X %02X",
										j+(i<<3),(k)&255,(k>>8)&255,(k>>16)&255,(k>>24)&255,
										(l)&255,(l>>8)&255,(l>>16)&255,(l>>24)&255);
				} else if (mview == IDC_RADIO_H)
				{
					wsprintf(szBuffer,"%08X: %04X  %04X  %04X  %04X",
										j+(i<<3),(k)&0xFFFF,(k>>16)&0xFFFF,
										(l)&0xFFFF,(l>>16)&0xFFFF);
				} else
				{
					wsprintf(szBuffer,"%08X: %08X    %08X",
							j+(i<<3),k,l);
				}
				TextOut(memdc,8,64+50+(i*14),szBuffer,lstrlen(szBuffer));
			}
			EndPaint(hdlg,&ps);
			break;


		case WM_COMMAND:
			switch(LOWORD(wParam)) {
				case IDC_RADIO_B:
				case IDC_RADIO_H:
				case IDC_RADIO_W:
					InvalidateRect(hdlg,NULL,TRUE);
					break;

				case IDC_BUTTON1:
					hCmb = GetDlgItem(hdlg,IDC_COMBO_MEM);
					
					GetWindowText(hCmb,szBuffer3,12);
					if (strlen(szBuffer3))
					{
						if (szBuffer3[0] != '0')
						{
							strcpy(szBuffer,"0x");
							strcat(szBuffer,szBuffer3);
						} else
						{
							strcpy(szBuffer,szBuffer3);
						}
						memviewScroll.pos = strtoul(szBuffer,NULL,0) >> 3; // & (~7);
						//wsprintf(szBuffer,"%x",memviewScroll.pos);
						//MessageBox(NULL,szBuffer,"EDIT contains",MB_OK);

						memviewScroll.set_pos(memviewScroll.pos); //memview_lut[SendMessage(hCmb,CB_GETCURSEL,0,0)]>>3);
						memviewScroll.set_tracker_pos(memviewScroll.pos);
						InvalidateRect(hdlg,NULL,TRUE);
					}
					break;

				case IDC_BUTTON2:
					hCtl = GetDlgItem(hdlg,IDC_EDIT1);
					
					if (adrPick != 0xffffffff)
					{
						GetWindowText(hCtl,szBuffer3,12);
						if (strlen(szBuffer3))
						{
							if (szBuffer3[0] != '0')
							{
								strcpy(szBuffer,"0x");
								strcat(szBuffer,szBuffer3);
							} else
							{
								strcpy(szBuffer,szBuffer3);
							}
							mmu_write_dword(adrPick, strtoul(szBuffer,NULL,0)); 

							//wsprintf(szBuffer,"Writing %08x to %08x",0,adrPick);
							//MessageBox(NULL,szBuffer,"foo",MB_OK);

							//memviewScroll.set_pos(memviewScroll.pos); //memview_lut[SendMessage(hCmb,CB_GETCURSEL,0,0)]>>3);
							//memviewScroll.set_tracker_pos(memviewScroll.pos);
							InvalidateRect(hdlg,NULL,TRUE);
						}
					}
					break;

				case IDOK:
					ReleaseDC(hdlg,memdc);
					EndDialog(hdlg, 0);
					windows[5].active = false;
					return TRUE;

				case IDCANCEL:
				case IDCLOSE:
					ReleaseDC(hdlg,memdc);
					EndDialog(hdlg, 1);
					windows[5].active = false;
					return FALSE;

				default:
					break;
			}
			break;
   }

	return FALSE;
}




// Debug console callback
BOOL CALLBACK DlgProc8(HWND hdlg, UINT msg, WPARAM wParam, LPARAM lParam) {
	static char stemp[64];
	int i,j,k,l;
	HWND hCmb,hCtl,hSize2;
	HWND hScroll;

   switch(msg) {
		case WM_INITDIALOG:
			SetWindowLong(hdlg, DWL_USER, lParam);

			dbgdc = GetDC(hdlg);

			SelectObject(dbgdc, font);
			SetBkColor(dbgdc,GetSysColor(COLOR_MENU));
			SetTextColor(dbgdc,RGB(128,20,20));

			hScroll = GetDlgItem(hdlg,IDC_SCROLLBAR2);
			ZeroMemory(&si, sizeof(si));
			si.cbSize = sizeof(si);
			si.fMask  = SIF_RANGE | SIF_PAGE | SIF_POS;
			si.nMin   = 0;
			//si.nMax   = 0x0FFFFFFF;
			si.nPage  = 0x1;
			//si.nPos   = 0x00800000;
			si.nPos = dbgMsgPos;
			si.nMax   = (dbgMsgCount-1)>=0 ? (dbgMsgCount-1) : 0;
			SetScrollInfo(hScroll, SB_CTL, &si, TRUE);

			hCtl = GetDlgItem(hdlg,IDC_CHECK1);
			SendMessage(hCtl,BM_SETCHECK,1,0);

			return TRUE;


		case WM_SIZE:
			return 0;

		case WM_VSCROLL:
			hScroll = GetDlgItem(hdlg,IDC_SCROLLBAR2);
			if ((HWND)lParam != hScroll) break;
			dbgMsgPos = GetScrollPos(hScroll, SB_CTL);
			switch (LOWORD(wParam))
			{
				case SB_TOP:
						dbgMsgPos = 0;
						break;

				case SB_LINEUP:
						if (dbgMsgPos > 0)
								dbgMsgPos--;
						break;
				case SB_PAGEUP:
						if (dbgMsgPos > 1)
								dbgMsgPos -= 2;
						break;

				case SB_THUMBPOSITION:
						dbgMsgPos = HIWORD(wParam);
						break;

				case SB_THUMBTRACK:
						dbgMsgPos = HIWORD(wParam);
						break;

				case SB_LINEDOWN:
						if (dbgMsgPos < dbgMsgCount-1)
								dbgMsgPos++;
						break;
				case SB_PAGEDOWN:
						if (dbgMsgPos < dbgMsgCount-2)
								dbgMsgPos += 2;
						break;

				case SB_BOTTOM:
						dbgMsgPos = dbgMsgCount-1;
						break;
			}
			SetScrollPos(hScroll, SB_CTL, dbgMsgPos, TRUE);
			InvalidateRect(hdlg,NULL,TRUE);
			break;

		case WM_PAINT:
			BeginPaint(hdlg,&ps);
			MoveToEx(dbgdc, 8, 36, NULL);
			LineTo(dbgdc, 256,36);
			j = dbgMsgPos;
			for (i=1; i<=dbgMsgCount; i++)
			{
				if (i>12) break;
				if (dbgMsgCount-(i+j) < 0) break;
				TextOut(dbgdc,8,40+((i-1)*14),dbgMessages[dbgMsgCount-(i+j)],lstrlen(dbgMessages[dbgMsgCount-(i+j)]));
			}
			EndPaint(hdlg,&ps);
			return 0;

				

		case WM_COMMAND:
			switch(LOWORD(wParam)) {
				case IDC_BUTTON1:
					dbgMsgCount = 0;
					dbgMsgPos = 0;
					si.nPos = dbgMsgPos;
					si.nMax   = (dbgMsgCount-1)>=0 ? (dbgMsgCount-1) : 0;
					hScroll = GetDlgItem(hdlg,IDC_SCROLLBAR1);
					SetScrollInfo(hScroll, SB_CTL, &si, TRUE);
					for (i=0; i<32; i++)
						dbgMessages[i][0] = '\0';
					InvalidateRect(hdlg,NULL,TRUE);
					break;

				case IDOK:
					ReleaseDC(hdlg,dbgdc);
					EndDialog(hdlg, 0);
					windows[4].active = false;
					return TRUE;

				case IDCANCEL:
				case IDCLOSE:
					ReleaseDC(hdlg,dbgdc);
					EndDialog(hdlg, 1);
					windows[4].active = false;
					return FALSE;

				default:
					break;
			}
			break;
   }

	return FALSE;
}


BOOL CALLBACK DlgProc15(HWND hdlg, UINT msg, WPARAM wParam, LPARAM lParam);
const char sep = '/';
unsigned int dlg15EditVal=0;

// Disassembler callback
BOOL CALLBACK DlgProc9(HWND hdlg, UINT msg, WPARAM wParam, LPARAM lParam) {
	int				i,j,k,l,p,x,y,page,offset;
	unsigned int	op;
	HWND			hCmb,hCtl;
	HWND			hScroll;
	char			*lpsz,*token;
	HPEN			blackPen,whitePen;
	HBRUSH			whiteBrush;
	HWND			hDlg;
	static bool		isARM = true;
	static int		disMode = IDC_RADIO_AUTO;

   switch(msg) {
		case WM_INITDIALOG:
			SetWindowLong(hdlg, DWL_USER, lParam);

			disdc = GetDC(hdlg);

			SelectObject(disdc, font);
			SetBkColor(disdc,colors[0]); ;
			SetTextColor(disdc,RGB(160,160,160)); 

			disasmScroll.hwnd = GetDlgItem(hdlg, IDC_SCROLLBAR1);
			disasmScroll.set_range(0,0x0FFFFFFF);
			disasmScroll.set_page_size(0x100);
			disasmScroll.set_pos(disasmScroll.pos);

			hCmb = GetDlgItem(hdlg,IDC_COMBO1);
			SendMessage(hCmb,CB_ADDSTRING,0,(LPARAM)"0x00000000");
			SendMessage(hCmb,CB_ADDSTRING,0,(LPARAM)"0x00800000");
			SendMessage(hCmb,CB_ADDSTRING,0,(LPARAM)"0x02000000");
			SendMessage(hCmb,CB_ADDSTRING,0,(LPARAM)"0x02004000");
			SendMessage(hCmb,CB_ADDSTRING,0,(LPARAM)"0x04000000");
			SendMessage(hCmb,CB_ADDSTRING,0,(LPARAM)"0x05000000");
			SendMessage(hCmb,CB_ADDSTRING,0,(LPARAM)"0x06000000");
			SendMessage(hCmb,CB_ADDSTRING,0,(LPARAM)"0x06200000");
			SendMessage(hCmb,CB_ADDSTRING,0,(LPARAM)"0x06800000");
			SendMessage(hCmb,CB_ADDSTRING,0,(LPARAM)"0x07000000");
			SendMessage(hCmb,CB_ADDSTRING,0,(LPARAM)"0x08000000");
			SendMessage(hCmb,CB_SETCURSEL,3,0);
			EnableWindow(hCmb,TRUE);

			whitePen = CreatePen(PS_SOLID,0,colors[0]); //RGB(255,255,255));
			blackPen = CreatePen(PS_SOLID,0,RGB(0,0,0));

			hCtl = GetDlgItem(hdlg,disMode);
			SendMessage(hCtl,BM_SETCHECK,1,0);

			arm9_regs = (unsigned int*)cpu_get(CPU_REG);

			for (i=IDC_STATIC0; i<=IDC_STATIC15; i++)
			{
				hCtl = GetDlgItem(hdlg,i);
				SendMessage(hCtl, WM_SETFONT, (WPARAM)font, TRUE);
				if (i<IDC_STATIC10)
					wsprintf(szBuffer,"R%d:  0x%08X",i-IDC_STATIC0,arm9_regs[i-IDC_STATIC0]);
				else
					wsprintf(szBuffer,"R%d: 0x%08X",i-IDC_STATIC0,arm9_regs[i-IDC_STATIC0]);
				SetWindowText(hCtl,szBuffer);
			}

			j = 0x80000000;
			for (i=IDC_STATIC_N; i<=IDC_STATIC_N4; i++)
			{
				hCtl = GetDlgItem(hdlg,i);
				EnableWindow(hCtl,(arm9_regs[16]&j)!=0);
				j >>= 1;
			}
			hCtl = GetDlgItem(hdlg,IDC_STATIC_N5);
			EnableWindow(hCtl,(arm9_regs[16]&0x8000000)!=0);
			hCtl = GetDlgItem(hdlg,IDC_STATIC_N6);
			EnableWindow(hCtl,(arm9_regs[16]&0x20)!=0);

			return TRUE;


		case WM_SIZE:
			return 0;
		
		// Handle leftbutton clicks on the register list
		case WM_LBUTTONDOWN:
			x = LOWORD(lParam);
			y = HIWORD(lParam);
			if ((x>=454) && (y>=37))
			{
				x -= 454;
				y -= 37;
				y /= 18;
				if (y<16)
				{
					dlg15EditVal = arm9_regs[y];
					DialogBoxParam(hInst,MAKEINTRESOURCE(IDD_DIALOG15),hdlg,DlgProc15,NULL);
					arm9_regs[y] = dlg15EditVal;
				}
			}
			break;

		case WM_VSCROLL:
			if ((HWND)lParam != disasmScroll.hwnd) break;
			disasmScroll.get_pos();
			switch (LOWORD(wParam))
			{
				case SB_TOP:
						disasmScroll.pos = 0;
						break;

				case SB_LINEUP:
						if (disasmScroll.pos > 0)
								disasmScroll.pos--;
						break;
				case SB_PAGEUP:
						if (disasmScroll.pos > 12)
								disasmScroll.pos -= 12;
						break;

				case SB_THUMBPOSITION:
						disasmScroll.pos = HIWORD(wParam);
						break;

				case SB_THUMBTRACK:
					disasmScroll.get_tracker_pos();
					break;

				case SB_LINEDOWN:
						if (disasmScroll.pos<0x0FFFFF80)
								disasmScroll.pos++;
						break;
				case SB_PAGEDOWN:
						if (disasmScroll.pos<0x0FFFFFC0)
								disasmScroll.pos += 12;
						break;

				case SB_BOTTOM:
						disasmScroll.pos = 0x0FFFFF80;
						break;
			}
			disasmScroll.set_pos(disasmScroll.pos);
			rect2.top = 90;
			rect2.left = 8;
			rect2.right = 360;
			rect2.bottom = -1;
			InvalidateRect(hdlg,&rect2,FALSE);
			break;

		case WM_PAINT:
			BeginPaint(hdlg,&ps);

			arm9_regs = (unsigned int*)cpu_get(CPU_REG);

			for (i=IDC_STATIC0; i<=IDC_STATIC15; i++)
			{
				hCtl = GetDlgItem(hdlg,i);
				SendMessage(hCtl, WM_SETFONT, (WPARAM)font, TRUE);
				if (i<IDC_STATIC10)
					wsprintf(szBuffer,"R%d:  0x%08X",i-IDC_STATIC0,arm9_regs[i-IDC_STATIC0]);
				else
					wsprintf(szBuffer,"R%d: 0x%08X",i-IDC_STATIC0,arm9_regs[i-IDC_STATIC0]);
				SetWindowText(hCtl,szBuffer);
			}

			j = 0x80000000;
			for (i=IDC_STATIC_N; i<=IDC_STATIC_N4; i++)
			{
				hCtl = GetDlgItem(hdlg,i);
				EnableWindow(hCtl,(arm9_regs[16]&j)!=0);
				j >>= 1;
			}
			hCtl = GetDlgItem(hdlg,IDC_STATIC_N5);
			EnableWindow(hCtl,(arm9_regs[16]&0x8000000)!=0);
			hCtl = GetDlgItem(hdlg,IDC_STATIC_N6);
			EnableWindow(hCtl,(arm9_regs[16]&0x20)!=0);
			
			whiteBrush = CreateSolidBrush(colors[0]);
			SelectObject(disdc,whiteBrush);
			Rectangle(disdc,8,91,416,348);
			lpsz = &szBuffer[0];

			hCtl = GetDlgItem(hdlg,IDC_RADIO_AUTO);
			if (SendMessage(hCtl,BM_GETCHECK,0,0) == BST_CHECKED)
			{
				isARM = ((arm9_regs[16]&0x20)==0);
			} else
			{
				hCtl = GetDlgItem(hdlg,IDC_RADIO_ARM);
				isARM = (SendMessage(hCtl,BM_GETCHECK,0,0) == BST_CHECKED);
			}

			j = disasmScroll.pos<<2;
			for (i=0; i<18; i++)
			{
				page = j>>20;
				if (isARM)
					offset = j&0xFFFFC;
				else
					offset = j&0xFFFFE;
				k = j;
				if (pageTable[page])
				{
					j += disassemble(lpsz,(page<<20)+offset,(unsigned int*)(pageTable[page]+offset),isARM);
				} else
				{
					op = 0;
					j += disassemble(lpsz,(page<<20)+offset,&op,isARM);
				}
					

				token = strtok(lpsz,&sep);
				x = lstrlen(token);
				if (k == arm9_regs[15])
				{
					SetBkColor(disdc,colors[7]);
					SetTextColor(disdc,colors[0]);
				} else
					SetTextColor(disdc,colors[1]); 
				TextOut(disdc,10,96+(i*14),token,x);
				for (p=1; p<16; p++)
				{
					token = strtok(NULL,&sep);
					if (token==NULL) break;
					if (k != arm9_regs[15])
					{
						if (p==1)
							SetTextColor(disdc,colors[1]);
						else if (p==2)
							SetTextColor(disdc,colors[2]);
						else if ((token[0] == 'r'))
							SetTextColor(disdc,colors[3]);
						else if (token[0]=='#')
							SetTextColor(disdc,colors[4]);
						else if ((token[0]==']')||(token[0]=='[')||(token[0]=='}')||(token[0]=='{'))
							SetTextColor(disdc,colors[6]);
						else if (token[0]==';')
							SetTextColor(disdc,colors[5]);
						else
							SetTextColor(disdc,colors[7]);
					}				
					TextOut(disdc,10+(x*7),96+(i*14),token,lstrlen(token));
					x += lstrlen(token);
				}
				if (k == arm9_regs[15])
					SetBkColor(disdc,colors[0]);
			}
			DeleteObject(whiteBrush);
			EndPaint(hdlg,&ps);
			break;


		case WM_COMMAND:
			switch(LOWORD(wParam)) {
				case IDC_RADIO_ARM:
				case IDC_RADIO_TMB:
				case IDC_RADIO_AUTO:
					InvalidateRect(hdlg,NULL,TRUE);
					break;

				case IDC_BUTTON1:
					hCmb = GetDlgItem(hdlg,IDC_COMBO1);
					
					GetWindowText(hCmb,szBuffer3,12);
					if (strlen(szBuffer3))
					{
						if (szBuffer3[0] != '0')
						{
							strcpy(szBuffer,"0x");
							strcat(szBuffer,szBuffer3);
						} else
						{
							strcpy(szBuffer,szBuffer3);
						}
						disasmScroll.pos = strtoul(szBuffer,NULL,0) >> 2; 

						disasmScroll.set_pos(disasmScroll.pos); 
						disasmScroll.set_tracker_pos(disasmScroll.pos);
						InvalidateRect(hdlg,NULL,TRUE);
					}
					break;

				case IDC_BUTTON4:
					arm9_regs = (unsigned int*)cpu_get(CPU_REG);
					disasmScroll.pos = arm9_regs[15]>>2;
					disasmScroll.set_pos(disasmScroll.pos);
					disasmScroll.set_tracker_pos(disasmScroll.pos);
					rect2.top = 90;
					rect2.left = 8;
					rect2.right = 360;
					rect2.bottom = -1;
					InvalidateRect(hdlg,&rect2,FALSE);
					break;

				case IDOK:
					ReleaseDC(hdlg,disdc);
					EndDialog(hdlg, 0);
					windows[6].active = false;
					return TRUE;

				case IDCANCEL:
				case IDCLOSE:
					ReleaseDC(hdlg,disdc);
					EndDialog(hdlg, 1);
					windows[6].active = false;
					return FALSE;

				default:
					break;
			}
			break;
   }

	return FALSE;
}



#define MAINPAL_POSX 8
#define SUBPAL_POSX  160
#define EXTPAL_POSX  312

unsigned int lcdc_banks[5] = 
{
	0x0080000,
	0x0090000,
	0x0094000,
	0x0098000,
	0x00A0000
};

// Palette viewer callback
BOOL CALLBACK DlgProc10(HWND hdlg, UINT msg, WPARAM wParam, LPARAM lParam) {
	static int	palSel=0,colSel=0,extBank=0,extSet=0,extPal=0;
	int			i,j,k,l;
	HWND		hCmb,hCtl,hSize2;
	HWND		hScroll;
	HBRUSH		hbrCol;
	short int	currCol;
	unsigned short int *p;
	unsigned char *vramptr;
	HANDLE		hFile;
	DWORD		dwBytesRead;
	static char szRIFF[]="RIFF",szPAL[]="PAL ",szdata[]="data";


   switch(msg) {
		case WM_INITDIALOG:
			SetWindowLong(hdlg, DWL_USER, lParam);

			hCmb = GetDlgItem(hdlg,IDC_COMBO1);
			SendMessage(hCmb,CB_ADDSTRING,0,(LPARAM)"Bank E");
			SendMessage(hCmb,CB_ADDSTRING,0,(LPARAM)"Bank F");
			SendMessage(hCmb,CB_ADDSTRING,0,(LPARAM)"Bank G");
			SendMessage(hCmb,CB_ADDSTRING,0,(LPARAM)"Bank H");
			SendMessage(hCmb,CB_ADDSTRING,0,(LPARAM)"Bank I");
			SendMessage(hCmb,CB_SETCURSEL,extBank,0);

			hCmb = GetDlgItem(hdlg,IDC_COMBO2);
			SendMessage(hCmb,CB_ADDSTRING,0,(LPARAM)"Set 0");
			SendMessage(hCmb,CB_ADDSTRING,0,(LPARAM)"Set 1");
			SendMessage(hCmb,CB_ADDSTRING,0,(LPARAM)"Set 2");
			SendMessage(hCmb,CB_ADDSTRING,0,(LPARAM)"Set 3");
			SendMessage(hCmb,CB_SETCURSEL,extSet,0);

			hCmb = GetDlgItem(hdlg,IDC_COMBO3);
			SendMessage(hCmb,CB_ADDSTRING,0,(LPARAM)"Frame");
			SendMessage(hCmb,CB_ADDSTRING,0,(LPARAM)"Second");
			SendMessage(hCmb,CB_SETCURSEL,palUpdateMode&3,0);

			hCtl = GetDlgItem(hdlg,IDC_CHECK1);
			SendMessage(hCmb,BM_SETCHECK,(palUpdateMode&4)?BST_CHECKED:BST_UNCHECKED,0);

			paldc = GetDC(hdlg);

			SelectObject(paldc, font);
			SetBkColor(paldc,GetSysColor(COLOR_MENU));
			SetTextColor(paldc,RGB(128,20,20));

			if (romLoaded)
			{ 
				vramptr = (unsigned char*)gpu_get(GPU_MEMORY);
				currCol = mmu_read_word(0x5000000+(palSel<<10)+(colSel<<1));
			} else
			{
				vramptr = NULL;
				currCol = (short)GetSysColor(COLOR_MENU);
			}

			for (i=0; i<3; i++)
			{
				hCtl = GetDlgItem(hdlg,IDC_SLIDER1+i);
				SendMessage(hCtl,TBM_SETRANGE,FALSE,MAKELONG(0,31));
				SendMessage(hCtl,TBM_SETPOS,TRUE,currCol&31);
				hCtl = GetDlgItem(hdlg,IDC_STATIC_R+i);
				wsprintf(szBuffer,"%d",currCol&31);
				SetWindowText(hCtl,szBuffer);

				currCol >>= 5;
			}

			hCtl = GetDlgItem(hdlg,IDC_SLIDER4);
			SendMessage(hCtl,TBM_SETRANGE,FALSE,MAKELONG(0,15));
			SendMessage(hCtl,TBM_SETPOS,TRUE,extPal);
			hCtl = GetDlgItem(hdlg,IDC_STATIC_E);
			wsprintf(szBuffer,"%d",extPal);
			SetWindowText(hCtl,szBuffer);

			return TRUE;


		case WM_SIZE:
			return 0;

		case WM_HSCROLL:
			if (!romLoaded) return 0;
			for (i=0; i<3; i++)
			{
				hScroll = GetDlgItem(hdlg,IDC_SLIDER1+i);
				if ((HWND)lParam == hScroll) break;
			}
			if (i == 3)
			{
				hScroll = GetDlgItem(hdlg,IDC_SLIDER4);
				if ((HWND)lParam == hScroll)
				{
					extPal = SendMessage(hScroll,TBM_GETPOS,0,0);
					hCtl = GetDlgItem(hdlg,IDC_STATIC_E);
					wsprintf(szBuffer,"%d",extPal);
					SetWindowText(hCtl,szBuffer);

					if (palSel == 2)
					{
						if ((extBank==0)||(extBank==3))
							i = extSet;
						else
							i = extSet & 1;
						p = (unsigned short int*)(pageTable[0x60] + (lcdc_banks[extBank]&0xFFFFF) + (i<<13) + (extPal<<9) + (colSel<<1));
						currCol = *p;
						for (i=0; i<3; i++)
						{
							hCtl = GetDlgItem(hdlg,IDC_SLIDER1+i);
							//SendMessage(hCtl,TBM_SETRANGE,FALSE,MAKELONG(0,31));
							SendMessage(hCtl,TBM_SETPOS,TRUE,currCol&31);
							hCtl = GetDlgItem(hdlg,IDC_STATIC_R+i);
							wsprintf(szBuffer,"%d",currCol&31);
							SetWindowText(hCtl,szBuffer);

							currCol >>= 5;
						}
					}

					InvalidateRect(hdlg,NULL,FALSE);
				}
				return 0;
			}
			j = SendMessage(hScroll,TBM_GETPOS,0,0);
			currCol = mmu_read_word(0x5000000+(palSel<<10)+(colSel<<1));
			mmu_write_word(0x5000000+(palSel<<10)+(colSel<<1),(currCol&(~(31<<(i*5))))|(j<<(i*5)));
			hCtl = GetDlgItem(hdlg,IDC_STATIC_R+i);
			wsprintf(szBuffer,"%d",j);
			SetWindowText(hCtl,szBuffer);
			rect2.left = 8;
			rect2.top = 8;
			rect2.right = 80;
			rect2.bottom = 80;
			InvalidateRect(hdlg,&rect2,FALSE);
			return 0;

		case WM_LBUTTONDOWN:
			i = LOWORD(lParam);
			j = HIWORD(lParam);
			k = -1;
			if ((j>=116)&&(j<=276))
			{
				if ((i>=MAINPAL_POSX)&&(i<=MAINPAL_POSX+128))
					k = 0;
				else if ((i>=SUBPAL_POSX)&&(i<=SUBPAL_POSX+128))
					k = 1;
			}
			if (k == -1)
				if ((j>=116+80)&&(j<=276))
					if ((i>=EXTPAL_POSX)&&(i<=EXTPAL_POSX+128))
						k = 2;
			if (k != -1)
			{
				palSel = k;
				colSel = ((j-116)/5)<<4;
				if (i>=EXTPAL_POSX)
				{
					i -= EXTPAL_POSX;
					colSel -= 256;
				} else if (i>=SUBPAL_POSX) 
					i -= SUBPAL_POSX;
				else
					i -= MAINPAL_POSX;
				colSel += (i>>3);

				if (romLoaded)
				{
					if (palSel==2)
					{
						if ((extBank==0)||(extBank==3))
							i = extSet;
						else
							i = extSet & 1;
						currCol = *(unsigned short int*)(pageTable[0x60] + (lcdc_banks[extBank]&0xFFFFF) + (i<<13) + (extPal<<9) + (colSel<<1));
					} else
					{
						currCol = mmu_read_word(0x5000000+(palSel<<10)+(colSel<<1));
					}
				} else
				{
					currCol = (short)GetSysColor(COLOR_MENU);
					currCol = (currCol>>3)&31;
					currCol |= (currCol<<5)|(currCol<<10);
				}

				for (i=0; i<3; i++)
				{
					hCtl = GetDlgItem(hdlg,IDC_SLIDER1+i);
					SendMessage(hCtl,TBM_SETPOS,TRUE,currCol&31);
					hCtl = GetDlgItem(hdlg,IDC_STATIC_R+i);
					wsprintf(szBuffer,"%d",currCol&31);
					SetWindowText(hCtl,szBuffer);
					currCol >>= 5;
				}

				rect2.left = 8;
				rect2.top = 8;
				rect2.right = 200;
				rect2.bottom = 80;
				InvalidateRect(hdlg,&rect2,FALSE);
			}
			break;

		case WM_PAINT:
			BeginPaint(hdlg,&ps);
			MoveToEx(paldc, 8, 82, NULL);
			LineTo(paldc, 440,82);

			if (romLoaded)
			{
				if (palSel==2)
				{
					if ((extBank==0)||(extBank==3))
						i = extSet;
					else
						i = extSet & 1;
					currCol = *(unsigned short int*)(pageTable[0x60] + (lcdc_banks[extBank]&0xFFFFF) + (i<<13) + (extPal<<9) + (colSel<<1));

				} else
				{
					currCol = mmu_read_word(0x5000000+(palSel<<10)+(colSel<<1));
				}
			} else
			{
				currCol = GetSysColor(COLOR_MENU);
				currCol = (currCol>>3)&31;
				currCol |= (currCol<<5)|(currCol<<10);
			}
			hbrCol = CreateSolidBrush(RGB((currCol&31)<<3,(currCol>>2)&0xF8,(currCol>>7)&0xF8));
			SelectObject(paldc,hbrCol);
			Rectangle(paldc,8,16+10,56,64+10);
			DeleteObject(hbrCol);

			if (palSel==0)
			{
				if (colSel<256)
					wsprintf(szBuffer,"Main BG color %d",colSel);
				else
					wsprintf(szBuffer,"Main OBJ color %d",colSel-256);
			} else if (palSel==1)
			{
				if (colSel<256)
					wsprintf(szBuffer,"Sub BG color %d",colSel);
				else
					wsprintf(szBuffer,"Sub OBJ color %d",colSel-256);
			} else
			{
				wsprintf(szBuffer,"Extended color %d",colSel);
			}
			hCtl = GetDlgItem(hdlg,IDC_STATIC_C);
			SetWindowText(hCtl,szBuffer);

			wsprintf(szBuffer,"R:%d  G:%d  B:%d",currCol&31,(currCol>>5)&31,(currCol>>10)&31);
			hCtl = GetDlgItem(hdlg,IDC_STATIC_RGB);
			SetWindowText(hCtl,szBuffer);

			if (romLoaded)
			{
				pdib = (palette_dib*)gpu_get(GPU_PALETTE);				
				StretchDIBits(paldc,MAINPAL_POSX,116,128,160,0,32,16,32,
							  pdib->data,(BITMAPINFO*)&pdib->bih,DIB_RGB_COLORS,SRCCOPY);
				StretchDIBits(paldc,SUBPAL_POSX,116,128,160,0,0,16,32,
							  pdib->data,(BITMAPINFO*)&pdib->bih,DIB_RGB_COLORS,SRCCOPY);

				if ((extBank==0)||(extBank==3))
					i = extSet;
				else
					i = extSet & 1;
				p = (unsigned short int*)(pageTable[0x60] + (lcdc_banks[extBank]&0xFFFFF) + (i<<13) + (extPal<<9));
				pdib->data = (char*)p;
				pdib->bih.biHeight = -16;
				StretchDIBits(paldc,EXTPAL_POSX,116+80,128,80,0,0,16,16,
							  pdib->data,(BITMAPINFO*)&pdib->bih,DIB_RGB_COLORS,SRCCOPY);
			}

			for (i=0; i<=16; i++)
			{
				MoveToEx(paldc,8+(i*8),116,NULL);
				LineTo(paldc,8+(i*8),276);
				MoveToEx(paldc,SUBPAL_POSX+(i*8),116,NULL);
				LineTo(paldc,SUBPAL_POSX+(i*8),276);
				MoveToEx(paldc,EXTPAL_POSX+(i*8),116+80,NULL);
				LineTo(paldc,EXTPAL_POSX+(i*8),276);
			}

			for (i=0; i<=32; i++)
			{
				MoveToEx(paldc,MAINPAL_POSX,116+(i*5),NULL);
				LineTo(paldc,MAINPAL_POSX+128,116+(i*5));
				MoveToEx(paldc,SUBPAL_POSX,116+(i*5),NULL);
				LineTo(paldc,SUBPAL_POSX+128,116+(i*5));
				if (i>=16)
				{
					MoveToEx(paldc,EXTPAL_POSX,116+(i*5),NULL);
					LineTo(paldc,EXTPAL_POSX+128,116+(i*5));
				}
			}
			
			EndPaint(hdlg,&ps);
			return 0;

				

		case WM_COMMAND:
			switch(LOWORD(wParam)) {
				case IDC_COMBO1:
					if (HIWORD(wParam)==CBN_SELCHANGE)
					{
						hCmb = GetDlgItem(hdlg,IDC_COMBO1);
						extBank = SendMessage(hCmb,CB_GETCURSEL,0,0);
						InvalidateRect(hdlg,NULL,FALSE);
					}
					return 0;
				case IDC_COMBO2:
					if (HIWORD(wParam)==CBN_SELCHANGE)
					{
						hCmb = GetDlgItem(hdlg,IDC_COMBO2);
						extSet = SendMessage(hCmb,CB_GETCURSEL,0,0);
						InvalidateRect(hdlg,NULL,FALSE);
					}
					return 0;
				case IDC_COMBO3:
					if (HIWORD(wParam)==CBN_SELCHANGE)
					{
						hCmb = GetDlgItem(hdlg,IDC_COMBO3);
						palUpdateMode &= ~3;
						palUpdateMode |= SendMessage(hCmb,CB_GETCURSEL,0,0);
					}
					return 0;

				case IDC_CHECK1:
					hCtl = GetDlgItem(hdlg,IDC_CHECK1);
					if (SendMessage(hCtl,BM_GETCHECK,0,0)==BST_CHECKED) 
						palUpdateMode |= 4;
					else
						palUpdateMode &= ~4;
					return 0;

				case IDOK:
					ReleaseDC(hdlg,paldc);
					EndDialog(hdlg, 0);
					windows[3].active = false;
					return TRUE;

					case ID_PAL_LOAD:	// Load palette
						if (!romLoaded)
							return 0;
						if (!get_openfilename(szFnBuffer,"Load Palette","MS PAL files (*.pal)\0*.pal\0"))
						{
							return 0;
						}
						hFile = CreateFile(szFnBuffer, GENERIC_READ, 0, NULL, OPEN_EXISTING,
										   FILE_ATTRIBUTE_NORMAL|FILE_FLAG_SEQUENTIAL_SCAN,
										   NULL);
						if (hFile == INVALID_HANDLE_VALUE)
							return 0;

						if (GetFileSize(hFile,NULL) != 1048)
						{
							CloseHandle(hFile);
							return 0;
						}
						if (romLoaded)
						{
							ReadFile(hFile,&mspal,24,&dwBytesRead,NULL);
							if (palSel == 2)
							{
								if ((extBank==0)||(extBank==3))
									i = extSet;
								else
									i = extSet & 1;
								p = (unsigned short int*)(pageTable[0x68] + (lcdc_banks[extBank]&0xFFFFF) + (i<<13) + (extPal<<9));

							} else
								p = (unsigned short int*)(pageTable[0x50] + (palSel<<10) + ((colSel&0x100)<<1));
							i = mspal.sNumColors;
							if (i>256) i = 256;
							ReadFile(hFile,mspal.cData,i*4,&dwBytesRead,NULL);
							CloseHandle(hFile);
							k = 0;
							for (j=0; j<i; j++)
							{
								p[j] = (mspal.cData[k+0]>>3) |
									   ((mspal.cData[k+1]>>3)<<5) |
									   ((mspal.cData[k+2]>>3)<<10);
								k += 4;
							}
							rect2.left = 8;
							rect2.top = 8;
							rect2.right = 200;
							rect2.bottom = 80;
							InvalidateRect(hdlg,&rect2,FALSE);
						}
						return 0;

					case ID_PAL_SAVE:	// Save palette
						if (!romLoaded)
							return 0;
						if (!get_savefilename(szFnBuffer,"Save Palette","MS PAL files (*.pal)\0*.pal\0"))
						{
							return 0;
						}
						hFile = CreateFile(szFnBuffer, GENERIC_WRITE, 0, NULL, CREATE_ALWAYS,
										   FILE_ATTRIBUTE_NORMAL|FILE_FLAG_SEQUENTIAL_SCAN,
										   NULL);
						if (hFile == INVALID_HANDLE_VALUE)
							return 0;

						if (romLoaded)
						{
							mspal.dwSignature = *(DWORD*)&szRIFF;
							mspal.dwFileLength = 1040;
							mspal.dwRIFFType = *(DWORD*)&szPAL;
							mspal.dwRIFFSignature = *(DWORD*)&szdata;
							mspal.dwChunkSize = 1028;
							mspal.sPalVersion = 0x300;
							mspal.sNumColors = 256;

							if (palSel == 2)
							{
								if ((extBank==0)||(extBank==3))
									i = extSet;
								else
									i = extSet & 1;
								p = (unsigned short int*)(pageTable[0x68] + (lcdc_banks[extBank]&0xFFFFF) + (i<<13) + (extPal<<9));

							} else
								p = (unsigned short int*)(pageTable[0x50] + (palSel<<10) + ((colSel&0x100)<<1));

							k = 0;
							for (j=0; j<256; j++)
							{
								mspal.cData[k+0] = (p[j]&0x1f)<<3;
								mspal.cData[k+1] = (p[j]&0x3e0)>>2;
								mspal.cData[k+2] = (p[j]&0x7c00)>>7;
								mspal.cData[k+3] = 0;
								k += 4;
							}
							WriteFile(hFile,&mspal,1048,&dwBytesRead,NULL);
							CloseHandle(hFile);
						}
						return 0;

				case IDCANCEL:
					ReleaseDC(hdlg,paldc);
					EndDialog(hdlg, 1);
					windows[3].active = false;
					return FALSE;

				default:
					break;
			}
			break;
   }

	return FALSE;
}



// IO viewer callback
BOOL CALLBACK DlgProc11(HWND hdlg, UINT msg, WPARAM wParam, LPARAM lParam)
{
	//static char stemp[64];
	int i,j,k,l;
	HWND hCmb,hCtl,hSize2;
	HWND hScroll;
	//static int mview=IDC_RADIO_B;
	static int ioRegSel=0;
	unsigned short int regVal;

   switch(msg) {
		case WM_INITDIALOG:
			SetWindowLong(hdlg, DWL_USER, lParam);

			iodc = GetDC(hdlg);

			hCmb = GetDlgItem(hdlg,IDC_COMBO3);
			SendMessage(hCmb,CB_ADDSTRING,0,(LPARAM)"0x04000000 - DISPCNT_L");
			SendMessage(hCmb,CB_ADDSTRING,0,(LPARAM)"0x04000002 - DISPCNT_H");
			SendMessage(hCmb,CB_ADDSTRING,0,(LPARAM)"0x04000004 - DISPSTAT");
			SendMessage(hCmb,CB_ADDSTRING,0,(LPARAM)"0x04000006 - VCOUNT");
			SendMessage(hCmb,CB_ADDSTRING,0,(LPARAM)"0x04000008 - BG0CNT");
			SendMessage(hCmb,CB_ADDSTRING,0,(LPARAM)"0x0400000A - BG1CNT");
			SendMessage(hCmb,CB_ADDSTRING,0,(LPARAM)"0x0400000C - BG2CNT");
			SendMessage(hCmb,CB_ADDSTRING,0,(LPARAM)"0x0400000E - BG3CNT");
			SendMessage(hCmb,CB_ADDSTRING,0,(LPARAM)"0x04000010 - BG0HOFS");
			SendMessage(hCmb,CB_ADDSTRING,0,(LPARAM)"0x04000012 - BG0VOFS");
			SendMessage(hCmb,CB_ADDSTRING,0,(LPARAM)"0x04000014 - BG1HOFS");
			SendMessage(hCmb,CB_ADDSTRING,0,(LPARAM)"0x04000016 - BG1VOFS");
			SendMessage(hCmb,CB_ADDSTRING,0,(LPARAM)"0x04000018 - BG2HOFS");
			SendMessage(hCmb,CB_ADDSTRING,0,(LPARAM)"0x0400001A - BG2VOFS");
			SendMessage(hCmb,CB_ADDSTRING,0,(LPARAM)"0x0400001C - BG3HOFS");
			SendMessage(hCmb,CB_ADDSTRING,0,(LPARAM)"0x0400001E - BG3VOFS");
			SendMessage(hCmb,CB_ADDSTRING,0,(LPARAM)"0x04000020 - BG2PA");
			SendMessage(hCmb,CB_ADDSTRING,0,(LPARAM)"0x04000022 - BG2PB");
			SendMessage(hCmb,CB_ADDSTRING,0,(LPARAM)"0x04000024 - BG2PC");
			SendMessage(hCmb,CB_ADDSTRING,0,(LPARAM)"0x04000026 - BG2PD");
			SendMessage(hCmb,CB_ADDSTRING,0,(LPARAM)"0x04000028 - BG2X_L");
			SendMessage(hCmb,CB_ADDSTRING,0,(LPARAM)"0x0400002A - BG2X_H");
			SendMessage(hCmb,CB_ADDSTRING,0,(LPARAM)"0x0400002C - BG2Y_L");
			SendMessage(hCmb,CB_ADDSTRING,0,(LPARAM)"0x0400002E - BG2Y_H");
			SendMessage(hCmb,CB_ADDSTRING,0,(LPARAM)"0x04000030 - BG3PA");
			SendMessage(hCmb,CB_ADDSTRING,0,(LPARAM)"0x04000032 - BG3PB");
			SendMessage(hCmb,CB_ADDSTRING,0,(LPARAM)"0x04000034 - BG3PC");
			SendMessage(hCmb,CB_ADDSTRING,0,(LPARAM)"0x04000036 - BG3PD");
			SendMessage(hCmb,CB_ADDSTRING,0,(LPARAM)"0x04000038 - BG3X_L");
			SendMessage(hCmb,CB_ADDSTRING,0,(LPARAM)"0x0400003A - BG3X_H");
			SendMessage(hCmb,CB_ADDSTRING,0,(LPARAM)"0x0400003C - BG3Y_L");
			SendMessage(hCmb,CB_ADDSTRING,0,(LPARAM)"0x0400003E - BG3Y_H");
			SendMessage(hCmb,CB_ADDSTRING,0,(LPARAM)"0x04000040 - WIN0H");
			SendMessage(hCmb,CB_ADDSTRING,0,(LPARAM)"0x04000042 - WIN1H");
			SendMessage(hCmb,CB_ADDSTRING,0,(LPARAM)"0x04000044 - WIN0V");
			SendMessage(hCmb,CB_ADDSTRING,0,(LPARAM)"0x04000046 - WIN1V");
			SendMessage(hCmb,CB_ADDSTRING,0,(LPARAM)"0x04000048 - WININ");
			SendMessage(hCmb,CB_ADDSTRING,0,(LPARAM)"0x0400004A - WINOUT");
			SendMessage(hCmb,CB_ADDSTRING,0,(LPARAM)"0x0400004C - MOSAIC");
			SendMessage(hCmb,CB_ADDSTRING,0,(LPARAM)"0x04000050 - BLDCNT");
			SendMessage(hCmb,CB_ADDSTRING,0,(LPARAM)"0x04000052 - BLDALPHA");
			SendMessage(hCmb,CB_ADDSTRING,0,(LPARAM)"0x04000054 - BLDY");

			SendMessage(hCmb,CB_ADDSTRING,0,(LPARAM)"0x04000068 - RAMFIFO_L");
			SendMessage(hCmb,CB_ADDSTRING,0,(LPARAM)"0x0400006A - RAMFIFO_H");
			SendMessage(hCmb,CB_ADDSTRING,0,(LPARAM)"0x0400006C - BRIGHTNESS");

			SendMessage(hCmb,CB_ADDSTRING,0,(LPARAM)"0x04000240 - VRAMCNT_AB");
			SendMessage(hCmb,CB_ADDSTRING,0,(LPARAM)"0x04000242 - VRAMCNT_CD");
			SendMessage(hCmb,CB_ADDSTRING,0,(LPARAM)"0x04000244 - VRAMCNT_EF");
			SendMessage(hCmb,CB_ADDSTRING,0,(LPARAM)"0x04000246 - VRAMCNT_G_WRAM");
			SendMessage(hCmb,CB_ADDSTRING,0,(LPARAM)"0x04000248 - VRAMCNT_HI");

			SendMessage(hCmb,CB_ADDSTRING,0,(LPARAM)"0x04000304 - POWERCNT");
			SendMessage(hCmb,CB_ADDSTRING,0,(LPARAM)"0x04001000 - DISPCNT_SUB_L");
			SendMessage(hCmb,CB_ADDSTRING,0,(LPARAM)"0x04001002 - DISPCNT_SUB_H");
	
			SendMessage(hCmb,CB_ADDSTRING,0,(LPARAM)"0x04001008 - BG0CNT_SUB");
			SendMessage(hCmb,CB_ADDSTRING,0,(LPARAM)"0x0400100A - BG1CNT_SUB");
			SendMessage(hCmb,CB_ADDSTRING,0,(LPARAM)"0x0400100C - BG2CNT_SUB");
			SendMessage(hCmb,CB_ADDSTRING,0,(LPARAM)"0x0400100E - BG3CNT_SUB");			
			SendMessage(hCmb,CB_ADDSTRING,0,(LPARAM)"0x04001050 - BLDCNT_SUB");
			SendMessage(hCmb,CB_ADDSTRING,0,(LPARAM)"0x04001052 - BLDALPHA_SUB");
			SendMessage(hCmb,CB_ADDSTRING,0,(LPARAM)"0x04001054 - BLDY_SUB");			
			SendMessage(hCmb,CB_SETCURSEL,ioRegSel,0);

			if (romLoaded)
				regVal = mmu_read_word(ioreg_address[ioRegSel]);
			else
				regVal = 0;
			hCtl = GetDlgItem(hdlg,IDC_STATIC_V);
			wsprintf(szBuffer,"0x%04X",regVal&0xFFFF);
			SetWindowText(hCtl,szBuffer);
			for (i=0; i<16; i++)
			{
				hCtl = GetDlgItem(hdlg,IDC_CHECK1+i);
				SendMessage(hCtl,BM_SETCHECK,(regVal&1),0);
				SetWindowText(hCtl,ioreg_descr[ioRegSel][i]);
				regVal >>= 1;
			}

			hCtl = GetDlgItem(hdlg,IDC_CHECK17);
			EnableWindow(hCtl,FALSE);

			return TRUE;


		case WM_SIZE:
			return 0;
					

		case WM_PAINT:
			BeginPaint(hdlg,&ps);
			
			MoveToEx(iodc, 8, 80, NULL);
			LineTo(iodc, 328,80);

			MoveToEx(iodc, 8, 408, NULL);
			LineTo(iodc, 328,408);

			EndPaint(hdlg,&ps);
			break;


		case WM_COMMAND:
			switch(LOWORD(wParam))
			{
				case IDC_COMBO3:
					if (HIWORD(wParam)==CBN_SELCHANGE)
					{
						hCmb = GetDlgItem(hdlg,IDC_COMBO3);
						ioRegSel = SendMessage(hCmb,CB_GETCURSEL,0,0);
						if (romLoaded)
							regVal = mmu_read_word(ioreg_address[ioRegSel]);
						else
							regVal = 0;
						hCtl = GetDlgItem(hdlg,IDC_STATIC_V);
						wsprintf(szBuffer,"0x%04X",regVal&0xFFFF);
						SetWindowText(hCtl,szBuffer);
						for (i=0; i<16; i++)
						{
							hCtl = GetDlgItem(hdlg,IDC_CHECK1+i);
							SendMessage(hCtl,BM_SETCHECK,(regVal&1),0);
							SetWindowText(hCtl,ioreg_descr[ioRegSel][i]);
							regVal >>= 1;
						}
						InvalidateRect(hdlg,NULL,TRUE);
					}
					return 0;

				case IDOK:
					ReleaseDC(hdlg,iodc);
					EndDialog(hdlg, 0);
					windows[7].active = false;
					return TRUE;

				case IDCANCEL:
				case IDCLOSE:
					ReleaseDC(hdlg,iodc);
					EndDialog(hdlg, 1);
					windows[7].active = false;
					return FALSE;

				default:
					break;
			}
			break;
   }

	return FALSE;
}




// Tile viewer callback
BOOL CALLBACK DlgProc12(HWND hdlg, UINT msg, WPARAM wParam, LPARAM lParam)
{
	int i,j,k,l;
	HWND hCmb,hCtl,hSize2;
	HWND hScroll;
	unsigned short int *paletteData;
	unsigned char *tileSrc,*vramPtr;
	static int twTileNum = 0, twTileBlock=0, twTileOffset=0;
	static int palType = 1, pal16PalPal = 0, pal16PalNum=0,
			   pal256Pal = 0, palExtPalBank=0, palExtPalSet=0,palExtPalNum = 0;

   switch(msg)
   {
		case WM_INITDIALOG:
			SetWindowLong(hdlg, DWL_USER, lParam);

			twdc = GetDC(hdlg);

			hCmb = GetDlgItem(hdlg,IDC_COMBO1);
			SendMessage(hCmb,CB_ADDSTRING,0,(LPARAM)"0");
			SendMessage(hCmb,CB_ADDSTRING,0,(LPARAM)"1");
			SendMessage(hCmb,CB_ADDSTRING,0,(LPARAM)"2");
			SendMessage(hCmb,CB_ADDSTRING,0,(LPARAM)"3");
			SendMessage(hCmb,CB_ADDSTRING,0,(LPARAM)"4");
			SendMessage(hCmb,CB_ADDSTRING,0,(LPARAM)"5");
			SendMessage(hCmb,CB_ADDSTRING,0,(LPARAM)"6");
			SendMessage(hCmb,CB_ADDSTRING,0,(LPARAM)"7");
			SendMessage(hCmb,CB_ADDSTRING,0,(LPARAM)"8");
			SendMessage(hCmb,CB_ADDSTRING,0,(LPARAM)"9");
			SendMessage(hCmb,CB_ADDSTRING,0,(LPARAM)"10");
			SendMessage(hCmb,CB_ADDSTRING,0,(LPARAM)"11");
			SendMessage(hCmb,CB_ADDSTRING,0,(LPARAM)"12");
			SendMessage(hCmb,CB_ADDSTRING,0,(LPARAM)"13");
			SendMessage(hCmb,CB_ADDSTRING,0,(LPARAM)"14");
			SendMessage(hCmb,CB_ADDSTRING,0,(LPARAM)"15");
			SendMessage(hCmb,CB_SETCURSEL,pal16PalNum,0);

			hCmb = GetDlgItem(hdlg,IDC_COMBO2);
			SendMessage(hCmb,CB_ADDSTRING,0,(LPARAM)"Bank E");
			SendMessage(hCmb,CB_ADDSTRING,0,(LPARAM)"Bank F");
			SendMessage(hCmb,CB_ADDSTRING,0,(LPARAM)"Bank G");
			SendMessage(hCmb,CB_ADDSTRING,0,(LPARAM)"Bank H");
			SendMessage(hCmb,CB_SETCURSEL,palExtPalBank,0);

			hCmb = GetDlgItem(hdlg,IDC_COMBO3);
			SendMessage(hCmb,CB_ADDSTRING,0,(LPARAM)"Set 0");
			SendMessage(hCmb,CB_ADDSTRING,0,(LPARAM)"Set 1");
			SendMessage(hCmb,CB_ADDSTRING,0,(LPARAM)"Set 2");
			SendMessage(hCmb,CB_ADDSTRING,0,(LPARAM)"Set 3");
			SendMessage(hCmb,CB_SETCURSEL,palExtPalSet,0);

			hCmb = GetDlgItem(hdlg,IDC_COMBO4);
			SendMessage(hCmb,CB_ADDSTRING,0,(LPARAM)"0");
			SendMessage(hCmb,CB_ADDSTRING,0,(LPARAM)"1");
			SendMessage(hCmb,CB_ADDSTRING,0,(LPARAM)"2");
			SendMessage(hCmb,CB_ADDSTRING,0,(LPARAM)"3");
			SendMessage(hCmb,CB_ADDSTRING,0,(LPARAM)"4");
			SendMessage(hCmb,CB_ADDSTRING,0,(LPARAM)"5");
			SendMessage(hCmb,CB_ADDSTRING,0,(LPARAM)"6");
			SendMessage(hCmb,CB_ADDSTRING,0,(LPARAM)"7");
			SendMessage(hCmb,CB_ADDSTRING,0,(LPARAM)"8");
			SendMessage(hCmb,CB_ADDSTRING,0,(LPARAM)"9");
			SendMessage(hCmb,CB_ADDSTRING,0,(LPARAM)"10");
			SendMessage(hCmb,CB_ADDSTRING,0,(LPARAM)"11");
			SendMessage(hCmb,CB_ADDSTRING,0,(LPARAM)"12");
			SendMessage(hCmb,CB_ADDSTRING,0,(LPARAM)"13");
			SendMessage(hCmb,CB_ADDSTRING,0,(LPARAM)"14");
			SendMessage(hCmb,CB_ADDSTRING,0,(LPARAM)"15");
			SendMessage(hCmb,CB_SETCURSEL,twTileBlock,0);

			hCmb = GetDlgItem(hdlg,IDC_COMBO5);
			SendMessage(hCmb,CB_ADDSTRING,0,(LPARAM)"0x00000");
			SendMessage(hCmb,CB_ADDSTRING,0,(LPARAM)"0x10000");
			SendMessage(hCmb,CB_ADDSTRING,0,(LPARAM)"0x20000");
			SendMessage(hCmb,CB_ADDSTRING,0,(LPARAM)"0x30000");
			SendMessage(hCmb,CB_ADDSTRING,0,(LPARAM)"0x40000");
			SendMessage(hCmb,CB_ADDSTRING,0,(LPARAM)"0x50000");
			SendMessage(hCmb,CB_ADDSTRING,0,(LPARAM)"0x60000");
			SendMessage(hCmb,CB_ADDSTRING,0,(LPARAM)"0x70000");
			SendMessage(hCmb,CB_SETCURSEL,twTileOffset,0);

			hCmb = GetDlgItem(hdlg,IDC_COMBO6);
			SendMessage(hCmb,CB_ADDSTRING,0,(LPARAM)"Palette 0");
			SendMessage(hCmb,CB_ADDSTRING,0,(LPARAM)"Palette 1");
			SendMessage(hCmb,CB_ADDSTRING,0,(LPARAM)"Palette 2");
			SendMessage(hCmb,CB_ADDSTRING,0,(LPARAM)"Palette 3");
			SendMessage(hCmb,CB_ADDSTRING,0,(LPARAM)"Palette 4");
			SendMessage(hCmb,CB_ADDSTRING,0,(LPARAM)"Palette 5");
			SendMessage(hCmb,CB_ADDSTRING,0,(LPARAM)"Palette 6");
			SendMessage(hCmb,CB_ADDSTRING,0,(LPARAM)"Palette 7");
			SendMessage(hCmb,CB_ADDSTRING,0,(LPARAM)"Palette 8");
			SendMessage(hCmb,CB_ADDSTRING,0,(LPARAM)"Palette 9");
			SendMessage(hCmb,CB_ADDSTRING,0,(LPARAM)"Palette 10");
			SendMessage(hCmb,CB_ADDSTRING,0,(LPARAM)"Palette 11");
			SendMessage(hCmb,CB_ADDSTRING,0,(LPARAM)"Palette 12");
			SendMessage(hCmb,CB_ADDSTRING,0,(LPARAM)"Palette 13");
			SendMessage(hCmb,CB_ADDSTRING,0,(LPARAM)"Palette 14");
			SendMessage(hCmb,CB_ADDSTRING,0,(LPARAM)"Palette 15");
			SendMessage(hCmb,CB_SETCURSEL,palExtPalNum,0);

			hCmb = GetDlgItem(hdlg,IDC_COMBO7);
			SendMessage(hCmb,CB_ADDSTRING,0,(LPARAM)"Main BG");
			SendMessage(hCmb,CB_ADDSTRING,0,(LPARAM)"Main OBJ");
			SendMessage(hCmb,CB_ADDSTRING,0,(LPARAM)"Sub BG");
			SendMessage(hCmb,CB_ADDSTRING,0,(LPARAM)"Sub OBJ");
			SendMessage(hCmb,CB_SETCURSEL,pal256Pal,0);

			hCmb = GetDlgItem(hdlg,IDC_COMBO8);
			SendMessage(hCmb,CB_ADDSTRING,0,(LPARAM)"Main BG");
			SendMessage(hCmb,CB_ADDSTRING,0,(LPARAM)"Main OBJ");
			SendMessage(hCmb,CB_ADDSTRING,0,(LPARAM)"Sub BG");
			SendMessage(hCmb,CB_ADDSTRING,0,(LPARAM)"Sub OBJ");
			SendMessage(hCmb,CB_SETCURSEL,pal16PalPal,0);

			hCtl = GetDlgItem(hdlg,IDC_RADIO1+palType);
			SendMessage(hCtl,BM_SETCHECK,1,0);

			/*hCtl = GetDlgItem(hdlg,IDC_SLIDER1);
			SendMessage(hCtl,TBM_SETRANGE,FALSE,MAKELONG(0,255));
			SendMessage(hCtl,TBM_SETPOS,TRUE,twTileNum);*/
			hScroll = GetDlgItem(hdlg,IDC_SCROLLBAR1);
			ZeroMemory(&si4, sizeof(si4));
			si4.cbSize = sizeof(si);
			si4.fMask  = SIF_RANGE | SIF_PAGE | SIF_POS;
			si4.nMin   = 0;
			si4.nMax   = 255;
			si4.nPage  = 1;
			si4.nPos   = twTileNum; 
			SetScrollInfo(hScroll, SB_CTL, &si4, TRUE);

			hCtl = GetDlgItem(hdlg,IDC_STATIC_TILENUM);
			wsprintf(szBuffer,"%d",twTileNum);
			SetWindowText(hCtl,szBuffer);		

			tile.data = (char*)&tileData[0];
			memset(&tile.bih,0,sizeof(BITMAPINFOHEADER));
 			tile.bih.biSize = sizeof(BITMAPINFOHEADER);
 			tile.bih.biWidth = 8;
 			tile.bih.biHeight = -8;
 			tile.bih.biPlanes = 1;
 			tile.bih.biBitCount = 16;
  			tile.bih.biCompression = BI_BITFIELDS;
			*((int*)&tile.colors[0]) = 0x001F;	// 00000000 000rrrrr
			*((int*)&tile.colors[1]) = 0x03E0;	// 000000gg ggg00000
			*((int*)&tile.colors[2]) = 0x7C00;	// 0bbbbb00 00000000

			vramPtr = (unsigned char*)gpu_get(GPU_MEMORY);

			return TRUE;


		/*case WM_HSCROLL:
			hScroll = GetDlgItem(hdlg,IDC_SLIDER1);
			if ((HWND)lParam == hScroll)
			{
				twTileNum = SendMessage(hScroll,TBM_GETPOS,0,0);
				hCtl = GetDlgItem(hdlg,IDC_STATIC_TILENUM);
				wsprintf(szBuffer,"%d",twTileNum);
				SetWindowText(hCtl,szBuffer);
			}
			return 0;*/
		case WM_HSCROLL:
			hScroll = GetDlgItem(hdlg,IDC_SCROLLBAR1);
			if ((HWND)lParam != hScroll) return 0;

			twTileNum = GetScrollPos(hScroll, SB_CTL);
			switch (LOWORD(wParam))
			{
				case SB_TOP:
						twTileNum = 0;
						break;

				case SB_LINEUP:
						if (twTileNum > 0)
								twTileNum--;
						break;
				case SB_PAGEUP:
						if (twTileNum > 1)
								twTileNum -= 2;;
						break;

				case SB_THUMBPOSITION:
						twTileNum = HIWORD(wParam);
						break;

				case SB_THUMBTRACK:
						twTileNum = HIWORD(wParam);
						break;

				case SB_LINEDOWN:
						if (twTileNum < 255)
								twTileNum++;
						break;
				case SB_PAGEDOWN:
						if (twTileNum < 254)
								twTileNum += 2;
						break;

				case SB_BOTTOM:
						twTileNum = 255;
						break;
			}
			hCtl = GetDlgItem(hdlg,IDC_STATIC_TILENUM);
			wsprintf(szBuffer,"%d",twTileNum);
			SetWindowText(hCtl,szBuffer);
			SetScrollPos(hScroll, SB_CTL, twTileNum, TRUE);
			rect2.top = 8;
			rect2.left = 12;
			rect2.right = rect2.bottom = 64;
			InvalidateRect(hdlg,&rect2,TRUE);
			return 0;


		case WM_SIZE:
			return 0;
					

		case WM_PAINT:
			BeginPaint(hdlg,&ps);
			
			/*MoveToEx(twdc, 8, 80, NULL);
			LineTo(twdc, 328,80);

			MoveToEx(iodc, 8, 408, NULL);
			LineTo(iodc, 328,408);*/
			if (romLoaded)
			{
				switch (palType)
				{
					case 0:
						paletteData = (unsigned short int*)(pageTable[0x50] + (pal16PalPal<<9) + (pal16PalNum<<5));
						tileSrc = (unsigned char *)(pageTable[0x60] + (twTileOffset<<16) + (twTileBlock<<14) + (twTileNum<<5));
						for (i=0; i<32; i++)
						{
							tileData[i+i] = paletteData[tileSrc[i]&0xF];
							tileData[i+i+1] = paletteData[(tileSrc[i]>>4)&0xF];
						}
						break;
					case 1:
						paletteData = (unsigned short int*)(pageTable[0x50] + (pal256Pal<<9));
						tileSrc = (unsigned char *)(pageTable[0x60] + (twTileOffset<<16) + (twTileBlock<<14) + (twTileNum<<6));
						for (i=0; i<64; i++)
						{
							tileData[i] = paletteData[tileSrc[i]];
						}
						break;
					case 2:
						paletteData = (unsigned short int*)(pageTable[0x60] + (lcdc_banks[palExtPalBank]&0xFFFFF) + (palExtPalSet<<13) + (palExtPalNum<<9));
						tileSrc = (unsigned char *)(pageTable[0x60] + (twTileOffset<<16) + (twTileBlock<<14) + (twTileNum<<6));
						for (i=0; i<64; i++)
						{
							tileData[i] = paletteData[tileSrc[i]];
						}
						break;
				}
				StretchDIBits(twdc,12,8,64,64,0,0,8,8,
							  tile.data,(BITMAPINFO*)&tile.bih,DIB_RGB_COLORS,SRCCOPY);
			}

			EndPaint(hdlg,&ps);
			break;


		case WM_COMMAND:
			switch(LOWORD(wParam))
			{
				case IDC_COMBO1:
					if (HIWORD(wParam)==CBN_SELCHANGE)
					{
						hCmb = GetDlgItem(hdlg,IDC_COMBO1);
						pal16PalNum = SendMessage(hCmb,CB_GETCURSEL,0,0);
						InvalidateRect(hdlg,NULL,FALSE);
					}
					return 0;
				case IDC_COMBO2:
					if (HIWORD(wParam)==CBN_SELCHANGE)
					{
						hCmb = GetDlgItem(hdlg,IDC_COMBO2);
						palExtPalBank = SendMessage(hCmb,CB_GETCURSEL,0,0);
						InvalidateRect(hdlg,NULL,FALSE);
					}
					return 0;
				case IDC_COMBO3:
					if (HIWORD(wParam)==CBN_SELCHANGE)
					{
						hCmb = GetDlgItem(hdlg,IDC_COMBO3);
						palExtPalSet = SendMessage(hCmb,CB_GETCURSEL,0,0);
						InvalidateRect(hdlg,NULL,FALSE);
					}
					return 0;
				case IDC_COMBO4:
					if (HIWORD(wParam)==CBN_SELCHANGE)
					{
						hCmb = GetDlgItem(hdlg,IDC_COMBO4);
						twTileBlock = SendMessage(hCmb,CB_GETCURSEL,0,0);
						InvalidateRect(hdlg,NULL,FALSE);
					}
					return 0;
				case IDC_COMBO5:
					if (HIWORD(wParam)==CBN_SELCHANGE)
					{
						hCmb = GetDlgItem(hdlg,IDC_COMBO5);
						twTileOffset = SendMessage(hCmb,CB_GETCURSEL,0,0);
						InvalidateRect(hdlg,NULL,FALSE);
					}
					return 0;
				case IDC_COMBO6:
					if (HIWORD(wParam)==CBN_SELCHANGE)
					{
						hCmb = GetDlgItem(hdlg,IDC_COMBO6);
						palExtPalNum = SendMessage(hCmb,CB_GETCURSEL,0,0);
						InvalidateRect(hdlg,NULL,FALSE);
					}
					return 0;
				case IDC_COMBO7:
					if (HIWORD(wParam)==CBN_SELCHANGE)
					{
						hCmb = GetDlgItem(hdlg,IDC_COMBO7);
						pal256Pal = SendMessage(hCmb,CB_GETCURSEL,0,0);
						InvalidateRect(hdlg,NULL,FALSE);
					}
					return 0;
				case IDC_COMBO8:
					if (HIWORD(wParam)==CBN_SELCHANGE)
					{
						hCmb = GetDlgItem(hdlg,IDC_COMBO8);
						pal16PalPal = SendMessage(hCmb,CB_GETCURSEL,0,0);
						InvalidateRect(hdlg,NULL,FALSE);
					}
					return 0;

				case IDC_RADIO1:
				case IDC_RADIO2:
				case IDC_RADIO_D3D:
					if (HIWORD(wParam)==BN_CLICKED)
					{
						if ((LOWORD(wParam)==IDC_RADIO1)&&(palType!=0))
						{
							hScroll = GetDlgItem(hdlg,IDC_SCROLLBAR1);
							si4.nMax   = 511;
							si4.nPos   = twTileNum; 
							SetScrollInfo(hScroll, SB_CTL, &si4, TRUE);
						}
						if ((LOWORD(wParam)!=IDC_RADIO1)&&(palType==0))
						{
							hScroll = GetDlgItem(hdlg,IDC_SCROLLBAR1);
							twTileNum >>= 1;
							si4.nMax   = 255;
							si4.nPos   = twTileNum; 
							SetScrollInfo(hScroll, SB_CTL, &si4, TRUE);
							hCtl = GetDlgItem(hdlg,IDC_STATIC_TILENUM);
							wsprintf(szBuffer,"%d",twTileNum);
							SetWindowText(hCtl,szBuffer);
						}
						palType = LOWORD(wParam) - IDC_RADIO1;
						InvalidateRect(hdlg,NULL,FALSE);
					}
					return 0;

				case IDOK:
					ReleaseDC(hdlg,twdc);
					EndDialog(hdlg, 0);
					windows[8].active = false;
					return TRUE;

				case IDCANCEL:
				case IDCLOSE:
					ReleaseDC(hdlg,twdc);
					EndDialog(hdlg, 1);
					windows[8].active = false;
					return FALSE;

				default:
					break;
			}
			break;
   }

   
	return FALSE;
}



// Breakpoint viewer callback
BOOL CALLBACK DlgProc13(HWND hdlg, UINT msg, WPARAM wParam, LPARAM lParam)
{
	int i,j,k,l,factor;
	unsigned int bkptAddr;
	HWND hCmb,hCtl,hSize2;
	HWND hScroll;

   switch(msg) {
		case WM_INITDIALOG:
			SetWindowLong(hdlg, DWL_USER, lParam);

			hCmb = GetDlgItem(hdlg,IDC_COMBO1);
			SendMessage(hCmb,CB_ADDSTRING,0,(LPARAM)"ARM9 execute at");
			SendMessage(hCmb,CB_ADDSTRING,0,(LPARAM)"ARM9 read from");
			SendMessage(hCmb,CB_ADDSTRING,0,(LPARAM)"ARM9 write to");
			SendMessage(hCmb,CB_ADDSTRING,0,(LPARAM)"ARM9 read byte from");
			SendMessage(hCmb,CB_ADDSTRING,0,(LPARAM)"ARM9 read hword from");
			SendMessage(hCmb,CB_ADDSTRING,0,(LPARAM)"ARM9 read word from");
			SendMessage(hCmb,CB_ADDSTRING,0,(LPARAM)"ARM9 write byte to");
			SendMessage(hCmb,CB_ADDSTRING,0,(LPARAM)"ARM9 write hword to");
			SendMessage(hCmb,CB_ADDSTRING,0,(LPARAM)"ARM9 write word to");
			SendMessage(hCmb,CB_ADDSTRING,0,(LPARAM)"ARM7 execute at");
			SendMessage(hCmb,CB_ADDSTRING,0,(LPARAM)"ARM7 read byte from");
			SendMessage(hCmb,CB_ADDSTRING,0,(LPARAM)"ARM7 read hword from");
			SendMessage(hCmb,CB_ADDSTRING,0,(LPARAM)"ARM7 read word from");
			SendMessage(hCmb,CB_SETCURSEL,0,0);
			EnableWindow(hCmb,FALSE);

			return TRUE;


		case WM_HSCROLL:
			/*hScroll = GetDlgItem(hdlg,IDC_SLIDER1);
			if ((HWND)lParam == hScroll)
			{
				twTileNum = SendMessage(hScroll,TBM_GETPOS,0,0);
				hCtl = GetDlgItem(hdlg,IDC_STATIC_TILENUM);
				wsprintf(szBuffer,"%d",twTileNum);
				SetWindowText(hCtl,szBuffer);
			}*/
			return 0;


		case WM_SIZE:
			return 0;
					

		case WM_PAINT:
			BeginPaint(hdlg,&ps);
			
			/*MoveToEx(twdc, 8, 80, NULL);
			LineTo(twdc, 328,80);

			MoveToEx(iodc, 8, 408, NULL);
			LineTo(iodc, 328,408);*/

			EndPaint(hdlg,&ps);
			break;


		case WM_COMMAND:
			switch(LOWORD(wParam))
			{
				case IDC_COMBO3:
					if (HIWORD(wParam)==CBN_SELCHANGE)
					{
						//hCmb = GetDlgItem(hdlg,IDC_COMBO3);
						//ioRegSel = SendMessage(hCmb,CB_GETCURSEL,0,0);
					}
					return 0;

				case IDC_BUTTON5:
					hCtl = GetDlgItem(hdlg,IDC_EDIT1);
					GetWindowText(hCtl,szBuffer,10);
					factor = 10; // decimal
					j = strlen(szBuffer);
					if (j==0)
					{
						MessageBox(NULL,"No address entered","Error",MB_ICONINFORMATION);
						return 0;
					}
					if (j>=3)
						if (szBuffer[1]=='x')
							factor = 16; // hexadecimal
					k = 1;
					bkptAddr = 0;
					if (factor == 10)
						for (; j>0; j--)
						{
							if ((szBuffer[j-1]>='0')&&(szBuffer[j-1]<='9'))
								bkptAddr += (szBuffer[j-1]-'0')*k;
							else
							{
								MessageBox(NULL,"Not a valid address","Error",MB_ICONINFORMATION);
								return 0;
							}
							k *= 10;
						}
					else
						for (; j>2; j--)
						{
							if ((szBuffer[j-1]>='0')&&(szBuffer[j-1]<='9'))
								bkptAddr += (szBuffer[j-1]-'0')*k;
							else if ((szBuffer[j-1]>='a')&&(szBuffer[j-1]<='f'))
								bkptAddr += (szBuffer[j-1]+10-'a')*k;
							else if ((szBuffer[j-1]>='A')&&(szBuffer[j-1]<='F'))
								bkptAddr += (szBuffer[j-1]+10-'A')*k;
							else
							{
								MessageBox(NULL,"Not a valid address","Error",MB_ICONINFORMATION);
								return 0;
							}
							k *= 16;
						}

					hCtl = GetDlgItem(hdlg,IDC_LIST1);
					wsprintf(szBuffer,"ARM9 EXC -- 0x%08X",bkptAddr);
					SendMessage(hCtl,LB_ADDSTRING,0,(LPARAM)szBuffer);
					return 0;


				case IDOK:
					//ReleaseDC(hdlg,twdc);
					EndDialog(hdlg, 0);
					windows[9].active = false;
					return TRUE;

				case IDCANCEL:
				case IDCLOSE:
					//ReleaseDC(hdlg,twdc);
					EndDialog(hdlg, 1);
					windows[9].active = false;
					return FALSE;

				default:
					break;
			}
			break;
   }

	return FALSE;
}



// Video output callback
BOOL CALLBACK DlgProc14(HWND hdlg, UINT msg, WPARAM wParam, LPARAM lParam)
{
	int i,j,k;
	HWND hCmb,hCtl,hSize2;

   switch(msg)
   {
		case WM_KEYDOWN:
			switch (wParam)
			{
				case VK_F5:
					if (romLoaded)
						run = true;
					break;
				case VK_F6:
					if (romLoaded)
						run = false;
					break;
				case VK_F7:
					if (romLoaded)
						reset_machine(false);
					break;				
			}
			return 0;

		case WM_MOUSEMOVE:
			touch.x = touch.y = touch.z = 0;
			if (GET_Y_LPARAM(lParam)>=192)
			{
				if (wParam & MK_LBUTTON)
				{
					touch.x = GET_X_LPARAM(lParam); //+13;
					touch.y = GET_Y_LPARAM(lParam)+16-192;
					touch.z = -1;
					if (touch.x<0) touch.x = 0; if (touch.x>255) touch.x = 255;
				} 
			}
			return 0;
		case WM_LBUTTONDOWN:
			if (GET_Y_LPARAM(lParam)>=192)
			{
				touch.x = GET_X_LPARAM(lParam); //+13;
				touch.y = GET_Y_LPARAM(lParam)+16-192;
				touch.z = -1;
				if (touch.x<0) touch.x = 0; if (touch.x>255) touch.x = 255;
			}
				wsprintf(szBuffer,"x = %d, y = %d | ipc_x = %d, ipc_y = %d\n",
					touch.x,touch.y,touch.x*14,(touch.y*8917)>>9);
				WriteConsole(hOut,szBuffer,lstrlen(szBuffer),(LPDWORD)&i,NULL);
			return 0;

		case WM_LBUTTONUP:
			touch.x = 0;
			touch.y = 0;
			touch.z = 0;
			return 0;

		case WM_INITDIALOG:
			SetWindowLong(hdlg, DWL_USER, lParam);
			//force_window_size(hdlg,rect.right+24,rect.top,256,384);
			//UpdateWindow(hdlg);
			return TRUE;

		case WM_SIZE:
			return 0;


		case WM_COMMAND:
			switch(LOWORD(wParam))
			{
				case IDCLOSE:
					EndDialog(hdlg, 1);
					windows[2].active = false;
					return FALSE;

				default:
					break;
			}
			break;
   }

	return FALSE;
}



BOOL CALLBACK DlgProc15(HWND hdlg, UINT msg, WPARAM wParam, LPARAM lParam)
{
	int i,j,k,l;
	HWND hCmb,hCtl;

   switch(msg) {
		case WM_INITDIALOG:
			SetWindowLong(hdlg, DWL_USER, lParam);

			hCtl = GetDlgItem(hdlg,IDC_EDIT1);
			wsprintf(szBuffer,"0x%08x",dlg15EditVal);
			SetWindowText(hCtl,szBuffer);
			return TRUE;


		case WM_SIZE:
			return 0;
					

		case WM_COMMAND:
			switch(LOWORD(wParam))
			{

				case IDOK:
					hCtl = GetDlgItem(hdlg,IDC_EDIT1);
					
					GetWindowText(hCtl,szBuffer3,12);
					if (strlen(szBuffer3))
					{
						if (szBuffer3[0] != '0')
						{
							strcpy(szBuffer,"0x");
							strcat(szBuffer,szBuffer3);
						} else
						{
							strcpy(szBuffer,szBuffer3);
						}
						dlg15EditVal = strtoul(szBuffer,NULL,0); 
					}
					EndDialog(hdlg, 0);
					windows[10].active = false;
					return TRUE;

				case IDCANCEL:
				case IDCLOSE:
					EndDialog(hdlg, 1);
					windows[10].active = false;
					return FALSE;

				default:
					break;
			}
			break;
   }

	return FALSE;
}




// AVI recording setup dialog
BOOL CALLBACK DlgProc16(HWND hdlg, UINT msg, WPARAM wParam, LPARAM lParam)
{
	int i,j,k,l;
	HWND hCmb,hCtl;
	
   switch(msg) {
		case WM_INITDIALOG:
			SetWindowLong(hdlg, DWL_USER, lParam);
			
			hCtl = GetDlgItem(hdlg,IDC_CHECK1);
			SendMessage(hCtl,BM_SETCHECK,(recordMain)?BST_CHECKED:BST_UNCHECKED,0);
			hCtl = GetDlgItem(hdlg,IDC_CHECK3);
			SendMessage(hCtl,BM_SETCHECK,(recordSub)?BST_CHECKED:BST_UNCHECKED,0);

			hCtl = GetDlgItem(hdlg,IDC_EDIT1);
			wsprintf(szBuffer,"%d",aviRate);
			SetWindowText(hCtl,szBuffer);

			hCtl = GetDlgItem(hdlg,IDC_STATIC_FN);
			SetWindowText(hCtl,szAviFn);

			hCtl = GetDlgItem(hdlg,IDC_EDIT2);
			SetWindowText(hCtl,"0");
			EnableWindow(hCtl,FALSE);

			hCmb = GetDlgItem(hdlg,IDC_COMBO1);
			SendMessage(hCmb,CB_ADDSTRING,0,(LPARAM)"RGB24");
			SendMessage(hCmb,CB_ADDSTRING,0,(LPARAM)"UYVY");
			SendMessage(hCmb,CB_ADDSTRING,0,(LPARAM)"YV12");
			SendMessage(hCmb,CB_ADDSTRING,0,(LPARAM)"NV12");
			SendMessage(hCmb,CB_SETCURSEL,0,0);

			return TRUE;


		case WM_SIZE:
			return 0;

		case WM_COMMAND:
			switch(LOWORD(wParam))
			{

				case IDC_CHECK1:
					hCtl = GetDlgItem(hdlg,IDC_CHECK1);
					recordMain = (SendMessage(hCtl,BM_GETCHECK,0,0)==BST_CHECKED) ? 1 : 0;
					return 0;
				
				case IDC_CHECK3:
					hCtl = GetDlgItem(hdlg,IDC_CHECK3);
					recordSub = (SendMessage(hCtl,BM_GETCHECK,0,0)==BST_CHECKED) ? 1 : 0;
					return 0;

				case IDOK:
					hCtl = GetDlgItem(hdlg,IDC_EDIT1);
					
					GetWindowText(hCtl,szBuffer3,12);
					if (strlen(szBuffer3))
					{
						if (szBuffer3[0] != '0')
						{
							//strcpy(szBuffer,"0x");
							//strcat(szBuffer,szBuffer3);
							strcpy(szBuffer,szBuffer3);
						} else
						{
							strcpy(szBuffer,szBuffer3);
						}
						aviRate = strtoul(szBuffer,NULL,0); 
					}
					if ((aviRate>0)&&(aviRate<=60))
					{
						EndDialog(hdlg, 0);
						windows[11].active = false;
					} else
					{
						aviRate = 30;
						MessageBox(NULL,"Enter a value from 1 to 60","Bad fps",MB_ICONERROR|MB_OK);
					}
					return TRUE;

				case IDC_BUTTON2:
					get_savefilename(szAviFn,"Save as..","AVI files (*.avi)\0*.avi\0");
					hCtl = GetDlgItem(hdlg,IDC_STATIC_FN);
					SetWindowText(hCtl,szAviFn);
					InvalidateRect(hdlg,NULL,TRUE);
					avigen.SetFileName(_T(szAviFn));
					return TRUE;
					break;

				case IDC_BUTTON_COMPRESS:
					if (!aviStreamCreated)
					{
						avi_setup();
						if (avigen.CreateStream() != AVIERR_OK)
						{
							MessageBox(NULL,"Failed to create stream","AVI recorder",MB_ICONERROR|MB_OK);
							return FALSE;
						}
						aviStreamCreated = true;
					}
					aviCodecSelected = (avigen.CodecSelect() == AVIERR_OK);
					return TRUE;

				case IDCANCEL:
				case IDCLOSE:
					EndDialog(hdlg, 1);
					windows[11].active = false;
					return FALSE;

				default:
					break;
			}
			break;
   }

	return FALSE;
}

/////////////////////////////////////////////////////////////////////////////////////////


DWORD *lpfnOldWndProc;

LRESULT CALLBACK input_proc(HWND hwnd,UINT uMsg,WPARAM wParam,LPARAM lParam)
{

	if (hwnd == hMain)
	{
		switch (uMsg)
		{
			case WM_KEYDOWN:
	/*__asm
	{
		mov ecx,wParam
		xor ebx,ebx
		div ebx
	}*/
				keys[wParam&0xFF] = 1;
				mmu_set(ZOMBIE_KEYSTATE,wParam&0xFF,1);
				switch (wParam)
				{
					case VK_F5:
						if (romLoaded)
							run = true;
						break;
					/*case VK_F6:
						if (romLoaded)
							run = false;
						break;
					case VK_F7:
						if (romLoaded)
							reset_machine(false);
						break;*/
					
					case VK_ESCAPE:
						PostMessage(hwnd, WM_CLOSE, wParam, lParam);
						break;

				}
				break;

			case WM_KEYUP:
				keys[wParam&0xFF] = 0;
				mmu_set(ZOMBIE_KEYSTATE,wParam&0xFF,0);
				break;

			//case WM_CLOSE:
			case WM_DESTROY:
				SetWindowLong(hMain, GWL_WNDPROC, (DWORD)lpfnOldWndProc);
				break;
		}
	}

	return CallWindowProc((WNDPROC)lpfnOldWndProc,hwnd,uMsg,wParam,lParam);
}



LRESULT CALLBACK wnd_proc(HWND hwnd,UINT uMsg,WPARAM wParam,LPARAM lParam)
{
	RECT rect;
	HDC dc;
	HWND hdlg;
	int i,j,k,l;
	DWORD dwTick;
	//palette_dib *pdib;
	pTransferRegion pIPC;

	if (hwnd == hMain)
	{
		switch (uMsg)
		{
			case WM_DROPFILES:
					if (romLoaded)
					{
						run = false;
						memset(cart,0,romSize);
						LocalFree((HLOCAL)cart);
						romLoaded = false;
					}
					//SendMessage(hStatus,SB_SETTEXT,1,(LPARAM)szFileNameOnly);
					DragQueryFile((HDROP)wParam,0,szFnBuffer,256);
					DragFinish((HDROP)wParam);
					cart = load_rom(szFnBuffer);
					if (cart)
					{
						//wsprintf(szBuffer,"Loaded ROM: %s",szFileNameOnly);
						//hub(TELL,ZOMBIE_DEBUG_MSG,szBuffer,0);
						romLoaded = true;
						reset_machine(true);
						//SendMessage(hStatus,SB_SETTEXT,1,(LPARAM)szFileNameOnly);
						run = true;
					} else
					{
						SendMessage(hStatus,SB_SETTEXT,1,(LPARAM)"No ROM loaded");
						run = false;
					}
					break;
				
			case WM_COMMAND:
				switch (LOWORD(wParam))
				{
					case IDM_LOAD_AND_EXEC:
						if (!get_openfilename(szFnBuffer,"Load ROM","ROM files (*.bin,*.nds)\0*.bin;*.nds\0"))
						{
							//COMMDLGERROR("OFN failed.");
							break;
						}
						if (romLoaded)
						{
							run = false;
							memset(cart,0,romSize);
							LocalFree((HLOCAL)cart);
							romLoaded = false;
						}
						SendMessage(hStatus,SB_SETTEXT,1,(LPARAM)szFileNameOnly);
						cart = load_rom(szFnBuffer);
						if (cart)
						{
							wsprintf(szBuffer,"Loaded ROM: %s",szFileNameOnly);
							hub(TELL,ZOMBIE_DEBUG_MSG,szBuffer,0);
							romLoaded = true;
							reset_machine(true);
							SendMessage(hStatus,SB_SETTEXT,1,(LPARAM)szFileNameOnly);
							run = true;
						} else
						{
							SendMessage(hStatus,SB_SETTEXT,1,(LPARAM)"No ROM loaded");
							run = false;
						}
						break;

					case IDM_LOAD:
						if (!get_openfilename(szFnBuffer,"Load ROM","ROM files (*.bin,*.nds)\0*.bin;*.nds\0"))
						{
							//COMMDLGERROR("OFN failed.");
							break;
						}
						run = false;
						if (romLoaded)
						{
							LocalFree((HLOCAL)cart);
							romLoaded = false;
						}

						SendMessage(hStatus,SB_SETTEXT,1,(LPARAM)&szFileNameOnly);
						cart = load_rom(szFnBuffer);
						if (cart)
						{
							wsprintf(szBuffer,"Loaded ROM: %s",szFileNameOnly);
							hub(TELL,ZOMBIE_DEBUG_MSG,szBuffer,0);
							romLoaded = true;
							reset_machine(true);
						} 
						break;

					case IDM_ROM_INFO:
						wsprintf(szBuffer,"Title: %s\n\nARM9 location: \t\t0x%08X\nARM9 execute from: \t0x%08X  \nARM9 copy to: \t\t0x%08X\nARM9 size: \t\t0x%08X\n\nARM7 location: \t\t0x%08X\nARM7 execute from: \t0x%08X\nARM7 copy to: \t\t0x%08X\nARM7 size: \t\t0x%08X\n",
									hdr.szGameTitle,hdr.uARM9Source,hdr.uARM9ExecuteFrom,hdr.uARM9CopyTo,hdr.uARM9Size,
									hdr.uARM7Source,hdr.uARM7ExecuteFrom,hdr.uARM7CopyTo,hdr.uARM7Size);
						MessageBox(NULL,szBuffer,"ROM info",MB_OK);
						break;


					// The reason for postponing the screenshot is to be able to get a
					// finished frame instead of a partially rendered one. If the emulator
					// is in a paused state (run==false) we already have a finished frame,
					// so we can go ahead with taking the screenshot right away.
					//
					case IDM_SCREEN_MAIN:
						if (!romLoaded)
							break;
						bmpFrameSelection = GPU_FRAMEBUFFER_MAIN_BGR24;
						if (run)
							pendingScreenshot = true;
						else
							screenshot();
						break;
					case IDM_SCREEN_SUB:
						if (!romLoaded)
							break;
						bmpFrameSelection = GPU_FRAMEBUFFER_SUB_BGR24;
						if (run)
							pendingScreenshot = true;
						else
							screenshot();
						break;
					case IDM_SCREEN_BOTH:
						if (!romLoaded)
							break;
						bmpFrameSelection = GPU_FRAMEBUFFER_BGR24;
						if (run)
							pendingScreenshot = true;
						else
							screenshot();
						break;

					case IDM_CLOSE:
						if (romLoaded)
							LocalFree((HLOCAL)cart);
						cart = NULL;
						romLoaded = false;
						run = false;
						SendMessage(hStatus,SB_SETTEXT,1,(LPARAM)"No ROM loaded");
						break;

					case IDM_EXIT:
						PostMessage(hwnd,WM_CLOSE,wParam,lParam);
						break;

					case IDM_RUN:
						if (romLoaded)
							run = true;
						break;
					case IDM_PAUSE:
						if (romLoaded && run)
							pendingPause = true;
						if (aviIsRecording)
							avi_stop_recording();
							//run = false;
						break;
					case IDM_RESET:
						if (romLoaded)
							reset_machine(false);
						break;

					case IDM_BLOCK_DMA:
						mmu_set(PLUGIN_SETTING,63,blockDMA);
						blockDMA = 1-blockDMA;
						break;

					case IDM_PALETTE:
						GetWindowRect(hwnd,&rect);
						hdlg = CreateDialog(hInst,MAKEINTRESOURCE(IDD_DIALOG10),hwnd,(DLGPROC)DlgProc10);
						windows[3].hwnd = hdlg;
						windows[3].active = true;
						SetWindowPos(hdlg,NULL,rect.left,rect.bottom+20,0,0,SWP_NOSIZE|SWP_NOZORDER);						ShowWindow(hdlg,SW_SHOW);
						ShowWindow(hdlg,SW_SHOW);
						SetForegroundWindow(hwnd);
						break;

					case IDM_DBGCON:
						GetWindowRect(hwnd,&rect);
						hdlg = CreateDialog(hInst,MAKEINTRESOURCE(IDD_DIALOG8),hwnd,(DLGPROC)DlgProc8);
						windows[4].hwnd = hdlg;
						windows[4].active = true;
						SetWindowPos(hdlg,NULL,rect.left,rect.bottom+20,0,0,SWP_NOSIZE|SWP_NOZORDER);						ShowWindow(hdlg,SW_SHOW);
						SetForegroundWindow(hwnd);
						break;

					case IDM_MEMORY:
						GetWindowRect(hwnd,&rect);
						hdlg = CreateDialog(hInst,MAKEINTRESOURCE(IDD_DIALOG7),hwnd,(DLGPROC)DlgProc7);
						windows[5].hwnd = hdlg;
						windows[5].active = true;
						SetWindowPos(hdlg,NULL,rect.left+300,rect.bottom+20,0,0,SWP_NOSIZE|SWP_NOZORDER);						ShowWindow(hdlg,SW_SHOW);
						ShowWindow(hdlg,SW_SHOW);
						SetForegroundWindow(hwnd);
						break;

					case IDM_DISASM:
						GetWindowRect(hwnd,&rect);
						hdlg = CreateDialog(hInst,MAKEINTRESOURCE(IDD_DIALOG9),hwnd,(DLGPROC)DlgProc9);
						windows[6].hwnd = hdlg;
						windows[6].active = true;
						SetWindowPos(hdlg,NULL,rect.left+300,rect.bottom+20,0,0,SWP_NOSIZE|SWP_NOZORDER);						ShowWindow(hdlg,SW_SHOW);
						ShowWindow(hdlg,SW_SHOW);
						SetForegroundWindow(hwnd);
						break;

					case IDM_IOREGS:
						GetWindowRect(hwnd,&rect);
						hdlg = CreateDialog(hInst,MAKEINTRESOURCE(IDD_DIALOG11),hwnd,(DLGPROC)DlgProc11);
						windows[7].hwnd = hdlg;
						windows[7].active = true;
						SetWindowPos(hdlg,NULL,rect.left+280,rect.top+80,0,0,SWP_NOSIZE|SWP_NOZORDER);						ShowWindow(hdlg,SW_SHOW);
						ShowWindow(hdlg,SW_SHOW);
						SetForegroundWindow(hwnd);
						break;

					case IDM_TILES:
						GetWindowRect(hwnd,&rect);
						hdlg = CreateDialog(hInst,MAKEINTRESOURCE(IDD_DIALOG12),hwnd,(DLGPROC)DlgProc12);
						windows[8].hwnd = hdlg;
						windows[8].active = true;
						SetWindowPos(hdlg,NULL,rect.left+280,rect.top+80,0,0,SWP_NOSIZE|SWP_NOZORDER);						ShowWindow(hdlg,SW_SHOW);
						ShowWindow(hdlg,SW_SHOW);
						SetForegroundWindow(hwnd);
						break;


					case IDM_MOVIE_START:
						avi_start_recording();
						if (aviIsRecording)
							SetWindowText(hMain,"Dualis [Recording]");
						break;
					case IDM_MOVIE_STOP:
						SetWindowText(hMain,"Dualis");
						if (aviIsRecording)
							avi_stop_recording();
						break;
					case IDM_MOVIE_SETUP:
						hdlg = CreateDialog(hInst,MAKEINTRESOURCE(IDD_DIALOG16),hwnd,(DLGPROC)DlgProc16);
						windows[11].hwnd = hdlg;
						windows[11].active = true;
						ShowWindow(hdlg,SW_SHOW);
						SetForegroundWindow(hwnd);

						break;

					/*case IDM_BREAKPOINTS:
						GetWindowRect(hwnd,&rect);
						hdlg = CreateDialog(hInst,MAKEINTRESOURCE(IDD_DIALOG13),hwnd,(DLGPROC)DlgProc13);
						windows[9].hwnd = hdlg;
						windows[9].active = true;
						SetWindowPos(hdlg,NULL,rect.left+120,rect.top+60,0,0,SWP_NOSIZE|SWP_NOZORDER);						ShowWindow(hdlg,SW_SHOW);
						ShowWindow(hdlg,SW_SHOW);
						SetForegroundWindow(hwnd);
						break;*/

					case IDM_ABOUT:
						DialogBoxParam(hInst,
								 MAKEINTRESOURCE(IDD_DIALOG5), hMain,
								 DlgProc5, NULL);

				}
				return 0;

			case WM_ACTIVATE:
				SendMessage(hPropsheet,uMsg,wParam,lParam);
				break;
		
			case WM_SIZE:
				center_propsheet(lParam);

				if (hStatus != NULL)
				{
					rect.left = 170;//440-100;
					rect.top = 170+180;//440;
					rect.right = -1;
					rect.bottom = -1;
	            	SendMessage(hStatus, SB_SETPARTS, 3, (LPARAM)&rect);
	            	SendMessage(hStatus, WM_SIZE, wParam, lParam);
					//SendMessage(hStatus,SB_SETTEXT,0,(LPARAM)"CPU: 0.0 MHz  GPU: 0 fps");
					//SendMessage(hStatus,SB_SETTEXT,1,(LPARAM)"No ROM loaded");

				}
				/*if (romLoaded)
					SendMessage(hStatus,SB_SETTEXT,1,(LPARAM)szFileNameOnly);
				else
					SendMessage(hStatus,SB_SETTEXT,1,(LPARAM)"No ROM loaded");
				
				if (run)
					SendMessage(hStatus,SB_SETTEXT,2,(LPARAM)"Running");
				else
					SendMessage(hStatus,SB_SETTEXT,2,(LPARAM)"Idle");*/

				break;
			
			case WM_KEYDOWN:
				//keys[wParam&0xFF] = 1;
				//mmu_set(ZOMBIE_KEYSTATE,wParam&0xFF,1);

				switch (wParam)
				{
					case VK_F5:
						if (romLoaded)
							run = true;
						break;
					case VK_F6:
						if (romLoaded && run)
							pendingPause = true;
							//run = false;
						break;
					case VK_F7:
						if (romLoaded)
							reset_machine(false);
						break;
					
					case VK_ESCAPE:
						run = false;
						PostMessage(hwnd, WM_CLOSE, wParam, lParam);
						break;

					/*case 'J':
						//start_avi();
						break;
					case 'K':
						//stop_avi();
						MessageBox(NULL,"Stopping AVI output","Message",MB_OK);
						break;
					case 'H':
						hdlg = CreateDialog(hInst,MAKEINTRESOURCE(IDD_DIALOG16),hwnd,(DLGPROC)DlgProc16);
						windows[11].hwnd = hdlg;
						windows[11].active = true;
						ShowWindow(hdlg,SW_SHOW);
						SetForegroundWindow(hwnd);
						break;*/

					/*case 'D':
						wsprintf(szBuffer,"PC = %08X\n",cpu_get(CPU_REG_PC));
						WriteConsole(hOut,szBuffer,lstrlen(szBuffer),(unsigned long*)&dwDummy,NULL);
						break;

					case 'G':
						wsprintf(szBuffer,"%04X%04x\n",mmu_read_word(0x4000002),mmu_read_word(0x4000000));
						WriteConsole(hOut,szBuffer,lstrlen(szBuffer),(unsigned long*)&dwDummy,NULL);

						//wsprintf(szBuffer,"%04x %04x\n",mmu_read_word(0x4000050),mmu_read_word(0x4000052));
						//WriteConsole(hOut,szBuffer,lstrlen(szBuffer),(unsigned long*)&dwDummy,NULL);

						wsprintf(szBuffer,"%04x %04x %04X %04X\n",mmu_read_word(0x4001008),mmu_read_word(0x400100a),
							mmu_read_word(0x400100c),mmu_read_word(0x400100e));
						WriteConsole(hOut,szBuffer,lstrlen(szBuffer),(unsigned long*)&dwDummy,NULL);

						for (i=0; i<16; i++)
						{
						wsprintf(szBuffer,"%04X ",mmu_read_word(0x7000400+(i<<1)));
						WriteConsole(hOut,szBuffer,lstrlen(szBuffer),(unsigned long*)&dwDummy,NULL);
						}
						WriteConsole(hOut,"\n",2,(LPDWORD)&i,NULL);*/
				}
				return 0;

			case WM_KEYUP:
				//keys[wParam&0xFF] = 0;
				//mmu_set(ZOMBIE_KEYSTATE,wParam&0xFF,0);
				return 0;

			case WM_TIMER:
				if (wParam == 777)
				{
					dwTick = GetTickCount();
					if (samples)
						cpuEmuSpeed *= (float)perfFreq.QuadPart/(float)(cpu_get(CPU_CYCLE_SCALING)*samples);
					else
						cpuEmuSpeed = 0.0f;
					/*wsprintf(szBuffer,"CPU: %d MHz\tGPU %d fps    ",
							(UINT)(cpuEmuSpeed/((float)(dwTick-dwTimerOf)*1000.0f)),
							(UINT)((float)frames*1000.0f / (float)(dwTick-dwTimerOf)));*/
					wsprintf(szBuffer,"CPU: %d MHz      ",
							(UINT)(cpuEmuSpeed/((float)(dwTick-dwTimerOf)*1000.0f)));
					wsprintf(&szBuffer[16],"GPU: %d fps   ",
							(UINT)((float)frames*1000.0f / (float)(dwTick-dwTimerOf)));
					SendMessage(hStatus,SB_SETTEXT,0,(LPARAM)szBuffer);
					frames = 0;
					cpuEmuSpeed = 0.0f;
					samples = 0;
					dwTimerOf = dwTick;

					/*systime.wSecond++;
					if (systime.wSecond==60)
					{
						systime.wSecond = 0;
						systime.wMinute++;
						if (systime.wMinute==60)
						{
							systime.wMinute = 0;
							systime.wHour++;
							if (systime.wHour==24)
							{
								GetLocalTime(&systime);
							}
						}
					}*/
					GetLocalTime(&systime);

					pIPC = (pTransferRegion)pageTable[0x20];

					// Update IPC time data
					if (false) //ipcLoc)
					{
						mmu_write_dword(0x237F016,((systime.wYear-1744)<<24)|(systime.wMinute<<16)|(systime.wSecond<<8)|(systime.wSecond<<0));
						mmu_write_dword(0x237F01A,(systime.wHour<<24)|(systime.wMonth<<8)|(systime.wDay)|(systime.wSecond<<16));
						//mmu_write_dword(0x237F016,0x04030201);
						//mmu_write_dword(0x237F01A,0x08070605);
					} else
					{
						if (romLoaded)
						{
							/*pIPC->year = 5;
							pIPC->month = systime.wMonth;
							pIPC->day = systime.wDay;
							pIPC->hours = systime.wHour;
							pIPC->minutes = systime.wMinute;
							pIPC->seconds = systime.wSecond;*/

							if (systime.wHour > 11) systime.wHour += 40;

							*(unsigned int*)(pageTable[0x20] + 22) = ((systime.wYear-1744)<<24)|0x070907; //((systime.wYear-1744)<<8) | (systime.wMonth<<16) | (systime.wDay<<24);
							*(unsigned int*)(pageTable[0x20] + 26) = ((systime.wHour)<<24)|(systime.wMonth)|(systime.wDay<<8); //(systime.wMonth);
							*(unsigned int*)(pageTable[0x20] + 30) = (systime.wSecond<<8)|(systime.wMinute);
							*(unsigned int*)(pageTable[0x20] + 34) = 0x08070608;
						
							if (mirrorIPC)
							{
							*(unsigned int*)(pageTable[0x23] + 0xFF01A) = ((systime.wYear-1744)<<24)|0x070907; //((systime.wYear-1744)<<8) | (systime.wMonth<<16) | (systime.wDay<<24);
							*(unsigned int*)(pageTable[0x23] + 0xFF01E) = ((systime.wHour)<<24)|(systime.wMonth)|(systime.wDay<<8); //(systime.wMonth);
							*(unsigned int*)(pageTable[0x23] + 0xFF022) = (systime.wSecond<<8)|(systime.wMinute);
							*(unsigned int*)(pageTable[0x23] + 0xFF026) = 0x08070608;
							}
							//mmu_write_dword(0x2000016,0x0E|((systime.wYear-1744)<<8)|(systime.wMonth<<16)|(systime.wDay<<24));
						//mmu_write_dword(0x200001A,0x00|(systime.wHour<<8)|(systime.wMinute<<16)|(systime.wSecond<<24));
						//mmu_write_dword(0x2000016,((systime.wYear-1744)<<24)|(systime.wMinute<<16)|(systime.wSecond<<8)|(systime.wSecond<<0));
						//mmu_write_dword(0x200001A,(systime.wHour<<24)|(systime.wMonth<<8)|(systime.wDay)|(systime.wSecond<<16));
						}
					}
					// Prevent timestamp overflows
					if (cycles >= 0x40000000)
					{
						cpu_set(CPU_CYCLE_COUNT,cycles-0x40000000,0);
						cycles = cpu_get(CPU_CYCLE_COUNT);
						for (i=0; i<eq->nItems; i++)
							eq->e[i].timestamp -= 0x40000000;

					}

					if (windows[3].active && run && (palUpdateMode==5))
						//UpdateWindow(windows[3].hwnd);
						InvalidateRect(windows[3].hwnd,NULL,FALSE);
					/*if ((windows[3].active)&&romLoaded&&run)
					{
						pdib = (palette_dib*)gpu_get(GPU_PALETTE);				
  						GetClientRect(hPalw,&rect);
	  					StretchDIBits(paldc,0,0,rect.right,rect.bottom,0,0,32,32,
									  pdib->data,(BITMAPINFO*)&pdib->bih,DIB_RGB_COLORS,SRCCOPY);

					}*/
				}
				break;

			case WM_CLOSE:
	  			run = false;
  				quit = true;
  				return 0;

			case WM_DESTROY:
 				KillTimer(hwnd,777);
	 			PostQuitMessage(0);
	  			return 0;
		}


	} else if (hwnd == hSubScr)
	{
		switch (uMsg)
		{
			case WM_KEYDOWN:
				switch (wParam)
				{
					case VK_F5:
						if (romLoaded)
							run = true;
						break;
					case VK_F6:
						if (romLoaded)
							run = false;
						break;
					case VK_F7:
						if (romLoaded)
							reset_machine(false);
						break;				
					case VK_ESCAPE:
						run = false;
						PostMessage(hwnd, WM_CLOSE, wParam, lParam);
						break;
				}
				return 0;

			case WM_MOUSEMOVE:
				touch.x = touch.y = touch.z = 0;
				if (GET_Y_LPARAM(lParam)>=192)
				{
					if (wParam & MK_LBUTTON)
					{
						touch.x = GET_X_LPARAM(lParam); //+13;
						touch.y = GET_Y_LPARAM(lParam)+16-192;
						touch.z = -1;
						if (touch.x<0) touch.x = 0; if (touch.x>255) touch.x = 255;
					} 
				}
				return 0;
			case WM_LBUTTONDOWN:
				if (GET_Y_LPARAM(lParam)>=192)
				{
					touch.x = GET_X_LPARAM(lParam); //+13;
					touch.y = GET_Y_LPARAM(lParam)+16-192;
					touch.z = -1;
					if (touch.x<0) touch.x = 0; if (touch.x>255) touch.x = 255;
					wsprintf(szBuffer,"x = %d, y = %d | ipc_x = %d, ipc_y = %d\n",
						touch.x,touch.y,touch.x*14,(touch.y*8917)>>9);
					WriteConsole(hOut,szBuffer,lstrlen(szBuffer),(LPDWORD)&i,NULL);
				}
				return 0;

			case WM_LBUTTONUP:
				touch.x = 0;
				touch.y = 0;
				touch.z = 0;
				return 0;

			case WM_CLOSE:
				SendMessage(hMain,WM_CLOSE,0,0);
				return 0;

		}

	}

	return DefWindowProc(hwnd,uMsg,wParam,lParam);
}



void idle()
{
	int i;

	SendMessage(hStatus,SB_SETTEXT,2,(LPARAM)"Idle");
	if (!romLoaded)
		SendMessage(hStatus,SB_SETTEXT,1,(LPARAM)"No ROM loaded");

	while ((!run) && (!quit))
	{
		while(PeekMessage(&msg,NULL,0,0,1))
		{
			if (!TranslateAccelerator( 
					hMain,      // handle to receiving window 
					haccel,     // handle to active accelerator table 
					&msg))      // message data 
			{
				TranslateMessage(&msg);
				DispatchMessage(&msg);
			}
		}

		// Suspend the process for a short while
		if (!quit)
			Sleep(20);
 	}
}



void shut_down()
{
	delete menu;
	delete eq;

	mmu_close();
	gpu_close();
	inp_close();

	if (aviStreamCreated) //(aviIsRecording)
		avi_stop_recording();

	FreeLibrary(hCPU);
	FreeLibrary(hMMU);
	FreeLibrary(hGPU);
	FreeLibrary(hINP);

	if (romLoaded)
		LocalFree((HLOCAL)cart);

	DestroyWindow(hSubScr);
	DestroyWindow(hStatus);
	DestroyWindow(hMain);
}



COLORREF RGB2BGR(COLORREF cref)
{
	return (cref&0x00FF00)|((cref&0xFF0000)>>16)|((cref&0x0000FF)<<16);
}




int APIENTRY WinMain(HINSTANCE hInstance,HINSTANCE hPrevInstance,LPSTR lpCmdLine,int nCmdShow)
{
	int		i,j,k;
	RECT	rect,rect3;
	HWND	hWnd;
	HMENU	hSysMenu;
	char	*szCommandline;
	static const char delimit = ' ';
	char	*token,*p1,*p2;
	char	*romName = lpCmdLine;

	hInst = hInstance;

	szPath = (char*)get_path();
	GetCurrentDirectory(256,currDir);

	eq = new CEventQueue(128);

	wsprintf(szScrFn,"%s\\dualis.bmp",szPath);
	wsprintf(szAviFn,"c:\\dualis.avi");
	avigen.SetFileName(_T(szAviFn));

	wsprintf(iniFn,"%s\\dualis.ini",szPath);
	fpsLimit = GetPrivateProfileInt("GPU","LimitFPS",1,iniFn);
	frameskip = GetPrivateProfileInt("GPU","Frameskip",0,iniFn);
	renderer = GetPrivateProfileString("GPU","Renderer","OpenGL",szBuffer,32,iniFn);
	if (strcmp("D3D",szBuffer)==0)
		renderer = 1;
	else if (strcmp("GDI",szBuffer)==0)
		renderer = 2;
	else
		renderer = 0;

	ipcFormat = GetPrivateProfileInt("IPC","DefaultIPCVersion",1,iniFn);
	tsCalibX1 = GetPrivateProfileInt("Calibration","x1",0,iniFn);
	tsCalibY1 = GetPrivateProfileInt("Calibration","y1",0,iniFn);
	tsCalibX2 = GetPrivateProfileInt("Calibration","x2",0,iniFn);
	tsCalibY2 = GetPrivateProfileInt("Calibration","y2",0,iniFn);

	openCon = false;
	
	strcpy(szBuffer,lpCmdLine);
	if (strlen(szBuffer))
	{
		token = strtok(szBuffer,&delimit);
		while (token != NULL)
		{
			if (strcmp("-theme",token)==0)
			{
				token = strtok(NULL,&delimit);
				if (token==NULL) break;
				theme = atoi(token);
			} else if (strcmp("-wincon",token)==0)
			{
				openCon = true;
			}

			token = strtok(NULL,&delimit);
		}
	}

	p1 = strchr(romName,'\"');
	if (p1==NULL) p1 = romName+10000;
	while (strchr(romName,' '))
	{
		p2=strchr(romName,' ')+1;
		if (p2>p1) break;
		romName = p2;
	}


	windows[0].active = false;
	windows[1].active = false;
	windows[2].active = false;
	windows[3].active = false;
	windows[4].active = false;
	windows[5].active = false;
	windows[6].active = false;
	hMain = NULL;

	windows[0].hwnd = hMain = create_window("Dualis","DualisClass",NULL,NULL,COLOR_MENU,440,288+16,(WNDPROC)wnd_proc);
	//windows[1].hwnd = hMainScr = create_window("Main screen","MnScrClass",NULL,NULL,COLOR_MENUTEXT,240+8,160+28,(WNDPROC)wnd_proc);
	//windows[2].hwnd = hSubScr = CreateDialog(hInst,MAKEINTRESOURCE(IDD_DIALOG14),hMain,(DLGPROC)DlgProc14); //create_window("Video output","SbScrClass",NULL,MAKEINTRESOURCE(IDI_ICON2),COLOR_MENUTEXT,240+8,160+28,(WNDPROC)wnd_proc);
	windows[2].hwnd = hSubScr = create_window("Video output","SbScrClass",NULL,MAKEINTRESOURCE(IDI_ICON2),COLOR_MENUTEXT,240+8,160+28,(WNDPROC)wnd_proc);

	windows[0].active = true;
	windows[2].active = true;

	menu = new CMenu;

	defaultFontID = (UINT)GetStockObject(ANSI_VAR_FONT);

	// Create a font
    font = CreateFont(11,0,0,0,
					FW_NORMAL,	// Specify normal font weight
    			    0,			// Italic flag
    			    0,
    			    0, 
        	        ANSI_CHARSET,
        	        OUT_OUTLINE_PRECIS,
        	        CLIP_DEFAULT_PRECIS,
        	        ANTIALIASED_QUALITY,
        	        FF_DONTCARE,
        	        "lucida console");

////////////////////////// Set up the debug console window ///////////////////////////////////


	SelectObject(dbgdc, font);
	SetBkColor(dbgdc,GetSysColor(COLOR_MENU));
	SetTextColor(dbgdc,RGB(132,32,32));

    hScrollbar1 = CreateWindowEx(0L,
                   "SCROLLBAR",
                   NULL, // There is no text to display
                   WS_CHILD | WS_VISIBLE | SBS_VERT,
                   296,
                   0,
                   16,
                   172,
                   hDbgw,
                   NULL,
                   hInst,
                   NULL);

        ZeroMemory(&si, sizeof(si));
        si.cbSize = sizeof(si);
        si.fMask  = SIF_RANGE | SIF_PAGE | SIF_POS;
        si.nMin   = 0;
        si.nMax   = 0;
        si.nPage  = 1;
        si.nPos   = 0;
        SetScrollInfo(hScrollbar1, SB_CTL, &si, TRUE);


////////////////////////////////////////////////////////////////////////////////////////////////

	InitCommonControls();

	menu->add_popup("File");
		menu->last->add_item("Load and execute..\tCtrl+R",IDM_LOAD_AND_EXEC,true);
		menu->last->add_item("Load..\tCtrl+L",IDM_LOAD,true);
		menu->last->add_item("ROM info..",IDM_ROM_INFO,false);
		menu->last->add_item("Close",IDM_CLOSE,true);
		menu->last->add_item(0,0,false);
		menu->last->add_popup("Save screenshot");
			menu->last->popup->add_item("Main screen\t1",IDM_SCREEN_MAIN,true);
			menu->last->popup->add_item("Sub screen\t2",IDM_SCREEN_SUB,true);
			menu->last->popup->add_item("Both screens\t3",IDM_SCREEN_BOTH,true);

		menu->last->add_popup("Movie");
			menu->last->popup->add_item("Start recording\t,",IDM_MOVIE_START,true);
			menu->last->popup->add_item("Stop recording\t.",IDM_MOVIE_STOP,true);
			menu->last->popup->add_item("Setup..\tCtrl+A",IDM_MOVIE_SETUP,true);

		menu->last->add_item(0,0,false);
		menu->last->add_item("Exit\tEsc",IDM_EXIT,true);

	menu->add_popup("Emulation");
		menu->last->add_item("Run\tF5",IDM_RUN,true);
		menu->last->add_item("Pause\tF6",IDM_PAUSE,true);
		menu->last->add_item("Reset\tF7",IDM_RESET,true);

	menu->add_popup("View");
		menu->last->add_item("Disassembler..\tCtrl+D",IDM_DISASM,true);
		menu->last->add_item("Memory..\tCtrl+M",IDM_MEMORY,true);
		menu->last->add_item("I/O registers..\tCtrl+I",IDM_IOREGS,true);
		menu->last->add_item("Palette..\tCtrl+P",IDM_PALETTE,true);
		menu->last->add_item("Tiles..\tCtrl+T",IDM_TILES,true);
		menu->last->add_item("Debug console..\tCtrl+C",IDM_DBGCON,true);

	menu->add_popup("Help");
		menu->last->add_item("About..",IDM_ABOUT,true);

	SetMenu(hMain,menu->hMenu);

	hPropsheet = create_propsheet();
	if(hPropsheet == INVALID_HANDLE_VALUE)
	{
		WINERROR("Property sheet creation failed.");
		ExitProcess(0);
	}

	SetWindowLong(hPropsheet, GWL_STYLE, WS_CHILD);
	SetParent(hPropsheet,hMain);
	SetWindowLong(hPropsheet, GWL_EXSTYLE, WS_EX_CONTROLPARENT);

	init_propsheet_size();

	SetTimer(hMain, 777, 1000, NULL);
	dwTimerOf = GetTickCount();

	DragAcceptFiles(hMain,TRUE);

	hStatus = CreateStatusWindow(WS_CHILD|WS_VISIBLE,"",hMain,1555);

	ShowWindow(hMain,SW_SHOW);
	ShowWindow(hSubScr,SW_SHOW);

	GetWindowRect(hMain,&rect);
	force_window_size(hSubScr,rect.right+24,rect.top,256,384);


	UpdateWindow(hSubScr);
	UpdateWindow(hMain);


    hSysMenu = GetSystemMenu(hSubScr, 0);
	EnableMenuItem(hSysMenu, SC_CLOSE, (MF_BYCOMMAND|MF_GRAYED));


	bmp_config(BMP_FLIP, BMP_DONT_FLIP);
	bmp_config(BMP_HEADER, BMP_HEADER);
	bmp_config(BMP_PALETTE, BMP_PALETTE);
	bmp_config(BMP_ALIGN, BMP_ALIGN);


	init();


	// Try to load a rom if one was specified on the commandline
	if (strlen(lpCmdLine))
	{
		// Handle quoted filenames from explorer
		if (romName[0] == '\"')
		{
			romName[strlen(romName)-1] = '\0';
			romName++;
			strcpy(szBuffer3,romName);
		}
		else if (!((strchr(romName,':')!=NULL) || (romName[0]=='\\')))
		{
			wsprintf(szBuffer3,"%s\\%s",currDir,romName);
		} else 
		{
			strcpy(szBuffer3,romName);
		}
		//MessageBox(NULL,szBuffer,"Foo",MB_OK);
		cart = load_rom(szBuffer3);
		if (cart)
		{
			SendMessage(hStatus,SB_SETTEXT,1,(LPARAM)romName);
			wsprintf(szBuffer,"Loaded ROM: %s",romName);
			hub(TELL,ZOMBIE_DEBUG_MSG,szBuffer,0);
			romLoaded = true;
			reset_machine(true);
			run = true;
		} else
		{
			SendMessage(hStatus,SB_SETTEXT,1,(LPARAM)"No ROM loaded");
			run = false;
		}
	}

	colors[0] = GetPrivateProfileInt("Colors","ColorBackground",0xFFFFFF,iniFn);
	colors[1] = GetPrivateProfileInt("Colors","ColorAddress",0x909090,iniFn);
	colors[2] = GetPrivateProfileInt("Colors","ColorMnemonic",0x0000FF,iniFn);
	colors[3] = GetPrivateProfileInt("Colors","ColorRegister",0x000090,iniFn);
	colors[4] = GetPrivateProfileInt("Colors","ColorImmediate",0x808010,iniFn);
	colors[5] = GetPrivateProfileInt("Colors","ColorComment",0x009000,iniFn);
	colors[6] = GetPrivateProfileInt("Colors","ColorBracket",0xFF0000,iniFn);
	colors[7] = GetPrivateProfileInt("Colors","ColorText",0x000000,iniFn);
	
	for (i=0; i<8; i++)
		colors[i] = RGB2BGR(colors[i]);

	haccel = LoadAccelerators(hInst,(LPCSTR)MAKEINTRESOURCE(IDR_ACCELERATOR1));

	/*lpfnOldWndProc = (DWORD*)SetWindowLong(hMain,GWL_WNDPROC,(DWORD)input_proc);
	if (lpfnOldWndProc==NULL)
	{
		WINERROR("SetWindowLong failed");
		ExitProcess(0);
	}*/

	while (!quit)
	{
		idle();
		emulate();
	}

	shut_down();

	return msg.wParam;
}
