#ifndef __beeampee_h__
#define __beeampee_h__

#include <windows.h>


#define BMP_BUFFERSIZE      51200

#define BMP_FLIP            4
#define BMP_DONT_FLIP       0
#define BMP_INVERT          5
#define BMP_DONT_INVERT     0
#define BMP_HEADER          6
#define BMP_NO_HEADER       0
#define BMP_PALETTE         7
#define BMP_NO_PALETTE      0
#define BMP_ALIGN           8
#define BMP_DONT_ALIGN      0


#define BMP_FILE_ERROR      1
#define BMP_HEADER_ERROR    2
#define BMP_BITCOUNT_ERROR  3

#define BMP_ERROR(err)      lbmp->errorcode = err; return

#define makeCol15(r,g,b) ((b>>3)|((g&248)<<2)|((r&248)<<7))
#define makeCol16(r,g,b) ((b>>3)|((g&252)<<2)|((r&248)<<8))



typedef struct
{
  unsigned char r,g,b;
}rgb_type;


typedef struct
{
 char *lpbits;
 int xdim,ydim;
 int bpp;
 int errorcode;
 rgb_type palette[256];
}loaded_bitmap;


typedef void (*copyfunc)(char *lpsrc, char *lpdest, int xdim, int ydim, int reading);


extern int bmp_save(char *, loaded_bitmap *, loaded_bitmap *);
extern void bmp_config(int, int);


#endif


