#include "beeampee.h"


loaded_bitmap		*lpBmp;
BITMAPFILEHEADER	bfh;
BITMAPINFOHEADER	bih30;
BITMAPCOREHEADER	bih20;
HANDLE				BMPfile;
char				*BMPmem;
int					bytes_per_pixel, bytes_per_row;
int					padding;
int					sizeHi;


struct
{
	int				flip;
	int				convert;
	int				invert; 
	int				header;
	int				palette;
	int				align;
} settings;


unsigned char		bitfields15[12] = {0x00,0x7C,0x00,0x00,
						               0xE0,0x03,0x00,0x00,
							           0x1F,0x00,0x00,0x00};
unsigned char		bitfields16[12] = {0x00,0xF8,0x00,0x00,
								       0xE0,0x07,0x00,0x00,
									   0x1F,0x00,0x00,0x00};




void copy(char *lpSrc, char *lpDest, int xdim, int ydim, int reading)
{
	int num_bytes, i;

	num_bytes = (xdim*bytes_per_pixel);

	for (i=0; i<ydim; i++)  
	{
		memcpy(lpDest, lpSrc, num_bytes);
		lpSrc += num_bytes;
		lpDest += num_bytes;
		if (reading)
			lpSrc += padding;
		else
			lpDest += padding;
	}
}




void copy_and_flip(char *lpSrc, char *lpDest, int xdim, int ydim, int reading)
{
	int num_bytes, i;

	num_bytes = (xdim*bytes_per_pixel);

	for (i=0; i<ydim; i++)  
	{
		memcpy(lpDest, lpSrc, num_bytes);

		if (reading)
		{
			lpDest -= num_bytes;
			lpSrc += num_bytes+padding;
		}
		else
		{
			lpSrc -= num_bytes;
			lpDest += num_bytes+padding;
		}
	}
}


void bgr_to_555(char *lpSrc, char *lpDest, int xdim, int ydim, int reading)
{
	int num_bytes,i,j;

	num_bytes = (xdim*bytes_per_pixel);

	for (i=0; i<ydim; i++)  
	{
		for (j=0; j<xdim; j++)
		{
			*(short *)lpDest = makeCol15(*(lpSrc),*(lpSrc+1),*(lpSrc+2));
			lpSrc += 3;
			lpDest += 2;
		}
 
		if (reading)
		{
			lpSrc += padding;
		}
		else
		{
			lpDest += padding;
		}
	}
}




void write_palette()
{
	char *palBuffer;
	int dstOffs = 0;
	int i;
	unsigned char col_mask = 0;

	if (settings.invert) col_mask = 255;

	palBuffer = (char*)LocalAlloc(LPTR, 1024);

	for (i=0; i<256; i++)
	{
		*(palBuffer+(dstOffs++)) = lpBmp->palette[i].b ^ col_mask;
		*(palBuffer+(dstOffs++)) = lpBmp->palette[i].g ^ col_mask;
		*(palBuffer+(dstOffs++)) = lpBmp->palette[i].r ^ col_mask;
		dstOffs++;
	}

	WriteFile(BMPfile, palBuffer, 1024, (LPDWORD)&sizeHi, NULL);
	LocalFree(palBuffer);
}



void write_bmp_as_blocks(copyfunc cFunc)
{
	char *bmpBuffer, *pekare;
	int linesToWrite, linesRemaining;

	if (settings.align == BMP_DONT_ALIGN)
	{
		bytes_per_row -= padding;
		padding = 0;
	}
 
	bmpBuffer = (char*)LocalAlloc(LPTR, BMP_BUFFERSIZE);
	if (bmpBuffer == NULL)
		return;
	
	BMPmem = bmpBuffer;
	pekare = lpBmp->lpbits;

	linesToWrite = (BMP_BUFFERSIZE/bytes_per_row);
	if (linesToWrite>bih30.biHeight)
		linesToWrite = bih30.biHeight;

	linesRemaining = bih30.biHeight;
	if (settings.flip)
		pekare += (bih30.biWidth*bytes_per_pixel*(bih30.biHeight-1));

	while (linesRemaining>0) 
	{
		cFunc(pekare, bmpBuffer, bih30.biWidth, linesToWrite, 0);
		WriteFile(BMPfile, bmpBuffer, (linesToWrite*bytes_per_row),
			      (LPDWORD)&sizeHi, NULL);
		if (settings.flip)
			pekare -= (bih30.biWidth*bytes_per_pixel*linesToWrite);
		else
			pekare += (bih30.biWidth*bytes_per_pixel*linesToWrite);

		linesRemaining -= linesToWrite;
		if (linesToWrite>linesRemaining)
			linesToWrite = linesRemaining;
	}

	LocalFree(bmpBuffer);
}



void write_8bit()
{
	padding = (bytes_per_row-bih30.biWidth);
	bytes_per_pixel = 1;
	if (settings.flip)
		write_bmp_as_blocks(copy_and_flip);
	else
		write_bmp_as_blocks(copy);
	CloseHandle(BMPfile);
}


void write_24bit()
{
	padding = (bytes_per_row - bih30.biWidth*3);
	bytes_per_pixel = 3;
	if (settings.flip)
		write_bmp_as_blocks(copy_and_flip);
	else
		write_bmp_as_blocks(copy);
	CloseHandle(BMPfile);
}


void write_24bit_as_15bit()
{
	padding = (bytes_per_row - bih30.biWidth*2);
	bytes_per_pixel = 3;
	if (settings.flip)
		write_bmp_as_blocks(copy_and_flip);
	else
		write_bmp_as_blocks(bgr_to_555);
	CloseHandle(BMPfile);
}


int bmp_save(char *fname, loaded_bitmap *srcbmp, loaded_bitmap *trgtbmp)
{

	lpBmp = srcbmp;

	if (lpBmp->lpbits == NULL)
		return 1;

	BMPfile = CreateFile(fname, GENERIC_WRITE,0,NULL,CREATE_ALWAYS,
                       FILE_ATTRIBUTE_NORMAL|FILE_FLAG_SEQUENTIAL_SCAN,NULL);
	if (BMPfile == INVALID_HANDLE_VALUE)
		return BMP_FILE_ERROR;

	bfh.bfType = 19778;
	bih30.biSize = sizeof(BITMAPINFOHEADER);
	bih30.biWidth = trgtbmp->xdim;
	bih30.biHeight = trgtbmp->ydim;
	bih30.biBitCount = trgtbmp->bpp;
	bih30.biSizeImage = (bih30.biWidth*bih30.biHeight)*((bih30.biBitCount+1)>>3);
	bih30.biPlanes = 1;
	if ((bih30.biBitCount==8)||(bih30.biBitCount==24))
		bih30.biCompression = BI_RGB;
	else
		bih30.biCompression = BI_BITFIELDS;
	bih30.biXPelsPerMeter = 72;
	bih30.biYPelsPerMeter = 72;
	bih30.biClrUsed = 0;
	bih30.biClrImportant = 0;

	bfh.bfSize = bih30.biSizeImage+54;
	bfh.bfReserved1 = 0;
	bfh.bfReserved2 = 0;
	bfh.bfOffBits = 40;

	bytes_per_row = (((bih30.biWidth*bih30.biBitCount)+31)>>5)<<2;

	if (bih30.biBitCount == 8) 
	{
		bfh.bfSize += 1024;
		bfh.bfOffBits += 1024;
	}
	else if (bih30.biBitCount == 15) 
	{
		bih30.biBitCount = 16;
		bfh.bfSize += 12;
		bfh.bfOffBits += 12;
	}
	else if (bih30.biBitCount == 16)
	{
		bfh.bfSize += 12;
		bfh.bfOffBits += 12;
	}

	if (settings.header)
	{
		WriteFile(BMPfile,&bfh,sizeof(BITMAPFILEHEADER),(LPDWORD)&sizeHi,NULL);
		WriteFile(BMPfile,&bih30,sizeof(BITMAPINFOHEADER),(LPDWORD)&sizeHi,NULL);
	}

	switch (bih30.biBitCount)
	{
		case 8:
			if (srcbmp->bpp == 8)
			{
				if (settings.palette)
					write_palette();
				write_8bit();
			} else
				return 1;
			break;

		case 15:
 			if (srcbmp->bpp == 24)
				write_24bit_as_15bit();
			else
				return 1;
			break;

		case 24:
			if (srcbmp->bpp == 24)
				write_24bit();
				//CloseHandle(BMPfile);
			else
				return 1;
			break;

		default:
			break;
  }
  return 0;
}



void bmp_config(int pname, int pvalue)
{
  switch (pname)
  {
    case BMP_FLIP:
      settings.flip = pvalue;
      break;
    case BMP_INVERT:
      settings.invert = pvalue;
      break;
    case BMP_HEADER:
      settings.header = pvalue;
      break;
    case BMP_PALETTE:
      settings.palette = pvalue;
      break;
    case BMP_ALIGN:
      settings.align = pvalue;
      break;
    default:
      break;
  }
}  
