#include "CScrollBar.h"


CScrollBar::CScrollBar()
{
	pos = 0;
	hwnd = NULL;
	ZeroMemory(&si, sizeof(SCROLLINFO));
	si.cbSize = sizeof(SCROLLINFO);
}


CScrollBar::~CScrollBar()
{
}


void CScrollBar::set_range(int min,int max)
{
	ZeroMemory(&si, sizeof(SCROLLINFO));
	si.fMask  = SIF_RANGE;
	si.nMin   = min;
	si.nMax   = max;
	SetScrollInfo(hwnd, SB_CTL, &si, TRUE);
}


void CScrollBar::set_page_size(int size)
{
	ZeroMemory(&si, sizeof(SCROLLINFO));
	si.fMask  = SIF_PAGE;
	si.nPage  = size;
	SetScrollInfo(hwnd, SB_CTL, &si, TRUE);
}


void CScrollBar::set_pos(int p)
{
	SetScrollPos(hwnd, SB_CTL, p, TRUE);
	pos = p;
}


void CScrollBar::set_tracker_pos(int p)
{
	si.nTrackPos = p;
	si.nPos = pos;
	si.fMask = SIF_POS;
	SetScrollInfo(hwnd, SB_CTL, &si, TRUE);
}


int CScrollBar::get_pos()
{
	return (pos = GetScrollPos(hwnd, SB_CTL));
}


int CScrollBar::get_tracker_pos()
{
	ZeroMemory(&si, sizeof(SCROLLINFO));
	si.fMask = SIF_TRACKPOS;

	if (GetScrollInfo(hwnd, SB_VERT, &si))
		return si.nTrackPos;
	return 0;
}
