#ifndef __STDAFX_H__
#define __STDAFX_H__

#include "zombie.h"


#define NR10	0x60
#define NR11	0x62
#define NR12	0x63
#define NR13	0x64
#define NR14	0x65
#define NR21	0x68
#define NR22	0x69
#define NR23	0x6C
#define NR24	0x6D
#define NR30	0x70
#define NR31	0x72
#define NR32	0x73
#define NR33	0x74
#define NR34	0x75
#define NR41	0x78
#define NR42	0x79
#define NR43	0x7C
#define NR44	0x7D
#define NR50	0x80
#define NR51	0x81
#define NR52	0x84

#define TM0D	0x100
#define TM0CNT	0x102
#define TM1D	0x104
#define TM1CNT	0x106
#define TM2D	0x108
#define TM2CNT	0x10A
#define TM3D	0x10C
#define TM3CNT	0x10E
#define P1		0x130
#define P1CNT	0x132
#define IE		0x210
#define IF_		0x214
#define IME		0x208

#define REG_DIVCNT		0x280
#define REG_NUMER_L		0x290
#define REG_DENOM_L		0x298
#define REG_DIVRESULT_L	0x2A0
#define REG_DIVREM_L	0x2A8
#define REG_SQRTCNT		0x2B0
#define REG_SQRTRESULT	0x2B4
#define REG_SQRTPARM	0x2B8


#define JUMP 0


#define CP_BUSY			0x8000
#define CP_DIV0			0x4000


typedef struct
{
	int sad,		// Source address
		dad,		// Destination address
		cnt_l,		// Control (low)
		cnt_h;		// Control (high)
	bool enabled;
	// Internal values
	unsigned int sad_int,dad_int,cnt_int;
}dma_channel;


typedef struct
{
	unsigned int tstart;
	unsigned short int tcurr,td,te;
	bool enabled,countup;
}timer_channel;


typedef struct
{
	mmu_write_word_callback wrh;
	mmu_read_word_callback rdh;
	mmu_write_dword_callback wrw;
	mmu_read_dword_callback rdw;
	int nPage;
	unsigned char *physaddr;
	int mask,length;
} dtcmBackup;



extern unsigned char	*ROM,*SYSROM,*IWRAM,*EXRAM,*cart,*VRAM,*IOREGS,*mmu_memory,*BIOS,
						*ITCM,*DTCM,*OBJ_VRAM,*OBJ_S_VRAM,*LCDC_VRAM,*PLT_VRAM,*PLT_S_VRAM,
						*S_VRAM,*OAM;
extern					vram_bank vramBank[9];
extern unsigned char	*vramBase[9];
extern unsigned char	*vramChunk[1024];
extern unsigned short int keys,irqFlags,irqAck,irqMask;
extern int				*arm9_regs,*arm7_regs;
extern unsigned int		*arm9_cycle,*arm7_cycle;
extern unsigned char	*DTCM, *ITCM, *arm9_pageTable[256],*arm7_pageTable[256];
extern unsigned int		dtcmBase, itcmBase;
extern dma_channel		dma[4];
extern int				blockDMA;
extern timer_channel	timer[4];
extern touchpad			*touch;
extern const unsigned char prescalar[4];
extern int				btnXY[2];
extern unsigned int		arm9_pageLength[16],arm9_pageMask[16],arm7_pageLength[16],arm7_pageMask[16];
extern int				ipc_page,ipc_x,ipc_y,ipc_z;
extern int				*arm9_pageTableAddr,*arm9_pageLengthAddr,*arm9_pageMaskAddr;
extern int				*arm7_pageTableAddr,*arm7_pageLengthAddr,*arm7_pageMaskAddr;
extern char				buffer[80];
extern HANDLE			hout;
extern int				dummy;

extern gpu_get_callback gpu_get;
extern gpu_set_callback	gpu_set;

extern void dma_setup(int,bool);
extern void timer_setup(int);
extern void remap_vram(int,int);
extern void cp_div(short int);
extern void cp_sqrt(short int);

#endif
