#ifndef __ZOMBIE_H__
#define __ZOMBIE_H__

#include <windows.h>

#define	ASK 0L
#define TELL 1L

#define INPUT 0
#define OUTPUT 1


#define PALETTE_OFFSET		0xA4000
#define IOREGS_OFFSET		0xA5000
#define SPRITE_TABLE_OFFSET	0xA7000
#define BG2X_DIRTY			0x03000
#define BG3X_DIRTY			0x03004


#define CPU_IRQ_CALLBACK		0x000
#define CPU_IO_HANDLER			0x001
#define CPU_CYCLE_COUNT			0x002
#define CPU_REG_PC				0x003
#define CPU_REG_SP				0x004
#define CPU_BREAKPOINT			0x005
#define CPU_SPEED				0x006
#define CPU_INPB_CALLBACK		0x007
#define CPU_OUTPB_CALLBACK		0x008
#define CPU_CYCLE_SCALING		0x009

#define MMU_READ_BYTE_CALLBACK	0x100
#define MMU_READ_WORD_CALLBACK	0x101
#define MMU_WRITE_BYTE_CALLBACK	0x102
#define MMU_WRITE_WORD_CALLBACK	0x103
#define MMU_TRANSLATE_ADDRESS_CALLBACK	0x104
#define MMU_MAP_PORT			0x105
#define MMU_READ_DWORD_CALLBACK	0x106
#define MMU_WRITE_DWORD_CALLBACK 0x107
#define MMU_MAP_MEMORY			0x108
#define MMU_GET_CALLBACK		0x109
#define MMU_IRQ_CALLBACK		0x10A
#define MMU_IRQ					0x116
#define MMU_IRQ_OK				0x118
#define MMU_VRAM_BANKS			0x11A

#define GPU_CURRENT_SCANLINE	0x200
#define GPU_SCREEN_WIDTH		0x201
#define GPU_SCREEN_HEIGHT		0x202
#define GPU_FRAME_COMPLETED		0x203
#define GPU_VBLANK_LINES		0x204
#define GPU_HBLANK_PIXELS		0x205
#define GPU_MEMORY				0x206
#define GPU_NUMBER_COLORS		0x207
#define GPU_PALETTE				0x208
#define GPU_VBLANK_ACTION		0x209
#define GPU_HBLANK_ACTION		0x20A
#define GPU_SIZE_MULTIPLIER		0x20B
#define GPU_FRAME_RATE			0x20C
#define GPU_3D_COMMAND			0x20E
#define GPU_RENDERER_OK			0x210
#define GPU_FRAMEBUFFER_BGR24	0x220
#define GPU_FRAMEBUFFER_MAIN_BGR24	0x221
#define GPU_FRAMEBUFFER_SUB_BGR24	0x222

#define	ZOMBIE_WINDOW_HANDLE	0x500
#define ZOMBIE_ROM_BASE			0x501
#define ZOMBIE_KEYSTATE			0x502
#define ZOMBIE_HALT				0x508
#define ZOMBIE_DEBUG_MSG		0x511
#define ZOMBIE_LOG_EVENT		0x512

#define PLUGIN_NAME				0x600
#define LAST_ERROR				0x601
#define PLUGIN_SETTING			0x602

typedef struct
{
	char *data;
	BITMAPINFOHEADER bih;
	RGBQUAD colors[256];
} palette_dib;



#define MAIN_BG			0
#define SUB_BG			1
#define MAIN_OBJ		2
#define SUB_OBJ			3
#define MAIN_BGEXTPLTT	4
#define SUB_BGEXTPLTT	5
#define MAIN_OBJEXTPLTT	6
#define SUB_OBJEXTPLTT	7
#define TEX0			8
#define TEX1			9
#define TEX2			10
#define TEX3			11
#define TEXPLTT			12
#define ARM7			13
#define LCDC			14
#define DISABLED		15

typedef struct
{
	int base;	// 0..0x3FF
	int size;	// 16kB blocks
	int type;
} vram_bank;


typedef void(__stdcall *cpu_irq_callback)(int);
typedef void(__stdcall *cpu_set_io_handler_callback)(int,int,void*);
typedef int(__stdcall *cpu_inpb_callback)(int);
typedef void(__stdcall *cpu_outpb_callback)(int,int);
typedef short int(__stdcall *mmu_read_word_callback)(int);
typedef int(__stdcall *mmu_get_callback)(int);
typedef void(__stdcall *mmu_irq_callback)(int);
typedef void*(__stdcall *zombie_callback)(int,int,void*,void*);

#endif
