#include "d3dsetup.h"


IDirect3D8 *lpD3D;
IDirect3DDevice8 *lpD3DDevice;
D3DDISPLAYMODE d3ddm;
D3DPRESENT_PARAMETERS d3dpp;


bool create_d3d_device(HWND owner,int width,int height,int pixfmt,bool fullscreen)
{
	RECT clientRect;

	CoInitialize(NULL);
	
	if ((lpD3D=Direct3DCreate8(D3D_SDK_VERSION))==NULL)
		return false;


	memset(&d3ddm,0,sizeof(D3DDISPLAYMODE));
  

	if (lpD3D->GetAdapterDisplayMode(D3DADAPTER_DEFAULT,&d3ddm) < 0)
		return false;		
	
	memset(&d3dpp,0,sizeof(D3DPRESENT_PARAMETERS));
	d3dpp.BackBufferFormat = d3ddm.Format;
	d3dpp.BackBufferCount = 1;
	d3dpp.hDeviceWindow = owner;


//	.if fullscreen == 0
	d3dpp.Windowed = TRUE;
	GetClientRect(owner,&clientRect);
	d3dpp.BackBufferWidth = clientRect.right - clientRect.left;
	d3dpp.BackBufferHeight = clientRect.bottom - clientRect.top;
	
	d3dpp.SwapEffect = D3DSWAPEFFECT_COPY;	

	// Select the best depth buffer, select 32, 24 or 16 bit
	d3dpp.EnableAutoDepthStencil = FALSE;
	
	if (lpD3D->CheckDeviceFormat(D3DADAPTER_DEFAULT, D3DDEVTYPE_HAL, d3ddm.Format,
		                         D3DUSAGE_DEPTHSTENCIL,D3DRTYPE_SURFACE,D3DFMT_D32) == NULL)
	{
		d3dpp.AutoDepthStencilFormat = D3DFMT_D32;
		d3dpp.EnableAutoDepthStencil = TRUE;
	} else
	{
		if (lpD3D->CheckDeviceFormat(D3DADAPTER_DEFAULT, D3DDEVTYPE_HAL, d3ddm.Format,
			                         D3DUSAGE_DEPTHSTENCIL,D3DRTYPE_SURFACE,D3DFMT_D24X8) == NULL)
		{
			d3dpp.AutoDepthStencilFormat = D3DFMT_D24X8;
			d3dpp.EnableAutoDepthStencil = TRUE;
		} else
		{
			if (lpD3D->CheckDeviceFormat(D3DADAPTER_DEFAULT, D3DDEVTYPE_HAL, d3ddm.Format,
				                         D3DUSAGE_DEPTHSTENCIL,D3DRTYPE_SURFACE,D3DFMT_D16) == NULL)
			{
				d3dpp.AutoDepthStencilFormat = D3DFMT_D16;
				d3dpp.EnableAutoDepthStencil = TRUE;
			}
		}
	}

   	//Create a Direct3D device.
    if (lpD3D->CreateDevice(D3DADAPTER_DEFAULT, D3DDEVTYPE_HAL, owner, D3DCREATE_HARDWARE_VERTEXPROCESSING, &d3dpp, &lpD3DDevice) < 0)
	if (lpD3D->CreateDevice(D3DADAPTER_DEFAULT, D3DDEVTYPE_HAL, owner, D3DCREATE_SOFTWARE_VERTEXPROCESSING, &d3dpp, &lpD3DDevice) < 0)
		return false;
	
	return true;
}


void destroy_d3d_device()
{
	if (lpD3DDevice != NULL)
	{
		lpD3DDevice->Release();
		lpD3DDevice = NULL;
	}

	if (lpD3D != NULL)
	{
		lpD3D->Release();
		lpD3D = NULL;
	}

	CoUninitialize();
}


