#include "CMatrixStack.h"


CMatrixStack::CMatrixStack(int n)
{
	m = new t_matrix_4x4[n];
	max = n;
	pos = n;
	depth = 0;
	underflow = overflow = false;
}


CMatrixStack::~CMatrixStack()
{
	delete [] m;
}


void CMatrixStack::flush()
{
	depth = 0;
	pos = max;
	underflow = overflow = false;
}


void CMatrixStack::store(t_matrix_4x4 *curr,int n)
{
	n &= (max-1);
	//memcpy(curr,&m[n],sizeof(t_matrix_4x4));
	memcpy(&m[n],curr,sizeof(t_matrix_4x4));
}


void CMatrixStack::restore(t_matrix_4x4 *curr,int n)
{
	n &= (max-1);
	//memcpy(&m[n],curr,sizeof(t_matrix_4x4));
	memcpy(curr,&m[n],sizeof(t_matrix_4x4));
}


void CMatrixStack::pop(t_matrix_4x4 *curr,int n)
{
	int i;

	underflow = false;
	for (i=0; i<n; i++)
	{
		if (pos<max)
		{
			memcpy(curr,&m[pos],sizeof(t_matrix_4x4));
			pos++;
			depth--;
		} else
		{
			underflow = true;
			break;
		}
	}
}	

void CMatrixStack::push(t_matrix_4x4 *curr)
{
	if (pos>0)
	{
		pos--;
		depth++;
		memcpy(&m[pos],curr,sizeof(t_matrix_4x4));
		overflow = false;
	} else
		overflow = true;
}
